/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutAsProjectOperation
extends SVNOperation {
    private ISVNRemoteFolder[] remoteFolders;
    private IProject[] localFolders;
    private IPath projectRoot;
    private SVNRevision svnRevision = SVNRevision.HEAD;

    public CheckoutAsProjectOperation(IWorkbenchPart part, ISVNRemoteFolder[] remoteFolders, IProject[] localFolders) {
        this(part, remoteFolders, localFolders, null);
    }

    public CheckoutAsProjectOperation(IWorkbenchPart part, ISVNRemoteFolder[] remoteFolders, IProject[] localFolders, IPath projectRoot) {
        super(part);
        this.remoteFolders = remoteFolders;
        this.localFolders = localFolders;
        this.projectRoot = projectRoot;
    }

    protected String getTaskName() {
        return Policy.bind("CheckoutAsProjectOperation.taskName");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, this.remoteFolders.length * 1000);
        int i = 0;
        while (i < this.remoteFolders.length) {
            Object var7_7;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            ISchedulingRule rule = this.localFolders[i].getWorkspace().getRuleFactory().modifyRule((IResource)this.localFolders[i]);
            try {
                Job.getJobManager().beginRule(rule, monitor);
                monitor.setTaskName(Policy.bind("CheckoutAsProjectOperation.0", this.remoteFolders[i].getName()));
                IProject[] local = new IProject[]{this.localFolders[i]};
                ISVNRemoteFolder[] remote = new ISVNRemoteFolder[]{this.remoteFolders[i]};
                this.execute(remote, local, (IProgressMonitor)subMonitor);
            }
            catch (Throwable throwable) {
                var7_7 = null;
                Job.getJobManager().endRule(rule);
                throw throwable;
            }
            {
                var7_7 = null;
            }
            Job.getJobManager().endRule(rule);
            ++i;
        }
        return;
    }

    protected void execute(ISVNRemoteFolder[] remote, IProject[] local, IProgressMonitor monitor) throws SVNException, InterruptedException {
        try {
            CheckoutCommand command = this.projectRoot == null ? new CheckoutCommand(remote, local) : new CheckoutCommand(remote, local, this.projectRoot);
            command.setSvnRevision(this.svnRevision);
            command.run(monitor);
        }
        catch (SVNException e) {
            this.collectStatus(e.getStatus());
        }
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }
}

