/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.symbols;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.symbols.Location;
import org.rubypeople.rdt.internal.core.symbols.SearchResult;
import org.rubypeople.rdt.internal.core.symbols.Symbol;

public class SymbolIndex
implements ISymbolFinder {
    private Map index = Collections.synchronizedMap(new HashMap());
    private static boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Symbol symbol, Location location) {
        if (verbose) {
            SymbolIndex.log("Adding " + symbol + " at " + location);
        }
        Map map = this.index;
        synchronized (map) {
            HashSet<Location> hashSet = (HashSet<Location>)this.index.get(symbol);
            if (hashSet == null) {
                hashSet = new HashSet<Location>();
                this.index.put(symbol, hashSet);
            }
            hashSet.add(location);
        }
    }

    public void add(Symbol symbol, IFile iFile, ISourcePosition iSourcePosition) {
        this.add(symbol, new Location(iFile, iSourcePosition));
    }

    public Set find(Symbol symbol) {
        Set set = (Set)this.index.get(symbol);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }

    public Set find(String string, int n) throws PatternSyntaxException {
        Pattern pattern = Pattern.compile(string);
        HashSet<SearchResult> hashSet = new HashSet<SearchResult>();
        Iterator iterator = this.index.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Symbol symbol = (Symbol)entry.getKey();
            if (symbol.getType() != n || !pattern.matcher(symbol.getName()).find()) continue;
            Set set = (Set)entry.getValue();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Location location = (Location)iterator2.next();
                hashSet.add(new SearchResult(symbol, location));
            }
        }
        return hashSet;
    }

    public void flush(IFile iFile) {
        if (verbose) {
            SymbolIndex.log("Flushing all Symbols with path: " + iFile.getFullPath());
        }
        this.flush(new PathEqualsPredicate(iFile));
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    private static boolean isVerbose() {
        return verbose;
    }

    private static void log(String string) {
        if (!SymbolIndex.isVerbose()) {
            return;
        }
        System.out.println(string);
    }

    public void flush(IProject iProject) {
        if (verbose) {
            SymbolIndex.log("Flushing all Symbols for project: " + iProject.getName());
        }
        this.flush(new ContainedByProject(iProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(Predicate predicate) {
        Map map = this.index;
        synchronized (map) {
            Iterator iterator = this.index.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Set set = (Set)entry.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Location location = (Location)iterator2.next();
                    if (!predicate.evaluate(location.getSourceFile())) continue;
                    iterator2.remove();
                    if (!verbose) continue;
                    SymbolIndex.log("Removing " + location);
                }
                if (!set.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private static class PathEqualsPredicate
    implements Predicate {
        private final IFile fileToFlush;

        public PathEqualsPredicate(IFile iFile) {
            this.fileToFlush = iFile;
        }

        public boolean evaluate(Object object) {
            return object.equals(this.fileToFlush);
        }
    }

    static interface Predicate {
        public boolean evaluate(Object var1);
    }

    private static class ContainedByProject
    implements Predicate {
        private final IProject project;

        public ContainedByProject(IProject iProject) {
            this.project = iProject;
        }

        public boolean evaluate(Object object) {
            IFile iFile = (IFile)object;
            return iFile.getProject().equals((Object)this.project);
        }
    }
}

