/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.util.Arrays;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.rubypeople.rdt.internal.ui.text.Symbols;

public class RubyHeuristicScanner
implements Symbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private IDocument fDocument;
    private String fPartitioning;
    private String fPartition;
    private char fChar;
    private int fPos;
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdent = new NonRubyIdentifierPartDefaultPartition();

    public RubyHeuristicScanner(IDocument iDocument, String string, String string2) {
        Assert.isNotNull((Object)iDocument);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.fDocument = iDocument;
        this.fPartitioning = string;
        this.fPartition = string2;
    }

    public RubyHeuristicScanner(IDocument iDocument) {
        this(iDocument, "___ruby_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int n, int n2) {
        int n3 = this.scanForward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3;
            int n5 = (n3 = this.scanForward(n3 + 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? this.fDocument.getLength() : n2) : n3;
            try {
                string = this.fDocument.get(n4, n5 - n4);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    public int previousToken(int n, int n2) {
        int n3 = this.scanBackward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3 + 1;
            int n5 = (n3 = this.scanBackward(n3 - 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? 0 : n2 + 1) : n3 + 1;
            try {
                string = this.fDocument.get(n5, n4 - n5);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    private int getToken(String string) {
        Assert.isNotNull((Object)string);
        switch (string.length()) {
            case 2: {
                if ("if".equals(string)) {
                    return 109;
                }
                if (!"do".equals(string)) break;
                return 1010;
            }
            case 3: {
                if (!"for".equals(string)) break;
                return 1011;
            }
            case 4: {
                if ("case".equals(string)) {
                    return 1014;
                }
                if (!"else".equals(string)) break;
                return 1015;
            }
            case 5: {
                if ("break".equals(string)) {
                    return 1016;
                }
                if ("class".equals(string)) {
                    return 1026;
                }
                if (!"while".equals(string)) break;
                return 1018;
            }
            case 6: {
                if ("return".equals(string)) {
                    return 1019;
                }
                if ("switch".equals(string)) {
                    return 1020;
                }
                if ("module".equals(string)) {
                    return 1027;
                }
                if (!"unless".equals(string)) break;
                return 1021;
            }
        }
        return 2000;
    }

    public int findClosingPeer(int n, char c, char c2) {
        Assert.isNotNull((Object)this.fDocument);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        try {
            int n2 = 1;
            --n;
            do {
                if ((n = this.scanForward(n + 1, -2, new CharacterMatch(new char[]{c, c2}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c) {
                    ++n2;
                    continue;
                }
                --n2;
            } while (n2 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int findOpeningPeer(int n, char c, char c2) {
        Assert.isTrue((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            int n2 = 1;
            ++n;
            do {
                if ((n = this.scanBackward(n - 1, -2, new CharacterMatch(new char[]{c, c2}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c2) {
                    ++n2;
                    continue;
                }
                --n2;
            } while (n2 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findSurroundingBlock(int n) {
        if (n < 1 || n >= this.fDocument.getLength()) {
            return null;
        }
        int n2 = this.findOpeningPeer(n - 1, '{', '}');
        int n3 = this.findClosingPeer(n, '{', '}');
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return new Region(n2, n3 + 1 - n2);
    }

    public int findNonWhitespaceForward(int n, int n2) {
        return this.scanForward(n, n2, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int n, int n2) {
        return this.scanForward(n, n2, fNonWS);
    }

    public int findNonWhitespaceBackward(int n, int n2) {
        return this.scanBackward(n, n2, this.fNonWSDefaultPart);
    }

    public int scanForward(int n, int n2, StopCondition stopCondition) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        if (n2 == -2) {
            n2 = this.fDocument.getLength();
        }
        Assert.isTrue((n2 <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos < n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                ++this.fPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int n, int n2, char c) {
        return this.scanForward(n, n2, new CharacterMatch(c));
    }

    public int scanForward(int n, int n2, char[] cArray) {
        return this.scanForward(n, n2, new CharacterMatch(cArray));
    }

    public int scanBackward(int n, int n2, StopCondition stopCondition) {
        if (n2 == -2) {
            n2 = -1;
        }
        Assert.isTrue((n2 >= -1 ? 1 : 0) != 0);
        Assert.isTrue((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos > n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                --this.fPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int n, int n2, char c) {
        return this.scanBackward(n, n2, new CharacterMatch(c));
    }

    public int scanBackward(int n, int n2, char[] cArray) {
        return this.scanBackward(n, n2, new CharacterMatch(cArray));
    }

    public boolean isDefaultPartition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)n, (boolean)false);
            return iTypedRegion.getType().equals(this.fPartition);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public boolean isBracelessBlockStart(int n, int n2) {
        if (n < 1) {
            return false;
        }
        switch (this.previousToken(n, n2)) {
            case 1010: 
            case 1015: {
                return true;
            }
            case 6: {
                n = this.findOpeningPeer(this.fPos, '(', ')');
                if (n <= 0) break;
                switch (this.previousToken(n - 1, n2)) {
                    case 109: 
                    case 1011: 
                    case 1018: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static interface StopCondition {
        public boolean stop(char var1, int var2, boolean var3);
    }

    private static class NonWhitespace
    implements StopCondition {
        NonWhitespace() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return !Character.isWhitespace(c);
        }
    }

    private class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        NonWhitespaceDefaultPartition() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) && RubyHeuristicScanner.this.isDefaultPartition(n);
        }
    }

    private static class NonRubyIdentifierPart
    implements StopCondition {
        NonRubyIdentifierPart() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return !Character.isJavaIdentifierPart(c);
        }
    }

    private class NonRubyIdentifierPartDefaultPartition
    extends NonRubyIdentifierPart {
        NonRubyIdentifierPartDefaultPartition() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) || !RubyHeuristicScanner.this.isDefaultPartition(n);
        }
    }

    private class CharacterMatch
    implements StopCondition {
        private final char[] fChars;

        public CharacterMatch(char c) {
            this(new char[]{c});
        }

        public CharacterMatch(char[] cArray) {
            Assert.isNotNull((Object)cArray);
            Assert.isTrue((cArray.length > 0 ? 1 : 0) != 0);
            this.fChars = cArray;
            Arrays.sort(cArray);
        }

        public boolean stop(char c, int n, boolean bl) {
            return Arrays.binarySearch(this.fChars, c) >= 0 && RubyHeuristicScanner.this.isDefaultPartition(n);
        }
    }

    protected class SkippingScopeMatch
    extends CharacterMatch {
        private char fOpening;
        private char fClosing;
        private int fDepth;

        public SkippingScopeMatch(char c) {
            super(c);
            this.fDepth = 0;
        }

        public SkippingScopeMatch(char[] cArray) {
            super(cArray);
            this.fDepth = 0;
        }

        public boolean stop(char c, int n, boolean bl) {
            if (this.fDepth == 0 && super.stop(c, n, true)) {
                return true;
            }
            if (c == this.fOpening) {
                ++this.fDepth;
            } else if (c == this.fClosing) {
                --this.fDepth;
                if (this.fDepth == 0) {
                    this.fOpening = '\u0000';
                    this.fClosing = '\u0000';
                }
            } else if (this.fDepth == 0) {
                this.fDepth = 1;
                if (bl) {
                    switch (c) {
                        case '{': {
                            this.fOpening = (char)123;
                            this.fClosing = (char)125;
                            break;
                        }
                        case '(': {
                            this.fOpening = (char)40;
                            this.fClosing = (char)41;
                            break;
                        }
                        case '[': {
                            this.fOpening = (char)91;
                            this.fClosing = (char)93;
                        }
                    }
                } else {
                    switch (c) {
                        case '}': {
                            this.fOpening = (char)125;
                            this.fClosing = (char)123;
                            break;
                        }
                        case ')': {
                            this.fOpening = (char)41;
                            this.fClosing = (char)40;
                            break;
                        }
                        case ']': {
                            this.fOpening = (char)93;
                            this.fClosing = (char)91;
                        }
                    }
                }
            }
            return false;
        }
    }
}

