/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.Separator;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_METHOD_PARAMETER_NAMES = "org.rubypeople.rdt.ui.methodparameternames";
    private static final String STACK_BROWSING_VIEWS_VERTICALLY = "org.rubypeople.rdt.ui.browsing.stackVertically";
    private SelectionButtonDialogField fStackBrowsingViewsVertically;
    private SelectionButtonDialogField fShowMethodParameterNames;

    public AppearancePreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.AppearancePreferencePage_description);
        IDialogFieldListener iDialogFieldListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                AppearancePreferencePage.this.doDialogFieldChanged(dialogField);
            }
        };
        this.fShowMethodParameterNames = new SelectionButtonDialogField(32);
        this.fShowMethodParameterNames.setDialogFieldListener(iDialogFieldListener);
        this.fShowMethodParameterNames.setLabelText(PreferencesMessages.AppearancePreferencePage_methodtypeparams_label);
        this.fStackBrowsingViewsVertically = new SelectionButtonDialogField(32);
        this.fStackBrowsingViewsVertically.setDialogFieldListener(iDialogFieldListener);
        this.fStackBrowsingViewsVertically.setLabelText(PreferencesMessages.AppearancePreferencePage_stackViewsVerticallyInTheRubyBrowsingPerspective);
    }

    private void initFields() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fShowMethodParameterNames.setSelection(iPreferenceStore.getBoolean(PREF_METHOD_PARAMETER_NAMES));
        this.fStackBrowsingViewsVertically.setSelection(iPreferenceStore.getBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.rubypeople.rdt.ui.appearance_preference_page_context");
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        int n = 1;
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.fShowMethodParameterNames.doFillIntoGrid(composite2, n);
        new Separator().doFillIntoGrid(composite2, n);
        this.fStackBrowsingViewsVertically.doFillIntoGrid(composite2, n);
        String string = PreferencesMessages.AppearancePreferencePage_note;
        String string2 = PreferencesMessages.AppearancePreferencePage_preferenceOnlyEffectiveForNewPerspectives;
        Composite composite3 = this.createNoteComposite(JFaceResources.getDialogFont(), composite2, string, string2);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.initFields();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doDialogFieldChanged(DialogField dialogField) {
        this.updateStatus(this.getValidationStatus());
    }

    private IStatus getValidationStatus() {
        return new StatusInfo();
    }

    private void updateStatus(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue(PREF_METHOD_PARAMETER_NAMES, this.fShowMethodParameterNames.isSelected());
        iPreferenceStore.setValue(STACK_BROWSING_VIEWS_VERTICALLY, this.fStackBrowsingViewsVertically.isSelected());
        RubyPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fShowMethodParameterNames.setSelection(iPreferenceStore.getDefaultBoolean(PREF_METHOD_PARAMETER_NAMES));
        this.fStackBrowsingViewsVertically.setSelection(iPreferenceStore.getDefaultBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
        super.performDefaults();
    }
}

