/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import java.util.ArrayList;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;

public class FramesReader
extends XmlStreamReader {
    private RubyThread thread;
    int index = 1;
    private ArrayList frames;

    public FramesReader(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    public FramesReader(AbstractReadStrategy abstractReadStrategy) {
        super(abstractReadStrategy);
    }

    public RubyStackFrame[] readFrames(RubyThread rubyThread) {
        this.thread = rubyThread;
        this.frames = new ArrayList();
        try {
            this.read();
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
            return new RubyStackFrame[0];
        }
        RubyStackFrame[] rubyStackFrameArray = new RubyStackFrame[this.frames.size()];
        this.frames.toArray(rubyStackFrameArray);
        rubyThread.setStackFrames(rubyStackFrameArray);
        return rubyStackFrameArray;
    }

    protected boolean processStartElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        if (string.equals("frames")) {
            return true;
        }
        if (string.equals("frame")) {
            int n = Integer.parseInt(xmlPullParser.getAttributeValue("", "line"));
            String string2 = xmlPullParser.getAttributeValue("", "file");
            this.frames.add(new RubyStackFrame(this.thread, string2, n, this.index++));
            return true;
        }
        return false;
    }

    protected boolean processEndElement(XmlPullParser xmlPullParser) {
        return xmlPullParser.getName().equals("frames");
    }
}

