/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathContainer;
import org.jayasoft.ivyde.eclipse.ui.core.IvyFileEditorInput;
import org.jayasoft.ivyde.eclipse.ui.editors.pages.OverviewFormPage;
import org.jayasoft.ivyde.eclipse.ui.editors.xml.XMLEditor;

public class IvyEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String ID = "org.jayasoft.ivyde.editors.IvyEditor";
    private XMLEditor xmlEditor;
    private Browser _browser;

    public IvyEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void setInput(IEditorInput input) {
        IvyFileEditorInput ivyFileEditorInput = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput cfr_ignored_0 = (FileEditorInput)input;
            IFile file = ((FileEditorInput)input).getFile();
            ivyFileEditorInput = new IvyFileEditorInput(file);
        } else if (input instanceof IvyFileEditorInput) {
            ivyFileEditorInput = (IvyFileEditorInput)input;
        }
        super.setInput((IEditorInput)ivyFileEditorInput);
        if (ivyFileEditorInput.getFile() != null && this.xmlEditor != null) {
            this.xmlEditor.setFile(ivyFileEditorInput.getFile());
        }
        this.setTitle(ivyFileEditorInput.getFile().getName());
    }

    void createPageXML() {
        try {
            this.xmlEditor = new XMLEditor();
            this.xmlEditor.setFile(((IvyFileEditorInput)this.getEditorInput()).getFile());
            int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            this.setPageText(index, this.xmlEditor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPageOverView() {
        try {
            int index = this.addPage((IFormPage)new OverviewFormPage(this));
            this.setPageText(index, "Information");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void createPagePreview() {
        this._browser = new Browser(this.getContainer(), 0);
        this._browser.setUrl(((IvyFileEditorInput)this.getEditorInput()).getPath().toOSString());
        int index = this.addPage((Control)this._browser);
        this.setPageText(index, "Preview");
    }

    protected void addPages() {
        this.createPageXML();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.xmlEditor.doSave(monitor);
        IFile file = ((IvyFileEditorInput)this.getEditorInput()).getFile();
        IvyClasspathContainer.resolveIfNeeded(file);
    }

    public void doSaveAs() {
        this.xmlEditor.doSaveAs();
        this.setPageText(0, this.xmlEditor.getTitle());
        this.setInput(this.xmlEditor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return this.xmlEditor.isSaveAsAllowed();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this._browser.refresh();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            final IResource res = event.getResource();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = IvyEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)IvyEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)res)) {
                            IEditorPart editorPart = pages[i].findEditor(IvyEditor.this.xmlEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

