/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;

public class DefaultAuthorizationMap
extends DestinationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;
    private TempDestinationAuthorizationEntry tempDestinationAuthorizationEntry;

    public DefaultAuthorizationMap() {
    }

    public DefaultAuthorizationMap(List<DestinationMapEntry> authorizationEntries) {
        this.setAuthorizationEntries(authorizationEntries);
    }

    public void setTempDestinationAuthorizationEntry(TempDestinationAuthorizationEntry tempDestinationAuthorizationEntry) {
        this.tempDestinationAuthorizationEntry = tempDestinationAuthorizationEntry;
    }

    public TempDestinationAuthorizationEntry getTempDestinationAuthorizationEntry() {
        return this.tempDestinationAuthorizationEntry;
    }

    public Set<Object> getTempDestinationAdminACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getAdminACLs();
        }
        return null;
    }

    public Set<Object> getTempDestinationReadACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getReadACLs();
        }
        return null;
    }

    public Set<Object> getTempDestinationWriteACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getWriteACLs();
        }
        return null;
    }

    public Set<Object> getAdminACLs(ActiveMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getAdminACLs());
        }
        return answer;
    }

    public Set<Object> getReadACLs(ActiveMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getReadACLs());
        }
        return answer;
    }

    public Set<Object> getWriteACLs(ActiveMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getWriteACLs());
        }
        return answer;
    }

    public AuthorizationEntry getEntryFor(ActiveMQDestination destination) {
        AuthorizationEntry answer = (AuthorizationEntry)((Object)this.chooseValue(destination));
        if (answer == null) {
            answer = this.getDefaultEntry();
        }
        return answer;
    }

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination childDestination;
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            Set answer = null;
            for (int i = 0; i < destinations.length && (answer = DefaultAuthorizationMap.union(answer, (Set)this.get(childDestination = destinations[i]))) != null && !answer.isEmpty(); ++i) {
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public void setAuthorizationEntries(List<DestinationMapEntry> entries) {
        super.setEntries(entries);
    }

    public AuthorizationEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(AuthorizationEntry defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    protected Class<? extends DestinationMapEntry> getEntryClass() {
        return AuthorizationEntry.class;
    }

    protected Set<AuthorizationEntry> getAllEntries(ActiveMQDestination destination) {
        Set entries = this.get(destination);
        if (this.defaultEntry != null) {
            entries.add(this.defaultEntry);
        }
        return entries;
    }
}

