/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.util.KeyValueHolder;

public class InstrumentationInterceptStrategy
implements InterceptStrategy {
    private Map<ProcessorDefinition<?>, PerformanceCounter> registeredCounters;
    private final Map<Processor, KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor>> wrappedProcessors;

    public InstrumentationInterceptStrategy(Map<ProcessorDefinition<?>, PerformanceCounter> registeredCounters, Map<Processor, KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor>> wrappedProcessors) {
        this.registeredCounters = registeredCounters;
        this.wrappedProcessors = wrappedProcessors;
    }

    @Override
    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        if (target instanceof InstrumentationProcessor) {
            return target;
        }
        PerformanceCounter counter = this.registeredCounters.get(definition);
        if (counter != null) {
            InstrumentationProcessor wrapper = new InstrumentationProcessor(counter);
            wrapper.setProcessor(target);
            wrapper.setType(definition.getShortName());
            KeyValueHolder holder = new KeyValueHolder(definition, wrapper);
            this.wrappedProcessors.put(target, holder);
            return wrapper;
        }
        return target;
    }

    public String toString() {
        return "InstrumentProcessor";
    }
}

