/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring3.xml.encryption;

import org.jasypt.spring3.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.jasypt.util.password.StrongPasswordEncryptor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UtilDigesterBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_CONFIG_BEAN = "config-bean";
    private static final String PARAM_PROVIDER_BEAN = "provider-bean";
    private static final String PARAM_PROVIDER_NAME = "provider-name";
    private static final String PARAM_STRING_OUTPUT_TYPE = "string-output-type";
    static final int UTIL_TYPE_BASIC = 0;
    static final int UTIL_TYPE_STRONG = 1;
    static final int UTIL_TYPE_CONFIGURABLE = 2;
    private final int utilType;

    UtilDigesterBeanDefinitionParser(int utilType) {
        this.utilType = utilType;
    }

    protected Class<?> getBeanClass(Element element) {
        if (this.utilType == 0) {
            return BasicPasswordEncryptor.class;
        }
        if (this.utilType == 1) {
            return StrongPasswordEncryptor.class;
        }
        if (this.utilType == 2) {
            return ConfigurablePasswordEncryptor.class;
        }
        throw new IllegalArgumentException("Unknown util type: " + this.utilType);
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.processStringAttribute(element, builder, PARAM_ALGORITHM, PARAM_ALGORITHM);
        this.processBeanAttribute(element, builder, PARAM_CONFIG_BEAN, "config");
        this.processBeanAttribute(element, builder, PARAM_PROVIDER_BEAN, "provider");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME, "providerName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE, "stringOutputType");
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }
}

