/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;

public final class ControlFile {
    private static final boolean DISABLE_FILE_LOCK = "true".equals(System.getProperty("java.nio.channels.FileLock.broken", "false"));
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final int maxRecordSize;
    private final int firstRecordStart;
    private final int secondRecordStart;
    private final int firstRecordEnd;
    private final int secondRecordEnd;
    private long version;
    private FileLock lock;
    private boolean disposed;

    public ControlFile(File file, int recordSize) throws IOException {
        this.file = file;
        this.maxRecordSize = recordSize + 4;
        this.firstRecordStart = 8;
        this.secondRecordStart = 8 + this.maxRecordSize + 8 + 8;
        this.firstRecordEnd = this.firstRecordStart + this.maxRecordSize;
        this.secondRecordEnd = this.secondRecordStart + this.maxRecordSize;
        this.randomAccessFile = new RandomAccessFile(file, "rw");
    }

    public void lock() throws IOException {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        if (this.lock == null) {
            try {
                this.lock = this.randomAccessFile.getChannel().tryLock(0L, Math.max(1L, this.randomAccessFile.getChannel().size()), false);
            }
            catch (OverlappingFileLockException e) {
                throw IOExceptionSupport.create("Control file '" + this.file + "' could not be locked.", e);
            }
            if (this.lock == null) {
                throw new IOException("Control file '" + this.file + "' could not be locked.");
            }
        }
    }

    public void unlock() throws IOException {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.unlock();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized ByteSequence load() throws IOException {
        long l = this.randomAccessFile.length();
        if (l < (long)this.maxRecordSize) {
            return null;
        }
        this.randomAccessFile.seek(this.firstRecordStart - 8);
        long v1 = this.randomAccessFile.readLong();
        this.randomAccessFile.seek(this.firstRecordEnd);
        long v1check = this.randomAccessFile.readLong();
        this.randomAccessFile.seek(this.secondRecordStart - 8);
        long v2 = this.randomAccessFile.readLong();
        this.randomAccessFile.seek(this.secondRecordEnd);
        long v2check = this.randomAccessFile.readLong();
        byte[] data = null;
        if (v2 == v2check) {
            this.version = v2;
            this.randomAccessFile.seek(this.secondRecordStart);
            int size2 = this.randomAccessFile.readInt();
            data = new byte[size2];
            this.randomAccessFile.readFully(data);
        } else if (v1 == v1check) {
            this.version = v1;
            this.randomAccessFile.seek(this.firstRecordStart);
            int size3 = this.randomAccessFile.readInt();
            data = new byte[size3];
            this.randomAccessFile.readFully(data);
        } else {
            throw new IOException("Control data corrupted.");
        }
        return new ByteSequence(data, 0, data.length);
    }

    public void store(ByteSequence data, boolean sync) throws IOException {
        ++this.version;
        this.randomAccessFile.setLength(this.maxRecordSize * 2 + 32);
        this.randomAccessFile.seek(0L);
        this.randomAccessFile.writeLong(this.version);
        this.randomAccessFile.writeInt(data.getLength());
        this.randomAccessFile.write(data.getData());
        this.randomAccessFile.seek(this.firstRecordEnd);
        this.randomAccessFile.writeLong(this.version);
        this.randomAccessFile.writeLong(this.version);
        this.randomAccessFile.writeInt(data.getLength());
        this.randomAccessFile.write(data.getData());
        this.randomAccessFile.seek(this.secondRecordEnd);
        this.randomAccessFile.writeLong(this.version);
        if (sync) {
            this.randomAccessFile.getFD().sync();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

