/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import org.armedbear.lisp.Debug;

public class HttpHead {
    private static String get(String urlString, String key) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            HttpHead.log("Failed to form url from '" + urlString + "'" + ": " + e);
        }
        return HttpHead.get(url, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String get(URL url, String key) {
        String result;
        block22: {
            Socket socket;
            block19: {
                String string;
                String line;
                socket = null;
                result = null;
                String protocol = url.getProtocol();
                if (protocol.equals("http")) break block20;
                HttpHead.log("The protocol '" + protocol + "'" + " is not http.");
                String string2 = result;
                Object var15_7 = null;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                {
                    block20: {
                        return string2;
                    }
                    socket = new Socket(Proxy.NO_PROXY);
                    int port = url.getPort();
                    if (port == -1) {
                        port = 80;
                    }
                    InetSocketAddress address = new InetSocketAddress(url.getHost(), port);
                    try {
                        socket.connect(address, 5000);
                    }
                    catch (IOException ex) {
                        HttpHead.log("Connection failed: " + ex);
                        String string3 = result;
                        Object var15_8 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        return string3;
                    }
                    PrintWriter out = null;
                    BufferedReader in = null;
                    try {
                        out = new PrintWriter(socket.getOutputStream());
                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    }
                    catch (IOException e) {
                        HttpHead.log("Failed to establish socket io: " + e);
                        String string4 = result;
                        Object var15_9 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        return string4;
                    }
                    String head = "HEAD " + url.getPath() + " HTTP/1.1";
                    out.println(head);
                    out.println("Host: " + url.getAuthority());
                    out.println("Connection: close");
                    out.println("");
                    out.flush();
                    line = null;
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        HttpHead.log("Failed to read HTTP response: " + e);
                    }
                    String[] status = line.split("\\s");
                    if (status[1].equals("200")) {
                        result = HttpHead.findHeader(in, key);
                        break block19;
                    }
                    if (!status[1].startsWith("3")) break block21;
                    String location = HttpHead.findHeader(in, "Location");
                    if (location == null) break block19;
                    string = HttpHead.get(location, key);
                }
                Object var15_10 = null;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                {
                    block21: {
                        return string;
                    }
                    HttpHead.log("Unexpected response: " + line);
                }
            }
            Object var15_11 = null;
            try {
                socket.close();
            }
            catch (IOException e2) {}
            break block22;
            catch (Throwable throwable) {
                Object var15_12 = null;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    private static String findHeader(BufferedReader in, String key) {
        String result = null;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int i = line.indexOf(":");
                if (i == -1) continue;
                String k = line.substring(0, i);
                String v = line.substring(i + 1).trim();
                if (!k.equals(key)) continue;
                result = v;
                break;
            }
        }
        catch (IOException e) {
            HttpHead.log("Failed to read headers: " + e);
        }
        return result;
    }

    private static void log(String message) {
        Debug.warn(message);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: <cmd> URL");
            return;
        }
        String modified = HttpHead.get(argv[0], "Last-Modified");
        if (modified != null) {
            System.out.println("Last-Modified: " + modified);
        } else {
            System.out.println("No result returned.");
        }
    }
}

