/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import openlink.util.Vector;
import virtuoso.jdbc2.VirtuosoBlob;
import virtuoso.jdbc2.VirtuosoCallableStatement;
import virtuoso.jdbc2.VirtuosoColumn;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoExplicitString;
import virtuoso.jdbc2.VirtuosoFuture;
import virtuoso.jdbc2.VirtuosoPreparedStatement;
import virtuoso.jdbc2.VirtuosoResultSetMetaData;
import virtuoso.jdbc2.VirtuosoRow;
import virtuoso.jdbc2.VirtuosoStatement;

public class VirtuosoResultSet
implements ResultSet {
    private static final String er1 = "I/O error on output stream.";
    protected Vector rows = new Vector(20);
    private Object[] row;
    private int concurrency;
    private int fetchDirection;
    private int prefetch;
    private int type;
    private VirtuosoStatement statement;
    protected VirtuosoResultSetMetaData metaData;
    private int maxRows;
    protected int totalRows;
    private boolean is_complete;
    private int updateCount;
    private String cursorName;
    protected int currentRow;
    protected int stmt_current_of;
    protected int stmt_n_rows_to_get;
    protected boolean stmt_co_last_in_batch;
    private int oldRow;
    private boolean wasNull = false;
    private boolean rowIsDeleted = false;
    private boolean rowIsUpdated = false;
    private boolean rowIsInserted = false;
    private boolean more_result;
    protected boolean isLastResult = false;
    protected boolean isLastRow = false;
    private int kindop;
    private VirtuosoPreparedStatement pstmt;
    private int rowNum = 0;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    VirtuosoResultSet(VirtuosoStatement virtuosoStatement, VirtuosoResultSetMetaData virtuosoResultSetMetaData, boolean bl) throws VirtuosoException {
        this.statement = virtuosoStatement;
        this.metaData = virtuosoResultSetMetaData;
        this.fetchDirection = virtuosoStatement.getFetchDirection();
        this.concurrency = virtuosoStatement.getResultSetConcurrency();
        this.type = virtuosoStatement.getResultSetType();
        this.prefetch = virtuosoStatement.getFetchSize();
        this.maxRows = virtuosoStatement.getMaxRows();
        this.cursorName = virtuosoStatement.cursorName == null ? virtuosoStatement.statid : virtuosoStatement.cursorName;
        this.stmt_current_of = -1;
        this.stmt_n_rows_to_get = this.prefetch;
        this.stmt_co_last_in_batch = false;
        this.process_result(bl);
    }

    VirtuosoResultSet(VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        this.statement = new VirtuosoStatement(virtuosoConnection);
        this.metaData = new VirtuosoResultSetMetaData(null, virtuosoConnection);
        this.type = 1003;
        this.is_complete = true;
    }

    protected VirtuosoResultSet(VirtuosoConnection virtuosoConnection, String[] stringArray, int[] nArray) throws VirtuosoException {
        this.statement = new VirtuosoStatement(virtuosoConnection);
        this.metaData = new VirtuosoResultSetMetaData(virtuosoConnection, stringArray, nArray);
        this.type = 1003;
        this.is_complete = true;
    }

    protected void getMoreResults(boolean bl) throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            this.is_complete = false;
            this.rowIsInserted = false;
            this.rowIsUpdated = false;
            this.rowIsDeleted = false;
            this.currentRow = 0;
            if (this.rows == null) {
                this.rows = new Vector(20);
            } else {
                this.rows.removeAllElements();
            }
            this.process_result(bl);
            this.more_result = true;
        }
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(int n) {
        this.updateCount = n;
    }

    private void fetch_rpc() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] objectArray = new Object[]{this.statement.statid, new Long(this.statement.future.hashCode())};
                this.statement.connection.removeFuture(this.statement.connection.getFuture("FTCH", objectArray, this.statement.rpc_timeout));
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
        }
    }

    private void extended_fetch(int n, long l, long l2) throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] objectArray = new Object[]{this.statement.statid, new Long(n), new Long(l), new Long(l2), new Long(this.statement.connection.getAutoCommit() ? 1L : 0L), null};
                this.statement.future = this.statement.connection.getFuture("EXTF", objectArray, this.statement.rpc_timeout);
                this.getMoreResults(false);
                if (this.statement.connection.getAutoCommit()) {
                    this.process_result(false);
                }
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
        }
    }

    private void set_pos(int n, Vector vector, long l) throws VirtuosoException {
        if (this.pstmt == null) {
            this.pstmt = (VirtuosoPreparedStatement)this.statement.connection.prepareStatement("__set_pos(?,?,?,?)");
        }
        this.pstmt.setString(1, this.statement.statid);
        this.pstmt.setLong(2, n);
        this.pstmt.setLong(3, l);
        this.pstmt.setVector(4, vector);
        this.pstmt.execute();
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            switch (n) {
                case 3: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsDeleted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 2: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsUpdated = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 4: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsInserted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 1: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (this.pstmt.vresultSet.more_result());
                    this.totalRows = this.pstmt.vresultSet.totalRows;
                }
            }
            this.pstmt.vresultSet.rows = null;
        }
    }

    private void process_result(boolean bl) throws VirtuosoException {
        this.more_result = false;
        int n = 0;
        block16: while (!this.is_complete) {
            if (this.rows.size() == this.statement.getMaxRows() && this.rows.size() > 0) {
                this.is_complete = true;
                continue;
            }
            if (this.statement == null || this.statement.future == null) {
                throw new VirtuosoException("Statement closed. Operation not applicable", -17);
            }
            Vector vector = this.statement.future.nextResult();
            Vector vector2 = vector = vector == null ? null : vector.firstElement();
            if (vector instanceof Vector) {
                Vector vector3 = vector;
                switch (((Short)vector3.firstElement()).intValue()) {
                    case 9: {
                        this.statement.connection.qualifier = (String)vector3.elementAt(1);
                        continue block16;
                    }
                    case 13: {
                        if (this.statement.type != 1003) {
                            this.is_complete = true;
                        } else {
                            this.stmt_co_last_in_batch = true;
                        }
                    }
                    case 1: {
                        this.isLastRow = false;
                        vector3.removeElementAt(0);
                        if (this.currentRow == 0) {
                            this.rows.insertElementAt(new VirtuosoRow(this, vector3), n++);
                        } else {
                            this.rows.setElementAt(new VirtuosoRow(this, vector3), this.currentRow - 1);
                        }
                        if (this.statement.type == 1003) {
                            return;
                        }
                        if (n < (this.prefetch == 0 ? 100 : this.prefetch)) continue block16;
                        return;
                    }
                    case 4: {
                        Vector vector4 = (Vector)vector3.elementAt(1);
                        Number number = (Number)vector4.elementAt(1);
                        if (number == null) {
                            this.kindop = 0;
                            if (this.statement != null && this.statement.getExecType() == 1) {
                                throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                            }
                            if (!(this.statement instanceof VirtuosoPreparedStatement)) {
                                this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(null, this.statement.connection);
                                continue block16;
                            }
                        } else {
                            this.kindop = number.intValue();
                            if (this.statement != null) {
                                if (this.statement.getExecType() == 0 && this.kindop == 1) {
                                    throw new VirtuosoException("executeUpdate can execute only update/insert/delete queries", -4);
                                }
                                if (this.statement.getExecType() == 1 && this.kindop == 0) {
                                    throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                                }
                            }
                        }
                        if (this.metaData != null) {
                            this.metaData.close();
                        }
                        this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(vector4, this.statement.connection);
                        if (!(this.statement instanceof PreparedStatement) || !bl) continue block16;
                        Object object = vector4.elementAt(3);
                        this.statement.objparams = null;
                        if (object != null && object instanceof Vector) {
                            this.statement.objparams = (Vector)object;
                            this.statement.parameters = (Vector)this.statement.objparams.clone();
                            if (this.statement instanceof CallableStatement) {
                                VirtuosoCallableStatement virtuosoCallableStatement = (VirtuosoCallableStatement)this.statement;
                                virtuosoCallableStatement.param_type = new int[this.statement.parameters.capacity()];
                                virtuosoCallableStatement.param_scale = new int[this.statement.parameters.capacity()];
                                int n2 = 0;
                                while (n2 < virtuosoCallableStatement.param_type.length) {
                                    virtuosoCallableStatement.param_type[n2] = 1111;
                                    virtuosoCallableStatement.param_scale[n2] = 0;
                                    ++n2;
                                }
                            }
                            this.is_complete = true;
                            continue block16;
                        }
                        this.statement.parameters = null;
                        continue block16;
                    }
                    case 7: {
                        if (this.type != 1003) {
                            this.totalRows = ((Number)vector3.elementAt(1)).intValue();
                            this.updateCount = 0;
                            this.is_complete = true;
                        } else {
                            this.updateCount = ((Number)vector3.elementAt(1)).intValue();
                            this.is_complete = true;
                        }
                        this.isLastRow = true;
                        if (this.kindop == 2) continue block16;
                        this.isLastResult = true;
                        continue block16;
                    }
                    case 12: {
                        vector3.removeElementAt(0);
                        this.rows.removeElementAt(this.currentRow - 1);
                        --this.totalRows;
                        continue block16;
                    }
                    case 11: {
                        vector3.removeElementAt(0);
                        vector3.removeElementAt(vector3.size() - 1);
                        this.rows.setElementAt(new VirtuosoRow(this, vector3), this.currentRow - 1);
                        continue block16;
                    }
                    case 3: {
                        Object object;
                        if (VirtuosoFuture.rpc_log != null) {
                            object = VirtuosoFuture.rpc_log;
                            synchronized (object) {
                                VirtuosoFuture.rpc_log.println("---> QA_ERROR err=[" + (String)vector3.elementAt(2) + "] stat=[" + (String)vector3.elementAt(1) + "]");
                                VirtuosoFuture.rpc_log.flush();
                            }
                        }
                        this.isLastResult = true;
                        this.isLastRow = true;
                        throw new VirtuosoException((String)vector3.elementAt(2), (String)vector3.elementAt(1), -8);
                    }
                    case 14: {
                        this.statement.connection.setWarning(new SQLWarning((String)vector3.elementAt(2), (String)vector3.elementAt(1), -8));
                        continue block16;
                    }
                    case 6: {
                        if (this.statement.objparams != null && this.statement.objparams.size() != vector3.size() - 2) {
                            this.statement.objparams = new Vector(vector3.size() - 2);
                        }
                        int n3 = 2;
                        while (n3 < vector3.size()) {
                            if (this.statement.objparams == null) {
                                this.statement.objparams = new Vector(vector3.size() - 2);
                            }
                            this.statement.objparams.setElementAt(vector3.elementAt(n3), n3 - 2);
                            ++n3;
                        }
                        this.is_complete = true;
                        this.isLastResult = true;
                        this.isLastRow = true;
                        continue block16;
                    }
                    case 5: {
                        this.sendBlobData(vector3);
                        continue block16;
                    }
                    default: {
                        throw new VirtuosoException(((Object)vector).toString(), -16);
                    }
                }
            }
            this.isLastRow = true;
            if (this.kindop != 2) {
                this.isLastResult = true;
            }
            if (vector == null) {
                this.more_result = true;
                this.is_complete = true;
                continue;
            }
            if ((Short)((Object)vector) != 0 && (Short)((Object)vector) != 100) continue;
            this.is_complete = true;
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    public void clearWarnings() throws VirtuosoException {
    }

    public int getType() throws VirtuosoException {
        return this.type;
    }

    public int getConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    public void setFetchDirection(int n) throws VirtuosoException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws VirtuosoException {
        if (n < 0 || n > this.statement.getMaxRows()) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = n == 0 ? 100 : n;
    }

    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    public Statement getStatement() throws VirtuosoException {
        return this.statement;
    }

    public ResultSetMetaData getMetaData() throws VirtuosoException {
        return this.metaData;
    }

    protected int kindop() throws VirtuosoException {
        return this.kindop;
    }

    protected boolean more_result() throws VirtuosoException {
        return this.more_result;
    }

    public int findColumn(String string) throws VirtuosoException {
        if (string == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        Integer n = (Integer)this.metaData.hcolumns.get(new VirtuosoColumn(string, 182, this.statement.connection));
        return n == null ? 0 : n + 1;
    }

    public boolean wasNull() throws VirtuosoException {
        return this.wasNull;
    }

    public String getString(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(n);
    }

    public boolean getBoolean(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBoolean(n);
    }

    public byte getByte(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getByte(n);
    }

    public short getShort(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getShort(n);
    }

    public int getInt(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getInt(n);
    }

    public long getLong(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getLong(n);
    }

    public float getFloat(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getFloat(n);
    }

    public double getDouble(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws VirtuosoException {
        return this.getBigDecimal(n).setScale(n2, 7);
    }

    public byte[] getBytes(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBytes(n);
    }

    public BigDecimal getBigDecimal(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBigDecimal(n);
    }

    public InputStream getAsciiStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getAsciiStream(n);
    }

    public InputStream getUnicodeStream(int n) throws VirtuosoException {
        return this.getAsciiStream(n);
    }

    public InputStream getBinaryStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBinaryStream(n);
    }

    public Reader getCharacterStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(n);
    }

    public String getString(String string) throws VirtuosoException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws VirtuosoException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws VirtuosoException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws VirtuosoException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws VirtuosoException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws VirtuosoException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws VirtuosoException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws VirtuosoException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws VirtuosoException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(String string) throws VirtuosoException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws VirtuosoException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws VirtuosoException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws VirtuosoException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getObject(n);
    }

    public Object getObject(String string) throws VirtuosoException {
        return this.getObject(this.findColumn(string));
    }

    public Date getDate(int n) throws VirtuosoException {
        return this.getDate(n, null);
    }

    public Time getTime(int n) throws VirtuosoException {
        return this.getTime(n, null);
    }

    public Timestamp getTimestamp(int n) throws VirtuosoException {
        return this.getTimestamp(n, null);
    }

    public Date getDate(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        java.util.Date date = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDate(n);
        if (calendar != null && date != null) {
            calendar.setTime(date);
            date = calendar.getTime();
            date = Date.valueOf(new Date(date.getTime()).toString());
        }
        return date;
    }

    public Time getTime(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Time time = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTime(n);
        if (calendar != null && time != null) {
            calendar.setTime(time);
            time = Time.valueOf(new Time(calendar.getTime().getTime()).toString());
        }
        return time;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Timestamp timestamp = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTimestamp(n);
        if (calendar != null) {
            calendar.setTime(timestamp);
            timestamp = new Timestamp(calendar.getTime().getTime());
        }
        return timestamp;
    }

    public Date getDate(String string) throws VirtuosoException {
        return this.getDate(this.findColumn(string), null);
    }

    public Time getTime(String string) throws VirtuosoException {
        return this.getTime(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(String string) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public void updateNull(String string) throws VirtuosoException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws VirtuosoException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws VirtuosoException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws VirtuosoException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws VirtuosoException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws VirtuosoException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws VirtuosoException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws VirtuosoException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws VirtuosoException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws VirtuosoException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws VirtuosoException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws VirtuosoException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws VirtuosoException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws VirtuosoException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws VirtuosoException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws VirtuosoException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws VirtuosoException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws VirtuosoException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws VirtuosoException {
        this.updateObject(this.findColumn(string), object);
    }

    public Object getObject(String string, Map map) throws VirtuosoException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws VirtuosoException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws VirtuosoException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws VirtuosoException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws VirtuosoException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws VirtuosoException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws VirtuosoException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    protected void wasNull(boolean bl) {
        this.wasNull = bl;
    }

    public void close() throws VirtuosoException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.rows != null) {
            this.rows.removeAllElements();
        }
        this.row = null;
        this.cursorName = null;
    }

    public boolean next() throws VirtuosoException {
        try {
            int n = this.currentRow + 1;
            if (this.statement == null) {
                throw new VirtuosoException("Activity on a closed statement 1", "IM001", -8);
            }
            if (this.statement.isClosed()) {
                throw new VirtuosoException("Activity on a closed statement 2", "IM001", -8);
            }
            if (this.type == 1003) {
                if (this.rowNum >= this.maxRows && this.maxRows > 0) {
                    return false;
                }
                while (true) {
                    VirtuosoConnection virtuosoConnection = this.statement.connection;
                    synchronized (virtuosoConnection) {
                        if (this.is_complete) {
                            boolean bl = false;
                            return bl;
                        }
                        Object object = this.rows.firstElement();
                        if (!this.stmt_co_last_in_batch && this.currentRow == 0 && object != null) {
                            ++this.stmt_current_of;
                            ++this.currentRow;
                            ++this.rowNum;
                            boolean bl = true;
                            return bl;
                        }
                        if ((this.stmt_co_last_in_batch || this.stmt_current_of == this.stmt_n_rows_to_get - 1) && this.metaData != null && this.kindop == 1) {
                            this.rows.removeElementAt(1);
                            this.fetch_rpc();
                            this.stmt_current_of = -1;
                            this.stmt_co_last_in_batch = false;
                        }
                        this.process_result(false);
                    }
                    this.currentRow = 0;
                }
            }
            if (n > 0 && n <= this.rows.size()) {
                this.currentRow = n;
                return true;
            }
            if (this.type == 1003) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            if (this.type == 1004 && this.getRow() == this.totalRows) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            this.extended_fetch(1, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 1;
                return false;
            }
            this.currentRow = 1;
            return true;
        }
        catch (Throwable throwable) {
            this.statement.notify_error(throwable);
            return false;
        }
    }

    public int getRow() throws VirtuosoException {
        if (this.currentRow > 0 && this.currentRow <= this.rows.size()) {
            int n = this.type == 1004 ? ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getRow() : (this.type == 1005 ? ((Number)((Vector)((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBookmark().elementAt(1)).elementAt(0)).intValue() : (this.type == 1003 ? this.rowNum : 0));
            if (n == 0) {
                return this.currentRow;
            }
            return n;
        }
        return this.currentRow;
    }

    public boolean previous() throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't access to the previous row, the type is forward only.", -12);
        }
        if (this.currentRow == 0) {
            return false;
        }
        int n = this.currentRow - 1;
        if (n > 0 && n <= this.rows.size()) {
            this.currentRow = n;
            return true;
        }
        if (this.type == 1004 && this.getRow() == 1) {
            this.currentRow = 0;
            return false;
        }
        if (this.type == 1004) {
            int n2 = this.getRow();
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            int n3 = this.rows.size() - 1;
            while (n3 >= 0) {
                if (this.rows.elementAt(n3) != null && ((VirtuosoRow)this.rows.elementAt(n3)).getRow() == n2) {
                    this.currentRow = n3;
                    return true;
                }
                --n3;
            }
        }
        if (this.type == 1005) {
            VirtuosoRow virtuosoRow = (VirtuosoRow)this.rows.elementAt(this.currentRow - 1);
            Vector vector = null;
            if (virtuosoRow != null) {
                vector = virtuosoRow.getBookmark();
            }
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            if (vector != null) {
                int n4 = this.rows.size() - 1;
                while (n4 >= 0) {
                    if (this.rows.elementAt(n4) != null && ((VirtuosoRow)this.rows.elementAt(n4)).getBookmark().equals(vector)) {
                        this.currentRow = n4;
                        return true;
                    }
                    --n4;
                }
            }
        }
        this.currentRow = this.rows.size();
        return true;
    }

    public void beforeFirst() throws VirtuosoException {
        this.absolute(1);
        this.previous();
    }

    public void afterLast() throws VirtuosoException {
        this.absolute(-1);
        this.next();
    }

    public boolean first() throws VirtuosoException {
        return this.absolute(1);
    }

    public boolean isBeforeFirst() throws VirtuosoException {
        return this.getRow() == 0;
    }

    public boolean isAfterLast() throws VirtuosoException {
        return this.getRow() == this.rows.size() + 1;
    }

    public boolean isFirst() throws VirtuosoException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws VirtuosoException {
        return this.getRow() == this.totalRows;
    }

    public boolean last() throws VirtuosoException {
        return this.absolute(-1);
    }

    public boolean absolute(int n) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(5, n, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = n > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    public boolean relative(int n) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(6, n, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = n > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    public String getCursorName() throws VirtuosoException {
        return this.cursorName;
    }

    public Blob getBlob(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBlob(n);
    }

    public Clob getClob(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(n);
    }

    public boolean rowUpdated() throws VirtuosoException {
        return this.rowIsUpdated;
    }

    public boolean rowInserted() throws VirtuosoException {
        return this.rowIsInserted;
    }

    public boolean rowDeleted() throws VirtuosoException {
        return this.rowIsDeleted;
    }

    public void updateNull(int n) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = null;
    }

    public void updateBoolean(int n, boolean bl) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Boolean(bl);
    }

    public void updateByte(int n, byte by) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Byte(by);
    }

    public void updateShort(int n, short s) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Short(s);
    }

    public void updateInt(int n, int n2) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Integer(n2);
    }

    public void updateLong(int n, long l) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Long(l);
    }

    public void updateFloat(int n, float f) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Float(f);
    }

    public void updateDouble(int n, double d) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Double(d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = bigDecimal;
    }

    public void updateString(int n, String string) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = string;
    }

    /*
     * Unable to fully structure code
     */
    public void updateBytes(int var1_1, byte[] var2_2) throws VirtuosoException {
        block7: {
            if (var1_1 < 1 || var1_1 > this.metaData.getColumnCount()) {
                throw new VirtuosoException("Index " + var1_1 + " is not 1<n<" + this.metaData.getColumnCount(), -4);
            }
            if (this.row == null) {
                this.row = new Object[this.metaData.getColumnCount()];
                if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                    ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
                }
            }
            try {
                this.row[var1_1 - 1] = new String(var2_2, "8859_1");
                break block7;
            }
            catch (UnsupportedEncodingException var3_3) {
                if (var2_2 == null) {
                    this.row[var1_1 - 1] = new String(var2_2);
                }
                var4_4 = new char[var2_2.length];
                var5_5 = 0;
                ** while (var5_5 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                var4_4[var5_5] = (char)var2_2[var5_5];
                ++var5_5;
                continue;
            }
lbl19:
            // 1 sources

            this.row[var1_1 - 1] = new String(var4_4);
        }
    }

    public void updateDate(int n, Date date) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = date;
    }

    public void updateTime(int n, Time time) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = time;
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = timestamp;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (inputStream == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setInputStream(inputStream, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(inputStream, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (inputStream == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setInputStream(inputStream, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(inputStream, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (reader == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setReader(reader, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(reader, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    public void updateObject(int n, Object object) throws VirtuosoException {
        Object object2;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (object == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object2 = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setObject(object);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(object, n - 1);
    }

    public void updateObject(int n, Object object, int n2) throws VirtuosoException {
        this.updateObject(n, object);
    }

    public void cancelRowUpdates() throws VirtuosoException {
        if (this.row != null) {
            this.row = null;
        }
    }

    public void insertRow() throws VirtuosoException {
        Object[] objectArray = new Object[]{new Vector(this.row)};
        this.set_pos(4, new Vector(objectArray), 0L);
        this.row = null;
    }

    public void updateRow() throws VirtuosoException {
        if (this.currentRow < 0 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        if (this.currentRow != 0) {
            this.set_pos(2, new Vector(this.row), this.currentRow);
            this.row = null;
        } else if (this.oldRow != 0) {
            this.insertRow();
        }
    }

    public void deleteRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(3, null, this.currentRow);
    }

    public void refreshRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(1, null, this.currentRow);
    }

    public void moveToInsertRow() throws VirtuosoException {
        if (this.oldRow == 0) {
            this.oldRow = this.getRow();
            this.currentRow = 0;
        }
    }

    public void moveToCurrentRow() throws VirtuosoException {
        if (this.oldRow != 0) {
            this.absolute(this.oldRow);
            this.oldRow = 0;
        }
    }

    public Object getObject(int n, Map map) throws VirtuosoException {
        return null;
    }

    public Ref getRef(int n) throws VirtuosoException {
        return null;
    }

    public Array getArray(int n) throws VirtuosoException {
        return null;
    }

    protected void sendBlobData(Vector vector) throws VirtuosoException {
        try {
            int n;
            Object object;
            int n2 = ((Number)vector.elementAt(1)).intValue();
            VirtuosoBlob virtuosoBlob = (VirtuosoBlob)this.statement.objparams.elementAt(n2);
            Reader reader = virtuosoBlob.getCharacterStream();
            long l = 0L;
            int n3 = 182;
            if (this.statement.parameters != null && this.statement.parameters.elementAt(n2) instanceof Vector) {
                object = (Vector)this.statement.parameters.elementAt(n2);
                n3 = ((Number)((Vector)object).elementAt(0)).intValue();
                n3 = n3 == 131 ? 222 : (n3 == 132 ? 225 : 182);
            }
            object = new char[8192];
            do {
                n = 0;
                while (n < 8192 && (long)n < virtuosoBlob.length() - l) {
                    int n4 = reader.read((char[])object, n, virtuosoBlob.length() - l < (long)(8192 - n) ? (int)(virtuosoBlob.length() - l) : 8192 - n);
                    if (n4 == -1) break;
                    n += n4;
                    l += (long)n4;
                }
                if (n <= 0) continue;
                Object object2 = n3 == 222 ? new String((char[])object, 0, n) : new VirtuosoExplicitString(new String((char[])object, 0, n), n3, this.statement.connection);
                this.statement.connection.write_object(object2);
            } while (n > 0);
            byte[] byArray = new byte[]{0};
            this.statement.connection.write_bytes(byArray);
        }
        catch (IOException iOException) {
            throw new VirtuosoException(er1, -3);
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof VirtuosoResultSet;
    }
}

