-- File: bin2gray.vhd
-- Generated by MyHDL 0.7
-- Date: Sun Dec 19 16:52:33 2010


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_07.all;

entity bin2gray is
    port (
        B: in unsigned(7 downto 0);
        G: out unsigned(7 downto 0)
    );
end entity bin2gray;
-- Gray encoder.
-- 
-- B -- input intbv signal, binary encoded
-- G -- output intbv signal, gray encoded
-- width -- bit width

architecture MyHDL of bin2gray is


begin




BIN2GRAY_LOGIC: process (B) is
    variable Bext: unsigned(8 downto 0);
begin
    Bext := to_unsigned(0, 9);
    Bext := resize(B, 9);
    for i in 0 to 8-1 loop
        G(i) <= (Bext((i + 1)) xor Bext(i));
    end loop;
end process BIN2GRAY_LOGIC;

end architecture MyHDL;
