# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Florian Boucault <florian@fluendo.com>

from elisa.core.utils import defer
from elisa.core.components.model import Model
from elisa.plugins.pigment.widgets.list_vertical import ListVertical

from elisa.plugins.poblesec.base.list import GenericListViewMode, \
                                             BaseListController
from elisa.plugins.poblesec.base.info_list import ButtonItem
from elisa.plugins.poblesec.actions import OpenControllerAction

class Link(Model):

    def __init__(self, controller_path=None, controller_args={}, label=None,
                 icon=None):
        super(Link, self).__init__()
        self.controller_path = controller_path
        self.controller_args = controller_args
        self.label = label
        self.icon = icon

class DeviceLink(Link):

    def __init__(self, udi, *args, **kwargs):
        super(DeviceLink, self).__init__(*args, **kwargs)
        self.udi = udi


class OpenLinkAction(OpenControllerAction):

    def __init__(self, controller):
        super(OpenLinkAction, self).__init__(controller, None)

    def execute(self, item):
        return self.open_controller(item.controller_path, item.label,
                                    **item.controller_args)

class LinksMenuViewMode(GenericListViewMode):
    """
    DOCME
    """

    def get_label(self, item):
        return defer.succeed(item.label)

    def get_preview_image(self, item, theme):
        return None

    def get_image(self, item, theme):
        return None

    def get_default_image(self, item):
        return item.icon

class LinksMenuController(BaseListController):
    """
    DOCME
    """

    view_mode = LinksMenuViewMode

    def create_actions(self):
        return OpenLinkAction(self), []

    def node_renderer(self, item, widget):
        widget.item_widget.label.label = item.label
