// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_REGEX_H
#define _GLIBMM_REGEX_H


/* Copyright (C) 2007 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmmconfig.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <glibmm/error.h>
#include <glibmm/arrayhandle.h>
#include <glib.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GRegex GRegex;
#endif

namespace Glib
{

/** @addtogroup glibmmEnums glibmm Enums and Flags */

/** 
 * Flags specifying compile-time options.
 * 
 * @newin{2,14}
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexCompileFlags operator|(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator&(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator^(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator~(RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator|=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator&=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator^=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 */
enum RegexCompileFlags
{
  /** Letters in the pattern match both upper- and
   * lowercase letters. This option can be changed within a pattern
   * by a "(?i)" option setting.
   */
  REGEX_CASELESS = 1 << 0,
  /** By default, GRegex treats the strings as consisting
   * of a single line of characters (even if it actually contains
   * newlines). The "start of line" metacharacter ("^") matches only
   * at the start of the string, while the "end of line" metacharacter
   * ("$") matches only at the end of the string, or before a terminating
   * newline (unless REGEX_DOLLAR_ENDONLY is set). When
   * REGEX_MULTILINE is set, the "start of line" and "end of line"
   * constructs match immediately following or immediately before any
   * newline in the string, respectively, as well as at the very start
   * and end. This can be changed within a pattern by a "(?m)" option
   * setting.
   */
  REGEX_MULTILINE = 1 << 1,
  /** A dot metacharater (".") in the pattern matches all
   * characters, including newlines. Without it, newlines are excluded.
   * This option can be changed within a pattern by a ("?s") option setting.
   */
  REGEX_DOTALL = 1 << 2,
  /** Whitespace data characters in the pattern are
   * totally ignored except when escaped or inside a character class.
   * Whitespace does not include the VT character (code 11). In addition,
   * characters between an unescaped "#" outside a character class and
   * the next newline character, inclusive, are also ignored. This can
   * be changed within a pattern by a "(?x)" option setting.
   */
  REGEX_EXTENDED = 1 << 3,
  /** The pattern is forced to be "anchored", that is,
   * it is constrained to match only at the first matching point in the
   * string that is being searched. This effect can also be achieved by
   * appropriate constructs in the pattern itself such as the "^"
   * metacharater.
   */
  REGEX_ANCHORED = 1 << 4,
  /** A dollar metacharacter ("$") in the pattern
   * matches only at the end of the string. Without this option, a
   * dollar also matches immediately before the final character if
   * it is a newline (but not before any other newlines). This option
   * is ignored if REGEX_MULTILINE is set.
   */
  REGEX_DOLLAR_ENDONLY = 1 << 5,
  /** Inverts the "greediness" of the quantifiers so that
   * they are not greedy by default, but become greedy if followed by "?".
   * It can also be set by a "(?U)" option setting within the pattern.
   */
  REGEX_UNGREEDY = 1 << 9,
  /** Usually strings must be valid UTF-8 strings, using this
   * flag they are considered as a raw sequence of bytes.
   */
  REGEX_RAW = 1 << 11,
  /** Disables the use of numbered capturing
   * parentheses in the pattern. Any opening parenthesis that is not
   * followed by "?" behaves as if it were followed by "?:" but named
   * parentheses can still be used for capturing (and they acquire numbers
   * in the usual way).
   */
  REGEX_NO_AUTO_CAPTURE = 1 << 12,
  /** Optimize the regular expression. If the pattern will
   * be used many times, then it may be worth the effort to optimize it
   * to improve the speed of matches.
   */
  REGEX_OPTIMIZE = 1 << 13,
  /** Limits an unanchored pattern to match before (or at) the
   * first newline. @newin{2,34}
   */
  REGEX_FIRSTLINE = 1 << 18,
  /** Names used to identify capturing subpatterns need not
   * be unique. This can be helpful for certain types of pattern when it
   * is known that only one instance of the named subpattern can ever be
   * matched.
   */
  REGEX_DUPNAMES = 1 << 19,
  /** Usually any newline character or character sequence is
   * recognized. If this option is set, the only recognized newline character
   * is '\\r'.
   */
  REGEX_NEWLINE_CR = 1 << 20,
  /** Usually any newline character or character sequence is
   * recognized. If this option is set, the only recognized newline character
   * is '\\n'.
   */
  REGEX_NEWLINE_LF = 1 << 21,
  /** Usually any newline character or character sequence is
   * recognized. If this option is set, the only recognized newline character
   * sequence is '\\r\\n'.
   */
  REGEX_NEWLINE_CRLF = 0x300000,
  /** Usually any newline character or character sequence
   * is recognized. If this option is set, the only recognized newline character
   * sequences are '\\r', '\\n', and '\\r\\n'. @newin{2,34}
   */
  REGEX_NEWLINE_ANYCRLF = 1048576 | 1 << 22,
  /** Usually any newline character or character sequence
   * is recognised. If this option is set, then "\\R" only recognizes the newline
   * characters '\\r', '\\n' and '\\r\\n'. @newin{2,34}
   */
  REGEX_BSR_ANYCRLF = 1 << 23,
  /** Changes behaviour so that it is compatible with
   * JavaScript rather than PCRE. @newin{2,34}
   */
  REGEX_JAVASCRIPT_COMPAT = 1 << 25
};

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator|(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator&(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator^(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator~(RegexCompileFlags flags)
  { return static_cast<RegexCompileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator|=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator&=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator^=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** 
 * Flags specifying match-time options.
 * 
 * @newin{2,14}
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexMatchFlags operator|(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator&(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator^(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator~(RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator|=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator&=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator^=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 */
enum RegexMatchFlags
{
  /** The pattern is forced to be "anchored", that is,
   * it is constrained to match only at the first matching point in the
   * string that is being searched. This effect can also be achieved by
   * appropriate constructs in the pattern itself such as the "^"
   * metacharater.
   */
  REGEX_MATCH_ANCHORED = 1 << 4,
  /** Specifies that first character of the string is
   * not the beginning of a line, so the circumflex metacharacter should
   * not match before it. Setting this without REGEX_MULTILINE (at
   * compile time) causes circumflex never to match. This option affects
   * only the behaviour of the circumflex metacharacter, it does not
   * affect "\\A".
   */
  REGEX_MATCH_NOTBOL = 1 << 7,
  /** Specifies that the end of the subject string is
   * not the end of a line, so the dollar metacharacter should not match
   * it nor (except in multiline mode) a newline immediately before it.
   * Setting this without REGEX_MULTILINE (at compile time) causes
   * dollar never to match. This option affects only the behaviour of
   * the dollar metacharacter, it does not affect "\\Z" or "\\z".
   */
  REGEX_MATCH_NOTEOL = 1 << 8,
  /** An empty string is not considered to be a valid
   * match if this option is set. If there are alternatives in the pattern,
   * they are tried. If all the alternatives match the empty string, the
   * entire match fails. For example, if the pattern "a?b?" is applied to
   * a string not beginning with "a" or "b", it matches the empty string
   * at the start of the string. With this flag set, this match is not
   * valid, so GRegex searches further into the string for occurrences
   * of "a" or "b".
   */
  REGEX_MATCH_NOTEMPTY = 1 << 10,
  /** Turns on the partial matching feature, for more
   * documentation on partial matching see g_match_info_is_partial_match().
   */
  REGEX_MATCH_PARTIAL = 1 << 15,
  /** Overrides the newline definition set when
   * creating a new Regex, setting the '\\r' character as line terminator.
   */
  REGEX_MATCH_NEWLINE_CR = 1 << 20,
  /** Overrides the newline definition set when
   * creating a new Regex, setting the '\\n' character as line terminator.
   */
  REGEX_MATCH_NEWLINE_LF = 1 << 21,
  /** Overrides the newline definition set when
   * creating a new Regex, setting the '\\r\\n' characters sequence as line terminator.
   */
  REGEX_MATCH_NEWLINE_CRLF = 0x300000,
  /** Overrides the newline definition set when
   * creating a new Regex, any Unicode newline sequence
   * is recognised as a newline. These are '\\r', '\\n' and '\\rn', and the
   * single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
   * U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
   * U+2029 PARAGRAPH SEPARATOR.
   */
  REGEX_MATCH_NEWLINE_ANY = 1 << 22,
  /** Overrides the newline definition set when
   * creating a new Regex; any '\\r', '\\n', or '\\r\\n' character sequence
   * is recognized as a newline. @newin{2,34}
   */
  REGEX_MATCH_NEWLINE_ANYCRLF = 0x500000,
  /** Overrides the newline definition for "\\R" set when
   * creating a new Regex; only '\\r', '\\n', or '\\r\\n' character sequences
   * are recognized as a newline by "\\R". @newin{2,34}
   */
  REGEX_MATCH_BSR_ANYCRLF = 1 << 23,
  /** Overrides the newline definition for "\\R" set when
   * creating a new Regex; any Unicode newline character or character sequence
   * are recognized as a newline by "\\R". These are '\\r', '\\n' and '\\rn', and the
   * single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
   * U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
   * U+2029 PARAGRAPH SEPARATOR. @newin{2,34}
   */
  REGEX_MATCH_BSR_ANY = 1 << 24,
  /** An alias for REGEX_MATCH_PARTIAL. @newin{2,34}
   */
  REGEX_MATCH_PARTIAL_SOFT = 0x8000,
  /** Turns on the partial matching feature. In contrast to
   * to REGEX_MATCH_PARTIAL_SOFT, this stops matching as soon as a partial match
   * is found, without continuing to search for a possible complete match. See
   * see g_match_info_is_partial_match() for more information. @newin{2,34}
   */
  REGEX_MATCH_PARTIAL_HARD = 1 << 27,
  /** Like REGEX_MATCH_NOTEMPTY, but only applied to
   * the start of the matched string. For anchored
   * patterns this can only happen for pattern containing "\\K". @newin{2,34}
   */
  REGEX_MATCH_NOTEMPTY_ATSTART = 1 << 28
};

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator|(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator&(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator^(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator~(RegexMatchFlags flags)
  { return static_cast<RegexMatchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator|=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator&=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator^=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Exception class for Regex
 */
class RegexError : public Glib::Error
{
public:
  enum Code
  {
    /** Compilation of the regular expression failed.
     */
    COMPILE = 0,
    /** Optimization of the regular expression failed.
     */
    OPTIMIZE = 1,
    /** Replacement failed due to an ill-formed replacement
     * string.
     */
    REPLACE = 2,
    /** The match process failed.
     */
    MATCH = 3,
    /** Internal error of the regular expression engine.
     * @newin{2,16}
     */
    INTERNAL = 4,
    /** "\\\\" at end of pattern. @newin{2,16}
     */
    STRAY_BACKSLASH = 101,
    /** "\\\\c" at end of pattern. @newin{2,16}
     */
    MISSING_CONTROL_CHAR = 102,
    /** Unrecognized character follows "\\\\".
     * @newin{2,16}
     */
    UNRECOGNIZED_ESCAPE = 103,
    /** Numbers out of order in "{}"
     * quantifier. @newin{2,16}
     */
    QUANTIFIERS_OUT_OF_ORDER = 104,
    /** Number too big in "{}" quantifier.
     * @newin{2,16}
     */
    QUANTIFIER_TOO_BIG = 105,
    /** Missing terminating "]" for
     * character class. @newin{2,16}
     */
    UNTERMINATED_CHARACTER_CLASS = 106,
    /** Invalid escape sequence
     * in character class. @newin{2,16}
     */
    INVALID_ESCAPE_IN_CHARACTER_CLASS = 107,
    /** Range out of order in character class.
     * @newin{2,16}
     */
    RANGE_OUT_OF_ORDER = 108,
    /** Nothing to repeat. @newin{2,16}
     */
    NOTHING_TO_REPEAT = 109,
    /** Unrecognized character after "(?",
     * "(?<" or "(?P". @newin{2,16}
     */
    UNRECOGNIZED_CHARACTER = 112,
    /** POSIX named classes are
     * supported only within a class. @newin{2,16}
     */
    POSIX_NAMED_CLASS_OUTSIDE_CLASS = 113,
    /** Missing terminating ")" or ")"
     * without opening "(". @newin{2,16}
     */
    UNMATCHED_PARENTHESIS = 114,
    /** Reference to non-existent
     * subpattern. @newin{2,16}
     */
    INEXISTENT_SUBPATTERN_REFERENCE = 115,
    /** Missing terminating ")" after comment.
     * @newin{2,16}
     */
    UNTERMINATED_COMMENT = 118,
    /** Regular expression too large.
     * @newin{2,16}
     */
    EXPRESSION_TOO_LARGE = 120,
    /** Failed to get memory. @newin{2,16}
     */
    MEMORY_ERROR = 121,
    /** Lookbehind assertion is not
     * fixed length. @newin{2,16}
     */
    VARIABLE_LENGTH_LOOKBEHIND = 125,
    /** Malformed number or name after "(?(".
     * @newin{2,16}
     */
    MALFORMED_CONDITION = 126,
    /** Conditional group contains
     * more than two branches. @newin{2,16}
     */
    TOO_MANY_CONDITIONAL_BRANCHES = 127,
    /** Assertion expected after "(?(".
     * @newin{2,16}
     */
    ASSERTION_EXPECTED = 128,
    /** Unknown POSIX class name.
     * @newin{2,16}
     */
    UNKNOWN_POSIX_CLASS_NAME = 130,
    /** POSIX collating
     * elements are not supported. @newin{2,16}
     */
    POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED = 131,
    /** Character value in "\\\\x{...}" sequence
     * is too large. @newin{2,16}
     */
    HEX_CODE_TOO_LARGE = 134,
    /** Invalid condition "(?(0)". @newin{2,16}
     */
    INVALID_CONDITION = 135,
    /** \\\\C not allowed in
     * lookbehind assertion. @newin{2,16}
     */
    SINGLE_BYTE_MATCH_IN_LOOKBEHIND = 136,
    /** Recursive call could loop indefinitely.
     * @newin{2,16}
     */
    INFINITE_LOOP = 140,
    /** Missing terminator
     * in subpattern name. @newin{2,16}
     */
    MISSING_SUBPATTERN_NAME_TERMINATOR = 142,
    /** Two named subpatterns have
     * the same name. @newin{2,16}
     */
    DUPLICATE_SUBPATTERN_NAME = 143,
    /** Malformed "\\\\P" or "\\\\p" sequence.
     * @newin{2,16}
     */
    MALFORMED_PROPERTY = 146,
    /** Unknown property name after "\\\\P" or
     * "\\\\p". @newin{2,16}
     */
    UNKNOWN_PROPERTY = 147,
    /** Subpattern name is too long
     * (maximum 32 characters). @newin{2,16}
     */
    SUBPATTERN_NAME_TOO_LONG = 148,
    /** Too many named subpatterns (maximum
     * 10,000). @newin{2,16}
     */
    TOO_MANY_SUBPATTERNS = 149,
    /** Octal value is greater than "\\\\377".
     * @newin{2,16}
     */
    INVALID_OCTAL_VALUE = 151,
    /** "DEFINE" group contains more
     * than one branch. @newin{2,16}
     */
    TOO_MANY_BRANCHES_IN_DEFINE = 154,
    /** Repeating a "DEFINE" group is not allowed.
     * This error is never raised. @newin{2,16} Deprecated: 2.34
     */
    DEFINE_REPETION = 155,
    /** Inconsistent newline options.
     * @newin{2,16}
     */
    INCONSISTENT_NEWLINE_OPTIONS = 156,
    /** "\\\\g" is not followed by a braced,
     * angle-bracketed, or quoted name or number, or by a plain number. @newin{2,16}
     */
    MISSING_BACK_REFERENCE = 157,
    /** relative reference must not be zero. @newin{2,34}
     */
    INVALID_RELATIVE_REFERENCE = 158,
    /** the backtracing
     * control verb used does not allow an argument. @newin{2,34}
     */
    BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN = 159,
    /** unknown backtracing 
     * control verb. @newin{2,34}
     */
    UNKNOWN_BACKTRACKING_CONTROL_VERB = 160,
    /** number is too big in escape sequence. @newin{2,34}
     */
    NUMBER_TOO_BIG = 161,
    /** Missing subpattern name. @newin{2,34}
     */
    MISSING_SUBPATTERN_NAME = 162,
    /** Missing digit. @newin{2,34}
     */
    MISSING_DIGIT = 163,
    /** In JavaScript compatibility mode,
     * "[" is an invalid data character. @newin{2,34}
     */
    INVALID_DATA_CHARACTER = 164,
    /** different names for subpatterns of the 
     * same number are not allowed. @newin{2,34}
     */
    EXTRA_SUBPATTERN_NAME = 165,
    /** the backtracing control
     * verb requires an argument. @newin{2,34}
     */
    BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED = 166,
    /** "\\\\c" must be followed by an ASCII 
     * character. @newin{2,34}
     */
    INVALID_CONTROL_CHAR = 168,
    /** "\\\\k" is not followed by a braced, angle-bracketed, or 
     * quoted name. @newin{2,34}
     */
    MISSING_NAME = 169,
    /** "\\\\N" is not supported in a class. @newin{2,34}
     */
    NOT_SUPPORTED_IN_CLASS = 171,
    /** too many forward references. @newin{2,34}
     */
    TOO_MANY_FORWARD_REFERENCES = 172,
    /** the name is too long in "(*MARK)", "(*PRUNE)", 
     * "(*SKIP)", or "(*THEN)". @newin{2,34}
     */
    NAME_TOO_LONG = 175,
    /** the character value in the \\\\u sequence is
     * too large. @newin{2,34}
     */
    CHARACTER_VALUE_TOO_LARGE = 176
  };

  RegexError(Code error_code, const Glib::ustring& error_message);
  explicit RegexError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};


class MatchInfo;

/** Perl-compatible regular expressions - matches strings against regular expressions.
 *
 * The Glib::Regex functions implement regular expression pattern matching using
 * syntax and semantics similar to Perl regular expression.
 *
 * Some functions accept a start_position argument, setting it differs from just
 * passing over a shortened string and setting REGEX_MATCH_NOTBOL in the case
 * of a pattern that begins with any kind of lookbehind assertion. For example,
 * consider the pattern "\Biss\B" which finds occurrences of "iss" in the middle
 * of words. ("\B" matches only if the current position in the subject is not a
 * word boundary.) When applied to the string "Mississipi" from the fourth byte,
 * namely "issipi", it does not match, because "\B" is always false at the
 * start of the subject, which is deemed to be a word boundary. However, if
 * the entire string is passed , but with start_position set to 4, it finds the
 * second occurrence of "iss" because it is able to look behind the starting point
 * to discover that it is preceded by a letter.
 *
 * Note that, unless you set the REGEX_RAW flag, all the strings passed to these
 * functions must be encoded in UTF-8. The lengths and the positions inside the
 *  strings are in bytes and not in characters, so, for instance,
 * "\xc3\xa0" (i.e. "à") is two bytes long but it is treated as a single
 * character. If you set REGEX_RAW the strings can be non-valid UTF-8 strings
 * and a byte is treated as a character, so "\xc3\xa0" is two bytes and
 * two characters long.
 *
 * When matching a pattern, "\n" matches only against a "\n" character in the
 * string, and "\r" matches only a "\r" character. To match any newline sequence
 * use "\R". This particular group matches either the two-character sequence
 * CR + LF ("\r\n"), or one of the single characters LF (linefeed, U+000A, "\n"),
 *  VT (vertical tab, U+000B, "\v"), FF (formfeed, U+000C, "\f"), CR (carriage
 * return, U+000D, "\r"), NEL (next line, U+0085), LS (line separator, U+2028),
 * or PS (paragraph separator, U+2029).
 *
 * The behaviour of the dot, circumflex, and dollar metacharacters are affected
 * by newline characters, the default is to recognize any newline character (the
 * same characters recognized by "\R"). This can be changed with REGEX_NEWLINE_CR,
 * REGEX_NEWLINE_LF and REGEX_NEWLINE_CRLF compile options, and with
 * REGEX_MATCH_NEWLINE_ANY, REGEX_MATCH_NEWLINE_CR, REGEX_MATCH_NEWLINE_LF
 * and REGEX_MATCH_NEWLINE_CRLF match options. These settings are also
 * relevant when compiling a pattern if REGEX_EXTENDED is set, and an unescaped
 * "#" outside a character class is encountered. This indicates a comment that
 * lasts until after the next newline.
 *
 * Creating and manipulating the same Glib::Regex class from different threads is
 * not a problem as Glib::Regex does not modify its internal state between creation and
 * destruction, on the other hand Glib::MatchInfo is not threadsafe.
 *
 * The regular expressions low level functionalities are obtained through the
 * excellent PCRE library written by Philip Hazel.
 *
 * @newin{2,14}
 */
class Regex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Regex CppObjectType;
  typedef GRegex BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GRegex*       gobj();

  ///Provides access to the underlying C instance.
  const GRegex* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GRegex* gobj_copy() const;

protected:
  // Do not derive this.  Glib::Regex can neither be constructed nor deleted.
  Regex();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Regex(const Regex&);
  Regex& operator=(const Regex&);


public:

  static Glib::RefPtr<Glib::Regex> create(const Glib::ustring& pattern, RegexCompileFlags compile_options = static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  
  /** Gets the pattern string associated with @a regex, i.e.\ a copy of
   * the string passed to g_regex_new().
   * 
   * @newin{2,14}
   * @return The pattern of @a regex.
   */
  Glib::ustring get_pattern() const;
  
  /** Returns the number of the highest back reference
   * in the pattern, or 0 if the pattern does not contain
   * back references.
   * 
   * @newin{2,14}
   * @return The number of the highest back reference.
   */
  int get_max_backref() const;
  
  /** Returns the number of capturing subpatterns in the pattern.
   * 
   * @newin{2,14}
   * @return The number of capturing subpatterns.
   */
  int get_capture_count() const;
  
  /** Checks whether the pattern contains explicit CR or LF references.
   * 
   * @newin{2,34}
   * @return <tt>true</tt> if the pattern contains explicit CR or LF references.
   */
  bool get_has_cr_or_lf() const;

  
  /** Retrieves the number of the subexpression named @a name.
   * 
   * @newin{2,14}
   * @param name Name of the subexpression.
   * @return The number of the subexpression or -1 if @a name
   * does not exists.
   */
  int get_string_number(const Glib::ustring& name) const;
  
  /** Returns the compile options that @a regex was created with.
   * 
   * @newin{2,26}
   * @return Flags from RegexCompileFlags.
   */
  RegexCompileFlags get_compile_flags() const;
  
  /** Returns the match options that @a regex was created with.
   * 
   * @newin{2,26}
   * @return Flags from RegexMatchFlags.
   */
  RegexMatchFlags get_match_flags() const;

  static Glib::ustring escape_string(const Glib::ustring& string);

  
  /** Scans for a match in @a string for @a pattern.
   * 
   * This function is equivalent to g_regex_match() but it does not
   * require to compile the pattern with g_regex_new(), avoiding some
   * lines of code when you need just to do a match without extracting
   * substrings, capture counts, and so on.
   * 
   * If this function is to be called on the same @a pattern more than
   * once, it's more efficient to compile the pattern once with
   * g_regex_new() and then use g_regex_match().
   * 
   * @newin{2,14}
   * @param pattern The regular expression.
   * @param string The string to scan for matches.
   * @param compile_options Compile options for the regular expression, or 0.
   * @param match_options Match options, or 0.
   * @return <tt>true</tt> if the string matched, <tt>false</tt> otherwise.
   */
  static bool match_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options =  static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0));

  
  /** Scans for a match in string for the pattern in @a regex.
   * The @a match_options are combined with the match options specified
   * when the @a regex structure was created, letting you have more
   * flexibility in reusing Regex structures.
   * 
   * A MatchInfo structure, used to get information on the match,
   * is stored in @a match_info if not <tt>0</tt>. Note that if @a match_info
   * is not <tt>0</tt> then it is created even if the function returns <tt>false</tt>,
   * i.e. you must free it regardless if regular expression actually matched.
   * 
   * To retrieve all the non-overlapping matches of the pattern in
   * string you can use g_match_info_next().
   * 
   * 
   * [C example ellipted]
   * 
   *  @a string is not copied and is used in MatchInfo internally. If
   * you use any MatchInfo method (except g_match_info_free()) after
   * freeing or modifying @a string then the behaviour is undefined.
   * 
   * @newin{2,14}
   * @param string The string to scan for matches.
   * @param match_options Match options.
   * @param match_info Pointer to location where to store
   * the MatchInfo, or <tt>0</tt> if you do not need it.
   * @return <tt>true</tt> is the string matched, <tt>false</tt> otherwise.
   */

  bool match(
    const Glib::ustring& string,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  /// A match() method not requiring a Glib::MatchInfo.
  bool match(const Glib::ustring& string, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  /// A match() method with a start position and a Glib::MatchInfo.
  bool match(
    const Glib::ustring& string,
    int start_position,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  
  /** Scans for a match in string for the pattern in @a regex.
   * The @a match_options are combined with the match options specified
   * when the @a regex structure was created, letting you have more
   * flexibility in reusing Regex structures.
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\\b".
   * 
   * A MatchInfo structure, used to get information on the match, is
   * stored in @a match_info if not <tt>0</tt>. Note that if @a match_info is
   * not <tt>0</tt> then it is created even if the function returns <tt>false</tt>,
   * i.e. you must free it regardless if regular expression actually
   * matched.
   * 
   *  @a string is not copied and is used in MatchInfo internally. If
   * you use any MatchInfo method (except g_match_info_free()) after
   * freeing or modifying @a string then the behaviour is undefined.
   * 
   * To retrieve all the non-overlapping matches of the pattern in
   * string you can use g_match_info_next().
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{2,14}
   * @param string The string to scan for matches.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Match options.
   * @param match_info Pointer to location where to store
   * the MatchInfo, or <tt>0</tt> if you do not need it.
   * @return <tt>true</tt> is the string matched, <tt>false</tt> otherwise.
   */

  bool match(
    const Glib::ustring& string,
    gssize string_len,
    int start_position,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  /// A match() method with a start position not requiring a Glib::MatchInfo.
  bool match(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);

  /** A match() method with a string length and start position not requiring a
   * Glib::MatchInfo.
   */
  bool match(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);

  
  /** Using the standard algorithm for regular expression matching only
   * the longest match in the string is retrieved. This function uses
   * a different algorithm so it can retrieve all the possible matches.
   * For more documentation see g_regex_match_all_full().
   * 
   * A MatchInfo structure, used to get information on the match, is
   * stored in @a match_info if not <tt>0</tt>. Note that if @a match_info is
   * not <tt>0</tt> then it is created even if the function returns <tt>false</tt>,
   * i.e. you must free it regardless if regular expression actually
   * matched.
   * 
   *  @a string is not copied and is used in MatchInfo internally. If
   * you use any MatchInfo method (except g_match_info_free()) after
   * freeing or modifying @a string then the behaviour is undefined.
   * 
   * @newin{2,14}
   * @param string The string to scan for matches.
   * @param match_options Match options.
   * @param match_info Pointer to location where to store
   * the MatchInfo, or <tt>0</tt> if you do not need it.
   * @return <tt>true</tt> is the string matched, <tt>false</tt> otherwise.
   */

  bool match_all(
    const Glib::ustring& string,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  /// A match_all() method not requiring a Glib::MatchInfo.
  bool match_all(const Glib::ustring& string, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  /// A match_all() method with a start positon and a Glib::MatchInfo.
  bool match_all(
    const Glib::ustring& string,
    int start_position,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  
  /** Using the standard algorithm for regular expression matching only
   * the longest match in the string is retrieved, it is not possible
   * to obtain all the available matches. For instance matching
   * "<a> <b> <c>" against the pattern "<.*>"
   * you get "<a> <b> <c>".
   * 
   * This function uses a different algorithm (called DFA, i.e. deterministic
   * finite automaton), so it can retrieve all the possible matches, all
   * starting at the same point in the string. For instance matching
   * "<a> <b> <c>" against the pattern "<.*>"
   * you would obtain three matches: "<a> <b> <c>",
   * "<a> <b>" and "<a>".
   * 
   * The number of matched strings is retrieved using
   * g_match_info_get_match_count(). To obtain the matched strings and
   * their position you can use, respectively, g_match_info_fetch() and
   * g_match_info_fetch_pos(). Note that the strings are returned in
   * reverse order of length; that is, the longest matching string is
   * given first.
   * 
   * Note that the DFA algorithm is slower than the standard one and it
   * is not able to capture substrings, so backreferences do not work.
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\\b".
   * 
   * A MatchInfo structure, used to get information on the match, is
   * stored in @a match_info if not <tt>0</tt>. Note that if @a match_info is
   * not <tt>0</tt> then it is created even if the function returns <tt>false</tt>,
   * i.e. you must free it regardless if regular expression actually
   * matched.
   * 
   *  @a string is not copied and is used in MatchInfo internally. If
   * you use any MatchInfo method (except g_match_info_free()) after
   * freeing or modifying @a string then the behaviour is undefined.
   * 
   * @newin{2,14}
   * @param string The string to scan for matches.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Match options.
   * @param match_info Pointer to location where to store
   * the MatchInfo, or <tt>0</tt> if you do not need it.
   * @return <tt>true</tt> is the string matched, <tt>false</tt> otherwise.
   */

  /// @throw Glib::Error.
  bool match_all(
    const Glib::ustring& string,
    gssize string_len,
    int start_position,
    Glib::MatchInfo& match_info,
    RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0)
  );

  /** A match_all() method with a start position not requiring a
   * Glib::MatchInfo.
   */
  bool match_all(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);

  /** A match_all() method with a start position and a string length not
   * requiring a Glib::MatchInfo.
   */
  bool match_all(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);

 
  /** Breaks the string on the pattern, and returns an array of
   * the tokens. If the pattern contains capturing parentheses,
   * then the text for each of the substrings will also be returned.
   * If the pattern does not match anywhere in the string, then the
   * whole string is returned as the first token.
   * 
   * This function is equivalent to g_regex_split() but it does
   * not require to compile the pattern with g_regex_new(), avoiding
   * some lines of code when you need just to do a split without
   * extracting substrings, capture counts, and so on.
   * 
   * If this function is to be called on the same @a pattern more than
   * once, it's more efficient to compile the pattern once with
   * g_regex_new() and then use g_regex_split().
   * 
   * As a special case, the result of splitting the empty string ""
   * is an empty vector, not a vector containing a single string.
   * The reason for this special case is that being able to represent
   * a empty vector is typically more useful than consistent handling
   * of empty elements. If you do need to represent empty elements,
   * you'll need to check for the empty string before calling this
   * function.
   * 
   * A pattern that can match empty strings splits @a string into
   * separate characters wherever it matches the empty string between
   * characters. For example splitting "ab c" using as a separator
   * "\\s*", you will get "a", "b" and "c".
   * 
   * @newin{2,14}
   * @param pattern The regular expression.
   * @param string The string to scan for matches.
   * @param compile_options Compile options for the regular expression, or 0.
   * @param match_options Match options, or 0.
   * @return A <tt>0</tt>-terminated array of strings. Free
   * it using g_strfreev().
   */
  static Glib::StringArrayHandle split_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options =  static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0));
  
  /** Breaks the string on the pattern, and returns an array of the tokens.
   * If the pattern contains capturing parentheses, then the text for each
   * of the substrings will also be returned. If the pattern does not match
   * anywhere in the string, then the whole string is returned as the first
   * token.
   * 
   * As a special case, the result of splitting the empty string "" is an
   * empty vector, not a vector containing a single string. The reason for
   * this special case is that being able to represent a empty vector is
   * typically more useful than consistent handling of empty elements. If
   * you do need to represent empty elements, you'll need to check for the
   * empty string before calling this function.
   * 
   * A pattern that can match empty strings splits @a string into separate
   * characters wherever it matches the empty string between characters.
   * For example splitting "ab c" using as a separator "\\s*", you will get
   * "a", "b" and "c".
   * 
   * @newin{2,14}
   * @param string The string to split with the pattern.
   * @param match_options Match time option flags.
   * @return A <tt>0</tt>-terminated gchar ** array. Free
   * it using g_strfreev().
   */
  Glib::StringArrayHandle split(const Glib::ustring& string, RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0));

  
  /** Breaks the string on the pattern, and returns an array of the tokens.
   * If the pattern contains capturing parentheses, then the text for each
   * of the substrings will also be returned. If the pattern does not match
   * anywhere in the string, then the whole string is returned as the first
   * token.
   * 
   * As a special case, the result of splitting the empty string "" is an
   * empty vector, not a vector containing a single string. The reason for
   * this special case is that being able to represent a empty vector is
   * typically more useful than consistent handling of empty elements. If
   * you do need to represent empty elements, you'll need to check for the
   * empty string before calling this function.
   * 
   * A pattern that can match empty strings splits @a string into separate
   * characters wherever it matches the empty string between characters.
   * For example splitting "ab c" using as a separator "\\s*", you will get
   * "a", "b" and "c".
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\\b".
   * 
   * @newin{2,14}
   * @param string The string to split with the pattern.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Match time option flags.
   * @param max_tokens The maximum number of tokens to split @a string into.
   * If this is less than 1, the string is split completely.
   * @return A <tt>0</tt>-terminated gchar ** array. Free
   * it using g_strfreev().
   */
  Glib::StringArrayHandle split(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0), int max_tokens =  0) const;

  Glib::StringArrayHandle split(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, int max_tokens) const;

  
  /** Replaces all occurrences of the pattern in @a regex with the
   * replacement text. Backreferences of the form '\\number' or
   * '\\g<number>' in the replacement text are interpolated by the
   * number-th captured subexpression of the match, '\\g<name>' refers
   * to the captured subexpression with the given name. '\\0' refers to the
   * complete match, but '\\0' followed by a number is the octal representation
   * of a character. To include a literal '\\' in the replacement, write '\\\\'.
   * There are also escapes that changes the case of the following text:
   * 
   * <dl>
   * <dt>\\l</dt>
   * <dd>
   * Convert to lower case the next character
   * </dd>
   * <dt>\\u</dt>
   * <dd>
   * Convert to upper case the next character
   * </dd>
   * <dt>\\L</dt>
   * <dd>
   * Convert to lower case till \\E
   * </dd>
   * <dt>\\U</dt>
   * <dd>
   * Convert to upper case till \\E
   * </dd>
   * <dt>\\E</dt>
   * <dd>
   * End case modification
   * </dd>
   * </dl>
   * 
   * If you do not need to use backreferences use g_regex_replace_literal().
   * 
   * The @a replacement string must be UTF-8 encoded even if REGEX_RAW was
   * passed to g_regex_new(). If you want to use not UTF-8 encoded stings
   * you can use g_regex_replace_literal().
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern that
   * begins with any kind of lookbehind assertion, such as "\\b".
   * 
   * @newin{2,14}
   * @param string The string to perform matches against.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param replacement Text to replace each match with.
   * @param match_options Options for the match.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace(const gchar* string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0));
  Glib::ustring replace(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);

  
  /** Replaces all occurrences of the pattern in @a regex with the
   * replacement text. @a replacement is replaced literally, to
   * include backreferences use g_regex_replace().
   * 
   * Setting @a start_position differs from just passing over a
   * shortened string and setting REGEX_MATCH_NOTBOL in the
   * case of a pattern that begins with any kind of lookbehind
   * assertion, such as "\\b".
   * 
   * @newin{2,14}
   * @param string The string to perform matches against.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param replacement Text to replace each match with.
   * @param match_options Options for the match.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace_literal(const gchar * string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options =  static_cast<RegexMatchFlags>(0));
  Glib::ustring replace_literal(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);

  
  /** Replaces occurrences of the pattern in regex with the output of
   *  @a eval for that occurrence.
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\\b".
   * 
   * The following example uses g_regex_replace_eval() to replace multiple
   * strings at once:
   * 
   * [C example ellipted]
   * 
   * @newin{2,14}
   * @param string String to perform matches against.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Options for the match.
   * @param eval A function to call for each match.
   * @param user_data User data to pass to the function.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace_eval(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, GRegexEvalCallback eval, gpointer user_data);
  
  /** Checks whether @a replacement is a valid replacement string
   * (see g_regex_replace()), i.e.\ that all escape sequences in
   * it are valid.
   * 
   * If @a has_references is not <tt>0</tt> then @a replacement is checked
   * for pattern references. For instance, replacement text 'foo\\n'
   * does not contain references and may be evaluated without information
   * about actual match, but '\\0\\1' (whole match followed by first
   * subpattern) requires valid MatchInfo object.
   * 
   * @newin{2,14}
   * @param replacement The replacement string.
   * @param has_references Location to store information about
   * references in @a replacement or <tt>0</tt>.
   * @return Whether @a replacement is a valid replacement string.
   */
  static bool check_replacement(const Glib::ustring& replacement, gboolean* has_references);


};

//TODO: Add C++ iterator like functionality for this class.
/** MatchInfo - MatchInfo is used to retrieve information about the regular
 * expression match which created it.
 * @newin{2,28}
 */
class MatchInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MatchInfo CppObjectType;
  typedef GMatchInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  /// Default constructor.
  MatchInfo();

  /** C object constructor.
   * @param castitem The C object.
   * @param take_ownership Whether to destroy the C object with the wrapper or
   * not.
   */
  explicit MatchInfo(GMatchInfo* castitem, bool take_ownership = true);

  /// Destructor.
  virtual ~MatchInfo();

  /// Provides access to the underlying C object.
  GMatchInfo* gobj()
    { return reinterpret_cast<GMatchInfo*>(gobject_); }

  /// Provides access to the underlying C object.
  const GMatchInfo* gobj() const
    { return reinterpret_cast<GMatchInfo*>(gobject_); }

private:
// noncopyable
  MatchInfo(const MatchInfo& other);
  MatchInfo& operator=(const MatchInfo& other);

  friend class Regex;

public:

  
  /** Returns Regex object used in @a match_info. It belongs to Glib
   * and must not be freed. Use g_regex_ref() if you need to keep it
   * after you free @a match_info object.
   * 
   * @newin{2,14}
   * @return Regex object used in @a match_info.
   */
  Glib::RefPtr<Regex> get_regex();
  
  /** Returns Regex object used in @a match_info. It belongs to Glib
   * and must not be freed. Use g_regex_ref() if you need to keep it
   * after you free @a match_info object.
   * 
   * @newin{2,14}
   * @return Regex object used in @a match_info.
   */
  Glib::RefPtr<const Regex> get_regex() const;

  
  /** Returns the string searched with @a match_info. This is the
   * string passed to g_regex_match() or g_regex_replace() so
   * you may not free it before calling this function.
   * 
   * @newin{2,14}
   * @return The string searched with @a match_info.
   */
  Glib::ustring get_string() const;
  
  /** Returns whether the previous match operation succeeded.
   * 
   * @newin{2,14}
   * @return <tt>true</tt> if the previous match operation succeeded,
   * <tt>false</tt> otherwise.
   */
  bool matches() const;

  
  /** Scans for the next match using the same parameters of the previous
   * call to g_regex_match_full() or g_regex_match() that returned
   *  @a match_info.
   * 
   * The match is done on the string passed to the match function, so you
   * cannot free it before calling this function.
   * 
   * @newin{2,14}
   * @return <tt>true</tt> is the string matched, <tt>false</tt> otherwise.
   */
  bool next();

  
  /** Retrieves the number of matched substrings (including substring 0,
   * that is the whole matched text), so 1 is returned if the pattern
   * has no substrings in it and 0 is returned if the match failed.
   * 
   * If the last match was obtained using the DFA algorithm, that is
   * using g_regex_match_all() or g_regex_match_all_full(), the retrieved
   * count is not that of the number of capturing parentheses but that of
   * the number of matched substrings.
   * 
   * @newin{2,14}
   * @return Number of matched substrings, or -1 if an error occurred.
   */
  int get_match_count() const;
  
  /** Usually if the string passed to g_regex_match*() matches as far as
   * it goes, but is too short to match the entire pattern, <tt>false</tt> is
   * returned. There are circumstances where it might be helpful to
   * distinguish this case from other cases in which there is no match.
   * 
   * Consider, for example, an application where a human is required to
   * type in data for a field with specific formatting requirements. An
   * example might be a date in the form ddmmmyy, defined by the pattern
   * "^\\d?\\d(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\\d\\d$".
   * If the application sees the user’s keystrokes one by one, and can
   * check that what has been typed so far is potentially valid, it is
   * able to raise an error as soon as a mistake is made.
   * 
   * GRegex supports the concept of partial matching by means of the
   * REGEX_MATCH_PARTIAL_SOFT and REGEX_MATCH_PARTIAL_HARD flags.
   * When they are used, the return code for
   * g_regex_match() or g_regex_match_full() is, as usual, <tt>true</tt>
   * for a complete match, <tt>false</tt> otherwise. But, when these functions
   * return <tt>false</tt>, you can check if the match was partial calling
   * g_match_info_is_partial_match().
   * 
   * The difference between REGEX_MATCH_PARTIAL_SOFT and 
   * REGEX_MATCH_PARTIAL_HARD is that when a partial match is encountered
   * with REGEX_MATCH_PARTIAL_SOFT, matching continues to search for a
   * possible complete match, while with REGEX_MATCH_PARTIAL_HARD matching
   * stops at the partial match.
   * When both REGEX_MATCH_PARTIAL_SOFT and REGEX_MATCH_PARTIAL_HARD
   * are set, the latter takes precedence.
   * See man:pcrepartial for more information on partial matching.
   * 
   * Because of the way certain internal optimizations are implemented
   * the partial matching algorithm cannot be used with all patterns.
   * So repeated single characters such as "a{2,4}" and repeated single
   * meta-sequences such as "\\d+" are not permitted if the maximum number
   * of occurrences is greater than one. Optional items such as "\\d?"
   * (where the maximum is one) are permitted. Quantifiers with any values
   * are permitted after parentheses, so the invalid examples above can be
   * coded thus "(a){2,4}" and "(\\d)+". If REGEX_MATCH_PARTIAL or 
   * REGEX_MATCH_PARTIAL_HARD is set
   * for a pattern that does not conform to the restrictions, matching
   * functions return an error.
   * 
   * @newin{2,14}
   * @return <tt>true</tt> if the match was partial, <tt>false</tt> otherwise.
   */
  bool is_partial_match() const;

  
  /** Returns a new string containing the text in @a string_to_expand with
   * references and escape sequences expanded. References refer to the last
   * match done with @a string against @a regex and have the same syntax used by
   * g_regex_replace().
   * 
   * The @a string_to_expand must be UTF-8 encoded even if REGEX_RAW was
   * passed to g_regex_new().
   * 
   * The backreferences are extracted from the string passed to the match
   * function, so you cannot call this function after freeing the string.
   * 
   *  @a match_info may be <tt>0</tt> in which case @a string_to_expand must not
   * contain references. For instance "foo\\n" does not refer to an actual
   * pattern and '\\n' merely will be replaced with \\n character,
   * while to expand "\\0" (whole match) one needs the result of a match.
   * Use g_regex_check_replacement() to find out whether @a string_to_expand
   * contains references.
   * 
   * @newin{2,14}
   * @param string_to_expand The string to expand.
   * @return The expanded string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring expand_references(const Glib::ustring& string_to_expand);

  
  /** Retrieves the text matching the @a match_num<!-- -->'th capturing
   * parentheses. 0 is the full text of the match, 1 is the first paren
   * set, 2 the second, and so on.
   * 
   * If @a match_num is a valid sub pattern but it didn't match anything
   * (e.g. sub pattern 1, matching "b" against "(a)?b") then an empty
   * string is returned.
   * 
   * If the match was obtained using the DFA algorithm, that is using
   * g_regex_match_all() or g_regex_match_all_full(), the retrieved
   * string is not that of a set of parentheses but that of a matched
   * substring. Substrings are matched in reverse order of length, so
   * 0 is the longest match.
   * 
   * The string is fetched from the string passed to the match function,
   * so you cannot call this function after freeing the string.
   * 
   * @newin{2,14}
   * @param match_num Number of the sub expression.
   * @return The matched substring, or <tt>0</tt> if an error
   * occurred. You have to free the string yourself.
   */
  Glib::ustring fetch(int match_num);

  
  /** Retrieves the position in bytes of the @a match_num<!-- -->'th capturing
   * parentheses. 0 is the full text of the match, 1 is the first
   * paren set, 2 the second, and so on.
   * 
   * If @a match_num is a valid sub pattern but it didn't match anything
   * (e.g. sub pattern 1, matching "b" against "(a)?b") then @a start_pos
   * and @a end_pos are set to -1 and <tt>true</tt> is returned.
   * 
   * If the match was obtained using the DFA algorithm, that is using
   * g_regex_match_all() or g_regex_match_all_full(), the retrieved
   * position is not that of a set of parentheses but that of a matched
   * substring. Substrings are matched in reverse order of length, so
   * 0 is the longest match.
   * 
   * @newin{2,14}
   * @param match_num Number of the sub expression.
   * @param start_pos Pointer to location where to store
   * the start position, or <tt>0</tt>.
   * @param end_pos Pointer to location where to store
   * the end position, or <tt>0</tt>.
   * @return <tt>true</tt> if the position was fetched, <tt>false</tt> otherwise. If
   * the position cannot be fetched, @a start_pos and @a end_pos are left
   * unchanged.
   */
  bool fetch_pos(int match_num, int& start_pos, int& end_pos);

  
  /** Retrieves the text matching the capturing parentheses named @a name.
   * 
   * If @a name is a valid sub pattern name but it didn't match anything
   * (e.g. sub pattern "X", matching "b" against "(?P<X>a)?b")
   * then an empty string is returned.
   * 
   * The string is fetched from the string passed to the match function,
   * so you cannot call this function after freeing the string.
   * 
   * @newin{2,14}
   * @param name Name of the subexpression.
   * @return The matched substring, or <tt>0</tt> if an error
   * occurred. You have to free the string yourself.
   */
  Glib::ustring fetch_named(const Glib::ustring& name);

  
  /** Retrieves the position in bytes of the capturing parentheses named @a name.
   * 
   * If @a name is a valid sub pattern name but it didn't match anything
   * (e.g. sub pattern "X", matching "b" against "(?P<X>a)?b")
   * then @a start_pos and @a end_pos are set to -1 and <tt>true</tt> is returned.
   * 
   * @newin{2,14}
   * @param name Name of the subexpression.
   * @param start_pos Pointer to location where to store
   * the start position, or <tt>0</tt>.
   * @param end_pos Pointer to location where to store
   * the end position, or <tt>0</tt>.
   * @return <tt>true</tt> if the position was fetched, <tt>false</tt> otherwise.
   * If the position cannot be fetched, @a start_pos and @a end_pos
   * are left unchanged.
   */
  bool fetch_named_pos(const Glib::ustring& name, int& start_pos, int& end_pos);

  
  /** Bundles up pointers to each of the matching substrings from a match
   * and stores them in an array of gchar pointers. The first element in
   * the returned array is the match number 0, i.e. the entire matched
   * text.
   * 
   * If a sub pattern didn't match anything (e.g. sub pattern 1, matching
   * "b" against "(a)?b") then an empty string is inserted.
   * 
   * If the last match was obtained using the DFA algorithm, that is using
   * g_regex_match_all() or g_regex_match_all_full(), the retrieved
   * strings are not that matched by sets of parentheses but that of the
   * matched substring. Substrings are matched in reverse order of length,
   * so the first one is the longest match.
   * 
   * The strings are fetched from the string passed to the match function,
   * so you cannot call this function after freeing the string.
   * 
   * @newin{2,14}
   * @return A <tt>0</tt>-terminated array of gchar *
   * pointers.  It must be freed using g_strfreev(). If the previous
   * match failed <tt>0</tt> is returned.
   */
  Glib::StringArrayHandle fetch_all();

protected:
  GMatchInfo* gobject_;      // The C object.
  bool take_ownership;       // Bool signaling ownership.

protected:
  // So that Glib::Regex::match() can set the C object.
  void set_gobject(GMatchInfo* castitem, bool take_ownership = true);


};

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Glib::Regex
   */
  Glib::RefPtr<Glib::Regex> wrap(GRegex* object, bool take_copy = false);

} // namespace Glib


#endif /* _GLIBMM_REGEX_H */

