-- Valyria Tear map editor begin. Do not edit this line or put anything before this line. --

-- Set the namespace according to the map name.
local ns = {};
setmetatable(ns, {__index = _G});
layna_village_bronanns_home = ns;
setfenv(1, ns);

-- The map name, subname and location image
map_name = ""
map_image_filename = ""
map_subname = "Bronann's home"

-- The number of rows, and columns that compose the map
num_tile_cols = 32
num_tile_rows = 24

-- The contexts names and inheritance definition
-- Tells the context id the current context inherit from
-- This means that the parent context will be used as a base, and the current
-- context will only have its own differences from it.
-- At least, the base context (id:0) can't a parent context, thus it should be equal to -1.
-- Note that a context cannot inherit from itself or a context with a higher id
-- since it would lead to nasty and useless loading use cases.
contexts = {}
contexts[0] = {}
contexts[0].name = "Base"
contexts[0].inherit_from = -1

-- The music file used as default background music on this map.
-- Other musics will have to handled through scripting.
music_filename = "mus/Caketown_1-OGA-mat-pablo.ogg"

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "building_interior_objects_01"
tileset_filenames[2] = "harrvah_house_interior"
tileset_filenames[3] = "mountain_house_interior"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable for all contexts. Valid range: [0:2^32-1]
-- Example: 1 (BIN 001) = wall for first context only, 2 (BIN 010) means wall for second context only, 5 (BIN 101) means Wall for first and third context.
map_grid = {}
map_grid[0] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[1] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[2] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[3] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[4] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[5] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[6] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[7] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[8] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[10] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[12] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[13] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[14] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[15] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[16] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[17] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[18] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[19] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[20] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[21] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[22] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[23] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[24] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[25] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[26] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[27] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[28] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[29] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[30] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[31] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[32] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[33] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[34] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[35] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[36] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[37] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[38] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[39] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[40] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[41] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[42] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[43] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[44] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[45] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[46] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[47] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }

-- The tile layers. The numbers are indeces to the tile_mappings table.
layers = {}
layers[0] = {}
layers[0].type = "ground"
layers[0].name = "Background"
layers[0][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 197, 208, 198, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][1] = { -1, -1, -1, -1, -1, -1, 736, 736, 736, 736, 736, 736, 736, 736, 624, 625, 227, 227, 227, 626, 626, 626, 626, 626, 628, 629, -1, -1, -1, -1, -1, -1 }
layers[0][2] = { -1, -1, -1, -1, -1, -1, 736, 736, 736, 736, 736, 736, 736, 736, 640, 641, 227, 227, 227, 531, -1, -1, -1, -1, 678, -1, -1, -1, -1, -1, -1, -1 }
layers[0][3] = { -1, -1, -1, -1, -1, -1, 736, 736, 736, 736, 736, 736, 736, 736, 656, 657, 227, 227, 227, 547, -1, -1, -1, -1, 678, -1, -1, -1, -1, -1, -1, -1 }
layers[0][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 579, 227, 227, 227, 563, -1, -1, 579, 579, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 563, 563, 563, 578, 579, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 563, 579, 578, 563, 563, 563, 579, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 563, 563, 578, 563, 563, 563, 563, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 224, 224, 224, 563, 563, 563, 563, 563, 563, 563, -1, -1, -1, -1, -1, -1, -1 }
layers[0][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 355, 357, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 736, 736, 736, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][15] = { -1, -1, -1, -1, -1, -1, -1, -1, 736, 736, 736, 736, 736, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[0][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

layers[1] = {}
layers[1].type = "ground"
layers[1].name = "Background 2"
layers[1][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 662, -1, -1, -1, -1, -1, -1, -1 }
layers[1][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, 83, 81, 662, 663, 635, 636, 637, 638, -1, -1, -1, -1, -1, -1, -1 }
layers[1][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 176, 177, 178, 678, 679, 651, 652, 653, 654, -1, -1, -1, -1, -1, -1, -1 }
layers[1][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 673, 192, 193, 194, 694, 695, 667, 668, 669, 670, -1, -1, -1, -1, -1, -1, -1 }
layers[1][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 710, 711, 683, 684, 685, 686, -1, -1, -1, -1, -1, -1, -1 }
layers[1][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 713, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 195, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 209, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 210, 208, 198, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

layers[2] = {}
layers[2].type = "ground"
layers[2].name = "Background 3"
layers[2][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

layers[3] = {}
layers[3].type = "ground"
layers[3].name = "Background 4"
layers[3][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

layers[4] = {}
layers[4].type = "sky"
layers[4].name = "Sky"
layers[4][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][2] = { -1, -1, -1, -1, -1, -1, 736, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 645, -1, -1, -1, -1, -1, -1 }
layers[4][3] = { -1, -1, -1, -1, -1, -1, 736, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 661, -1, -1, -1, -1, -1, -1 }
layers[4][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 688, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 677, -1, -1, -1, -1, -1, -1 }
layers[4][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 704, 705, -1, -1, 632, 633, 630, 631, -1, -1, 708, 709, -1, -1, -1, -1, -1, -1 }
layers[4][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 720, 721, 722, 722, 648, 649, 646, 647, 723, 723, 724, 725, -1, -1, -1, -1, -1, -1 }
layers[4][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 688, -1, -1, 693, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }


-- Valyria Tear map editor end. Do not edit this line. Place your scripts after this line. --

-- c++ objects instances
local Map = {};
local ObjectManager = {};
local DialogueManager = {};
local EventManager = {};
local GlobalEvents = {};

-- The main character handlers
local bronann = {};
local bronanns_dad = {};
local bronanns_mother = {};
local quest2_start_scene = {};

-- the main map loading code
function Load(m)

	Map = m;
	ObjectManager = Map.object_supervisor;
	DialogueManager = Map.dialogue_supervisor;
	EventManager = Map.event_supervisor;

	Map.unlimited_stamina = true;

	_CreateCharacters();
	_CreateNPCs();
	_CreateObjects();

	-- Set the camera focus on bronann
	Map:SetCamera(bronann);

	_CreateEvents();
	_CreateZones();
end

function Update()
	-- Check whether the character is in one of the zones
	_CheckZones();
end


-- Character creation
function _CreateCharacters()
	-- default position and direction
	bronann = CreateSprite(Map, "Bronann", 46.5, 11.5);
	bronann:SetDirection(hoa_map.MapMode.SOUTH);
	bronann:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);

	-- set up the position according to the previous map
	if (GlobalManager:GetPreviousLocation() == "from_village_center") then
		bronann:SetPosition(39.5, 22.5);
		bronann:SetDirection(hoa_map.MapMode.NORTH);
		AudioManager:PlaySound("snd/door_close.wav");
	end

	Map:AddGroundObject(bronann);
end

function _CreateNPCs()
	local event = {}
	local dialogue = {}
	local text = {}

	bronanns_dad = CreateSprite(Map, "Carson", 33.5, 11.5);
	Map:AddGroundObject(bronanns_dad);

	event = hoa_map.RandomMoveSpriteEvent("Dad random move", bronanns_dad, 2000, 2000);
	event:AddEventLinkAtEnd("Dad random move", 3000); -- Loop on itself
	EventManager:RegisterEvent(event);

	if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == true) then
	    -- Carson isn't here anymore
	    bronanns_dad:SetVisible(false);
	    bronanns_dad:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        bronanns_dad:SetPosition(0, 0);
	else
	    EventManager:StartEvent("Dad random move");
	end

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Hey son! Slept well? Err, where did I leave that oil lamp?");
	dialogue:AddLine(text, bronanns_dad);
	text = hoa_system.Translate("Hi Dad! Er, I don't know. Sorry.");
	dialogue:AddLineEmote(text, bronann, "thinking dots");
	text = hoa_system.Translate("Nah, no problem, I'll find it.");
	dialogue:AddLine(text, bronanns_dad);
	DialogueManager:AddDialogue(dialogue);
	bronanns_dad:AddDialogueReference(dialogue);

	bronanns_mother = CreateSprite(Map, "Malta", 33.1, 17.5);
	bronanns_mother:SetDirection(hoa_map.MapMode.SOUTH);
	Map:AddGroundObject(bronanns_mother);
	_UpdateMotherDialogue();

	-- Make her walk in front of the table to prepare the lunch.
	event = hoa_map.PathMoveSpriteEvent("Kitchen: Mother goes middle", bronanns_mother, 33.1, 19.9, false);
	event:AddEventLinkAtEnd("Kitchen: Mother looks left");
	EventManager:RegisterEvent(event);
	event = hoa_map.ChangeDirectionSpriteEvent("Kitchen: Mother looks left", bronanns_mother, hoa_map.MapMode.WEST);
	event:AddEventLinkAtEnd("Kitchen: Mother goes right", 2000);
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Kitchen: Mother goes right", bronanns_mother, 35, 19.9, false);
	event:AddEventLinkAtEnd("Kitchen: Mother looks down");
	EventManager:RegisterEvent(event);
	event = hoa_map.ChangeDirectionSpriteEvent("Kitchen: Mother looks down", bronanns_mother, hoa_map.MapMode.SOUTH);
	event:AddEventLinkAtEnd("Kitchen: Mother goes middle 2", 2000);
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Kitchen: Mother goes middle 2", bronanns_mother, 33.1, 19.9, false);
	event:AddEventLinkAtEnd("Kitchen: Mother goes up");
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Kitchen: Mother goes up", bronanns_mother, 33.1, 17.5, false);
	event:AddEventLinkAtEnd("Kitchen: Mother looks left 2");
	EventManager:RegisterEvent(event);
	event = hoa_map.ChangeDirectionSpriteEvent("Kitchen: Mother looks left 2", bronanns_mother, hoa_map.MapMode.WEST);
	event:AddEventLinkAtEnd("Kitchen: Mother goes middle", 2000);
	EventManager:RegisterEvent(event);
	-- The mother routine event
	EventManager:StartEvent("Kitchen: Mother goes middle");


	-- The Hero's first noble quest briefing...
	event = hoa_map.ScriptedSpriteEvent("Start Quest1", bronanns_mother, "StartQuest1", "");
	EventManager:RegisterEvent(event);

	event = hoa_map.ChangeDirectionSpriteEvent("Quest1: Mother looks south", bronanns_mother, hoa_map.MapMode.SOUTH);
	event:AddEventLinkAtEnd("Mother calls Bronann");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Bronann!");
	dialogue:AddLine(text, bronanns_mother);
	DialogueManager:AddDialogue(dialogue);

	event = hoa_map.DialogueEvent("Mother calls Bronann", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("SetCameraOnMother");
	event:AddEventLinkAtEnd("BronannLooksUp");
	EventManager:RegisterEvent(event);

	event = hoa_map.ChangeDirectionSpriteEvent("BronannLooksUp", bronann, hoa_map.MapMode.NORTH);
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedSpriteEvent("SetCameraOnMother", bronanns_mother, "Map_SetCamera", "");
	event:AddEventLinkAtEnd("ClearDialogueRefOnMother");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedSpriteEvent("ClearDialogueRefOnMother", bronanns_mother, "ClearDialogueReferences", "");
	event:AddEventLinkAtEnd("Mother moves near entrance1");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Mother moves near entrance1", bronanns_mother, 38, 20, false);
	event:AddEventLinkAtEnd("MotherLooksSouth2");
	EventManager:RegisterEvent(event);

	event = hoa_map.ChangeDirectionSpriteEvent("MotherLooksSouth2", bronanns_mother, hoa_map.MapMode.SOUTH);
	event:AddEventLinkAtEnd("Mother quest1 dialogue");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Now that you're *finally* up, could you go and buy some barley meal for us three?");
	dialogue:AddLine(text, bronanns_mother);
	text = hoa_system.Translate("Barley meal again?");
	dialogue:AddLineEmote(text, bronann, "sweat drop");
	text = hoa_system.Translate("Hmph, just go, boy. You'll be free after that, ok?");
	dialogue:AddLine(text, bronanns_mother);
	DialogueManager:AddDialogue(dialogue);

	event = hoa_map.DialogueEvent("Mother quest1 dialogue", dialogue);
	event:AddEventLinkAtEnd("Map_PopState");
	event:AddEventLinkAtEnd("SetQuest1DialogueDone");
	event:AddEventLinkAtEnd("SetCameraOnBronann");
	event:AddEventLinkAtEnd("Kitchen: Mother goes middle", 300);
	EventManager:RegisterEvent(event);

	-- Common events.
	-- Pop Map state
	event = hoa_map.ScriptedEvent("Map_PopState", "Map_PopState", "");
	EventManager:RegisterEvent(event);

	-- Set the opening dialogue as done
	event = hoa_map.ScriptedEvent("SetQuest1DialogueDone", "Quest1MotherStartDialogueDone", "");
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedSpriteEvent("SetCameraOnBronann", bronann, "Map_SetCamera", "");
	EventManager:RegisterEvent(event);
end


function _CreateObjects()
	object = {}

	object = CreateObject(Map, "Chair1", 48, 18);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Chair1_inverted", 40, 18);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Bench2", 44, 15.3);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Table1", 44, 19);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Barrel1", 31, 14);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Vase1", 31, 16);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Flower Pot1", 48.5, 11);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Flower Pot1", 31, 9);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	--lights
	object = CreateObject(Map, "Left Window Light 2", 31, 15);
	object:SetDrawOnSecondPass(true); -- Above any other ground object
	object:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Right Window Light 2", 49, 15);
	object:SetDrawOnSecondPass(true); -- Above any other ground object
	object:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	-- Turn the food and dishes are objects to permit the update of their visible status.
	plate_pile = CreateObject(Map, "Plate Pile1", 31, 22);
	if (plate_pile ~= nil) then Map:AddGroundObject(plate_pile) end;

	salad = CreateObject(Map, "Salad1", 31, 18);
	if (salad ~= nil) then Map:AddGroundObject(salad) end;
	green_pepper = CreateObject(Map, "Green Pepper1", 31, 20);
	if (green_pepper ~= nil) then Map:AddGroundObject(green_pepper) end;
	bread = CreateObject(Map, "Bread1", 31, 22);
	if (bread ~= nil) then Map:AddGroundObject(bread) end;
	sauce_pot = CreateObject(Map, "Sauce Pot1", 33, 22);
	if (sauce_pot ~= nil) then Map:AddGroundObject(sauce_pot) end;
	knife = CreateObject(Map, "Knife1", 35, 22);
	if (knife ~= nil) then Map:AddGroundObject(knife) end;
	_UpdateDishesAndFood();
end

-- Creates all events and sets up the entire event sequence chain
function _CreateEvents()
	local event = {};
	local text = {};
	local dialogue = {};

	-- Triggered Events
	event = hoa_map.MapTransitionEvent("to village", "dat/maps/layna_village/layna_village_center.lua", "from_bronanns_home");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Bronann's 1st floor", "dat/maps/layna_village/layna_village_bronanns_home_first_floor.lua", "from_bronanns_home");
	EventManager:RegisterEvent(event);

	-- Generic events
	event = hoa_map.ScriptedEvent("Audio:FadeOutMusic()", "Audio_FadeOutMusic", "");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedEvent("Audio:ResumeMusic()", "Audio_ResumeMusic", "");
	EventManager:RegisterEvent(event);

    -- Quest events

    -- End quest 1 (Barley meal retrieval) and prepare map for what's next.
    event = hoa_map.ScriptedEvent("Quest1: end and transition to after-dinner", "Quest1Done", "");
    event:AddEventLinkAtEnd("Quest1: Terminate mother and father events");
    EventManager:RegisterEvent(event);

    event = hoa_map.ScriptedEvent("Quest1: Terminate mother and father events", "TerminateMotherAndFatherEvents", "");
    event:AddEventLinkAtEnd("Fade out to after dinner");
    EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedEvent("Fade out to after dinner", "FadeOutToAfterDinner", "CheckFadeInOrOut");
    event:AddEventLinkAtEnd("Fade in to after dinner");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedEvent("Fade in to after dinner", "FadeInToAfterDinner", "CheckFadeInOrOut");
    event:AddEventLinkAtEnd("Quest2: Bronann is told not to leave town - part 1");
    event:AddEventLinkAtEnd("Quest2: Father looks west");
	EventManager:RegisterEvent(event);

    -- Quest 2 start: Bronann is told to not leave town
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Father looks west", bronanns_dad, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("Thanks for helping me out with the dishes.");
    dialogue:AddLine(text, bronanns_mother);
    text = hoa_system.Translate("Hmm, say, mom? Why is the village entrance blocked?");
    dialogue:AddLineEmote(text, bronann, "thinking dots");
    text = hoa_system.Translate("...");
    dialogue:AddLineEmote(text, bronanns_mother, "sweat drop");
    DialogueManager:AddDialogue(dialogue);
    event = hoa_map.DialogueEvent("Quest2: Bronann is told not to leave town - part 1", dialogue)
    -- Make a pause here
    event:AddEventLinkAtEnd("Quest2: Father looks south to think");
    event:AddEventLinkAtEnd("Audio:FadeOutMusic()");
    EventManager:RegisterEvent(event);

    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Father looks south to think", bronanns_dad, hoa_map.MapMode.SOUTH);
    event:AddEventLinkAtEnd("Quest2: Father looks at Bronann", 2000);
    EventManager:RegisterEvent(event);

    event = hoa_map.LookAtSpriteEvent("Quest2: Father looks at Bronann", bronanns_dad, bronann);
    event:AddEventLinkAtEnd("Quest2: Bronann is told not to leave town - part 2");
    EventManager:RegisterEvent(event);

    event = hoa_map.AnimateSpriteEvent("Quest2: Bronann looks at both parents", bronann, "searching", 1000);
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("Bronann, I'd like you to not go outside today.");
    dialogue:AddLine(text, bronanns_dad);
    text = hoa_system.Translate("Huh?! Why? You told me I could go into the forest and...");
    dialogue:AddLineEmote(text, bronann, "exclamation");
    text = hoa_system.Translate("Sorry, son. It's maybe a bit early, but I'd like you to be careful.");
    dialogue:AddLine(text, bronanns_dad);
    text = hoa_system.Translate("Hey, wait! All of the elders in the village are on their nerves. There is something going on here! Why won't you tell me?");
    dialogue:AddLineEventEmote(text, bronann, "", "Quest2: Bronann looks at both parents", "interrogation");
    text = hoa_system.Translate("None of you?");
    dialogue:AddLine(text, bronann);
    text = hoa_system.Translate("You really won't tell me?");
    dialogue:AddLineEmote(text, bronann, "exclamation");
    text = hoa_system.Translate("... It's not that simple, Bronann. Believe me.");
    dialogue:AddLineEmote(text, bronanns_dad, "thinking dots");
    DialogueManager:AddDialogue(dialogue);
    event = hoa_map.DialogueEvent("Quest2: Bronann is told not to leave town - part 2", dialogue)
    event:AddEventLinkAtEnd("Quest2: Mother looks at Bronann", 2000);
    EventManager:RegisterEvent(event);

    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Mother looks at Bronann", bronanns_mother, hoa_map.MapMode.NORTH);
    event:AddEventLinkAtEnd("Quest2: Bronann is told not to leave town - part 3");
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("Bronann, this time I want you to listen to your father very carefully. Please, my dear.");
    dialogue:AddLine(text, bronanns_mother);
    text = hoa_system.Translate("But mom!");
    dialogue:AddLine(text, bronann);
    text = hoa_system.Translate("Bronann, please.");
    dialogue:AddLine(text, bronanns_dad);
    text = hoa_system.Translate("(grumble)... Crap!");
    dialogue:AddLineEmote(text, bronann, "exclamation");
    DialogueManager:AddDialogue(dialogue);
    event = hoa_map.DialogueEvent("Quest2: Bronann is told not to leave town - part 3", dialogue);
    event:AddEventLinkAtEnd("Quest2: Bronann is frustrated");
    EventManager:RegisterEvent(event);

    event = hoa_map.AnimateSpriteEvent("Quest2: Bronann is frustrated", bronann, "hero_stance", 1000);
    event:AddEventLinkAtEnd("Quest2: Bronann runs out of the house");
    EventManager:RegisterEvent(event);

    -- Make Bronann leave house
    event = hoa_map.PathMoveSpriteEvent("Quest2: Bronann runs out of the house", bronann, 40, 24.5, true);
    event:AddEventLinkAtEnd("Quest2: Bronann disappears after running out of the house");
    EventManager:RegisterEvent(event);

    event = hoa_map.ScriptedSpriteEvent("Quest2: Bronann disappears after running out of the house", bronann, "MakeInvisible", "");
    event:AddEventLinkAtEnd("Quest2: Bronann is told not to leave town - part 4", 2000);
    event:AddEventLinkAtEnd("Quest2: Mother looks at father", 1000);
    event:AddEventLinkAtEnd("Quest2: SetCamera on mother", 1000);
    event:AddEventLinkAtEnd("Quest2: Father looks at mother", 2000);
    EventManager:RegisterEvent(event);

    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Father looks at mother", bronanns_dad, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Mother looks at father", bronanns_mother, hoa_map.MapMode.EAST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ScriptedSpriteEvent("Quest2: SetCamera on mother", bronanns_mother, "Map_SetCamera", "");
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("Maybe we should tell him...");
    dialogue:AddLine(text, bronanns_mother);
    text = hoa_system.Translate("It's too early, darling. We might be wrong.");
    dialogue:AddLineEmote(text, bronanns_dad, "thinking dots");
    text = hoa_system.Translate("I really hope we are...");
    dialogue:AddLine(text, bronanns_dad);
    DialogueManager:AddDialogue(dialogue);
    event = hoa_map.DialogueEvent("Quest2: Bronann is told not to leave town - part 4", dialogue);
    event:AddEventLinkAtEnd("Map_PopState");
    event:AddEventLinkAtEnd("to village");
    EventManager:RegisterEvent(event);
end

-- zones
local home_exit_zone = {};
local to_bronanns_room_zone = {};

function _CreateZones()
	-- N.B.: left, right, top, bottom
	home_exit_zone = hoa_map.CameraZone(38, 41, 24, 25, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(home_exit_zone);

	to_bronanns_room_zone = hoa_map.CameraZone(44, 47, 8, 9, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_bronanns_room_zone);

	quest2_start_scene = false;
end

function _CheckZones()
	-- Don't check that zone when dealing with the quest 2 start scene.
	if (quest2_start_scene == false and home_exit_zone:IsCameraEntering() == true) then
		-- Prevent Bronann from exiting until his mother talked to him
		if (GlobalManager:DoesEventExist("bronanns_home", "quest1_mother_start_dialogue_done") == false) then
			Map:PushState(hoa_map.MapMode.STATE_SCENE);
			EventManager:StartEvent("Start Quest1");
		else
			EventManager:StartEvent("to village");
			AudioManager:PlaySound("snd/door_open2.wav");
		end
	end
	if (to_bronanns_room_zone:IsCameraEntering() == true) then
		EventManager:StartEvent("to Bronann's 1st floor");
	end
end


-- Internal Custom functions
function _UpdateDishesAndFood()
        if (GlobalManager:DoesEventExist("story", "Quest2_started") == true) then
		-- Show the plate pile, hide the rest
		plate_pile:SetVisible(true);
		plate_pile:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);

		salad:SetVisible(false);
		salad:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
		green_pepper:SetVisible(false);
		green_pepper:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
		bread:SetVisible(false);
		bread:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
		sauce_pot:SetVisible(false);
		sauce_pot:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
		knife:SetVisible(false);
		knife:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	else
		-- Show the food, hide the plate pile
		plate_pile:SetVisible(false);
		plate_pile:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);

		salad:SetVisible(true);
		salad:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
		green_pepper:SetVisible(true);
		green_pepper:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
		bread:SetVisible(true);
		bread:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
		sauce_pot:SetVisible(true);
		sauce_pot:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
		knife:SetVisible(true);
		knife:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
	end
end

function _UpdateMotherDialogue()
	bronanns_mother:ClearDialogueReferences();

    if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == true) then
		local dialogue = hoa_map.SpriteDialogue();
		local text = hoa_system.Translate("Promise me you'll be careful, Bronann, ok?.");
		dialogue:AddLine(text, bronanns_mother);
		DialogueManager:AddDialogue(dialogue);
		bronanns_mother:AddDialogueReference(dialogue);
		return;
    end
    if (GlobalManager:DoesEventExist("story", "quest1_barley_meal_done") == true) then
        -- Got some barley meal, Mom!
		-- Begining dialogue
		local dialogue = hoa_map.SpriteDialogue();
		local text = hoa_system.Translate("Sigh... got it, mom!");
		dialogue:AddLine(text, bronann);
		text = hoa_system.Translate("Perfect timing, let's have dinner.");
		dialogue:AddLineEvent(text, bronanns_mother, "", "Quest1: end and transition to after-dinner");
		DialogueManager:AddDialogue(dialogue);
		bronanns_mother:AddDialogueReference(dialogue);
	elseif (GlobalManager:DoesEventExist("bronanns_home", "quest1_mother_start_dialogue_done") == true) then
		-- 1st quest dialogue
		local dialogue = hoa_map.SpriteDialogue();
		local text = hoa_system.Translate("Could you go and buy some barley meal for us three?");
		dialogue:AddLine(text, bronanns_mother);
		DialogueManager:AddDialogue(dialogue);
		bronanns_mother:AddDialogueReference(dialogue);
	elseif (GlobalManager:DoesEventExist("bronanns_home", "quest1_mother_start_dialogue_done") == false) then
		-- Begining dialogue
		local dialogue = hoa_map.SpriteDialogue();
		local text = hoa_system.Translate("Hi son, did you also have a nightmare last night?");
		dialogue:AddLine(text, bronanns_mother);
		text = hoa_system.Translate("Hi mom. Huh, how do you know...");
		dialogue:AddLineEmote(text, bronann, "interrogation");
		text = hoa_system.Translate("Eh eh? Have you already forgotten I'm your mother?");
		dialogue:AddLine(text, bronanns_mother);
		DialogueManager:AddDialogue(dialogue);
		bronanns_mother:AddDialogueReference(dialogue);
	else
		-- Last default dialogue
		local dialogue = hoa_map.SpriteDialogue();
		local text = hoa_system.Translate("Don't venture too far, I'll need your help quite soon!");
		dialogue:AddLine(text, bronanns_mother);
		DialogueManager:AddDialogue(dialogue);
		bronanns_mother:AddDialogueReference(dialogue);
	end
end


-- Map Custom functions
map_functions = {

	Map_PopState = function()
		Map:PopState();
	end,

	Map_SetCamera = function(sprite)
		Map:SetCamera(sprite, 800);
	end,

    Audio_FadeOutMusic = function()
        AudioManager:FadeOutAllMusic(2000);
    end,

    MakeInvisible = function(sprite)
        if (sprite ~= nil) then
            sprite:SetVisible(false);
            sprite:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        end
    end,

	ClearDialogueReferences = function(sprite)
		sprite:ClearDialogueReferences();
	end,

	StartQuest1 =  function(sprite)
		EventManager:TerminateAllEvents(sprite);
		sprite:SetMoving(false); -- in case she's moving
		EventManager:StartEvent("Quest1: Mother looks south");
	end,

	Quest1MotherStartDialogueDone = function()
		GlobalManager:SetEventValue("bronanns_home", "quest1_mother_start_dialogue_done", 1);
        _UpdateMotherDialogue();
        GlobalManager:AddQuestLog("get_barley");
	end,

    Quest1Done = function()
        GlobalManager:SetEventValue("story", "Quest1_done", 1);
    end,

    TerminateMotherAndFatherEvents = function()
        -- Start scene
        Map:PushState(hoa_map.MapMode.STATE_SCENE);
        -- Stop everyone
        bronanns_dad:SetMoving(false);
        bronanns_dad:ClearDialogueReferences();
        EventManager:TerminateAllEvents(bronanns_dad);
        bronanns_mother:SetMoving(false);
        bronanns_mother:ClearDialogueReferences();
        EventManager:TerminateAllEvents(bronanns_mother);

        bronann:SetMoving(false);
    end,

    FadeOutToAfterDinner = function()
        VideoManager:FadeScreen(hoa_video.Color(0.0, 0.0, 0.0, 1.0), 1000);
    end,

    CheckFadeInOrOut = function()
        if (VideoManager:IsFading() == true) then
            return false;
        end
        return true;
    end,

    FadeInToAfterDinner = function()
        -- Place characters
        bronann:SetPosition(41.5, 15.0);
        bronann:SetDirection(hoa_map.MapMode.SOUTH);

        bronanns_mother:SetPosition(40, 19);
        bronanns_mother:SetDirection(hoa_map.MapMode.EAST);
        bronanns_dad:SetPosition(48, 19);
        bronanns_dad:SetDirection(hoa_map.MapMode.WEST);

        -- Remove the barley meal key item from inventory
        local barley_meal_item_id = 70002;
        if (GlobalManager:IsObjectInInventory(barley_meal_item_id) == true) then
            GlobalManager:RemoveFromInventory(barley_meal_item_id);
        end

        -- Set the quest 2 as started
        GlobalManager:SetEventValue("story", "Quest2_started", 1);
        GlobalManager:AddQuestLog("wants_to_go_into_the_forest");
        -- Make the food and dishes not appear anymore, once the dinner is done.
        _UpdateDishesAndFood();

        VideoManager:FadeIn(1000);

        -- Flag used to disable the warp zone temporarily
        quest2_start_scene = true;
    end
}
