# *** This file is generated by InstructionParser ***

module Rubinius
  module GeneratorMethods
      def noop
        @stream << 0
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 0
      end

      def push_nil
        @stream << 1
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 1
      end

      def push_true
        @stream << 2
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 2
      end

      def push_false
        @stream << 3
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 3
      end

      def push_int(arg1)
        if arg1 > 2 and arg1 < 256
          @stream << 4 << arg1
          @current_block.add_stack(0, 1)
          @ip += 2
          @instruction = 4
        else
          case arg1
          when -1
            meta_push_neg_1
          when 0
            meta_push_0
          when 1
            meta_push_1
          when 2
            meta_push_2
          else
            push_literal arg1
          end
        end
      end

      def push_self
        @stream << 5
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 5
      end

      def set_literal(arg1)
        @stream << 6 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 6
      end

      def emit_push_literal(arg1)
        @stream << 7 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 7
      end

      def goto(arg1)
        location = @ip + 1
        @stream << 8 << arg1
        @ip += 2
        arg1.used_at location
        @current_block.add_stack(0, 0)
        @current_block.left = arg1.basic_block
        @current_block.close
        @current_block = new_basic_block
        @instruction = 8
      end

      def goto_if_false(arg1)
        location = @ip + 1
        @stream << 9 << arg1
        @ip += 2
        arg1.used_at location
        @current_block.add_stack(1, 0)
        @current_block.left = arg1.basic_block
        @current_block.close
        block = new_basic_block
        @current_block.right = block
        @current_block = block
        @instruction = 9
      end

      def goto_if_true(arg1)
        location = @ip + 1
        @stream << 10 << arg1
        @ip += 2
        arg1.used_at location
        @current_block.add_stack(1, 0)
        @current_block.left = arg1.basic_block
        @current_block.close
        block = new_basic_block
        @current_block.right = block
        @current_block = block
        @instruction = 10
      end

      def ret
        @stream << 11
        @ip += 1
        @current_block.add_stack(1, 1)
        @current_block.close true
        @current_block = new_basic_block
        @instruction = 11
      end

      def swap_stack
        @stream << 12
        @ip += 1
        @current_block.add_stack(2, 2)
        @instruction = 12
      end

      def dup_top
        @stream << 13
        @ip += 1
        @current_block.add_stack(1, 2)
        @instruction = 13
      end

      def dup_many(arg1)
        @stream << 14 << arg1
        @ip += 2
        @current_block.add_stack(arg1, (arg1 * 2))
        @instruction = 14
      end

      def pop
        @stream << 15
        @ip += 1
        @current_block.add_stack(1, 0)
        @instruction = 15
      end

      def pop_many(arg1)
        @stream << 16 << arg1
        @ip += 2
        @current_block.add_stack(arg1, 0)
        @instruction = 16
      end

      def rotate(arg1)
        @stream << 17 << arg1
        @ip += 2
        @current_block.add_stack(arg1, (arg1 * 1))
        @instruction = 17
      end

      def move_down(arg1)
        @stream << 18 << arg1
        @ip += 2
        @current_block.add_stack(arg1, (arg1 * 1))
        @instruction = 18
      end

      def set_local(arg1)
        @stream << 19 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 19
      end

      def push_local(arg1)
        @stream << 20 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 20
      end

      def push_local_depth(arg1, arg2)
        @stream << 21 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(0, 1)
        @instruction = 21
      end

      def set_local_depth(arg1, arg2)
        @stream << 22 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(1, 1)
        @instruction = 22
      end

      def passed_arg(arg1)
        @stream << 23 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 23
      end

      def push_current_exception
        @stream << 24
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 24
      end

      def clear_exception
        @stream << 25
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 25
      end

      def push_exception_state
        @stream << 26
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 26
      end

      def restore_exception_state
        @stream << 27
        @ip += 1
        @current_block.add_stack(1, 0)
        @instruction = 27
      end

      def raise_exc
        @stream << 28
        @ip += 1
        @current_block.add_stack(1, 0)
        @current_block.close false
        @current_block = new_basic_block
        @instruction = 28
      end

      def setup_unwind(arg1, arg2)
        location = @ip + 1
        @stream << 29 << arg1 << arg2
        @ip += 3
        arg1.used_at location
        @current_block.add_stack(0, 0)
        @current_block.left = arg1.basic_block
        @current_block.close
        block = new_basic_block
        @current_block.right = block
        @current_block = block
        @instruction = 29
      end

      def pop_unwind
        @stream << 30
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 30
      end

      def raise_return
        @stream << 31
        @ip += 1
        @current_block.add_stack(1, 1)
        @current_block.close true
        @current_block = new_basic_block
        @instruction = 31
      end

      def ensure_return
        @stream << 32
        @ip += 1
        @current_block.add_stack(1, 1)
        @current_block.close true
        @current_block = new_basic_block
        @instruction = 32
      end

      def raise_break
        @stream << 33
        @ip += 1
        @current_block.add_stack(1, 1)
        @current_block.close false
        @current_block = new_basic_block
        @instruction = 33
      end

      def reraise
        @stream << 34
        @ip += 1
        @current_block.add_stack(0, 0)
        @current_block.close false
        @current_block = new_basic_block
        @instruction = 34
      end

      def make_array(arg1)
        @stream << 35 << arg1
        @ip += 2
        @current_block.add_stack(arg1, 1)
        @instruction = 35
      end

      def cast_array
        unless @instruction == 36 or @instruction == 35
          @stream << 36
          @ip += 1
        end
        @instruction = 36
      end

      def shift_array
        @stream << 37
        @ip += 1
        @current_block.add_stack(1, 2)
        @instruction = 37
      end

      def set_ivar(arg1)
        arg1 = find_literal arg1
        @stream << 38 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 38
      end

      def push_ivar(arg1)
        arg1 = find_literal arg1
        @stream << 39 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 39
      end

      def set_const(arg1)
        @stream << 41 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 41
      end

      def set_const_at(arg1)
        @stream << 42 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 42
      end

      def find_const(arg1)
        arg1 = find_literal arg1
        @stream << 43 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 43
      end

      def push_cpath_top
        @stream << 44
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 44
      end

      def push_const_fast(arg1, arg2)
        @stream << 45 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(0, 1)
        @instruction = 45
      end

      def set_call_flags(arg1)
        @stream << 46 << arg1
        @ip += 2
        @current_block.add_stack(0, 0)
        @instruction = 46
      end

      def allow_private
        @stream << 47
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 47
      end

      def send_method(arg1)
        @stream << 48 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 48
      end

      def send_stack(arg1, arg2)
        @stream << 49 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+1, 1)
        @instruction = 49
      end

      def send_stack_with_block(arg1, arg2)
        @stream << 50 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+2, 1)
        @instruction = 50
      end

      def send_stack_with_splat(arg1, arg2)
        @stream << 51 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+3, 1)
        @instruction = 51
      end

      def send_super_stack_with_block(arg1, arg2)
        @stream << 52 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+1, 1)
        @instruction = 52
      end

      def send_super_stack_with_splat(arg1, arg2)
        @stream << 53 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+2, 1)
        @instruction = 53
      end

      def push_block
        @stream << 54
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 54
      end

      def passed_blockarg(arg1)
        @stream << 55 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 55
      end

      def create_block(arg1)
        arg1 = add_literal arg1
        @generators << arg1
        @stream << 56 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 56
      end

      def cast_for_single_block_arg
        @stream << 57
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 57
      end

      def cast_for_multi_block_arg
        @stream << 58
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 58
      end

      def cast_for_splat_block_arg
        @stream << 59
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 59
      end

      def yield_stack(arg1)
        @stream << 60 << arg1
        @ip += 2
        @current_block.add_stack(arg1, 1)
        @instruction = 60
      end

      def yield_splat(arg1)
        @stream << 61 << arg1
        @ip += 2
        @current_block.add_stack(arg1+1, 1)
        @instruction = 61
      end

      def string_append
        @stream << 62
        @ip += 1
        @current_block.add_stack(2, 1)
        @instruction = 62
      end

      def string_build(arg1)
        @stream << 63 << arg1
        @ip += 2
        @current_block.add_stack(arg1, 1)
        @instruction = 63
      end

      def string_dup
        @stream << 64
        @ip += 1
        @current_block.add_stack(1, 1)
        @instruction = 64
      end

      def push_scope
        @stream << 65
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 65
      end

      def add_scope
        @stream << 66
        @ip += 1
        @current_block.add_stack(1, 0)
        @instruction = 66
      end

      def push_variables
        @stream << 67
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 67
      end

      def check_interrupts
        @stream << 68
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 68
      end

      def yield_debugger
        @stream << 69
        @ip += 1
        @current_block.add_stack(0, 0)
        @instruction = 69
      end

      def is_nil
        @stream << 70
        @ip += 1
        @current_block.add_stack(1, 1)
        @instruction = 70
      end

      def check_serial(arg1, arg2)
        arg1 = find_literal arg1
        arg2 = Integer(arg2)
        @stream << 71 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(1, 1)
        @instruction = 71
      end

      def check_serial_private(arg1, arg2)
        arg1 = find_literal arg1
        arg2 = Integer(arg2)
        @stream << 72 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(1, 1)
        @instruction = 72
      end

      def push_my_field(arg1)
        @stream << 73 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 73
      end

      def store_my_field(arg1)
        @stream << 74 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 74
      end

      def kind_of
        @stream << 75
        @ip += 1
        @current_block.add_stack(2, 1)
        @instruction = 75
      end

      def instance_of
        @stream << 76
        @ip += 1
        @current_block.add_stack(2, 1)
        @instruction = 76
      end

      def meta_push_neg_1
        @stream << 77
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 77
      end

      def meta_push_0
        @stream << 78
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 78
      end

      def meta_push_1
        @stream << 79
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 79
      end

      def meta_push_2
        @stream << 80
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 80
      end

      def meta_send_op_plus(arg1)
        @stream << 81 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 81
      end

      def meta_send_op_minus(arg1)
        @stream << 82 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 82
      end

      def meta_send_op_equal(arg1)
        @stream << 83 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 83
      end

      def meta_send_op_lt(arg1)
        @stream << 84 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 84
      end

      def meta_send_op_gt(arg1)
        @stream << 85 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 85
      end

      def meta_send_op_tequal(arg1)
        @stream << 86 << arg1
        @ip += 2
        @current_block.add_stack(2, 1)
        @instruction = 86
      end

      def meta_send_call(arg1, arg2)
        @stream << 87 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+1, 1)
        @instruction = 87
      end

      def push_my_offset(arg1)
        @stream << 88 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 88
      end

      def zsuper(arg1)
        arg1 = find_literal arg1
        @stream << 89 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 89
      end

      def push_block_arg
        @stream << 90
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 90
      end

      def push_undef
        @stream << 91
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 91
      end

      def push_stack_local(arg1)
        @stream << 92 << arg1
        @ip += 2
        @current_block.add_stack(0, 1)
        @instruction = 92
      end

      def set_stack_local(arg1)
        @stream << 93 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 93
      end

      def push_has_block
        @stream << 94
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 94
      end

      def push_proc
        @stream << 95
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 95
      end

      def check_frozen
        @stream << 96
        @ip += 1
        @current_block.add_stack(1, 1)
        @instruction = 96
      end

      def cast_multi_value
        @stream << 97
        @ip += 1
        @current_block.add_stack(1, 1)
        @instruction = 97
      end

      def invoke_primitive(arg1, arg2)
        arg1 = find_literal arg1
        arg2 = Integer(arg2)
        @stream << 98 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2, 1)
        @instruction = 98
      end

      def push_rubinius
        @stream << 99
        @ip += 1
        @current_block.add_stack(0, 1)
        @instruction = 99
      end

      def call_custom(arg1, arg2)
        arg1 = find_literal arg1
        arg2 = Integer(arg2)
        @stream << 100 << arg1 << arg2
        @ip += 3
        @current_block.add_stack(arg2+1, 1)
        @instruction = 100
      end

      def meta_to_s(arg1)
        @stream << 101 << arg1
        @ip += 2
        @current_block.add_stack(1, 1)
        @instruction = 101
      end

  end
end
