/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.ffmpegnative;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sourceforge.jffmpeg.CodecManager;
import net.sourceforge.jffmpeg.JMFCodec;

public class NativeDecoder
implements JMFCodec {
    private boolean opened;
    private Format[] inputFormats = new Format[]{new VideoFormat("h263"), new VideoFormat("h263/rtp"), new VideoFormat("mpeg"), new VideoFormat("mpeg video"), new VideoFormat("DIV3"), new VideoFormat("DIVX"), new VideoFormat("MP42"), new VideoFormat("MPG4"), new VideoFormat("WMV1"), new VideoFormat("WMV2"), new VideoFormat("MJPG")};
    private Format[] outputFormats = new Format[]{new YUVFormat(2), new RGBFormat()};
    private Format inputFormat = null;
    private Format outputFormat = null;
    private static final String PLUGIN_NAME = "FFMPEG Decoder";
    private static final int DEF_WIDTH = 352;
    private static final int DEF_HEIGHT = 288;
    private static final int INPUT_BUFFER_PADDING_SIZE = 8;
    private int inputH263Length;
    private int outputLength;
    private static final int MAX_PAYLOAD_SIZE = 2048;
    private String encoding;
    private Dimension videoSize;
    protected boolean resetRequired = false;
    private boolean rtpActive = false;
    private boolean truncatedFlag = false;
    private long seqNum = 0L;
    private long frameNum = 0L;
    private long timestamp = 0L;
    private float frameRate = 0.0f;
    private boolean yuv2rgb = false;
    private int depth;
    private int rMask;
    private int gMask;
    private int bMask;
    public int peer = 0;
    private static boolean nativeLibraryLoaded = false;
    private boolean quirkIncompatibleBuffering = false;
    private byte[] leftOver = null;
    private long lastTime = 10L;
    private int frames = 0;

    private native boolean open_decoder(String var1, boolean var2, boolean var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean close_decoder(int var1);

    private native int convert(int var1, Object var2, int var3, int var4, int var5, Object var6, int var7, int var8);

    private native float extractFrameRate(int var1);

    public boolean isCodecAvailable() {
        return nativeLibraryLoaded;
    }

    public void setYuv2rgb(boolean bl) {
        this.yuv2rgb = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setVideoSize(Dimension dimension) {
        this.videoSize = dimension;
    }

    public void setIsRtp(boolean bl) {
        this.rtpActive = bl;
    }

    public void setIsTruncated(boolean bl) {
        this.truncatedFlag = bl;
    }

    public Format setOutputFormat(Format format) {
        Dimension dimension;
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension2 = videoFormat.getSize();
        if (dimension2 == null) {
            dimension = this.videoSize;
            dimension2 = dimension == null ? new Dimension(352, 288) : dimension;
        }
        if (format instanceof YUVFormat) {
            this.yuv2rgb = false;
            dimension = (YUVFormat)format;
            if (dimension.getYuvType() != 2) {
                return null;
            }
            if (dimension.getOffsetU() > dimension.getOffsetV()) {
                return null;
            }
            int n = dimension2.width;
            int n2 = n / 2;
            int n3 = n * dimension2.height;
            int n4 = n3 + n2 * dimension2.height / 2;
            this.outputLength = dimension2.width * dimension2.height * 3 / 2;
            this.outputFormat = new YUVFormat(dimension2, this.outputLength, Format.byteArray, videoFormat.getFrameRate(), 2, n, n2, 0, n3, n4);
        } else if (format instanceof RGBFormat) {
            this.yuv2rgb = true;
            dimension = (RGBFormat)format;
            int n = dimension.getBitsPerPixel();
            Class clazz = dimension.getDataType();
            int n5 = 1;
            switch (n) {
                case 15: 
                case 16: {
                    if (clazz != Format.byteArray && clazz != Format.shortArray) {
                        return null;
                    }
                    if (clazz != Format.byteArray) break;
                    n5 = 2;
                    break;
                }
                case 24: {
                    if (clazz != Format.byteArray) {
                        return null;
                    }
                    n5 = 3;
                    break;
                }
                case 32: {
                    if (clazz != Format.byteArray && clazz != Format.intArray) {
                        return null;
                    }
                    if (clazz != Format.byteArray) break;
                    n5 = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (clazz == Format.byteArray) {
                this.rMask = 255 << (dimension.getRedMask() - 1) * 8;
                this.gMask = 255 << (dimension.getGreenMask() - 1) * 8;
                this.bMask = 255 << (dimension.getBlueMask() - 1) * 8;
            } else {
                this.rMask = dimension.getRedMask();
                this.gMask = dimension.getGreenMask();
                this.bMask = dimension.getBlueMask();
            }
            this.depth = n;
            int n6 = (n + 7) / 8;
            this.outputLength = dimension2.width * dimension2.height * n6;
            this.outputFormat = new RGBFormat(dimension2, this.outputLength, clazz, videoFormat.getFrameRate(), n, dimension.getRedMask(), dimension.getGreenMask(), dimension.getBlueMask(), n5, dimension2.width * n5, 0, -1);
        } else {
            return null;
        }
        return this.outputFormat;
    }

    public float getFrameRate(int n) {
        if (this.frameRate <= 0.0f) {
            this.frameRate = this.extractFrameRate(n);
        }
        return this.frameRate;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        int n2;
        buffer2.setFlags(buffer.getFlags());
        if ((buffer.getFlags() & 0x40) == 0) {
            if (this.lastTime != buffer.getTimeStamp()) {
                this.lastTime = buffer.getTimeStamp();
                this.frames = 0;
            } else {
                buffer2.setFlags(buffer.getFlags() | 0x100 | 0x20);
            }
            float f = ((VideoFormat)buffer.getFormat()).getFrameRate();
            if (f <= 0.0f) {
                f = this.getFrameRate(this.peer);
            }
            buffer2.setTimeStamp(buffer.getTimeStamp() + (long)(1.0E9f / f) * (long)this.frames);
        }
        if (this.quirkIncompatibleBuffering && this.leftOver != null) {
            byte[] byArray = new byte[this.leftOver.length + buffer.getLength()];
            System.arraycopy(this.leftOver, 0, byArray, 0, this.leftOver.length);
            byte[] byArray2 = (byte[])buffer.getData();
            System.arraycopy(byArray2, buffer.getOffset(), byArray, this.leftOver.length, buffer.getLength());
            buffer.setData((Object)byArray);
            buffer.setOffset(0);
            buffer.setLength(byArray.length);
            this.leftOver = null;
        }
        if ((buffer.getFlags() & 1) != 0) {
            this.frames = 0;
            buffer2.setFlags(buffer2.getFlags() | 1);
            this.reset();
            return 0;
        }
        if (buffer.isDiscard()) {
            buffer2.setDiscard(true);
            this.reset();
            return 0;
        }
        Format format = buffer.getFormat();
        if (buffer.getLength() < 5) {
            buffer2.setDiscard(true);
            this.reset();
            return 0;
        }
        int n3 = buffer.getOffset();
        int n4 = buffer.getLength();
        byte[] byArray = (byte[])buffer.getData();
        int n5 = byArray.length;
        Object object = buffer.getData();
        long l = 0L;
        int[] nArray = (int[])buffer2.getData();
        if (nArray == null || nArray.length < this.outputLength || buffer2.getFormat() != this.outputFormat || !buffer2.getFormat().equals((Object)this.outputFormat)) {
            nArray = new int[this.outputLength];
            buffer2.setLength(this.outputLength);
            buffer2.setFormat(this.outputFormat);
            buffer2.setData((Object)nArray);
        }
        long l2 = 0L;
        if (this.rtpActive) {
            n2 = buffer.getFlags() & 0x800;
            if (this.seqNum == 0L) {
                this.seqNum = buffer.getSequenceNumber();
            }
            if (this.seqNum != buffer.getSequenceNumber() && buffer.getTimeStamp() > 0L && this.timestamp > 0L && this.timestamp != buffer.getTimeStamp() && (n = this.convert(this.peer, object, 0, 0, 0, nArray, this.outputLength, 0)) > 0) {
                buffer2.setOffset(0);
                buffer2.setLength(this.outputLength);
                ++this.frameNum;
                this.seqNum = buffer.getSequenceNumber();
                return 2;
            }
            this.timestamp = buffer.getTimeStamp();
            this.seqNum = buffer.getSequenceNumber();
        } else {
            n2 = 1;
        }
        n = this.convert(this.peer, object, n5, n3, n4, nArray, this.outputLength, n2);
        if (n > 0) {
            buffer.setOffset(n3 + n);
            buffer.setLength(n4 - n);
        }
        if (n < 0) {
            ++this.seqNum;
            return 1;
        }
        if (n == 0) {
            if (this.quirkIncompatibleBuffering) {
                this.leftOver = new byte[n4];
                System.arraycopy(object, n3, this.leftOver, 0, n4);
            }
            ++this.frames;
            return 0;
        }
        if (n2 == 0) {
            ++this.seqNum;
            buffer2.setDiscard(true);
            ++this.frames;
            return 0;
        }
        buffer2.setOffset(0);
        buffer2.setLength(this.outputLength);
        ++this.seqNum;
        ++this.frameNum;
        if (this.resetRequired && this.opened) {
            this.reset();
        }
        ++this.frames;
        if (buffer.getLength() > 0) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() throws ResourceUnavailableException {
        if (!this.opened) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.outputFormat == null) {
                    throw new ResourceUnavailableException("No output format selected");
                }
                Dimension dimension = this.videoSize;
                if (!this.open_decoder(this.encoding, this.rtpActive, this.truncatedFlag, this.yuv2rgb, this.depth, this.rMask, this.gMask, this.bMask, (int)dimension.getWidth(), (int)dimension.getHeight())) {
                    throw new ResourceUnavailableException("Couldn't open codec for " + this.encoding);
                }
            }
            this.resetRequired = false;
        }
    }

    public synchronized void close() {
        if (this.opened) {
            this.close_decoder(this.peer);
        }
    }

    public synchronized void reset() {
        this.frames = 0;
        if (this.resetRequired && this.opened) {
            try {
                this.close();
                this.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    private boolean isRTPFormat(Format format) {
        return format.getEncoding().equals("h263/rtp");
    }

    public Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n = dimension.width;
        int n2 = n / 2;
        int n3 = n * dimension.height;
        int n4 = n3 + n2 * dimension.height / 2;
        VideoFormat[] videoFormatArray = new VideoFormat[]{new YUVFormat(dimension, (n + n2) * dimension.height, Format.byteArray, videoFormat.getFrameRate(), 2, n, n2, 0, n3, n4), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 15, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, -1, -1, -1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, videoFormat.getFrameRate(), 32, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 31744, 992, 31, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 63488, 992, 31, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, dimension.width, 0, -1)};
        return videoFormatArray;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return null;
    }

    static {
        CodecManager codecManager = new CodecManager();
        String string = codecManager.getNativeLibraryName();
        if (string == null) {
            string = "jffmpeg";
        }
        try {
            System.loadLibrary(string);
            nativeLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            nativeLibraryLoaded = false;
        }
    }
}

