/*
 * Decompiled with CFR 0.152.
 */
package railo.commons.io.res;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import railo.commons.io.res.ResourceProvider;
import railo.commons.io.res.filter.ResourceFilter;
import railo.commons.io.res.filter.ResourceNameFilter;

public interface Resource
extends Serializable {
    public static final short ATTRIBUTE_HIDDEN = 1;
    public static final short ATTRIBUTE_SYSTEM = 2;
    public static final short ATTRIBUTE_ARCHIVE = 4;

    public boolean isReadable();

    public boolean canRead();

    public boolean isWriteable();

    public boolean canWrite();

    public void remove(boolean var1) throws IOException;

    public boolean delete();

    public boolean exists();

    public Resource getAbsoluteResource();

    public String getAbsolutePath();

    public Resource getCanonicalResource() throws IOException;

    public String getCanonicalPath() throws IOException;

    public String getName();

    public String getParent();

    public Resource getParentResource();

    public String getReal(String var1);

    public Resource getRealResource(String var1);

    public String getPath();

    public boolean isAbsolute();

    public boolean isDirectory();

    public boolean isFile();

    public boolean isHidden();

    public boolean isArchive();

    public boolean isSystem();

    public long lastModified();

    public long length();

    public String[] list();

    public String[] list(ResourceNameFilter var1);

    public String[] list(ResourceFilter var1);

    public Resource[] listResources();

    public Resource[] listResources(ResourceFilter var1);

    public Resource[] listResources(ResourceNameFilter var1);

    public boolean renameTo(Resource var1);

    public void moveTo(Resource var1) throws IOException;

    public boolean setLastModified(long var1);

    public boolean setReadOnly();

    public boolean setWritable(boolean var1);

    public boolean setReadable(boolean var1);

    public boolean createNewFile();

    public void createFile(boolean var1) throws IOException;

    public boolean mkdir();

    public boolean mkdirs();

    public void createDirectory(boolean var1) throws IOException;

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public void copyTo(Resource var1, boolean var2) throws IOException;

    public void copyFrom(Resource var1, boolean var2) throws IOException;

    public OutputStream getOutputStream(boolean var1) throws IOException;

    public ResourceProvider getResourceProvider();

    public int getMode();

    public void setMode(int var1) throws IOException;

    public void setHidden(boolean var1) throws IOException;

    public void setSystem(boolean var1) throws IOException;

    public void setArchive(boolean var1) throws IOException;

    public void setAttribute(short var1, boolean var2) throws IOException;

    public boolean getAttribute(short var1);
}

