/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLStylesheet;

public class VariableTable {
    private static final int SIZE = 10;
    private int classID = -1;
    private int methodID = -1;
    private XSLStylesheet xss;
    private int offset;
    private int argCnt = this.offset = 3;
    private int slots = 0;
    private long[] codeIndex;
    private String[] name;
    private String[] signature;
    private int[] length;
    private int[] slot;
    private int size;

    public VariableTable(int n, int n2, XSLStylesheet xSLStylesheet) {
        this.init(n, n2, xSLStylesheet);
    }

    public VariableTable(int n, int n2, XSLStylesheet xSLStylesheet, int n3) {
        this.init(n, n2, xSLStylesheet);
        int n4 = this.offset - 3;
        this.codeIndex[n4] = n3;
        this.name[n4] = "$contextPosition";
        this.signature[n4] = "I";
        ++this.slots;
        this.codeIndex[++n4] = n3;
        this.name[n4] = "$contextSize";
        this.signature[n4] = "I";
        ++this.slots;
        this.codeIndex[++n4] = n3;
        this.name[n4] = "$contextNode";
        this.signature[n4] = "L$oracle/xml/xslt/XMLNode;";
        ++this.slots;
        this.codeIndex[3] = n3;
        this.name[3] = "$matchPattern";
        this.signature[3] = "L$oracle/xml/xslt/XMLString;";
        ++this.slots;
    }

    private void init(int n, int n2, XSLStylesheet xSLStylesheet) {
        this.classID = n;
        this.methodID = n2;
        this.xss = xSLStylesheet;
        this.codeIndex = new long[10];
        this.name = new String[10];
        this.signature = new String[10];
        this.length = new int[10];
        this.slot = new int[10];
        this.size = 10;
    }

    int getClassID() {
        return this.classID;
    }

    int getMethodID() {
        return this.methodID;
    }

    void setMethodID(int n) {
        this.methodID = n;
    }

    public int getArgCnt() {
        return this.argCnt;
    }

    public int getSlots() {
        return this.slots;
    }

    public long[] getCodeIndex() {
        return this.codeIndex;
    }

    public String[] getName() {
        return this.name;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public int[] getLength() {
        return this.length;
    }

    public int[] getSlot() {
        return this.slot;
    }

    void setSignaturesAndArgCnt() {
        LinkedList linkedList = null;
        if (this.xss.getFrameValues() == null || this.xss.getFrameValues().size() <= 0) {
            return;
        }
        linkedList = (LinkedList)this.xss.getFrameValues().getLast();
        if (linkedList != null) {
            int n = linkedList.size();
            for (int i = 0; i < n; ++i) {
                OXMLSequence oXMLSequence = (OXMLSequence)linkedList.get(i);
                this.signature[i + this.offset] = XSLJDWPUtil.getJNISignature(oXMLSequence);
            }
            if (n > 0) {
                Integer n2 = (Integer)this.xss.getFrameParams().getLast();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (this.signature[i].equals("D")) {
                        n3 += 2;
                        continue;
                    }
                    ++n3;
                }
                this.argCnt += n3;
            }
        }
    }

    public void set(long l, String string) {
        if (this.slots == this.size) {
            this.size *= 2;
            long[] lArray = this.codeIndex;
            String[] stringArray = this.name;
            String[] stringArray2 = this.signature;
            int[] nArray = this.length;
            int[] nArray2 = this.slot;
            this.codeIndex = new long[this.size];
            this.name = new String[this.size];
            this.signature = new String[this.size];
            this.length = new int[this.size];
            this.slot = new int[this.size];
            System.arraycopy(lArray, 0, this.codeIndex, 0, this.size / 2);
            System.arraycopy(stringArray, 0, this.name, 0, this.size / 2);
            System.arraycopy(stringArray2, 0, this.signature, 0, this.size / 2);
            System.arraycopy(nArray, 0, this.length, 0, this.size / 2);
            System.arraycopy(nArray2, 0, this.slot, 0, this.size / 2);
        }
        this.codeIndex[this.slots] = l + 1L;
        this.name[this.slots] = string;
        this.signature[this.slots] = "L$oracle/xml/xslt/XMLString;";
        this.slot[this.slots] = this.slots;
        ++this.slots;
    }

    public void setEndCodeIndex(long l) {
        int n = 0;
        while (n < this.slots) {
            this.length[n] = (int)(l - this.codeIndex[n]);
            int n2 = n++;
            this.length[n2] = this.length[n2] + 1;
        }
    }

    public void notifyEnd() {
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "VariableTable: " + this.classID + ":" + this.methodID + ":" + this.argCnt + ":" + this.slots);
        for (int i = 0; i < this.slots; ++i) {
            XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), this.codeIndex[i] + ":" + this.name[i] + ":" + this.signature[i] + ":" + this.length[i] + ":" + this.slot[i]);
        }
        this.xss.getJDWPMethod().makeVariableTable(this);
    }
}

