/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JacobReleaseInfo {
    private static String buildVersion = "";
    private static String buildDate = "";
    private static final String PROPERTY_FILE_NAME = "META-INF/JacobVersion.properties";

    private static void loadVersionProperties() {
        Properties versionProps = new Properties();
        InputStream stream = JacobReleaseInfo.class.getClassLoader().getResourceAsStream(PROPERTY_FILE_NAME);
        if (stream == null) {
            stream = JacobReleaseInfo.class.getClassLoader().getResourceAsStream("/META-INF/JacobVersion.properties");
        }
        if (stream == null) {
            throw new IllegalStateException("Can't find META-INF/JacobVersion.properties using JacobReleaseInfo.class.getClassLoader().getResourceAsStream()");
        }
        try {
            versionProps.load(stream);
            stream.close();
            buildVersion = (String)versionProps.get("version");
            buildDate = (String)versionProps.get("build.date");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Warning! Couldn't load props " + ioe);
        }
    }

    public static String getBuildDate() {
        if (buildDate.equals("")) {
            JacobReleaseInfo.loadVersionProperties();
        }
        return buildDate;
    }

    public static String getBuildVersion() {
        if (buildVersion.equals("")) {
            JacobReleaseInfo.loadVersionProperties();
        }
        return buildVersion;
    }
}

