/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.utils.Messages;

public class Preferences
extends JPanel {
    JFrame jf = new JFrame("JPedal PDF Preferences");
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTextField dpi_Input;
    String dpiDefaultValue = "96";
    JComboBox searchStyle;
    int searchStyleDefaultValue = 1;
    JCheckBox border;
    int borderDefaultValue = 1;
    JCheckBox downloadWindow;
    boolean downloadWindowDefaultValue = false;
    JCheckBox update = new JCheckBox("Check for updates on startup");
    boolean updateDefaultValue = true;
    JTextField maxMultiViewers;
    String maxMultiViewersDefaultValue = "20";
    JCheckBox autoScroll;
    boolean scrollDefaultValue = false;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing"});
    int pageLayoutDefaultValue = 1;
    private JFrame parent;
    private boolean preferencesSetup = false;

    public void showPreferenceWindow(SwingGUI swingGUI) {
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(swingGUI);
        }
        this.jf.setLocationRelativeTo(this.parent);
        this.jf.setVisible(true);
    }

    private void createPreferenceWindow(final GUI gUI) {
        this.dpi_Input = new JTextField(this.dpiDefaultValue);
        this.maxMultiViewers = new JTextField(this.maxMultiViewersDefaultValue);
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing")});
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.downloadWindow = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.DownloadWindow_Show"));
        this.jf.getContentPane().setLayout(new BorderLayout());
        this.jf.getContentPane().add((Component)this, "Center");
        this.jf.pack();
        this.jf.setSize(500, 400);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.dpiDefaultValue = Preferences.this.dpi_Input.getText();
                int n = Integer.parseInt(Preferences.this.dpi_Input.getText());
                int n2 = Preferences.this.searchStyleDefaultValue = Preferences.this.searchStyle.getSelectedIndex();
                int n3 = Preferences.this.pageLayoutDefaultValue = Preferences.this.pageLayout.getSelectedIndex() + 1;
                Preferences.this.borderDefaultValue = 0;
                int n4 = 0;
                if (Preferences.this.border.isSelected()) {
                    Preferences.this.borderDefaultValue = 1;
                    n4 = 1;
                }
                Preferences.this.updateDefaultValue = Preferences.this.update.isSelected();
                boolean bl = Preferences.this.scrollDefaultValue = Preferences.this.autoScroll.isSelected();
                int n5 = Integer.parseInt(Preferences.this.maxMultiViewers.getText());
                gUI.setPreferences(n, n2, n4, bl, n3, Preferences.this.updateDefaultValue, n5, Preferences.this.downloadWindow.isSelected());
                Preferences.this.jf.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.jf.setVisible(false);
            }
        });
        KeyListener keyListener = new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent keyEvent) {
                this.consume = false;
                if (!(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        };
        this.dpi_Input.addKeyListener(keyListener);
        this.maxMultiViewers.addKeyListener(keyListener);
        this.searchStyle.setSelectedIndex(this.searchStyleDefaultValue);
        this.dpi_Input.setText(this.dpiDefaultValue);
        if (this.borderDefaultValue == 1) {
            this.border.setSelected(true);
        } else {
            this.border.setSelected(false);
        }
        if (this.downloadWindowDefaultValue) {
            this.downloadWindow.setSelected(true);
        } else {
            this.downloadWindow.setSelected(false);
        }
        this.autoScroll.setSelected(this.scrollDefaultValue);
        this.update.setSelected(this.updateDefaultValue);
        this.setLayout(new BorderLayout());
        JButtonBar jButtonBar = new JButtonBar(1);
        if (PdfDecoder.isRunningOnMac) {
            jButtonBar.setPreferredSize(new Dimension(120, 0));
        }
        this.add((Component)new ButtonBarPanel(jButtonBar), "Center");
        jButtonBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.confirm);
        this.getRootPane().setDefaultButton(this.confirm);
        jPanel.add(filler);
        jPanel.add(this.cancel);
        jPanel.add(filler);
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)jPanel, "South");
    }

    public void setAutoScrollDefaultValue(boolean bl) {
        this.scrollDefaultValue = bl;
    }

    public void setBorderDefaultValue(int n) {
        this.borderDefaultValue = n;
    }

    public void setdownloadWindowDefaultValue(boolean bl) {
        this.downloadWindowDefaultValue = bl;
    }

    public void setUpdateDefaultValue(boolean bl) {
        this.updateDefaultValue = bl;
    }

    public void setMaxMultiViewersDefaultValue(String string) {
        this.maxMultiViewersDefaultValue = string;
    }

    public void setDpiDefaultValue(String string) {
        this.dpiDefaultValue = string;
    }

    public void setSearchStyleDefaultValue(int n) {
        this.searchStyleDefaultValue = n;
    }

    public void setPageLayoutDefaultValue(int n) {
        if (n > this.pageLayout.getItemCount() + 1) {
            n = 1;
        }
        this.pageLayoutDefaultValue = n;
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;

        public ButtonBarPanel(JButtonBar jButtonBar) {
            this.setLayout(new BorderLayout());
            this.add((Component)jButtonBar, "West");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.addButton("Display", "/org/jpedal/examples/simpleviewer/res/display.png", this.createDisplaySettings(), jButtonBar, buttonGroup);
            this.addButton("Viewer", "/org/jpedal/examples/simpleviewer/res/viewer.png", this.createViewerSettings(), jButtonBar, buttonGroup);
            this.addButton("Updates", "/org/jpedal/examples/simpleviewer/res/updates.png", this.createUpdateSettings(), jButtonBar, buttonGroup);
            this.addButton("MulitViewer", "/org/jpedal/examples/simpleviewer/res/multiviewer.png", this.createMultiViewerSettings(), jButtonBar, buttonGroup);
        }

        private JPanel makePanel(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(string);
            jLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setOpaque(true);
            jLabel.setBackground(jPanel.getBackground().brighter());
            jPanel.add((Component)jLabel, "North");
            jPanel.setPreferredSize(new Dimension(400, 300));
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return jPanel;
        }

        private JPanel createDisplaySettings() {
            JPanel jPanel = this.makePanel("Display");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerViewMenu.Dpi"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel2.add((Component)Preferences.this.dpi_Input, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            Preferences.this.border.setMargin(new Insets(0, 0, 0, 0));
            Preferences.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)Preferences.this.border, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            Preferences.this.downloadWindow.setMargin(new Insets(0, 0, 0, 0));
            Preferences.this.downloadWindow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)Preferences.this.downloadWindow, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private JPanel createViewerSettings() {
            JPanel jPanel = this.makePanel("Viewer");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel2.add((Component)Preferences.this.searchStyle, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            Preferences.this.pageLayout.setSelectedIndex(Preferences.this.pageLayoutDefaultValue - 1);
            jPanel2.add((Component)Preferences.this.pageLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            Preferences.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            Preferences.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)Preferences.this.autoScroll, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private JPanel createUpdateSettings() {
            JPanel jPanel = this.makePanel("Updates");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            Preferences.this.update.setMargin(new Insets(0, 0, 0, 0));
            Preferences.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)Preferences.this.update, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private JPanel createMultiViewerSettings() {
            JPanel jPanel = this.makePanel("MultiViewer");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel("Maximum number of MultiViewer Windows");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel2.add((Component)Preferences.this.maxMultiViewers, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String string, String string2, final Component component, JButtonBar jButtonBar, ButtonGroup buttonGroup) {
            AbstractAction abstractAction = new AbstractAction(string, new ImageIcon(this.getClass().getResource(string2))){

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton jToggleButton = new JToggleButton(abstractAction);
            if (PdfDecoder.isRunningOnMac) {
                jToggleButton.setHorizontalAlignment(2);
            }
            jButtonBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (buttonGroup.getSelection() == null) {
                jToggleButton.setSelected(true);
                this.show(component);
            }
        }
    }
}

