/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import java.util.Map;

public final class Policy {
    public static final int NOPLAINTEXT = 1;
    public static final int NOACTIVE = 2;
    public static final int NODICTIONARY = 4;
    public static final int FORWARD_SECRECY = 8;
    public static final int NOANONYMOUS = 16;
    public static final int PASS_CREDENTIALS = 512;

    public static boolean checkPolicy(int n, Map map) {
        if (map == null) {
            return true;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noplaintext")) && (n & 1) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noactive")) && (n & 2) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.nodictionary")) && (n & 4) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noanonymous")) && (n & 0x10) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.forward")) && (n & 8) == 0) {
            return false;
        }
        return !"true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.credentials")) || (n & 0x200) != 0;
    }

    public static String[] filterMechs(String[] stringArray, int[] nArray, Map map) {
        if (map == null) {
            return (String[])stringArray.clone();
        }
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            blArray[n2] = Policy.checkPolicy(nArray[n2], map);
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            if (blArray[n3]) {
                stringArray2[n4++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }
}

