/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.util.SaslImpl;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class SaslOutputStream
extends FilterOutputStream {
    private static final boolean debug = false;
    private byte[] lenBuf = new byte[4];
    private int rawSendSize = 65536;
    private SaslClient sc;

    SaslOutputStream(SaslClient saslClient, OutputStream outputStream) throws IOException {
        super(outputStream);
        this.sc = saslClient;
        String string = saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (string != null) {
            try {
                this.rawSendSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SaslException("javax.security.sasl.rawsendsize property must be numeric string: " + string);
            }
        }
    }

    public void close() throws IOException {
        this.sc.dispose();
        super.close();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - n3 < this.rawSendSize ? n2 - n3 : this.rawSendSize;
            byte[] byArray2 = this.sc.wrap(byArray, n + n3, n4);
            SaslImpl.intToNetworkByteOrder(byArray2.length, this.lenBuf, 0, 4);
            this.out.write(this.lenBuf, 0, 4);
            this.out.write(byArray2, 0, byArray2.length);
            n3 += this.rawSendSize;
        }
    }
}

