/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.type.TimestampType;
import org.hibernate.type.VersionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTimestampType
extends TimestampType
implements VersionType {
    private static final Logger log = LoggerFactory.getLogger((Class)DbTimestampType.class);

    public String getName() {
        return "dbtimestamp";
    }

    public Object seed(SessionImplementor session) {
        if (session == null) {
            log.trace("incoming session was null; using current jvm time");
            return super.seed(session);
        }
        if (!session.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            log.debug("falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return super.seed(session);
        }
        return this.getCurrentTimestamp(session);
    }

    private Timestamp getCurrentTimestamp(SessionImplementor session) {
        Dialect dialect = session.getFactory().getDialect();
        String timestampSelectString = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(timestampSelectString, session);
        }
        return this.usePreparedStatement(timestampSelectString, session);
    }

    private Timestamp usePreparedStatement(String timestampSelectString, SessionImplementor session) {
        PreparedStatement ps = null;
        try {
            ps = session.getBatcher().prepareStatement(timestampSelectString);
            ResultSet rs = session.getBatcher().getResultSet(ps);
            rs.next();
            Timestamp ts = rs.getTimestamp(1);
            if (log.isTraceEnabled()) {
                log.trace("current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")");
            }
            Timestamp timestamp = ts;
            return timestamp;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not select current db timestamp", timestampSelectString);
        }
        finally {
            if (ps != null) {
                try {
                    session.getBatcher().closeStatement(ps);
                }
                catch (SQLException sqle) {
                    log.warn("unable to clean up prepared statement", (Throwable)sqle);
                }
            }
        }
    }

    private Timestamp useCallableStatement(String callString, SessionImplementor session) {
        CallableStatement cs = null;
        try {
            cs = session.getBatcher().prepareCallableStatement(callString);
            cs.registerOutParameter(1, 93);
            cs.execute();
            Timestamp ts = cs.getTimestamp(1);
            if (log.isTraceEnabled()) {
                log.trace("current timestamp retreived from db : " + ts + " (nanos=" + ts.getNanos() + ", time=" + ts.getTime() + ")");
            }
            Timestamp timestamp = ts;
            return timestamp;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not call current db timestamp function", callString);
        }
        finally {
            if (cs != null) {
                try {
                    session.getBatcher().closeStatement(cs);
                }
                catch (SQLException sqle) {
                    log.warn("unable to clean up callable statement", (Throwable)sqle);
                }
            }
        }
    }
}

