/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction;

import java.util.Iterator;
import java.util.List;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.util.LittleEndian;
import org.textmining.text.extraction.WordTextBuffer;
import org.textmining.text.extraction.chp.Word6CHPBinTable;

class Word6Extractor {
    public String extractText(byte[] byArray) throws Exception {
        int n = LittleEndian.getInt(byArray, 24);
        int n2 = LittleEndian.getInt(byArray, 28);
        int n3 = LittleEndian.getInt(byArray, 184);
        int n4 = LittleEndian.getInt(byArray, 188);
        Word6CHPBinTable word6CHPBinTable = new Word6CHPBinTable(byArray, n3, n4, n);
        List list = word6CHPBinTable.getTextRuns();
        WordTextBuffer wordTextBuffer = new WordTextBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CHPX cHPX = (CHPX)iterator.next();
            int n5 = cHPX.getStart() + n;
            int n6 = cHPX.getEnd() + n;
            if (this.isDeleted(cHPX.getGrpprl())) continue;
            String string = new String(byArray, n5, Math.min(n6, n2) - n5, "Cp1252");
            wordTextBuffer.append(string);
            if (n6 < n2) continue;
            break;
        }
        return wordTextBuffer.toString();
    }

    private boolean isDeleted(byte[] byArray) {
        int n = 0;
        boolean bl = false;
        while (n < byArray.length) {
            switch (LittleEndian.getUnsignedByte(byArray, n++)) {
                case 65: {
                    bl = byArray[n++] != 0;
                    break;
                }
                case 66: {
                    ++n;
                    break;
                }
                case 67: {
                    ++n;
                    break;
                }
                case 68: {
                    n += byArray[n];
                    break;
                }
                case 69: {
                    n += 2;
                    break;
                }
                case 70: {
                    n += 4;
                    break;
                }
                case 71: {
                    ++n;
                    break;
                }
                case 72: {
                    n += 2;
                    break;
                }
                case 73: {
                    n += 3;
                    break;
                }
                case 74: {
                    n += byArray[n];
                    break;
                }
                case 75: {
                    ++n;
                    break;
                }
                case 80: {
                    n += 2;
                    break;
                }
                case 81: {
                    n += byArray[n];
                    break;
                }
                case 82: {
                    n += byArray[n];
                    break;
                }
                case 83: {
                    break;
                }
                case 85: {
                    ++n;
                    break;
                }
                case 86: {
                    ++n;
                    break;
                }
                case 87: {
                    ++n;
                    break;
                }
                case 88: {
                    ++n;
                    break;
                }
                case 89: {
                    ++n;
                    break;
                }
                case 90: {
                    ++n;
                    break;
                }
                case 91: {
                    ++n;
                    break;
                }
                case 92: {
                    ++n;
                    break;
                }
                case 93: {
                    n += 2;
                    break;
                }
                case 94: {
                    ++n;
                    break;
                }
                case 95: {
                    n += 3;
                    break;
                }
                case 96: {
                    n += 2;
                    break;
                }
                case 97: {
                    n += 2;
                    break;
                }
                case 98: {
                    ++n;
                    break;
                }
                case 99: {
                    ++n;
                    break;
                }
                case 100: {
                    ++n;
                    break;
                }
                case 101: {
                    ++n;
                    break;
                }
                case 102: {
                    ++n;
                    break;
                }
                case 103: {
                    n += byArray[n];
                    break;
                }
                case 104: {
                    ++n;
                    break;
                }
                case 105: {
                    n += byArray[n];
                    break;
                }
                case 106: {
                    n += byArray[n];
                    break;
                }
                case 107: {
                    n += 2;
                    break;
                }
                case 108: {
                    n += byArray[n];
                    break;
                }
                case 109: {
                    n += 2;
                    break;
                }
                case 110: {
                    n += 2;
                    break;
                }
                case 117: {
                    ++n;
                    break;
                }
                case 118: {
                    ++n;
                }
            }
        }
        return bl;
    }
}

