/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.Color;
import java.awt.RenderingHints;
import org.icepdf.core.util.Defs;

public class GraphicsRenderingHints {
    public static final int SCREEN = 1;
    public static final int PRINT = 2;
    private static GraphicsRenderingHints singleton;
    Object printAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY;
    Object printAntiAliasing = RenderingHints.VALUE_ANTIALIAS_ON;
    Object printTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    Object printColorRendering = RenderingHints.VALUE_COLOR_RENDER_QUALITY;
    Object printDithering = RenderingHints.VALUE_DITHER_ENABLE;
    Object printFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
    Object printInterPolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    Object printRendering = RenderingHints.VALUE_RENDER_QUALITY;
    Object printStrokeControl = RenderingHints.VALUE_STROKE_NORMALIZE;
    Color printBackground = Color.white;
    Object screenAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY;
    Object screenAntiAliasing = RenderingHints.VALUE_ANTIALIAS_ON;
    Object screenTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    Object screenColorRendering = RenderingHints.VALUE_COLOR_RENDER_QUALITY;
    Object screenDithering = RenderingHints.VALUE_DITHER_ENABLE;
    Object screenFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
    Object screenInterPolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    Object screenRendering = RenderingHints.VALUE_RENDER_QUALITY;
    Object screenStrokeControl = RenderingHints.VALUE_STROKE_NORMALIZE;
    Color screenBackground = Color.white;
    private RenderingHints screenHints;
    private RenderingHints printHints;

    public static synchronized GraphicsRenderingHints getDefault() {
        if (singleton == null) {
            singleton = new GraphicsRenderingHints();
        }
        return singleton;
    }

    private GraphicsRenderingHints() {
        this.setFromProperties();
    }

    public RenderingHints getRenderingHints(int n) {
        if (n == 1) {
            return (RenderingHints)this.screenHints.clone();
        }
        return (RenderingHints)this.printHints.clone();
    }

    public Color getPageBackgroundColor(int n) {
        if (n == 1) {
            return this.screenBackground;
        }
        return this.printBackground;
    }

    public synchronized void reset() {
        this.setFromProperties();
    }

    private void setFromProperties() {
        String string = Defs.sysProperty("org.icepdf.core.screen.alphaInterpolation");
        if (string != null) {
            if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_QUALITY")) {
                this.screenAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_DEFAULT")) {
                this.screenAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_SPEED")) {
                this.screenAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.antiAliasing")) != null) {
            if (string.equalsIgnoreCase("VALUE_ANTIALIAS_DEFAULT")) {
                this.screenAntiAliasing = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_ANTIALIAS_ON")) {
                this.screenAntiAliasing = RenderingHints.VALUE_ANTIALIAS_ON;
            } else if (string.equalsIgnoreCase("VALUE_ANTIALIAS_OFF")) {
                this.screenAntiAliasing = RenderingHints.VALUE_ANTIALIAS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.textAntiAliasing")) != null) {
            if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_DEFAULT")) {
                this.screenTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_ON")) {
                this.screenTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_OFF")) {
                this.screenTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.colorRender")) != null) {
            if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_DEFAULT")) {
                this.screenColorRendering = RenderingHints.VALUE_COLOR_RENDER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_QUALITY")) {
                this.screenColorRendering = RenderingHints.VALUE_COLOR_RENDER_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_SPEED")) {
                this.screenColorRendering = RenderingHints.VALUE_COLOR_RENDER_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.dither")) != null) {
            if (string.equalsIgnoreCase("VALUE_DITHER_DEFAULT")) {
                this.screenDithering = RenderingHints.VALUE_DITHER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_DITHER_DISABLE")) {
                this.screenDithering = RenderingHints.VALUE_DITHER_DISABLE;
            } else if (string.equalsIgnoreCase("VALUE_DITHER_ENABLE")) {
                this.screenDithering = RenderingHints.VALUE_DITHER_ENABLE;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.fractionalmetrics")) != null) {
            if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_DEFAULT")) {
                this.screenFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_ON")) {
                this.screenFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
            } else if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_OFF")) {
                this.screenFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.interpolation")) != null) {
            if (string.equalsIgnoreCase("VALUE_INTERPOLATION_BICUBIC")) {
                this.screenInterPolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            } else if (string.equalsIgnoreCase("VALUE_INTERPOLATION_BILINEAR")) {
                this.screenInterPolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            } else if (string.equalsIgnoreCase("VALUE_INTERPOLATION_NEAREST_NEIGHBOR")) {
                this.screenInterPolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.render")) != null) {
            if (string.equalsIgnoreCase("VALUE_RENDER_DEFAULT")) {
                this.screenRendering = RenderingHints.VALUE_RENDER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_RENDER_QUALITY")) {
                this.screenRendering = RenderingHints.VALUE_RENDER_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_RENDER_SPEED")) {
                this.screenRendering = RenderingHints.VALUE_RENDER_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.stroke")) != null) {
            if (string.equalsIgnoreCase("VALUE_STROKE_DEFAULT")) {
                this.screenStrokeControl = RenderingHints.VALUE_STROKE_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_STROKE_NORMALIZE")) {
                this.screenStrokeControl = RenderingHints.VALUE_STROKE_NORMALIZE;
            } else if (string.equalsIgnoreCase("VALUE_STROKE_PURE")) {
                this.screenStrokeControl = RenderingHints.VALUE_STROKE_PURE;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.screen.background")) != null) {
            if (string.equalsIgnoreCase("VALUE_DRAW_WHITE_BACKGROUND")) {
                this.screenBackground = Color.white;
            } else if (string.equalsIgnoreCase("VALUE_DRAW_NO_BACKGROUND")) {
                this.screenBackground = null;
            }
        }
        this.screenHints = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, this.screenAlphaInterpolocation);
        this.screenHints.put(RenderingHints.KEY_ANTIALIASING, this.screenAntiAliasing);
        this.screenHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.screenTextAntiAliasing);
        this.screenHints.put(RenderingHints.KEY_COLOR_RENDERING, this.screenColorRendering);
        this.screenHints.put(RenderingHints.KEY_DITHERING, this.screenDithering);
        this.screenHints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.screenFractionalMetrics);
        this.screenHints.put(RenderingHints.KEY_INTERPOLATION, this.screenInterPolation);
        this.screenHints.put(RenderingHints.KEY_RENDERING, this.screenRendering);
        this.screenHints.put(RenderingHints.KEY_STROKE_CONTROL, this.screenStrokeControl);
        string = Defs.sysProperty("org.icepdf.core.print.alphaInterpolation");
        if (string != null) {
            if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_QUALITY")) {
                this.printAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_DEFAULT")) {
                this.printAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_ALPHA_INTERPOLATION_SPEED")) {
                this.printAlphaInterpolocation = RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.antiAliasing")) != null) {
            if (string.equalsIgnoreCase("VALUE_ANTIALIAS_DEFAULT")) {
                this.printAntiAliasing = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_ANTIALIAS_ON")) {
                this.printAntiAliasing = RenderingHints.VALUE_ANTIALIAS_ON;
            } else if (string.equalsIgnoreCase("VALUE_ANTIALIAS_OFF")) {
                this.printAntiAliasing = RenderingHints.VALUE_ANTIALIAS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.textAntiAliasing")) != null) {
            if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_DEFAULT")) {
                this.printTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_ON")) {
                this.printTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else if (string.equalsIgnoreCase("VALUE_TEXT_ANTIALIAS_OFF")) {
                this.printTextAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.colorRender")) != null) {
            if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_DEFAULT")) {
                this.printColorRendering = RenderingHints.VALUE_COLOR_RENDER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_QUALITY")) {
                this.printColorRendering = RenderingHints.VALUE_COLOR_RENDER_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_COLOR_RENDER_SPEED")) {
                this.printColorRendering = RenderingHints.VALUE_COLOR_RENDER_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.dither")) != null) {
            if (string.equalsIgnoreCase("VALUE_DITHER_DEFAULT")) {
                this.printDithering = RenderingHints.VALUE_DITHER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_DITHER_DISABLE")) {
                this.printDithering = RenderingHints.VALUE_DITHER_DISABLE;
            } else if (string.equalsIgnoreCase("VALUE_DITHER_ENABLE")) {
                this.printDithering = RenderingHints.VALUE_DITHER_ENABLE;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.fractionalmetrics")) != null) {
            if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_DEFAULT")) {
                this.printFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_ON")) {
                this.printFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
            } else if (string.equalsIgnoreCase("VALUE_FRACTIONALMETRICS_OFF")) {
                this.printFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.interpolation")) != null) {
            if (string.equalsIgnoreCase("VALUE_INTERPOLATION_BICUBIC")) {
                this.printInterPolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            } else if (string.equalsIgnoreCase("VALUE_INTERPOLATION_BILINEAR")) {
                this.printInterPolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            } else if (string.equalsIgnoreCase("VALUE_INTERPOLATION_NEAREST_NEIGHBOR")) {
                this.printInterPolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.render")) != null) {
            if (string.equalsIgnoreCase("VALUE_RENDER_DEFAULT")) {
                this.printRendering = RenderingHints.VALUE_RENDER_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_RENDER_QUALITY")) {
                this.printRendering = RenderingHints.VALUE_RENDER_QUALITY;
            } else if (string.equalsIgnoreCase("VALUE_RENDER_SPEED")) {
                this.printRendering = RenderingHints.VALUE_RENDER_SPEED;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.stroke")) != null) {
            if (string.equalsIgnoreCase("VALUE_STROKE_DEFAULT")) {
                this.printStrokeControl = RenderingHints.VALUE_STROKE_DEFAULT;
            } else if (string.equalsIgnoreCase("VALUE_STROKE_NORMALIZE")) {
                this.printStrokeControl = RenderingHints.VALUE_STROKE_NORMALIZE;
            } else if (string.equalsIgnoreCase("VALUE_STROKE_PURE")) {
                this.printStrokeControl = RenderingHints.VALUE_STROKE_PURE;
            }
        }
        if ((string = Defs.sysProperty("org.icepdf.core.print.background")) != null) {
            if (string.equalsIgnoreCase("VALUE_DRAW_WHITE_BACKGROUND")) {
                this.printBackground = Color.white;
            } else if (string.equalsIgnoreCase("VALUE_DRAW_NO_BACKGROUND")) {
                this.printBackground = null;
            }
        }
        this.printHints = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, this.printAlphaInterpolocation);
        this.printHints.put(RenderingHints.KEY_ANTIALIASING, this.printAntiAliasing);
        this.printHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.printTextAntiAliasing);
        this.printHints.put(RenderingHints.KEY_COLOR_RENDERING, this.printColorRendering);
        this.printHints.put(RenderingHints.KEY_DITHERING, this.printDithering);
        this.printHints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.printFractionalMetrics);
        this.printHints.put(RenderingHints.KEY_INTERPOLATION, this.printInterPolation);
        this.printHints.put(RenderingHints.KEY_RENDERING, this.printRendering);
        this.printHints.put(RenderingHints.KEY_STROKE_CONTROL, this.printStrokeControl);
    }
}

