/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.EncryptionDictionary;

class StandardEncryption {
    private static final Logger logger = Logger.getLogger(StandardEncryption.class.toString());
    private static final byte[] PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private EncryptionDictionary encryptionDictionary;
    private byte[] encryptionKey;
    private Reference objectReference;
    private byte[] rc4Key = null;
    private String userPassword = "";
    private String ownerPassword = "";

    public StandardEncryption(EncryptionDictionary encryptionDictionary) {
        this.encryptionDictionary = encryptionDictionary;
    }

    public byte[] generalEncryptionAlgorithm(Reference reference, byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (reference == null || byArray == null || byArray2 == null) {
            // empty if block
        }
        if (this.rc4Key == null || this.encryptionKey != byArray || this.objectReference != reference) {
            this.objectReference = reference;
            byArray3 = this.resetObjectReference(reference);
            int n = byArray.length;
            this.rc4Key = new byte[Math.min(n + 5, 16)];
            System.arraycopy(byArray3, 0, this.rc4Key, 0, this.rc4Key.length);
        }
        byArray3 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.rc4Key, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, secretKeySpec);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            logger.log(Level.FINE, "BadPaddingException.", badPaddingException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
        }
        return byArray3;
    }

    public InputStream generalEncryptionInputStream(Reference reference, byte[] byArray, InputStream inputStream) {
        Object object;
        if (reference == null || byArray == null || inputStream == null) {
            return null;
        }
        if (this.rc4Key == null || this.encryptionKey != byArray || this.objectReference != reference) {
            this.objectReference = reference;
            object = this.resetObjectReference(reference);
            int n = byArray.length;
            this.rc4Key = new byte[Math.min(n + 5, 16)];
            System.arraycopy(object, 0, this.rc4Key, 0, this.rc4Key.length);
        }
        try {
            object = new SecretKeySpec(this.rc4Key, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, (Key)object);
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);
            return cipherInputStream;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
        }
        return null;
    }

    public byte[] resetObjectReference(Reference reference) {
        int n = reference.getObjectNumber();
        int n2 = reference.getGenerationNumber();
        int n3 = this.encryptionKey.length;
        byte[] byArray = new byte[n3 + 5];
        System.arraycopy(this.encryptionKey, 0, byArray, 0, n3);
        byArray[n3] = (byte)(n & 0xFF);
        byArray[n3 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 & 0xFF);
        byArray[n3 + 4] = (byte)(n2 >> 8 & 0xFF);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] encryptionKeyAlgorithm(String string, int n) {
        int n2;
        int n3;
        byte[] byArray = StandardEncryption.padPassword(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        messageDigest.update(byArray);
        String string2 = this.encryptionDictionary.getBigO();
        byte[] byArray2 = new byte[string2.length()];
        for (n3 = 0; n3 < string2.length(); ++n3) {
            byArray2[n3] = (byte)string2.charAt(n3);
        }
        messageDigest.update(byArray2);
        n3 = 0;
        int n4 = this.encryptionDictionary.getPermissions();
        while (n3 < 4) {
            messageDigest.update((byte)n4);
            ++n3;
            n4 >>= 8;
        }
        String string3 = ((StringObject)this.encryptionDictionary.getFileID().elementAt(0)).getLiteralString();
        byte[] byArray3 = new byte[string3.length()];
        for (n2 = 0; n2 < string3.length(); ++n2) {
            byArray3[n2] = (byte)string3.charAt(n2);
        }
        byArray = messageDigest.digest(byArray3);
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            for (n2 = 0; n2 < 50; ++n2) {
                byArray = messageDigest.digest(byArray);
            }
        }
        byte[] byArray4 = null;
        int n5 = 5;
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            byArray4 = new byte[n5];
        } else if (this.encryptionDictionary.getRevisionNumber() == 3) {
            n5 = n / 8;
            byArray4 = new byte[n5];
        }
        System.arraycopy(byArray, 0, byArray4, 0, n5);
        this.encryptionKey = byArray4;
        return byArray4;
    }

    protected static byte[] padPassword(String string) {
        byte[] byArray = new byte[32];
        if (string == null || "".equals(string)) {
            return PADDING;
        }
        int n = Math.min(string.length(), 32);
        byte[] byArray2 = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray2[i] = (byte)string.charAt(i);
        }
        System.arraycopy(byArray2, 0, byArray, 0, n);
        System.arraycopy(PADDING, 0, byArray, n, 32 - n);
        return byArray;
    }

    public byte[] calculateOwnerPassword(String string, String string2, boolean bl) {
        if ("".equals(string) && !"".equals(string2)) {
            string = string2;
        }
        byte[] byArray = StandardEncryption.padPassword(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "Could not fint MD5 Digest", noSuchAlgorithmException);
        }
        byArray = messageDigest.digest(byArray);
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            for (int i = 0; i < 50; ++i) {
                byArray = messageDigest.digest(byArray);
            }
        }
        int n = 5;
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            n = this.encryptionDictionary.getKeyLength() / 8;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (bl) {
            return byArray2;
        }
        byte[] byArray3 = StandardEncryption.padPassword(string2);
        byte[] byArray4 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, secretKeySpec);
            byArray4 = cipher.update(byArray3);
            if (this.encryptionDictionary.getRevisionNumber() == 3) {
                byte[] byArray5 = new byte[byArray2.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < byArray2.length; ++j) {
                        byArray5[j] = (byte)(byArray2[j] ^ i);
                    }
                    secretKeySpec = new SecretKeySpec(byArray5, "RC4");
                    cipher.init(1, secretKeySpec);
                    byArray4 = cipher.update(byArray4);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
        }
        return byArray4;
    }

    public byte[] calculateUserPassword(String string) {
        byte[] byArray = this.encryptionKeyAlgorithm(string, this.encryptionDictionary.getKeyLength());
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            byte[] byArray2 = (byte[])PADDING.clone();
            byte[] byArray3 = null;
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RC4");
                Cipher cipher = Cipher.getInstance("RC4");
                cipher.init(1, secretKeySpec);
                byArray3 = cipher.doFinal(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                logger.log(Level.FINE, "IllegalBlockSizeException.", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                logger.log(Level.FINE, "BadPaddingException.", badPaddingException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
            }
            catch (InvalidKeyException invalidKeyException) {
                logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
            }
            return byArray3;
        }
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            Object object;
            byte[] byArray4 = (byte[])PADDING.clone();
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.log(Level.FINE, "MD5 digester could not be found", noSuchAlgorithmException);
            }
            messageDigest.update(byArray4);
            String string2 = ((StringObject)this.encryptionDictionary.getFileID().elementAt(0)).getLiteralString();
            byte[] byArray5 = new byte[string2.length()];
            for (int i = 0; i < string2.length(); ++i) {
                byArray5[i] = (byte)string2.charAt(i);
            }
            byte[] byArray6 = messageDigest.digest(byArray5);
            try {
                object = new SecretKeySpec(byArray, "RC4");
                Cipher cipher = Cipher.getInstance("RC4");
                cipher.init(1, (Key)object);
                byArray6 = cipher.update(byArray6);
                byte[] byArray7 = new byte[byArray.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < byArray.length; ++j) {
                        byArray7[j] = (byte)(byArray[j] ^ (byte)i);
                    }
                    object = new SecretKeySpec(byArray7, "RC4");
                    cipher.init(1, (Key)object);
                    byArray6 = cipher.update(byArray6);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
            }
            catch (InvalidKeyException invalidKeyException) {
                logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
            }
            object = new byte[32];
            System.arraycopy(byArray6, 0, object, 0, 16);
            System.arraycopy(PADDING, 0, object, 16, 16);
            return object;
        }
        return null;
    }

    public boolean authenticateUserPassword(String string) {
        byte[] byArray;
        byte[] byArray2 = this.calculateUserPassword(string);
        String string2 = this.encryptionDictionary.getBigU();
        byte[] byArray3 = new byte[string2.length()];
        for (int i = 0; i < string2.length(); ++i) {
            byArray3[i] = (byte)string2.charAt(i);
        }
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            byArray = new byte[32];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        } else {
            byArray = new byte[16];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        }
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray3[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean authenticateOwnerPassword(String string) {
        String string2;
        byte[] byArray = this.calculateOwnerPassword(string, "", true);
        byte[] byArray2 = null;
        try {
            Object object;
            string2 = this.encryptionDictionary.getBigO();
            byte[] byArray3 = new byte[string2.length()];
            for (int i = 0; i < string2.length(); ++i) {
                byArray3[i] = (byte)string2.charAt(i);
            }
            if (this.encryptionDictionary.getRevisionNumber() == 2) {
                object = new SecretKeySpec(byArray, "RC4");
                Cipher cipher = Cipher.getInstance("RC4");
                cipher.init(2, (Key)object);
                byArray2 = cipher.doFinal(byArray3);
            } else {
                object = new byte[byArray.length];
                byArray2 = byArray3;
                for (int i = 19; i >= 0; --i) {
                    for (int j = 0; j < ((byte[])object).length; ++j) {
                        object[j] = (byte)(byArray[j] ^ (byte)i);
                    }
                    SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "RC4");
                    Cipher cipher = Cipher.getInstance("RC4");
                    cipher.init(1, secretKeySpec);
                    byArray2 = cipher.update(byArray2);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            logger.log(Level.FINE, "BadPaddingException.", badPaddingException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.log(Level.FINE, "NoSuchPaddingException.", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.FINE, "InvalidKeyException.", invalidKeyException);
        }
        string2 = "";
        for (byte by : byArray2) {
            string2 = string2 + (char)by;
        }
        boolean bl = this.authenticateUserPassword(string2);
        if (bl) {
            this.userPassword = string2;
            this.ownerPassword = string;
        }
        return bl;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }
}

