/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.util.Library;

public class ExtGState
extends Dictionary {
    private static final Logger logger = Logger.getLogger(ExtGState.class.toString());

    public ExtGState(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    Number getLineWidth() {
        return this.getNumber("LW");
    }

    Number getLineCapStyle() {
        return this.getNumber("LC");
    }

    Number getLineJoinStyle() {
        return this.getNumber("LJ");
    }

    Number getMiterLimit() {
        return this.getNumber("ML");
    }

    Vector getLineDashPattern() {
        Vector<Object> vector = null;
        Number number = new Float(0.0f);
        float[] fArray = null;
        if (this.entries.containsKey("D")) {
            try {
                Vector vector2 = (Vector)this.entries.get("D");
                number = (Number)vector2.elementAt(1);
                Vector vector3 = (Vector)vector2.elementAt(0);
                if (vector3.size() > 0) {
                    Enumeration enumeration = vector3.elements();
                    fArray = new float[vector3.size()];
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        fArray[n++] = ((Number)enumeration.nextElement()).floatValue();
                    }
                } else {
                    number = new Float(0.0f);
                    fArray = null;
                }
                vector = new Vector<Object>(2);
                vector.add(fArray);
                vector.add(number);
            }
            catch (ClassCastException classCastException) {
                logger.log(Level.FINE, "Dash pattern syntax error: ", classCastException);
            }
        }
        return vector;
    }

    Number getStrokingAlphConstant() {
        return this.getNumber("CA");
    }

    Number getNonStrokingAlphConstant() {
        return this.getNumber("ca");
    }

    Boolean getOverprint() {
        Object object = this.getObject("OP");
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    Boolean getOverprintFill() {
        Object object = this.getObject("op");
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    Number getOverprintMode() {
        return this.getNumber("OPM");
    }
}

