/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class SeekableByteArrayInputStream
extends ByteArrayInputStream
implements SeekableInput {
    private static final Logger log = Logger.getLogger(SeekableByteArrayInputStream.class.toString());
    private int m_iBeginningOffset;
    private Object m_oCurrentUser;

    public SeekableByteArrayInputStream(byte[] byArray) {
        super(byArray);
        this.m_iBeginningOffset = 0;
    }

    public SeekableByteArrayInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.m_iBeginningOffset = n;
    }

    public void seekAbsolute(long l) {
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.pos = this.m_iBeginningOffset + n;
    }

    public void seekRelative(long l) {
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int n2 = this.pos + n;
        if (n2 < this.m_iBeginningOffset) {
            n2 = this.m_iBeginningOffset;
        }
        this.pos = n2;
    }

    public void seekEnd() {
        this.seekAbsolute(this.getLength());
    }

    public long getAbsolutePosition() {
        int n = this.pos - this.m_iBeginningOffset;
        return (long)n & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getLength() {
        int n = this.count - this.m_iBeginningOffset;
        return (long)n & 0xFFFFFFFFFFFFFFFFL;
    }

    public InputStream getInputStream() {
        return this;
    }

    public synchronized void beginThreadAccess() {
        Thread thread = Thread.currentThread();
        while (true) {
            if (this.m_oCurrentUser == null) {
                this.m_oCurrentUser = thread;
                break;
            }
            if (this.m_oCurrentUser == thread) break;
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void endThreadAccess() {
        Thread thread = Thread.currentThread();
        if (this.m_oCurrentUser == null) {
            this.notifyAll();
        } else if (this.m_oCurrentUser == thread) {
            this.m_oCurrentUser = null;
            this.notifyAll();
        } else if (log.isLoggable(Level.SEVERE)) {
            log.severe("ERROR:  Thread finished using SeekableInput, but it wasn't locked by that Thread\n        Thread: " + Thread.currentThread() + "\n" + "        Locking Thread: " + this.m_oCurrentUser + "\n" + "        SeekableInput: " + this);
        }
    }
}

