/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaDefinition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editor.refactoring.TooManyMatchesException;
import org.python.pydev.plugin.PydevPlugin;

public class PyGoToDefinition
extends PyRefactorAction {
    IPyRefactoring pyRefactoring;

    protected IPyRefactoring getPyRefactoring() {
        if (this.pyRefactoring == null) {
            this.pyRefactoring = this.getPyRefactoring("canFindDefinition");
        }
        return this.pyRefactoring;
    }

    protected boolean areRefactorPreconditionsOK(RefactoringRequest request) {
        try {
            IPyRefactoring pyRefactoring = this.getPyRefactoring();
            pyRefactoring.checkAvailableForRefactoring(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorDialog.openError(null, (String)"Error", (String)"Unable to do requested action", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, e.getMessage(), null));
            return false;
        }
        if (request.pyEdit.isDirty()) {
            request.pyEdit.doSave(null);
        }
        return true;
    }

    public void run(IAction action) {
        this.findDefinitionsAndOpen(true);
    }

    public ItemPointer[] findDefinitionsAndOpen(boolean doOpenDefinition) {
        this.request = null;
        Shell shell = PyGoToDefinition.getShell();
        try {
            this.ps = new PySelection(this.getTextEditor());
            PyEdit pyEdit = this.getPyEdit();
            if (this.areRefactorPreconditionsOK(this.getRefactoringRequest())) {
                ItemPointer[] defs = this.findDefinition(pyEdit);
                if (doOpenDefinition) {
                    PyGoToDefinition.openDefinition(defs, pyEdit, shell);
                }
                return defs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PydevPlugin.log(e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = "Unable to get error msg";
            }
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Unable to do requested action", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, msg, (Throwable)e));
        }
        return null;
    }

    public static void openDefinition(ItemPointer[] defs, final PyEdit pyEdit, final Shell shell) {
        if (defs == null) {
            shell.getDisplay().beep();
            return;
        }
        HashSet<ItemPointer> set = new HashSet<ItemPointer>();
        ItemPointer[] itemPointerArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer pointer = itemPointerArray[n2];
            if (pointer.file != null) {
                set.add(pointer);
            }
            ++n2;
        }
        final ItemPointer[] where = set.toArray(new ItemPointer[0]);
        if (where == null) {
            shell.getDisplay().beep();
            return;
        }
        if (where.length > 0) {
            if (where.length == 1) {
                ItemPointer itemPointer = where[0];
                PyGoToDefinition.doOpen(itemPointer, pyEdit, shell);
            } else {
                Display disp = shell.getDisplay();
                disp.syncExec(new Runnable(){

                    public void run() {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, new ILabelProvider(){

                            public Image getImage(Object element) {
                                return PyCodeCompletionImages.getImageForType(6);
                            }

                            public String getText(Object element) {
                                ItemPointer pointer = (ItemPointer)element;
                                File f = (File)pointer.file;
                                int line = pointer.start.line;
                                return String.valueOf(f.getName()) + "  (" + f.getParent() + ") - line:" + line;
                            }

                            public void addListener(ILabelProviderListener listener) {
                            }

                            public void dispose() {
                            }

                            public boolean isLabelProperty(Object element, String property) {
                                return false;
                            }

                            public void removeListener(ILabelProviderListener listener) {
                            }
                        });
                        dialog.setTitle("Found matches");
                        dialog.setTitle("Select the one you believe matches most your search.");
                        dialog.setElements((Object[])where);
                        dialog.open();
                        Object[] result = dialog.getResult();
                        if (result != null && result.length > 0) {
                            PyGoToDefinition.doOpen((ItemPointer)result[0], pyEdit, shell);
                        }
                    }
                });
            }
        } else {
            shell.getDisplay().beep();
        }
    }

    private static void doOpen(ItemPointer itemPointer, PyEdit pyEdit, Shell shell) {
        File f = (File)itemPointer.file;
        String filename = f.getName();
        if (PythonPathHelper.isValidSourceFile(filename) || filename.indexOf(46) == -1 || itemPointer.zipFilePath != null && PythonPathHelper.isValidSourceFile(itemPointer.zipFilePath)) {
            PyOpenAction openAction = (PyOpenAction)pyEdit.getAction("OpenEditor");
            openAction.run(itemPointer);
        } else if (itemPointer.definition instanceof JavaDefinition) {
            JavaDefinition javaDefinition = (JavaDefinition)itemPointer.definition;
            OpenAction openAction = new OpenAction((IWorkbenchSite)pyEdit.getSite());
            StructuredSelection selection = new StructuredSelection(new Object[]{javaDefinition.javaElement});
            openAction.run((IStructuredSelection)selection);
        } else {
            String message;
            if (itemPointer.definition != null && itemPointer.definition.module instanceof AbstractJavaClassModule) {
                AbstractJavaClassModule module = (AbstractJavaClassModule)itemPointer.definition.module;
                message = "The definition was found at: " + f.toString() + "\n" + "as the java module: " + module.getName();
            } else {
                message = "The definition was found at: " + f.toString() + "\n" + "(which cannot be opened because it is a compiled extension)";
            }
            MessageDialog.openInformation((Shell)shell, (String)"Compiled Extension file", (String)message);
        }
    }

    public ItemPointer[] findDefinition(PyEdit pyEdit) throws TooManyMatchesException, MisconfigurationException {
        IPyRefactoring pyRefactoring = this.getPyRefactoring("canFindDefinition");
        return pyRefactoring.findDefinition(this.getRefactoringRequest());
    }

    protected String perform(IAction action, String name, IProgressMonitor monitor) throws Exception {
        return null;
    }

    protected String getInputMessage() {
        return null;
    }
}

