/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters.offsetstrategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.FindLastLineVisitor;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.offsetstrategy.AbstractOffsetStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginOffset
extends AbstractOffsetStrategy {
    public BeginOffset(IASTNodeAdapter<? extends SimpleNode> adapter, IDocument doc) {
        super(adapter, doc);
    }

    @Override
    protected int getLine() {
        int startLine;
        Object node = this.adapter.getASTNode();
        if (this.nodeHelper.isClassDef((SimpleNode)node)) {
            ClassDef classNode = (ClassDef)node;
            Str strNode = NodeUtils.getNodeDocStringNode(node);
            if (strNode != null) {
                return NodeUtils.getLineEnd((SimpleNode)strNode) - 1;
            }
            FindLastLineVisitor findLastLineVisitor = new FindLastLineVisitor();
            try {
                classNode.name.accept((VisitorIF)findLastLineVisitor);
                if (classNode.bases != null) {
                    exprType[] exprTypeArray = classNode.bases;
                    int n = classNode.bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        exprType n3 = exprTypeArray[n2];
                        n3.accept((VisitorIF)findLastLineVisitor);
                        ++n2;
                    }
                }
                SimpleNode lastNode = findLastLineVisitor.getLastNode();
                SpecialStr lastSpecialStr = findLastLineVisitor.getLastSpecialStr();
                if (lastSpecialStr != null && (lastSpecialStr.str.equals(":") || lastSpecialStr.str.equals(")"))) {
                    return lastSpecialStr.beginLine - 1;
                }
                return lastNode.beginLine - 1;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if ((startLine = this.adapter.getNodeFirstLine() - 1) < 0) {
            startLine = 0;
        }
        return startLine;
    }

    @Override
    protected int getLineIndendation() throws BadLocationException {
        if (this.adapter.getNodeBodyIndent() == 0) {
            return 0;
        }
        return this.doc.getLineLength(this.getLine());
    }
}

