/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.poi.hssf.model.Node;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;

public class FormulaParser {
    public static int FORMULA_TYPE_CELL = 0;
    public static int FORMULA_TYPE_SHARED = 1;
    public static int FORMULA_TYPE_ARRAY = 2;
    public static int FORMULA_TYPE_CONDFOMRAT = 3;
    public static int FORMULA_TYPE_NAMEDRANGE = 4;
    private String formulaString;
    private int pointer = 0;
    private int formulaLength;
    private List tokens = new Stack();
    private List functionTokens = new LinkedList();
    private List result = new ArrayList();
    private int numParen;
    private static char TAB = (char)9;
    private static char CR = (char)10;
    private char look;
    private boolean inFunction = false;
    private Workbook book;

    public FormulaParser(String formula, Workbook book) {
        this.formulaString = formula;
        this.pointer = 0;
        this.book = book;
        this.formulaLength = this.formulaString.length();
    }

    private void GetChar() {
        if (this.pointer == this.formulaLength) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaString.charAt(this.pointer++);
    }

    private void Error(String s) {
        System.out.println("Error: " + s);
    }

    private void Abort(String s) {
        this.Error(s);
        throw new RuntimeException("Cannot Parse, sorry : " + s);
    }

    private void Expected(String s) {
        this.Abort(s + " Expected");
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsAddop(char c) {
        return c == '+' || c == '-';
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private boolean IsSpecialChar(char c) {
        return c == '>' || c == '<' || c == '=' || c == '&' || c == '[' || c == ']';
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            this.Expected("" + x + "");
        } else {
            this.GetChar();
            this.SkipWhite();
        }
    }

    private String GetName() {
        StringBuffer Token2 = new StringBuffer();
        if (!this.IsAlpha(this.look) && this.look != '\'') {
            this.Expected("Name");
        }
        if (this.look == '\'') {
            boolean done;
            this.Match('\'');
            boolean bl = done = this.look == '\'';
            while (!done) {
                Token2.append(Character.toUpperCase(this.look));
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
        } else {
            while (this.IsAlNum(this.look)) {
                Token2.append(Character.toUpperCase(this.look));
                this.GetChar();
            }
        }
        this.SkipWhite();
        return Token2.toString();
    }

    private String GetNameAsIs() {
        StringBuffer Token2 = new StringBuffer();
        while (this.IsAlNum(this.look) || this.IsWhite(this.look) || this.IsSpecialChar(this.look)) {
            Token2 = Token2.append(this.look);
            this.GetChar();
        }
        return Token2.toString();
    }

    private String GetNum() {
        String Value2 = "";
        if (!this.IsDigit(this.look)) {
            this.Expected("Integer");
        }
        while (this.IsDigit(this.look)) {
            Value2 = Value2 + this.look;
            this.GetChar();
        }
        this.SkipWhite();
        return Value2;
    }

    private void Emit(String s) {
        System.out.print(TAB + s);
    }

    private void EmitLn(String s) {
        this.Emit(s);
        System.out.println();
    }

    private void Ident() {
        String name = this.GetName();
        if (this.look == '(') {
            this.function(name);
        } else if (this.look == ':') {
            String first = name;
            this.Match(':');
            String second = this.GetName();
            this.tokens.add(new AreaPtg(first + ":" + second));
        } else if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = this.GetName();
            short externIdx = this.book.checkExternSheet(this.book.getSheetIndex(sheetName));
            if (this.look == ':') {
                this.Match(':');
                String second = this.GetName();
                this.tokens.add(new Area3DPtg(first + ":" + second, externIdx));
            } else {
                this.tokens.add(new Ref3DPtg(first, externIdx));
            }
        } else {
            boolean boolLit;
            boolean cellRef = true;
            boolean bl = boolLit = name.equals("TRUE") || name.equals("FALSE");
            if (boolLit) {
                this.tokens.add(new BoolPtg(name));
            } else if (cellRef) {
                this.tokens.add(new ReferencePtg(name));
            }
        }
    }

    private void addArgumentPointer() {
        if (this.functionTokens.size() > 0) {
            List arguments = (List)this.functionTokens.get(0);
            arguments.add(this.tokens.get(this.tokens.size() - 1));
        }
    }

    private void function(String name) {
        this.functionTokens.add(0, new ArrayList(2));
        this.Match('(');
        int numArgs = this.Arguments();
        this.Match(')');
        AbstractFunctionPtg functionPtg = this.getFunction(name, (byte)numArgs);
        this.tokens.add(functionPtg);
        if (functionPtg.getName().equals("externalflag")) {
            this.tokens.add(new NamePtg(name, this.book));
        }
        this.functionTokens.remove(0);
    }

    private int getPtgSize(int index) {
        int count = 0;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        while (ptgIterator.hasNext()) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
        }
        return count;
    }

    private int getPtgSize(int start, int end) {
        int index;
        int count = 0;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        for (index = start; ptgIterator.hasNext() && index <= end; ++index) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
        }
        return count;
    }

    private AbstractFunctionPtg getFunction(String name, byte numArgs) {
        FuncVarPtg retval = null;
        if (name.equals("IF")) {
            retval = new FuncVarPtg("specialflag", numArgs);
            List argumentPointers = (List)this.functionTokens.get(0);
            AttrPtg ifPtg = new AttrPtg();
            ifPtg.setData((short)7);
            ifPtg.setOptimizedIf(true);
            if (argumentPointers.size() != 2 && argumentPointers.size() != 3) {
                throw new IllegalArgumentException("[" + argumentPointers.size() + "] Arguments Found - An IF formula requires 2 or 3 arguments. IF(CONDITION, TRUE_VALUE, FALSE_VALUE [OPTIONAL]");
            }
            int ifIndex = this.tokens.indexOf(argumentPointers.get(0)) + 1;
            this.tokens.add(ifIndex, ifPtg);
            int gotoIndex = this.tokens.indexOf(argumentPointers.get(1)) + 1;
            AttrPtg goto1Ptg = new AttrPtg();
            goto1Ptg.setGoto(true);
            this.tokens.add(gotoIndex, goto1Ptg);
            if (numArgs > 2) {
                AttrPtg goto2Ptg = new AttrPtg();
                goto2Ptg.setGoto(true);
                goto2Ptg.setData((short)(((AbstractFunctionPtg)retval).getSize() - 1));
                this.tokens.add(goto2Ptg);
            }
            ifPtg.setData((short)this.getPtgSize(ifIndex + 1, gotoIndex));
            int ptgCount = this.getPtgSize(gotoIndex) - goto1Ptg.getSize() + ((AbstractFunctionPtg)retval).getSize();
            if (ptgCount > Short.MAX_VALUE) {
                throw new RuntimeException("Ptg Size exceeds short when being specified for a goto ptg in an if");
            }
            goto1Ptg.setData((short)(ptgCount - 1));
        } else {
            retval = new FuncVarPtg(name, numArgs);
        }
        return retval;
    }

    private int Arguments() {
        int numArgs = 0;
        if (this.look != ')') {
            ++numArgs;
            this.Expression();
            this.addArgumentPointer();
        }
        while (this.look == ',' || this.look == ';') {
            if (this.look == ',') {
                this.Match(',');
            } else {
                this.Match(';');
            }
            this.Expression();
            this.addArgumentPointer();
            ++numArgs;
        }
        return numArgs;
    }

    private void Factor() {
        if (this.look == '-') {
            this.Match('-');
            this.Factor();
            this.tokens.add(new UnaryMinusPtg());
        } else if (this.look == '(') {
            this.Match('(');
            this.Expression();
            this.Match(')');
            this.tokens.add(new ParenthesisPtg());
        } else if (this.IsAlpha(this.look) || this.look == '\'') {
            this.Ident();
        } else if (this.look == '\"') {
            this.StringLiteral();
        } else {
            String number = this.GetNum();
            if (this.look == '.') {
                this.Match('.');
                Object decimalPart = null;
                if (this.IsDigit(this.look)) {
                    number = number + "." + this.GetNum();
                }
                this.tokens.add(new NumberPtg(number));
            } else {
                this.tokens.add(new IntPtg(number));
            }
        }
    }

    private void StringLiteral() {
        if (this.look != '\"') {
            this.Expected("\"");
        } else {
            this.GetChar();
            StringBuffer Token2 = new StringBuffer();
            while (true) {
                if (this.look == '\"') {
                    this.GetChar();
                    this.SkipWhite();
                    if (this.look != '\"') break;
                    Token2.append("\"");
                    continue;
                }
                if (this.look == '\u0000') break;
                Token2.append(this.look);
                this.GetChar();
            }
            this.tokens.add(new StringPtg(Token2.toString()));
        }
    }

    private void Multiply() {
        this.Match('*');
        this.Factor();
        this.tokens.add(new MultiplyPtg());
    }

    private void Divide() {
        this.Match('/');
        this.Factor();
        this.tokens.add(new DividePtg());
    }

    private void Term() {
        this.Factor();
        while (this.look == '*' || this.look == '/' || this.look == '^' || this.look == '&') {
            if (this.look == '*') {
                this.Multiply();
                continue;
            }
            if (this.look == '/') {
                this.Divide();
                continue;
            }
            if (this.look == '^') {
                this.Power();
                continue;
            }
            if (this.look != '&') continue;
            this.Concat();
        }
    }

    private void Add() {
        this.Match('+');
        this.Term();
        this.tokens.add(new AddPtg());
    }

    private void Concat() {
        this.Match('&');
        this.Term();
        this.tokens.add(new ConcatPtg());
    }

    private void Equal() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new EqualPtg());
    }

    private void Subtract() {
        this.Match('-');
        this.Term();
        this.tokens.add(new SubtractPtg());
    }

    private void Power() {
        this.Match('^');
        this.Term();
        this.tokens.add(new PowerPtg());
    }

    private void Expression() {
        this.Term();
        while (this.IsAddop(this.look)) {
            if (this.look == '+') {
                this.Add();
                continue;
            }
            if (this.look != '-') continue;
            this.Subtract();
        }
        if (this.look == '=' || this.look == '>' || this.look == '<') {
            if (this.look == '=') {
                this.Equal();
            } else if (this.look == '>') {
                this.GreaterThan();
            } else if (this.look == '<') {
                this.LessThan();
            }
            return;
        }
    }

    private void GreaterThan() {
        this.Match('>');
        if (this.look == '=') {
            this.GreaterEqual();
        } else {
            this.Expression();
            this.tokens.add(new GreaterThanPtg());
        }
    }

    private void LessThan() {
        this.Match('<');
        if (this.look == '=') {
            this.LessEqual();
        } else if (this.look == '>') {
            this.NotEqual();
        } else {
            this.Expression();
            this.tokens.add(new LessThanPtg());
        }
    }

    private void GreaterEqual() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new GreaterEqualPtg());
    }

    private void LessEqual() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new LessEqualPtg());
    }

    private void NotEqual() {
        this.Match('>');
        this.Expression();
        this.tokens.add(new NotEqualPtg());
    }

    private void init() {
        this.GetChar();
        this.SkipWhite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        List list = this.tokens;
        synchronized (list) {
            this.init();
            this.Expression();
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(FORMULA_TYPE_CELL);
    }

    public Ptg[] getRPNPtg(int formulaType) {
        Node node = this.createTree();
        this.setRootLevelRVA(node, formulaType);
        this.setParameterRVA(node, formulaType);
        return this.tokens.toArray(new Ptg[0]);
    }

    private void setRootLevelRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            } else {
                this.setClass(n, (byte)64);
            }
        } else {
            this.setClass(n, (byte)32);
        }
    }

    private void setParameterRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg) {
            int numOperands = n.getNumChildren();
            for (int i = 0; i < n.getNumChildren(); ++i) {
                this.setParameterRVA(n.getChild(i), ((AbstractFunctionPtg)p).getParameterClass(i), formulaType);
                if (!(n.getChild(i).getValue() instanceof AbstractFunctionPtg)) continue;
                this.setParameterRVA(n.getChild(i), formulaType);
            }
        } else {
            for (int i = 0; i < n.getNumChildren(); ++i) {
                this.setParameterRVA(n.getChild(i), formulaType);
            }
        }
    }

    private void setParameterRVA(Node n, int expectedClass, int formulaType) {
        Ptg p = n.getValue();
        if (expectedClass == 0) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            }
            if (p.getDefaultOperandClass() == 32) {
                if (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED) {
                    this.setClass(n, (byte)32);
                } else {
                    this.setClass(n, (byte)64);
                }
            }
            if (p.getDefaultOperandClass() == 64) {
                this.setClass(n, (byte)64);
            }
        } else if (expectedClass == 32) {
            if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
                this.setClass(n, (byte)64);
            } else {
                this.setClass(n, (byte)32);
            }
        } else if (p.getDefaultOperandClass() == 32 && (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED)) {
            this.setClass(n, (byte)32);
        } else {
            this.setClass(n, (byte)64);
        }
    }

    private void setClass(Node n, byte theClass) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg || !(p instanceof OperationPtg)) {
            p.setClass(theClass);
        } else {
            for (int i = 0; i < n.getNumChildren(); ++i) {
                this.setClass(n.getChild(i), theClass);
            }
        }
    }

    public static String toFormulaString(Workbook book, List lptgs) {
        String retval = null;
        if (lptgs == null || lptgs.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgs = new Ptg[lptgs.size()];
        ptgs = lptgs.toArray(ptgs);
        retval = FormulaParser.toFormulaString(book, ptgs);
        return retval;
    }

    public static String toFormulaString(Workbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        AttrPtg ifptg = null;
        stack.push(ptgs[0].toFormulaString(book));
        for (int i = 1; i < ptgs.length; ++i) {
            AbstractFunctionPtg f;
            String fname;
            if (!(ptgs[i] instanceof OperationPtg)) {
                stack.push(ptgs[i].toFormulaString(book));
                continue;
            }
            if (ptgs[i] instanceof AttrPtg && ((AttrPtg)ptgs[i]).isOptimizedIf()) {
                ifptg = (AttrPtg)ptgs[i];
                continue;
            }
            OperationPtg o = (OperationPtg)ptgs[i];
            String[] operands = new String[o.getNumberOfOperands()];
            for (int j = operands.length; j > 0; --j) {
                operands[j - 1] = (String)stack.pop();
            }
            stack.push(o.toFormulaString(operands));
            if (!(o instanceof AbstractFunctionPtg) || (fname = (f = (AbstractFunctionPtg)o).getName()) == null) continue;
            if (ifptg != null && fname.equals("specialflag")) {
                stack.push(ifptg.toFormulaString(new String[]{(String)stack.pop()}));
                continue;
            }
            if (!fname.equals("externalflag")) continue;
            String top = (String)stack.pop();
            int paren = top.indexOf(40);
            int comma = top.indexOf(44);
            if (comma == -1) {
                int rparen = top.indexOf(41);
                stack.push(top.substring(paren + 1, rparen) + "()");
                continue;
            }
            stack.push(top.substring(paren + 1, comma) + '(' + top.substring(comma + 1));
        }
        return (String)stack.pop();
    }

    private Node createTree() {
        Stack<Node> stack = new Stack<Node>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            if (this.tokens.get(i) instanceof OperationPtg) {
                OperationPtg o = (OperationPtg)this.tokens.get(i);
                int numOperands = o.getNumberOfOperands();
                Node[] operands = new Node[numOperands];
                for (int j = 0; j < numOperands; ++j) {
                    operands[numOperands - j - 1] = (Node)stack.pop();
                }
                Node result = new Node(o);
                result.setChildren(operands);
                stack.push(result);
                continue;
            }
            stack.push(new Node((Ptg)this.tokens.get(i)));
        }
        return (Node)stack.pop();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            buf.append(((Ptg)this.tokens.get(i)).toFormulaString(this.book));
            buf.append(' ');
        }
        return buf.toString();
    }
}

