/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Date;
import java.util.GregorianCalendar;

public class MoonCalculation {
    private int fullMoon = 14;
    private int firstQuaterMoon = 7;
    private int thirdQuaterMoon = 22;
    private static final int[] day_year = new int[]{-1, -1, 30, 58, 89, 119, 150, 180, 211, 241, 272, 303, 333};
    private static final String[] moon_phase_name = new String[]{"New", "Waxing crescent", "First quarter", "Waxing gibbous", "Full", "Waning gibbous", "Third quarter", "Waning crescent"};
    private GregorianCalendar calendar = new GregorianCalendar();

    public int moonPhase(int year, int month, int day) {
        int cent;
        int golden;
        int epact;
        if (month < 0 || month > 12) {
            month = 0;
        }
        int diy = day + day_year[month];
        if (month > 2 && this.isLeapYearP(year)) {
            ++diy;
        }
        if ((epact = (11 * (golden = year % 19 + 1) + 20 + (8 * (cent = year / 100 + 1) + 5) / 25 - 5 - (3 * cent / 4 - 12)) % 30) <= 0) {
            epact += 30;
        }
        if (epact == 25 && golden > 11 || epact == 24) {
            ++epact;
        }
        int phase = ((diy + epact) * 6 + 11) % 177 / 6;
        return phase;
    }

    int daysInMonth(int month, int year) {
        int result = 31;
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                result = 30;
                break;
            }
            case 2: {
                result = this.isLeapYearP(year) ? 29 : 28;
            }
        }
        return result;
    }

    public boolean isLeapYearP(int year) {
        return year % 4 == 0 && (year % 400 == 0 || year % 100 != 0);
    }

    String phaseName(int phase) {
        return moon_phase_name[phase];
    }

    public Graphics drawMoon(Graphics g, Date d, int posX, int posY, int size) {
        this.calendar.setTime(d);
        int newPhase = this.moonPhase(this.calendar.get(1), this.calendar.get(2) + 1, this.calendar.get(5));
        if (newPhase == 0) {
            g.setColor(Color.BLACK);
            g.fillOval(posX, posY, size, size);
        } else if (newPhase == this.fullMoon) {
            g.setColor(Color.BLACK);
            g.drawOval(posX, posY, size, size);
            g.setColor(Color.yellow);
            g.fillOval(posX + 1, posY + 1, size - 1, size - 2);
        } else if (newPhase == this.firstQuaterMoon) {
            g.setColor(Color.BLACK);
            g.drawOval(posX, posY, size, size);
            g.fillArc(posX + 1, posY + 1, size - 1, size - 1, 90, 180);
            g.setColor(Color.yellow);
            g.fillArc(posX + 1, posY + 1, size - 1, size - 1, 270, 180);
        } else if (newPhase == this.thirdQuaterMoon) {
            g.setColor(Color.BLACK);
            g.drawOval(posX, posY, size, size);
            g.fillArc(posX + 1, posY + 1, size - 1, size - 1, 270, 180);
            g.setColor(Color.yellow);
            g.fillArc(posX + 1, posY + 1, size - 1, size - 1, 90, 180);
        }
        return g;
    }
}

