/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreportReturnValue;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillSubreport
extends JRFillElement
implements Runnable,
JRSubreport {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFillSubreport == null ? (class$net$sf$jasperreports$engine$fill$JRFillSubreport = JRFillSubreport.class$("net.sf.jasperreports.engine.fill.JRFillSubreport")) : class$net$sf$jasperreports$engine$fill$JRFillSubreport));
    private Map parameterValues = null;
    private JRSubreportParameter[] parameters = null;
    private Connection connection = null;
    private JRDataSource dataSource = null;
    private JasperReport jasperReport = null;
    private JRCalculator calculator = null;
    private JRFillSubreportReturnValue[] returnValues = null;
    private JRBaseFiller subreportFiller = null;
    private JRPrintPage printPage = null;
    private JRReportFont[] subreportFonts = null;
    private Throwable error = null;
    private Thread fillThread = null;
    private boolean isRunning = false;
    private Set checkedReports;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFillSubreport;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JasperReport;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    protected JRFillSubreport(JRBaseFiller filler, JRSubreport subreport, JRFillObjectFactory factory) {
        super(filler, subreport, factory);
        this.parameters = subreport.getParameters();
        JRSubreportReturnValue[] subrepReturnValues = subreport.getReturnValues();
        if (subrepReturnValues != null) {
            ArrayList returnValuesList = new ArrayList(subrepReturnValues.length * 2);
            this.returnValues = new JRFillSubreportReturnValue[subrepReturnValues.length];
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.addReturnValue(subrepReturnValues[i], returnValuesList, factory);
            }
            this.returnValues = new JRFillSubreportReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
        this.checkedReports = new HashSet();
    }

    public boolean isUsingCache() {
        return ((JRSubreport)this.parent).isUsingCache();
    }

    public void setUsingCache(boolean isUsingCache) {
    }

    public JRExpression getParametersMapExpression() {
        return ((JRSubreport)this.parent).getParametersMapExpression();
    }

    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return ((JRSubreport)this.parent).getConnectionExpression();
    }

    public JRExpression getDataSourceExpression() {
        return ((JRSubreport)this.parent).getDataSourceExpression();
    }

    public JRExpression getExpression() {
        return ((JRSubreport)this.parent).getExpression();
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        if (this.template == null) {
            JRDesignRectangle rectangle = new JRDesignRectangle();
            rectangle.setKey(this.getKey());
            rectangle.setPositionType(this.getPositionType());
            rectangle.setMode(this.getMode());
            rectangle.setX(this.getX());
            rectangle.setY(this.getY());
            rectangle.setWidth(this.getWidth());
            rectangle.setHeight(this.getHeight());
            rectangle.setRemoveLineWhenBlank(this.isRemoveLineWhenBlank());
            rectangle.setPrintInFirstWholeBand(this.isPrintInFirstWholeBand());
            rectangle.setPrintWhenDetailOverflows(this.isPrintWhenDetailOverflows());
            rectangle.setPrintWhenGroupChanges(this.getPrintWhenGroupChanges());
            rectangle.setForecolor(this.getForecolor());
            rectangle.setBackcolor(this.getBackcolor());
            rectangle.setPen((byte)0);
            this.template = new JRTemplateRectangle(rectangle);
        }
        return (JRTemplateRectangle)this.template;
    }

    protected JRReportFont[] getFonts() {
        return this.subreportFonts;
    }

    protected Collection getPrintElements() {
        List printElements = null;
        if (this.printPage != null) {
            printElements = this.printPage.getElements();
        }
        return printElements;
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRExpression expression;
        Object source;
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && (source = this.filler.calculator.evaluate(expression = this.getExpression(), evaluation)) != null) {
            if (this.isUsingCache() && this.filler.loadedSubreports.containsKey(source)) {
                this.jasperReport = (JasperReport)this.filler.loadedSubreports.get(source);
                this.calculator = (JRCalculator)this.filler.loadedCalculators.get(this.jasperReport);
            } else {
                Class expressionClass = expression.getValueClass();
                if (expressionClass.equals(class$net$sf$jasperreports$engine$JasperReport == null ? (class$net$sf$jasperreports$engine$JasperReport = JRFillSubreport.class$("net.sf.jasperreports.engine.JasperReport")) : class$net$sf$jasperreports$engine$JasperReport)) {
                    this.jasperReport = (JasperReport)source;
                } else if (expressionClass.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRFillSubreport.class$("java.io.InputStream")) : class$java$io$InputStream)) {
                    InputStream is = (InputStream)source;
                    this.jasperReport = (JasperReport)JRLoader.loadObject(is);
                } else if (expressionClass.equals(class$java$net$URL == null ? (class$java$net$URL = JRFillSubreport.class$("java.net.URL")) : class$java$net$URL)) {
                    URL url = (URL)source;
                    this.jasperReport = (JasperReport)JRLoader.loadObject(url);
                } else if (expressionClass.equals(class$java$io$File == null ? (class$java$io$File = JRFillSubreport.class$("java.io.File")) : class$java$io$File)) {
                    File file = (File)source;
                    this.jasperReport = (JasperReport)JRLoader.loadObject(file);
                } else if (expressionClass.equals(class$java$lang$String == null ? (class$java$lang$String = JRFillSubreport.class$("java.lang.String")) : class$java$lang$String)) {
                    String location = (String)source;
                    this.jasperReport = (JasperReport)JRLoader.loadObjectFromLocation(location);
                }
                if (this.jasperReport != null) {
                    this.calculator = JRDefaultCompiler.getInstance().loadCalculator(this.jasperReport);
                }
                if (this.isUsingCache()) {
                    this.filler.loadedSubreports.put(source, this.jasperReport);
                    this.filler.loadedCalculators.put(this.jasperReport, this.calculator);
                }
            }
            if (this.jasperReport != null) {
                expression = this.getParametersMapExpression();
                this.parameterValues = (Map)this.filler.calculator.evaluate(expression, evaluation);
                if (this.parameterValues != null) {
                    this.parameterValues.remove("REPORT_LOCALE");
                    this.parameterValues.remove("REPORT_RESOURCE_BUNDLE");
                    this.parameterValues.remove("REPORT_CONNECTION");
                    this.parameterValues.remove("REPORT_MAX_COUNT");
                    this.parameterValues.remove("REPORT_DATA_SOURCE");
                    this.parameterValues.remove("REPORT_SCRIPTLET");
                    this.parameterValues.remove("REPORT_VIRTUALIZER");
                    this.parameterValues.remove("IS_IGNORE_PAGINATION");
                    this.parameterValues.remove("REPORT_PARAMETERS_MAP");
                }
                expression = this.getConnectionExpression();
                this.connection = (Connection)this.filler.calculator.evaluate(expression, evaluation);
                expression = this.getDataSourceExpression();
                this.dataSource = (JRDataSource)this.filler.calculator.evaluate(expression, evaluation);
                JRSubreportParameter[] subreportParameters = this.getParameters();
                if (subreportParameters != null && subreportParameters.length > 0) {
                    if (this.parameterValues == null) {
                        this.parameterValues = new HashMap();
                    }
                    Object parameterValue = null;
                    for (int i = 0; i < subreportParameters.length; ++i) {
                        expression = subreportParameters[i].getExpression();
                        parameterValue = this.filler.calculator.evaluate(expression, evaluation);
                        if (parameterValue == null) {
                            this.parameterValues.remove(subreportParameters[i].getName());
                            continue;
                        }
                        this.parameterValues.put(subreportParameters[i].getName(), parameterValue);
                    }
                }
                if (this.subreportFiller != null) {
                    this.filler.unregisterSubfiller(this.subreportFiller);
                }
                switch (this.jasperReport.getPrintOrder()) {
                    case 2: {
                        this.subreportFiller = new JRHorizontalFiller(this.jasperReport, this.calculator, this.filler);
                        break;
                    }
                    case 1: {
                        this.subreportFiller = new JRVerticalFiller(this.jasperReport, this.calculator, this.filler);
                    }
                }
                this.checkReturnValues();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        this.error = null;
        try {
            if (this.getConnectionExpression() != null) {
                this.subreportFiller.fill(this.parameterValues, this.connection);
            } else {
                this.subreportFiller.fill(this.parameterValues, this.dataSource);
            }
        }
        catch (JRFillInterruptedException e) {
        }
        catch (Throwable t) {
            this.error = t;
        }
        this.isRunning = false;
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean prepare(int availableStretchHeight, boolean isOverflow) {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (this.subreportFiller == null) {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        this.subreportFiller.setPageHeight(this.getHeight() + availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY());
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            block16: {
                if (this.fillThread == null) {
                    if (!isOverflow || isOverflow && (this.isPrintWhenDetailOverflows() || !this.isAlreadyPrinted())) {
                        if (isOverflow && this.isPrintWhenDetailOverflows()) {
                            this.setReprinted(true);
                        }
                        this.fillThread = new Thread(this);
                        this.fillThread.start();
                        break block16;
                    } else {
                        this.printPage = null;
                        this.subreportFonts = null;
                        this.setStretchHeight(this.getHeight());
                        this.setToPrint(false);
                        return willOverflow;
                    }
                }
                this.subreportFiller.notifyAll();
            }
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", e);
            }
            if (!this.isRunning) {
                this.copyValues();
            }
            if (this.error != null) {
                if (this.error instanceof RuntimeException) {
                    throw (RuntimeException)this.error;
                }
                throw new JRRuntimeException(this.error);
            }
            this.printPage = this.subreportFiller.getCurrentPage();
            this.subreportFonts = this.subreportFiller.getFonts();
            this.setStretchHeight(this.subreportFiller.getCurrentPageStretchHeight());
            willOverflow = this.isRunning;
            if (!willOverflow) {
                this.fillThread = null;
            }
        }
        Collection printElements = this.getPrintElements();
        if ((printElements == null || printElements.size() == 0) && this.isRemoveLineWhenBlank()) {
            this.setToPrint(false);
        }
        return willOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() throws JRException {
        if (this.subreportFiller == null) {
            return;
        }
        this.subreportFiller.setInterrupted(true);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
            if (this.isRunning) {
                try {
                    this.subreportFiller.wait();
                }
                catch (InterruptedException e) {
                    throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
                }
            }
        }
        this.fillThread = null;
        if (this.subreportFiller != null) {
            this.filler.unregisterSubfiller(this.subreportFiller);
        }
        switch (this.jasperReport.getPrintOrder()) {
            case 2: {
                this.subreportFiller = new JRHorizontalFiller(this.jasperReport, this.filler);
                break;
            }
            case 1: {
                this.subreportFiller = new JRVerticalFiller(this.jasperReport, this.filler);
            }
        }
        if (this.getConnectionExpression() == null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"The subreport is placed on a non-splitting band, but it does not have a rewindable data source.");
            }
        }
    }

    protected JRPrintElement fill() {
        JRTemplatePrintRectangle printRectangle = null;
        printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getSubreport(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) {
        xmlWriter.writeSubreport(this);
    }

    private JRFillSubreportReturnValue addReturnValue(JRSubreportReturnValue parentReturnValue, List returnValueList, JRFillObjectFactory factory) {
        JRFillSubreportReturnValue returnValue = factory.getSubreportReturnValue(parentReturnValue);
        byte calculation = returnValue.getCalculation();
        switch (calculation) {
            case 3: 
            case 7: {
                JRSubreportReturnValue countVal = this.createHelperReturnValue(parentReturnValue, "_COUNT", (byte)1);
                this.addReturnValue(countVal, returnValueList, factory);
                JRSubreportReturnValue sumVal = this.createHelperReturnValue(parentReturnValue, "_SUM", (byte)2);
                this.addReturnValue(sumVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case 6: {
                JRSubreportReturnValue varianceVal = this.createHelperReturnValue(parentReturnValue, "_VARIANCE", (byte)7);
                this.addReturnValue(varianceVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
        }
        returnValueList.add(returnValue);
        return returnValue;
    }

    protected JRSubreportReturnValue createHelperReturnValue(JRSubreportReturnValue returnValue, String nameSuffix, byte calculation) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    private void copyValues() {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                try {
                    JRFillVariable variable = (JRFillVariable)this.filler.variablesMap.get(this.returnValues[i].getToVariable());
                    Object value = this.subreportFiller.getVariableValue(this.returnValues[i].getSubreportVariable());
                    Object newValue = this.returnValues[i].getIncrementer().increment(variable, value, AbstractValueProvider.getCurrentValueProvider());
                    variable.setOldValue(newValue);
                    variable.setValue(newValue);
                    continue;
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
    }

    private void checkReturnValues() throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0 && !this.checkedReports.contains(this.jasperReport)) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                JRFillSubreportReturnValue returnValue = this.returnValues[i];
                String subreportVariableName = returnValue.getSubreportVariable();
                JRVariable subrepVariable = (JRVariable)this.subreportFiller.variablesMap.get(subreportVariableName);
                if (subrepVariable == null) {
                    throw new JRException("Subreport variable " + subreportVariableName + " not found.");
                }
                JRVariable variable = (JRVariable)this.filler.variablesMap.get(returnValue.getToVariable());
                if (returnValue.getCalculation() == 1) {
                    if ((class$java$lang$Number == null ? JRFillSubreport.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(variable.getValueClass())) continue;
                    throw new JRException("Variable " + returnValue.getToVariable() + " must have a numeric type.");
                }
                if (variable.getValueClass().isAssignableFrom(subrepVariable.getValueClass()) || (class$java$lang$Number == null ? JRFillSubreport.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(variable.getValueClass()) && (class$java$lang$Number == null ? JRFillSubreport.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(subrepVariable.getValueClass())) continue;
                throw new JRException("Variable " + returnValue.getToVariable() + " is not assignable from subreport variable " + subreportVariableName);
            }
            this.checkedReports.add(this.jasperReport);
        }
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    public Boolean isOwnUsingCache() {
        return ((JRSubreport)this.parent).isOwnUsingCache();
    }

    public void setUsingCache(Boolean isUsingCache) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

