/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.LinkedList;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.CriteriaReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

public abstract class FilterReader {
    protected abstract Integer getVarDataType();

    protected abstract CriteriaReader getCriteriaReader();

    public void process(ProjectFile projectFile, FixedData fixedData, Var2Data var2Data) {
        int n = fixedData.getItemCount();
        boolean[] blArray = new boolean[2];
        CriteriaReader criteriaReader = this.getCriteriaReader();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null || byArray.length < 4) continue;
            Filter filter = new Filter();
            filter.setID(MPPUtility.getInt(byArray, 0));
            filter.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(byArray, 4)));
            byte[] byArray2 = var2Data.getByteArray(filter.getID(), this.getVarDataType());
            if (byArray2 == null) continue;
            LinkedList<GenericCriteriaPrompt> linkedList = new LinkedList<GenericCriteriaPrompt>();
            filter.setShowRelatedSummaryRows(MPPUtility.getByte(byArray2, 4) != 0);
            filter.setCriteria(criteriaReader.process(projectFile, byArray2, 0, -1, linkedList, null, blArray));
            filter.setIsTaskFilter(blArray[0]);
            filter.setIsResourceFilter(blArray[1]);
            filter.setPrompts(linkedList);
            projectFile.addFilter(filter);
        }
    }
}

