/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHeader
extends ProjectEntity {
    private String m_currencySymbol;
    private CurrencySymbolPosition m_symbolPosition = CurrencySymbolPosition.BEFORE;
    private Number m_currencyDigits;
    private char m_thousandsSeparator;
    private char m_decimalSeparator;
    private TimeUnit m_defaultDurationUnits = TimeUnit.DAYS;
    private boolean m_defaultDurationIsFixed;
    private TimeUnit m_defaultWorkUnits;
    private Rate m_defaultStandardRate;
    private Rate m_defaultOvertimeRate;
    private boolean m_updatingTaskStatusUpdatesResourceStatus;
    private boolean m_splitInProgressTasks;
    private DateOrder m_dateOrder = DateOrder.MDY;
    private ProjectTimeFormat m_timeFormat = ProjectTimeFormat.TWELVE_HOUR;
    private Date m_defaultStartTime;
    private char m_dateSeparator;
    private char m_timeSeparator;
    private String m_amText;
    private String m_pmText;
    private ProjectDateFormat m_dateFormat = ProjectDateFormat.DD_MM_YY;
    private ProjectDateFormat m_barTextDateFormat;
    private String m_projectTitle;
    private String m_company;
    private String m_manager;
    private String m_calendarName;
    private Date m_startDate;
    private Date m_finishDate;
    private ScheduleFrom m_scheduleFrom = ScheduleFrom.START;
    private Date m_currentDate;
    private String m_comments;
    private Number m_cost;
    private Number m_baselineCost;
    private Number m_actualCost;
    private Duration m_work;
    private Duration m_baselineWork;
    private Duration m_actualWork;
    private Number m_work2;
    private Duration m_duration;
    private Duration m_baselineDuration;
    private Duration m_actualDuration;
    private Number m_percentageComplete;
    private Date m_baselineStart;
    private Date m_baselineFinish;
    private Date m_actualStart;
    private Date m_actualFinish;
    private Duration m_startVariance;
    private Duration m_finishVariance;
    private String m_subject;
    private String m_author;
    private String m_keywords;
    private String m_hyperlinkBase;
    private Date m_defaultEndTime;
    private boolean m_projectExternallyEdited;
    private String m_category;
    private Number m_minutesPerDay;
    private Number m_daysPerMonth;
    private Number m_minutesPerWeek;
    private boolean m_fiscalYearStart;
    private EarnedValueMethod m_defaultTaskEarnedValueMethod;
    private boolean m_removeFileProperties;
    private boolean m_moveCompletedEndsBack;
    private boolean m_newTasksEstimated;
    private boolean m_spreadActualCost;
    private boolean m_multipleCriticalPaths;
    private boolean m_autoAddNewResourcesAndTasks;
    private Date m_lastSaved;
    private Date m_statusDate;
    private boolean m_moveRemainingStartsBack;
    private boolean m_autolink;
    private boolean m_microsoftProjectServerURL;
    private boolean m_honorConstraints;
    private boolean m_adminProject;
    private boolean m_insertedProjectsLikeSummary;
    private String m_name;
    private boolean m_spreadPercentComplete;
    private boolean m_moveCompletedEndsForward;
    private boolean m_editableActualCosts;
    private String m_uniqueID;
    private Integer m_revision;
    private boolean m_newTasksEffortDriven;
    private boolean m_moveRemainingStartsForward;
    private boolean m_actualsInSync;
    private TaskType m_defaultTaskType;
    private EarnedValueMethod m_earnedValueMethod;
    private Date m_creationDate;
    private Date m_extendedCreationDate;
    private AccrueType m_defaultFixedCostAccrual;
    private Integer m_criticalSlackLimit;
    private Integer m_baselineForEarnedValue;
    private Integer m_fiscalYearStartMonth;
    private boolean m_newTaskStartIsProjectStart;
    private Day m_weekStartDay;
    private boolean m_calculateMultipleCriticalPaths;
    private Map<Integer, Object> m_documentSummaryInformation;
    private String m_currencyCode;
    private boolean m_showProjectSummaryTask;
    private Date[] m_baselineDate = new Date[11];
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final Double DEFAULT_COST = 0.0;
    private static final Integer DEFAULT_CRITICAL_SLACK_LIMIT = 0;
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = 0;
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = 1;
    private static final Day DEFAULT_WEEK_START_DAY = Day.MONDAY;
    private static final Duration DEFAULT_WORK = Duration.getInstance(0, TimeUnit.HOURS);
    private static final Double DEFAULT_WORK2 = 0.0;
    private static final Duration DEFAULT_DURATION = Duration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Double DEFAULT_PERCENT_COMPLETE = 0.0;
    private static final String DEFAULT_CALENDAR_NAME = "Standard";
    private static final Integer DEFAULT_MINUTES_PER_DAY = 480;
    private static final Integer DEFAULT_DAYS_PER_MONTH = 20;
    private static final Integer DEFAULT_MINUTES_PER_WEEK = 2400;

    ProjectHeader(ProjectFile projectFile) {
        super(projectFile);
        this.setCurrencySymbol("$");
        this.setSymbolPosition(CurrencySymbolPosition.BEFORE);
        this.setCurrencyDigits(2);
        this.setThousandsSeparator(',');
        this.setDecimalSeparator('.');
        this.setDateOrder(DateOrder.DMY);
        this.setTimeFormat(ProjectTimeFormat.TWELVE_HOUR);
        this.setIntegerDefaultStartTime(480);
        this.setDateSeparator('/');
        this.setTimeSeparator(':');
        this.setAMText("am");
        this.setPMText("pm");
        this.setDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setBarTextDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setMinutesPerDay(480);
        this.setMinutesPerWeek(2400);
        this.setDefaultStandardRate(new Rate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new Rate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setCalendarName(DEFAULT_CALENDAR_NAME);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(new Date());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
    }

    public TimeUnit getDefaultDurationUnits() {
        return this.m_defaultDurationUnits;
    }

    public void setDefaultDurationUnits(TimeUnit timeUnit) {
        this.m_defaultDurationUnits = timeUnit;
    }

    public boolean getDefaultDurationIsFixed() {
        return this.m_defaultDurationIsFixed;
    }

    public void setDefaultDurationIsFixed(boolean bl) {
        this.m_defaultDurationIsFixed = bl;
    }

    public TimeUnit getDefaultWorkUnits() {
        return this.m_defaultWorkUnits;
    }

    public void setDefaultWorkUnits(TimeUnit timeUnit) {
        this.m_defaultWorkUnits = timeUnit;
    }

    public Rate getDefaultStandardRate() {
        return this.m_defaultStandardRate;
    }

    public void setDefaultStandardRate(Rate rate) {
        this.m_defaultStandardRate = rate;
    }

    public Rate getDefaultOvertimeRate() {
        return this.m_defaultOvertimeRate;
    }

    public void setDefaultOvertimeRate(Rate rate) {
        this.m_defaultOvertimeRate = rate;
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return this.m_updatingTaskStatusUpdatesResourceStatus;
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean bl) {
        this.m_updatingTaskStatusUpdatesResourceStatus = bl;
    }

    public boolean getSplitInProgressTasks() {
        return this.m_splitInProgressTasks;
    }

    public void setSplitInProgressTasks(boolean bl) {
        this.m_splitInProgressTasks = bl;
    }

    public DateOrder getDateOrder() {
        return this.m_dateOrder;
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.m_dateOrder = dateOrder;
    }

    public ProjectTimeFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(ProjectTimeFormat projectTimeFormat) {
        this.m_timeFormat = projectTimeFormat;
    }

    public void setIntegerDefaultStartTime(Integer n) {
        if (n != null) {
            int n2 = n;
            int n3 = n2 / 60;
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, n2 -= n3 * 60);
            calendar.set(11, n3);
            Date date = calendar.getTime();
            this.setDefaultStartTime(date);
        }
    }

    public Date getDefaultStartTime() {
        return this.m_defaultStartTime;
    }

    public void setDefaultStartTime(Date date) {
        this.m_defaultStartTime = date;
    }

    public char getDateSeparator() {
        return this.m_dateSeparator;
    }

    public void setDateSeparator(char c) {
        this.m_dateSeparator = c;
    }

    public char getTimeSeparator() {
        return this.m_timeSeparator;
    }

    public void setTimeSeparator(char c) {
        this.m_timeSeparator = c;
    }

    public void setTimeSeparator(Character c) {
        this.setTimeSeparator(c == null ? (char)':' : (char)c.charValue());
    }

    public String getAMText() {
        return this.m_amText;
    }

    public void setAMText(String string) {
        this.m_amText = string;
    }

    public String getPMText() {
        return this.m_pmText;
    }

    public void setPMText(String string) {
        this.m_pmText = string;
    }

    public ProjectDateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(ProjectDateFormat projectDateFormat) {
        this.m_dateFormat = projectDateFormat;
    }

    public ProjectDateFormat getBarTextDateFormat() {
        return this.m_barTextDateFormat;
    }

    public void setBarTextDateFormat(ProjectDateFormat projectDateFormat) {
        this.m_barTextDateFormat = projectDateFormat;
    }

    public Date getDefaultEndTime() {
        return this.m_defaultEndTime;
    }

    public void setDefaultEndTime(Date date) {
        this.m_defaultEndTime = date;
    }

    public void setProjectTitle(String string) {
        this.m_projectTitle = string;
    }

    public String getProjectTitle() {
        return this.m_projectTitle;
    }

    public void setCompany(String string) {
        this.m_company = string;
    }

    public String getCompany() {
        return this.m_company;
    }

    public void setManager(String string) {
        this.m_manager = string;
    }

    public String getManager() {
        return this.m_manager;
    }

    public void setCalendarName(String string) {
        if (string == null || string.length() == 0) {
            string = DEFAULT_CALENDAR_NAME;
        }
        this.m_calendarName = string;
    }

    public String getCalendarName() {
        return this.m_calendarName;
    }

    public void setStartDate(Date date) {
        this.m_startDate = date;
    }

    public Date getStartDate() {
        Date date = this.m_startDate;
        if (date == null) {
            date = this.getParentFile().getStartDate();
        }
        return date;
    }

    public Date getFinishDate() {
        Date date = this.m_finishDate;
        if (date == null) {
            date = this.getParentFile().getFinishDate();
        }
        return date;
    }

    public void setFinishDate(Date date) {
        this.m_finishDate = date;
    }

    public ScheduleFrom getScheduleFrom() {
        return this.m_scheduleFrom;
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.m_scheduleFrom = scheduleFrom;
    }

    public Date getCurrentDate() {
        return this.m_currentDate;
    }

    public void setCurrentDate(Date date) {
        this.m_currentDate = date;
    }

    public String getComments() {
        return this.m_comments;
    }

    public void setComments(String string) {
        this.m_comments = string;
    }

    public Number getCost() {
        return this.m_cost;
    }

    public void setCost(Number number) {
        this.m_cost = number;
    }

    public void setBaselineCost(Number number) {
        this.m_baselineCost = number;
    }

    public Number getBaselineCost() {
        return this.m_baselineCost;
    }

    public void setActualCost(Number number) {
        this.m_actualCost = number;
    }

    public Number getActualCost() {
        return this.m_actualCost;
    }

    public void setWork(Duration duration) {
        this.m_work = duration;
    }

    public Duration getWork() {
        return this.m_work;
    }

    public void setBaselineWork(Duration duration) {
        this.m_baselineWork = duration;
    }

    public Duration getBaselineWork() {
        return this.m_baselineWork;
    }

    public void setActualWork(Duration duration) {
        this.m_actualWork = duration;
    }

    public Duration getActualWork() {
        return this.m_actualWork;
    }

    public Number getWork2() {
        return this.m_work2;
    }

    public void setWork2(Number number) {
        this.m_work2 = number;
    }

    public Duration getDuration() {
        return this.m_duration;
    }

    public void setDuration(Duration duration) {
        this.m_duration = duration;
    }

    public Duration getBaselineDuration() {
        return this.m_baselineDuration;
    }

    public void setBaselineDuration(Duration duration) {
        this.m_baselineDuration = duration;
    }

    public Duration getActualDuration() {
        return this.m_actualDuration;
    }

    public void setActualDuration(Duration duration) {
        this.m_actualDuration = duration;
    }

    public Number getPercentageComplete() {
        return this.m_percentageComplete;
    }

    public void setPercentageComplete(Number number) {
        this.m_percentageComplete = number;
    }

    public void setBaselineStart(Date date) {
        this.m_baselineStart = date;
    }

    public Date getBaselineStart() {
        return this.m_baselineStart;
    }

    public void setBaselineFinish(Date date) {
        this.m_baselineFinish = date;
    }

    public Date getBaselineFinish() {
        return this.m_baselineFinish;
    }

    public void setActualStart(Date date) {
        this.m_actualStart = date;
    }

    public Date getActualStart() {
        return this.m_actualStart;
    }

    public void setActualFinish(Date date) {
        this.m_actualFinish = date;
    }

    public Date getActualFinish() {
        return this.m_actualFinish;
    }

    public Duration getStartVariance() {
        return this.m_startVariance;
    }

    public void setStartVariance(Duration duration) {
        this.m_startVariance = duration;
    }

    public Duration getFinishVariance() {
        return this.m_finishVariance;
    }

    public void setFinishVariance(Duration duration) {
        this.m_finishVariance = duration;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String string) {
        this.m_subject = string;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public void setAuthor(String string) {
        this.m_author = string;
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public void setKeywords(String string) {
        this.m_keywords = string;
    }

    public void setCurrencySymbol(String string) {
        if (string == null) {
            string = "$";
        }
        this.m_currencySymbol = string;
    }

    public String getCurrencySymbol() {
        return this.m_currencySymbol;
    }

    public void setSymbolPosition(CurrencySymbolPosition currencySymbolPosition) {
        this.m_symbolPosition = currencySymbolPosition;
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return this.m_symbolPosition;
    }

    public void setCurrencyDigits(Number number) {
        this.m_currencyDigits = number;
    }

    public Number getCurrencyDigits() {
        return this.m_currencyDigits;
    }

    public void setThousandsSeparator(char c) {
        this.m_thousandsSeparator = c;
    }

    public char getThousandsSeparator() {
        return this.m_thousandsSeparator;
    }

    public void setDecimalSeparator(char c) {
        this.m_decimalSeparator = c;
    }

    public char getDecimalSeparator() {
        return this.m_decimalSeparator;
    }

    public boolean getProjectExternallyEdited() {
        return this.m_projectExternallyEdited;
    }

    public void setProjectExternallyEdited(boolean bl) {
        this.m_projectExternallyEdited = bl;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String string) {
        this.m_category = string;
    }

    public Number getDaysPerMonth() {
        return this.m_daysPerMonth;
    }

    public void setDaysPerMonth(Number number) {
        if (number != null) {
            this.m_daysPerMonth = number;
        }
    }

    public Number getMinutesPerDay() {
        return this.m_minutesPerDay;
    }

    public void setMinutesPerDay(Number number) {
        if (number != null) {
            this.m_minutesPerDay = number;
        }
    }

    public Number getMinutesPerWeek() {
        return this.m_minutesPerWeek;
    }

    public void setMinutesPerWeek(Number number) {
        if (number != null) {
            this.m_minutesPerWeek = number;
        }
    }

    public boolean getFiscalYearStart() {
        return this.m_fiscalYearStart;
    }

    public void setFiscalYearStart(boolean bl) {
        this.m_fiscalYearStart = bl;
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return this.m_defaultTaskEarnedValueMethod;
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_defaultTaskEarnedValueMethod = earnedValueMethod;
    }

    public boolean getRemoveFileProperties() {
        return this.m_removeFileProperties;
    }

    public void setRemoveFileProperties(boolean bl) {
        this.m_removeFileProperties = bl;
    }

    public boolean getMoveCompletedEndsBack() {
        return this.m_moveCompletedEndsBack;
    }

    public void setMoveCompletedEndsBack(boolean bl) {
        this.m_moveCompletedEndsBack = bl;
    }

    public boolean getNewTasksEstimated() {
        return this.m_newTasksEstimated;
    }

    public void setNewTasksEstimated(boolean bl) {
        this.m_newTasksEstimated = bl;
    }

    public boolean getSpreadActualCost() {
        return this.m_spreadActualCost;
    }

    public void setSpreadActualCost(boolean bl) {
        this.m_spreadActualCost = bl;
    }

    public boolean getMultipleCriticalPaths() {
        return this.m_multipleCriticalPaths;
    }

    public void setMultipleCriticalPaths(boolean bl) {
        this.m_multipleCriticalPaths = bl;
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return this.m_autoAddNewResourcesAndTasks;
    }

    public void setAutoAddNewResourcesAndTasks(boolean bl) {
        this.m_autoAddNewResourcesAndTasks = bl;
    }

    public Date getLastSaved() {
        return this.m_lastSaved;
    }

    public void setLastSaved(Date date) {
        this.m_lastSaved = date;
    }

    public Date getStatusDate() {
        return this.m_statusDate;
    }

    public void setStatusDate(Date date) {
        this.m_statusDate = date;
    }

    public boolean getMoveRemainingStartsBack() {
        return this.m_moveRemainingStartsBack;
    }

    public void setMoveRemainingStartsBack(boolean bl) {
        this.m_moveRemainingStartsBack = bl;
    }

    public boolean getAutolink() {
        return this.m_autolink;
    }

    public void setAutolink(boolean bl) {
        this.m_autolink = bl;
    }

    public boolean getMicrosoftProjectServerURL() {
        return this.m_microsoftProjectServerURL;
    }

    public void setMicrosoftProjectServerURL(boolean bl) {
        this.m_microsoftProjectServerURL = bl;
    }

    public boolean getHonorConstraints() {
        return this.m_honorConstraints;
    }

    public void setHonorConstraints(boolean bl) {
        this.m_honorConstraints = bl;
    }

    public boolean getAdminProject() {
        return this.m_adminProject;
    }

    public void setAdminProject(boolean bl) {
        this.m_adminProject = bl;
    }

    public boolean getInsertedProjectsLikeSummary() {
        return this.m_insertedProjectsLikeSummary;
    }

    public void setInsertedProjectsLikeSummary(boolean bl) {
        this.m_insertedProjectsLikeSummary = bl;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public boolean getSpreadPercentComplete() {
        return this.m_spreadPercentComplete;
    }

    public void setSpreadPercentComplete(boolean bl) {
        this.m_spreadPercentComplete = bl;
    }

    public boolean getMoveCompletedEndsForward() {
        return this.m_moveCompletedEndsForward;
    }

    public void setMoveCompletedEndsForward(boolean bl) {
        this.m_moveCompletedEndsForward = bl;
    }

    public boolean getEditableActualCosts() {
        return this.m_editableActualCosts;
    }

    public void setEditableActualCosts(boolean bl) {
        this.m_editableActualCosts = bl;
    }

    public String getUniqueID() {
        return this.m_uniqueID;
    }

    public void setUniqueID(String string) {
        this.m_uniqueID = string;
    }

    public Integer getRevision() {
        return this.m_revision;
    }

    public boolean getNewTasksEffortDriven() {
        return this.m_newTasksEffortDriven;
    }

    public void setNewTasksEffortDriven(boolean bl) {
        this.m_newTasksEffortDriven = bl;
    }

    public void setRevision(Integer n) {
        this.m_revision = n;
    }

    public boolean getMoveRemainingStartsForward() {
        return this.m_moveRemainingStartsForward;
    }

    public void setMoveRemainingStartsForward(boolean bl) {
        this.m_moveRemainingStartsForward = bl;
    }

    public boolean getActualsInSync() {
        return this.m_actualsInSync;
    }

    public void setActualsInSync(boolean bl) {
        this.m_actualsInSync = bl;
    }

    public TaskType getDefaultTaskType() {
        return this.m_defaultTaskType;
    }

    public void setDefaultTaskType(TaskType taskType) {
        this.m_defaultTaskType = taskType;
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setCreationDate(Date date) {
        this.m_creationDate = date;
    }

    public Date getExtendedCreationDate() {
        return this.m_extendedCreationDate;
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return this.m_defaultFixedCostAccrual;
    }

    public void setDefaultFixedCostAccrual(AccrueType accrueType) {
        this.m_defaultFixedCostAccrual = accrueType;
    }

    public void setExtendedCreationDate(Date date) {
        this.m_extendedCreationDate = date;
    }

    public Integer getCriticalSlackLimit() {
        return this.m_criticalSlackLimit;
    }

    public void setCriticalSlackLimit(Integer n) {
        this.m_criticalSlackLimit = n;
    }

    public Integer getBaselineForEarnedValue() {
        return this.m_baselineForEarnedValue;
    }

    public void setBaselineForEarnedValue(Integer n) {
        this.m_baselineForEarnedValue = n;
    }

    public Integer getFiscalYearStartMonth() {
        return this.m_fiscalYearStartMonth;
    }

    public void setFiscalYearStartMonth(Integer n) {
        this.m_fiscalYearStartMonth = n;
    }

    public boolean getNewTaskStartIsProjectStart() {
        return this.m_newTaskStartIsProjectStart;
    }

    public void setNewTaskStartIsProjectStart(boolean bl) {
        this.m_newTaskStartIsProjectStart = bl;
    }

    public Day getWeekStartDay() {
        return this.m_weekStartDay;
    }

    public void setWeekStartDay(Day day) {
        this.m_weekStartDay = day;
    }

    public void setCalculateMultipleCriticalPaths(boolean bl) {
        this.m_calculateMultipleCriticalPaths = bl;
    }

    public boolean getCalculateMultipleCriticalPaths() {
        return this.m_calculateMultipleCriticalPaths;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public void setCurrencyCode(String string) {
        this.m_currencyCode = string;
    }

    public void setDocumentSummaryInformation(Map<Integer, Object> map) {
        this.m_documentSummaryInformation = map;
    }

    public Map<Integer, Object> getDocumentSummaryInformation() {
        return this.m_documentSummaryInformation;
    }

    public void setHyperlinkBase(String string) {
        this.m_hyperlinkBase = string;
    }

    public String getHyperlinkBase() {
        return this.m_hyperlinkBase;
    }

    public boolean getShowProjectSummaryTask() {
        return this.m_showProjectSummaryTask;
    }

    public void setShowProjectSummaryTask(boolean bl) {
        this.m_showProjectSummaryTask = bl;
    }

    public Date getBaselineDate(int n) {
        return this.m_baselineDate[n];
    }

    public void setBaselineDate(int n, Date date) {
        this.m_baselineDate[n] = date;
    }
}

