/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType implements MpxjEnum
{
    STRING(1),
    DATE(2),
    CURRENCY(3),
    BOOLEAN(4),
    NUMERIC(5),
    DURATION(6),
    UNITS(7),
    PERCENTAGE(8),
    ACCRUE(9),
    CONSTRAINT(10),
    RATE(11),
    PRIORITY(12),
    RELATION_LIST(13),
    TASK_TYPE(14),
    RESOURCE_TYPE(15),
    TIME_UNITS(15),
    WORK(16),
    INTEGER(17),
    ASCII_STRING(18),
    SHORT(19),
    BINARY(20),
    DELAY(21),
    WORK_UNITS(22),
    WORKGROUP(23),
    GUID(24),
    RATE_UNITS(25);

    private static final DataType[] TYPE_VALUES;
    private int m_value;

    private DataType(int n2) {
        this.m_value = n2;
    }

    public static DataType getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = STRING.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static DataType getInstance(Number number) {
        int n = number == null ? -1 : NumberUtility.getInt(number);
        return DataType.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (DataType[])EnumUtility.createTypeArray(DataType.class, (int)1);
    }
}

