/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CodePage {
    ANSI("ANSI", "Cp1252"),
    MAC("MAC", "MacRoman"),
    LATIN("850", "Cp850"),
    US("437", "Cp437"),
    ZH("ZH", "GB2312");

    private String m_value;
    private String m_charset;
    private static final Map<String, CodePage> NAME_MAP;

    private CodePage(String string2, String string3) {
        this.m_value = string2;
        this.m_charset = string3;
    }

    public static CodePage getInstance(String string) {
        CodePage codePage = NAME_MAP.get(string);
        if (codePage == null) {
            codePage = ANSI;
        }
        return codePage;
    }

    public Charset getCharset() {
        return Charset.forName(this.m_charset);
    }

    public String toString() {
        return this.m_value;
    }

    static {
        NAME_MAP = new HashMap<String, CodePage>();
        for (CodePage codePage : EnumSet.allOf(CodePage.class)) {
            NAME_MAP.put(codePage.m_value, codePage);
        }
    }
}

