/*
 * Decompiled with CFR 0.152.
 */
package com.projity.script;

import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.transform.TransformList;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.script.FieldArrayUtil;
import com.projity.strings.Messages;

public class ConverterContext
implements Cloneable {
    public static final int ALL = 0;
    public static final int CHANGE = 1;
    public static final int SCALE = 2;
    public static final int TRANSLATE = 3;
    protected int type;
    protected String id;
    protected String name;
    protected String fieldArrayId;
    protected String hiddenFieldArrayId;
    protected String filterId;
    protected String groupFieldId;
    protected String sortFieldId;
    protected String roles;
    protected boolean distribution;
    protected int summaryLevel = -1;
    protected long s = Long.MAX_VALUE;
    protected long e = 0L;
    protected int scale = 2;
    protected int timeType;
    protected int actionType;
    protected long winS = 0L;
    protected long winE = Long.MAX_VALUE;
    protected transient SpreadSheetFieldArray fieldArray;
    protected transient boolean fieldArrayInitialized;
    protected transient SpreadSheetFieldArray hiddenFieldArray;
    protected transient boolean hiddenFieldArrayInitialized;
    protected transient NodeFilter filter;
    protected transient boolean filterInitialized;

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int n) {
        this.actionType = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        if (this.name == null) {
            this.name = Messages.getString(this.id);
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFieldArrayId() {
        return this.fieldArrayId;
    }

    public void setFieldArrayId(String string) {
        this.fieldArrayId = string;
    }

    public String getHiddenFieldArrayId() {
        return this.hiddenFieldArrayId;
    }

    public void setHiddenFieldArrayId(String string) {
        this.hiddenFieldArrayId = string;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String string) {
        this.filterId = string;
    }

    public String getGroupFieldId() {
        return this.groupFieldId;
    }

    public void setGroupFieldId(String string) {
        this.groupFieldId = string;
    }

    public String getSortFieldId() {
        return this.sortFieldId;
    }

    public void setSortFieldId(String string) {
        this.sortFieldId = string;
    }

    public int getSummaryLevel() {
        return this.summaryLevel;
    }

    public void setSummaryLevel(int n) {
        this.summaryLevel = n;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String string) {
        this.roles = string;
    }

    public long getE() {
        return this.e;
    }

    public void setE(long l) {
        this.e = l;
    }

    public long getS() {
        return this.s;
    }

    public void setS(long l) {
        this.s = l;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public long getWinE() {
        return this.winE;
    }

    public void setWinE(long l) {
        this.winE = l;
    }

    public long getWinS() {
        return this.winS;
    }

    public void setWinS(long l) {
        this.winS = l;
    }

    public SpreadSheetFieldArray retrieveFieldArray() {
        if (this.fieldArrayInitialized) {
            return this.fieldArray;
        }
        this.fieldArrayInitialized = true;
        if (this.fieldArrayId == null) {
            return null;
        }
        this.fieldArray = FieldArrayUtil.getFieldArray(this.type, this.fieldArrayId);
        return this.fieldArray;
    }

    public SpreadSheetFieldArray retrieveHiddenFieldArray() {
        if (this.hiddenFieldArrayInitialized) {
            return this.hiddenFieldArray;
        }
        this.hiddenFieldArrayInitialized = true;
        if (this.hiddenFieldArrayId == null) {
            return null;
        }
        this.hiddenFieldArray = FieldArrayUtil.getHiddenFieldArray(this.type, this.hiddenFieldArrayId);
        return this.hiddenFieldArray;
    }

    public NodeFilter retrieveFilter() {
        if (this.filterInitialized) {
            return this.filter;
        }
        this.filterInitialized = true;
        if (this.filterId == null) {
            return null;
        }
        this.filter = (NodeFilter)TransformList.getInstance("report_filters").getTransform(this.filterId);
        if (this.filter == null) {
            this.filter = (NodeFilter)TransformList.getInstance("user_filters").getTransform(this.filterId);
        }
        if (this.filter == null) {
            this.filter = (NodeFilter)TransformList.getInstance("hidden_filters").getTransform(this.filterId);
        }
        return this.filter;
    }

    public String toString() {
        return "{id=" + this.id + ", " + "type=" + this.type + ", " + "fieldArrayId=" + this.fieldArrayId + ", " + "hiddenFieldArrayId=" + this.hiddenFieldArrayId + ", " + "filterId=" + this.filterId + ", " + "}";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isDistribution() {
        return this.distribution;
    }

    public void setDistribution(boolean bl) {
        this.distribution = bl;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public void setTimeType(int n) {
        this.timeType = n;
    }
}

