/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.Duration;
import com.projity.datatype.RateFormat;
import com.projity.options.ScheduleOption;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Rate
implements Comparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1748666535067764189L;
    double value = 0.0;
    int timeUnit = ScheduleOption.getInstance().getRateEnteredIn();

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double d) {
        this.value = d;
    }

    public final int getTimeUnit() {
        return this.timeUnit;
    }

    public final void setTimeUnit(int n) {
        this.timeUnit = n;
    }

    public boolean isNonTemporal() {
        return this.timeUnit == -2;
    }

    public Rate() {
    }

    public Rate(double d) {
        this.value = d;
    }

    public Rate(double d, int n) {
        this.value = d;
        this.timeUnit = n;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Rate)) {
            throw new IllegalArgumentException();
        }
        return (int)(this.value - ((Rate)object).value);
    }

    public String toString() {
        return RateFormat.getInstance(null, false, false, true).format(this);
    }

    public void makeUnitless() {
        this.value *= Duration.timeUnitFactor(this.timeUnit);
        this.timeUnit = -2;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeDouble(this.value);
        objectOutputStream.writeInt(this.timeUnit);
    }

    public static Rate deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return new Rate(objectInputStream.readDouble(), objectInputStream.readInt());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

