/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.BitwiseNegateEvaluatingException;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.SpreadMap;
import groovy.lang.SpreadMapEvaluatingException;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.Invoker;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.IntegerCache;
import org.w3c.dom.Element;

public class InvokerHelper {
    public static final Object[] EMPTY_ARGS = new Object[0];
    private static final Object[] EMPTY_MAIN_ARGS = new Object[]{new String[0]};
    private static final Invoker singleton = new Invoker();

    public static MetaClass getMetaClass(Object object) {
        return InvokerHelper.getInstance().getMetaClass(object);
    }

    public static Invoker getInstance() {
        return singleton;
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments) {
        return InvokerHelper.getInstance().invokeMethod(object, methodName, arguments);
    }

    public static Object invokeStaticMethod(Class type, String methodName, Object arguments) {
        return InvokerHelper.getInstance().invokeStaticMethod(type, methodName, arguments);
    }

    public static Object invokeConstructorOf(Class type, Object arguments) {
        return InvokerHelper.getInstance().invokeConstructorOf(type, arguments);
    }

    public static String toString(Object arguments) {
        if (arguments instanceof Object[]) {
            return InvokerHelper.toArrayString((Object[])arguments);
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.toListString((Collection)arguments);
        }
        if (arguments instanceof Map) {
            return InvokerHelper.toMapString((Map)arguments);
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.format(arguments, true);
        }
        return InvokerHelper.format(arguments, false);
    }

    public static String inspect(Object self) {
        return InvokerHelper.format(self, true);
    }

    public static Object getAttribute(Object object, String attribute) {
        return InvokerHelper.getInstance().getAttribute(object, attribute);
    }

    public static void setAttribute(Object object, String attribute, Object newValue) {
        InvokerHelper.getInstance().setAttribute(object, attribute, newValue);
    }

    public static Object getProperty(Object object, String property) {
        return InvokerHelper.getInstance().getProperty(object, property);
    }

    public static void setProperty(Object object, String property, Object newValue) {
        InvokerHelper.getInstance().setProperty(object, property, newValue);
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        return InvokerHelper.getInstance().getMethodPointer(object, methodName);
    }

    public static Object negate(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return IntegerCache.integerValue(-number.intValue());
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return new Long(-number.longValue());
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof Double) {
            Double number = (Double)value;
            return new Double(-number.doubleValue());
        }
        if (value instanceof Float) {
            Float number = (Float)value;
            return new Float(-number.floatValue());
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.negate(it.next()));
            }
            return newlist;
        }
        throw new GroovyRuntimeException("Cannot negate type " + value.getClass().getName() + ", value " + value);
    }

    public static Matcher findRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : InvokerHelper.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = InvokerHelper.toString(right);
        }
        Matcher matcher = Pattern.compile(regexToCompareTo).matcher(stringToCompare);
        return matcher;
    }

    public static boolean matchRegex(Object left, Object right) {
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(InvokerHelper.toString(right));
        String stringToCompare = InvokerHelper.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public static SpreadMap spreadMap(Object value) {
        if (value instanceof Map) {
            Object[] values = new Object[((Map)value).keySet().size() * 2];
            int index = 0;
            Iterator it = ((Map)value).keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                values[index++] = key;
                values[index++] = ((Map)value).get(key);
            }
            return new SpreadMap(values);
        }
        throw new SpreadMapEvaluatingException("Cannot spread the map " + value.getClass().getName() + ", value " + value);
    }

    public static List createList(Object[] values) {
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            answer.add(values[i]);
        }
        return answer;
    }

    public static Map createMap(Object[] values) {
        HashMap<Object, Object> answer = new HashMap<Object, Object>(values.length / 2);
        int i = 0;
        while (i < values.length - 1) {
            if (values[i] instanceof SpreadMap && values[i + 1] instanceof Map) {
                Map smap = (Map)values[i + 1];
                Iterator iter = smap.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    answer.put(key, smap.get(key));
                }
                i += 2;
                continue;
            }
            answer.put(values[i++], values[i++]);
        }
        return answer;
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new AssertionError((Object)("Expression: " + expression));
        }
        throw new AssertionError((Object)("" + message + ". Expression: " + expression));
    }

    public static void write(Writer out, Object object) throws IOException {
        if (object instanceof String) {
            out.write((String)object);
        } else if (object instanceof Object[]) {
            out.write(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.write(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.write(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            writable.writeTo(out);
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                out.write(chars, 0, i);
            }
            reader.close();
        } else {
            out.write(InvokerHelper.toString(object));
        }
    }

    protected static String format(Object arguments, boolean verbose) {
        if (arguments == null) {
            return "null";
        }
        if (arguments.getClass().isArray()) {
            return InvokerHelper.format(DefaultTypeTransformation.asCollection(arguments), verbose);
        }
        if (arguments instanceof Range) {
            Range range = (Range)arguments;
            if (verbose) {
                return range.inspect();
            }
            return range.toString();
        }
        if (arguments instanceof List) {
            List list = (List)arguments;
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(InvokerHelper.format(iter.next(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Map) {
            Map map = (Map)arguments;
            if (map.isEmpty()) {
                return "[:]";
            }
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                Map.Entry entry = iter.next();
                buffer.append(InvokerHelper.format(entry.getKey(), verbose));
                buffer.append(":");
                if (entry.getValue() == map) {
                    buffer.append("this Map_");
                    continue;
                }
                buffer.append(InvokerHelper.format(entry.getValue(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Element) {
            Element node = (Element)arguments;
            OutputFormat format = new OutputFormat(node.getOwnerDocument());
            format.setOmitXMLDeclaration(true);
            format.setIndenting(true);
            format.setLineWidth(0);
            format.setPreserveSpace(true);
            StringWriter sw = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
            try {
                serializer.asDOMSerializer();
                serializer.serialize(node);
            }
            catch (IOException e) {
                // empty catch block
            }
            return sw.toString();
        }
        if (arguments instanceof String) {
            if (verbose) {
                String arg = ((String)arguments).replaceAll("\\n", "\\\\n");
                arg = arg.replaceAll("\\r", "\\\\r");
                arg = arg.replaceAll("\\t", "\\\\t");
                arg = arg.replaceAll("\\f", "\\\\f");
                arg = arg.replaceAll("\\\"", "\\\\\"");
                arg = arg.replaceAll("\\\\", "\\\\");
                return "\"" + arg + "\"";
            }
            return (String)arguments;
        }
        return arguments.toString();
    }

    public static String toTypeString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuffer argBuf = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments[i] != null ? arguments[i].getClass().getName() : "null");
        }
        return argBuf.toString();
    }

    public static String toMapString(Map arg) {
        return InvokerHelper.format(arg, true);
    }

    public static String toListString(Collection arg) {
        if (arg == null) {
            return "null";
        }
        if (arg.isEmpty()) {
            return "[]";
        }
        String sbdry = "[";
        String ebdry = "]";
        StringBuffer buffer = new StringBuffer(sbdry);
        boolean first = true;
        Iterator iter = arg.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            Object elem = iter.next();
            buffer.append(InvokerHelper.format(elem, true));
        }
        buffer.append(ebdry);
        return buffer.toString();
    }

    public static String toArrayString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        String sbdry = "{";
        String ebdry = "}";
        StringBuffer argBuf = new StringBuffer(sbdry);
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(InvokerHelper.format(arguments[i], true));
        }
        argBuf.append(ebdry);
        return argBuf.toString();
    }

    public static Object bitNegate(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return new Integer(~number.intValue());
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return new Long((long)(number ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).not();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.negate(value.toString());
        }
        if (value instanceof GString) {
            return DefaultGroovyMethods.negate(value.toString());
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.bitNegate(it.next()));
            }
            return newlist;
        }
        throw new BitwiseNegateEvaluatingException("Cannot bitwise negate type " + value.getClass().getName() + ", value " + value);
    }
}

