<?php
/* vim: set expandtab sw=4 ts=4 sts=4: */
/**
 * <code>
 * N   N  OOO  !!   DDDD   OOO    N   N  OOO  TTTTT   EEEE DDDD  I TTTTT !!
 * NN  N O   O !!   D   D O   O   NN  N O   O   T     E    D   D I   T   !!
 * N N N O   O !!   D   D O   O   N N N O   O   T     EEEE D   D I   T   !!
 * N  NN O   O      D   D O   O   N  NN O   O   T     E    D   D I   T
 * N   N  OOO  !!   DDDD   OOO    N   N  OOO    T     EEEE DDDD  I   T   !!
 * </code>
 *
 * DO NOT EDIT THIS FILE, EDIT config.inc.php INSTEAD !!!
 *
 * phpMyAdmin default configuration, you can copy values from here to your
 * config.inc.php
 *
 * All directives are explained in the documentation
 *
 * @package PhpMyAdmin
 */

/**
 * Your phpMyAdmin URL.
 *
 * Complete the variable below with the full URL ie
 *    http://www.your_web.net/path_to_your_phpMyAdmin_directory/
 *
 * It must contain characters that are valid for a URL, and the path is
 * case sensitive on some Web servers, for example Unix-based servers.
 *
 * In most cases you can leave this variable empty, as the correct value
 * will be detected automatically. However, we recommend that you do
 * test to see that the auto-detection code works in your system. A good
 * test is to browse a table, then edit a row and save it.  There will be
 * an error message if phpMyAdmin cannot auto-detect the correct value.
 *
 * @global string $cfg['PmaAbsoluteUri']
 */
$cfg['PmaAbsoluteUri'] = '';

/**
 * Disable the default warning that is displayed on the DB Details Structure page if
 * any of the required Tables for the configuration storage could not be found
 *
 * @global boolean $cfg['PmaNoRelation_DisableWarning']
 */
$cfg['PmaNoRelation_DisableWarning'] = false;

/**
 * Disable the default warning that is displayed if Suhosin is detected
 *
 * @global boolean $cfg['SuhosinDisableWarning']
 */
$cfg['SuhosinDisableWarning'] = false;

/**
 * Disable the default warning that is displayed if mcrypt is missing for
 * cookie authentication.
 *
 * @global boolean $cfg['McryptDisableWarning']
 */
$cfg['McryptDisableWarning'] = false;

/**
 * Disable the default warning that is displayed if a diffrence between
 * the MySQL library and server is detected.
 *
 * @global boolean $cfg['['ServerLibraryDifference_DisableWarning']']
 */
$cfg['ServerLibraryDifference_DisableWarning'] = false;

/**
 * Disable the default warning about MySQL reserved words in column names
 *
 * @global boolean $cfg['ReservedWordDisableWarning']
 */
$cfg['ReservedWordDisableWarning'] = false;

/**
 * Show warning about incomplete translations on certain threshold.
 *
 * @global boolean $cfg['TranslationWarningThreshold']
 */
$cfg['TranslationWarningThreshold'] = 80;

/**
 * The 'cookie' auth_type uses blowfish algorithm to encrypt the password. If
 * at least one server configuration uses 'cookie' auth_type, enter here a
 * pass phrase that will be used by blowfish. The maximum length seems to be 46
 * characters.
 *
 * @global string $cfg['blowfish_secret']
 */
$cfg['blowfish_secret'] = '';


/*******************************************************************************
 * Server(s) configuration
 *
 * The $cfg['Servers'] array starts with $cfg['Servers'][1].  Do not use
 * $cfg['Servers'][0]. You can disable a server configuration entry by setting host
 * to ''. If you want more than one server, just copy following section
 * (including $i incrementation) several times. There is no need to define
 * full server array, just define values you need to change.
 *
 * @global array $cfg['Servers']
 */
$cfg['Servers'] = array();

$i = 1;

/**
 * MySQL hostname or IP address
 *
 * @global string $cfg['Servers'][$i]['host']
 */
$cfg['Servers'][$i]['host'] = 'localhost';

/**
 * MySQL port - leave blank for default port
 *
 * @global string $cfg['Servers'][$i]['port']
 */
$cfg['Servers'][$i]['port'] = '';

/**
 * Path to the socket - leave blank for default socket
 *
 * @global string $cfg['Servers'][$i]['socket']
 */
$cfg['Servers'][$i]['socket'] = '';

/**
 * Use SSL for connecting to MySQL server?
 *
 * @global boolean $cfg['Servers'][$i]['ssl']
 */
$cfg['Servers'][$i]['ssl'] = false;

/**
 * How to connect to MySQL server ('tcp' or 'socket')
 *
 * @global string $cfg['Servers'][$i]['connect_type']
 */
$cfg['Servers'][$i]['connect_type'] = 'tcp';

/**
 * The PHP MySQL extension to use ('mysql' or 'mysqli')
 *
 * @global string $cfg['Servers'][$i]['extension']
 */
$cfg['Servers'][$i]['extension'] = 'mysqli';

/**
 * Use compressed protocol for the MySQL connection
 *
 * @global boolean $cfg['Servers'][$i]['compress']
 */
$cfg['Servers'][$i]['compress'] = false;

/**
 * MySQL control host. This permits to use a host different than the
 * main host, for the phpMyAdmin configuration storage. If left empty,
 * $cfg['Servers'][$i]['host'] is used instead.
 *
 * @global string $cfg['Servers'][$i]['controlhost']
 */
$cfg['Servers'][$i]['controlhost'] = '';

/**
 * MySQL control user settings (this user must have read-only
 * access to the "mysql/user" and "mysql/db" tables). The controluser is also
 * used for all relational features (pmadb)
 *
 * @global string $cfg['Servers'][$i]['controluser']
 */
$cfg['Servers'][$i]['controluser'] = '';

/**
 * MySQL control user settings (this user must have read-only
 * access to the "mysql/user" and "mysql/db" tables). The controluser is also
 * used for all relational features (pmadb)
 *
 * @global string $cfg['Servers'][$i]['controlpass']
 */
$cfg['Servers'][$i]['controlpass'] = '';

/**
 * Authentication method (valid choices: config, http, signon or cookie)
 *
 * @global string $cfg['Servers'][$i]['auth_type']
 */
$cfg['Servers'][$i]['auth_type'] = 'cookie';

/**
 * HTTP Basic Auth Realm name to display (only used with 'HTTP' auth_type)
 *
 * @global string $cfg['Servers'][$i]['auth_http_realm']
 */
$cfg['Servers'][$i]['auth_http_realm'] = '';

/**
 * File containing Swekey ids and login names (see /contrib);
 * leave empty to deactivate Swekey hardware authentication
 *
 * @global string $cfg['Servers'][$i]['auth_swekey_config']
 */
$cfg['Servers'][$i]['auth_swekey_config'] = '';

/**
 * MySQL user
 *
 * @global string $cfg['Servers'][$i]['user']
 */
$cfg['Servers'][$i]['user'] = 'root';

/**
 * MySQL password (only needed with 'config' auth_type)
 *
 * @global string $cfg['Servers'][$i]['password']
 */
$cfg['Servers'][$i]['password'] = '';

/**
 * Session to use for 'signon' authentication method
 *
 * @global string $cfg['Servers'][$i]['SignonSession']
 */
$cfg['Servers'][$i]['SignonSession'] = '';

/**
 * PHP script to use for 'signon' authentication method
 *
 * @global string $cfg['Servers'][$i]['SignonScript']
 */
$cfg['Servers'][$i]['SignonScript'] = '';

/**
 * URL where to redirect user to login for 'signon' authentication method
 *
 * @global string $cfg['Servers'][$i]['SignonURL']
 */
$cfg['Servers'][$i]['SignonURL'] = '';

/**
 * URL where to redirect user after logout
 *
 * @global string $cfg['Servers'][$i]['LogoutURL']
 */
$cfg['Servers'][$i]['LogoutURL'] = '';

/**
 * Whether to try to connect without password
 *
 * @global boolean $cfg['Servers'][$i]['nopassword']
 */
$cfg['Servers'][$i]['nopassword'] = false;

/**
 * If set to a db-name, only this db is displayed in navigation panel
 * It may also be an array of db-names
 *
 * @global string $cfg['Servers'][$i]['only_db']
 */
$cfg['Servers'][$i]['only_db'] = '';

/**
 * Database name to be hidden from listings
 *
 * @global string $cfg['Servers'][$i]['hide_db']
 */
$cfg['Servers'][$i]['hide_db'] = '';

/**
 * Verbose name for this host - leave blank to show the hostname
 * (for HTTP authentication, all non-US-ASCII characters will be stripped)
 *
 * @global string $cfg['Servers'][$i]['verbose']
 */
$cfg['Servers'][$i]['verbose'] = '';

/**
 * Database used for Relation, Bookmark and PDF Features
 * (see examples/create_tables.sql)
 *   - leave blank for no support
 *     SUGGESTED: 'phpmyadmin'
 *
 * @global string $cfg['Servers'][$i]['pmadb']
 */
$cfg['Servers'][$i]['pmadb'] = '';

/**
 * Bookmark table
 *   - leave blank for no bookmark support
 *     SUGGESTED: 'pma__bookmark'
 *
 * @global string $cfg['Servers'][$i]['bookmarktable']
 */
$cfg['Servers'][$i]['bookmarktable'] = '';

/**
 * table to describe the relation between links (see doc)
 *   - leave blank for no relation-links support
 *     SUGGESTED: 'pma__relation'
 *
 * @global string $cfg['Servers'][$i]['relation']
 */
$cfg['Servers'][$i]['relation'] = '';

/**
 * table to describe the display fields
 *   - leave blank for no display fields support
 *     SUGGESTED: 'pma__table_info'
 *
 * @global string $cfg['Servers'][$i]['table_info']
 */
$cfg['Servers'][$i]['table_info'] = '';

/**
 * table to describe the tables position for the PDF schema
 *   - leave blank for no PDF schema support
 *     SUGGESTED: 'pma__table_coords'
 *
 * @global string $cfg['Servers'][$i]['table_coords']
 */
$cfg['Servers'][$i]['table_coords'] = '';

/**
 * table to describe pages of relationpdf
 *   - leave blank if you don't want to use this
 *     SUGGESTED: 'pma__pdf_pages'
 *
 * @global string $cfg['Servers'][$i]['pdf_pages']
 */
$cfg['Servers'][$i]['pdf_pages'] = '';

/**
 * table to store column information
 *   - leave blank for no column comments/mime types
 *     SUGGESTED: 'pma__column_info'
 *
 * @global string $cfg['Servers'][$i]['column_info']
 */
$cfg['Servers'][$i]['column_info'] = '';

/**
 * table to store SQL history
 *   - leave blank for no SQL query history
 *     SUGGESTED: 'pma__history'
 *
 * @global string $cfg['Servers'][$i]['history']
 */
$cfg['Servers'][$i]['history'] = '';

/**
 * table to store the coordinates for Designer
 *   - leave blank for no Designer feature
 *     SUGGESTED: 'pma__designer_coords'
 *
 * @global string $cfg['Servers'][$i]['designer_coords']
 */
$cfg['Servers'][$i]['designer_coords'] = '';

/**
 * table to store recently used tables
 *   - leave blank for no "persistent" recently used tables
 *     SUGGESTED: 'pma__recent'
 */
$cfg['Servers'][$i]['recent'] = '';

/**
 * table to store UI preferences for tables
 *   - leave blank for no "persistent" UI preferences
 *     SUGGESTED: 'pma__table_uiprefs'
 */
$cfg['Servers'][$i]['table_uiprefs'] = '';

/**
 * table to store SQL tracking
 *   - leave blank for no SQL tracking
 *     SUGGESTED: 'pma__tracking'
 *
 * @global string $cfg['Servers'][$i]['tracking']
 */
$cfg['Servers'][$i]['tracking'] = '';

/**
 * table to store user preferences
 *   - leave blank to disable server storage
 *     SUGGESTED: 'pma__userconfig'
 *
 * @global string $cfg['Servers'][$i]['userconfig']
 */
$cfg['Servers'][$i]['userconfig'] = '';

/**
 * Maximum number of records saved in $cfg['Servers'][$i]['table_uiprefs'] table.
 *
 * In case where tables in databases is modified (e.g. dropped or renamed),
 * table_uiprefs may contains invalid data (referring to tables which are not
 * exist anymore).
 * This configuration make sure that we only keep N (N = MaxTableUiprefs)
 * newest record in table_uiprefs and automatically delete older records.
 *
 * @global integer $cfg['Servers'][$i]['userconfig'] = '';
 */
$cfg['Servers'][$i]['MaxTableUiprefs'] = 100;

/**
 * whether to allow root login
 *
 * @global boolean $cfg['Servers'][$i]['AllowRoot']
 */
$cfg['Servers'][$i]['AllowRoot'] = true;

/**
 * whether to allow login of any user without a password
 *
 * @global boolean $cfg['Servers'][$i]['AllowNoPassword']
 */
$cfg['Servers'][$i]['AllowNoPassword'] = false;

/**
 * Host authentication order, leave blank to not use
 *
 * @global string $cfg['Servers'][$i]['AllowDeny']['order']
 */
$cfg['Servers'][$i]['AllowDeny']['order'] = '';

/**
 * Host authentication rules, leave blank for defaults
 *
 * @global array $cfg['Servers'][$i]['AllowDeny']['rules']
 */
$cfg['Servers'][$i]['AllowDeny']['rules'] = array();

/**
 * Disable use of INFORMATION_SCHEMA. Is always 'false' for Drizzle.
 *
 * @see https://sourceforge.net/p/phpmyadmin/bugs/2606/
 * @see http://bugs.mysql.com/19588
 * @global boolean $cfg['Servers'][$i]['DisableIS']
 */
$cfg['Servers'][$i]['DisableIS'] = true;

/**
 * SQL command to fetch available databases
 *
 * by default most user will be fine with SHOW DATABASES,
 * for servers with a huge amount of databases it is possible to
 * define a command which executes faster but with less information
 *
 * especially when accessing database servers from ISPs changing this command
 * can result in a great speed improvement
 *
 * false will disable fetching databases from the server, only databases in
 * $cfg['Servers'][$i]['only_db'] will be displayed
 *
 * #user# will be replaced by current user
 *
 * examples:
 * 'SHOW DATABASES'
 * "SHOW DATABASES LIKE '#user#\_%'"
 * 'SELECT DISTINCT TABLE_SCHEMA FROM information_schema.SCHEMA_PRIVILEGES'
 * 'SELECT SCHEMA_NAME FROM information_schema.SCHEMATA'
 * false
 *
 * @global array $cfg['Servers'][$i]['ShowDatabasesCommand']
 */
$cfg['Servers'][$i]['ShowDatabasesCommand'] = 'SHOW DATABASES';

/**
 * Whether the tracking mechanism creates
 * versions for tables and views automatically.
 *
 * @global bool $cfg['Servers'][$i]['tracking_version_auto_create']
 */

$cfg['Servers'][$i]['tracking_version_auto_create'] = false;

/**
 * Defines the list of statements
 * the auto-creation uses for new versions.
 *
 * @global string $cfg['Servers'][$i]['tracking_default_statements']
 */

$cfg['Servers'][$i]['tracking_default_statements']
    = 'CREATE TABLE,ALTER TABLE,DROP TABLE,RENAME TABLE,CREATE INDEX,' .
      'DROP INDEX,INSERT,UPDATE,DELETE,TRUNCATE,REPLACE,CREATE VIEW,' .
      'ALTER VIEW,DROP VIEW,CREATE DATABASE,ALTER DATABASE,DROP DATABASE';

/**
 * Whether a DROP VIEW IF EXISTS statement will be added
 * as first line to the log when creating a view.
 *
 * @global bool $cfg['Servers'][$i]['tracking_add_drop_view']
 */

$cfg['Servers'][$i]['tracking_add_drop_view'] = true;

/**
 * Whether a DROP TABLE IF EXISTS statement will be added
 * as first line to the log when creating a table.
 *
 * @global bool $cfg['Servers'][$i]['tracking_add_drop_table']
 */

$cfg['Servers'][$i]['tracking_add_drop_table'] = true;

/**
 * Whether a DROP DATABASE IF EXISTS statement will be added
 * as first line to the log when creating a database.
 *
 * @global bool $cfg['Servers'][$i]['tracking_add_drop_database']
 */

$cfg['Servers'][$i]['tracking_add_drop_database'] = true;

/**
 * Enables caching of TABLE STATUS outputs for specific databases on this server
 * (in some cases TABLE STATUS can be very slow, so you may want to cache it).
 * APC is used (if the PHP extension is available, if not, this setting is ignored
 * silently). You have to provide StatusCacheLifetime.
 * Takes effect only if DisableIS is true.
 *
 * @global array $cfg['Servers'][$i]['StatusCacheDatabases']
 */
$cfg['Servers'][$i]['StatusCacheDatabases'] = array();

/**
 * Lifetime in seconds of the TABLE STATUS cache if StatusCacheDatabases is used
 *
 * @global integer $cfg['Servers'][$i]['StatusCacheLifetime']
 */
$cfg['Servers'][$i]['StatusCacheLifetime'] = 0;

/**
 * Default server (0 = no default server)
 *
 * If you have more than one server configured, you can set $cfg['ServerDefault']
 * to any one of them to auto-connect to that server when phpMyAdmin is started,
 * or set it to 0 to be given a list of servers without logging in
 * If you have only one server configured, $cfg['ServerDefault'] *MUST* be
 * set to that server.
 *
 * @global integer $cfg['ServerDefault']
 */
$cfg['ServerDefault'] = 1;

/*
 * Other core phpMyAdmin settings
 */

/**
 * whether version check is active
 *
 * @global boolean $cfg['VersionCheck']
 */
$cfg['VersionCheck'] = VERSION_CHECK_DEFAULT;

/**
 * maximum number of db's displayed in database list
 *
 * @global integer $cfg['MaxDbList']
 */
$cfg['MaxDbList'] = 100;

/**
 * maximum number of items displayed in navigation panel
 *
 * @global integer $cfg['MaxDbList']
 */
$cfg['MaxNavigationItems'] = 25;

/**
 * maximum number of tables displayed in table list
 *
 * @global integer $cfg['MaxTableList']
 */
$cfg['MaxTableList'] = 250;

/**
 * whether to show hint or not
 *
 * @global boolean $cfg['ShowHint']
 */
$cfg['ShowHint'] = true;

/**
 * maximum number of characters when a SQL query is displayed
 *
 * @global integer $cfg['MaxCharactersInDisplayedSQL']
 */
$cfg['MaxCharactersInDisplayedSQL'] = 1000;

/**
 * use GZIP output buffering if possible (true|false|'auto')
 *
 * @global string $cfg['OBGzip']
 */
$cfg['OBGzip'] = 'auto';

/**
 * use persistent connections to MySQL database
 *
 * @global boolean $cfg['PersistentConnections']
 */
$cfg['PersistentConnections'] = false;

/**
 * whether to force using HTTPS
 *
 * @global boolean $cfg['ForceSSL']
 */
$cfg['ForceSSL'] = false;

/**
 * maximum execution time in seconds (0 for no limit)
 *
 * @global integer $cfg['ExecTimeLimit']
 */
$cfg['ExecTimeLimit'] = 300;

/**
 * Path for storing session data (session_save_path PHP parameter).
 *
 * @global integer $cfg['SessionSavePath']
 */
$cfg['SessionSavePath'] = '';

/**
 * maximum allocated bytes ('0' for no limit)
 * this is a string because '16M' is a valid value; we must put here
 * a string as the default value so that /setup accepts strings
 *
 * @global string $cfg['MemoryLimit']
 */
$cfg['MemoryLimit'] = '0';

/**
 * mark used tables, make possible to show locked tables (since MySQL 3.23.30)
 * Is ignored for Drizzle.
 *
 * @global boolean $cfg['SkipLockedTables']
 */
$cfg['SkipLockedTables'] = false;

/**
 * show SQL queries as run
 *
 * @global boolean $cfg['ShowSQL']
 */
$cfg['ShowSQL'] = true;

/**
 * retain SQL input on Ajax execute
 *
 * @global boolean $cfg['RetainQueryEditor']
 */
$cfg['RetainQueryBox'] = false;

/**
 * use CodeMirror syntax highlighting for editing SQL
 *
 * @global boolean $cfg['CodemirrorEnable']
 */
$cfg['CodemirrorEnable'] = true;

/**
 * show a 'Drop database' link to normal users
 *
 * @global boolean $cfg['AllowUserDropDatabase']
 */
$cfg['AllowUserDropDatabase'] = false;

/**
 * confirm some commands that can result in loss of data
 * (see "need_confirm" in the parser)
 *
 * @global boolean $cfg['Confirm']
 */
$cfg['Confirm'] = true;

/**
 * recall previous login in cookie authentication mode or not
 *
 * @global boolean $cfg['LoginCookieRecall']
 */
$cfg['LoginCookieRecall'] = true;

/**
 * validity of cookie login (in seconds; 1440 matches php.ini's
 * session.gc_maxlifetime)
 *
 * @global integer $cfg['LoginCookieValidity']
 */
$cfg['LoginCookieValidity'] = 1440;

/**
 * how long login cookie should be stored (in seconds)
 *
 * @global integer $cfg['LoginCookieStore']
 */
$cfg['LoginCookieStore'] = 0;

/**
 * whether to delete all login cookies on logout
 *
 * @global boolean $cfg['LoginCookieDeleteAll']
 */
$cfg['LoginCookieDeleteAll'] = true;

/**
 * whether to enable the "database search" feature or not
 *
 * @global boolean $cfg['UseDbSearch']
 */
$cfg['UseDbSearch'] = true;

/**
 * if set to true, PMA continues computing multiple-statement queries
 * even if one of the queries failed
 *
 * @global boolean $cfg['IgnoreMultiSubmitErrors']
 */
$cfg['IgnoreMultiSubmitErrors'] = false;

/**
 * allow login to any user entered server in cookie based authentication
 *
 * @global boolean $cfg['AllowArbitraryServer']
 */
$cfg['AllowArbitraryServer'] = false;


/*******************************************************************************
 * Error handler configuration
 *
 * this configures phpMyAdmin's own error handler, it is used to avoid information
 * disclosure, gather errors for logging, reporting and displaying
 *
 * @global array $cfg['Error_Handler']
 */
$cfg['Error_Handler'] = array();

/**
 * whether to display errors or not
 *
 * this does not affect errors of type  E_USER_*
 *
 * @global boolean $cfg['Error_Handler']['display']
 */
$cfg['Error_Handler']['display'] = false;

/**
 * (NOT IMPLEMENTED YET)
 * where to log errors, false or empty to disable
 *
 * <code>
 * // EXAMPLE log to std PHP error log
 * $cfg['Error_Handler']['log'] = array(0);
 * // EXAMPLE mail errors
 * $cfg['Error_Handler']['log'] = array(1, 'admin@example.org');
 * // EXAMPLE append to specific file
 * $cfg['Error_Handler']['log'] = array(3, '/var/log/phpmyadmin_error.log');
 * </code>
 *
 * @see     http://php.net/error_log
 * @global  string $cfg['Error_Handler']['log']
 */
//$cfg['Error_Handler']['log'] = false;

/**
 * gather all errors in session to be displayed on a error reporting page
 * for viewing and/or sending to phpMyAdmin developer team
 *
 * @global boolean $cfg['Error_Handler']['gather']
 */
$cfg['Error_Handler']['gather'] = false;


/*******************************************************************************
 * Navigation panel setup
 */

/**
 * turn the select-based light menu into a tree
 *
 * @global boolean $cfg['NavigationTreeEnableGrouping']
 */
$cfg['NavigationTreeEnableGrouping'] = true;

/**
 * the separator to sub-tree the select-based light menu tree
 *
 * @global string $cfg['NavigationTreeDbSeparator']
 */
$cfg['NavigationTreeDbSeparator'] = '_';

/**
 * Which string will be used to generate table prefixes
 * to split/nest tables into multiple categories
 *
 * @global string $cfg['NavigationTreeTableSeparator']
 */
$cfg['NavigationTreeTableSeparator'] = '__';

/**
 * How many sublevels should be displayed when splitting up tables
 * by the above Separator
 *
 * @global integer $cfg['NavigationTreeTableLevel']
 */
$cfg['NavigationTreeTableLevel'] = 1;

/**
 * display table comment as tooltip in navigation panel
 *
 * @global boolean $cfg['ShowTooltip']
 */
$cfg['ShowTooltip'] = true;

/**
 * display logo at top of navigation panel
 *
 * @global boolean $cfg['NavigationDisplayLogo']
 */
$cfg['NavigationDisplayLogo'] = true;

/**
 * where should logo link point to (can also contain an external URL)
 *
 * @global string $cfg['NavigationLogoLink']
 */
$cfg['NavigationLogoLink'] = 'index.php';

/**
 * whether to open the linked page in the main window ('main') or
 * in a new window ('new')
 *
 * @global string $cfg['NavigationLogoLinkWindow']
 */
$cfg['NavigationLogoLinkWindow'] = 'main';

/**
 * number of recently used tables displayed in the navigation panel
 *
 * @global integer $cfg['NumRecentTables']
 */
$cfg['NumRecentTables'] = 10;

/**
 * display a JavaScript table filter in the navigation panel
 * when more then x tables are present
 *
 * @global boolean $cfg['NavigationTreeDisplayItemFilterMinimum']
 */
$cfg['NavigationTreeDisplayItemFilterMinimum'] = 30;

/**
 * display server choice at top of navigation panel
 *
 * @global boolean $cfg['NavigationDisplayServers']
 */
$cfg['NavigationDisplayServers'] = true;

/**
 * server choice as links
 *
 * @global boolean $cfg['DisplayServersList']
 */
$cfg['DisplayServersList'] = false;

/**
 * display a JavaScript database filter in the navigation panel
 * when more then x databases are present
 *
 * @global boolean $cfg['NavigationTreeDisplayDbFilterMinimum']
 */
$cfg['NavigationTreeDisplayDbFilterMinimum'] = 30;

/**
 * target of the navigation panel quick access icon
 *
 * Possible values:
 * 'tbl_structure.php' = fields list
 * 'tbl_sql.php' = SQL form
 * 'tbl_select.php' = search page
 * 'tbl_change.php' = insert row page
 * 'sql.php' = browse page
 *
 * @global string $cfg['NavigationTreeDefaultTabTable']
 */
$cfg['NavigationTreeDefaultTabTable'] = 'tbl_structure.php';


/*******************************************************************************
 * In the main panel, at startup...
 */

/**
 * allow to display statistics and space usage in the pages about database
 * details and table properties
 *
 * @global boolean $cfg['ShowStats']
 */
$cfg['ShowStats'] = true;

/**
 * show PHP info link
 *
 * @global boolean $cfg['ShowPhpInfo']
 */
$cfg['ShowPhpInfo'] = false;

/**
 * show MySQL server and web server information
 *
 * @global boolean $cfg['ShowServerInfo']
 */
$cfg['ShowServerInfo'] = true;

/**
 * show change password link
 *
 * @global boolean $cfg['ShowChgPassword']
 */
$cfg['ShowChgPassword'] = true;

/**
 * show create database form
 *
 * @global boolean $cfg['ShowCreateDb']
 */
$cfg['ShowCreateDb'] = true;


/*******************************************************************************
 * Database structure
 */

/**
 * show creation timestamp column in database structure (true|false)?
 *
 * @global boolean $cfg['ShowDbStructureCreation']
 */
$cfg['ShowDbStructureCreation'] = false;

/**
 * show last update timestamp column in database structure (true|false)?
 *
 * @global boolean $cfg['ShowDbStructureLastUpdate']
 */
$cfg['ShowDbStructureLastUpdate'] = false;

/**
 * show last check timestamp column in database structure (true|false)?
 *
 * @global boolean $cfg['ShowDbStructureLastCheck']
 */
$cfg['ShowDbStructureLastCheck'] = false;

/**
 * allow hide action columns to drop down menu in database structure (true|false)?
 *
 * @global boolean $cfg['HideStructureActions']
 */
$cfg['HideStructureActions'] = true;


/*******************************************************************************
 * In browse mode...
 */

/**
 * Use icons instead of text for the navigation bar buttons
 * and on right panel top menu (server db table) (true|false|'both')
 *
 * @global string $cfg['NavigationBarIconic']
 */
$cfg['NavigationBarIconic'] = true;

/**
 * Defines whether a user should be displayed a "show all (records)"
 * button in browse mode or not.
 *
 * @global boolean $cfg['ShowAll']
 */
$cfg['ShowAll'] = false;

/**
 * Number of rows displayed when browsing a result set. If the result
 * set contains more rows, "Previous" and "Next".
 *
 * @global integer $cfg['MaxRows']
 */
$cfg['MaxRows'] = 30;

/**
 * default for 'ORDER BY' clause (valid values are 'ASC', 'DESC' or 'SMART' -ie
 * descending order for fields of type TIME, DATE, DATETIME & TIMESTAMP,
 * ascending order else-)
 *
 * @global string $cfg['Order']
 */
$cfg['Order'] = 'SMART';

/**
 * default for 'Show binary contents as HEX'
 *
 * @global string $cfg['DisplayBinaryAsHex']
 */
$cfg['DisplayBinaryAsHex'] = true;

/**
 * grid editing: save edited cell(s) in browse-mode at once
 *
 * @global boolean $cfg['SaveCellsAtOnce']
 */

$cfg['SaveCellsAtOnce'] = false;

/**
 * grid editing: which action triggers it, or completely disable the feature
 *
 * Possible values:
 * 'click'
 * 'double-click'
 * 'disabled'
 *
 * @global string $cfg['GridEditing']
 */
$cfg['GridEditing'] ='double-click';


/*******************************************************************************
 * In edit mode...
 */

/**
 * disallow editing of binary fields
 * valid values are:
 *   false    allow editing
 *   'blob'   allow editing except for BLOB fields
 *   'noblob' disallow editing except for BLOB fields
 *   'all'    disallow editing
 *
 * @global string $cfg['ProtectBinary']
 */
$cfg['ProtectBinary'] = 'blob';

/**
 * Display the function fields in edit/insert mode
 *
 * @global boolean $cfg['ShowFunctionFields']
 */
$cfg['ShowFunctionFields'] = true;

/**
 * Display the type fields in edit/insert mode
 *
 * @global boolean $cfg['ShowFieldTypesInDataEditView']
 */
$cfg['ShowFieldTypesInDataEditView'] = true;

/**
 * Which editor should be used for CHAR/VARCHAR fields:
 *  input - allows limiting of input length
 *  textarea - allows newlines in fields
 *
 * @global string $cfg['CharEditing']
 */
$cfg['CharEditing'] = 'input';

/**
 * The minimum size for character input fields
 *
 * @global integer $cfg['MinSizeForInputField']
 */
$cfg['MinSizeForInputField'] = 4;

/**
 * The maximum size for character input fields
 *
 * @global integer $cfg['MinSizeForInputField']
 */
$cfg['MaxSizeForInputField'] = 60;

/**
 * How many rows can be inserted at one time
 *
 * @global integer $cfg['InsertRows']
 */
$cfg['InsertRows'] = 2;

/**
 * Sort order for items in a foreign-key drop-down list.
 * 'content' is the referenced data, 'id' is the key value.
 *
 * @global array $cfg['ForeignKeyDropdownOrder']
 */
$cfg['ForeignKeyDropdownOrder'] = array('content-id', 'id-content');

/**
 * A drop-down list will be used if fewer items are present
 *
 * @global integer $cfg['ForeignKeyMaxLimit']
 */
$cfg['ForeignKeyMaxLimit'] = 100;


/*******************************************************************************
 * For the export features...
 */

/**
 * Allow for the use of zip compression (requires zip support to be enabled)
 *
 * @global boolean $cfg['ZipDump']
 */
$cfg['ZipDump'] = true;

/**
 * Allow for the use of gzip compression (requires zlib)
 *
 * @global boolean $cfg['GZipDump']
 */
$cfg['GZipDump'] = true;

/**
 * Allow for the use of bzip2 compression (requires bz2 extension)
 *
 * @global boolean $cfg['BZipDump']
 */
$cfg['BZipDump'] = true;

/**
 * Will compress gzip/bzip2 exports on the fly without the need for much memory.
 * If you encounter problems with created gzip/bzip2 files disable this feature.
 *
 * @global boolean $cfg['CompressOnFly']
 */
$cfg['CompressOnFly'] = true;


/*******************************************************************************
 * Tabs display settings
 */

/**
 * Use icons instead of text for the table display of a database (true|false|'both')
 *
 * @global boolean $cfg['PropertiesIconic']
 */
$cfg['PropertiesIconic'] = 'both';

/**
 * How many columns should be used for table display of a database?
 * (a value larger than 1 results in some information being hidden)
 *
 * @global integer $cfg['PropertiesNumColumns']
 */
$cfg['PropertiesNumColumns'] = 1;

/**
 * Possible values:
 * 'index.php' = the welcome page
 * (recommended for multiuser setups)
 * 'server_databases.php' = list of databases
 * 'server_status.php' = runtime information
 * 'server_variables.php' = MySQL server variables
 * 'server_privileges.php' = user management
 *
 * @global string $cfg['DefaultTabServer']
 */
$cfg['DefaultTabServer'] = 'index.php';

/**
 * Possible values:
 * 'db_structure.php' = tables list
 * 'db_sql.php' = SQL form
 * 'db_search.php' = search query
 * 'db_operations.php' = operations on database
 *
 * @global string $cfg['DefaultTabDatabase']
 */
$cfg['DefaultTabDatabase'] = 'db_structure.php';

/**
 * Possible values:
 * 'tbl_structure.php' = fields list
 * 'tbl_sql.php' = SQL form
 * 'tbl_select.php' = search page
 * 'tbl_change.php' = insert row page
 * 'sql.php' = browse page
 *
 * @global string $cfg['DefaultTabTable']
 */
$cfg['DefaultTabTable'] = 'sql.php';

/*******************************************************************************
 * Export defaults
 */
$cfg['Export'] = array();

/**
 * codegen/csv/excel/htmlexcel/htmlword/latex/ods/odt/pdf/sql/texytext/xls/xml/yaml
 *
 * @global string $cfg['Export']['format']
 */
$cfg['Export']['format'] = 'sql';

/**
 * quick/custom/custom-no-form
 *
 * @global string $cfg['Export']['format']
 */
$cfg['Export']['method'] = 'quick';

/**
 * none/zip/gzip/bzip2
 *
 * @global string $cfg['Export']['compression']
 */
$cfg['Export']['compression'] = 'none';

/**
 *
 *
 * @global boolean $cfg['Export']['asfile']
 */
$cfg['Export']['asfile'] = true;

/**
 *
 *
 * @global string $cfg['Export']['charset']
 */
$cfg['Export']['charset'] = '';

/**
 *
 *
 * @global boolean $cfg['Export']['onserver']
 */
$cfg['Export']['onserver'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['onserver_overwrite']
 */
$cfg['Export']['onserver_overwrite'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['quick_export_onserver']
 */
$cfg['Export']['quick_export_onserver'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['quick_export_onserver_overwrite']
 */
$cfg['Export']['quick_export_onserver_overwrite'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['remember_file_template']
 */
$cfg['Export']['remember_file_template'] = true;

/**
 *
 *
 * @global string $cfg['Export']['file_template_table']
 */
$cfg['Export']['file_template_table'] = '@TABLE@';

/**
 *
 *
 * @global string $cfg['Export']['file_template_database']
 */
$cfg['Export']['file_template_database'] = '@DATABASE@';

/**
 *
 *
 * @global string $cfg['Export']['file_template_server']
 */
$cfg['Export']['file_template_server'] = '@SERVER@';

/**
 *
 *
 * @global string $cfg['Export']['codegen_structure_or_data']
 */
$cfg['Export']['codegen_structure_or_data'] = 'data';

/**
 *
 *
 * @global $cfg['Export']['codegen_format']
 */
$cfg['Export']['codegen_format'] = 0;

/**
 *
 *
 * @global boolean $cfg['Export']['ods_columns']
 */
$cfg['Export']['ods_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['ods_null']
 */
$cfg['Export']['ods_null'] = 'NULL';

/**
 *
 *
 * @global string $cfg['Export']['odt_structure_or_data']
 */
$cfg['Export']['odt_structure_or_data'] = 'structure_and_data';

/**
 *
 *
 * @global boolean $cfg['Export']['odt_columns']
 */
$cfg['Export']['odt_columns'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['odt_relation']
 */
$cfg['Export']['odt_relation'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['odt_comments']
 */
$cfg['Export']['odt_comments'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['odt_mime']
 */
$cfg['Export']['odt_mime'] = true;

/**
 *
 *
 * @global string $cfg['Export']['odt_null']
 */
$cfg['Export']['odt_null'] = 'NULL';

/**
 *
 *
 * @global boolean $cfg['Export']['htmlword_structure_or_data']
 */
$cfg['Export']['htmlword_structure_or_data'] = 'structure_and_data';

/**
 *
 *
 * @global boolean $cfg['Export']['htmlword_columns']
 */
$cfg['Export']['htmlword_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['htmlword_null']
 */
$cfg['Export']['htmlword_null'] = 'NULL';

/**
 *
 *
 * @global string $cfg['Export']['texytext_structure_or_data']
 */
$cfg['Export']['texytext_structure_or_data'] = 'structure_and_data';

/**
 *
 *
 * @global boolean $cfg['Export']['texytext_columns']
 */
$cfg['Export']['texytext_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['texytext_null']
 */
$cfg['Export']['texytext_null'] = 'NULL';

/**
 *
 *
 * @global boolean $cfg['Export']['xls_columns']
 */
$cfg['Export']['xls_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['xls_structure_or_data']
 */
$cfg['Export']['xls_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['xls_null']
 */
$cfg['Export']['xls_null'] = 'NULL';

/**
 *
 *
 * @global boolean $cfg['Export']['xlsx_columns']
 */
$cfg['Export']['xlsx_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['xlsx_structure_or_data']
 */
$cfg['Export']['xlsx_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['xlsx_null']
 */
$cfg['Export']['xlsx_null'] = 'NULL';

/**
 *
 *
 * @global boolean $cfg['Export']['csv_columns']
 */
$cfg['Export']['csv_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['csv_structure_or_data']
 */
$cfg['Export']['csv_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['csv_null']
 */
$cfg['Export']['csv_null'] = 'NULL';

/**
 *
 *
 * @global string $cfg['Export']['csv_separator']
 */
$cfg['Export']['csv_separator'] = ',';

/**
 *
 *
 * @global string $cfg['Export']['csv_enclosed']
 */
$cfg['Export']['csv_enclosed'] = '"';

/**
 *
 *
 * @global string $cfg['Export']['csv_escaped']
 */
$cfg['Export']['csv_escaped'] = '"';

/**
 *
 *
 * @global string $cfg['Export']['csv_terminated']
 */
$cfg['Export']['csv_terminated'] = 'AUTO';

/**
 *
 *
 * @global string $cfg['Export']['csv_removeCRLF']
 */
$cfg['Export']['csv_removeCRLF'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['excel_columns']
 */
$cfg['Export']['excel_columns'] = false;

/**
 *
 *
 * @global string $cfg['Export']['excel_null']
 */
$cfg['Export']['excel_null'] = 'NULL';

/**
 * win/mac
 *
 * @global string $cfg['Export']['excel_edition']
 */
$cfg['Export']['excel_edition'] = 'win';

/**
 *
 *
 * @global string $cfg['Export']['excel_removeCRLF']
 */
$cfg['Export']['excel_removeCRLF'] = false;

/**
 *
 *
 * @global string $cfg['Export']['excel_structure_or_data']
 */
$cfg['Export']['excel_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['latex_structure_or_data']
 */
$cfg['Export']['latex_structure_or_data'] = 'structure_and_data';

/**
 *
 *
 * @global boolean $cfg['Export']['latex_columns']
 */
$cfg['Export']['latex_columns'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['latex_relation']
 */
$cfg['Export']['latex_relation'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['latex_comments']
 */
$cfg['Export']['latex_comments'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['latex_mime']
 */
$cfg['Export']['latex_mime'] = true;

/**
 *
 *
 * @global string $cfg['Export']['latex_null']
 */
$cfg['Export']['latex_null'] = '\textit{NULL}';

/**
 *
 *
 * @global boolean $cfg['Export']['latex_caption']
 */
$cfg['Export']['latex_caption'] = true;

/**
 *
 *
 * @global string $cfg['Export']['latex_structure_caption']
 */
$cfg['Export']['latex_structure_caption'] = 'strLatexStructure';

/**
 *
 *
 * @global string $cfg['Export']['latex_structure_continued_caption']
 */
$cfg['Export']['latex_structure_continued_caption']
    = 'strLatexStructure strLatexContinued';

/**
 *
 *
 * @global string $cfg['Export']['latex_data_caption']
 */
$cfg['Export']['latex_data_caption'] = 'strLatexContent';

/**
 *
 *
 * @global string $cfg['Export']['latex_data_continued_caption']
 */
$cfg['Export']['latex_data_continued_caption'] = 'strLatexContent strLatexContinued';

/**
 *
 *
 * @global string $cfg['Export']['latex_data_label']
 */
$cfg['Export']['latex_data_label'] = 'tab:@TABLE@-data';

/**
 *
 *
 * @global string $cfg['Export']['latex_structure_label']
 */
$cfg['Export']['latex_structure_label'] = 'tab:@TABLE@-structure';

/**
 *
 *
 * @global string $cfg['Export']['mediawiki_structure_or_data']
 */
$cfg['Export']['mediawiki_structure_or_data'] = 'data';

/**
 *
 *
 * @global boolean $cfg['Export']['mediawiki_caption']
 */

$cfg['Export']['mediawiki_caption'] = true;
/**
 *
 *
 * @global boolean $cfg['Export']['mediawiki_headers']
 */
$cfg['Export']['mediawiki_headers'] = true;

/**
 *
 *
 * @global string $cfg['Export']['ods_structure_or_data']
 */
$cfg['Export']['ods_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['pdf_structure_or_data']
 */
$cfg['Export']['pdf_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['phparray_structure_or_data']
 */
$cfg['Export']['phparray_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['json_structure_or_data']
 */
$cfg['Export']['json_structure_or_data'] = 'data';

/**
 *
 *
 * @global string $cfg['Export']['sql_structure_or_data']
 */
$cfg['Export']['sql_structure_or_data'] = 'structure_and_data';

/**
 *
 *
 * @global string $cfg['Export']['sql_compatibility']
 */
$cfg['Export']['sql_compatibility'] = 'NONE';

/**
 * Whether to include comments in SQL export.
 *
 * @global string $cfg['Export']['sql_include_comments']
 */
$cfg['Export']['sql_include_comments'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_disable_fk']
 */
$cfg['Export']['sql_disable_fk'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_use_transaction']
 */
$cfg['Export']['sql_use_transaction'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_drop_database']
 */
$cfg['Export']['sql_drop_database'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_drop_table']
 */
$cfg['Export']['sql_drop_table'] = false;

/**
 *
 *
 * true by default for correct behavior when dealing with exporting
 * of VIEWs and the stand-in table
 * @global boolean $cfg['Export']['sql_if_not_exists']
 */
$cfg['Export']['sql_if_not_exists'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_procedure_function']
 */
$cfg['Export']['sql_procedure_function'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_auto_increment']
 */
$cfg['Export']['sql_auto_increment'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_backquotes']
 */
$cfg['Export']['sql_backquotes'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_dates']
 */
$cfg['Export']['sql_dates'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_relation']
 */
$cfg['Export']['sql_relation'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_truncate']
 */
$cfg['Export']['sql_truncate'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_delayed']
 */
$cfg['Export']['sql_delayed'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_ignore']
 */
$cfg['Export']['sql_ignore'] = false;

/**
 * Export time in UTC.
 *
 * @global boolean $cfg['Export']['sql_utc_time']
 */
$cfg['Export']['sql_utc_time'] = true;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_hex_for_blob']
 */
$cfg['Export']['sql_hex_for_blob'] = true;

/**
 * insert/update/replace
 *
 * @global string $cfg['Export']['sql_type']
 */
$cfg['Export']['sql_type'] = 'INSERT';

/**
 *
 *
 * @global integer $cfg['Export']['sql_max_query_size']
 */
$cfg['Export']['sql_max_query_size'] = 50000;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_comments']
 */
$cfg['Export']['sql_comments'] = false;

/**
 *
 *
 * @global boolean $cfg['Export']['sql_mime']
 */
$cfg['Export']['sql_mime'] = false;

/**
 * \n is replaced by new line
 *
 * @global string $cfg['Export']['sql_header_comment']
 */
$cfg['Export']['sql_header_comment'] = '';

/**
 *
 *
 * @global boolean $cfg['Export']['sql_create_table_statements']
 */
$cfg['Export']['sql_create_table_statements'] = true;

/**
 * Whether to use complete inserts, extended inserts, both, or neither
 *
 * @global string $cfg['Export']['sql_insert_syntax']
 */
$cfg['Export']['sql_insert_syntax'] = 'both';

/**
 *
 *
 * @global string $cfg['Export']['pdf_report_title']
 */
$cfg['Export']['pdf_report_title'] = '';

/**
 *
 *
 *@global string $cfg['Export']['xml_structure_or_data']
 */
$cfg['Export']['xml_structure_or_data'] = 'data';

/**
 * Export schema for each structure
 *
 * @global string $cfg['Export']['xml_export_struc']
 */
$cfg['Export']['xml_export_struc'] = true;

/**
 * Export functions
 *
 * @global string $cfg['Export']['xml_export_functions']
 */
$cfg['Export']['xml_export_functions'] = true;

/**
 * Export procedures
 *
 * @global string $cfg['Export']['xml_export_procedures']
 */
$cfg['Export']['xml_export_procedures'] = true;

/**
 * Export schema for each table
 *
 * @global string $cfg['Export']['xml_export_tables']
 */
$cfg['Export']['xml_export_tables'] = true;

/**
 * Export triggers
 *
 * @global string $cfg['Export']['xml_export_triggers']
 */
$cfg['Export']['xml_export_triggers'] = true;

/**
 * Export views
 *
 * @global string $cfg['Export']['xml_export_views']
 */
$cfg['Export']['xml_export_views'] = true;

/**
 * Export contents data
 *
 * @global string $cfg['Export']['xml_export_contents']
 */
$cfg['Export']['xml_export_contents'] = true;

/**
 *
 *
 * @global string $cfg['Export']['yaml_structure_or_data']
 */
$cfg['Export']['yaml_structure_or_data'] = 'data';

/*******************************************************************************
 * Import defaults
 */
$cfg['Import'] = array();

/**
 *
 *
 * @global string $cfg['Import']['format']
 */
$cfg['Import']['format'] = 'sql';

/**
 * Default charset for import.
 *
 * @global string $cfg['Import']['charset']
 */
$cfg['Import']['charset'] = '';

/**
 *
 *
 * @global boolean $cfg['Import']['allow_interrupt']
 */
$cfg['Import']['allow_interrupt'] = true;

/**
 *
 *
 * @global integer $cfg['Import']['skip_queries']
 */
$cfg['Import']['skip_queries'] = 0;

/**
 *
 *
 * @global string $cfg['Import']['sql_compatibility']
 */
$cfg['Import']['sql_compatibility'] = 'NONE';

/**
 *
 *
 * @global string $cfg['Import']['sql_no_auto_value_on_zero']
 */
$cfg['Import']['sql_no_auto_value_on_zero'] = true;

/**
 *
 *
 * @global boolean $cfg['Import']['csv_replace']
 */
$cfg['Import']['csv_replace'] = false;

/**
 *
 *
 * @global boolean $cfg['Import']['csv_ignore']
 */
$cfg['Import']['csv_ignore'] = false;

/**
 *
 *
 * @global string $cfg['Import']['csv_terminated']
 */
$cfg['Import']['csv_terminated'] = ',';

/**
 *
 *
 * @global string $cfg['Import']['csv_enclosed']
 */
$cfg['Import']['csv_enclosed'] = '"';

/**
 *
 *
 * @global string $cfg['Import']['csv_escaped']
 */
$cfg['Import']['csv_escaped'] = '"';

/**
 *
 *
 * @global string $cfg['Import']['csv_new_line']
 */
$cfg['Import']['csv_new_line'] = 'auto';

/**
 *
 *
 * @global string $cfg['Import']['csv_columns']
 */
$cfg['Import']['csv_columns'] = '';

/**
 *
 *
 * @global string $cfg['Import']['csv_col_names']
 */
$cfg['Import']['csv_col_names'] = false;

/**
 *
 *
 * @global boolean $cfg['Import']['ldi_replace']
 */
$cfg['Import']['ldi_replace'] = false;

/**
 *
 *
 * @global boolean $cfg['Import']['ldi_ignore']
 */
$cfg['Import']['ldi_ignore'] = false;

/**
 *
 *
 * @global string $cfg['Import']['ldi_terminated']
 */
$cfg['Import']['ldi_terminated'] = ';';

/**
 *
 *
 * @global string $cfg['Import']['ldi_enclosed']
 */
$cfg['Import']['ldi_enclosed'] = '"';

/**
 *
 *
 * @global string $cfg['Import']['ldi_escaped']
 */
$cfg['Import']['ldi_escaped'] = '\\';

/**
 *
 *
 * @global string $cfg['Import']['ldi_new_line']
 */
$cfg['Import']['ldi_new_line'] = 'auto';

/**
 *
 *
 * @global string $cfg['Import']['ldi_columns']
 */
$cfg['Import']['ldi_columns'] = '';

/**
 * 'auto' for auto-detection, true or false for forcing
 *
 * @global string $cfg['Import']['ldi_local_option']
 */
$cfg['Import']['ldi_local_option'] = 'auto';

/**
 *
 *
 * @global string $cfg['Import']['ods_col_names']
 */
$cfg['Import']['ods_col_names'] = false;

/**
 *
 *
 * @global string $cfg['Import']['ods_empty_rows']
 */
$cfg['Import']['ods_empty_rows'] = true;

/**
 *
 *
 * @global string $cfg['Import']['ods_recognize_percentages']
 */
$cfg['Import']['ods_recognize_percentages'] = true;

/**
 *
 *
 * @global string $cfg['Import']['ods_recognize_currency']
 */
$cfg['Import']['ods_recognize_currency'] = true;

/**
 *
 *
 * @global string $cfg['Import']['xml_col_names']
 */
$cfg['Import']['xls_col_names'] = false;

/**
 *
 *
 * @global string $cfg['Import']['xml_empty_rows']
 */
$cfg['Import']['xls_empty_rows'] = true;

/**
 *
 *
 * @global string $cfg['Import']['xlsx_col_names']
 */
$cfg['Import']['xlsx_col_names'] = false;

/**
 * Link to the official MySQL documentation.
 * Be sure to include no trailing slash on the path.
 * See http://dev.mysql.com/doc/ for more information
 * about MySQL manuals and their types.
 *
 * @global string $cfg['MySQLManualBase']
 */
$cfg['MySQLManualBase'] = 'http://dev.mysql.com/doc/refman';

/**
 * Type of MySQL documentation:
 *   viewable     - "viewable online", current one used on MySQL website
 *   searchable   - "Searchable, with user comments"
 *   chapters     - "HTML, one page per chapter"
 *   chapters_old - "HTML, one page per chapter",
 *                  format used prior to MySQL 5.0 release
 *   big          - "HTML, all on one page"
 *   old          - old style used in phpMyAdmin 2.3.0 and sooner
 *   none         - do not show documentation links
 *
 * @global string $cfg['MySQLManualType']
 */
$cfg['MySQLManualType'] = 'viewable';


/*******************************************************************************
 * PDF options
 */

/**
 *
 *
 * @global array $cfg['PDFPageSizes']
 */
$cfg['PDFPageSizes'] = array('A3', 'A4', 'A5', 'letter', 'legal');

/**
 *
 *
 * @global string $cfg['PDFDefaultPageSize']
 */
$cfg['PDFDefaultPageSize'] = 'A4';


/*******************************************************************************
 * Language and character set conversion settings
 */

/**
 * Default language to use, if not browser-defined or user-defined
 *
 * @global string $cfg['DefaultLang']
 */
$cfg['DefaultLang'] = 'en';

/**
 * Default connection collation
 *
 * @global string $cfg['DefaultConnectionCollation']
 */
$cfg['DefaultConnectionCollation'] = 'utf8_general_ci';

/**
 * Force: always use this language
 * $cfg['Lang'] = 'en';
 *
 * Regular expression to limit listed languages, e.g. '^(cs|en)' for Czech and
 * English only
 *
 * @global string $cfg['FilterLanguages']
 */
$cfg['FilterLanguages'] = '';

/**
 * You can select here which functions will be used for character set conversion.
 * Possible values are:
 *      auto   - automatically use available one (first is tested iconv, then
 *               recode)
 *      iconv  - use iconv or libiconv functions
 *      recode - use recode_string function
 *      none   - disable encoding conversion
 *
 * @global string $cfg['RecodingEngine']
 */
$cfg['RecodingEngine'] = 'auto';

/**
 * Specify some parameters for iconv used in character set conversion. See iconv
 * documentation for details:
 * http://www.gnu.org/software/libiconv/documentation/libiconv/iconv_open.3.html
 *
 * @global string $cfg['IconvExtraParams']
 */
$cfg['IconvExtraParams'] = '//TRANSLIT';

/**
 * Available character sets for MySQL conversion. currently contains all which could
 * be found in lang/* files and few more.
 * Character sets will be shown in same order as here listed, so if you frequently
 * use some of these move them to the top.
 *
 * @global array $cfg['AvailableCharsets']
 */
$cfg['AvailableCharsets'] = array(
    'iso-8859-1',
    'iso-8859-2',
    'iso-8859-3',
    'iso-8859-4',
    'iso-8859-5',
    'iso-8859-6',
    'iso-8859-7',
    'iso-8859-8',
    'iso-8859-9',
    'iso-8859-10',
    'iso-8859-11',
    'iso-8859-12',
    'iso-8859-13',
    'iso-8859-14',
    'iso-8859-15',
    'windows-1250',
    'windows-1251',
    'windows-1252',
    'windows-1256',
    'windows-1257',
    'koi8-r',
    'big5',
    'gb2312',
    'utf-16',
    'utf-8',
    'utf-7',
    'x-user-defined',
    'euc-jp',
    'ks_c_5601-1987',
    'tis-620',
    'SHIFT_JIS'
);


/*******************************************************************************
 * Customization & design
 *
 * The graphical settings are now located in themes/theme-name/layout.inc.php
 */

/**
 * enable the left panel pointer
 * see also LeftPointerColor
 * in layout.inc.php
 *
 * @global boolean $cfg['NavigationTreePointerEnable']
 */
$cfg['NavigationTreePointerEnable'] = true;

/**
 * enable the browse pointer
 * see also BrowsePointerColor
 * in layout.inc.php
 *
 * @global boolean $cfg['BrowsePointerEnable']
 */
$cfg['BrowsePointerEnable'] = true;

/**
 * enable the browse marker
 * see also BrowseMarkerColor
 * in layout.inc.php
 *
 * @global boolean $cfg['BrowseMarkerEnable']
 */
$cfg['BrowseMarkerEnable'] = true;

/**
 * textarea size (columns) in edit mode
 * (this value will be emphasized (*2) for SQL
 * query textareas and (*1.25) for query window)
 *
 * @global integer $cfg['TextareaCols']
 */
$cfg['TextareaCols'] = 40;

/**
 * textarea size (rows) in edit mode
 *
 * @global integer $cfg['TextareaRows']
 */
$cfg['TextareaRows'] = 15;

/**
 * double size of textarea size for LONGTEXT columns
 *
 * @global boolean $cfg['LongtextDoubleTextarea']
 */
$cfg['LongtextDoubleTextarea'] = true;

/**
 * auto-select when clicking in the textarea of the query-box
 *
 * @global boolean $cfg['TextareaAutoSelect']
 */
$cfg['TextareaAutoSelect'] = false;

/**
 * textarea size (columns) for CHAR/VARCHAR
 *
 * @global integer $cfg['CharTextareaCols']
 */
$cfg['CharTextareaCols'] = 40;

/**
 * textarea size (rows) for CHAR/VARCHAR
 *
 * @global integer $cfg['CharTextareaRows']
 */
$cfg['CharTextareaRows'] = 2;

/**
 * Max field data length in browse mode for all non-numeric fields
 *
 * @global integer $cfg['LimitChars']
 */
$cfg['LimitChars'] = 50;

/**
 * Where to show the edit/copy/delete links in browse mode
 * Possible values are 'left', 'right', 'both' and 'none';
 * which will be interpreted as 'top', 'bottom', 'both' and 'none'
 * respectively for vertical display mode
 *
 * @global string $cfg['RowActionLinks']
 */
$cfg['RowActionLinks'] = 'left';

/**
 * default display direction (horizontal|vertical|horizontalflipped)
 *
 * @global string $cfg['DefaultDisplay']
 */
$cfg['DefaultDisplay'] = 'horizontal';

/**
 * remember the last way a table sorted
 *
 * @global string $cfg['RememberSorting']
 */
$cfg['RememberSorting'] = true;

/**
 * table-header rotation via faking or CSS? (css|fake|auto)
 * NOTE: CSS only works in IE browsers!
 *
 * @global string $cfg['HeaderFlipType']
 */
$cfg['HeaderFlipType'] = 'auto';

/**
 * shows stored relation-comments in 'browse' mode.
 *
 * @global boolean $cfg['ShowBrowseComments']
 */
$cfg['ShowBrowseComments'] = true;

/**
 * shows stored relation-comments in 'table property' mode.
 *
 * @global boolean $cfg['ShowPropertyComments']
 */
$cfg['ShowPropertyComments']= true;

/**
 * shows table display direction.
 */
$cfg['ShowDisplayDirection'] = false;

/**
 * repeat header names every X cells? (0 = deactivate)
 *
 * @global integer $cfg['RepeatCells']
 */
$cfg['RepeatCells'] = 100;

/**
 * Set to true if Edit link should open the query to edit in the query window
 * and to false if we should edit in the right panel
 *
 * @global boolean $cfg['EditInWindow']
 */
$cfg['EditInWindow'] = true;

/**
 * Width of Query window
 *
 * @global integer $cfg['QueryWindowWidth']
 */
$cfg['QueryWindowWidth'] = 550;

/**
 * Height of Query window
 *
 * @global integer $cfg['QueryWindowHeight']
 */
$cfg['QueryWindowHeight'] = 310;

/**
 * Set to true if you want DB-based query history.If false, this utilizes
 * JS-routines to display query history (lost by window close)
 *
 * @global boolean $cfg['QueryHistoryDB']
 */
$cfg['QueryHistoryDB'] = false;

/**
 * which tab to display in the querywindow on startup
 * (sql|files|history|full)
 *
 * @global string $cfg['QueryWindowDefTab']
 */
$cfg['QueryWindowDefTab'] = 'sql';

/**
 * When using DB-based query history, how many entries should be kept?
 *
 * @global integer $cfg['QueryHistoryMax']
 */
$cfg['QueryHistoryMax'] = 25;

/**
 * Use MIME-Types (stored in column comments table) for
 *
 * @global boolean $cfg['BrowseMIME']
 */
$cfg['BrowseMIME'] = true;

/**
 * When approximate count < this, PMA will get exact count for table rows.
 *
 * @global integer $cfg['MaxExactCount']
 */
$cfg['MaxExactCount'] = 0;

/**
 * Zero means that no row count is done for views; see the doc
 *
 * @global integer $cfg['MaxExactCountViews']
 */
$cfg['MaxExactCountViews'] = 0;

/**
 * Sort table and database in natural order
 *
 * @global boolean $cfg['NaturalOrder']
 */
$cfg['NaturalOrder'] = true;

/**
 * Initial state for sliders
 * (open | closed | disabled)
 *
 * @global string $cfg['InitialSlidersState']
 */
$cfg['InitialSlidersState'] = 'closed';

/**
 * User preferences: disallow these settings
 * For possible setting names look in libraries/config/user_preferences.forms.php
 *
 * @global array $cfg['UserprefsDisallow']
 */
$cfg['UserprefsDisallow'] = array();

/**
 * User preferences: enable the Developer tab
 */
$cfg['UserprefsDeveloperTab'] = false;

/*******************************************************************************
 * Window title settings
 */

/**
 * title of browser window when a table is selected
 *
 * @global string $cfg['TitleTable']
 */
$cfg['TitleTable'] = '@HTTP_HOST@ / @VSERVER@ / @DATABASE@ / @TABLE@ | @PHPMYADMIN@';

/**
 * title of browser window when a database is selected
 *
 * @global string $cfg['TitleDatabase']
 */
$cfg['TitleDatabase'] = '@HTTP_HOST@ / @VSERVER@ / @DATABASE@ | @PHPMYADMIN@';

/**
 * title of browser window when a server is selected
 *
 * @global string $cfg['TitleServer']
 */
$cfg['TitleServer'] = '@HTTP_HOST@ / @VSERVER@ | @PHPMYADMIN@';

/**
 * title of browser window when nothing is selected
 * @global string $cfg['TitleDefault']
 */
$cfg['TitleDefault'] = '@HTTP_HOST@ | @PHPMYADMIN@';


/*******************************************************************************
 * theme manager
 */

/**
 * using themes manager please set up here the path to 'themes' else leave empty
 *
 * @global string $cfg['ThemePath']
 */
$cfg['ThemePath'] = './themes';

/**
 * if you want to use selectable themes and if ThemesPath not empty
 * set it to true, else set it to false (default is false);
 *
 * @global boolean $cfg['ThemeManager']
 */
$cfg['ThemeManager'] = true;

/**
 * set up default theme, if ThemePath not empty you can set up here an valid
 * path to themes or 'original' for the original pma-theme
 *
 * @global string $cfg['ThemeDefault']
 */
$cfg['ThemeDefault'] = 'pmahomme';

/**
 * allow different theme for each configured server
 *
 * @global boolean $cfg['ThemePerServer']
 */
$cfg['ThemePerServer'] = false;


/*******************************************************************************
 *
 */

/**
 * Default query for table
 *
 * @global string $cfg['DefaultQueryTable']
 */
$cfg['DefaultQueryTable'] = 'SELECT * FROM @TABLE@ WHERE 1';

/**
 * Default query for database
 *
 * @global string $cfg['DefaultQueryDatabase']
 */
$cfg['DefaultQueryDatabase'] = '';


/*******************************************************************************
 * SQL Query box settings
 * These are the links display in all of the SQL Query boxes
 *
 * @global array $cfg['SQLQuery']
 */
$cfg['SQLQuery'] = array();

/**
 * Edit link to change a query
 *
 * @global boolean $cfg['SQLQuery']['Edit']
 */
$cfg['SQLQuery']['Edit'] = true;

/**
 * EXPLAIN on SELECT queries
 *
 * @global boolean $cfg['SQLQuery']['Explain']
 */
$cfg['SQLQuery']['Explain'] = true;

/**
 * Wrap a query in PHP
 *
 * @global boolean $cfg['SQLQuery']['ShowAsPHP']
 */
$cfg['SQLQuery']['ShowAsPHP'] = true;

/**
 * Validate a query (see $cfg['SQLValidator'] as well)
 *
 * @global boolean $cfg['SQLQuery']['Validate']
 */
$cfg['SQLQuery']['Validate'] = false;

/**
 * Refresh the results page
 *
 * @global boolean $cfg['SQLQuery']['Refresh']
 */
$cfg['SQLQuery']['Refresh'] = true;


/*******************************************************************************
 * Web server upload/save/import directories
 */

/**
 * Directory for uploaded files that can be executed by phpMyAdmin.
 * For example './upload'. Leave empty for no upload directory support.
 * Use %u for username inclusion.
 *
 * @global string $cfg['UploadDir']
 */
$cfg['UploadDir'] = '';

/**
 * Directory where phpMyAdmin can save exported data on server.
 * For example './save'. Leave empty for no save directory support.
 * Use %u for username inclusion.
 *
 * @global string $cfg['SaveDir']
 */
$cfg['SaveDir'] = '';

/**
 * Directory where phpMyAdmin can save temporary files.
 *
 * @global string $cfg['TempDir']
 */
$cfg['TempDir'] = '';


/**
 * Misc. settings
 */

/**
 * Is GD >= 2 available? Set to yes/no/auto. 'auto' does auto-detection,
 * which is the only safe way to determine GD version.
 *
 * @global string $cfg['GD2Available']
 */
$cfg['GD2Available'] = 'auto';

/**
 * Lists proxy IP and HTTP header combinations which are trusted for IP allow/deny
 *
 * @global array $cfg['TrustedProxies']
 */
$cfg['TrustedProxies'] = array();

/**
 * We normally check the permissions on the configuration file to ensure
 * it's not world writable. However, phpMyAdmin could be installed on
 * a NTFS filesystem mounted on a non-Windows server, in which case the
 * permissions seems wrong but in fact cannot be detected. In this case
 * a sysadmin would set the following to false.
 */
$cfg['CheckConfigurationPermissions'] = true;

/**
 * Limit for length of URL in links. When length would be above this limit, it
 * is replaced by form with button.
 * This is required as some web servers (IIS) have problems with long URLs.
 * The recommended limit is 2000
 * (see http://www.boutell.com/newfaq/misc/urllength.html) but we put
 * 1000 to accommodate Suhosin, see bug #3358750.
 */
$cfg['LinkLengthLimit'] = 1000;

/**
 * Additional string to allow in CSP headers.
 */
 $cfg['CSPAllow'] = '';

/**
 * Disable the table maintenance mass operations, like optimizing or
 * repairing the selected tables of a database. An accidental execution
 * of such a maintenance task can enormously slow down a bigger database.
 */
$cfg['DisableMultiTableMaintenance'] = false;

/*******************************************************************************
 * SQL Parser Settings
 *
 * @global array $cfg['SQP']
 */
$cfg['SQP'] = array();

/**
 * Pretty-printing style to use on queries (html, text, none)
 *
 * @global string $cfg['SQP']['fmtType']
 */
$cfg['SQP']['fmtType'] = 'html';

/**
 * Amount to indent each level (floats are valid)
 *
 * @global integer $cfg['SQP']['fmtInd']
 */
$cfg['SQP']['fmtInd'] = '1';

/**
 * Units for indenting each level (CSS Types - {em, px, pt})
 *
 * @global string $cfg['SQP']['fmtIndUnit']
 */
$cfg['SQP']['fmtIndUnit'] = 'em';


/*******************************************************************************
 * If you wish to use the SQL Validator service, you should be aware of the
 * following:
 * All SQL statements are stored anonymously for statistical purposes.
 * Mimer SQL Validator, Copyright 2002 Upright Database Technology.
 * All rights reserved.
 *
 * @global array $cfg['SQLValidator']
 */
$cfg['SQLValidator'] = array();

/**
 * Make the SQL Validator available
 *
 * @global boolean $cfg['SQLValidator']['use']
 */
$cfg['SQLValidator']['use'] = false;

/**
 * If you have a custom username, specify it here (defaults to anonymous)
 *
 * @global string $cfg['SQLValidator']['username']
 */
$cfg['SQLValidator']['username'] = '';

/**
 * Password for username
 *
 * @global string $cfg['SQLValidator']['password']
 */
$cfg['SQLValidator']['password'] = '';


/*******************************************************************************
 * Developers ONLY!
 *
 * @global array $cfg['DBG']
 */
$cfg['DBG'] = array();

/**
 * Output executed queries and their execution times
 *
 * @global boolean $cfg['DBG']['sql']
 */
$cfg['DBG']['sql'] = false;


/*******************************************************************************
 * MySQL settings
 */

/**
 * Default functions for above defined groups
 *
 * @global array $cfg['DefaultFunctions']
 */
$cfg['DefaultFunctions'] = array(
    'FUNC_CHAR' => '',
    'FUNC_DATE' => '',
    'FUNC_NUMBER' => '',
    'FUNC_SPATIAL' => 'GeomFromText',
    'FUNC_UUID' => 'UUID',
    'first_timestamp' => 'NOW',
);

/**
 * Max rows retreived for zoom search
 */
$cfg['maxRowPlotLimit'] = 500;

?>
