/* *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0  
 
THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, 
MERCHANTABLITY OR NON-INFRINGEMENT. 
 
See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var TypeScript;
(function (TypeScript) {
    var ArrayUtilities = (function () {
        function ArrayUtilities() {
        }
        ArrayUtilities.isArray = function (value) {
            return Object.prototype.toString.apply(value, []) === '[object Array]';
        };

        ArrayUtilities.sequenceEquals = function (array1, array2, equals) {
            if (array1 === array2) {
                return true;
            }

            if (array1 === null || array2 === null) {
                return false;
            }

            if (array1.length !== array2.length) {
                return false;
            }

            for (var i = 0, n = array1.length; i < n; i++) {
                if (!equals(array1[i], array2[i])) {
                    return false;
                }
            }

            return true;
        };

        ArrayUtilities.contains = function (array, value) {
            for (var i = 0; i < array.length; i++) {
                if (array[i] === value) {
                    return true;
                }
            }

            return false;
        };

        ArrayUtilities.groupBy = function (array, func) {
            var result = {};

            for (var i = 0, n = array.length; i < n; i++) {
                var v = array[i];
                var k = func(v);

                var list = result[k] || [];
                list.push(v);
                result[k] = list;
            }

            return result;
        };

        ArrayUtilities.min = function (array, func) {
            var min = func(array[0]);

            for (var i = 1; i < array.length; i++) {
                var next = func(array[i]);
                if (next < min) {
                    min = next;
                }
            }

            return min;
        };

        ArrayUtilities.max = function (array, func) {
            var max = func(array[0]);

            for (var i = 1; i < array.length; i++) {
                var next = func(array[i]);
                if (next > max) {
                    max = next;
                }
            }

            return max;
        };

        ArrayUtilities.last = function (array) {
            if (array.length === 0) {
                throw TypeScript.Errors.argumentOutOfRange('array');
            }

            return array[array.length - 1];
        };

        ArrayUtilities.firstOrDefault = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                var value = array[i];
                if (func(value)) {
                    return value;
                }
            }

            return null;
        };

        ArrayUtilities.sum = function (array, func) {
            var result = 0;

            for (var i = 0, n = array.length; i < n; i++) {
                result += func(array[i]);
            }

            return result;
        };

        ArrayUtilities.whereNotNull = function (array) {
            var result = [];
            for (var i = 0; i < array.length; i++) {
                var value = array[i];
                if (value !== null) {
                    result.push(value);
                }
            }

            return result;
        };

        ArrayUtilities.select = function (values, func) {
            var result = [];

            for (var i = 0; i < values.length; i++) {
                result.push(func(values[i]));
            }

            return result;
        };

        ArrayUtilities.where = function (values, func) {
            var result = [];

            for (var i = 0; i < values.length; i++) {
                if (func(values[i])) {
                    result.push(values[i]);
                }
            }

            return result;
        };

        ArrayUtilities.any = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                if (func(array[i])) {
                    return true;
                }
            }

            return false;
        };

        ArrayUtilities.all = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                if (!func(array[i])) {
                    return false;
                }
            }

            return true;
        };

        ArrayUtilities.binarySearch = function (array, value) {
            var low = 0;
            var high = array.length - 1;

            while (low <= high) {
                var middle = low + ((high - low) >> 1);
                var midValue = array[middle];

                if (midValue === value) {
                    return middle;
                } else if (midValue > value) {
                    high = middle - 1;
                } else {
                    low = middle + 1;
                }
            }

            return ~low;
        };

        ArrayUtilities.createArray = function (length, defaultvalue) {
            var result = [];
            for (var i = 0; i < length; i++) {
                result.push(defaultvalue);
            }

            return result;
        };

        ArrayUtilities.grow = function (array, length, defaultValue) {
            var count = length - array.length;
            for (var i = 0; i < count; i++) {
                array.push(defaultValue);
            }
        };

        ArrayUtilities.copy = function (sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
            for (var i = 0; i < length; i++) {
                destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
            }
        };
        return ArrayUtilities;
    })();
    TypeScript.ArrayUtilities = ArrayUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Constants) {
        Constants[Constants["Max31BitInteger"] = 1073741823] = "Max31BitInteger";
        Constants[Constants["Min31BitInteger"] = -1073741824] = "Min31BitInteger";
    })(TypeScript.Constants || (TypeScript.Constants = {}));
    var Constants = TypeScript.Constants;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Contract = (function () {
        function Contract() {
        }
        Contract.requires = function (expression) {
            if (!expression) {
                throw new Error("Contract violated. False expression.");
            }
        };

        Contract.throwIfFalse = function (expression) {
            if (!expression) {
                throw new Error("Contract violated. False expression.");
            }
        };

        Contract.throwIfNull = function (value) {
            if (value === null) {
                throw new Error("Contract violated. Null value.");
            }
        };
        return Contract;
    })();
    TypeScript.Contract = Contract;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Debug = (function () {
        function Debug() {
        }
        Debug.assert = function (expression, message) {
            if (!expression) {
                throw new Error("Debug Failure. False expression: " + (message ? message : ""));
            }
        };
        return Debug;
    })();
    TypeScript.Debug = Debug;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (DiagnosticCategory) {
        DiagnosticCategory[DiagnosticCategory["Warning"] = 0] = "Warning";
        DiagnosticCategory[DiagnosticCategory["Error"] = 1] = "Error";
        DiagnosticCategory[DiagnosticCategory["Message"] = 2] = "Message";
        DiagnosticCategory[DiagnosticCategory["NoPrefix"] = 3] = "NoPrefix";
    })(TypeScript.DiagnosticCategory || (TypeScript.DiagnosticCategory = {}));
    var DiagnosticCategory = TypeScript.DiagnosticCategory;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (DiagnosticCode) {
        DiagnosticCode[DiagnosticCode["error_TS_0__1"] = 0] = "error_TS_0__1";
        DiagnosticCode[DiagnosticCode["warning_TS_0__1"] = 1] = "warning_TS_0__1";

        DiagnosticCode[DiagnosticCode["_0__NL__1_TB__2"] = 2] = "_0__NL__1_TB__2";
        DiagnosticCode[DiagnosticCode["_0_TB__1"] = 3] = "_0_TB__1";

        DiagnosticCode[DiagnosticCode["Unrecognized_escape_sequence"] = 4] = "Unrecognized_escape_sequence";
        DiagnosticCode[DiagnosticCode["Unexpected_character_0"] = 5] = "Unexpected_character_0";
        DiagnosticCode[DiagnosticCode["Missing_closing_quote_character"] = 6] = "Missing_closing_quote_character";
        DiagnosticCode[DiagnosticCode["Identifier_expected"] = 7] = "Identifier_expected";
        DiagnosticCode[DiagnosticCode["_0_keyword_expected"] = 8] = "_0_keyword_expected";
        DiagnosticCode[DiagnosticCode["_0_expected"] = 9] = "_0_expected";
        DiagnosticCode[DiagnosticCode["Identifier_expected__0__is_a_keyword"] = 10] = "Identifier_expected__0__is_a_keyword";
        DiagnosticCode[DiagnosticCode["Automatic_semicolon_insertion_not_allowed"] = 11] = "Automatic_semicolon_insertion_not_allowed";
        DiagnosticCode[DiagnosticCode["Unexpected_token__0_expected"] = 12] = "Unexpected_token__0_expected";
        DiagnosticCode[DiagnosticCode["Trailing_separator_not_allowed"] = 13] = "Trailing_separator_not_allowed";
        DiagnosticCode[DiagnosticCode["_StarSlash__expected"] = 14] = "_StarSlash__expected";
        DiagnosticCode[DiagnosticCode["_public_or_private_modifier_must_precede__static_"] = 15] = "_public_or_private_modifier_must_precede__static_";
        DiagnosticCode[DiagnosticCode["Unexpected_token_"] = 16] = "Unexpected_token_";
        DiagnosticCode[DiagnosticCode["A_catch_clause_variable_cannot_have_a_type_annotation"] = 17] = "A_catch_clause_variable_cannot_have_a_type_annotation";
        DiagnosticCode[DiagnosticCode["Rest_parameter_must_be_last_in_list"] = 18] = "Rest_parameter_must_be_last_in_list";
        DiagnosticCode[DiagnosticCode["Parameter_cannot_have_question_mark_and_initializer"] = 19] = "Parameter_cannot_have_question_mark_and_initializer";
        DiagnosticCode[DiagnosticCode["Required_parameter_cannot_follow_optional_parameter"] = 20] = "Required_parameter_cannot_follow_optional_parameter";
        DiagnosticCode[DiagnosticCode["Index_signatures_cannot_have_rest_parameters"] = 21] = "Index_signatures_cannot_have_rest_parameters";
        DiagnosticCode[DiagnosticCode["Index_signature_parameter_cannot_have_accessibility_modifiers"] = 22] = "Index_signature_parameter_cannot_have_accessibility_modifiers";
        DiagnosticCode[DiagnosticCode["Index_signature_parameter_cannot_have_a_question_mark"] = 23] = "Index_signature_parameter_cannot_have_a_question_mark";
        DiagnosticCode[DiagnosticCode["Index_signature_parameter_cannot_have_an_initializer"] = 24] = "Index_signature_parameter_cannot_have_an_initializer";
        DiagnosticCode[DiagnosticCode["Index_signature_must_have_a_type_annotation"] = 25] = "Index_signature_must_have_a_type_annotation";
        DiagnosticCode[DiagnosticCode["Index_signature_parameter_must_have_a_type_annotation"] = 26] = "Index_signature_parameter_must_have_a_type_annotation";
        DiagnosticCode[DiagnosticCode["Index_signature_parameter_type_must_be__string__or__number_"] = 27] = "Index_signature_parameter_type_must_be__string__or__number_";
        DiagnosticCode[DiagnosticCode["_extends__clause_already_seen"] = 28] = "_extends__clause_already_seen";
        DiagnosticCode[DiagnosticCode["_extends__clause_must_precede__implements__clause"] = 29] = "_extends__clause_must_precede__implements__clause";
        DiagnosticCode[DiagnosticCode["Class_can_only_extend_single_type"] = 30] = "Class_can_only_extend_single_type";
        DiagnosticCode[DiagnosticCode["_implements__clause_already_seen"] = 31] = "_implements__clause_already_seen";
        DiagnosticCode[DiagnosticCode["Accessibility_modifier_already_seen"] = 32] = "Accessibility_modifier_already_seen";
        DiagnosticCode[DiagnosticCode["_0__modifier_must_precede__1__modifier"] = 33] = "_0__modifier_must_precede__1__modifier";
        DiagnosticCode[DiagnosticCode["_0__modifier_already_seen"] = 34] = "_0__modifier_already_seen";
        DiagnosticCode[DiagnosticCode["_0__modifier_cannot_appear_on_a_class_element"] = 35] = "_0__modifier_cannot_appear_on_a_class_element";
        DiagnosticCode[DiagnosticCode["Interface_declaration_cannot_have__implements__clause"] = 36] = "Interface_declaration_cannot_have__implements__clause";
        DiagnosticCode[DiagnosticCode["_super__invocation_cannot_have_type_arguments"] = 37] = "_super__invocation_cannot_have_type_arguments";
        DiagnosticCode[DiagnosticCode["Non_ambient_modules_cannot_use_quoted_names"] = 38] = "Non_ambient_modules_cannot_use_quoted_names";
        DiagnosticCode[DiagnosticCode["Statements_are_not_allowed_in_ambient_contexts"] = 39] = "Statements_are_not_allowed_in_ambient_contexts";
        DiagnosticCode[DiagnosticCode["Implementations_are_not_allowed_in_ambient_contexts"] = 40] = "Implementations_are_not_allowed_in_ambient_contexts";
        DiagnosticCode[DiagnosticCode["_declare__modifier_not_allowed_for_code_already_in_an_ambient_context"] = 41] = "_declare__modifier_not_allowed_for_code_already_in_an_ambient_context";
        DiagnosticCode[DiagnosticCode["Initializers_are_not_allowed_in_ambient_contexts"] = 42] = "Initializers_are_not_allowed_in_ambient_contexts";
        DiagnosticCode[DiagnosticCode["Overload_and_ambient_signatures_cannot_specify_parameter_properties"] = 43] = "Overload_and_ambient_signatures_cannot_specify_parameter_properties";
        DiagnosticCode[DiagnosticCode["Function_implementation_expected"] = 44] = "Function_implementation_expected";
        DiagnosticCode[DiagnosticCode["Constructor_implementation_expected"] = 45] = "Constructor_implementation_expected";
        DiagnosticCode[DiagnosticCode["Function_overload_name_must_be__0_"] = 46] = "Function_overload_name_must_be__0_";
        DiagnosticCode[DiagnosticCode["_0__modifier_cannot_appear_on_a_module_element"] = 47] = "_0__modifier_cannot_appear_on_a_module_element";
        DiagnosticCode[DiagnosticCode["_declare__modifier_cannot_appear_on_an_interface_declaration"] = 48] = "_declare__modifier_cannot_appear_on_an_interface_declaration";
        DiagnosticCode[DiagnosticCode["_declare__modifier_required_for_top_level_element"] = 49] = "_declare__modifier_required_for_top_level_element";
        DiagnosticCode[DiagnosticCode["_set__accessor_must_have_only_one_parameter"] = 50] = "_set__accessor_must_have_only_one_parameter";
        DiagnosticCode[DiagnosticCode["_set__accessor_parameter_cannot_have_accessibility_modifier"] = 51] = "_set__accessor_parameter_cannot_have_accessibility_modifier";
        DiagnosticCode[DiagnosticCode["_set__accessor_parameter_cannot_be_optional"] = 52] = "_set__accessor_parameter_cannot_be_optional";
        DiagnosticCode[DiagnosticCode["_set__accessor_parameter_cannot_have_initializer"] = 53] = "_set__accessor_parameter_cannot_have_initializer";
        DiagnosticCode[DiagnosticCode["_set__accessor_cannot_have_rest_parameter"] = 54] = "_set__accessor_cannot_have_rest_parameter";
        DiagnosticCode[DiagnosticCode["_get__accessor_cannot_have_parameters"] = 55] = "_get__accessor_cannot_have_parameters";
        DiagnosticCode[DiagnosticCode["Rest_parameter_cannot_be_optional"] = 56] = "Rest_parameter_cannot_be_optional";
        DiagnosticCode[DiagnosticCode["Rest_parameter_cannot_have_initializer"] = 57] = "Rest_parameter_cannot_have_initializer";
        DiagnosticCode[DiagnosticCode["Modifiers_cannot_appear_here"] = 58] = "Modifiers_cannot_appear_here";
        DiagnosticCode[DiagnosticCode["Accessors_are_only_available_when_targeting_EcmaScript5_and_higher"] = 59] = "Accessors_are_only_available_when_targeting_EcmaScript5_and_higher";
        DiagnosticCode[DiagnosticCode["Class_name_cannot_be__0_"] = 60] = "Class_name_cannot_be__0_";
        DiagnosticCode[DiagnosticCode["Interface_name_cannot_be__0_"] = 61] = "Interface_name_cannot_be__0_";
        DiagnosticCode[DiagnosticCode["Enum_name_cannot_be__0_"] = 62] = "Enum_name_cannot_be__0_";
        DiagnosticCode[DiagnosticCode["Module_name_cannot_be__0_"] = 63] = "Module_name_cannot_be__0_";
        DiagnosticCode[DiagnosticCode["Enum_member_must_have_initializer"] = 64] = "Enum_member_must_have_initializer";
        DiagnosticCode[DiagnosticCode["_module_______is_deprecated__Use__require_______instead"] = 65] = "_module_______is_deprecated__Use__require_______instead";
        DiagnosticCode[DiagnosticCode["Export_assignments_cannot_be_used_in_internal_modules"] = 66] = "Export_assignments_cannot_be_used_in_internal_modules";
        DiagnosticCode[DiagnosticCode["Export_assignment_not_allowed_in_module_with_exported_element"] = 67] = "Export_assignment_not_allowed_in_module_with_exported_element";
        DiagnosticCode[DiagnosticCode["Module_cannot_have_multiple_export_assignments"] = 68] = "Module_cannot_have_multiple_export_assignments";

        DiagnosticCode[DiagnosticCode["Duplicate_identifier__0_"] = 69] = "Duplicate_identifier__0_";
        DiagnosticCode[DiagnosticCode["The_name__0__does_not_exist_in_the_current_scope"] = 70] = "The_name__0__does_not_exist_in_the_current_scope";
        DiagnosticCode[DiagnosticCode["The_name__0__does_not_refer_to_a_value"] = 71] = "The_name__0__does_not_refer_to_a_value";
        DiagnosticCode[DiagnosticCode["Keyword__super__can_only_be_used_inside_a_class_instance_method"] = 72] = "Keyword__super__can_only_be_used_inside_a_class_instance_method";
        DiagnosticCode[DiagnosticCode["The_left_hand_side_of_an_assignment_expression_must_be_a_variable__property_or_indexer"] = 73] = "The_left_hand_side_of_an_assignment_expression_must_be_a_variable__property_or_indexer";
        DiagnosticCode[DiagnosticCode["Value_of_type__0__is_not_callable__Did_you_mean_to_include__new__"] = 74] = "Value_of_type__0__is_not_callable__Did_you_mean_to_include__new__";
        DiagnosticCode[DiagnosticCode["Value_of_type__0__is_not_callable"] = 75] = "Value_of_type__0__is_not_callable";
        DiagnosticCode[DiagnosticCode["Value_of_type__0__is_not_newable"] = 76] = "Value_of_type__0__is_not_newable";
        DiagnosticCode[DiagnosticCode["Value_of_type__0__is_not_indexable_by_type__1_"] = 77] = "Value_of_type__0__is_not_indexable_by_type__1_";
        DiagnosticCode[DiagnosticCode["Operator__0__cannot_be_applied_to_types__1__and__2_"] = 78] = "Operator__0__cannot_be_applied_to_types__1__and__2_";
        DiagnosticCode[DiagnosticCode["Operator__0__cannot_be_applied_to_types__1__and__2__3"] = 79] = "Operator__0__cannot_be_applied_to_types__1__and__2__3";
        DiagnosticCode[DiagnosticCode["Cannot_convert__0__to__1_"] = 80] = "Cannot_convert__0__to__1_";
        DiagnosticCode[DiagnosticCode["Cannot_convert__0__to__1__NL__2"] = 81] = "Cannot_convert__0__to__1__NL__2";
        DiagnosticCode[DiagnosticCode["Expected_var__class__interface__or_module"] = 82] = "Expected_var__class__interface__or_module";
        DiagnosticCode[DiagnosticCode["Operator__0__cannot_be_applied_to_type__1_"] = 83] = "Operator__0__cannot_be_applied_to_type__1_";
        DiagnosticCode[DiagnosticCode["Getter__0__already_declared"] = 84] = "Getter__0__already_declared";
        DiagnosticCode[DiagnosticCode["Setter__0__already_declared"] = 85] = "Setter__0__already_declared";
        DiagnosticCode[DiagnosticCode["Accessor_cannot_have_type_parameters"] = 86] = "Accessor_cannot_have_type_parameters";
        DiagnosticCode[DiagnosticCode["Exported_class__0__extends_private_class__1_"] = 87] = "Exported_class__0__extends_private_class__1_";
        DiagnosticCode[DiagnosticCode["Exported_class__0__implements_private_interface__1_"] = 88] = "Exported_class__0__implements_private_interface__1_";
        DiagnosticCode[DiagnosticCode["Exported_interface__0__extends_private_interface__1_"] = 89] = "Exported_interface__0__extends_private_interface__1_";
        DiagnosticCode[DiagnosticCode["Exported_class__0__extends_class_from_inaccessible_module__1_"] = 90] = "Exported_class__0__extends_class_from_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Exported_class__0__implements_interface_from_inaccessible_module__1_"] = 91] = "Exported_class__0__implements_interface_from_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Exported_interface__0__extends_interface_from_inaccessible_module__1_"] = 92] = "Exported_interface__0__extends_interface_from_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Public_static_property__0__of__exported_class_has_or_is_using_private_type__1_"] = 93] = "Public_static_property__0__of__exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Public_property__0__of__exported_class_has_or_is_using_private_type__1_"] = 94] = "Public_property__0__of__exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Property__0__of__exported_interface_has_or_is_using_private_type__1_"] = 95] = "Property__0__of__exported_interface_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Exported_variable__0__has_or_is_using_private_type__1_"] = 96] = "Exported_variable__0__has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Public_static_property__0__of__exported_class_is_using_inaccessible_module__1_"] = 97] = "Public_static_property__0__of__exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Public_property__0__of__exported_class_is_using_inaccessible_module__1_"] = 98] = "Public_property__0__of__exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Property__0__of__exported_interface_is_using_inaccessible_module__1_"] = 99] = "Property__0__of__exported_interface_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Exported_variable__0__is_using_inaccessible_module__1_"] = 100] = "Exported_variable__0__is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_constructor_from_exported_class_has_or_is_using_private_type__1_"] = 101] = "Parameter__0__of_constructor_from_exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_static_property_setter_from_exported_class_has_or_is_using_private_type__1_"] = 102] = "Parameter__0__of_public_static_property_setter_from_exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_property_setter_from_exported_class_has_or_is_using_private_type__1_"] = 103] = "Parameter__0__of_public_property_setter_from_exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_constructor_signature_from_exported_interface_has_or_is_using_private_type__1_"] = 104] = "Parameter__0__of_constructor_signature_from_exported_interface_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_call_signature_from_exported_interface_has_or_is_using_private_type__1_"] = 105] = "Parameter__0__of_call_signature_from_exported_interface_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_static_method_from_exported_class_has_or_is_using_private_type__1_"] = 106] = "Parameter__0__of_public_static_method_from_exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_method_from_exported_class_has_or_is_using_private_type__1_"] = 107] = "Parameter__0__of_public_method_from_exported_class_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_method_from_exported_interface_has_or_is_using_private_type__1_"] = 108] = "Parameter__0__of_method_from_exported_interface_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_exported_function_has_or_is_using_private_type__1_"] = 109] = "Parameter__0__of_exported_function_has_or_is_using_private_type__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_constructor_from_exported_class_is_using_inaccessible_module__1_"] = 110] = "Parameter__0__of_constructor_from_exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_static_property_setter_from_exported_class_is_using_inaccessible_module__1_"] = 111] = "Parameter__0__of_public_static_property_setter_from_exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_property_setter_from_exported_class_is_using_inaccessible_module__1_"] = 112] = "Parameter__0__of_public_property_setter_from_exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_constructor_signature_from_exported_interface_is_using_inaccessible_module__1_"] = 113] = "Parameter__0__of_constructor_signature_from_exported_interface_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_call_signature_from_exported_interface_is_using_inaccessible_module__1_"] = 114] = "Parameter__0__of_call_signature_from_exported_interface_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_static_method_from_exported_class_is_using_inaccessible_module__1_"] = 115] = "Parameter__0__of_public_static_method_from_exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_public_method_from_exported_class_is_using_inaccessible_module__1_"] = 116] = "Parameter__0__of_public_method_from_exported_class_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_method_from_exported_interface_is_using_inaccessible_module__1_"] = 117] = "Parameter__0__of_method_from_exported_interface_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Parameter__0__of_exported_function_is_using_inaccessible_module__1_"] = 118] = "Parameter__0__of_exported_function_is_using_inaccessible_module__1_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_private_type__0_"] = 119] = "Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_property_getter_from_exported_class_has_or_is_using_private_type__0_"] = 120] = "Return_type_of_public_property_getter_from_exported_class_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_type__0_"] = 121] = "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_type__0_"] = 122] = "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_type__0_"] = 123] = "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_type__0_"] = 124] = "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_method_from_exported_class_has_or_is_using_private_type__0_"] = 125] = "Return_type_of_public_method_from_exported_class_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_method_from_exported_interface_has_or_is_using_private_type__0_"] = 126] = "Return_type_of_method_from_exported_interface_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_exported_function_has_or_is_using_private_type__0_"] = 127] = "Return_type_of_exported_function_has_or_is_using_private_type__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_static_property_getter_from_exported_class_is_using_inaccessible_module__0_"] = 128] = "Return_type_of_public_static_property_getter_from_exported_class_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_property_getter_from_exported_class_is_using_inaccessible_module__0_"] = 129] = "Return_type_of_public_property_getter_from_exported_class_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_constructor_signature_from_exported_interface_is_using_inaccessible_module__0_"] = 130] = "Return_type_of_constructor_signature_from_exported_interface_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_call_signature_from_exported_interface_is_using_inaccessible_module__0_"] = 131] = "Return_type_of_call_signature_from_exported_interface_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_index_signature_from_exported_interface_is_using_inaccessible_module__0_"] = 132] = "Return_type_of_index_signature_from_exported_interface_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_static_method_from_exported_class_is_using_inaccessible_module__0_"] = 133] = "Return_type_of_public_static_method_from_exported_class_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_public_method_from_exported_class_is_using_inaccessible_module__0_"] = 134] = "Return_type_of_public_method_from_exported_class_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_method_from_exported_interface_is_using_inaccessible_module__0_"] = 135] = "Return_type_of_method_from_exported_interface_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["Return_type_of_exported_function_is_using_inaccessible_module__0_"] = 136] = "Return_type_of_exported_function_is_using_inaccessible_module__0_";
        DiagnosticCode[DiagnosticCode["_new_T____cannot_be_used_to_create_an_array__Use__new_Array_T_____instead"] = 137] = "_new_T____cannot_be_used_to_create_an_array__Use__new_Array_T_____instead";
        DiagnosticCode[DiagnosticCode["A_parameter_list_must_follow_a_generic_type_argument_list______expected"] = 138] = "A_parameter_list_must_follow_a_generic_type_argument_list______expected";
        DiagnosticCode[DiagnosticCode["Multiple_constructor_implementations_are_not_allowed"] = 139] = "Multiple_constructor_implementations_are_not_allowed";
        DiagnosticCode[DiagnosticCode["Unable_to_resolve_external_module__0_"] = 140] = "Unable_to_resolve_external_module__0_";
        DiagnosticCode[DiagnosticCode["Module_cannot_be_aliased_to_a_non_module_type"] = 141] = "Module_cannot_be_aliased_to_a_non_module_type";
        DiagnosticCode[DiagnosticCode["A_class_may_only_extend_another_class"] = 142] = "A_class_may_only_extend_another_class";
        DiagnosticCode[DiagnosticCode["A_class_may_only_implement_another_class_or_interface"] = 143] = "A_class_may_only_implement_another_class_or_interface";
        DiagnosticCode[DiagnosticCode["An_interface_may_only_extend_another_class_or_interface"] = 144] = "An_interface_may_only_extend_another_class_or_interface";
        DiagnosticCode[DiagnosticCode["An_interface_cannot_implement_another_type"] = 145] = "An_interface_cannot_implement_another_type";
        DiagnosticCode[DiagnosticCode["Unable_to_resolve_type"] = 146] = "Unable_to_resolve_type";
        DiagnosticCode[DiagnosticCode["Unable_to_resolve_type_of__0_"] = 147] = "Unable_to_resolve_type_of__0_";
        DiagnosticCode[DiagnosticCode["Unable_to_resolve_type_parameter_constraint"] = 148] = "Unable_to_resolve_type_parameter_constraint";
        DiagnosticCode[DiagnosticCode["Type_parameter_constraint_cannot_be_a_primitive_type"] = 149] = "Type_parameter_constraint_cannot_be_a_primitive_type";
        DiagnosticCode[DiagnosticCode["Supplied_parameters_do_not_match_any_signature_of_call_target"] = 150] = "Supplied_parameters_do_not_match_any_signature_of_call_target";
        DiagnosticCode[DiagnosticCode["Supplied_parameters_do_not_match_any_signature_of_call_target__NL__0"] = 151] = "Supplied_parameters_do_not_match_any_signature_of_call_target__NL__0";
        DiagnosticCode[DiagnosticCode["Invalid__new__expression"] = 152] = "Invalid__new__expression";
        DiagnosticCode[DiagnosticCode["Call_signatures_used_in_a__new__expression_must_have_a__void__return_type"] = 153] = "Call_signatures_used_in_a__new__expression_must_have_a__void__return_type";
        DiagnosticCode[DiagnosticCode["Could_not_select_overload_for__new__expression"] = 154] = "Could_not_select_overload_for__new__expression";
        DiagnosticCode[DiagnosticCode["Type__0__does_not_satisfy_the_constraint__1__for_type_parameter__2_"] = 155] = "Type__0__does_not_satisfy_the_constraint__1__for_type_parameter__2_";
        DiagnosticCode[DiagnosticCode["Could_not_select_overload_for__call__expression"] = 156] = "Could_not_select_overload_for__call__expression";
        DiagnosticCode[DiagnosticCode["Unable_to_invoke_type_with_no_call_signatures"] = 157] = "Unable_to_invoke_type_with_no_call_signatures";
        DiagnosticCode[DiagnosticCode["Calls_to__super__are_only_valid_inside_a_class"] = 158] = "Calls_to__super__are_only_valid_inside_a_class";
        DiagnosticCode[DiagnosticCode["Generic_type__0__requires_1_type_argument_s_"] = 159] = "Generic_type__0__requires_1_type_argument_s_";
        DiagnosticCode[DiagnosticCode["Type_of_conditional_expression_cannot_be_determined__Best_common_type_could_not_be_found_between__0__and__1_"] = 160] = "Type_of_conditional_expression_cannot_be_determined__Best_common_type_could_not_be_found_between__0__and__1_";
        DiagnosticCode[DiagnosticCode["Type_of_array_literal_cannot_be_determined__Best_common_type_could_not_be_found_for_array_elements"] = 161] = "Type_of_array_literal_cannot_be_determined__Best_common_type_could_not_be_found_for_array_elements";
        DiagnosticCode[DiagnosticCode["Could_not_find_enclosing_symbol_for_dotted_name__0_"] = 162] = "Could_not_find_enclosing_symbol_for_dotted_name__0_";
        DiagnosticCode[DiagnosticCode["The_property__0__does_not_exist_on_value_of_type__1__"] = 163] = "The_property__0__does_not_exist_on_value_of_type__1__";
        DiagnosticCode[DiagnosticCode["Could_not_find_symbol__0_"] = 164] = "Could_not_find_symbol__0_";
        DiagnosticCode[DiagnosticCode["_get__and__set__accessor_must_have_the_same_type"] = 165] = "_get__and__set__accessor_must_have_the_same_type";
        DiagnosticCode[DiagnosticCode["_this__cannot_be_referenced_in_current_location"] = 166] = "_this__cannot_be_referenced_in_current_location";
        DiagnosticCode[DiagnosticCode["Use_of_deprecated__bool__type__Use__boolean__instead"] = 167] = "Use_of_deprecated__bool__type__Use__boolean__instead";

        DiagnosticCode[DiagnosticCode["Class__0__is_recursively_referenced_as_a_base_type_of_itself"] = 168] = "Class__0__is_recursively_referenced_as_a_base_type_of_itself";
        DiagnosticCode[DiagnosticCode["Interface__0__is_recursively_referenced_as_a_base_type_of_itself"] = 169] = "Interface__0__is_recursively_referenced_as_a_base_type_of_itself";
        DiagnosticCode[DiagnosticCode["_super__property_access_is_permitted_only_in_a_constructor__instance_member_function__or_instance_member_accessor_of_a_derived_class"] = 170] = "_super__property_access_is_permitted_only_in_a_constructor__instance_member_function__or_instance_member_accessor_of_a_derived_class";
        DiagnosticCode[DiagnosticCode["_super__cannot_be_referenced_in_non_derived_classes"] = 171] = "_super__cannot_be_referenced_in_non_derived_classes";
        DiagnosticCode[DiagnosticCode["A__super__call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_intialized_properties_or_has_parameter_properties"] = 172] = "A__super__call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_intialized_properties_or_has_parameter_properties";
        DiagnosticCode[DiagnosticCode["Constructors_for_derived_classes_must_contain_a__super__call"] = 173] = "Constructors_for_derived_classes_must_contain_a__super__call";
        DiagnosticCode[DiagnosticCode["Super_calls_are_not_permitted_outside_constructors_or_in_local_functions_inside_constructors"] = 174] = "Super_calls_are_not_permitted_outside_constructors_or_in_local_functions_inside_constructors";
        DiagnosticCode[DiagnosticCode["_0_1__is_inaccessible"] = 175] = "_0_1__is_inaccessible";
        DiagnosticCode[DiagnosticCode["_this__cannot_be_referenced_within_module_bodies"] = 176] = "_this__cannot_be_referenced_within_module_bodies";
        DiagnosticCode[DiagnosticCode["_this__must_only_be_used_inside_a_function_or_script_context"] = 177] = "_this__must_only_be_used_inside_a_function_or_script_context";
        DiagnosticCode[DiagnosticCode["Invalid__addition__expression___types_do_not_agree"] = 178] = "Invalid__addition__expression___types_do_not_agree";
        DiagnosticCode[DiagnosticCode["The_right_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type"] = 179] = "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type";
        DiagnosticCode[DiagnosticCode["The_left_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type"] = 180] = "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type";
        DiagnosticCode[DiagnosticCode["The_type_of_a_unary_arithmetic_operation_operand_must_be_of_type__any____number__or_an_enum_type"] = 181] = "The_type_of_a_unary_arithmetic_operation_operand_must_be_of_type__any____number__or_an_enum_type";
        DiagnosticCode[DiagnosticCode["Variable_declarations_for_for_in_expressions_cannot_contain_a_type_annotation"] = 182] = "Variable_declarations_for_for_in_expressions_cannot_contain_a_type_annotation";
        DiagnosticCode[DiagnosticCode["Variable_declarations_for_for_in_expressions_must_be_of_types__string__or__any_"] = 183] = "Variable_declarations_for_for_in_expressions_must_be_of_types__string__or__any_";
        DiagnosticCode[DiagnosticCode["The_right_operand_of_a_for_in_expression_must_be_of_type__any____an_object_type_or_a_type_parameter"] = 184] = "The_right_operand_of_a_for_in_expression_must_be_of_type__any____an_object_type_or_a_type_parameter";
        DiagnosticCode[DiagnosticCode["The_left_hand_side_of_an__in__expression_must_be_of_types__string__or__any_"] = 185] = "The_left_hand_side_of_an__in__expression_must_be_of_types__string__or__any_";
        DiagnosticCode[DiagnosticCode["The_right_hand_side_of_an__in__expression_must_be_of_type__any___an_object_type_or_a_type_parameter"] = 186] = "The_right_hand_side_of_an__in__expression_must_be_of_type__any___an_object_type_or_a_type_parameter";
        DiagnosticCode[DiagnosticCode["The_left_hand_side_of_an__instanceOf__expression_must_be_of_type__any___an_object_type_or_a_type_parameter"] = 187] = "The_left_hand_side_of_an__instanceOf__expression_must_be_of_type__any___an_object_type_or_a_type_parameter";
        DiagnosticCode[DiagnosticCode["The_right_hand_side_of_an__instanceOf__expression_must_be_of_type__any__or_a_subtype_of_the__Function__interface_type"] = 188] = "The_right_hand_side_of_an__instanceOf__expression_must_be_of_type__any__or_a_subtype_of_the__Function__interface_type";
        DiagnosticCode[DiagnosticCode["Setters_cannot_return_a_value"] = 189] = "Setters_cannot_return_a_value";
        DiagnosticCode[DiagnosticCode["Tried_to_set_variable_type_to_module_type__0__"] = 190] = "Tried_to_set_variable_type_to_module_type__0__";
        DiagnosticCode[DiagnosticCode["Tried_to_set_variable_type_to_uninitialized_module_type__0__"] = 191] = "Tried_to_set_variable_type_to_uninitialized_module_type__0__";
        DiagnosticCode[DiagnosticCode["Function__0__declared_a_non_void_return_type__but_has_no_return_expression"] = 192] = "Function__0__declared_a_non_void_return_type__but_has_no_return_expression";
        DiagnosticCode[DiagnosticCode["Getters_must_return_a_value"] = 193] = "Getters_must_return_a_value";
        DiagnosticCode[DiagnosticCode["Getter_and_setter_accessors_do_not_agree_in_visibility"] = 194] = "Getter_and_setter_accessors_do_not_agree_in_visibility";
        DiagnosticCode[DiagnosticCode["Invalid_left_hand_side_of_assignment_expression"] = 195] = "Invalid_left_hand_side_of_assignment_expression";
        DiagnosticCode[DiagnosticCode["Function_declared_a_non_void_return_type__but_has_no_return_expression"] = 196] = "Function_declared_a_non_void_return_type__but_has_no_return_expression";
        DiagnosticCode[DiagnosticCode["Cannot_resolve_return_type_reference"] = 197] = "Cannot_resolve_return_type_reference";
        DiagnosticCode[DiagnosticCode["Constructors_cannot_have_a_return_type_of__void_"] = 198] = "Constructors_cannot_have_a_return_type_of__void_";
        DiagnosticCode[DiagnosticCode["Subsequent_variable_declarations_must_have_the_same_type___Variable__0__must_be_of_type__1___but_here_has_type___2_"] = 199] = "Subsequent_variable_declarations_must_have_the_same_type___Variable__0__must_be_of_type__1___but_here_has_type___2_";
        DiagnosticCode[DiagnosticCode["All_symbols_within_a__with__block_will_be_resolved_to__any__"] = 200] = "All_symbols_within_a__with__block_will_be_resolved_to__any__";
        DiagnosticCode[DiagnosticCode["Import_declarations_in_an_internal_module_cannot_reference_an_external_module"] = 201] = "Import_declarations_in_an_internal_module_cannot_reference_an_external_module";
        DiagnosticCode[DiagnosticCode["Class__0__declares_interface__1__but_does_not_implement_it__NL__2"] = 202] = "Class__0__declares_interface__1__but_does_not_implement_it__NL__2";
        DiagnosticCode[DiagnosticCode["Class__0__declares_class__1__but_does_not_implement_it__NL__2"] = 203] = "Class__0__declares_class__1__but_does_not_implement_it__NL__2";
        DiagnosticCode[DiagnosticCode["The_operand_of_an_increment_or_decrement_operator_must_be_a_variable__property_or_indexer"] = 204] = "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable__property_or_indexer";
        DiagnosticCode[DiagnosticCode["_this__cannot_be_referenced_in_initializers_in_a_class_body"] = 205] = "_this__cannot_be_referenced_in_initializers_in_a_class_body";
        DiagnosticCode[DiagnosticCode["Class__0__cannot_extend_class__1__NL__2"] = 206] = "Class__0__cannot_extend_class__1__NL__2";
        DiagnosticCode[DiagnosticCode["Interface__0__cannot_extend_class__1__NL__2"] = 207] = "Interface__0__cannot_extend_class__1__NL__2";
        DiagnosticCode[DiagnosticCode["Interface__0__cannot_extend_interface__1__NL__2"] = 208] = "Interface__0__cannot_extend_interface__1__NL__2";
        DiagnosticCode[DiagnosticCode["Duplicate_overload_signature_for__0_"] = 209] = "Duplicate_overload_signature_for__0_";
        DiagnosticCode[DiagnosticCode["Duplicate_constructor_overload_signature"] = 210] = "Duplicate_constructor_overload_signature";
        DiagnosticCode[DiagnosticCode["Duplicate_overload_call_signature"] = 211] = "Duplicate_overload_call_signature";
        DiagnosticCode[DiagnosticCode["Duplicate_overload_construct_signature"] = 212] = "Duplicate_overload_construct_signature";
        DiagnosticCode[DiagnosticCode["Overload_signature_is_not_compatible_with_function_definition"] = 213] = "Overload_signature_is_not_compatible_with_function_definition";
        DiagnosticCode[DiagnosticCode["Overload_signature_is_not_compatible_with_function_definition__NL__0"] = 214] = "Overload_signature_is_not_compatible_with_function_definition__NL__0";
        DiagnosticCode[DiagnosticCode["Overload_signatures_must_all_be_public_or_private"] = 215] = "Overload_signatures_must_all_be_public_or_private";
        DiagnosticCode[DiagnosticCode["Overload_signatures_must_all_be_exported_or_local"] = 216] = "Overload_signatures_must_all_be_exported_or_local";
        DiagnosticCode[DiagnosticCode["Overload_signatures_must_all_be_ambient_or_non_ambient"] = 217] = "Overload_signatures_must_all_be_ambient_or_non_ambient";
        DiagnosticCode[DiagnosticCode["Overload_signatures_must_all_be_optional_or_required"] = 218] = "Overload_signatures_must_all_be_optional_or_required";
        DiagnosticCode[DiagnosticCode["Specialized_overload_signature_is_not_subtype_of_any_non_specialized_signature"] = 219] = "Specialized_overload_signature_is_not_subtype_of_any_non_specialized_signature";
        DiagnosticCode[DiagnosticCode["_this__cannot_be_referenced_in_constructor_arguments"] = 220] = "_this__cannot_be_referenced_in_constructor_arguments";
        DiagnosticCode[DiagnosticCode["Static_member_cannot_be_accessed_off_an_instance_variable"] = 221] = "Static_member_cannot_be_accessed_off_an_instance_variable";
        DiagnosticCode[DiagnosticCode["Instance_member_cannot_be_accessed_off_a_class"] = 222] = "Instance_member_cannot_be_accessed_off_a_class";
        DiagnosticCode[DiagnosticCode["Untyped_function_calls_may_not_accept_type_arguments"] = 223] = "Untyped_function_calls_may_not_accept_type_arguments";
        DiagnosticCode[DiagnosticCode["Non_generic_functions_may_not_accept_type_arguments"] = 224] = "Non_generic_functions_may_not_accept_type_arguments";
        DiagnosticCode[DiagnosticCode["A_generic_type_may_not_reference_itself_with_its_own_type_parameters"] = 225] = "A_generic_type_may_not_reference_itself_with_its_own_type_parameters";
        DiagnosticCode[DiagnosticCode["Static_methods_cannot_reference_class_type_parameters"] = 226] = "Static_methods_cannot_reference_class_type_parameters";
        DiagnosticCode[DiagnosticCode["Value_of_type__0__is_not_callable__Did_you_mean_to_include__new___"] = 227] = "Value_of_type__0__is_not_callable__Did_you_mean_to_include__new___";
        DiagnosticCode[DiagnosticCode["Rest_parameters_must_be_array_types"] = 228] = "Rest_parameters_must_be_array_types";
        DiagnosticCode[DiagnosticCode["Overload_signature_implementation_cannot_use_specialized_type"] = 229] = "Overload_signature_implementation_cannot_use_specialized_type";
        DiagnosticCode[DiagnosticCode["Export_assignments_may_only_be_used_in_External_modules"] = 230] = "Export_assignments_may_only_be_used_in_External_modules";
        DiagnosticCode[DiagnosticCode["Export_assignments_may_only_be_made_with_acceptable_kinds"] = 231] = "Export_assignments_may_only_be_made_with_acceptable_kinds";
        DiagnosticCode[DiagnosticCode["Only_public_instance_methods_of_the_base_class_are_accessible_via_the_super_keyword"] = 232] = "Only_public_instance_methods_of_the_base_class_are_accessible_via_the_super_keyword";
        DiagnosticCode[DiagnosticCode["Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1__"] = 233] = "Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1__";
        DiagnosticCode[DiagnosticCode["Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1____NL__2"] = 234] = "Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1____NL__2";
        DiagnosticCode[DiagnosticCode["All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0__"] = 235] = "All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0__";
        DiagnosticCode[DiagnosticCode["All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0____NL__1"] = 236] = "All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0____NL__1";
        DiagnosticCode[DiagnosticCode["All_named_properties_must_be_subtypes_of_string_indexer_type___0__"] = 237] = "All_named_properties_must_be_subtypes_of_string_indexer_type___0__";
        DiagnosticCode[DiagnosticCode["All_named_properties_must_be_subtypes_of_string_indexer_type___0____NL__1"] = 238] = "All_named_properties_must_be_subtypes_of_string_indexer_type___0____NL__1";
        DiagnosticCode[DiagnosticCode["Generic_type_references_must_include_all_type_arguments"] = 239] = "Generic_type_references_must_include_all_type_arguments";

        DiagnosticCode[DiagnosticCode["Type__0__is_missing_property__1__from_type__2_"] = 240] = "Type__0__is_missing_property__1__from_type__2_";
        DiagnosticCode[DiagnosticCode["Types_of_property__0__of_types__1__and__2__are_incompatible"] = 241] = "Types_of_property__0__of_types__1__and__2__are_incompatible";
        DiagnosticCode[DiagnosticCode["Types_of_property__0__of_types__1__and__2__are_incompatible__NL__3"] = 242] = "Types_of_property__0__of_types__1__and__2__are_incompatible__NL__3";
        DiagnosticCode[DiagnosticCode["Property__0__defined_as_private_in_type__1__is_defined_as_public_in_type__2_"] = 243] = "Property__0__defined_as_private_in_type__1__is_defined_as_public_in_type__2_";
        DiagnosticCode[DiagnosticCode["Property__0__defined_as_public_in_type__1__is_defined_as_private_in_type__2_"] = 244] = "Property__0__defined_as_public_in_type__1__is_defined_as_private_in_type__2_";
        DiagnosticCode[DiagnosticCode["Types__0__and__1__define_property__2__as_private"] = 245] = "Types__0__and__1__define_property__2__as_private";
        DiagnosticCode[DiagnosticCode["Call_signatures_of_types__0__and__1__are_incompatible"] = 246] = "Call_signatures_of_types__0__and__1__are_incompatible";
        DiagnosticCode[DiagnosticCode["Call_signatures_of_types__0__and__1__are_incompatible__NL__2"] = 247] = "Call_signatures_of_types__0__and__1__are_incompatible__NL__2";
        DiagnosticCode[DiagnosticCode["Type__0__requires_a_call_signature__but_Type__1__lacks_one"] = 248] = "Type__0__requires_a_call_signature__but_Type__1__lacks_one";
        DiagnosticCode[DiagnosticCode["Construct_signatures_of_types__0__and__1__are_incompatible"] = 249] = "Construct_signatures_of_types__0__and__1__are_incompatible";
        DiagnosticCode[DiagnosticCode["Construct_signatures_of_types__0__and__1__are_incompatible__NL__2"] = 250] = "Construct_signatures_of_types__0__and__1__are_incompatible__NL__2";
        DiagnosticCode[DiagnosticCode["Type__0__requires_a_construct_signature__but_Type__1__lacks_one"] = 251] = "Type__0__requires_a_construct_signature__but_Type__1__lacks_one";
        DiagnosticCode[DiagnosticCode["Index_signatures_of_types__0__and__1__are_incompatible"] = 252] = "Index_signatures_of_types__0__and__1__are_incompatible";
        DiagnosticCode[DiagnosticCode["Index_signatures_of_types__0__and__1__are_incompatible__NL__2"] = 253] = "Index_signatures_of_types__0__and__1__are_incompatible__NL__2";
        DiagnosticCode[DiagnosticCode["Call_signature_expects__0__or_fewer_parameters"] = 254] = "Call_signature_expects__0__or_fewer_parameters";
        DiagnosticCode[DiagnosticCode["Could_not_apply_type__0__to_argument__1__which_is_of_type__2_"] = 255] = "Could_not_apply_type__0__to_argument__1__which_is_of_type__2_";
        DiagnosticCode[DiagnosticCode["Class__0__defines_instance_member_accessor__1___but_extended_class__2__defines_it_as_instance_member_function"] = 256] = "Class__0__defines_instance_member_accessor__1___but_extended_class__2__defines_it_as_instance_member_function";
        DiagnosticCode[DiagnosticCode["Class__0__defines_instance_member_property__1___but_extended_class__2__defines_it_as_instance_member_function"] = 257] = "Class__0__defines_instance_member_property__1___but_extended_class__2__defines_it_as_instance_member_function";
        DiagnosticCode[DiagnosticCode["Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_accessor"] = 258] = "Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_accessor";
        DiagnosticCode[DiagnosticCode["Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_property"] = 259] = "Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_property";
        DiagnosticCode[DiagnosticCode["Types_of_static_property__0__of_class__1__and_class__2__are_incompatible"] = 260] = "Types_of_static_property__0__of_class__1__and_class__2__are_incompatible";
        DiagnosticCode[DiagnosticCode["Types_of_static_property__0__of_class__1__and_class__2__are_incompatible__NL__3"] = 261] = "Types_of_static_property__0__of_class__1__and_class__2__are_incompatible__NL__3";
        DiagnosticCode[DiagnosticCode["Type_reference_cannot_refer_to_container__0_"] = 262] = "Type_reference_cannot_refer_to_container__0_";
        DiagnosticCode[DiagnosticCode["Type_reference_must_refer_to_type"] = 263] = "Type_reference_must_refer_to_type";
        DiagnosticCode[DiagnosticCode["Enums_with_multiple_declarations_must_provide_an_initializer_for_the_first_enum_element"] = 264] = "Enums_with_multiple_declarations_must_provide_an_initializer_for_the_first_enum_element";

        DiagnosticCode[DiagnosticCode["Current_host_does_not_support__w_atch_option"] = 265] = "Current_host_does_not_support__w_atch_option";
        DiagnosticCode[DiagnosticCode["ECMAScript_target_version__0__not_supported___Using_default__1__code_generation"] = 266] = "ECMAScript_target_version__0__not_supported___Using_default__1__code_generation";
        DiagnosticCode[DiagnosticCode["Module_code_generation__0__not_supported___Using_default__1__code_generation"] = 267] = "Module_code_generation__0__not_supported___Using_default__1__code_generation";
        DiagnosticCode[DiagnosticCode["Could_not_find_file___0_"] = 268] = "Could_not_find_file___0_";
        DiagnosticCode[DiagnosticCode["Unknown_extension_for_file___0__Only__ts_and_d_ts_extensions_are_allowed"] = 269] = "Unknown_extension_for_file___0__Only__ts_and_d_ts_extensions_are_allowed";
        DiagnosticCode[DiagnosticCode["A_file_cannot_have_a_reference_itself"] = 270] = "A_file_cannot_have_a_reference_itself";
        DiagnosticCode[DiagnosticCode["Cannot_resolve_referenced_file___0_"] = 271] = "Cannot_resolve_referenced_file___0_";
        DiagnosticCode[DiagnosticCode["Cannot_resolve_imported_file___0_"] = 272] = "Cannot_resolve_imported_file___0_";
        DiagnosticCode[DiagnosticCode["Cannot_find_the_common_subdirectory_path_for_the_input_files"] = 273] = "Cannot_find_the_common_subdirectory_path_for_the_input_files";
        DiagnosticCode[DiagnosticCode["Cannot_compile_dynamic_modules_when_emitting_into_single_file"] = 274] = "Cannot_compile_dynamic_modules_when_emitting_into_single_file";
        DiagnosticCode[DiagnosticCode["Emit_Error__0"] = 275] = "Emit_Error__0";
        DiagnosticCode[DiagnosticCode["Unsupported_encoding_for_file__0"] = 276] = "Unsupported_encoding_for_file__0";
    })(TypeScript.DiagnosticCode || (TypeScript.DiagnosticCode = {}));
    var DiagnosticCode = TypeScript.DiagnosticCode;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    TypeScript.diagnosticMessages = {
        error_TS_0__1: {
            category: 3 /* NoPrefix */,
            message: "error TS{0}: {1}",
            code: 0
        },
        warning_TS_0__1: {
            category: 3 /* NoPrefix */,
            message: "warning TS{0}: {1}",
            code: 1
        },
        _0__NL__1_TB__2: {
            category: 3 /* NoPrefix */,
            message: "{0}{NL}{{1}TB}{2}",
            code: 21
        },
        _0_TB__1: {
            category: 3 /* NoPrefix */,
            message: "{{0}TB}{1}",
            code: 22
        },
        Unrecognized_escape_sequence: {
            category: 1 /* Error */,
            message: "Unrecognized escape sequence.",
            code: 1000
        },
        Unexpected_character_0: {
            category: 1 /* Error */,
            message: "Unexpected character {0}.",
            code: 1001
        },
        Missing_closing_quote_character: {
            category: 1 /* Error */,
            message: "Missing close quote character.",
            code: 1002
        },
        Identifier_expected: {
            category: 1 /* Error */,
            message: "Identifier expected.",
            code: 1003
        },
        _0_keyword_expected: {
            category: 1 /* Error */,
            message: "'{0}' keyword expected.",
            code: 1004
        },
        _0_expected: {
            category: 1 /* Error */,
            message: "'{0}' expected.",
            code: 1005
        },
        Identifier_expected__0__is_a_keyword: {
            category: 1 /* Error */,
            message: "Identifier expected; '{0}' is a keyword.",
            code: 1006
        },
        Automatic_semicolon_insertion_not_allowed: {
            category: 1 /* Error */,
            message: "Automatic semicolon insertion not allowed.",
            code: 1007
        },
        Unexpected_token__0_expected: {
            category: 1 /* Error */,
            message: "Unexpected token; '{0}' expected.",
            code: 1008
        },
        Trailing_separator_not_allowed: {
            category: 1 /* Error */,
            message: "Trailing separator not allowed.",
            code: 1009
        },
        _StarSlash__expected: {
            category: 1 /* Error */,
            message: "'*/' expected.",
            code: 1010
        },
        _public_or_private_modifier_must_precede__static_: {
            category: 1 /* Error */,
            message: "'public' or 'private' modifier must precede 'static'.",
            code: 1011
        },
        Unexpected_token_: {
            category: 1 /* Error */,
            message: "Unexpected token.",
            code: 1012
        },
        A_catch_clause_variable_cannot_have_a_type_annotation: {
            category: 1 /* Error */,
            message: "A catch clause variable cannot have a type annotation.",
            code: 1013
        },
        Rest_parameter_must_be_last_in_list: {
            category: 1 /* Error */,
            message: "Rest parameter must be last in list.",
            code: 1014
        },
        Parameter_cannot_have_question_mark_and_initializer: {
            category: 1 /* Error */,
            message: "Parameter cannot have question mark and initializer.",
            code: 1015
        },
        Required_parameter_cannot_follow_optional_parameter: {
            category: 1 /* Error */,
            message: "Required parameter cannot follow optional parameter.",
            code: 1016
        },
        Index_signatures_cannot_have_rest_parameters: {
            category: 1 /* Error */,
            message: "Index signatures cannot have rest parameters.",
            code: 1017
        },
        Index_signature_parameter_cannot_have_accessibility_modifiers: {
            category: 1 /* Error */,
            message: "Index signature parameter cannot have accessibility modifiers.",
            code: 1018
        },
        Index_signature_parameter_cannot_have_a_question_mark: {
            category: 1 /* Error */,
            message: "Index signature parameter cannot have a question mark.",
            code: 1019
        },
        Index_signature_parameter_cannot_have_an_initializer: {
            category: 1 /* Error */,
            message: "Index signature parameter cannot have an initializer.",
            code: 1020
        },
        Index_signature_must_have_a_type_annotation: {
            category: 1 /* Error */,
            message: "Index signature must have a type annotation.",
            code: 1021
        },
        Index_signature_parameter_must_have_a_type_annotation: {
            category: 1 /* Error */,
            message: "Index signature parameter must have a type annotation.",
            code: 1022
        },
        Index_signature_parameter_type_must_be__string__or__number_: {
            category: 1 /* Error */,
            message: "Index signature parameter type must be 'string' or 'number'.",
            code: 1023
        },
        _extends__clause_already_seen: {
            category: 1 /* Error */,
            message: "'extends' clause already seen.",
            code: 1024
        },
        _extends__clause_must_precede__implements__clause: {
            category: 1 /* Error */,
            message: "'extends' clause must precede 'implements' clause.",
            code: 1025
        },
        Class_can_only_extend_single_type: {
            category: 1 /* Error */,
            message: "Class can only extend single type.",
            code: 1026
        },
        _implements__clause_already_seen: {
            category: 1 /* Error */,
            message: "'implements' clause already seen.",
            code: 1027
        },
        Accessibility_modifier_already_seen: {
            category: 1 /* Error */,
            message: "Accessibility modifier already seen.",
            code: 1028
        },
        _0__modifier_must_precede__1__modifier: {
            category: 1 /* Error */,
            message: "'{0}' modifier must precede '{1}' modifier.",
            code: 1029
        },
        _0__modifier_already_seen: {
            category: 1 /* Error */,
            message: "'{0}' modifier already seen.",
            code: 1030
        },
        _0__modifier_cannot_appear_on_a_class_element: {
            category: 1 /* Error */,
            message: "'{0}' modifier cannot appear on a class element.",
            code: 1031
        },
        Interface_declaration_cannot_have__implements__clause: {
            category: 1 /* Error */,
            message: "Interface declaration cannot have 'implements' clause.",
            code: 1032
        },
        _super__invocation_cannot_have_type_arguments: {
            category: 1 /* Error */,
            message: "'super' invocation cannot have type arguments.",
            code: 1034
        },
        Non_ambient_modules_cannot_use_quoted_names: {
            category: 1 /* Error */,
            message: "Non ambient modules cannot use quoted names.",
            code: 1035
        },
        Statements_are_not_allowed_in_ambient_contexts: {
            category: 1 /* Error */,
            message: "Statements are not allowed in ambient contexts.",
            code: 1036
        },
        Implementations_are_not_allowed_in_ambient_contexts: {
            category: 1 /* Error */,
            message: "Implementations are not allowed in ambient contexts.",
            code: 1037
        },
        _declare__modifier_not_allowed_for_code_already_in_an_ambient_context: {
            category: 1 /* Error */,
            message: "'declare' modifier not allowed for code already in an ambient context.",
            code: 1038
        },
        Initializers_are_not_allowed_in_ambient_contexts: {
            category: 1 /* Error */,
            message: "Initializers are not allowed in ambient contexts.",
            code: 1039
        },
        Overload_and_ambient_signatures_cannot_specify_parameter_properties: {
            category: 1 /* Error */,
            message: "Overload and ambient signatures cannot specify parameter properties.",
            code: 1040
        },
        Function_implementation_expected: {
            category: 1 /* Error */,
            message: "Function implementation expected.",
            code: 1041
        },
        Constructor_implementation_expected: {
            category: 1 /* Error */,
            message: "Constructor implementation expected.",
            code: 1042
        },
        Function_overload_name_must_be__0_: {
            category: 1 /* Error */,
            message: "Function overload name must be '{0}'.",
            code: 1043
        },
        _0__modifier_cannot_appear_on_a_module_element: {
            category: 1 /* Error */,
            message: "'{0}' modifier cannot appear on a module element.",
            code: 1044
        },
        _declare__modifier_cannot_appear_on_an_interface_declaration: {
            category: 1 /* Error */,
            message: "'declare' modifier cannot appear on an interface declaration.",
            code: 1045
        },
        _declare__modifier_required_for_top_level_element: {
            category: 1 /* Error */,
            message: "'declare' modifier required for top level element.",
            code: 1046
        },
        Rest_parameter_cannot_be_optional: {
            category: 1 /* Error */,
            message: "Rest parameter cannot be optional.",
            code: 1047
        },
        Rest_parameter_cannot_have_initializer: {
            category: 1 /* Error */,
            message: "Rest parameter cannot have initializer.",
            code: 1048
        },
        _set__accessor_must_have_only_one_parameter: {
            category: 1 /* Error */,
            message: "'set' accessor must have one and only one parameter.",
            code: 1049
        },
        _set__accessor_parameter_cannot_have_accessibility_modifier: {
            category: 1 /* Error */,
            message: "'set' accessor parameter cannot have accessibility modifier.",
            code: 1050
        },
        _set__accessor_parameter_cannot_be_optional: {
            category: 1 /* Error */,
            message: "'set' accessor parameter cannot be optional.",
            code: 1051
        },
        _set__accessor_parameter_cannot_have_initializer: {
            category: 1 /* Error */,
            message: "'set' accessor parameter cannot have initializer.",
            code: 1052
        },
        _set__accessor_cannot_have_rest_parameter: {
            category: 1 /* Error */,
            message: "'set' accessor cannot have rest parameter.",
            code: 1053
        },
        _get__accessor_cannot_have_parameters: {
            category: 1 /* Error */,
            message: "'get' accessor cannot have parameters.",
            code: 1054
        },
        Modifiers_cannot_appear_here: {
            category: 1 /* Error */,
            message: "Modifiers cannot appear here.",
            code: 1055
        },
        Accessors_are_only_available_when_targeting_EcmaScript5_and_higher: {
            category: 1 /* Error */,
            message: "Accessors are only when targeting EcmaScript5 and higher.",
            code: 1056
        },
        Class_name_cannot_be__0_: {
            category: 1 /* Error */,
            message: "Class name cannot be '{0}'.",
            code: 1057
        },
        Interface_name_cannot_be__0_: {
            category: 1 /* Error */,
            message: "Interface name cannot be '{0}'.",
            code: 1058
        },
        Enum_name_cannot_be__0_: {
            category: 1 /* Error */,
            message: "Enum name cannot be '{0}'.",
            code: 1059
        },
        Module_name_cannot_be__0_: {
            category: 1 /* Error */,
            message: "Module name cannot be '{0}'.",
            code: 1060
        },
        Enum_member_must_have_initializer: {
            category: 1 /* Error */,
            message: "Enum member must have initializer.",
            code: 1061
        },
        _module_______is_deprecated__Use__require_______instead: {
            category: 0 /* Warning */,
            message: "'module(...)' is deprecated. Use 'require(...)' instead.",
            code: 1062
        },
        Export_assignments_cannot_be_used_in_internal_modules: {
            category: 1 /* Error */,
            message: "Export assignments cannot be used in internal modules.",
            code: 1063
        },
        Export_assignment_not_allowed_in_module_with_exported_element: {
            category: 1 /* Error */,
            message: "Export assignment not allowed in module with exported element.",
            code: 1064
        },
        Module_cannot_have_multiple_export_assignments: {
            category: 1 /* Error */,
            message: "Module cannot have multiple export assignments.",
            code: 1065
        },
        Duplicate_identifier__0_: {
            category: 1 /* Error */,
            message: "Duplicate identifier '{0}'.",
            code: 2000
        },
        The_name__0__does_not_exist_in_the_current_scope: {
            category: 1 /* Error */,
            message: "The name '{0}' does not exist in the current scope.",
            code: 2001
        },
        The_name__0__does_not_refer_to_a_value: {
            category: 1 /* Error */,
            message: "The name '{0}' does not refer to a value.",
            code: 2002
        },
        Keyword__super__can_only_be_used_inside_a_class_instance_method: {
            category: 1 /* Error */,
            message: "Keyword 'super' can only be used inside a class instance method.",
            code: 2003
        },
        The_left_hand_side_of_an_assignment_expression_must_be_a_variable__property_or_indexer: {
            category: 1 /* Error */,
            message: "The left-hand side of an assignment expression must be a variable, property or indexer.",
            code: 2004
        },
        Value_of_type__0__is_not_callable__Did_you_mean_to_include__new__: {
            category: 1 /* Error */,
            message: "Value of type '{0}' is not callable. Did you mean to include 'new'?",
            code: 2005
        },
        Value_of_type__0__is_not_callable: {
            category: 1 /* Error */,
            message: "Value of type '{0}' is not callable.",
            code: 2006
        },
        Value_of_type__0__is_not_newable: {
            category: 1 /* Error */,
            message: "Value of type '{0}' is not newable.",
            code: 2007
        },
        Value_of_type__0__is_not_indexable_by_type__1_: {
            category: 1 /* Error */,
            message: "Value of type '{0}' is not indexable by type '{1}'.",
            code: 2008
        },
        Operator__0__cannot_be_applied_to_types__1__and__2_: {
            category: 1 /* Error */,
            message: "Operator '{0}' cannot be applied to types '{1}' and '{2}'.",
            code: 2009
        },
        Operator__0__cannot_be_applied_to_types__1__and__2__3: {
            category: 1 /* Error */,
            message: "Operator '{0}' cannot be applied to types '{1}' and '{2}': {3}",
            code: 2010
        },
        Cannot_convert__0__to__1_: {
            category: 1 /* Error */,
            message: "Cannot convert '{0}' to '{1}'.",
            code: 2011
        },
        Cannot_convert__0__to__1__NL__2: {
            category: 1 /* Error */,
            message: "Cannot convert '{0}' to '{1}':{NL}{2}",
            code: 2012
        },
        Expected_var__class__interface__or_module: {
            category: 1 /* Error */,
            message: "Expected var, class, interface, or module.",
            code: 2013
        },
        Operator__0__cannot_be_applied_to_type__1_: {
            category: 1 /* Error */,
            message: "Operator '{0}' cannot be applied to type '{1}'.",
            code: 2014
        },
        Getter__0__already_declared: {
            category: 1 /* Error */,
            message: "Getter '{0}' already declared.",
            code: 2015
        },
        Setter__0__already_declared: {
            category: 1 /* Error */,
            message: "Setter '{0}' already declared.",
            code: 2016
        },
        Accessor_cannot_have_type_parameters: {
            category: 1 /* Error */,
            message: "Accessors cannot have type parameters.",
            code: 2017
        },
        Exported_class__0__extends_private_class__1_: {
            category: 1 /* Error */,
            message: "Exported class '{0}' extends private class '{1}'.",
            code: 2018
        },
        Exported_class__0__implements_private_interface__1_: {
            category: 1 /* Error */,
            message: "Exported class '{0}' implements private interface '{1}'.",
            code: 2019
        },
        Exported_interface__0__extends_private_interface__1_: {
            category: 1 /* Error */,
            message: "Exported interface '{0}' extends private interface '{1}'.",
            code: 2020
        },
        Exported_class__0__extends_class_from_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Exported class '{0}' extends class from inaccessible module {1}.",
            code: 2021
        },
        Exported_class__0__implements_interface_from_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Exported class '{0}' implements interface from inaccessible module {1}.",
            code: 2022
        },
        Exported_interface__0__extends_interface_from_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Exported interface '{0}' extends interface from inaccessible module {1}.",
            code: 2023
        },
        Public_static_property__0__of__exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Public static property '{0}' of exported class has or is using private type '{1}'.",
            code: 2024
        },
        Public_property__0__of__exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Public property '{0}' of exported class has or is using private type '{1}'.",
            code: 2025
        },
        Property__0__of__exported_interface_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Property '{0}' of exported interface has or is using private type '{1}'.",
            code: 2026
        },
        Exported_variable__0__has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Exported variable '{0}' has or is using private type '{1}'.",
            code: 2027
        },
        Public_static_property__0__of__exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Public static property '{0}' of exported class is using inaccessible module {1}.",
            code: 2028
        },
        Public_property__0__of__exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Public property '{0}' of exported class is using inaccessible module {1}.",
            code: 2029
        },
        Property__0__of__exported_interface_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Property '{0}' of exported interface is using inaccessible module {1}.",
            code: 2030
        },
        Exported_variable__0__is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Exported variable '{0}' is using inaccessible module {1}.",
            code: 2031
        },
        Parameter__0__of_constructor_from_exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of constructor from exported class has or is using private type '{1}'.",
            code: 2032
        },
        Parameter__0__of_public_static_property_setter_from_exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public static property setter from exported class has or is using private type '{1}'.",
            code: 2033
        },
        Parameter__0__of_public_property_setter_from_exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public property setter from exported class has or is using private type '{1}'.",
            code: 2034
        },
        Parameter__0__of_constructor_signature_from_exported_interface_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of constructor signature from exported interface has or is using private type '{1}'.",
            code: 2035
        },
        Parameter__0__of_call_signature_from_exported_interface_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of call signature from exported interface has or is using private type '{1}'.",
            code: 2036
        },
        Parameter__0__of_public_static_method_from_exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public static method from exported class has or is using private type '{1}'.",
            code: 2037
        },
        Parameter__0__of_public_method_from_exported_class_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public method from exported class has or is using private type '{1}'.",
            code: 2038
        },
        Parameter__0__of_method_from_exported_interface_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of method from exported interface has or is using private type '{1}'.",
            code: 2039
        },
        Parameter__0__of_exported_function_has_or_is_using_private_type__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of exported function has or is using private type '{1}'.",
            code: 2040
        },
        Parameter__0__of_constructor_from_exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of constructor from exported class is using inaccessible module {1}.",
            code: 2041
        },
        Parameter__0__of_public_static_property_setter_from_exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public static property setter from exported class is using inaccessible module {1}.",
            code: 2042
        },
        Parameter__0__of_public_property_setter_from_exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public property setter from exported class is using inaccessible module {1}.",
            code: 2043
        },
        Parameter__0__of_constructor_signature_from_exported_interface_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of constructor signature from exported interface is using inaccessible module {1}.",
            code: 2044
        },
        Parameter__0__of_call_signature_from_exported_interface_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of call signature from exported interface is using inaccessible module {1}",
            code: 2045
        },
        Parameter__0__of_public_static_method_from_exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public static method from exported class is using inaccessible module {1}.",
            code: 2046
        },
        Parameter__0__of_public_method_from_exported_class_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of public method from exported class is using inaccessible module {1}.",
            code: 2047
        },
        Parameter__0__of_method_from_exported_interface_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of method from exported interface is using inaccessible module {1}.",
            code: 2048
        },
        Parameter__0__of_exported_function_is_using_inaccessible_module__1_: {
            category: 1 /* Error */,
            message: "Parameter '{0}' of exported function is using inaccessible module {1}.",
            code: 2049
        },
        Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of public static property getter from exported class has or is using private type '{0}'.",
            code: 2050
        },
        Return_type_of_public_property_getter_from_exported_class_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of public property getter from exported class has or is using private type '{0}'.",
            code: 2051
        },
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of constructor signature from exported interface has or is using private type '{0}'.",
            code: 2052
        },
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of call signature from exported interface has or is using private type '{0}'.",
            code: 2053
        },
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of index signature from exported interface has or is using private type '{0}'.",
            code: 2054
        },
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of public static method from exported class has or is using private type '{0}'.",
            code: 2055
        },
        Return_type_of_public_method_from_exported_class_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of public method from exported class has or is using private type '{0}'.",
            code: 2056
        },
        Return_type_of_method_from_exported_interface_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of method from exported interface has or is using private type '{0}'.",
            code: 2057
        },
        Return_type_of_exported_function_has_or_is_using_private_type__0_: {
            category: 1 /* Error */,
            message: "Return type of exported function has or is using private type '{0}'.",
            code: 2058
        },
        Return_type_of_public_static_property_getter_from_exported_class_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of public static property getter from exported class is using inaccessible module {0}.",
            code: 2059
        },
        Return_type_of_public_property_getter_from_exported_class_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of public property getter from exported class is using inaccessible module {0}.",
            code: 2060
        },
        Return_type_of_constructor_signature_from_exported_interface_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of constructor signature from exported interface is using inaccessible module {0}.",
            code: 2061
        },
        Return_type_of_call_signature_from_exported_interface_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of call signature from exported interface is using inaccessible module {0}.",
            code: 2062
        },
        Return_type_of_index_signature_from_exported_interface_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of index signature from exported interface is using inaccessible module {0}.",
            code: 2063
        },
        Return_type_of_public_static_method_from_exported_class_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of public static method from exported class is using inaccessible module {0}.",
            code: 2064
        },
        Return_type_of_public_method_from_exported_class_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of public method from exported class is using inaccessible module {0}.",
            code: 2065
        },
        Return_type_of_method_from_exported_interface_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of method from exported interface is using inaccessible module {0}.",
            code: 2066
        },
        Return_type_of_exported_function_is_using_inaccessible_module__0_: {
            category: 1 /* Error */,
            message: "Return type of exported function is using inaccessible module {0}.",
            code: 2067
        },
        _new_T____cannot_be_used_to_create_an_array__Use__new_Array_T_____instead: {
            category: 1 /* Error */,
            message: "'new T[]' cannot be used to create an array. Use 'new Array<T>()' instead.",
            code: 2068
        },
        A_parameter_list_must_follow_a_generic_type_argument_list______expected: {
            category: 1 /* Error */,
            message: "A parameter list must follow a generic type argument list. '(' expected.",
            code: 2069
        },
        Multiple_constructor_implementations_are_not_allowed: {
            category: 1 /* Error */,
            message: "Multiple constructor implementations are not allowed.",
            code: 2070
        },
        Unable_to_resolve_external_module__0_: {
            category: 1 /* Error */,
            message: "Unable to resolve external module '{0}'.",
            code: 2071
        },
        Module_cannot_be_aliased_to_a_non_module_type: {
            category: 1 /* Error */,
            message: "Module cannot be aliased to a non-module type.",
            code: 2072
        },
        A_class_may_only_extend_another_class: {
            category: 1 /* Error */,
            message: "A class may only extend another class.",
            code: 2073
        },
        A_class_may_only_implement_another_class_or_interface: {
            category: 1 /* Error */,
            message: "A class may only implement another class or interface.",
            code: 2074
        },
        An_interface_may_only_extend_another_class_or_interface: {
            category: 1 /* Error */,
            message: "An interface may only extend another class or interface.",
            code: 2075
        },
        An_interface_cannot_implement_another_type: {
            category: 1 /* Error */,
            message: "An interface cannot implement another type.",
            code: 2076
        },
        Unable_to_resolve_type: {
            category: 1 /* Error */,
            message: "Unable to resolve type.",
            code: 2077
        },
        Unable_to_resolve_type_of__0_: {
            category: 1 /* Error */,
            message: "Unable to resolve type of '{0}'.",
            code: 2078
        },
        Unable_to_resolve_type_parameter_constraint: {
            category: 1 /* Error */,
            message: "Unable to resolve type parameter constraint.",
            code: 2079
        },
        Type_parameter_constraint_cannot_be_a_primitive_type: {
            category: 1 /* Error */,
            message: "Type parameter constraint cannot be a primitive type.",
            code: 2080
        },
        Supplied_parameters_do_not_match_any_signature_of_call_target: {
            category: 1 /* Error */,
            message: "Supplied parameters do not match any signature of call target.",
            code: 2081
        },
        Supplied_parameters_do_not_match_any_signature_of_call_target__NL__0: {
            category: 1 /* Error */,
            message: "Supplied parameters do not match any signature of call target:{NL}{0}",
            code: 2082
        },
        Invalid__new__expression: {
            category: 1 /* Error */,
            message: "Invalid 'new' expression.",
            code: 2083
        },
        Call_signatures_used_in_a__new__expression_must_have_a__void__return_type: {
            category: 1 /* Error */,
            message: "Call signatures used in a 'new' expression must have a 'void' return type.",
            code: 2084
        },
        Could_not_select_overload_for__new__expression: {
            category: 1 /* Error */,
            message: "Could not select overload for 'new' expression.",
            code: 2085
        },
        Type__0__does_not_satisfy_the_constraint__1__for_type_parameter__2_: {
            category: 1 /* Error */,
            message: "Type '{0}' does not satisfy the constraint '{1}' for type parameter '{2}'.",
            code: 2086
        },
        Could_not_select_overload_for__call__expression: {
            category: 1 /* Error */,
            message: "Could not select overload for 'call' expression.",
            code: 2087
        },
        Unable_to_invoke_type_with_no_call_signatures: {
            category: 1 /* Error */,
            message: "Unable to invoke type with no call signatures.",
            code: 2088
        },
        Calls_to__super__are_only_valid_inside_a_class: {
            category: 1 /* Error */,
            message: "Calls to 'super' are only valid inside a class.",
            code: 2089
        },
        Generic_type__0__requires_1_type_argument_s_: {
            category: 1 /* Error */,
            message: "Generic type '{0}' requires {1} type argument(s).",
            code: 2090
        },
        Type_of_conditional_expression_cannot_be_determined__Best_common_type_could_not_be_found_between__0__and__1_: {
            category: 1 /* Error */,
            message: "Type of conditional expression cannot be determined. Best common type could not be found between '{0}' and '{1}'.",
            code: 2091
        },
        Type_of_array_literal_cannot_be_determined__Best_common_type_could_not_be_found_for_array_elements: {
            category: 1 /* Error */,
            message: "Type of array literal cannot be determined. Best common type could not be found for array elements.",
            code: 2092
        },
        Could_not_find_enclosing_symbol_for_dotted_name__0_: {
            category: 1 /* Error */,
            message: "Could not find enclosing symbol for dotted name '{0}'.",
            code: 2093
        },
        The_property__0__does_not_exist_on_value_of_type__1__: {
            category: 1 /* Error */,
            message: "The property '{0}' does not exist on value of type '{1}'.",
            code: 2094
        },
        Could_not_find_symbol__0_: {
            category: 1 /* Error */,
            message: "Could not find symbol '{0}'.",
            code: 2095
        },
        _get__and__set__accessor_must_have_the_same_type: {
            category: 1 /* Error */,
            message: "'get' and 'set' accessor must have the same type.",
            code: 2096
        },
        _this__cannot_be_referenced_in_current_location: {
            category: 1 /* Error */,
            message: "'this' cannot be referenced in current location.",
            code: 2097
        },
        Use_of_deprecated__bool__type__Use__boolean__instead: {
            category: 0 /* Warning */,
            message: "Use of deprecated type 'bool'. Use 'boolean' instead.",
            code: 2098
        },
        Static_methods_cannot_reference_class_type_parameters: {
            category: 1 /* Error */,
            message: "Static methods cannot reference class type parameters.",
            code: 2099
        },
        Class__0__is_recursively_referenced_as_a_base_type_of_itself: {
            category: 1 /* Error */,
            message: "Class '{0}' is recursively referenced as a base type of itself.",
            code: 2100
        },
        Interface__0__is_recursively_referenced_as_a_base_type_of_itself: {
            category: 1 /* Error */,
            message: "Interface '{0}' is recursively referenced as a base type of itself.",
            code: 2101
        },
        _super__property_access_is_permitted_only_in_a_constructor__instance_member_function__or_instance_member_accessor_of_a_derived_class: {
            category: 1 /* Error */,
            message: "'super' property access is permitted only in a constructor, instance member function, or instance member accessor of a derived class.",
            code: 2102
        },
        _super__cannot_be_referenced_in_non_derived_classes: {
            category: 1 /* Error */,
            message: "'super' cannot be referenced in non-derived classes.",
            code: 2103
        },
        A__super__call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_intialized_properties_or_has_parameter_properties: {
            category: 1 /* Error */,
            message: "A 'super' call must be the first statement in the constructor when a class contains initialized properties or has parameter properties.",
            code: 2104
        },
        Constructors_for_derived_classes_must_contain_a__super__call: {
            category: 1 /* Error */,
            message: "Constructors for derived classes must contain a 'super' call.",
            code: 2105
        },
        Super_calls_are_not_permitted_outside_constructors_or_in_local_functions_inside_constructors: {
            category: 1 /* Error */,
            message: "Super calls are not permitted outside constructors or in local functions inside constructors.",
            code: 2106
        },
        _0_1__is_inaccessible: {
            category: 1 /* Error */,
            message: "'{0}.{1}' is inaccessible.",
            code: 2107
        },
        _this__cannot_be_referenced_within_module_bodies: {
            category: 1 /* Error */,
            message: "'this' cannot be referenced within module bodies.",
            code: 2108
        },
        _this__must_only_be_used_inside_a_function_or_script_context: {
            category: 1 /* Error */,
            message: "'this' must only be used inside a function or script context.",
            code: 2109
        },
        Invalid__addition__expression___types_do_not_agree: {
            category: 1 /* Error */,
            message: "Invalid '+' expression - types not known to support the addition operator.",
            code: 2111
        },
        The_right_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type: {
            category: 1 /* Error */,
            message: "The right-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.",
            code: 2112
        },
        The_left_hand_side_of_an_arithmetic_operation_must_be_of_type__any____number__or_an_enum_type: {
            category: 1 /* Error */,
            message: "The left-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.",
            code: 2113
        },
        The_type_of_a_unary_arithmetic_operation_operand_must_be_of_type__any____number__or_an_enum_type: {
            category: 1 /* Error */,
            message: "The type of a unary arithmetic operation operand must be of type 'any', 'number' or an enum type.",
            code: 2114
        },
        Variable_declarations_for_for_in_expressions_cannot_contain_a_type_annotation: {
            category: 1 /* Error */,
            message: "Variable declarations for for/in expressions cannot contain a type annotation.",
            code: 2115
        },
        Variable_declarations_for_for_in_expressions_must_be_of_types__string__or__any_: {
            category: 1 /* Error */,
            message: "Variable declarations for for/in expressions must be of types 'string' or 'any'.",
            code: 2116
        },
        The_right_operand_of_a_for_in_expression_must_be_of_type__any____an_object_type_or_a_type_parameter: {
            category: 1 /* Error */,
            message: "The right operand of a for/in expression must be of type 'any', an object type or a type parameter.",
            code: 2117
        },
        The_left_hand_side_of_an__in__expression_must_be_of_types__string__or__any_: {
            category: 1 /* Error */,
            message: "The left-hand side of an 'in' expression must be of types 'string' or 'any'.",
            code: 2118
        },
        The_right_hand_side_of_an__in__expression_must_be_of_type__any___an_object_type_or_a_type_parameter: {
            category: 1 /* Error */,
            message: "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter.",
            code: 2119
        },
        The_left_hand_side_of_an__instanceOf__expression_must_be_of_type__any___an_object_type_or_a_type_parameter: {
            category: 1 /* Error */,
            message: "The left-hand side of an 'instanceOf' expression must be of type 'any', an object type or a type parameter.",
            code: 2120
        },
        The_right_hand_side_of_an__instanceOf__expression_must_be_of_type__any__or_a_subtype_of_the__Function__interface_type: {
            category: 1 /* Error */,
            message: "The right-hand side of an 'instanceOf' expression must be of type 'any' or a subtype of the 'Function' interface type.",
            code: 2121
        },
        Setters_cannot_return_a_value: {
            category: 1 /* Error */,
            message: "Setters cannot return a value.",
            code: 2122
        },
        Tried_to_set_variable_type_to_module_type__0__: {
            category: 1 /* Error */,
            message: "Tried to set variable type to container type '{0}'.",
            code: 2123
        },
        Tried_to_set_variable_type_to_uninitialized_module_type__0__: {
            category: 1 /* Error */,
            message: "Tried to set variable type to uninitialized module type '{0}'.",
            code: 2124
        },
        Function__0__declared_a_non_void_return_type__but_has_no_return_expression: {
            category: 1 /* Error */,
            message: "Function {0} declared a non-void return type, but has no return expression.",
            code: 2125
        },
        Getters_must_return_a_value: {
            category: 1 /* Error */,
            message: "Getters must return a value.",
            code: 2126
        },
        Getter_and_setter_accessors_do_not_agree_in_visibility: {
            category: 1 /* Error */,
            message: "Getter and setter accessors do not agree in visibility.",
            code: 2127
        },
        Invalid_left_hand_side_of_assignment_expression: {
            category: 1 /* Error */,
            message: "Invalid left-hand side of assignment expression.",
            code: 2130
        },
        Function_declared_a_non_void_return_type__but_has_no_return_expression: {
            category: 1 /* Error */,
            message: "Function declared a non-void return type, but has no return expression.",
            code: 2131
        },
        Cannot_resolve_return_type_reference: {
            category: 1 /* Error */,
            message: "Cannot resolve return type reference.",
            code: 2132
        },
        Constructors_cannot_have_a_return_type_of__void_: {
            category: 1 /* Error */,
            message: "Constructors cannot have a return type of 'void'.",
            code: 2133
        },
        Subsequent_variable_declarations_must_have_the_same_type___Variable__0__must_be_of_type__1___but_here_has_type___2_: {
            category: 1 /* Error */,
            message: "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'",
            code: 2134
        },
        All_symbols_within_a__with__block_will_be_resolved_to__any__: {
            category: 1 /* Error */,
            message: "All symbols within a with block will be resolved to 'any'.",
            code: 2135
        },
        Import_declarations_in_an_internal_module_cannot_reference_an_external_module: {
            category: 1 /* Error */,
            message: "Import declarations in an internal module cannot reference an external module.",
            code: 2136
        },
        Class__0__declares_interface__1__but_does_not_implement_it__NL__2: {
            category: 1 /* Error */,
            message: "Class {0} declares interface {1} but does not implement it:{NL}{2}",
            code: 2137
        },
        Class__0__declares_class__1__but_does_not_implement_it__NL__2: {
            category: 1 /* Error */,
            message: "Class {0} declares class {1} as an implemented interface but does not implement it:{NL}{2}",
            code: 2138
        },
        The_operand_of_an_increment_or_decrement_operator_must_be_a_variable__property_or_indexer: {
            category: 1 /* Error */,
            message: "The operand of an increment or decrement operator must be a variable, property or indexer.",
            code: 2139
        },
        _this__cannot_be_referenced_in_initializers_in_a_class_body: {
            category: 1 /* Error */,
            message: "'this' cannot be referenced in initializers in a class body.",
            code: 2140
        },
        Class__0__cannot_extend_class__1__NL__2: {
            category: 1 /* Error */,
            message: "Class '{0}' cannot extend class '{1}':{NL}{2}",
            code: 2141
        },
        Interface__0__cannot_extend_class__1__NL__2: {
            category: 1 /* Error */,
            message: "Interface '{0}' cannot extend class '{1}':{NL}{2}",
            code: 2142
        },
        Interface__0__cannot_extend_interface__1__NL__2: {
            category: 1 /* Error */,
            message: "Interface '{0}' cannot extend interface '{1}':{NL}{2}",
            code: 2143
        },
        Duplicate_overload_signature_for__0_: {
            category: 1 /* Error */,
            message: "Duplicate overload signature for '{0}'.",
            code: 2144
        },
        Duplicate_constructor_overload_signature: {
            category: 1 /* Error */,
            message: "Duplicate constructor overload signature.",
            code: 2145
        },
        Duplicate_overload_call_signature: {
            category: 1 /* Error */,
            message: "Duplicate overload call signature.",
            code: 2146
        },
        Duplicate_overload_construct_signature: {
            category: 1 /* Error */,
            message: "Duplicate overload construct signature.",
            code: 2147
        },
        Overload_signature_is_not_compatible_with_function_definition: {
            category: 1 /* Error */,
            message: "Overload signature is not compatible with function definition.",
            code: 2148
        },
        Overload_signature_is_not_compatible_with_function_definition__NL__0: {
            category: 1 /* Error */,
            message: "Overload signature is not compatible with function definition:{NL}{0}",
            code: 2149
        },
        Overload_signatures_must_all_be_public_or_private: {
            category: 1 /* Error */,
            message: "Overload signatures must all be public or private.",
            code: 2150
        },
        Overload_signatures_must_all_be_exported_or_local: {
            category: 1 /* Error */,
            message: "Overload signatures must all be exported or local.",
            code: 2151
        },
        Overload_signatures_must_all_be_ambient_or_non_ambient: {
            category: 1 /* Error */,
            message: "Overload signatures must all be ambient or non-ambient.",
            code: 2152
        },
        Overload_signatures_must_all_be_optional_or_required: {
            category: 1 /* Error */,
            message: "Overload signatures must all be optional or required.",
            code: 2153
        },
        Specialized_overload_signature_is_not_subtype_of_any_non_specialized_signature: {
            category: 1 /* Error */,
            message: "Specialized overload signature is not subtype of any non-specialized signature.",
            code: 2154
        },
        _this__cannot_be_referenced_in_constructor_arguments: {
            category: 1 /* Error */,
            message: "'this' cannot be referenced in constructor arguments.",
            code: 2155
        },
        Static_member_cannot_be_accessed_off_an_instance_variable: {
            category: 1 /* Error */,
            message: "Static member cannot be accessed off an instance variable.",
            code: 2156
        },
        Instance_member_cannot_be_accessed_off_a_class: {
            category: 1 /* Error */,
            message: "Instance member cannot be accessed off a class.",
            code: 2157
        },
        Untyped_function_calls_may_not_accept_type_arguments: {
            category: 1 /* Error */,
            message: "Untyped function calls may not accept type arguments.",
            code: 2158
        },
        Non_generic_functions_may_not_accept_type_arguments: {
            category: 1 /* Error */,
            message: "Non-generic functions may not accept type arguments.",
            code: 2159
        },
        A_generic_type_may_not_reference_itself_with_its_own_type_parameters: {
            category: 1 /* Error */,
            message: "A generic type may not reference itself with a wrapped form of its own type parameters.",
            code: 2160
        },
        Value_of_type__0__is_not_callable__Did_you_mean_to_include__new___: {
            category: 1 /* Error */,
            message: "Value of type '{0}' is not callable. Did you mean to include 'new'?",
            code: 2161
        },
        Rest_parameters_must_be_array_types: {
            category: 1 /* Error */,
            message: "Rest parameters must be array types.",
            code: 2162
        },
        Overload_signature_implementation_cannot_use_specialized_type: {
            category: 1 /* Error */,
            message: "Overload signature implementation cannot use specialized type.",
            code: 2163
        },
        Export_assignments_may_only_be_used_in_External_modules: {
            category: 1 /* Error */,
            message: "Export assignments may only be used at the top-level of external modules",
            code: 2164
        },
        Export_assignments_may_only_be_made_with_acceptable_kinds: {
            category: 1 /* Error */,
            message: "Export assignments may only be made with variables, functions, classes, interfaces, enums and internal modules",
            code: 2165
        },
        Only_public_instance_methods_of_the_base_class_are_accessible_via_the_super_keyword: {
            category: 1 /* Error */,
            message: "Only public instance methods of the base class are accessible via the super keyword",
            code: 2166
        },
        Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1__: {
            category: 1 /* Error */,
            message: "Numeric indexer type '{0}' must be a subtype of string indexer type '{1}'",
            code: 2167
        },
        Numeric_indexer_type___0___must_be_a_subtype_of_string_indexer_type___1____NL__2: {
            category: 1 /* Error */,
            message: "Numeric indexer type '{0}' must be a subtype of string indexer type '{1}':{NL}{2}",
            code: 2168
        },
        All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0__: {
            category: 1 /* Error */,
            message: "All numerically named properties must be subtypes of numeric indexer type '{0}'",
            code: 2169
        },
        All_numerically_named_properties_must_be_subtypes_of_numeric_indexer_type___0____NL__1: {
            category: 1 /* Error */,
            message: "All numerically named properties must be subtypes of numeric indexer type '{0}':{NL}{1}",
            code: 2170
        },
        All_named_properties_must_be_subtypes_of_string_indexer_type___0__: {
            category: 1 /* Error */,
            message: "All named properties must be subtypes of string indexer type '{0}'",
            code: 2171
        },
        All_named_properties_must_be_subtypes_of_string_indexer_type___0____NL__1: {
            category: 1 /* Error */,
            message: "All named properties must be subtypes of string indexer type '{0}':{NL}{1}",
            code: 2172
        },
        Generic_type_references_must_include_all_type_arguments: {
            category: 1 /* Error */,
            message: "Generic type references must include all type arguments",
            code: 2173
        },
        Type__0__is_missing_property__1__from_type__2_: {
            category: 3 /* NoPrefix */,
            message: "Type '{0}' is missing property '{1}' from type '{2}'.",
            code: 4000
        },
        Types_of_property__0__of_types__1__and__2__are_incompatible: {
            category: 3 /* NoPrefix */,
            message: "Types of property '{0}' of types '{1}' and '{2}' are incompatible.",
            code: 4001
        },
        Types_of_property__0__of_types__1__and__2__are_incompatible__NL__3: {
            category: 3 /* NoPrefix */,
            message: "Types of property '{0}' of types '{1}' and '{2}' are incompatible:{NL}{3}",
            code: 4002
        },
        Property__0__defined_as_private_in_type__1__is_defined_as_public_in_type__2_: {
            category: 3 /* NoPrefix */,
            message: "Property '{0}' defined as private in type '{1}' is defined as public in type '{2}'.",
            code: 4003
        },
        Property__0__defined_as_public_in_type__1__is_defined_as_private_in_type__2_: {
            category: 3 /* NoPrefix */,
            message: "Property '{0}' defined as public in type '{1}' is defined as private in type '{2}'.",
            code: 4004
        },
        Types__0__and__1__define_property__2__as_private: {
            category: 3 /* NoPrefix */,
            message: "Types '{0}' and '{1}' define property '{2}' as private.",
            code: 4005
        },
        Call_signatures_of_types__0__and__1__are_incompatible: {
            category: 3 /* NoPrefix */,
            message: "Call signatures of types '{0}' and '{1}' are incompatible.",
            code: 4006
        },
        Call_signatures_of_types__0__and__1__are_incompatible__NL__2: {
            category: 3 /* NoPrefix */,
            message: "Call signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
            code: 4007
        },
        Type__0__requires_a_call_signature__but_Type__1__lacks_one: {
            category: 3 /* NoPrefix */,
            message: "Type '{0}' requires a call signature, but type '{1}' lacks one.",
            code: 4008
        },
        Construct_signatures_of_types__0__and__1__are_incompatible: {
            category: 3 /* NoPrefix */,
            message: "Construct signatures of types '{0}' and '{1}' are incompatible.",
            code: 4009
        },
        Construct_signatures_of_types__0__and__1__are_incompatible__NL__2: {
            category: 3 /* NoPrefix */,
            message: "Construct signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
            code: 40010
        },
        Type__0__requires_a_construct_signature__but_Type__1__lacks_one: {
            category: 3 /* NoPrefix */,
            message: "Type '{0}' requires a construct signature, but type '{1}' lacks one.",
            code: 4011
        },
        Index_signatures_of_types__0__and__1__are_incompatible: {
            category: 3 /* NoPrefix */,
            message: "Index signatures of types '{0}' and '{1}' are incompatible.",
            code: 4012
        },
        Index_signatures_of_types__0__and__1__are_incompatible__NL__2: {
            category: 3 /* NoPrefix */,
            message: "Index signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
            code: 4013
        },
        Call_signature_expects__0__or_fewer_parameters: {
            category: 3 /* NoPrefix */,
            message: "Call signature expects {0} or fewer parameters.",
            code: 4014
        },
        Could_not_apply_type__0__to_argument__1__which_is_of_type__2_: {
            category: 3 /* NoPrefix */,
            message: "Could not apply type'{0}' to argument {1} which is of type '{2}'.",
            code: 4015
        },
        Class__0__defines_instance_member_accessor__1___but_extended_class__2__defines_it_as_instance_member_function: {
            category: 3 /* NoPrefix */,
            message: "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function.",
            code: 4016
        },
        Class__0__defines_instance_member_property__1___but_extended_class__2__defines_it_as_instance_member_function: {
            category: 3 /* NoPrefix */,
            message: "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function.",
            code: 4017
        },
        Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_accessor: {
            category: 3 /* NoPrefix */,
            message: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor.",
            code: 4018
        },
        Class__0__defines_instance_member_function__1___but_extended_class__2__defines_it_as_instance_member_property: {
            category: 3 /* NoPrefix */,
            message: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member property.",
            code: 4019
        },
        Types_of_static_property__0__of_class__1__and_class__2__are_incompatible: {
            category: 3 /* NoPrefix */,
            message: "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible.",
            code: 4020
        },
        Types_of_static_property__0__of_class__1__and_class__2__are_incompatible__NL__3: {
            category: 3 /* NoPrefix */,
            message: "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible:{NL}{3}",
            code: 4021
        },
        Type_reference_cannot_refer_to_container__0_: {
            category: 1 /* Error */,
            message: "Type reference cannot refer to container '{0}'.",
            code: 4022
        },
        Type_reference_must_refer_to_type: {
            category: 1 /* Error */,
            message: "Type reference cannot must refer to type.",
            code: 4023
        },
        Enums_with_multiple_declarations_must_provide_an_initializer_for_the_first_enum_element: {
            category: 1 /* Error */,
            message: "Enums with multiple declarations must provide an initializer for the first enum element.",
            code: 4024
        },
        Current_host_does_not_support__w_atch_option: {
            category: 1 /* Error */,
            message: "Current host does not support -w[atch] option.",
            code: 5001
        },
        ECMAScript_target_version__0__not_supported___Using_default__1__code_generation: {
            category: 0 /* Warning */,
            message: "ECMAScript target version '{0}' not supported.  Using default '{1}' code generation.",
            code: 5002
        },
        Module_code_generation__0__not_supported___Using_default__1__code_generation: {
            category: 0 /* Warning */,
            message: "Module code generation '{0}' not supported.  Using default '{1}' code generation.",
            code: 5003
        },
        Could_not_find_file___0_: {
            category: 1 /* Error */,
            message: "Could not find file: '{0}'.",
            code: 5004
        },
        Unknown_extension_for_file___0__Only__ts_and_d_ts_extensions_are_allowed: {
            category: 1 /* Error */,
            message: "Unknown extension for file: '{0}'. Only .ts and .d.ts extensions are allowed.",
            code: 5005
        },
        A_file_cannot_have_a_reference_itself: {
            category: 1 /* Error */,
            message: "A file cannot have a reference itself.",
            code: 5006
        },
        Cannot_resolve_referenced_file___0_: {
            category: 1 /* Error */,
            message: "Cannot resolve referenced file: '{0}'.",
            code: 5007
        },
        Cannot_resolve_imported_file___0_: {
            category: 1 /* Error */,
            message: "Cannot resolve imported file: '{0}'.",
            code: 5008
        },
        Cannot_find_the_common_subdirectory_path_for_the_input_files: {
            category: 1 /* Error */,
            message: "Cannot find the common subdirectory path for the input files",
            code: 5009
        },
        Cannot_compile_dynamic_modules_when_emitting_into_single_file: {
            category: 1 /* Error */,
            message: "Cannot compile dynamic modules when emitting into single file",
            code: 5010
        },
        Emit_Error__0: {
            category: 1 /* Error */,
            message: "Emit Error: {0}.",
            code: 5011
        },
        Unsupported_encoding_for_file__0: {
            category: 1 /* Error */,
            message: "Unsupported encoding for file: '{0}'.",
            code: 5013
        }
    };

    var seenCodes = [];
    for (var name in TypeScript.diagnosticMessages) {
        if (TypeScript.diagnosticMessages.hasOwnProperty(name)) {
            var diagnosticMessage = TypeScript.diagnosticMessages[name];
            var value = seenCodes[diagnosticMessage.code];
            if (value) {
                throw new Error("Duplicate diagnostic code: " + diagnosticMessage.code);
            }

            seenCodes[diagnosticMessage.code] = diagnosticMessage;
        }
    }
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Errors = (function () {
        function Errors() {
        }
        Errors.argument = function (argument, message) {
            return new Error("Invalid argument: " + argument + "." + (message ? (" " + message) : ""));
        };

        Errors.argumentOutOfRange = function (argument) {
            return new Error("Argument out of range: " + argument + ".");
        };

        Errors.argumentNull = function (argument) {
            return new Error("Argument null: " + argument + ".");
        };

        Errors.abstract = function () {
            return new Error("Operation not implemented properly by subclass.");
        };

        Errors.notYetImplemented = function () {
            return new Error("Not yet implemented.");
        };

        Errors.invalidOperation = function (message) {
            return new Error(message ? ("Invalid operation: " + message) : "Invalid operation.");
        };
        return Errors;
    })();
    TypeScript.Errors = Errors;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Hash = (function () {
        function Hash() {
        }
        Hash.computeFnv1aCharArrayHashCode = function (text, start, len) {
            var hashCode = Hash.FNV_BASE;
            var end = start + len;

            for (var i = start; i < end; i++) {
                hashCode = (hashCode ^ text[i]) * Hash.FNV_PRIME;
            }

            return hashCode;
        };

        Hash.computeSimple31BitCharArrayHashCode = function (key, start, len) {
            var hash = 0;

            for (var i = 0; i < len; i++) {
                var ch = key[start + i];

                hash = (((hash << 5) + hash) + ch) | 0;
            }

            return hash & 0x7FFFFFFF;
        };

        Hash.computeSimple31BitStringHashCode = function (key) {
            var hash = 0;

            var start = 0;
            var len = key.length;

            for (var i = 0; i < len; i++) {
                var ch = key.charCodeAt(start + i);

                hash = (((hash << 5) + hash) + ch) | 0;
            }

            return hash & 0x7FFFFFFF;
        };

        Hash.computeMurmur2CharArrayHashCode = function (key, start, len) {
            var m = 0x5bd1e995;
            var r = 24;

            var numberOfCharsLeft = len;
            var h = (0 ^ numberOfCharsLeft);

            var index = start;
            while (numberOfCharsLeft >= 2) {
                var c1 = key[index];
                var c2 = key[index + 1];

                var k = c1 | (c2 << 16);

                k *= m;
                k ^= k >> r;
                k *= m;

                h *= m;
                h ^= k;

                index += 2;
                numberOfCharsLeft -= 2;
            }

            if (numberOfCharsLeft === 1) {
                h ^= key[index];
                h *= m;
            }

            h ^= h >> 13;
            h *= m;
            h ^= h >> 15;

            return h;
        };

        Hash.computeMurmur2StringHashCode = function (key) {
            var m = 0x5bd1e995;
            var r = 24;

            var start = 0;
            var len = key.length;
            var numberOfCharsLeft = len;

            var h = (0 ^ numberOfCharsLeft);

            var index = start;
            while (numberOfCharsLeft >= 2) {
                var c1 = key.charCodeAt(index);
                var c2 = key.charCodeAt(index + 1);

                var k = c1 | (c2 << 16);

                k *= m;
                k ^= k >> r;
                k *= m;

                h *= m;
                h ^= k;

                index += 2;
                numberOfCharsLeft -= 2;
            }

            if (numberOfCharsLeft === 1) {
                h ^= key.charCodeAt(index);
                h *= m;
            }

            h ^= h >> 13;
            h *= m;
            h ^= h >> 15;

            return h;
        };

        Hash.getPrime = function (min) {
            for (var i = 0; i < Hash.primes.length; i++) {
                var num = Hash.primes[i];
                if (num >= min) {
                    return num;
                }
            }

            throw TypeScript.Errors.notYetImplemented();
        };

        Hash.expandPrime = function (oldSize) {
            var num = oldSize << 1;
            if (num > 2146435069 && 2146435069 > oldSize) {
                return 2146435069;
            }
            return Hash.getPrime(num);
        };

        Hash.combine = function (value, currentHash) {
            return (((currentHash << 5) + currentHash) + value) & 0x7FFFFFFF;
        };
        Hash.FNV_BASE = 2166136261;
        Hash.FNV_PRIME = 16777619;

        Hash.primes = [
            3,
            7,
            11,
            17,
            23,
            29,
            37,
            47,
            59,
            71,
            89,
            107,
            131,
            163,
            197,
            239,
            293,
            353,
            431,
            521,
            631,
            761,
            919,
            1103,
            1327,
            1597,
            1931,
            2333,
            2801,
            3371,
            4049,
            4861,
            5839,
            7013,
            8419,
            10103,
            12143,
            14591,
            17519,
            21023,
            25229,
            30293,
            36353,
            43627,
            52361,
            62851,
            75431,
            90523,
            108631,
            130363,
            156437,
            187751,
            225307,
            270371,
            324449,
            389357,
            467237,
            560689,
            672827,
            807403,
            968897,
            1162687,
            1395263,
            1674319,
            2009191,
            2411033,
            2893249,
            3471899,
            4166287,
            4999559,
            5999471,
            7199369
        ];
        return Hash;
    })();
    TypeScript.Hash = Hash;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Collections) {
        Collections.DefaultHashTableCapacity = 256;

        var HashTableEntry = (function () {
            function HashTableEntry(Key, Value, HashCode, Next) {
                this.Key = Key;
                this.Value = Value;
                this.HashCode = HashCode;
                this.Next = Next;
            }
            return HashTableEntry;
        })();

        var HashTable = (function () {
            function HashTable(capacity, hash, equals) {
                this.hash = hash;
                this.equals = equals;
                this.entries = [];
                this.count = 0;
                var size = TypeScript.Hash.getPrime(capacity);
                this.hash = hash;
                this.equals = equals;
                this.entries = TypeScript.ArrayUtilities.createArray(size, null);
            }
            HashTable.prototype.set = function (key, value) {
                this.addOrSet(key, value, false);
            };

            HashTable.prototype.add = function (key, value) {
                this.addOrSet(key, value, true);
            };

            HashTable.prototype.containsKey = function (key) {
                var hashCode = this.computeHashCode(key);
                var entry = this.findEntry(key, hashCode);
                return entry !== null;
            };

            HashTable.prototype.get = function (key) {
                var hashCode = this.computeHashCode(key);
                var entry = this.findEntry(key, hashCode);

                return entry === null ? null : entry.Value;
            };

            HashTable.prototype.computeHashCode = function (key) {
                var hashCode = this.hash === null ? key.hashCode() : this.hash(key);

                hashCode = hashCode & 0x7FFFFFFF;
                TypeScript.Debug.assert(hashCode > 0);

                return hashCode;
            };

            HashTable.prototype.addOrSet = function (key, value, throwOnExistingEntry) {
                var hashCode = this.computeHashCode(key);

                var entry = this.findEntry(key, hashCode);
                if (entry !== null) {
                    if (throwOnExistingEntry) {
                        throw TypeScript.Errors.argument('key', 'Key was already in table.');
                    }

                    entry.Key = key;
                    entry.Value = value;
                    return;
                }

                return this.addEntry(key, value, hashCode);
            };

            HashTable.prototype.findEntry = function (key, hashCode) {
                for (var e = this.entries[hashCode % this.entries.length]; e !== null; e = e.Next) {
                    if (e.HashCode === hashCode) {
                        var equals = this.equals === null ? key === e.Key : this.equals(key, e.Key);

                        if (equals) {
                            return e;
                        }
                    }
                }

                return null;
            };

            HashTable.prototype.addEntry = function (key, value, hashCode) {
                var index = hashCode % this.entries.length;

                var e = new HashTableEntry(key, value, hashCode, this.entries[index]);

                this.entries[index] = e;

                if (this.count === this.entries.length) {
                    this.grow();
                }

                this.count++;
                return e.Key;
            };

            HashTable.prototype.grow = function () {
                var newSize = TypeScript.Hash.expandPrime(this.entries.length);

                var oldEntries = this.entries;
                var newEntries = TypeScript.ArrayUtilities.createArray(newSize, null);

                this.entries = newEntries;

                for (var i = 0; i < oldEntries.length; i++) {
                    var e = oldEntries[i];

                    while (e !== null) {
                        var newIndex = e.HashCode % newSize;
                        var tmp = e.Next;
                        e.Next = newEntries[newIndex];
                        newEntries[newIndex] = e;
                        e = tmp;
                    }
                }
            };
            return HashTable;
        })();
        Collections.HashTable = HashTable;

        function createHashTable(capacity, hash, equals) {
            if (typeof capacity === "undefined") { capacity = Collections.DefaultHashTableCapacity; }
            if (typeof hash === "undefined") { hash = null; }
            if (typeof equals === "undefined") { equals = null; }
            return new HashTable(capacity, hash, equals);
        }
        Collections.createHashTable = createHashTable;

        var currentHashCode = 1;
        function identityHashCode(value) {
            if (value.__hash === undefined) {
                value.__hash = currentHashCode;
                currentHashCode++;
            }

            return value.__hash;
        }
        Collections.identityHashCode = identityHashCode;
    })(TypeScript.Collections || (TypeScript.Collections = {}));
    var Collections = TypeScript.Collections;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Diagnostic = (function () {
        function Diagnostic(fileName, start, length, diagnosticCode, arguments) {
            if (typeof arguments === "undefined") { arguments = null; }
            this._diagnosticCode = diagnosticCode;
            this._arguments = (arguments && arguments.length > 0) ? arguments : null;
            this._fileName = fileName;
            this._originalStart = this._start = start;
            this._length = length;
        }
        Diagnostic.prototype.toJSON = function (key) {
            var result = {};
            result.start = this.start();
            result.length = this.length();

            result.diagnosticCode = TypeScript.DiagnosticCode[this.diagnosticCode()];

            var arguments = (this).arguments();
            if (arguments && arguments.length > 0) {
                result.arguments = arguments;
            }

            return result;
        };

        Diagnostic.prototype.fileName = function () {
            return this._fileName;
        };

        Diagnostic.prototype.start = function () {
            return this._start;
        };

        Diagnostic.prototype.length = function () {
            return this._length;
        };

        Diagnostic.prototype.diagnosticCode = function () {
            return this._diagnosticCode;
        };

        Diagnostic.prototype.arguments = function () {
            return this._arguments;
        };

        Diagnostic.prototype.text = function () {
            return TypeScript.getDiagnosticText(this._diagnosticCode, this._arguments);
        };

        Diagnostic.prototype.message = function () {
            return TypeScript.getDiagnosticMessage(this._diagnosticCode, this._arguments);
        };

        Diagnostic.prototype.adjustOffset = function (pos) {
            this._start = this._originalStart + pos;
        };

        Diagnostic.prototype.additionalLocations = function () {
            return [];
        };

        Diagnostic.equals = function (diagnostic1, diagnostic2) {
            return diagnostic1._fileName === diagnostic2._fileName && diagnostic1._start === diagnostic2._start && diagnostic1._length === diagnostic2._length && diagnostic1._diagnosticCode === diagnostic2._diagnosticCode && TypeScript.ArrayUtilities.sequenceEquals(diagnostic1._arguments, diagnostic2._arguments, function (v1, v2) {
                return v1 === v2;
            });
        };
        return Diagnostic;
    })();
    TypeScript.Diagnostic = Diagnostic;

    function getLargestIndex(diagnostic) {
        var largest = -1;
        var stringComponents = diagnostic.split("_");

        for (var i = 0; i < stringComponents.length; i++) {
            var val = parseInt(stringComponents[i]);
            if (!isNaN(val) && val > largest) {
                largest = val;
            }
        }

        return largest;
    }

    function getDiagnosticInfoFromCode(diagnosticCode) {
        var diagnosticName = TypeScript.DiagnosticCode[diagnosticCode];
        return TypeScript.diagnosticMessages[diagnosticName];
    }
    TypeScript.getDiagnosticInfoFromCode = getDiagnosticInfoFromCode;

    function getDiagnosticText(diagnosticCode, args) {
        var diagnosticName = TypeScript.DiagnosticCode[diagnosticCode];

        var diagnostic = TypeScript.diagnosticMessages[diagnosticName];

        var actualCount = args ? args.length : 0;
        if (!diagnostic) {
            throw new Error("Invalid diagnostic");
        } else {
            var expectedCount = 1 + getLargestIndex(diagnosticName);

            if (expectedCount !== actualCount) {
                throw new Error("Expected " + expectedCount + " arguments to diagnostic, got " + actualCount + " instead");
            }
        }

        var diagnosticMessageText = diagnostic.message.replace(/{({(\d+)})?TB}/g, function (match, p1, num) {
            var tabChar = "\t";
            var result = tabChar;
            if (num && args[num]) {
                for (var i = 1; i < args[num]; i++) {
                    result += tabChar;
                }
            }

            return result;
        });

        diagnosticMessageText = diagnosticMessageText.replace(/{(\d+)}/g, function (match, num) {
            return typeof args[num] !== 'undefined' ? args[num] : match;
        });

        diagnosticMessageText = diagnosticMessageText.replace(/{(NL)}/g, function (match) {
            return "\r\n";
        });

        return diagnosticMessageText;
    }
    TypeScript.getDiagnosticText = getDiagnosticText;

    function getDiagnosticMessage(diagnosticCode, args) {
        var diagnostic = getDiagnosticInfoFromCode(diagnosticCode);
        var diagnosticMessageText = getDiagnosticText(diagnosticCode, args);

        var message;
        if (diagnostic.category === 1 /* Error */) {
            message = getDiagnosticText(0 /* error_TS_0__1 */, [diagnostic.code, diagnosticMessageText]);
        } else if (diagnostic.category === 0 /* Warning */) {
            message = getDiagnosticText(1 /* warning_TS_0__1 */, [diagnostic.code, diagnosticMessageText]);
        } else {
            message = diagnosticMessageText;
        }

        return message;
    }
    TypeScript.getDiagnosticMessage = getDiagnosticMessage;
})(TypeScript || (TypeScript = {}));
var ByteOrderMark;
(function (ByteOrderMark) {
    ByteOrderMark[ByteOrderMark["None"] = 0] = "None";
    ByteOrderMark[ByteOrderMark["Utf8"] = 1] = "Utf8";
    ByteOrderMark[ByteOrderMark["Utf16BigEndian"] = 2] = "Utf16BigEndian";
    ByteOrderMark[ByteOrderMark["Utf16LittleEndian"] = 3] = "Utf16LittleEndian";
})(ByteOrderMark || (ByteOrderMark = {}));

var FileInformation = (function () {
    function FileInformation(contents, byteOrderMark) {
        this._contents = contents;
        this._byteOrderMark = byteOrderMark;
    }
    FileInformation.prototype.contents = function () {
        return this._contents;
    };

    FileInformation.prototype.byteOrderMark = function () {
        return this._byteOrderMark;
    };
    return FileInformation;
})();

var Environment = (function () {
    function getWindowsScriptHostEnvironment() {
        try  {
            var fso = new ActiveXObject("Scripting.FileSystemObject");
        } catch (e) {
            return null;
        }

        var streamObjectPool = [];

        function getStreamObject() {
            if (streamObjectPool.length > 0) {
                return streamObjectPool.pop();
            } else {
                return new ActiveXObject("ADODB.Stream");
            }
        }

        function releaseStreamObject(obj) {
            streamObjectPool.push(obj);
        }

        var args = [];
        for (var i = 0; i < WScript.Arguments.length; i++) {
            args[i] = WScript.Arguments.Item(i);
        }

        return {
            currentDirectory: function () {
                return (WScript).CreateObject("WScript.Shell").CurrentDirectory;
            },
            readFile: function (path) {
                try  {
                    var streamObj = getStreamObject();
                    streamObj.Open();
                    streamObj.Type = 2;

                    streamObj.Charset = 'x-ansi';

                    streamObj.LoadFromFile(path);
                    var bomChar = streamObj.ReadText(2);

                    streamObj.Position = 0;

                    var byteOrderMark = 0 /* None */;

                    if (bomChar.charCodeAt(0) === 0xFE && bomChar.charCodeAt(1) === 0xFF) {
                        streamObj.Charset = 'unicode';
                        byteOrderMark = 2 /* Utf16BigEndian */;
                    } else if (bomChar.charCodeAt(0) === 0xFF && bomChar.charCodeAt(1) === 0xFE) {
                        streamObj.Charset = 'unicode';
                        byteOrderMark = 3 /* Utf16LittleEndian */;
                    } else if (bomChar.charCodeAt(0) === 0xEF && bomChar.charCodeAt(1) === 0xBB) {
                        streamObj.Charset = 'utf-8';
                        byteOrderMark = 1 /* Utf8 */;
                    } else {
                        streamObj.Charset = 'utf-8';
                    }

                    var contents = streamObj.ReadText(-1);
                    streamObj.Close();
                    releaseStreamObject(streamObj);
                    return new FileInformation(contents, byteOrderMark);
                } catch (err) {
                    var error = new Error(err.message);

                    var message;
                    if (err.number === -2147024809) {
                        error.isUnsupportedEncoding = true;
                    }

                    throw error;
                }
            },
            writeFile: function (path, contents, writeByteOrderMark) {
                var textStream = getStreamObject();
                textStream.Charset = 'utf-8';
                textStream.Open();
                textStream.WriteText(contents, 0);

                if (!writeByteOrderMark) {
                    textStream.Position = 3;
                } else {
                    textStream.Position = 0;
                }

                var fileStream = getStreamObject();
                fileStream.Type = 1;
                fileStream.Open();

                textStream.CopyTo(fileStream);

                fileStream.Flush();
                fileStream.SaveToFile(path, 2);
                fileStream.Close();

                textStream.Flush();
                textStream.Close();
            },
            fileExists: function (path) {
                return fso.FileExists(path);
            },
            deleteFile: function (path) {
                if (fso.FileExists(path)) {
                    fso.DeleteFile(path, true);
                }
            },
            directoryExists: function (path) {
                return fso.FolderExists(path);
            },
            listFiles: function (path, spec, options) {
                options = options || {};
                function filesInFolder(folder, root) {
                    var paths = [];
                    var fc;

                    if (options.recursive) {
                        fc = new Enumerator(folder.subfolders);

                        for (; !fc.atEnd(); fc.moveNext()) {
                            paths = paths.concat(filesInFolder(fc.item(), root + "\\" + fc.item().Name));
                        }
                    }

                    fc = new Enumerator(folder.files);

                    for (; !fc.atEnd(); fc.moveNext()) {
                        if (!spec || fc.item().Name.match(spec)) {
                            paths.push(root + "\\" + fc.item().Name);
                        }
                    }

                    return paths;
                }

                var folder = fso.GetFolder(path);
                var paths = [];

                return filesInFolder(folder, path);
            },
            arguments: args,
            standardOut: WScript.StdOut
        };
    }
    ;

    function getNodeEnvironment() {
        var _fs = require('fs');
        var _path = require('path');
        var _module = require('module');

        return {
            currentDirectory: function () {
                return (process).cwd();
            },
            readFile: function (file) {
                var buffer = _fs.readFileSync(file);
                switch (buffer[0]) {
                    case 0xFE:
                        if (buffer[1] === 0xFF) {
                            var i = 0;
                            while ((i + 1) < buffer.length) {
                                var temp = buffer[i];
                                buffer[i] = buffer[i + 1];
                                buffer[i + 1] = temp;
                                i += 2;
                            }
                            return new FileInformation(buffer.toString("ucs2", 2), 2 /* Utf16BigEndian */);
                        }
                        break;
                    case 0xFF:
                        if (buffer[1] === 0xFE) {
                            return new FileInformation(buffer.toString("ucs2", 2), 3 /* Utf16LittleEndian */);
                        }
                        break;
                    case 0xEF:
                        if (buffer[1] === 0xBB) {
                            return new FileInformation(buffer.toString("utf8", 3), 1 /* Utf8 */);
                        }
                }

                return new FileInformation(buffer.toString("utf8", 0), 0 /* None */);
            },
            writeFile: function (path, contents, writeByteOrderMark) {
                function mkdirRecursiveSync(path) {
                    var stats = _fs.statSync(path);
                    if (stats.isFile()) {
                        throw "\"" + path + "\" exists but isn't a directory.";
                    } else if (stats.isDirectory()) {
                        return;
                    } else {
                        mkdirRecursiveSync(_path.dirname(path));
                        _fs.mkdirSync(path, 0775);
                    }
                }
                mkdirRecursiveSync(_path.dirname(path));

                if (writeByteOrderMark) {
                    contents = '\uFEFF' + contents;
                }
                _fs.writeFileSync(path, contents, "utf8");
            },
            fileExists: function (path) {
                return _fs.existsSync(path);
            },
            deleteFile: function (path) {
                try  {
                    _fs.unlinkSync(path);
                } catch (e) {
                }
            },
            directoryExists: function (path) {
                return _fs.existsSync(path) && _fs.statSync(path).isDirectory();
            },
            listFiles: function dir(path, spec, options) {
                options = options || {};

                function filesInFolder(folder) {
                    var paths = [];

                    var files = _fs.readdirSync(folder);
                    for (var i = 0; i < files.length; i++) {
                        var stat = _fs.statSync(folder + "\\" + files[i]);
                        if (options.recursive && stat.isDirectory()) {
                            paths = paths.concat(filesInFolder(folder + "\\" + files[i]));
                        } else if (stat.isFile() && (!spec || files[i].match(spec))) {
                            paths.push(folder + "\\" + files[i]);
                        }
                    }

                    return paths;
                }

                return filesInFolder(path);
            },
            arguments: process.argv.slice(2),
            standardOut: {
                Write: function (str) {
                    process.stdout.write(str);
                },
                WriteLine: function (str) {
                    process.stdout.write(str + '\n');
                },
                Close: function () {
                }
            }
        };
    }
    ;

    if (typeof WScript !== "undefined" && typeof ActiveXObject === "function") {
        return getWindowsScriptHostEnvironment();
    } else if (typeof module !== 'undefined' && module.exports) {
        return getNodeEnvironment();
    } else {
        return null;
    }
})();
var TypeScript;
(function (TypeScript) {
    var IntegerUtilities = (function () {
        function IntegerUtilities() {
        }
        IntegerUtilities.integerDivide = function (numerator, denominator) {
            return (numerator / denominator) >> 0;
        };

        IntegerUtilities.integerMultiplyLow32Bits = function (n1, n2) {
            var n1Low16 = n1 & 0x0000ffff;
            var n1High16 = n1 >>> 16;

            var n2Low16 = n2 & 0x0000ffff;
            var n2High16 = n2 >>> 16;

            var resultLow32 = (((n1 & 0xffff0000) * n2) >>> 0) + (((n1 & 0x0000ffff) * n2) >>> 0) >>> 0;
            return resultLow32;
        };

        IntegerUtilities.integerMultiplyHigh32Bits = function (n1, n2) {
            var n1Low16 = n1 & 0x0000ffff;
            var n1High16 = n1 >>> 16;

            var n2Low16 = n2 & 0x0000ffff;
            var n2High16 = n2 >>> 16;

            var resultHigh32 = n1High16 * n2High16 + ((((n1Low16 * n2Low16) >>> 17) + n1Low16 * n2High16) >>> 15);
            return resultHigh32;
        };
        return IntegerUtilities;
    })();
    TypeScript.IntegerUtilities = IntegerUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var MathPrototype = (function () {
        function MathPrototype() {
        }
        MathPrototype.max = function (a, b) {
            return a >= b ? a : b;
        };

        MathPrototype.min = function (a, b) {
            return a <= b ? a : b;
        };
        return MathPrototype;
    })();
    TypeScript.MathPrototype = MathPrototype;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Collections) {
        Collections.DefaultStringTableCapacity = 256;

        var StringTableEntry = (function () {
            function StringTableEntry(Text, HashCode, Next) {
                this.Text = Text;
                this.HashCode = HashCode;
                this.Next = Next;
            }
            return StringTableEntry;
        })();

        var StringTable = (function () {
            function StringTable(capacity) {
                this.entries = [];
                this.count = 0;
                var size = TypeScript.Hash.getPrime(capacity);
                this.entries = TypeScript.ArrayUtilities.createArray(size, null);
            }
            StringTable.prototype.addCharArray = function (key, start, len) {
                var hashCode = TypeScript.Hash.computeSimple31BitCharArrayHashCode(key, start, len) & 0x7FFFFFFF;

                var entry = this.findCharArrayEntry(key, start, len, hashCode);
                if (entry !== null) {
                    return entry.Text;
                }

                var slice = key.slice(start, start + len);
                return this.addEntry(TypeScript.StringUtilities.fromCharCodeArray(slice), hashCode);
            };

            StringTable.prototype.findCharArrayEntry = function (key, start, len, hashCode) {
                for (var e = this.entries[hashCode % this.entries.length]; e !== null; e = e.Next) {
                    if (e.HashCode === hashCode && StringTable.textCharArrayEquals(e.Text, key, start, len)) {
                        return e;
                    }
                }

                return null;
            };

            StringTable.prototype.addEntry = function (text, hashCode) {
                var index = hashCode % this.entries.length;

                var e = new StringTableEntry(text, hashCode, this.entries[index]);

                this.entries[index] = e;

                if (this.count === this.entries.length) {
                    this.grow();
                }

                this.count++;
                return e.Text;
            };

            StringTable.prototype.grow = function () {
                var newSize = TypeScript.Hash.expandPrime(this.entries.length);

                var oldEntries = this.entries;
                var newEntries = TypeScript.ArrayUtilities.createArray(newSize, null);

                this.entries = newEntries;

                for (var i = 0; i < oldEntries.length; i++) {
                    var e = oldEntries[i];
                    while (e !== null) {
                        var newIndex = e.HashCode % newSize;
                        var tmp = e.Next;
                        e.Next = newEntries[newIndex];
                        newEntries[newIndex] = e;
                        e = tmp;
                    }
                }
            };

            StringTable.textCharArrayEquals = function (text, array, start, length) {
                if (text.length !== length) {
                    return false;
                }

                var s = start;
                for (var i = 0; i < length; i++) {
                    if (text.charCodeAt(i) !== array[s]) {
                        return false;
                    }

                    s++;
                }

                return true;
            };
            return StringTable;
        })();
        Collections.StringTable = StringTable;

        Collections.DefaultStringTable = new StringTable(Collections.DefaultStringTableCapacity);
    })(TypeScript.Collections || (TypeScript.Collections = {}));
    var Collections = TypeScript.Collections;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var StringUtilities = (function () {
        function StringUtilities() {
        }
        StringUtilities.isString = function (value) {
            return Object.prototype.toString.apply(value, []) === '[object String]';
        };

        StringUtilities.fromCharCodeArray = function (array) {
            return String.fromCharCode.apply(null, array);
        };

        StringUtilities.endsWith = function (string, value) {
            return string.substring(string.length - value.length, string.length) === value;
        };

        StringUtilities.startsWith = function (string, value) {
            return string.substr(0, value.length) === value;
        };

        StringUtilities.copyTo = function (source, sourceIndex, destination, destinationIndex, count) {
            for (var i = 0; i < count; i++) {
                destination[destinationIndex + i] = source.charCodeAt(sourceIndex + i);
            }
        };

        StringUtilities.repeat = function (value, count) {
            return Array(count + 1).join(value);
        };

        StringUtilities.stringEquals = function (val1, val2) {
            return val1 === val2;
        };
        return StringUtilities;
    })();
    TypeScript.StringUtilities = StringUtilities;
})(TypeScript || (TypeScript = {}));
var global = Function("return this").call(null);

var TypeScript;
(function (TypeScript) {
    var Clock;
    (function (Clock) {
        Clock.now;
        Clock.resolution;

        if (typeof WScript !== "undefined" && typeof global['WScript'].InitializeProjection !== "undefined") {
            global['WScript'].InitializeProjection();

            Clock.now = function () {
                return TestUtilities.QueryPerformanceCounter();
            };

            Clock.resolution = TestUtilities.QueryPerformanceFrequency();
        } else {
            Clock.now = function () {
                return Date.now();
            };

            Clock.resolution = 1000;
        }
    })(Clock || (Clock = {}));

    var Timer = (function () {
        function Timer() {
            this.time = 0;
        }
        Timer.prototype.start = function () {
            this.time = 0;
            this.startTime = Clock.now();
        };

        Timer.prototype.end = function () {
            this.time = (Clock.now() - this.startTime);
        };
        return Timer;
    })();
    TypeScript.Timer = Timer;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (CharacterCodes) {
        CharacterCodes[CharacterCodes["nullCharacter"] = 0] = "nullCharacter";
        CharacterCodes[CharacterCodes["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";

        CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
        CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
        CharacterCodes[CharacterCodes["lineSeparator"] = 0x2028] = "lineSeparator";
        CharacterCodes[CharacterCodes["paragraphSeparator"] = 0x2029] = "paragraphSeparator";

        CharacterCodes[CharacterCodes["nextLine"] = 0x0085] = "nextLine";

        CharacterCodes[CharacterCodes["space"] = 0x0020] = "space";
        CharacterCodes[CharacterCodes["nonBreakingSpace"] = 0x00A0] = "nonBreakingSpace";
        CharacterCodes[CharacterCodes["enQuad"] = 0x2000] = "enQuad";
        CharacterCodes[CharacterCodes["emQuad"] = 0x2001] = "emQuad";
        CharacterCodes[CharacterCodes["enSpace"] = 0x2002] = "enSpace";
        CharacterCodes[CharacterCodes["emSpace"] = 0x2003] = "emSpace";
        CharacterCodes[CharacterCodes["threePerEmSpace"] = 0x2004] = "threePerEmSpace";
        CharacterCodes[CharacterCodes["fourPerEmSpace"] = 0x2005] = "fourPerEmSpace";
        CharacterCodes[CharacterCodes["sixPerEmSpace"] = 0x2006] = "sixPerEmSpace";
        CharacterCodes[CharacterCodes["figureSpace"] = 0x2007] = "figureSpace";
        CharacterCodes[CharacterCodes["punctuationSpace"] = 0x2008] = "punctuationSpace";
        CharacterCodes[CharacterCodes["thinSpace"] = 0x2009] = "thinSpace";
        CharacterCodes[CharacterCodes["hairSpace"] = 0x200A] = "hairSpace";
        CharacterCodes[CharacterCodes["zeroWidthSpace"] = 0x200B] = "zeroWidthSpace";
        CharacterCodes[CharacterCodes["narrowNoBreakSpace"] = 0x202F] = "narrowNoBreakSpace";
        CharacterCodes[CharacterCodes["ideographicSpace"] = 0x3000] = "ideographicSpace";

        CharacterCodes[CharacterCodes["_"] = 95] = "_";
        CharacterCodes[CharacterCodes["$"] = 36] = "$";

        CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
        CharacterCodes[CharacterCodes["_9"] = 57] = "_9";

        CharacterCodes[CharacterCodes["a"] = 97] = "a";
        CharacterCodes[CharacterCodes["b"] = 98] = "b";
        CharacterCodes[CharacterCodes["c"] = 99] = "c";
        CharacterCodes[CharacterCodes["d"] = 100] = "d";
        CharacterCodes[CharacterCodes["e"] = 101] = "e";
        CharacterCodes[CharacterCodes["f"] = 102] = "f";
        CharacterCodes[CharacterCodes["g"] = 103] = "g";
        CharacterCodes[CharacterCodes["h"] = 104] = "h";
        CharacterCodes[CharacterCodes["i"] = 105] = "i";
        CharacterCodes[CharacterCodes["k"] = 107] = "k";
        CharacterCodes[CharacterCodes["l"] = 108] = "l";
        CharacterCodes[CharacterCodes["m"] = 109] = "m";
        CharacterCodes[CharacterCodes["n"] = 110] = "n";
        CharacterCodes[CharacterCodes["o"] = 111] = "o";
        CharacterCodes[CharacterCodes["p"] = 112] = "p";
        CharacterCodes[CharacterCodes["q"] = 113] = "q";
        CharacterCodes[CharacterCodes["r"] = 114] = "r";
        CharacterCodes[CharacterCodes["s"] = 115] = "s";
        CharacterCodes[CharacterCodes["t"] = 116] = "t";
        CharacterCodes[CharacterCodes["u"] = 117] = "u";
        CharacterCodes[CharacterCodes["v"] = 118] = "v";
        CharacterCodes[CharacterCodes["w"] = 119] = "w";
        CharacterCodes[CharacterCodes["x"] = 120] = "x";
        CharacterCodes[CharacterCodes["y"] = 121] = "y";
        CharacterCodes[CharacterCodes["z"] = 122] = "z";

        CharacterCodes[CharacterCodes["A"] = 65] = "A";
        CharacterCodes[CharacterCodes["E"] = 69] = "E";
        CharacterCodes[CharacterCodes["F"] = 70] = "F";
        CharacterCodes[CharacterCodes["X"] = 88] = "X";
        CharacterCodes[CharacterCodes["Z"] = 90] = "Z";

        CharacterCodes[CharacterCodes["ampersand"] = 38] = "ampersand";
        CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
        CharacterCodes[CharacterCodes["at"] = 64] = "at";
        CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
        CharacterCodes[CharacterCodes["bar"] = 124] = "bar";
        CharacterCodes[CharacterCodes["caret"] = 94] = "caret";
        CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
        CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
        CharacterCodes[CharacterCodes["closeParen"] = 41] = "closeParen";
        CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
        CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
        CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
        CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
        CharacterCodes[CharacterCodes["equals"] = 61] = "equals";
        CharacterCodes[CharacterCodes["exclamation"] = 33] = "exclamation";
        CharacterCodes[CharacterCodes["greaterThan"] = 62] = "greaterThan";
        CharacterCodes[CharacterCodes["lessThan"] = 60] = "lessThan";
        CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
        CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
        CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
        CharacterCodes[CharacterCodes["openParen"] = 40] = "openParen";
        CharacterCodes[CharacterCodes["percent"] = 37] = "percent";
        CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
        CharacterCodes[CharacterCodes["question"] = 63] = "question";
        CharacterCodes[CharacterCodes["semicolon"] = 59] = "semicolon";
        CharacterCodes[CharacterCodes["singleQuote"] = 39] = "singleQuote";
        CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
        CharacterCodes[CharacterCodes["tilde"] = 126] = "tilde";

        CharacterCodes[CharacterCodes["backspace"] = 8] = "backspace";
        CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
        CharacterCodes[CharacterCodes["byteOrderMark"] = 0xFEFF] = "byteOrderMark";
        CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
        CharacterCodes[CharacterCodes["verticalTab"] = 11] = "verticalTab";
    })(TypeScript.CharacterCodes || (TypeScript.CharacterCodes = {}));
    var CharacterCodes = TypeScript.CharacterCodes;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (ScriptSnapshot) {
        var StringScriptSnapshot = (function () {
            function StringScriptSnapshot(text) {
                this.text = text;
            }
            StringScriptSnapshot.prototype.getText = function (start, end) {
                return this.text.substring(start, end);
            };

            StringScriptSnapshot.prototype.getLength = function () {
                return this.text.length;
            };

            StringScriptSnapshot.prototype.getLineStartPositions = function () {
                return TypeScript.TextUtilities.parseLineStarts(TypeScript.SimpleText.fromString(this.text));
            };

            StringScriptSnapshot.prototype.getTextChangeRangeSinceVersion = function (scriptVersion) {
                throw TypeScript.Errors.notYetImplemented();
            };
            return StringScriptSnapshot;
        })();

        function fromString(text) {
            return new StringScriptSnapshot(text);
        }
        ScriptSnapshot.fromString = fromString;
    })(TypeScript.ScriptSnapshot || (TypeScript.ScriptSnapshot = {}));
    var ScriptSnapshot = TypeScript.ScriptSnapshot;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var LineMap = (function () {
        function LineMap(_lineStarts, length) {
            this._lineStarts = _lineStarts;
            this.length = length;
        }
        LineMap.prototype.toJSON = function (key) {
            return { lineStarts: this._lineStarts, length: this.length };
        };

        LineMap.prototype.equals = function (other) {
            return this.length === other.length && TypeScript.ArrayUtilities.sequenceEquals(this.lineStarts(), other.lineStarts(), function (v1, v2) {
                return v1 === v2;
            });
        };

        LineMap.prototype.lineStarts = function () {
            return this._lineStarts;
        };

        LineMap.prototype.lineCount = function () {
            return this.lineStarts().length;
        };

        LineMap.prototype.getPosition = function (line, character) {
            return this.lineStarts()[line] + character;
        };

        LineMap.prototype.getLineNumberFromPosition = function (position) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            if (position === this.length) {
                return this.lineCount() - 1;
            }

            var lineNumber = TypeScript.ArrayUtilities.binarySearch(this.lineStarts(), position);
            if (lineNumber < 0) {
                lineNumber = (~lineNumber) - 1;
            }

            return lineNumber;
        };

        LineMap.prototype.getLineStartPosition = function (lineNumber) {
            return this.lineStarts()[lineNumber];
        };

        LineMap.prototype.fillLineAndCharacterFromPosition = function (position, lineAndCharacter) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var lineNumber = this.getLineNumberFromPosition(position);
            lineAndCharacter.line = lineNumber;
            lineAndCharacter.character = position - this.lineStarts()[lineNumber];
        };

        LineMap.prototype.getLineAndCharacterFromPosition = function (position) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var lineNumber = this.getLineNumberFromPosition(position);

            return new TypeScript.LineAndCharacter(lineNumber, position - this.lineStarts()[lineNumber]);
        };

        LineMap.fromSimpleText = function (text) {
            var lineStarts = TypeScript.TextUtilities.parseLineStarts(text);

            return new LineMap(lineStarts, text.length());
        };

        LineMap.fromScriptSnapshot = function (scriptSnapshot) {
            return new LineMap(scriptSnapshot.getLineStartPositions(), scriptSnapshot.getLength());
        };

        LineMap.fromString = function (text) {
            return LineMap.fromSimpleText(TypeScript.SimpleText.fromString(text));
        };
        LineMap.empty = new LineMap([0], 0);
        return LineMap;
    })();
    TypeScript.LineMap = LineMap;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var LineAndCharacter = (function () {
        function LineAndCharacter(line, character) {
            this._line = 0;
            this._character = 0;
            if (line < 0) {
                throw TypeScript.Errors.argumentOutOfRange("line");
            }

            if (character < 0) {
                throw TypeScript.Errors.argumentOutOfRange("character");
            }

            this._line = line;
            this._character = character;
        }
        LineAndCharacter.prototype.line = function () {
            return this._line;
        };

        LineAndCharacter.prototype.character = function () {
            return this._character;
        };
        return LineAndCharacter;
    })();
    TypeScript.LineAndCharacter = LineAndCharacter;
})(TypeScript || (TypeScript = {}));
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var TypeScript;
(function (TypeScript) {
    (function (TextFactory) {
        function getStartAndLengthOfLineBreakEndingAt(text, index, info) {
            var c = text.charCodeAt(index);
            if (c === 10 /* lineFeed */) {
                if (index > 0 && text.charCodeAt(index - 1) === 13 /* carriageReturn */) {
                    info.startPosition = index - 1;
                    info.length = 2;
                } else {
                    info.startPosition = index;
                    info.length = 1;
                }
            } else if (TypeScript.TextUtilities.isAnyLineBreakCharacter(c)) {
                info.startPosition = index;
                info.length = 1;
            } else {
                info.startPosition = index + 1;
                info.length = 0;
            }
        }

        var LinebreakInfo = (function () {
            function LinebreakInfo(startPosition, length) {
                this.startPosition = startPosition;
                this.length = length;
            }
            return LinebreakInfo;
        })();

        var TextLine = (function () {
            function TextLine(text, body, lineBreakLength, lineNumber) {
                this._text = null;
                this._textSpan = null;
                TypeScript.Contract.throwIfNull(text);
                TypeScript.Contract.throwIfFalse(lineBreakLength >= 0);
                TypeScript.Contract.requires(lineNumber >= 0);
                this._text = text;
                this._textSpan = body;
                this._lineBreakLength = lineBreakLength;
                this._lineNumber = lineNumber;
            }
            TextLine.prototype.start = function () {
                return this._textSpan.start();
            };

            TextLine.prototype.end = function () {
                return this._textSpan.end();
            };

            TextLine.prototype.endIncludingLineBreak = function () {
                return this.end() + this._lineBreakLength;
            };

            TextLine.prototype.extent = function () {
                return this._textSpan;
            };

            TextLine.prototype.extentIncludingLineBreak = function () {
                return TypeScript.TextSpan.fromBounds(this.start(), this.endIncludingLineBreak());
            };

            TextLine.prototype.toString = function () {
                return this._text.toString(this._textSpan);
            };

            TextLine.prototype.lineNumber = function () {
                return this._lineNumber;
            };
            return TextLine;
        })();

        var TextBase = (function () {
            function TextBase() {
                this.lazyLineStarts = null;
                this.linebreakInfo = new LinebreakInfo(0, 0);
                this.lastLineFoundForPosition = null;
            }
            TextBase.prototype.length = function () {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.charCodeAt = function (position) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.checkSubSpan = function (span) {
                if (span.start() < 0 || span.start() > this.length() || span.end() > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("span");
                }
            };

            TextBase.prototype.toString = function (span) {
                if (typeof span === "undefined") { span = null; }
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SubText(this, span);
            };

            TextBase.prototype.substr = function (start, length, intern) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.lineCount = function () {
                return this.lineStarts().length;
            };

            TextBase.prototype.lines = function () {
                var lines = [];

                var length = this.lineCount();
                for (var i = 0; i < length; ++i) {
                    lines[i] = this.getLineFromLineNumber(i);
                }

                return lines;
            };

            TextBase.prototype.lineMap = function () {
                return new TypeScript.LineMap(this.lineStarts(), this.length());
            };

            TextBase.prototype.lineStarts = function () {
                if (this.lazyLineStarts === null) {
                    this.lazyLineStarts = TypeScript.TextUtilities.parseLineStarts(this);
                }

                return this.lazyLineStarts;
            };

            TextBase.prototype.getLineFromLineNumber = function (lineNumber) {
                var lineStarts = this.lineStarts();

                if (lineNumber < 0 || lineNumber >= lineStarts.length) {
                    throw TypeScript.Errors.argumentOutOfRange("lineNumber");
                }

                var first = lineStarts[lineNumber];
                if (lineNumber === lineStarts.length - 1) {
                    return new TextLine(this, new TypeScript.TextSpan(first, this.length() - first), 0, lineNumber);
                } else {
                    getStartAndLengthOfLineBreakEndingAt(this, lineStarts[lineNumber + 1] - 1, this.linebreakInfo);
                    return new TextLine(this, new TypeScript.TextSpan(first, this.linebreakInfo.startPosition - first), this.linebreakInfo.length, lineNumber);
                }
            };

            TextBase.prototype.getLineFromPosition = function (position) {
                var lastFound = this.lastLineFoundForPosition;
                if (lastFound !== null && lastFound.start() <= position && lastFound.endIncludingLineBreak() > position) {
                    return lastFound;
                }

                var lineNumber = this.getLineNumberFromPosition(position);

                var result = this.getLineFromLineNumber(lineNumber);
                this.lastLineFoundForPosition = result;
                return result;
            };

            TextBase.prototype.getLineNumberFromPosition = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                if (position === this.length()) {
                    return this.lineCount() - 1;
                }

                var lineNumber = TypeScript.ArrayUtilities.binarySearch(this.lineStarts(), position);
                if (lineNumber < 0) {
                    lineNumber = (~lineNumber) - 1;
                }

                return lineNumber;
            };

            TextBase.prototype.getLinePosition = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                var lineNumber = this.getLineNumberFromPosition(position);

                return new TypeScript.LineAndCharacter(lineNumber, position - this.lineStarts()[lineNumber]);
            };
            return TextBase;
        })();

        var SubText = (function (_super) {
            __extends(SubText, _super);
            function SubText(text, span) {
                _super.call(this);

                if (text === null) {
                    throw TypeScript.Errors.argumentNull("text");
                }

                if (span.start() < 0 || span.start() >= text.length() || span.end() < 0 || span.end() > text.length()) {
                    throw TypeScript.Errors.argument("span");
                }

                this.text = text;
                this.span = span;
            }
            SubText.prototype.length = function () {
                return this.span.length();
            };

            SubText.prototype.charCodeAt = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                return this.text.charCodeAt(this.span.start() + position);
            };

            SubText.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SubText(this.text, this.getCompositeSpan(span.start(), span.length()));
            };

            SubText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var span = this.getCompositeSpan(sourceIndex, count);
                this.text.copyTo(span.start(), destination, destinationIndex, span.length());
            };

            SubText.prototype.getCompositeSpan = function (start, length) {
                var compositeStart = TypeScript.MathPrototype.min(this.text.length(), this.span.start() + start);
                var compositeEnd = TypeScript.MathPrototype.min(this.text.length(), compositeStart + length);
                return new TypeScript.TextSpan(compositeStart, compositeEnd - compositeStart);
            };
            return SubText;
        })(TextBase);

        var StringText = (function (_super) {
            __extends(StringText, _super);
            function StringText(data) {
                _super.call(this);
                this.source = null;

                if (data === null) {
                    throw TypeScript.Errors.argumentNull("data");
                }

                this.source = data;
            }
            StringText.prototype.length = function () {
                return this.source.length;
            };

            StringText.prototype.charCodeAt = function (position) {
                if (position < 0 || position >= this.source.length) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                return this.source.charCodeAt(position);
            };

            StringText.prototype.substr = function (start, length, intern) {
                return this.source.substr(start, length);
            };

            StringText.prototype.toString = function (span) {
                if (typeof span === "undefined") { span = null; }
                if (span === null) {
                    span = new TypeScript.TextSpan(0, this.length());
                }

                this.checkSubSpan(span);

                if (span.start() === 0 && span.length() === this.length()) {
                    return this.source;
                }

                return this.source.substr(span.start(), span.length());
            };

            StringText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                TypeScript.StringUtilities.copyTo(this.source, sourceIndex, destination, destinationIndex, count);
            };
            return StringText;
        })(TextBase);

        function createText(value) {
            return new StringText(value);
        }
        TextFactory.createText = createText;
    })(TypeScript.TextFactory || (TypeScript.TextFactory = {}));
    var TextFactory = TypeScript.TextFactory;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (SimpleText) {
        var SimpleSubText = (function () {
            function SimpleSubText(text, span) {
                this.text = null;
                this.span = null;
                if (text === null) {
                    throw TypeScript.Errors.argumentNull("text");
                }

                if (span.start() < 0 || span.start() >= text.length() || span.end() < 0 || span.end() > text.length()) {
                    throw TypeScript.Errors.argument("span");
                }

                this.text = text;
                this.span = span;
            }
            SimpleSubText.prototype.checkSubSpan = function (span) {
                if (span.start() < 0 || span.start() > this.length() || span.end() > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("span");
                }
            };

            SimpleSubText.prototype.checkSubPosition = function (position) {
                if (position < 0 || position >= this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }
            };

            SimpleSubText.prototype.length = function () {
                return this.span.length();
            };

            SimpleSubText.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SimpleSubText(this.text, this.getCompositeSpan(span.start(), span.length()));
            };

            SimpleSubText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var span = this.getCompositeSpan(sourceIndex, count);
                this.text.copyTo(span.start(), destination, destinationIndex, span.length());
            };

            SimpleSubText.prototype.substr = function (start, length, intern) {
                var span = this.getCompositeSpan(start, length);
                return this.text.substr(span.start(), span.length(), intern);
            };

            SimpleSubText.prototype.getCompositeSpan = function (start, length) {
                var compositeStart = TypeScript.MathPrototype.min(this.text.length(), this.span.start() + start);
                var compositeEnd = TypeScript.MathPrototype.min(this.text.length(), compositeStart + length);
                return new TypeScript.TextSpan(compositeStart, compositeEnd - compositeStart);
            };

            SimpleSubText.prototype.charCodeAt = function (index) {
                this.checkSubPosition(index);
                return this.text.charCodeAt(this.span.start() + index);
            };

            SimpleSubText.prototype.lineMap = function () {
                return TypeScript.LineMap.fromSimpleText(this);
            };
            return SimpleSubText;
        })();

        var SimpleStringText = (function () {
            function SimpleStringText(value) {
                this.value = value;
            }
            SimpleStringText.prototype.length = function () {
                return this.value.length;
            };

            SimpleStringText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                TypeScript.StringUtilities.copyTo(this.value, sourceIndex, destination, destinationIndex, count);
            };

            SimpleStringText.prototype.substr = function (start, length, intern) {
                if (intern) {
                    var array = length <= SimpleStringText.charArray.length ? SimpleStringText.charArray : TypeScript.ArrayUtilities.createArray(length, 0);
                    this.copyTo(start, array, 0, length);
                    return TypeScript.Collections.DefaultStringTable.addCharArray(array, 0, length);
                }

                return this.value.substr(start, length);
            };

            SimpleStringText.prototype.subText = function (span) {
                return new SimpleSubText(this, span);
            };

            SimpleStringText.prototype.charCodeAt = function (index) {
                return this.value.charCodeAt(index);
            };

            SimpleStringText.prototype.lineMap = function () {
                return TypeScript.LineMap.fromSimpleText(this);
            };
            SimpleStringText.charArray = TypeScript.ArrayUtilities.createArray(1024, 0);
            return SimpleStringText;
        })();

        var SimpleScriptSnapshotText = (function () {
            function SimpleScriptSnapshotText(scriptSnapshot) {
                this.scriptSnapshot = scriptSnapshot;
            }
            SimpleScriptSnapshotText.prototype.charCodeAt = function (index) {
                return this.scriptSnapshot.getText(index, index + 1).charCodeAt(0);
            };

            SimpleScriptSnapshotText.prototype.length = function () {
                return this.scriptSnapshot.getLength();
            };

            SimpleScriptSnapshotText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var text = this.scriptSnapshot.getText(sourceIndex, sourceIndex + count);
                TypeScript.StringUtilities.copyTo(text, 0, destination, destinationIndex, count);
            };

            SimpleScriptSnapshotText.prototype.substr = function (start, length, intern) {
                return this.scriptSnapshot.getText(start, start + length);
            };

            SimpleScriptSnapshotText.prototype.subText = function (span) {
                return new SimpleSubText(this, span);
            };

            SimpleScriptSnapshotText.prototype.lineMap = function () {
                var lineStartPositions = this.scriptSnapshot.getLineStartPositions();
                return new TypeScript.LineMap(lineStartPositions, this.length());
            };
            return SimpleScriptSnapshotText;
        })();

        function fromString(value) {
            return new SimpleStringText(value);
        }
        SimpleText.fromString = fromString;

        function fromScriptSnapshot(scriptSnapshot) {
            return new SimpleScriptSnapshotText(scriptSnapshot);
        }
        SimpleText.fromScriptSnapshot = fromScriptSnapshot;
    })(TypeScript.SimpleText || (TypeScript.SimpleText = {}));
    var SimpleText = TypeScript.SimpleText;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (TextUtilities) {
        function parseLineStarts(text) {
            var length = text.length();

            if (0 === length) {
                var result = [];
                result.push(0);
                return result;
            }

            var position = 0;
            var index = 0;
            var arrayBuilder = [];
            var lineNumber = 0;

            while (index < length) {
                var c = text.charCodeAt(index);
                var lineBreakLength;

                if (c > 13 /* carriageReturn */ && c <= 127) {
                    index++;
                    continue;
                } else if (c === 13 /* carriageReturn */ && index + 1 < length && text.charCodeAt(index + 1) === 10 /* lineFeed */) {
                    lineBreakLength = 2;
                } else if (c === 10 /* lineFeed */) {
                    lineBreakLength = 1;
                } else {
                    lineBreakLength = TextUtilities.getLengthOfLineBreak(text, index);
                }

                if (0 === lineBreakLength) {
                    index++;
                } else {
                    arrayBuilder.push(position);
                    index += lineBreakLength;
                    position = index;
                    lineNumber++;
                }
            }

            arrayBuilder.push(position);

            return arrayBuilder;
        }
        TextUtilities.parseLineStarts = parseLineStarts;

        function getLengthOfLineBreakSlow(text, index, c) {
            if (c === 13 /* carriageReturn */) {
                var next = index + 1;
                return (next < text.length()) && 10 /* lineFeed */ === text.charCodeAt(next) ? 2 : 1;
            } else if (isAnyLineBreakCharacter(c)) {
                return 1;
            } else {
                return 0;
            }
        }
        TextUtilities.getLengthOfLineBreakSlow = getLengthOfLineBreakSlow;

        function getLengthOfLineBreak(text, index) {
            var c = text.charCodeAt(index);

            if (c > 13 /* carriageReturn */ && c <= 127) {
                return 0;
            }

            return getLengthOfLineBreakSlow(text, index, c);
        }
        TextUtilities.getLengthOfLineBreak = getLengthOfLineBreak;

        function isAnyLineBreakCharacter(c) {
            return c === 10 /* lineFeed */ || c === 13 /* carriageReturn */ || c === 133 /* nextLine */ || c === 8232 /* lineSeparator */ || c === 8233 /* paragraphSeparator */;
        }
        TextUtilities.isAnyLineBreakCharacter = isAnyLineBreakCharacter;
    })(TypeScript.TextUtilities || (TypeScript.TextUtilities = {}));
    var TextUtilities = TypeScript.TextUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var TextSpan = (function () {
        function TextSpan(start, length) {
            if (start < 0) {
                TypeScript.Errors.argument("start");
            }

            if (start + length < start) {
                throw new Error("length");
            }

            this._start = start;
            this._length = length;
        }
        TextSpan.prototype.start = function () {
            return this._start;
        };

        TextSpan.prototype.length = function () {
            return this._length;
        };

        TextSpan.prototype.end = function () {
            return this._start + this._length;
        };

        TextSpan.prototype.isEmpty = function () {
            return this._length === 0;
        };

        TextSpan.prototype.containsPosition = function (position) {
            return position >= this._start && position < this.end();
        };

        TextSpan.prototype.containsTextSpan = function (span) {
            return span._start >= this._start && span.end() <= this.end();
        };

        TextSpan.prototype.overlapsWith = function (span) {
            var overlapStart = TypeScript.MathPrototype.max(this._start, span._start);
            var overlapEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            return overlapStart < overlapEnd;
        };

        TextSpan.prototype.overlap = function (span) {
            var overlapStart = TypeScript.MathPrototype.max(this._start, span._start);
            var overlapEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            if (overlapStart < overlapEnd) {
                return TextSpan.fromBounds(overlapStart, overlapEnd);
            }

            return null;
        };

        TextSpan.prototype.intersectsWithTextSpan = function (span) {
            return span._start <= this.end() && span.end() >= this._start;
        };

        TextSpan.prototype.intersectsWith = function (start, length) {
            var end = start + length;
            return start <= this.end() && end >= this._start;
        };

        TextSpan.prototype.intersectsWithPosition = function (position) {
            return position <= this.end() && position >= this._start;
        };

        TextSpan.prototype.intersection = function (span) {
            var intersectStart = TypeScript.MathPrototype.max(this._start, span._start);
            var intersectEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            if (intersectStart <= intersectEnd) {
                return TextSpan.fromBounds(intersectStart, intersectEnd);
            }

            return null;
        };

        TextSpan.fromBounds = function (start, end) {
            TypeScript.Contract.requires(start >= 0);
            TypeScript.Contract.requires(end - start >= 0);
            return new TextSpan(start, end - start);
        };
        return TextSpan;
    })();
    TypeScript.TextSpan = TextSpan;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var TextChangeRange = (function () {
        function TextChangeRange(span, newLength) {
            if (newLength < 0) {
                throw TypeScript.Errors.argumentOutOfRange("newLength");
            }

            this._span = span;
            this._newLength = newLength;
        }
        TextChangeRange.prototype.span = function () {
            return this._span;
        };

        TextChangeRange.prototype.newLength = function () {
            return this._newLength;
        };

        TextChangeRange.prototype.newSpan = function () {
            return new TypeScript.TextSpan(this.span().start(), this.newLength());
        };

        TextChangeRange.prototype.isUnchanged = function () {
            return this.span().isEmpty() && this.newLength() === 0;
        };

        TextChangeRange.collapseChangesFromSingleVersion = function (changes) {
            var diff = 0;
            var start = 1073741823 /* Max31BitInteger */;
            var end = 0;

            for (var i = 0; i < changes.length; i++) {
                var change = changes[i];
                diff += change.newLength() - change.span().length();

                if (change.span().start() < start) {
                    start = change.span().start();
                }

                if (change.span().end() > end) {
                    end = change.span().end();
                }
            }

            if (start > end) {
                return null;
            }

            var combined = TypeScript.TextSpan.fromBounds(start, end);
            var newLen = combined.length() + diff;

            return new TextChangeRange(combined, newLen);
        };

        TextChangeRange.collapseChangesAcrossMultipleVersions = function (changes) {
            if (changes.length === 0) {
                return TextChangeRange.unchanged;
            }

            if (changes.length === 1) {
                return changes[0];
            }

            var change0 = changes[0];

            var oldStartN = change0.span().start();
            var oldEndN = change0.span().end();
            var newEndN = oldStartN + change0.newLength();

            for (var i = 1; i < changes.length; i++) {
                var nextChange = changes[i];

                var oldStart1 = oldStartN;
                var oldEnd1 = oldEndN;
                var newEnd1 = newEndN;

                var oldStart2 = nextChange.span().start();
                var oldEnd2 = nextChange.span().end();
                var newEnd2 = oldStart2 + nextChange.newLength();

                oldStartN = TypeScript.MathPrototype.min(oldStart1, oldStart2);
                oldEndN = TypeScript.MathPrototype.max(oldEnd1, oldEnd1 + (oldEnd2 - newEnd1));
                newEndN = TypeScript.MathPrototype.max(newEnd2, newEnd2 + (newEnd1 - oldEnd2));
            }

            return new TextChangeRange(TypeScript.TextSpan.fromBounds(oldStartN, oldEndN), newEndN - oldStartN);
        };
        TextChangeRange.unchanged = new TextChangeRange(new TypeScript.TextSpan(0, 0), 0);
        return TextChangeRange;
    })();
    TypeScript.TextChangeRange = TextChangeRange;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var CharacterInfo = (function () {
        function CharacterInfo() {
        }
        CharacterInfo.isDecimalDigit = function (c) {
            return c >= 48 /* _0 */ && c <= 57 /* _9 */;
        };

        CharacterInfo.isHexDigit = function (c) {
            return CharacterInfo.isDecimalDigit(c) || (c >= 65 /* A */ && c <= 70 /* F */) || (c >= 97 /* a */ && c <= 102 /* f */);
        };

        CharacterInfo.hexValue = function (c) {
            return CharacterInfo.isDecimalDigit(c) ? (c - 48 /* _0 */) : (c >= 65 /* A */ && c <= 70 /* F */) ? c - 65 /* A */ + 10 : c - 97 /* a */ + 10;
        };

        CharacterInfo.isWhitespace = function (ch) {
            switch (ch) {
                case 32 /* space */:
                case 160 /* nonBreakingSpace */:
                case 8192 /* enQuad */:
                case 8193 /* emQuad */:
                case 8194 /* enSpace */:
                case 8195 /* emSpace */:
                case 8196 /* threePerEmSpace */:
                case 8197 /* fourPerEmSpace */:
                case 8198 /* sixPerEmSpace */:
                case 8199 /* figureSpace */:
                case 8200 /* punctuationSpace */:
                case 8201 /* thinSpace */:
                case 8202 /* hairSpace */:
                case 8203 /* zeroWidthSpace */:
                case 8239 /* narrowNoBreakSpace */:
                case 12288 /* ideographicSpace */:

                case 9 /* tab */:
                case 11 /* verticalTab */:
                case 12 /* formFeed */:
                case 65279 /* byteOrderMark */:
                    return true;
            }

            return false;
        };

        CharacterInfo.isLineTerminator = function (ch) {
            switch (ch) {
                case 13 /* carriageReturn */:
                case 10 /* lineFeed */:
                case 8233 /* paragraphSeparator */:
                case 8232 /* lineSeparator */:
                    return true;
            }

            return false;
        };
        return CharacterInfo;
    })();
    TypeScript.CharacterInfo = CharacterInfo;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxConstants) {
        SyntaxConstants[SyntaxConstants["TriviaNewLineMask"] = 0x00000001] = "TriviaNewLineMask";
        SyntaxConstants[SyntaxConstants["TriviaCommentMask"] = 0x00000002] = "TriviaCommentMask";
        SyntaxConstants[SyntaxConstants["TriviaFullWidthShift"] = 2] = "TriviaFullWidthShift";

        SyntaxConstants[SyntaxConstants["NodeDataComputed"] = 0x00000001] = "NodeDataComputed";
        SyntaxConstants[SyntaxConstants["NodeIncrementallyUnusableMask"] = 0x00000002] = "NodeIncrementallyUnusableMask";
        SyntaxConstants[SyntaxConstants["NodeParsedInStrictModeMask"] = 0x00000004] = "NodeParsedInStrictModeMask";
        SyntaxConstants[SyntaxConstants["NodeFullWidthShift"] = 3] = "NodeFullWidthShift";
    })(TypeScript.SyntaxConstants || (TypeScript.SyntaxConstants = {}));
    var SyntaxConstants = TypeScript.SyntaxConstants;
})(TypeScript || (TypeScript = {}));
var FormattingOptions = (function () {
    function FormattingOptions(useTabs, spacesPerTab, indentSpaces, newLineCharacter) {
        this.useTabs = useTabs;
        this.spacesPerTab = spacesPerTab;
        this.indentSpaces = indentSpaces;
        this.newLineCharacter = newLineCharacter;
    }
    FormattingOptions.defaultOptions = new FormattingOptions(false, 4, 4, "\r\n");
    return FormattingOptions;
})();
var TypeScript;
(function (TypeScript) {
    (function (Indentation) {
        function columnForEndOfToken(token, syntaxInformationMap, options) {
            return columnForStartOfToken(token, syntaxInformationMap, options) + token.width();
        }
        Indentation.columnForEndOfToken = columnForEndOfToken;

        function columnForStartOfToken(token, syntaxInformationMap, options) {
            var firstTokenInLine = syntaxInformationMap.firstTokenInLineContainingToken(token);
            var leadingTextInReverse = [];

            var current = token;
            while (current !== firstTokenInLine) {
                current = syntaxInformationMap.previousToken(current);

                if (current === firstTokenInLine) {
                    leadingTextInReverse.push(current.trailingTrivia().fullText());
                    leadingTextInReverse.push(current.text());
                } else {
                    leadingTextInReverse.push(current.fullText());
                }
            }

            collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse);

            return columnForLeadingTextInReverse(leadingTextInReverse, options);
        }
        Indentation.columnForStartOfToken = columnForStartOfToken;

        function columnForStartOfFirstTokenInLineContainingToken(token, syntaxInformationMap, options) {
            var firstTokenInLine = syntaxInformationMap.firstTokenInLineContainingToken(token);
            var leadingTextInReverse = [];

            collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse);

            return columnForLeadingTextInReverse(leadingTextInReverse, options);
        }
        Indentation.columnForStartOfFirstTokenInLineContainingToken = columnForStartOfFirstTokenInLineContainingToken;

        function collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse) {
            var leadingTrivia = firstTokenInLine.leadingTrivia();

            for (var i = leadingTrivia.count() - 1; i >= 0; i--) {
                var trivia = leadingTrivia.syntaxTriviaAt(i);
                if (trivia.kind() === 5 /* NewLineTrivia */) {
                    break;
                }

                if (trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                    var lineSegments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);
                    leadingTextInReverse.push(TypeScript.ArrayUtilities.last(lineSegments));

                    if (lineSegments.length > 0) {
                        break;
                    }
                }

                leadingTextInReverse.push(trivia.fullText());
            }
        }

        function columnForLeadingTextInReverse(leadingTextInReverse, options) {
            var column = 0;

            for (var i = leadingTextInReverse.length - 1; i >= 0; i--) {
                var text = leadingTextInReverse[i];
                column = columnForPositionInStringWorker(text, text.length, column, options);
            }

            return column;
        }

        function columnForPositionInString(input, position, options) {
            return columnForPositionInStringWorker(input, position, 0, options);
        }
        Indentation.columnForPositionInString = columnForPositionInString;

        function columnForPositionInStringWorker(input, position, startColumn, options) {
            var column = startColumn;
            var spacesPerTab = options.spacesPerTab;

            for (var j = 0; j < position; j++) {
                var ch = input.charCodeAt(j);

                if (ch === 9 /* tab */) {
                    column += spacesPerTab - column % spacesPerTab;
                } else {
                    column++;
                }
            }

            return column;
        }

        function indentationString(column, options) {
            var numberOfTabs = 0;
            var numberOfSpaces = TypeScript.MathPrototype.max(0, column);

            if (options.useTabs) {
                numberOfTabs = Math.floor(column / options.spacesPerTab);
                numberOfSpaces -= numberOfTabs * options.spacesPerTab;
            }

            return TypeScript.StringUtilities.repeat('\t', numberOfTabs) + TypeScript.StringUtilities.repeat(' ', numberOfSpaces);
        }
        Indentation.indentationString = indentationString;

        function indentationTrivia(column, options) {
            return TypeScript.Syntax.whitespace(this.indentationString(column, options));
        }
        Indentation.indentationTrivia = indentationTrivia;

        function firstNonWhitespacePosition(value) {
            for (var i = 0; i < value.length; i++) {
                var ch = value.charCodeAt(i);
                if (!TypeScript.CharacterInfo.isWhitespace(ch)) {
                    return i;
                }
            }

            return value.length;
        }
        Indentation.firstNonWhitespacePosition = firstNonWhitespacePosition;
    })(TypeScript.Indentation || (TypeScript.Indentation = {}));
    var Indentation = TypeScript.Indentation;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (LanguageVersion) {
        LanguageVersion[LanguageVersion["EcmaScript3"] = 0] = "EcmaScript3";
        LanguageVersion[LanguageVersion["EcmaScript5"] = 1] = "EcmaScript5";
    })(TypeScript.LanguageVersion || (TypeScript.LanguageVersion = {}));
    var LanguageVersion = TypeScript.LanguageVersion;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var ParseOptions = (function () {
        function ParseOptions(allowAutomaticSemicolonInsertion, allowModuleKeywordInExternalModuleReference) {
            this._allowAutomaticSemicolonInsertion = allowAutomaticSemicolonInsertion;
            this._allowModuleKeywordInExternalModuleReference = allowModuleKeywordInExternalModuleReference;
        }
        ParseOptions.prototype.toJSON = function (key) {
            return {
                allowAutomaticSemicolonInsertion: this._allowAutomaticSemicolonInsertion,
                allowModuleKeywordInExternalModuleReference: this._allowModuleKeywordInExternalModuleReference
            };
        };

        ParseOptions.prototype.allowAutomaticSemicolonInsertion = function () {
            return this._allowAutomaticSemicolonInsertion;
        };

        ParseOptions.prototype.allowModuleKeywordInExternalModuleReference = function () {
            return this._allowModuleKeywordInExternalModuleReference;
        };
        return ParseOptions;
    })();
    TypeScript.ParseOptions = ParseOptions;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var PositionedElement = (function () {
        function PositionedElement(parent, element, fullStart) {
            this._parent = parent;
            this._element = element;
            this._fullStart = fullStart;
        }
        PositionedElement.create = function (parent, element, fullStart) {
            if (element === null) {
                return null;
            }

            if (element.isNode()) {
                return new PositionedNode(parent, element, fullStart);
            } else if (element.isToken()) {
                return new PositionedToken(parent, element, fullStart);
            } else if (element.isList()) {
                return new PositionedList(parent, element, fullStart);
            } else if (element.isSeparatedList()) {
                return new PositionedSeparatedList(parent, element, fullStart);
            } else {
                throw TypeScript.Errors.invalidOperation();
            }
        };

        PositionedElement.prototype.parent = function () {
            return this._parent;
        };

        PositionedElement.prototype.parentElement = function () {
            return this._parent && this._parent._element;
        };

        PositionedElement.prototype.element = function () {
            return this._element;
        };

        PositionedElement.prototype.kind = function () {
            return this.element().kind();
        };

        PositionedElement.prototype.childIndex = function (child) {
            return TypeScript.Syntax.childIndex(this.element(), child);
        };

        PositionedElement.prototype.childCount = function () {
            return this.element().childCount();
        };

        PositionedElement.prototype.childAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            return PositionedElement.create(this, this.element().childAt(index), this.fullStart() + offset);
        };

        PositionedElement.prototype.childStart = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return this.fullStart() + offset + child.leadingTriviaWidth();
        };

        PositionedElement.prototype.childEnd = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return this.fullStart() + offset + child.leadingTriviaWidth() + child.width();
        };

        PositionedElement.prototype.childStartAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            var child = this.element().childAt(index);
            return this.fullStart() + offset + child.leadingTriviaWidth();
        };

        PositionedElement.prototype.childEndAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            var child = this.element().childAt(index);
            return this.fullStart() + offset + child.leadingTriviaWidth() + child.width();
        };

        PositionedElement.prototype.getPositionedChild = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return PositionedElement.create(this, child, this.fullStart() + offset);
        };

        PositionedElement.prototype.fullStart = function () {
            return this._fullStart;
        };

        PositionedElement.prototype.fullEnd = function () {
            return this.fullStart() + this.element().fullWidth();
        };

        PositionedElement.prototype.fullWidth = function () {
            return this.element().fullWidth();
        };

        PositionedElement.prototype.start = function () {
            return this.fullStart() + this.element().leadingTriviaWidth();
        };

        PositionedElement.prototype.end = function () {
            return this.fullStart() + this.element().leadingTriviaWidth() + this.element().width();
        };

        PositionedElement.prototype.root = function () {
            var current = this;
            while (current.parent() !== null) {
                current = current.parent();
            }

            return current;
        };

        PositionedElement.prototype.containingNode = function () {
            var current = this.parent();

            while (current !== null && !current.element().isNode()) {
                current = current.parent();
            }

            return current;
        };
        return PositionedElement;
    })();
    TypeScript.PositionedElement = PositionedElement;

    var PositionedNodeOrToken = (function (_super) {
        __extends(PositionedNodeOrToken, _super);
        function PositionedNodeOrToken(parent, nodeOrToken, fullStart) {
            _super.call(this, parent, nodeOrToken, fullStart);
        }
        PositionedNodeOrToken.prototype.nodeOrToken = function () {
            return this.element();
        };
        return PositionedNodeOrToken;
    })(PositionedElement);
    TypeScript.PositionedNodeOrToken = PositionedNodeOrToken;

    var PositionedNode = (function (_super) {
        __extends(PositionedNode, _super);
        function PositionedNode(parent, node, fullStart) {
            _super.call(this, parent, node, fullStart);
        }
        PositionedNode.prototype.node = function () {
            return this.element();
        };
        return PositionedNode;
    })(PositionedNodeOrToken);
    TypeScript.PositionedNode = PositionedNode;

    var PositionedToken = (function (_super) {
        __extends(PositionedToken, _super);
        function PositionedToken(parent, token, fullStart) {
            _super.call(this, parent, token, fullStart);
        }
        PositionedToken.prototype.token = function () {
            return this.element();
        };

        PositionedToken.prototype.previousToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var triviaList = this.token().leadingTrivia();
            if (includeSkippedTokens && triviaList && triviaList.hasSkippedToken()) {
                var currentTriviaEndPosition = this.start();
                for (var i = triviaList.count() - 1; i >= 0; i--) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (trivia.isSkippedToken()) {
                        return new PositionedSkippedToken(this, trivia.skippedToken(), currentTriviaEndPosition - trivia.fullWidth());
                    }

                    currentTriviaEndPosition -= trivia.fullWidth();
                }
            }

            var start = this.fullStart();
            if (start === 0) {
                return null;
            }

            return this.root().node().findToken(start - 1, includeSkippedTokens);
        };

        PositionedToken.prototype.nextToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            if (this.token().tokenKind === 10 /* EndOfFileToken */) {
                return null;
            }

            var triviaList = this.token().trailingTrivia();
            if (includeSkippedTokens && triviaList && triviaList.hasSkippedToken()) {
                var fullStart = this.end();
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (trivia.isSkippedToken()) {
                        return new PositionedSkippedToken(this, trivia.skippedToken(), fullStart);
                    }

                    fullStart += trivia.fullWidth();
                }
            }

            return this.root().node().findToken(this.fullEnd(), includeSkippedTokens);
        };
        return PositionedToken;
    })(PositionedNodeOrToken);
    TypeScript.PositionedToken = PositionedToken;

    var PositionedList = (function (_super) {
        __extends(PositionedList, _super);
        function PositionedList(parent, list, fullStart) {
            _super.call(this, parent, list, fullStart);
        }
        PositionedList.prototype.list = function () {
            return this.element();
        };
        return PositionedList;
    })(PositionedElement);
    TypeScript.PositionedList = PositionedList;

    var PositionedSeparatedList = (function (_super) {
        __extends(PositionedSeparatedList, _super);
        function PositionedSeparatedList(parent, list, fullStart) {
            _super.call(this, parent, list, fullStart);
        }
        PositionedSeparatedList.prototype.list = function () {
            return this.element();
        };
        return PositionedSeparatedList;
    })(PositionedElement);
    TypeScript.PositionedSeparatedList = PositionedSeparatedList;

    var PositionedSkippedToken = (function (_super) {
        __extends(PositionedSkippedToken, _super);
        function PositionedSkippedToken(parentToken, token, fullStart) {
            _super.call(this, parentToken.parent(), token, fullStart);
            this._parentToken = parentToken;
        }
        PositionedSkippedToken.prototype.parentToken = function () {
            return this._parentToken;
        };

        PositionedSkippedToken.prototype.previousToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var start = this.fullStart();

            if (includeSkippedTokens) {
                var previousToken;

                if (start >= this.parentToken().end()) {
                    previousToken = TypeScript.Syntax.findSkippedTokenInTrailingTriviaList(this.parentToken(), start - 1);

                    if (previousToken) {
                        return previousToken;
                    }

                    return this.parentToken();
                } else {
                    previousToken = TypeScript.Syntax.findSkippedTokenInLeadingTriviaList(this.parentToken(), start - 1);

                    if (previousToken) {
                        return previousToken;
                    }
                }
            }

            var start = this.parentToken().fullStart();
            if (start === 0) {
                return null;
            }

            return this.root().node().findToken(start - 1, includeSkippedTokens);
        };

        PositionedSkippedToken.prototype.nextToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            if (this.token().tokenKind === 10 /* EndOfFileToken */) {
                return null;
            }

            if (includeSkippedTokens) {
                var end = this.end();
                var nextToken;

                if (end <= this.parentToken().start()) {
                    nextToken = TypeScript.Syntax.findSkippedTokenInLeadingTriviaList(this.parentToken(), end);

                    if (nextToken) {
                        return nextToken;
                    }

                    return this.parentToken();
                } else {
                    nextToken = TypeScript.Syntax.findSkippedTokenInTrailingTriviaList(this.parentToken(), end);

                    if (nextToken) {
                        return nextToken;
                    }
                }
            }

            return this.root().node().findToken(this.parentToken().fullEnd(), includeSkippedTokens);
        };
        return PositionedSkippedToken;
    })(PositionedToken);
    TypeScript.PositionedSkippedToken = PositionedSkippedToken;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Scanner = (function () {
        function Scanner(fileName, text, languageVersion, window) {
            if (typeof window === "undefined") { window = TypeScript.ArrayUtilities.createArray(2048, 0); }
            Scanner.initializeStaticData();

            this.slidingWindow = new TypeScript.SlidingWindow(this, window, 0, text.length());
            this.fileName = fileName;
            this.text = text;
            this._languageVersion = languageVersion;
        }
        Scanner.initializeStaticData = function () {
            if (Scanner.isKeywordStartCharacter.length === 0) {
                Scanner.isKeywordStartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
                Scanner.isIdentifierStartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
                Scanner.isIdentifierPartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
                Scanner.isNumericLiteralStart = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);

                for (var character = 0; character < 127 /* maxAsciiCharacter */; character++) {
                    if (character >= 97 /* a */ && character <= 122 /* z */) {
                        Scanner.isIdentifierStartCharacter[character] = true;
                        Scanner.isIdentifierPartCharacter[character] = true;
                    } else if ((character >= 65 /* A */ && character <= 90 /* Z */) || character === 95 /* _ */ || character === 36 /* $ */) {
                        Scanner.isIdentifierStartCharacter[character] = true;
                        Scanner.isIdentifierPartCharacter[character] = true;
                    } else if (character >= 48 /* _0 */ && character <= 57 /* _9 */) {
                        Scanner.isIdentifierPartCharacter[character] = true;
                        Scanner.isNumericLiteralStart[character] = true;
                    }
                }

                Scanner.isNumericLiteralStart[46 /* dot */] = true;

                for (var keywordKind = TypeScript.SyntaxKind.FirstKeyword; keywordKind <= TypeScript.SyntaxKind.LastKeyword; keywordKind++) {
                    var keyword = TypeScript.SyntaxFacts.getText(keywordKind);
                    Scanner.isKeywordStartCharacter[keyword.charCodeAt(0)] = true;
                }
            }
        };

        Scanner.prototype.languageVersion = function () {
            return this._languageVersion;
        };

        Scanner.prototype.fetchMoreItems = function (argument, sourceIndex, window, destinationIndex, spaceAvailable) {
            var charactersRemaining = this.text.length() - sourceIndex;
            var amountToRead = TypeScript.MathPrototype.min(charactersRemaining, spaceAvailable);
            this.text.copyTo(sourceIndex, window, destinationIndex, amountToRead);
            return amountToRead;
        };

        Scanner.prototype.currentCharCode = function () {
            return this.slidingWindow.currentItem(null);
        };

        Scanner.prototype.absoluteIndex = function () {
            return this.slidingWindow.absoluteIndex();
        };

        Scanner.prototype.setAbsoluteIndex = function (index) {
            this.slidingWindow.setAbsoluteIndex(index);
        };

        Scanner.prototype.scan = function (diagnostics, allowRegularExpression) {
            var diagnosticsLength = diagnostics.length;
            var fullStart = this.slidingWindow.absoluteIndex();
            var leadingTriviaInfo = this.scanTriviaInfo(diagnostics, false);

            var start = this.slidingWindow.absoluteIndex();
            var kind = this.scanSyntaxToken(diagnostics, allowRegularExpression);
            var end = this.slidingWindow.absoluteIndex();

            var trailingTriviaInfo = this.scanTriviaInfo(diagnostics, true);

            var token = this.createToken(fullStart, leadingTriviaInfo, start, kind, end, trailingTriviaInfo);

            return diagnosticsLength !== diagnostics.length ? TypeScript.Syntax.realizeToken(token) : token;
        };

        Scanner.prototype.createToken = function (fullStart, leadingTriviaInfo, start, kind, end, trailingTriviaInfo) {
            if (kind >= TypeScript.SyntaxKind.FirstFixedWidth) {
                if (leadingTriviaInfo === 0) {
                    if (trailingTriviaInfo === 0) {
                        return new TypeScript.Syntax.FixedWidthTokenWithNoTrivia(kind);
                    } else {
                        return new TypeScript.Syntax.FixedWidthTokenWithTrailingTrivia(this.text, fullStart, kind, trailingTriviaInfo);
                    }
                } else if (trailingTriviaInfo === 0) {
                    return new TypeScript.Syntax.FixedWidthTokenWithLeadingTrivia(this.text, fullStart, kind, leadingTriviaInfo);
                } else {
                    return new TypeScript.Syntax.FixedWidthTokenWithLeadingAndTrailingTrivia(this.text, fullStart, kind, leadingTriviaInfo, trailingTriviaInfo);
                }
            } else {
                var width = end - start;
                if (leadingTriviaInfo === 0) {
                    if (trailingTriviaInfo === 0) {
                        return new TypeScript.Syntax.VariableWidthTokenWithNoTrivia(this.text, fullStart, kind, width);
                    } else {
                        return new TypeScript.Syntax.VariableWidthTokenWithTrailingTrivia(this.text, fullStart, kind, width, trailingTriviaInfo);
                    }
                } else if (trailingTriviaInfo === 0) {
                    return new TypeScript.Syntax.VariableWidthTokenWithLeadingTrivia(this.text, fullStart, kind, leadingTriviaInfo, width);
                } else {
                    return new TypeScript.Syntax.VariableWidthTokenWithLeadingAndTrailingTrivia(this.text, fullStart, kind, leadingTriviaInfo, width, trailingTriviaInfo);
                }
            }
        };

        Scanner.scanTrivia = function (text, start, length, isTrailing) {
            var scanner = new Scanner(null, text.subText(new TypeScript.TextSpan(start, length)), 1 /* EcmaScript5 */, Scanner.triviaWindow);
            return scanner.scanTrivia(isTrailing);
        };

        Scanner.prototype.scanTrivia = function (isTrailing) {
            var trivia = [];

            while (true) {
                if (!this.slidingWindow.isAtEndOfSource()) {
                    var ch = this.currentCharCode();

                    switch (ch) {
                        case 32 /* space */:
                        case 160 /* nonBreakingSpace */:
                        case 8192 /* enQuad */:
                        case 8193 /* emQuad */:
                        case 8194 /* enSpace */:
                        case 8195 /* emSpace */:
                        case 8196 /* threePerEmSpace */:
                        case 8197 /* fourPerEmSpace */:
                        case 8198 /* sixPerEmSpace */:
                        case 8199 /* figureSpace */:
                        case 8200 /* punctuationSpace */:
                        case 8201 /* thinSpace */:
                        case 8202 /* hairSpace */:
                        case 8203 /* zeroWidthSpace */:
                        case 8239 /* narrowNoBreakSpace */:
                        case 12288 /* ideographicSpace */:

                        case 9 /* tab */:
                        case 11 /* verticalTab */:
                        case 12 /* formFeed */:
                        case 65279 /* byteOrderMark */:
                            trivia.push(this.scanWhitespaceTrivia());
                            continue;

                        case 47 /* slash */:
                            var ch2 = this.slidingWindow.peekItemN(1);
                            if (ch2 === 47 /* slash */) {
                                trivia.push(this.scanSingleLineCommentTrivia());
                                continue;
                            }

                            if (ch2 === 42 /* asterisk */) {
                                trivia.push(this.scanMultiLineCommentTrivia());
                                continue;
                            }

                            throw TypeScript.Errors.invalidOperation();

                        case 13 /* carriageReturn */:
                        case 10 /* lineFeed */:
                        case 8233 /* paragraphSeparator */:
                        case 8232 /* lineSeparator */:
                            trivia.push(this.scanLineTerminatorSequenceTrivia(ch));

                            if (!isTrailing) {
                                continue;
                            }

                            break;

                        default:
                            throw TypeScript.Errors.invalidOperation();
                    }
                }

                return TypeScript.Syntax.triviaList(trivia);
            }
        };

        Scanner.prototype.scanTriviaInfo = function (diagnostics, isTrailing) {
            var width = 0;
            var hasCommentOrNewLine = 0;

            while (true) {
                var ch = this.currentCharCode();

                switch (ch) {
                    case 32 /* space */:
                    case 160 /* nonBreakingSpace */:
                    case 8192 /* enQuad */:
                    case 8193 /* emQuad */:
                    case 8194 /* enSpace */:
                    case 8195 /* emSpace */:
                    case 8196 /* threePerEmSpace */:
                    case 8197 /* fourPerEmSpace */:
                    case 8198 /* sixPerEmSpace */:
                    case 8199 /* figureSpace */:
                    case 8200 /* punctuationSpace */:
                    case 8201 /* thinSpace */:
                    case 8202 /* hairSpace */:
                    case 8203 /* zeroWidthSpace */:
                    case 8239 /* narrowNoBreakSpace */:
                    case 12288 /* ideographicSpace */:

                    case 9 /* tab */:
                    case 11 /* verticalTab */:
                    case 12 /* formFeed */:
                    case 65279 /* byteOrderMark */:
                        this.slidingWindow.moveToNextItem();
                        width++;
                        continue;

                    case 47 /* slash */:
                        var ch2 = this.slidingWindow.peekItemN(1);
                        if (ch2 === 47 /* slash */) {
                            hasCommentOrNewLine |= 2 /* TriviaCommentMask */;
                            width += this.scanSingleLineCommentTriviaLength();
                            continue;
                        }

                        if (ch2 === 42 /* asterisk */) {
                            hasCommentOrNewLine |= 2 /* TriviaCommentMask */;
                            width += this.scanMultiLineCommentTriviaLength(diagnostics);
                            continue;
                        }

                        break;

                    case 13 /* carriageReturn */:
                    case 10 /* lineFeed */:
                    case 8233 /* paragraphSeparator */:
                    case 8232 /* lineSeparator */:
                        hasCommentOrNewLine |= 1 /* TriviaNewLineMask */;
                        width += this.scanLineTerminatorSequenceLength(ch);

                        if (!isTrailing) {
                            continue;
                        }

                        break;
                }

                return (width << 2 /* TriviaFullWidthShift */) | hasCommentOrNewLine;
            }
        };

        Scanner.prototype.isNewLineCharacter = function (ch) {
            switch (ch) {
                case 13 /* carriageReturn */:
                case 10 /* lineFeed */:
                case 8233 /* paragraphSeparator */:
                case 8232 /* lineSeparator */:
                    return true;
                default:
                    return false;
            }
        };

        Scanner.prototype.scanWhitespaceTrivia = function () {
            var absoluteStartIndex = this.slidingWindow.getAndPinAbsoluteIndex();

            var width = 0;
            while (true) {
                var ch = this.currentCharCode();

                switch (ch) {
                    case 32 /* space */:
                    case 160 /* nonBreakingSpace */:
                    case 8192 /* enQuad */:
                    case 8193 /* emQuad */:
                    case 8194 /* enSpace */:
                    case 8195 /* emSpace */:
                    case 8196 /* threePerEmSpace */:
                    case 8197 /* fourPerEmSpace */:
                    case 8198 /* sixPerEmSpace */:
                    case 8199 /* figureSpace */:
                    case 8200 /* punctuationSpace */:
                    case 8201 /* thinSpace */:
                    case 8202 /* hairSpace */:
                    case 8203 /* zeroWidthSpace */:
                    case 8239 /* narrowNoBreakSpace */:
                    case 12288 /* ideographicSpace */:

                    case 9 /* tab */:
                    case 11 /* verticalTab */:
                    case 12 /* formFeed */:
                    case 65279 /* byteOrderMark */:
                        this.slidingWindow.moveToNextItem();
                        width++;
                        continue;
                }

                break;
            }

            var text = this.substring(absoluteStartIndex, absoluteStartIndex + width, false);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(absoluteStartIndex);

            return TypeScript.Syntax.whitespace(text);
        };

        Scanner.prototype.scanSingleLineCommentTrivia = function () {
            var absoluteStartIndex = this.slidingWindow.getAndPinAbsoluteIndex();
            var width = this.scanSingleLineCommentTriviaLength();

            var text = this.substring(absoluteStartIndex, absoluteStartIndex + width, false);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(absoluteStartIndex);

            return TypeScript.Syntax.singleLineComment(text);
        };

        Scanner.prototype.scanSingleLineCommentTriviaLength = function () {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            var width = 2;
            while (true) {
                if (this.slidingWindow.isAtEndOfSource() || this.isNewLineCharacter(this.currentCharCode())) {
                    return width;
                }

                this.slidingWindow.moveToNextItem();
                width++;
            }
        };

        Scanner.prototype.scanMultiLineCommentTrivia = function () {
            var absoluteStartIndex = this.slidingWindow.getAndPinAbsoluteIndex();
            var width = this.scanMultiLineCommentTriviaLength(null);

            var text = this.substring(absoluteStartIndex, absoluteStartIndex + width, false);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(absoluteStartIndex);

            return TypeScript.Syntax.multiLineComment(text);
        };

        Scanner.prototype.scanMultiLineCommentTriviaLength = function (diagnostics) {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            var width = 2;
            while (true) {
                if (this.slidingWindow.isAtEndOfSource()) {
                    if (diagnostics !== null) {
                        diagnostics.push(new TypeScript.SyntaxDiagnostic(this.fileName, this.slidingWindow.absoluteIndex(), 0, 14 /* _StarSlash__expected */, null));
                    }

                    return width;
                }

                var ch = this.currentCharCode();
                if (ch === 42 /* asterisk */ && this.slidingWindow.peekItemN(1) === 47 /* slash */) {
                    this.slidingWindow.moveToNextItem();
                    this.slidingWindow.moveToNextItem();
                    width += 2;
                    return width;
                }

                this.slidingWindow.moveToNextItem();
                width++;
            }
        };

        Scanner.prototype.scanLineTerminatorSequenceTrivia = function (ch) {
            var absoluteStartIndex = this.slidingWindow.getAndPinAbsoluteIndex();
            var width = this.scanLineTerminatorSequenceLength(ch);

            var text = this.substring(absoluteStartIndex, absoluteStartIndex + width, false);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(absoluteStartIndex);

            return TypeScript.Syntax.trivia(5 /* NewLineTrivia */, text);
        };

        Scanner.prototype.scanLineTerminatorSequenceLength = function (ch) {
            this.slidingWindow.moveToNextItem();

            if (ch === 13 /* carriageReturn */ && this.currentCharCode() === 10 /* lineFeed */) {
                this.slidingWindow.moveToNextItem();
                return 2;
            } else {
                return 1;
            }
        };

        Scanner.prototype.scanSyntaxToken = function (diagnostics, allowRegularExpression) {
            if (this.slidingWindow.isAtEndOfSource()) {
                return 10 /* EndOfFileToken */;
            }

            var character = this.currentCharCode();

            switch (character) {
                case 34 /* doubleQuote */:
                case 39 /* singleQuote */:
                    return this.scanStringLiteral(diagnostics);

                case 47 /* slash */:
                    return this.scanSlashToken(allowRegularExpression);

                case 46 /* dot */:
                    return this.scanDotToken();

                case 45 /* minus */:
                    return this.scanMinusToken();

                case 33 /* exclamation */:
                    return this.scanExclamationToken();

                case 61 /* equals */:
                    return this.scanEqualsToken();

                case 124 /* bar */:
                    return this.scanBarToken();

                case 42 /* asterisk */:
                    return this.scanAsteriskToken();

                case 43 /* plus */:
                    return this.scanPlusToken();

                case 37 /* percent */:
                    return this.scanPercentToken();

                case 38 /* ampersand */:
                    return this.scanAmpersandToken();

                case 94 /* caret */:
                    return this.scanCaretToken();

                case 60 /* lessThan */:
                    return this.scanLessThanToken();

                case 62 /* greaterThan */:
                    return this.advanceAndSetTokenKind(82 /* GreaterThanToken */);

                case 44 /* comma */:
                    return this.advanceAndSetTokenKind(80 /* CommaToken */);

                case 58 /* colon */:
                    return this.advanceAndSetTokenKind(107 /* ColonToken */);

                case 59 /* semicolon */:
                    return this.advanceAndSetTokenKind(79 /* SemicolonToken */);

                case 126 /* tilde */:
                    return this.advanceAndSetTokenKind(103 /* TildeToken */);

                case 40 /* openParen */:
                    return this.advanceAndSetTokenKind(73 /* OpenParenToken */);

                case 41 /* closeParen */:
                    return this.advanceAndSetTokenKind(74 /* CloseParenToken */);

                case 123 /* openBrace */:
                    return this.advanceAndSetTokenKind(71 /* OpenBraceToken */);

                case 125 /* closeBrace */:
                    return this.advanceAndSetTokenKind(72 /* CloseBraceToken */);

                case 91 /* openBracket */:
                    return this.advanceAndSetTokenKind(75 /* OpenBracketToken */);

                case 93 /* closeBracket */:
                    return this.advanceAndSetTokenKind(76 /* CloseBracketToken */);

                case 63 /* question */:
                    return this.advanceAndSetTokenKind(106 /* QuestionToken */);
            }

            if (Scanner.isNumericLiteralStart[character]) {
                return this.scanNumericLiteral();
            }

            if (Scanner.isIdentifierStartCharacter[character]) {
                var result = this.tryFastScanIdentifierOrKeyword(character);
                if (result !== 0 /* None */) {
                    return result;
                }
            }

            if (this.isIdentifierStart(this.peekCharOrUnicodeEscape())) {
                return this.slowScanIdentifier(diagnostics);
            }

            return this.scanDefaultCharacter(character, diagnostics);
        };

        Scanner.prototype.isIdentifierStart = function (interpretedChar) {
            if (Scanner.isIdentifierStartCharacter[interpretedChar]) {
                return true;
            }

            return interpretedChar > 127 /* maxAsciiCharacter */ && TypeScript.Unicode.isIdentifierStart(interpretedChar, this._languageVersion);
        };

        Scanner.prototype.isIdentifierPart = function (interpretedChar) {
            if (Scanner.isIdentifierPartCharacter[interpretedChar]) {
                return true;
            }

            return interpretedChar > 127 /* maxAsciiCharacter */ && TypeScript.Unicode.isIdentifierPart(interpretedChar, this._languageVersion);
        };

        Scanner.prototype.tryFastScanIdentifierOrKeyword = function (firstCharacter) {
            var startIndex = this.slidingWindow.getAndPinAbsoluteIndex();

            while (true) {
                var character = this.currentCharCode();
                if (Scanner.isIdentifierPartCharacter[character]) {
                    this.slidingWindow.moveToNextItem();
                } else if (character === 92 /* backslash */ || character > 127 /* maxAsciiCharacter */) {
                    this.slidingWindow.rewindToPinnedIndex(startIndex);
                    this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);
                    return 0 /* None */;
                } else {
                    var endIndex = this.slidingWindow.absoluteIndex();

                    var kind;
                    if (Scanner.isKeywordStartCharacter[firstCharacter]) {
                        var offset = startIndex - this.slidingWindow.windowAbsoluteStartIndex;
                        kind = TypeScript.ScannerUtilities.identifierKind(this.slidingWindow.window, offset, endIndex - startIndex);
                    } else {
                        kind = 11 /* IdentifierName */;
                    }

                    this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);
                    return kind;
                }
            }
        };

        Scanner.prototype.slowScanIdentifier = function (diagnostics) {
            var startIndex = this.slidingWindow.absoluteIndex();

            do {
                this.scanCharOrUnicodeEscape(diagnostics);
            } while(this.isIdentifierPart(this.peekCharOrUnicodeEscape()));

            return 11 /* IdentifierName */;
        };

        Scanner.prototype.scanNumericLiteral = function () {
            if (this.isHexNumericLiteral()) {
                return this.scanHexNumericLiteral();
            } else {
                return this.scanDecimalNumericLiteral();
            }
        };

        Scanner.prototype.scanDecimalNumericLiteral = function () {
            while (TypeScript.CharacterInfo.isDecimalDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }

            if (this.currentCharCode() === 46 /* dot */) {
                this.slidingWindow.moveToNextItem();
            }

            while (TypeScript.CharacterInfo.isDecimalDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }

            var ch = this.currentCharCode();
            if (ch === 101 /* e */ || ch === 69 /* E */) {
                this.slidingWindow.moveToNextItem();

                ch = this.currentCharCode();
                if (ch === 45 /* minus */ || ch === 43 /* plus */) {
                    if (TypeScript.CharacterInfo.isDecimalDigit(this.slidingWindow.peekItemN(1))) {
                        this.slidingWindow.moveToNextItem();
                    }
                }
            }

            while (TypeScript.CharacterInfo.isDecimalDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }

            return 13 /* NumericLiteral */;
        };

        Scanner.prototype.scanHexNumericLiteral = function () {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            while (TypeScript.CharacterInfo.isHexDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }

            return 13 /* NumericLiteral */;
        };

        Scanner.prototype.isHexNumericLiteral = function () {
            if (this.currentCharCode() === 48 /* _0 */) {
                var ch = this.slidingWindow.peekItemN(1);

                if (ch === 120 /* x */ || ch === 88 /* X */) {
                    ch = this.slidingWindow.peekItemN(2);

                    return TypeScript.CharacterInfo.isHexDigit(ch);
                }
            }

            return false;
        };

        Scanner.prototype.advanceAndSetTokenKind = function (kind) {
            this.slidingWindow.moveToNextItem();
            return kind;
        };

        Scanner.prototype.scanLessThanToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 83 /* LessThanEqualsToken */;
            } else if (this.currentCharCode() === 60 /* lessThan */) {
                this.slidingWindow.moveToNextItem();
                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();
                    return 113 /* LessThanLessThanEqualsToken */;
                } else {
                    return 96 /* LessThanLessThanToken */;
                }
            } else {
                return 81 /* LessThanToken */;
            }
        };

        Scanner.prototype.scanBarToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 117 /* BarEqualsToken */;
            } else if (this.currentCharCode() === 124 /* bar */) {
                this.slidingWindow.moveToNextItem();
                return 105 /* BarBarToken */;
            } else {
                return 100 /* BarToken */;
            }
        };

        Scanner.prototype.scanCaretToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 118 /* CaretEqualsToken */;
            } else {
                return 101 /* CaretToken */;
            }
        };

        Scanner.prototype.scanAmpersandToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 116 /* AmpersandEqualsToken */;
            } else if (this.currentCharCode() === 38 /* ampersand */) {
                this.slidingWindow.moveToNextItem();
                return 104 /* AmpersandAmpersandToken */;
            } else {
                return 99 /* AmpersandToken */;
            }
        };

        Scanner.prototype.scanPercentToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 112 /* PercentEqualsToken */;
            } else {
                return 93 /* PercentToken */;
            }
        };

        Scanner.prototype.scanMinusToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();

            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 110 /* MinusEqualsToken */;
            } else if (character === 45 /* minus */) {
                this.slidingWindow.moveToNextItem();
                return 95 /* MinusMinusToken */;
            } else {
                return 91 /* MinusToken */;
            }
        };

        Scanner.prototype.scanPlusToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 109 /* PlusEqualsToken */;
            } else if (character === 43 /* plus */) {
                this.slidingWindow.moveToNextItem();
                return 94 /* PlusPlusToken */;
            } else {
                return 90 /* PlusToken */;
            }
        };

        Scanner.prototype.scanAsteriskToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 111 /* AsteriskEqualsToken */;
            } else {
                return 92 /* AsteriskToken */;
            }
        };

        Scanner.prototype.scanEqualsToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();

                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();

                    return 88 /* EqualsEqualsEqualsToken */;
                } else {
                    return 85 /* EqualsEqualsToken */;
                }
            } else if (character === 62 /* greaterThan */) {
                this.slidingWindow.moveToNextItem();
                return 86 /* EqualsGreaterThanToken */;
            } else {
                return 108 /* EqualsToken */;
            }
        };

        Scanner.prototype.isDotPrefixedNumericLiteral = function () {
            if (this.currentCharCode() === 46 /* dot */) {
                var ch = this.slidingWindow.peekItemN(1);
                return TypeScript.CharacterInfo.isDecimalDigit(ch);
            }

            return false;
        };

        Scanner.prototype.scanDotToken = function () {
            if (this.isDotPrefixedNumericLiteral()) {
                return this.scanNumericLiteral();
            }

            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 46 /* dot */ && this.slidingWindow.peekItemN(1) === 46 /* dot */) {
                this.slidingWindow.moveToNextItem();
                this.slidingWindow.moveToNextItem();
                return 78 /* DotDotDotToken */;
            } else {
                return 77 /* DotToken */;
            }
        };

        Scanner.prototype.scanSlashToken = function (allowRegularExpression) {
            if (allowRegularExpression) {
                var result = this.tryScanRegularExpressionToken();
                if (result !== 0 /* None */) {
                    return result;
                }
            }

            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 120 /* SlashEqualsToken */;
            } else {
                return 119 /* SlashToken */;
            }
        };

        Scanner.prototype.tryScanRegularExpressionToken = function () {
            var startIndex = this.slidingWindow.getAndPinAbsoluteIndex();
            try  {
                this.slidingWindow.moveToNextItem();

                var inEscape = false;
                var inCharacterClass = false;
                while (true) {
                    var ch = this.currentCharCode();
                    if (this.isNewLineCharacter(ch) || this.slidingWindow.isAtEndOfSource()) {
                        this.slidingWindow.rewindToPinnedIndex(startIndex);
                        return 0 /* None */;
                    }

                    this.slidingWindow.moveToNextItem();
                    if (inEscape) {
                        inEscape = false;
                        continue;
                    }

                    switch (ch) {
                        case 92 /* backslash */:
                            inEscape = true;
                            continue;

                        case 91 /* openBracket */:
                            inCharacterClass = true;
                            continue;

                        case 93 /* closeBracket */:
                            inCharacterClass = false;
                            continue;

                        case 47 /* slash */:
                            if (inCharacterClass) {
                                continue;
                            }

                            break;

                        default:
                            continue;
                    }

                    break;
                }

                while (Scanner.isIdentifierPartCharacter[this.currentCharCode()]) {
                    this.slidingWindow.moveToNextItem();
                }

                return 12 /* RegularExpressionLiteral */;
            } finally {
                this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);
            }
        };

        Scanner.prototype.scanExclamationToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();

                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();

                    return 89 /* ExclamationEqualsEqualsToken */;
                } else {
                    return 87 /* ExclamationEqualsToken */;
                }
            } else {
                return 102 /* ExclamationToken */;
            }
        };

        Scanner.prototype.scanDefaultCharacter = function (character, diagnostics) {
            var position = this.slidingWindow.absoluteIndex();
            this.slidingWindow.moveToNextItem();

            var text = String.fromCharCode(character);
            var messageText = this.getErrorMessageText(text);
            diagnostics.push(new TypeScript.SyntaxDiagnostic(this.fileName, position, 1, 5 /* Unexpected_character_0 */, [messageText]));

            return 9 /* ErrorToken */;
        };

        Scanner.prototype.getErrorMessageText = function (text) {
            if (text === "\\") {
                return '"\\"';
            }

            return JSON.stringify(text);
        };

        Scanner.prototype.skipEscapeSequence = function (diagnostics) {
            var rewindPoint = this.slidingWindow.getAndPinAbsoluteIndex();
            try  {
                this.slidingWindow.moveToNextItem();

                var ch = this.currentCharCode();
                this.slidingWindow.moveToNextItem();
                switch (ch) {
                    case 120 /* x */:
                    case 117 /* u */:
                        this.slidingWindow.rewindToPinnedIndex(rewindPoint);
                        var value = this.scanUnicodeOrHexEscape(diagnostics);
                        return;

                    case 13 /* carriageReturn */:
                        if (this.currentCharCode() === 10 /* lineFeed */) {
                            this.slidingWindow.moveToNextItem();
                        }
                        return;

                    default:
                        return;
                }
            } finally {
                this.slidingWindow.releaseAndUnpinAbsoluteIndex(rewindPoint);
            }
        };

        Scanner.prototype.scanStringLiteral = function (diagnostics) {
            var quoteCharacter = this.currentCharCode();

            this.slidingWindow.moveToNextItem();

            while (true) {
                var ch = this.currentCharCode();
                if (ch === 92 /* backslash */) {
                    this.skipEscapeSequence(diagnostics);
                } else if (ch === quoteCharacter) {
                    this.slidingWindow.moveToNextItem();
                    break;
                } else if (this.isNewLineCharacter(ch) || this.slidingWindow.isAtEndOfSource()) {
                    diagnostics.push(new TypeScript.SyntaxDiagnostic(this.fileName, this.slidingWindow.absoluteIndex(), 1, 6 /* Missing_closing_quote_character */, null));
                    break;
                } else {
                    this.slidingWindow.moveToNextItem();
                }
            }

            return 14 /* StringLiteral */;
        };

        Scanner.prototype.isUnicodeOrHexEscape = function (character) {
            return this.isUnicodeEscape(character) || this.isHexEscape(character);
        };

        Scanner.prototype.isUnicodeEscape = function (character) {
            if (character === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 117 /* u */) {
                    return true;
                }
            }

            return false;
        };

        Scanner.prototype.isHexEscape = function (character) {
            if (character === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 120 /* x */) {
                    return true;
                }
            }

            return false;
        };

        Scanner.prototype.peekCharOrUnicodeOrHexEscape = function () {
            var character = this.currentCharCode();
            if (this.isUnicodeOrHexEscape(character)) {
                return this.peekUnicodeOrHexEscape();
            } else {
                return character;
            }
        };

        Scanner.prototype.peekCharOrUnicodeEscape = function () {
            var character = this.currentCharCode();
            if (this.isUnicodeEscape(character)) {
                return this.peekUnicodeOrHexEscape();
            } else {
                return character;
            }
        };

        Scanner.prototype.peekUnicodeOrHexEscape = function () {
            var startIndex = this.slidingWindow.getAndPinAbsoluteIndex();

            var ch = this.scanUnicodeOrHexEscape(null);

            this.slidingWindow.rewindToPinnedIndex(startIndex);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);

            return ch;
        };

        Scanner.prototype.scanCharOrUnicodeEscape = function (errors) {
            var ch = this.currentCharCode();
            if (ch === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 117 /* u */) {
                    return this.scanUnicodeOrHexEscape(errors);
                }
            }

            this.slidingWindow.moveToNextItem();
            return ch;
        };

        Scanner.prototype.scanCharOrUnicodeOrHexEscape = function (errors) {
            var ch = this.currentCharCode();
            if (ch === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 117 /* u */ || ch2 === 120 /* x */) {
                    return this.scanUnicodeOrHexEscape(errors);
                }
            }

            this.slidingWindow.moveToNextItem();
            return ch;
        };

        Scanner.prototype.scanUnicodeOrHexEscape = function (errors) {
            var start = this.slidingWindow.absoluteIndex();
            var character = this.currentCharCode();

            this.slidingWindow.moveToNextItem();

            character = this.currentCharCode();

            var intChar = 0;
            this.slidingWindow.moveToNextItem();

            var count = character === 117 /* u */ ? 4 : 2;

            for (var i = 0; i < count; i++) {
                var ch2 = this.currentCharCode();
                if (!TypeScript.CharacterInfo.isHexDigit(ch2)) {
                    if (errors !== null) {
                        var end = this.slidingWindow.absoluteIndex();
                        var info = this.createIllegalEscapeDiagnostic(start, end);
                        errors.push(info);
                    }

                    break;
                }

                intChar = (intChar << 4) + TypeScript.CharacterInfo.hexValue(ch2);
                this.slidingWindow.moveToNextItem();
            }

            return intChar;
        };

        Scanner.prototype.substring = function (start, end, intern) {
            var length = end - start;
            var offset = start - this.slidingWindow.windowAbsoluteStartIndex;

            if (intern) {
                return TypeScript.Collections.DefaultStringTable.addCharArray(this.slidingWindow.window, offset, length);
            } else {
                return TypeScript.StringUtilities.fromCharCodeArray(this.slidingWindow.window.slice(offset, offset + length));
            }
        };

        Scanner.prototype.createIllegalEscapeDiagnostic = function (start, end) {
            return new TypeScript.SyntaxDiagnostic(this.fileName, start, end - start, 4 /* Unrecognized_escape_sequence */, null);
        };

        Scanner.isValidIdentifier = function (text, languageVersion) {
            var scanner = new Scanner(null, text, TypeScript.LanguageVersion, Scanner.triviaWindow);
            var errors = [];
            var token = scanner.scan(errors, false);

            return errors.length === 0 && TypeScript.SyntaxFacts.isIdentifierNameOrAnyKeyword(token) && token.width() === text.length();
        };
        Scanner.isKeywordStartCharacter = [];
        Scanner.isIdentifierStartCharacter = [];
        Scanner.isIdentifierPartCharacter = [];
        Scanner.isNumericLiteralStart = [];

        Scanner.triviaWindow = TypeScript.ArrayUtilities.createArray(2048, 0);
        return Scanner;
    })();
    TypeScript.Scanner = Scanner;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var ScannerUtilities = (function () {
        function ScannerUtilities() {
        }
        ScannerUtilities.identifierKind = function (array, startIndex, length) {
            switch (length) {
                case 2:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            return (array[startIndex + 1] === 111 /* o */) ? 22 /* DoKeyword */ : 11 /* IdentifierName */;
                        case 105 /* i */:
                            switch (array[startIndex + 1]) {
                                case 102 /* f */:
                                    return 28 /* IfKeyword */;
                                case 110 /* n */:
                                    return 29 /* InKeyword */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        default:
                            return 11 /* IdentifierName */;
                    }

                case 3:
                    switch (array[startIndex]) {
                        case 102 /* f */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 114 /* r */) ? 26 /* ForKeyword */ : 11 /* IdentifierName */;
                        case 110 /* n */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 119 /* w */) ? 31 /* NewKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 121 /* y */) ? 38 /* TryKeyword */ : 11 /* IdentifierName */;
                        case 118 /* v */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 114 /* r */) ? 40 /* VarKeyword */ : 11 /* IdentifierName */;
                        case 108 /* l */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 53 /* LetKeyword */ : 11 /* IdentifierName */;
                        case 97 /* a */:
                            return (array[startIndex + 1] === 110 /* n */ && array[startIndex + 2] === 121 /* y */) ? 60 /* AnyKeyword */ : 11 /* IdentifierName */;
                        case 103 /* g */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 65 /* GetKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 69 /* SetKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 4:
                    switch (array[startIndex]) {
                        case 99 /* c */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 101 /* e */) ? 16 /* CaseKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            switch (array[startIndex + 1]) {
                                case 108 /* l */:
                                    return (array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 101 /* e */) ? 23 /* ElseKeyword */ : 11 /* IdentifierName */;
                                case 110 /* n */:
                                    return (array[startIndex + 2] === 117 /* u */ && array[startIndex + 3] === 109 /* m */) ? 46 /* EnumKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 110 /* n */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 108 /* l */) ? 32 /* NullKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            switch (array[startIndex + 1]) {
                                case 104 /* h */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 115 /* s */) ? 35 /* ThisKeyword */ : 11 /* IdentifierName */;
                                case 114 /* r */:
                                    return (array[startIndex + 2] === 117 /* u */ && array[startIndex + 3] === 101 /* e */) ? 37 /* TrueKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 118 /* v */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 100 /* d */) ? 41 /* VoidKeyword */ : 11 /* IdentifierName */;
                        case 119 /* w */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 104 /* h */) ? 43 /* WithKeyword */ : 11 /* IdentifierName */;
                        case 98 /* b */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 111 /* o */ && array[startIndex + 3] === 108 /* l */) ? 62 /* BoolKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 5:
                    switch (array[startIndex]) {
                        case 98 /* b */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 101 /* e */ && array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 107 /* k */) ? 15 /* BreakKeyword */ : 11 /* IdentifierName */;
                        case 99 /* c */:
                            switch (array[startIndex + 1]) {
                                case 97 /* a */:
                                    return (array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 99 /* c */ && array[startIndex + 4] === 104 /* h */) ? 17 /* CatchKeyword */ : 11 /* IdentifierName */;
                                case 108 /* l */:
                                    return (array[startIndex + 2] === 97 /* a */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 115 /* s */) ? 44 /* ClassKeyword */ : 11 /* IdentifierName */;
                                case 111 /* o */:
                                    return (array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 116 /* t */) ? 45 /* ConstKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 102 /* f */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 101 /* e */) ? 24 /* FalseKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            return (array[startIndex + 1] === 104 /* h */ && array[startIndex + 2] === 114 /* r */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 119 /* w */) ? 36 /* ThrowKeyword */ : 11 /* IdentifierName */;
                        case 119 /* w */:
                            return (array[startIndex + 1] === 104 /* h */ && array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */) ? 42 /* WhileKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 114 /* r */) ? 50 /* SuperKeyword */ : 11 /* IdentifierName */;
                        case 121 /* y */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 101 /* e */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 100 /* d */) ? 59 /* YieldKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 6:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 101 /* e */) ? 21 /* DeleteKeyword */ : 11 /* IdentifierName */;
                        case 114 /* r */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 110 /* n */) ? 33 /* ReturnKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            switch (array[startIndex + 1]) {
                                case 119 /* w */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 99 /* c */ && array[startIndex + 5] === 104 /* h */) ? 34 /* SwitchKeyword */ : 11 /* IdentifierName */;
                                case 116 /* t */:
                                    switch (array[startIndex + 2]) {
                                        case 97 /* a */:
                                            return (array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 99 /* c */) ? 58 /* StaticKeyword */ : 11 /* IdentifierName */;
                                        case 114 /* r */:
                                            return (array[startIndex + 3] === 105 /* i */ && array[startIndex + 4] === 110 /* n */ && array[startIndex + 5] === 103 /* g */) ? 70 /* StringKeyword */ : 11 /* IdentifierName */;
                                        default:
                                            return 11 /* IdentifierName */;
                                    }

                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 116 /* t */:
                            return (array[startIndex + 1] === 121 /* y */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 111 /* o */ && array[startIndex + 5] === 102 /* f */) ? 39 /* TypeOfKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            return (array[startIndex + 1] === 120 /* x */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 116 /* t */) ? 47 /* ExportKeyword */ : 11 /* IdentifierName */;
                        case 105 /* i */:
                            return (array[startIndex + 1] === 109 /* m */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 116 /* t */) ? 49 /* ImportKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 98 /* b */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 99 /* c */) ? 57 /* PublicKeyword */ : 11 /* IdentifierName */;
                        case 109 /* m */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 100 /* d */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 108 /* l */ && array[startIndex + 5] === 101 /* e */) ? 66 /* ModuleKeyword */ : 11 /* IdentifierName */;
                        case 110 /* n */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 109 /* m */ && array[startIndex + 3] === 98 /* b */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 114 /* r */) ? 68 /* NumberKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 7:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            switch (array[startIndex + 1]) {
                                case 101 /* e */:
                                    switch (array[startIndex + 2]) {
                                        case 102 /* f */:
                                            return (array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 117 /* u */ && array[startIndex + 5] === 108 /* l */ && array[startIndex + 6] === 116 /* t */) ? 20 /* DefaultKeyword */ : 11 /* IdentifierName */;
                                        case 99 /* c */:
                                            return (array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 101 /* e */) ? 64 /* DeclareKeyword */ : 11 /* IdentifierName */;
                                        default:
                                            return 11 /* IdentifierName */;
                                    }

                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 102 /* f */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 108 /* l */ && array[startIndex + 5] === 108 /* l */ && array[startIndex + 6] === 121 /* y */) ? 25 /* FinallyKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            return (array[startIndex + 1] === 120 /* x */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 110 /* n */ && array[startIndex + 5] === 100 /* d */ && array[startIndex + 6] === 115 /* s */) ? 48 /* ExtendsKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            switch (array[startIndex + 1]) {
                                case 97 /* a */:
                                    return (array[startIndex + 2] === 99 /* c */ && array[startIndex + 3] === 107 /* k */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 103 /* g */ && array[startIndex + 6] === 101 /* e */) ? 54 /* PackageKeyword */ : 11 /* IdentifierName */;
                                case 114 /* r */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 118 /* v */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 116 /* t */ && array[startIndex + 6] === 101 /* e */) ? 55 /* PrivateKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 98 /* b */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 111 /* o */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 97 /* a */ && array[startIndex + 6] === 110 /* n */) ? 61 /* BooleanKeyword */ : 11 /* IdentifierName */;
                        case 114 /* r */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 113 /* q */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 101 /* e */) ? 67 /* RequireKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 8:
                    switch (array[startIndex]) {
                        case 99 /* c */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 110 /* n */ && array[startIndex + 6] === 117 /* u */ && array[startIndex + 7] === 101 /* e */) ? 18 /* ContinueKeyword */ : 11 /* IdentifierName */;
                        case 100 /* d */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 98 /* b */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 103 /* g */ && array[startIndex + 5] === 103 /* g */ && array[startIndex + 6] === 101 /* e */ && array[startIndex + 7] === 114 /* r */) ? 19 /* DebuggerKeyword */ : 11 /* IdentifierName */;
                        case 102 /* f */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 99 /* c */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 105 /* i */ && array[startIndex + 6] === 111 /* o */ && array[startIndex + 7] === 110 /* n */) ? 27 /* FunctionKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 9:
                    switch (array[startIndex]) {
                        case 105 /* i */:
                            return (array[startIndex + 1] === 110 /* n */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 102 /* f */ && array[startIndex + 6] === 97 /* a */ && array[startIndex + 7] === 99 /* c */ && array[startIndex + 8] === 101 /* e */) ? 52 /* InterfaceKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 111 /* o */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 99 /* c */ && array[startIndex + 6] === 116 /* t */ && array[startIndex + 7] === 101 /* e */ && array[startIndex + 8] === 100 /* d */) ? 56 /* ProtectedKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 10:
                    switch (array[startIndex]) {
                        case 105 /* i */:
                            switch (array[startIndex + 1]) {
                                case 110 /* n */:
                                    return (array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 110 /* n */ && array[startIndex + 6] === 99 /* c */ && array[startIndex + 7] === 101 /* e */ && array[startIndex + 8] === 111 /* o */ && array[startIndex + 9] === 102 /* f */) ? 30 /* InstanceOfKeyword */ : 11 /* IdentifierName */;
                                case 109 /* m */:
                                    return (array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 109 /* m */ && array[startIndex + 6] === 101 /* e */ && array[startIndex + 7] === 110 /* n */ && array[startIndex + 8] === 116 /* t */ && array[startIndex + 9] === 115 /* s */) ? 51 /* ImplementsKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        default:
                            return 11 /* IdentifierName */;
                    }

                case 11:
                    return (array[startIndex] === 99 /* c */ && array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 117 /* u */ && array[startIndex + 7] === 99 /* c */ && array[startIndex + 8] === 116 /* t */ && array[startIndex + 9] === 111 /* o */ && array[startIndex + 10] === 114 /* r */) ? 63 /* ConstructorKeyword */ : 11 /* IdentifierName */;
                default:
                    return 11 /* IdentifierName */;
            }
        };
        return ScannerUtilities;
    })();
    TypeScript.ScannerUtilities = ScannerUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var EmptySeparatedSyntaxList = (function () {
            function EmptySeparatedSyntaxList() {
            }
            EmptySeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            EmptySeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isList = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };

            EmptySeparatedSyntaxList.prototype.toJSON = function (key) {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.childCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.separatorCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.toArray = function () {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.separatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.collectTextElements = function (elements) {
            };

            EmptySeparatedSyntaxList.prototype.firstToken = function () {
                return null;
            };

            EmptySeparatedSyntaxList.prototype.lastToken = function () {
                return null;
            };

            EmptySeparatedSyntaxList.prototype.fullWidth = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.fullText = function () {
                return "";
            };

            EmptySeparatedSyntaxList.prototype.width = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                throw TypeScript.Errors.invalidOperation();
            };

            EmptySeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
            };

            EmptySeparatedSyntaxList.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySeparatedSyntaxList.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            return EmptySeparatedSyntaxList;
        })();

        Syntax.emptySeparatedList = new EmptySeparatedSyntaxList();

        var SingletonSeparatedSyntaxList = (function () {
            function SingletonSeparatedSyntaxList(item) {
                this.item = item;
            }
            SingletonSeparatedSyntaxList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            SingletonSeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isList = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };

            SingletonSeparatedSyntaxList.prototype.childCount = function () {
                return 1;
            };
            SingletonSeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return 1;
            };
            SingletonSeparatedSyntaxList.prototype.separatorCount = function () {
                return 0;
            };

            SingletonSeparatedSyntaxList.prototype.toArray = function () {
                return [this.item];
            };
            SingletonSeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                return [this.item];
            };

            SingletonSeparatedSyntaxList.prototype.childAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSeparatedSyntaxList.prototype.separatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            SingletonSeparatedSyntaxList.prototype.collectTextElements = function (elements) {
                this.item.collectTextElements(elements);
            };

            SingletonSeparatedSyntaxList.prototype.firstToken = function () {
                return this.item.firstToken();
            };

            SingletonSeparatedSyntaxList.prototype.lastToken = function () {
                return this.item.lastToken();
            };

            SingletonSeparatedSyntaxList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSeparatedSyntaxList.prototype.width = function () {
                return this.item.width();
            };

            SingletonSeparatedSyntaxList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSeparatedSyntaxList.prototype.leadingTrivia = function () {
                return this.item.leadingTrivia();
            };

            SingletonSeparatedSyntaxList.prototype.trailingTrivia = function () {
                return this.item.trailingTrivia();
            };

            SingletonSeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.item.leadingTriviaWidth();
            };

            SingletonSeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.item.trailingTriviaWidth();
            };

            SingletonSeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                return this.item.isTypeScriptSpecific();
            };

            SingletonSeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return this.item.isIncrementallyUnusable();
            };

            SingletonSeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                return (this.item).findTokenInternal(new TypeScript.PositionedSeparatedList(parent, this, fullStart), position, fullStart);
            };

            SingletonSeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
                array.splice(index, 0, this.item);
            };
            return SingletonSeparatedSyntaxList;
        })();

        var NormalSeparatedSyntaxList = (function () {
            function NormalSeparatedSyntaxList(elements) {
                this._data = 0;
                this.elements = elements;
            }
            NormalSeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            NormalSeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isList = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };
            NormalSeparatedSyntaxList.prototype.toJSON = function (key) {
                return this.elements;
            };

            NormalSeparatedSyntaxList.prototype.childCount = function () {
                return this.elements.length;
            };
            NormalSeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return TypeScript.IntegerUtilities.integerDivide(this.elements.length + 1, 2);
            };
            NormalSeparatedSyntaxList.prototype.separatorCount = function () {
                return TypeScript.IntegerUtilities.integerDivide(this.elements.length, 2);
            };

            NormalSeparatedSyntaxList.prototype.toArray = function () {
                return this.elements.slice(0);
            };

            NormalSeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                var result = [];
                for (var i = 0, n = this.nonSeparatorCount(); i < n; i++) {
                    result.push(this.nonSeparatorAt(i));
                }

                return result;
            };

            NormalSeparatedSyntaxList.prototype.childAt = function (index) {
                if (index < 0 || index >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[index];
            };

            NormalSeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                var value = index * 2;
                if (value < 0 || value >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[value];
            };

            NormalSeparatedSyntaxList.prototype.separatorAt = function (index) {
                var value = index * 2 + 1;
                if (value < 0 || value >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[value];
            };

            NormalSeparatedSyntaxList.prototype.firstToken = function () {
                var token;
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    if (i % 2 === 0) {
                        var nodeOrToken = this.elements[i];
                        token = nodeOrToken.firstToken();
                        if (token !== null) {
                            return token;
                        }
                    } else {
                        token = this.elements[i];
                        if (token.width() > 0) {
                            return token;
                        }
                    }
                }

                return null;
            };

            NormalSeparatedSyntaxList.prototype.lastToken = function () {
                var token;
                for (var i = this.elements.length - 1; i >= 0; i--) {
                    if (i % 2 === 0) {
                        var nodeOrToken = this.elements[i];
                        token = nodeOrToken.lastToken();
                        if (token !== null) {
                            return token;
                        }
                    } else {
                        token = this.elements[i];
                        if (token.width() > 0) {
                            return token;
                        }
                    }
                }

                return null;
            };

            NormalSeparatedSyntaxList.prototype.fullText = function () {
                var elements = [];
                this.collectTextElements(elements);
                return elements.join("");
            };

            NormalSeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                for (var i = 0, n = this.nonSeparatorCount(); i < n; i++) {
                    if (this.nonSeparatorAt(i).isTypeScriptSpecific()) {
                        return true;
                    }
                }

                return false;
            };

            NormalSeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
            };

            NormalSeparatedSyntaxList.prototype.fullWidth = function () {
                return this.data() >>> 3 /* NodeFullWidthShift */;
            };

            NormalSeparatedSyntaxList.prototype.width = function () {
                var fullWidth = this.fullWidth();
                return fullWidth - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.leadingTrivia = function () {
                return this.firstToken().leadingTrivia();
            };

            NormalSeparatedSyntaxList.prototype.trailingTrivia = function () {
                return this.lastToken().trailingTrivia();
            };

            NormalSeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.firstToken().leadingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.lastToken().trailingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.computeData = function () {
                var fullWidth = 0;
                var isIncrementallyUnusable = false;

                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];

                    var childWidth = element.fullWidth();
                    fullWidth += childWidth;

                    isIncrementallyUnusable = isIncrementallyUnusable || element.isIncrementallyUnusable();
                }

                return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
            };

            NormalSeparatedSyntaxList.prototype.data = function () {
                if ((this._data & 1 /* NodeDataComputed */) === 0) {
                    this._data = this.computeData();
                }

                return this._data;
            };

            NormalSeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                parent = new TypeScript.PositionedSeparatedList(parent, this, fullStart);
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];

                    var childWidth = element.fullWidth();
                    if (position < childWidth) {
                        return (element).findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }

                throw TypeScript.Errors.invalidOperation();
            };

            NormalSeparatedSyntaxList.prototype.collectTextElements = function (elements) {
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];
                    element.collectTextElements(elements);
                }
            };

            NormalSeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
                if (index === 0) {
                    array.unshift.apply(array, this.elements);
                } else {
                    array.splice.apply(array, [index, 0].concat(this.elements));
                }
            };
            return NormalSeparatedSyntaxList;
        })();

        function separatedList(nodes) {
            return separatedListAndValidate(nodes, false);
        }
        Syntax.separatedList = separatedList;

        function separatedListAndValidate(nodes, validate) {
            if (nodes === undefined || nodes === null || nodes.length === 0) {
                return Syntax.emptySeparatedList;
            }

            if (validate) {
                for (var i = 0; i < nodes.length; i++) {
                    var item = nodes[i];

                    if (i % 2 === 1) {
                    }
                }
            }

            if (nodes.length === 1) {
                return new SingletonSeparatedSyntaxList(nodes[0]);
            }

            return new NormalSeparatedSyntaxList(nodes);
        }
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SlidingWindow = (function () {
        function SlidingWindow(source, window, defaultValue, sourceLength) {
            if (typeof sourceLength === "undefined") { sourceLength = -1; }
            this.source = source;
            this.window = window;
            this.defaultValue = defaultValue;
            this.sourceLength = sourceLength;
            this.windowCount = 0;
            this.windowAbsoluteStartIndex = 0;
            this.currentRelativeItemIndex = 0;
            this._pinCount = 0;
            this.firstPinnedAbsoluteIndex = -1;
        }
        SlidingWindow.prototype.windowAbsoluteEndIndex = function () {
            return this.windowAbsoluteStartIndex + this.windowCount;
        };

        SlidingWindow.prototype.addMoreItemsToWindow = function (argument) {
            if (this.sourceLength >= 0 && this.absoluteIndex() >= this.sourceLength) {
                return false;
            }

            if (this.windowCount >= this.window.length) {
                this.tryShiftOrGrowWindow();
            }

            var spaceAvailable = this.window.length - this.windowCount;
            var amountFetched = this.source.fetchMoreItems(argument, this.windowAbsoluteEndIndex(), this.window, this.windowCount, spaceAvailable);

            this.windowCount += amountFetched;
            return amountFetched > 0;
        };

        SlidingWindow.prototype.tryShiftOrGrowWindow = function () {
            var currentIndexIsPastWindowHalfwayPoint = this.currentRelativeItemIndex > (this.window.length >>> 1);

            var isAllowedToShift = this.firstPinnedAbsoluteIndex === -1 || this.firstPinnedAbsoluteIndex > this.windowAbsoluteStartIndex;

            if (currentIndexIsPastWindowHalfwayPoint && isAllowedToShift) {
                var shiftStartIndex = this.firstPinnedAbsoluteIndex === -1 ? this.currentRelativeItemIndex : this.firstPinnedAbsoluteIndex - this.windowAbsoluteStartIndex;

                var shiftCount = this.windowCount - shiftStartIndex;

                if (shiftCount > 0) {
                    TypeScript.ArrayUtilities.copy(this.window, shiftStartIndex, this.window, 0, shiftCount);
                }

                this.windowAbsoluteStartIndex += shiftStartIndex;

                this.windowCount -= shiftStartIndex;

                this.currentRelativeItemIndex -= shiftStartIndex;
            } else {
                TypeScript.ArrayUtilities.grow(this.window, this.window.length * 2, this.defaultValue);
            }
        };

        SlidingWindow.prototype.absoluteIndex = function () {
            return this.windowAbsoluteStartIndex + this.currentRelativeItemIndex;
        };

        SlidingWindow.prototype.isAtEndOfSource = function () {
            return this.absoluteIndex() >= this.sourceLength;
        };

        SlidingWindow.prototype.getAndPinAbsoluteIndex = function () {
            var absoluteIndex = this.absoluteIndex();
            var pinCount = this._pinCount++;
            if (pinCount === 0) {
                this.firstPinnedAbsoluteIndex = absoluteIndex;
            }

            return absoluteIndex;
        };

        SlidingWindow.prototype.releaseAndUnpinAbsoluteIndex = function (absoluteIndex) {
            this._pinCount--;
            if (this._pinCount === 0) {
                this.firstPinnedAbsoluteIndex = -1;
            }
        };

        SlidingWindow.prototype.rewindToPinnedIndex = function (absoluteIndex) {
            var relativeIndex = absoluteIndex - this.windowAbsoluteStartIndex;

            this.currentRelativeItemIndex = relativeIndex;
        };

        SlidingWindow.prototype.currentItem = function (argument) {
            if (this.currentRelativeItemIndex >= this.windowCount) {
                if (!this.addMoreItemsToWindow(argument)) {
                    return this.defaultValue;
                }
            }

            return this.window[this.currentRelativeItemIndex];
        };

        SlidingWindow.prototype.peekItemN = function (n) {
            while (this.currentRelativeItemIndex + n >= this.windowCount) {
                if (!this.addMoreItemsToWindow(null)) {
                    return this.defaultValue;
                }
            }

            return this.window[this.currentRelativeItemIndex + n];
        };

        SlidingWindow.prototype.moveToNextItem = function () {
            this.currentRelativeItemIndex++;
        };

        SlidingWindow.prototype.disgardAllItemsFromCurrentIndexOnwards = function () {
            this.windowCount = this.currentRelativeItemIndex;
        };

        SlidingWindow.prototype.setAbsoluteIndex = function (absoluteIndex) {
            if (this.absoluteIndex() === absoluteIndex) {
                return;
            }

            if (this._pinCount > 0) {
            }

            if (absoluteIndex >= this.windowAbsoluteStartIndex && absoluteIndex < this.windowAbsoluteEndIndex()) {
                this.currentRelativeItemIndex = (absoluteIndex - this.windowAbsoluteStartIndex);
            } else {
                this.windowAbsoluteStartIndex = absoluteIndex;

                this.windowCount = 0;

                this.currentRelativeItemIndex = 0;
            }
        };

        SlidingWindow.prototype.pinCount = function () {
            return this._pinCount;
        };
        return SlidingWindow;
    })();
    TypeScript.SlidingWindow = SlidingWindow;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Strings = (function () {
        function Strings() {
        }
        Strings.module__class__interface__enum__import_or_statement = "module, class, interface, enum, import or statement";
        Strings.constructor__function__accessor_or_variable = "constructor, function, accessor or variable";
        Strings.statement = "statement";
        Strings.case_or_default_clause = "case or default clause";
        Strings.identifier = "identifier";
        Strings.call__construct__index__property_or_function_signature = "call, construct, index, property or function signature";
        Strings.expression = "expression";
        Strings.type_name = "type name";
        Strings.property_or_accessor = "property or accessor";
        Strings.parameter = "parameter";
        Strings.type = "type";
        Strings.type_parameter = "type parameter";
        return Strings;
    })();
    TypeScript.Strings = Strings;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        function emptySourceUnit() {
            return TypeScript.Syntax.normalModeFactory.sourceUnit(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(10 /* EndOfFileToken */, { text: "" }));
        }
        Syntax.emptySourceUnit = emptySourceUnit;

        function getStandaloneExpression(positionedToken) {
            var token = positionedToken.token();
            if (positionedToken !== null && positionedToken.kind() === 11 /* IdentifierName */) {
                var parentPositionedNode = positionedToken.containingNode();
                var parentNode = parentPositionedNode.node();

                if (parentNode.kind() === 122 /* QualifiedName */ && (parentNode).right === token) {
                    return parentPositionedNode;
                } else if (parentNode.kind() === 211 /* MemberAccessExpression */ && (parentNode).name === token) {
                    return parentPositionedNode;
                }
            }

            return positionedToken;
        }
        Syntax.getStandaloneExpression = getStandaloneExpression;

        function isInModuleOrTypeContext(positionedToken) {
            if (positionedToken !== null) {
                var positionedNodeOrToken = TypeScript.Syntax.getStandaloneExpression(positionedToken);
                var parent = positionedNodeOrToken.containingNode();

                if (parent !== null) {
                    switch (parent.kind()) {
                        case 246 /* ModuleNameModuleReference */:
                            return true;
                        case 122 /* QualifiedName */:
                            return true;
                        default:
                            return isInTypeOnlyContext(positionedToken);
                    }
                }
            }

            return false;
        }
        Syntax.isInModuleOrTypeContext = isInModuleOrTypeContext;

        function isInTypeOnlyContext(positionedToken) {
            var positionedNodeOrToken = TypeScript.Syntax.getStandaloneExpression(positionedToken);
            var positionedParent = positionedNodeOrToken.containingNode();

            var parent = positionedParent.node();
            var nodeOrToken = positionedNodeOrToken.nodeOrToken();

            if (parent !== null) {
                switch (parent.kind()) {
                    case 125 /* ArrayType */:
                        return (parent).type === nodeOrToken;
                    case 219 /* CastExpression */:
                        return (parent).type === nodeOrToken;
                    case 244 /* TypeAnnotation */:
                    case 229 /* HeritageClause */:
                    case 227 /* TypeArgumentList */:
                        return true;
                }
            }

            return false;
        }
        Syntax.isInTypeOnlyContext = isInTypeOnlyContext;

        function childOffset(parent, child) {
            var offset = 0;
            for (var i = 0, n = parent.childCount(); i < n; i++) {
                var current = parent.childAt(i);
                if (current === child) {
                    return offset;
                }

                if (current !== null) {
                    offset += current.fullWidth();
                }
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.childOffset = childOffset;

        function childOffsetAt(parent, index) {
            var offset = 0;
            for (var i = 0; i < index; i++) {
                var current = parent.childAt(i);
                if (current !== null) {
                    offset += current.fullWidth();
                }
            }

            return offset;
        }
        Syntax.childOffsetAt = childOffsetAt;

        function childIndex(parent, child) {
            for (var i = 0, n = parent.childCount(); i < n; i++) {
                var current = parent.childAt(i);
                if (current === child) {
                    return i;
                }
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.childIndex = childIndex;

        function nodeStructuralEquals(node1, node2) {
            if (node1 === null) {
                return node2 === null;
            }

            return node1.structuralEquals(node2);
        }
        Syntax.nodeStructuralEquals = nodeStructuralEquals;

        function nodeOrTokenStructuralEquals(node1, node2) {
            if (node1 === node2) {
                return true;
            }

            if (node1 === null || node2 === null) {
                return false;
            }

            if (node1.isToken()) {
                return node2.isToken() ? tokenStructuralEquals(node1, node2) : false;
            }

            return node2.isNode() ? nodeStructuralEquals(node1, node2) : false;
        }
        Syntax.nodeOrTokenStructuralEquals = nodeOrTokenStructuralEquals;

        function tokenStructuralEquals(token1, token2) {
            if (token1 === token2) {
                return true;
            }

            if (token1 === null || token2 === null) {
                return false;
            }

            return token1.kind() === token2.kind() && token1.width() === token2.width() && token1.fullWidth() === token2.fullWidth() && token1.text() === token2.text() && TypeScript.Syntax.triviaListStructuralEquals(token1.leadingTrivia(), token2.leadingTrivia()) && TypeScript.Syntax.triviaListStructuralEquals(token1.trailingTrivia(), token2.trailingTrivia());
        }
        Syntax.tokenStructuralEquals = tokenStructuralEquals;

        function triviaListStructuralEquals(triviaList1, triviaList2) {
            if (triviaList1.count() !== triviaList2.count()) {
                return false;
            }

            for (var i = 0, n = triviaList1.count(); i < n; i++) {
                if (!TypeScript.Syntax.triviaStructuralEquals(triviaList1.syntaxTriviaAt(i), triviaList2.syntaxTriviaAt(i))) {
                    return false;
                }
            }

            return true;
        }
        Syntax.triviaListStructuralEquals = triviaListStructuralEquals;

        function triviaStructuralEquals(trivia1, trivia2) {
            return trivia1.kind() === trivia2.kind() && trivia1.fullWidth() === trivia2.fullWidth() && trivia1.fullText() === trivia2.fullText();
        }
        Syntax.triviaStructuralEquals = triviaStructuralEquals;

        function listStructuralEquals(list1, list2) {
            if (list1.childCount() !== list2.childCount()) {
                return false;
            }

            for (var i = 0, n = list1.childCount(); i < n; i++) {
                var child1 = list1.childAt(i);
                var child2 = list2.childAt(i);

                if (!TypeScript.Syntax.nodeOrTokenStructuralEquals(child1, child2)) {
                    return false;
                }
            }

            return true;
        }
        Syntax.listStructuralEquals = listStructuralEquals;

        function separatedListStructuralEquals(list1, list2) {
            if (list1.childCount() !== list2.childCount()) {
                return false;
            }

            for (var i = 0, n = list1.childCount(); i < n; i++) {
                var element1 = list1.childAt(i);
                var element2 = list2.childAt(i);
                if (!TypeScript.Syntax.nodeOrTokenStructuralEquals(element1, element2)) {
                    return false;
                }
            }

            return true;
        }
        Syntax.separatedListStructuralEquals = separatedListStructuralEquals;

        function elementStructuralEquals(element1, element2) {
            if (element1 === element2) {
                return true;
            }

            if (element1 === null || element2 === null) {
                return false;
            }

            if (element2.kind() !== element2.kind()) {
                return false;
            }

            if (element1.isToken()) {
                return tokenStructuralEquals(element1, element2);
            } else if (element1.isNode()) {
                return nodeStructuralEquals(element1, element2);
            } else if (element1.isList()) {
                return listStructuralEquals(element1, element2);
            } else if (element1.isSeparatedList()) {
                return separatedListStructuralEquals(element1, element2);
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.elementStructuralEquals = elementStructuralEquals;

        function identifierName(text, info) {
            if (typeof info === "undefined") { info = null; }
            return Syntax.identifier(text);
        }
        Syntax.identifierName = identifierName;

        function trueExpression() {
            return TypeScript.Syntax.token(37 /* TrueKeyword */);
        }
        Syntax.trueExpression = trueExpression;

        function falseExpression() {
            return TypeScript.Syntax.token(24 /* FalseKeyword */);
        }
        Syntax.falseExpression = falseExpression;

        function numericLiteralExpression(text) {
            return TypeScript.Syntax.token(13 /* NumericLiteral */, { text: text });
        }
        Syntax.numericLiteralExpression = numericLiteralExpression;

        function stringLiteralExpression(text) {
            return TypeScript.Syntax.token(14 /* StringLiteral */, { text: text });
        }
        Syntax.stringLiteralExpression = stringLiteralExpression;

        function isSuperInvocationExpression(node) {
            return node.kind() === 212 /* InvocationExpression */ && (node).expression.kind() === 50 /* SuperKeyword */;
        }
        Syntax.isSuperInvocationExpression = isSuperInvocationExpression;

        function isSuperInvocationExpressionStatement(node) {
            return node.kind() === 148 /* ExpressionStatement */ && isSuperInvocationExpression((node).expression);
        }
        Syntax.isSuperInvocationExpressionStatement = isSuperInvocationExpressionStatement;

        function isSuperMemberAccessExpression(node) {
            return node.kind() === 211 /* MemberAccessExpression */ && (node).expression.kind() === 50 /* SuperKeyword */;
        }
        Syntax.isSuperMemberAccessExpression = isSuperMemberAccessExpression;

        function isSuperMemberAccessInvocationExpression(node) {
            return node.kind() === 212 /* InvocationExpression */ && isSuperMemberAccessExpression((node).expression);
        }
        Syntax.isSuperMemberAccessInvocationExpression = isSuperMemberAccessInvocationExpression;

        function assignmentExpression(left, token, right) {
            return TypeScript.Syntax.normalModeFactory.binaryExpression(173 /* AssignmentExpression */, left, token, right);
        }
        Syntax.assignmentExpression = assignmentExpression;

        function nodeHasSkippedOrMissingTokens(node) {
            for (var i = 0; i < node.childCount(); i++) {
                var child = node.childAt(i);
                if (child !== null && child.isToken()) {
                    var token = child;

                    if (token.hasSkippedToken() || (token.width() === 0 && token.kind() !== 10 /* EndOfFileToken */)) {
                        return true;
                    }
                }
            }
            return false;
        }
        Syntax.nodeHasSkippedOrMissingTokens = nodeHasSkippedOrMissingTokens;

        function isUnterminatedStringLiteral(token) {
            if (token && token.kind() === 14 /* StringLiteral */) {
                var text = token.text();
                return text.length < 2 || text.charCodeAt(text.length - 1) !== text.charCodeAt(0);
            }

            return false;
        }
        Syntax.isUnterminatedStringLiteral = isUnterminatedStringLiteral;

        function isUnterminatedMultilineCommentTrivia(trivia) {
            if (trivia && trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                var text = trivia.fullText();
                return text.length < 4 || text.substring(text.length - 2) !== "*/";
            }
            return false;
        }
        Syntax.isUnterminatedMultilineCommentTrivia = isUnterminatedMultilineCommentTrivia;

        function isEntirelyInsideCommentTrivia(trivia, fullStart, position) {
            if (trivia && trivia.isComment() && position > fullStart) {
                var end = fullStart + trivia.fullWidth();
                if (position < end) {
                    return true;
                } else if (position === end) {
                    return trivia.kind() === 7 /* SingleLineCommentTrivia */ || isUnterminatedMultilineCommentTrivia(trivia);
                }
            }

            return false;
        }
        Syntax.isEntirelyInsideCommentTrivia = isEntirelyInsideCommentTrivia;

        function isEntirelyInsideComment(sourceUnit, position) {
            var positionedToken = sourceUnit.findToken(position);
            var fullStart = positionedToken.fullStart();
            var triviaList = null;
            var lastTriviaBeforeToken = null;

            if (positionedToken.kind() === 10 /* EndOfFileToken */) {
                if (positionedToken.token().hasLeadingTrivia()) {
                    triviaList = positionedToken.token().leadingTrivia();
                } else {
                    positionedToken = positionedToken.previousToken();
                    if (positionedToken) {
                        if (positionedToken && positionedToken.token().hasTrailingTrivia()) {
                            triviaList = positionedToken.token().trailingTrivia();
                            fullStart = positionedToken.end();
                        }
                    }
                }
            } else {
                if (position <= (fullStart + positionedToken.token().leadingTriviaWidth())) {
                    triviaList = positionedToken.token().leadingTrivia();
                } else if (position >= (fullStart + positionedToken.token().width())) {
                    triviaList = positionedToken.token().trailingTrivia();
                    fullStart = positionedToken.end();
                }
            }

            if (triviaList) {
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (position <= fullStart) {
                        break;
                    } else if (position <= fullStart + trivia.fullWidth() && trivia.isComment()) {
                        lastTriviaBeforeToken = trivia;
                        break;
                    }

                    fullStart += trivia.fullWidth();
                }
            }

            return lastTriviaBeforeToken && isEntirelyInsideCommentTrivia(lastTriviaBeforeToken, fullStart, position);
        }
        Syntax.isEntirelyInsideComment = isEntirelyInsideComment;

        function isEntirelyInStringOrRegularExpressionLiteral(sourceUnit, position) {
            var positionedToken = sourceUnit.findToken(position);

            if (positionedToken) {
                if (positionedToken.kind() === 10 /* EndOfFileToken */) {
                    positionedToken = positionedToken.previousToken();
                    return positionedToken && positionedToken.token().trailingTriviaWidth() === 0 && isUnterminatedStringLiteral(positionedToken.token());
                } else if (position > positionedToken.start()) {
                    return (position < positionedToken.end() && (positionedToken.kind() === 14 /* StringLiteral */ || positionedToken.kind() === 12 /* RegularExpressionLiteral */)) || (position <= positionedToken.end() && isUnterminatedStringLiteral(positionedToken.token()));
                }
            }

            return false;
        }
        Syntax.isEntirelyInStringOrRegularExpressionLiteral = isEntirelyInStringOrRegularExpressionLiteral;

        function findSkippedTokenInTriviaList(positionedToken, position, lookInLeadingTriviaList) {
            var triviaList = null;
            var fullStart;

            if (lookInLeadingTriviaList) {
                triviaList = positionedToken.token().leadingTrivia();
                fullStart = positionedToken.fullStart();
            } else {
                triviaList = positionedToken.token().trailingTrivia();
                fullStart = positionedToken.end();
            }

            if (triviaList && triviaList.hasSkippedToken()) {
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    var triviaWidth = trivia.fullWidth();

                    if (trivia.isSkippedToken() && position >= fullStart && position <= fullStart + triviaWidth) {
                        return new TypeScript.PositionedSkippedToken(positionedToken, trivia.skippedToken(), fullStart);
                    }

                    fullStart += triviaWidth;
                }
            }

            return null;
        }

        function findSkippedTokenInLeadingTriviaList(positionedToken, position) {
            return findSkippedTokenInTriviaList(positionedToken, position, true);
        }
        Syntax.findSkippedTokenInLeadingTriviaList = findSkippedTokenInLeadingTriviaList;

        function findSkippedTokenInTrailingTriviaList(positionedToken, position) {
            return findSkippedTokenInTriviaList(positionedToken, position, false);
        }
        Syntax.findSkippedTokenInTrailingTriviaList = findSkippedTokenInTrailingTriviaList;

        function findSkippedTokenInPositionedToken(positionedToken, position) {
            var positionInLeadingTriviaList = (position < positionedToken.start());
            return findSkippedTokenInTriviaList(positionedToken, position, positionInLeadingTriviaList);
        }
        Syntax.findSkippedTokenInPositionedToken = findSkippedTokenInPositionedToken;

        function getAncestorOfKind(positionedToken, kind) {
            while (positionedToken && positionedToken.parent()) {
                if (positionedToken.parent().kind() === kind) {
                    return positionedToken.parent();
                }

                positionedToken = positionedToken.parent();
            }

            return null;
        }
        Syntax.getAncestorOfKind = getAncestorOfKind;

        function hasAncestorOfKind(positionedToken, kind) {
            return TypeScript.Syntax.getAncestorOfKind(positionedToken, kind) !== null;
        }
        Syntax.hasAncestorOfKind = hasAncestorOfKind;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxDiagnostic = (function (_super) {
        __extends(SyntaxDiagnostic, _super);
        function SyntaxDiagnostic() {
            _super.apply(this, arguments);
        }
        SyntaxDiagnostic.equals = function (diagnostic1, diagnostic2) {
            return TypeScript.Diagnostic.equals(diagnostic1, diagnostic2);
        };
        return SyntaxDiagnostic;
    })(TypeScript.Diagnostic);
    TypeScript.SyntaxDiagnostic = SyntaxDiagnostic;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var NormalModeFactory = (function () {
            function NormalModeFactory() {
            }
            NormalModeFactory.prototype.sourceUnit = function (moduleElements, endOfFileToken) {
                return new TypeScript.SourceUnitSyntax(moduleElements, endOfFileToken, false);
            };
            NormalModeFactory.prototype.externalModuleReference = function (moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken) {
                return new TypeScript.ExternalModuleReferenceSyntax(moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken, false);
            };
            NormalModeFactory.prototype.moduleNameModuleReference = function (moduleName) {
                return new TypeScript.ModuleNameModuleReferenceSyntax(moduleName, false);
            };
            NormalModeFactory.prototype.importDeclaration = function (importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
                return new TypeScript.ImportDeclarationSyntax(importKeyword, identifier, equalsToken, moduleReference, semicolonToken, false);
            };
            NormalModeFactory.prototype.exportAssignment = function (exportKeyword, equalsToken, identifier, semicolonToken) {
                return new TypeScript.ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.classDeclaration = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
                return new TypeScript.ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.interfaceDeclaration = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
                return new TypeScript.InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, false);
            };
            NormalModeFactory.prototype.heritageClause = function (extendsOrImplementsKeyword, typeNames) {
                return new TypeScript.HeritageClauseSyntax(extendsOrImplementsKeyword, typeNames, false);
            };
            NormalModeFactory.prototype.moduleDeclaration = function (modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
                return new TypeScript.ModuleDeclarationSyntax(modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.functionDeclaration = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
                return new TypeScript.FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.variableStatement = function (modifiers, variableDeclaration, semicolonToken) {
                return new TypeScript.VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, false);
            };
            NormalModeFactory.prototype.variableDeclaration = function (varKeyword, variableDeclarators) {
                return new TypeScript.VariableDeclarationSyntax(varKeyword, variableDeclarators, false);
            };
            NormalModeFactory.prototype.variableDeclarator = function (identifier, typeAnnotation, equalsValueClause) {
                return new TypeScript.VariableDeclaratorSyntax(identifier, typeAnnotation, equalsValueClause, false);
            };
            NormalModeFactory.prototype.equalsValueClause = function (equalsToken, value) {
                return new TypeScript.EqualsValueClauseSyntax(equalsToken, value, false);
            };
            NormalModeFactory.prototype.prefixUnaryExpression = function (kind, operatorToken, operand) {
                return new TypeScript.PrefixUnaryExpressionSyntax(kind, operatorToken, operand, false);
            };
            NormalModeFactory.prototype.arrayLiteralExpression = function (openBracketToken, expressions, closeBracketToken) {
                return new TypeScript.ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, false);
            };
            NormalModeFactory.prototype.omittedExpression = function () {
                return new TypeScript.OmittedExpressionSyntax(false);
            };
            NormalModeFactory.prototype.parenthesizedExpression = function (openParenToken, expression, closeParenToken) {
                return new TypeScript.ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, false);
            };
            NormalModeFactory.prototype.simpleArrowFunctionExpression = function (identifier, equalsGreaterThanToken, body) {
                return new TypeScript.SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, body, false);
            };
            NormalModeFactory.prototype.parenthesizedArrowFunctionExpression = function (callSignature, equalsGreaterThanToken, body) {
                return new TypeScript.ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, body, false);
            };
            NormalModeFactory.prototype.qualifiedName = function (left, dotToken, right) {
                return new TypeScript.QualifiedNameSyntax(left, dotToken, right, false);
            };
            NormalModeFactory.prototype.typeArgumentList = function (lessThanToken, typeArguments, greaterThanToken) {
                return new TypeScript.TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, false);
            };
            NormalModeFactory.prototype.constructorType = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, false);
            };
            NormalModeFactory.prototype.functionType = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, false);
            };
            NormalModeFactory.prototype.objectType = function (openBraceToken, typeMembers, closeBraceToken) {
                return new TypeScript.ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, false);
            };
            NormalModeFactory.prototype.arrayType = function (type, openBracketToken, closeBracketToken) {
                return new TypeScript.ArrayTypeSyntax(type, openBracketToken, closeBracketToken, false);
            };
            NormalModeFactory.prototype.genericType = function (name, typeArgumentList) {
                return new TypeScript.GenericTypeSyntax(name, typeArgumentList, false);
            };
            NormalModeFactory.prototype.typeAnnotation = function (colonToken, type) {
                return new TypeScript.TypeAnnotationSyntax(colonToken, type, false);
            };
            NormalModeFactory.prototype.block = function (openBraceToken, statements, closeBraceToken) {
                return new TypeScript.BlockSyntax(openBraceToken, statements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.parameter = function (dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause) {
                return new TypeScript.ParameterSyntax(dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause, false);
            };
            NormalModeFactory.prototype.memberAccessExpression = function (expression, dotToken, name) {
                return new TypeScript.MemberAccessExpressionSyntax(expression, dotToken, name, false);
            };
            NormalModeFactory.prototype.postfixUnaryExpression = function (kind, operand, operatorToken) {
                return new TypeScript.PostfixUnaryExpressionSyntax(kind, operand, operatorToken, false);
            };
            NormalModeFactory.prototype.elementAccessExpression = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
                return new TypeScript.ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, false);
            };
            NormalModeFactory.prototype.invocationExpression = function (expression, argumentList) {
                return new TypeScript.InvocationExpressionSyntax(expression, argumentList, false);
            };
            NormalModeFactory.prototype.argumentList = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
                return new TypeScript.ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, false);
            };
            NormalModeFactory.prototype.binaryExpression = function (kind, left, operatorToken, right) {
                return new TypeScript.BinaryExpressionSyntax(kind, left, operatorToken, right, false);
            };
            NormalModeFactory.prototype.conditionalExpression = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
                return new TypeScript.ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, false);
            };
            NormalModeFactory.prototype.constructSignature = function (newKeyword, callSignature) {
                return new TypeScript.ConstructSignatureSyntax(newKeyword, callSignature, false);
            };
            NormalModeFactory.prototype.methodSignature = function (propertyName, questionToken, callSignature) {
                return new TypeScript.MethodSignatureSyntax(propertyName, questionToken, callSignature, false);
            };
            NormalModeFactory.prototype.indexSignature = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
                return new TypeScript.IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, false);
            };
            NormalModeFactory.prototype.propertySignature = function (propertyName, questionToken, typeAnnotation) {
                return new TypeScript.PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, false);
            };
            NormalModeFactory.prototype.callSignature = function (typeParameterList, parameterList, typeAnnotation) {
                return new TypeScript.CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, false);
            };
            NormalModeFactory.prototype.parameterList = function (openParenToken, parameters, closeParenToken) {
                return new TypeScript.ParameterListSyntax(openParenToken, parameters, closeParenToken, false);
            };
            NormalModeFactory.prototype.typeParameterList = function (lessThanToken, typeParameters, greaterThanToken) {
                return new TypeScript.TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, false);
            };
            NormalModeFactory.prototype.typeParameter = function (identifier, constraint) {
                return new TypeScript.TypeParameterSyntax(identifier, constraint, false);
            };
            NormalModeFactory.prototype.constraint = function (extendsKeyword, type) {
                return new TypeScript.ConstraintSyntax(extendsKeyword, type, false);
            };
            NormalModeFactory.prototype.elseClause = function (elseKeyword, statement) {
                return new TypeScript.ElseClauseSyntax(elseKeyword, statement, false);
            };
            NormalModeFactory.prototype.ifStatement = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
                return new TypeScript.IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, false);
            };
            NormalModeFactory.prototype.expressionStatement = function (expression, semicolonToken) {
                return new TypeScript.ExpressionStatementSyntax(expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.constructorDeclaration = function (constructorKeyword, parameterList, block, semicolonToken) {
                return new TypeScript.ConstructorDeclarationSyntax(constructorKeyword, parameterList, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.memberFunctionDeclaration = function (modifiers, propertyName, callSignature, block, semicolonToken) {
                return new TypeScript.MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.getMemberAccessorDeclaration = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
                return new TypeScript.GetMemberAccessorDeclarationSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, false);
            };
            NormalModeFactory.prototype.setMemberAccessorDeclaration = function (modifiers, setKeyword, propertyName, parameterList, block) {
                return new TypeScript.SetMemberAccessorDeclarationSyntax(modifiers, setKeyword, propertyName, parameterList, block, false);
            };
            NormalModeFactory.prototype.memberVariableDeclaration = function (modifiers, variableDeclarator, semicolonToken) {
                return new TypeScript.MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, false);
            };
            NormalModeFactory.prototype.throwStatement = function (throwKeyword, expression, semicolonToken) {
                return new TypeScript.ThrowStatementSyntax(throwKeyword, expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.returnStatement = function (returnKeyword, expression, semicolonToken) {
                return new TypeScript.ReturnStatementSyntax(returnKeyword, expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.objectCreationExpression = function (newKeyword, expression, argumentList) {
                return new TypeScript.ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, false);
            };
            NormalModeFactory.prototype.switchStatement = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
                return new TypeScript.SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, false);
            };
            NormalModeFactory.prototype.caseSwitchClause = function (caseKeyword, expression, colonToken, statements) {
                return new TypeScript.CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, false);
            };
            NormalModeFactory.prototype.defaultSwitchClause = function (defaultKeyword, colonToken, statements) {
                return new TypeScript.DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, false);
            };
            NormalModeFactory.prototype.breakStatement = function (breakKeyword, identifier, semicolonToken) {
                return new TypeScript.BreakStatementSyntax(breakKeyword, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.continueStatement = function (continueKeyword, identifier, semicolonToken) {
                return new TypeScript.ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.forStatement = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
                return new TypeScript.ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.forInStatement = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
                return new TypeScript.ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.whileStatement = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.withStatement = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.enumDeclaration = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
                return new TypeScript.EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.enumElement = function (propertyName, equalsValueClause) {
                return new TypeScript.EnumElementSyntax(propertyName, equalsValueClause, false);
            };
            NormalModeFactory.prototype.castExpression = function (lessThanToken, type, greaterThanToken, expression) {
                return new TypeScript.CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, false);
            };
            NormalModeFactory.prototype.objectLiteralExpression = function (openBraceToken, propertyAssignments, closeBraceToken) {
                return new TypeScript.ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, false);
            };
            NormalModeFactory.prototype.simplePropertyAssignment = function (propertyName, colonToken, expression) {
                return new TypeScript.SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, false);
            };
            NormalModeFactory.prototype.functionPropertyAssignment = function (propertyName, callSignature, block) {
                return new TypeScript.FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, false);
            };
            NormalModeFactory.prototype.getAccessorPropertyAssignment = function (getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block) {
                return new TypeScript.GetAccessorPropertyAssignmentSyntax(getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block, false);
            };
            NormalModeFactory.prototype.setAccessorPropertyAssignment = function (setKeyword, propertyName, openParenToken, parameter, closeParenToken, block) {
                return new TypeScript.SetAccessorPropertyAssignmentSyntax(setKeyword, propertyName, openParenToken, parameter, closeParenToken, block, false);
            };
            NormalModeFactory.prototype.functionExpression = function (functionKeyword, identifier, callSignature, block) {
                return new TypeScript.FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, false);
            };
            NormalModeFactory.prototype.emptyStatement = function (semicolonToken) {
                return new TypeScript.EmptyStatementSyntax(semicolonToken, false);
            };
            NormalModeFactory.prototype.tryStatement = function (tryKeyword, block, catchClause, finallyClause) {
                return new TypeScript.TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, false);
            };
            NormalModeFactory.prototype.catchClause = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
                return new TypeScript.CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, false);
            };
            NormalModeFactory.prototype.finallyClause = function (finallyKeyword, block) {
                return new TypeScript.FinallyClauseSyntax(finallyKeyword, block, false);
            };
            NormalModeFactory.prototype.labeledStatement = function (identifier, colonToken, statement) {
                return new TypeScript.LabeledStatementSyntax(identifier, colonToken, statement, false);
            };
            NormalModeFactory.prototype.doStatement = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
                return new TypeScript.DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, false);
            };
            NormalModeFactory.prototype.typeOfExpression = function (typeOfKeyword, expression) {
                return new TypeScript.TypeOfExpressionSyntax(typeOfKeyword, expression, false);
            };
            NormalModeFactory.prototype.deleteExpression = function (deleteKeyword, expression) {
                return new TypeScript.DeleteExpressionSyntax(deleteKeyword, expression, false);
            };
            NormalModeFactory.prototype.voidExpression = function (voidKeyword, expression) {
                return new TypeScript.VoidExpressionSyntax(voidKeyword, expression, false);
            };
            NormalModeFactory.prototype.debuggerStatement = function (debuggerKeyword, semicolonToken) {
                return new TypeScript.DebuggerStatementSyntax(debuggerKeyword, semicolonToken, false);
            };
            return NormalModeFactory;
        })();
        Syntax.NormalModeFactory = NormalModeFactory;

        var StrictModeFactory = (function () {
            function StrictModeFactory() {
            }
            StrictModeFactory.prototype.sourceUnit = function (moduleElements, endOfFileToken) {
                return new TypeScript.SourceUnitSyntax(moduleElements, endOfFileToken, true);
            };
            StrictModeFactory.prototype.externalModuleReference = function (moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken) {
                return new TypeScript.ExternalModuleReferenceSyntax(moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken, true);
            };
            StrictModeFactory.prototype.moduleNameModuleReference = function (moduleName) {
                return new TypeScript.ModuleNameModuleReferenceSyntax(moduleName, true);
            };
            StrictModeFactory.prototype.importDeclaration = function (importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
                return new TypeScript.ImportDeclarationSyntax(importKeyword, identifier, equalsToken, moduleReference, semicolonToken, true);
            };
            StrictModeFactory.prototype.exportAssignment = function (exportKeyword, equalsToken, identifier, semicolonToken) {
                return new TypeScript.ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.classDeclaration = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
                return new TypeScript.ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.interfaceDeclaration = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
                return new TypeScript.InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, true);
            };
            StrictModeFactory.prototype.heritageClause = function (extendsOrImplementsKeyword, typeNames) {
                return new TypeScript.HeritageClauseSyntax(extendsOrImplementsKeyword, typeNames, true);
            };
            StrictModeFactory.prototype.moduleDeclaration = function (modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
                return new TypeScript.ModuleDeclarationSyntax(modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.functionDeclaration = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
                return new TypeScript.FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.variableStatement = function (modifiers, variableDeclaration, semicolonToken) {
                return new TypeScript.VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, true);
            };
            StrictModeFactory.prototype.variableDeclaration = function (varKeyword, variableDeclarators) {
                return new TypeScript.VariableDeclarationSyntax(varKeyword, variableDeclarators, true);
            };
            StrictModeFactory.prototype.variableDeclarator = function (identifier, typeAnnotation, equalsValueClause) {
                return new TypeScript.VariableDeclaratorSyntax(identifier, typeAnnotation, equalsValueClause, true);
            };
            StrictModeFactory.prototype.equalsValueClause = function (equalsToken, value) {
                return new TypeScript.EqualsValueClauseSyntax(equalsToken, value, true);
            };
            StrictModeFactory.prototype.prefixUnaryExpression = function (kind, operatorToken, operand) {
                return new TypeScript.PrefixUnaryExpressionSyntax(kind, operatorToken, operand, true);
            };
            StrictModeFactory.prototype.arrayLiteralExpression = function (openBracketToken, expressions, closeBracketToken) {
                return new TypeScript.ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, true);
            };
            StrictModeFactory.prototype.omittedExpression = function () {
                return new TypeScript.OmittedExpressionSyntax(true);
            };
            StrictModeFactory.prototype.parenthesizedExpression = function (openParenToken, expression, closeParenToken) {
                return new TypeScript.ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, true);
            };
            StrictModeFactory.prototype.simpleArrowFunctionExpression = function (identifier, equalsGreaterThanToken, body) {
                return new TypeScript.SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, body, true);
            };
            StrictModeFactory.prototype.parenthesizedArrowFunctionExpression = function (callSignature, equalsGreaterThanToken, body) {
                return new TypeScript.ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, body, true);
            };
            StrictModeFactory.prototype.qualifiedName = function (left, dotToken, right) {
                return new TypeScript.QualifiedNameSyntax(left, dotToken, right, true);
            };
            StrictModeFactory.prototype.typeArgumentList = function (lessThanToken, typeArguments, greaterThanToken) {
                return new TypeScript.TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, true);
            };
            StrictModeFactory.prototype.constructorType = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, true);
            };
            StrictModeFactory.prototype.functionType = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, true);
            };
            StrictModeFactory.prototype.objectType = function (openBraceToken, typeMembers, closeBraceToken) {
                return new TypeScript.ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, true);
            };
            StrictModeFactory.prototype.arrayType = function (type, openBracketToken, closeBracketToken) {
                return new TypeScript.ArrayTypeSyntax(type, openBracketToken, closeBracketToken, true);
            };
            StrictModeFactory.prototype.genericType = function (name, typeArgumentList) {
                return new TypeScript.GenericTypeSyntax(name, typeArgumentList, true);
            };
            StrictModeFactory.prototype.typeAnnotation = function (colonToken, type) {
                return new TypeScript.TypeAnnotationSyntax(colonToken, type, true);
            };
            StrictModeFactory.prototype.block = function (openBraceToken, statements, closeBraceToken) {
                return new TypeScript.BlockSyntax(openBraceToken, statements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.parameter = function (dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause) {
                return new TypeScript.ParameterSyntax(dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause, true);
            };
            StrictModeFactory.prototype.memberAccessExpression = function (expression, dotToken, name) {
                return new TypeScript.MemberAccessExpressionSyntax(expression, dotToken, name, true);
            };
            StrictModeFactory.prototype.postfixUnaryExpression = function (kind, operand, operatorToken) {
                return new TypeScript.PostfixUnaryExpressionSyntax(kind, operand, operatorToken, true);
            };
            StrictModeFactory.prototype.elementAccessExpression = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
                return new TypeScript.ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, true);
            };
            StrictModeFactory.prototype.invocationExpression = function (expression, argumentList) {
                return new TypeScript.InvocationExpressionSyntax(expression, argumentList, true);
            };
            StrictModeFactory.prototype.argumentList = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
                return new TypeScript.ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, true);
            };
            StrictModeFactory.prototype.binaryExpression = function (kind, left, operatorToken, right) {
                return new TypeScript.BinaryExpressionSyntax(kind, left, operatorToken, right, true);
            };
            StrictModeFactory.prototype.conditionalExpression = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
                return new TypeScript.ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, true);
            };
            StrictModeFactory.prototype.constructSignature = function (newKeyword, callSignature) {
                return new TypeScript.ConstructSignatureSyntax(newKeyword, callSignature, true);
            };
            StrictModeFactory.prototype.methodSignature = function (propertyName, questionToken, callSignature) {
                return new TypeScript.MethodSignatureSyntax(propertyName, questionToken, callSignature, true);
            };
            StrictModeFactory.prototype.indexSignature = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
                return new TypeScript.IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, true);
            };
            StrictModeFactory.prototype.propertySignature = function (propertyName, questionToken, typeAnnotation) {
                return new TypeScript.PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, true);
            };
            StrictModeFactory.prototype.callSignature = function (typeParameterList, parameterList, typeAnnotation) {
                return new TypeScript.CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, true);
            };
            StrictModeFactory.prototype.parameterList = function (openParenToken, parameters, closeParenToken) {
                return new TypeScript.ParameterListSyntax(openParenToken, parameters, closeParenToken, true);
            };
            StrictModeFactory.prototype.typeParameterList = function (lessThanToken, typeParameters, greaterThanToken) {
                return new TypeScript.TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, true);
            };
            StrictModeFactory.prototype.typeParameter = function (identifier, constraint) {
                return new TypeScript.TypeParameterSyntax(identifier, constraint, true);
            };
            StrictModeFactory.prototype.constraint = function (extendsKeyword, type) {
                return new TypeScript.ConstraintSyntax(extendsKeyword, type, true);
            };
            StrictModeFactory.prototype.elseClause = function (elseKeyword, statement) {
                return new TypeScript.ElseClauseSyntax(elseKeyword, statement, true);
            };
            StrictModeFactory.prototype.ifStatement = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
                return new TypeScript.IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, true);
            };
            StrictModeFactory.prototype.expressionStatement = function (expression, semicolonToken) {
                return new TypeScript.ExpressionStatementSyntax(expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.constructorDeclaration = function (constructorKeyword, parameterList, block, semicolonToken) {
                return new TypeScript.ConstructorDeclarationSyntax(constructorKeyword, parameterList, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.memberFunctionDeclaration = function (modifiers, propertyName, callSignature, block, semicolonToken) {
                return new TypeScript.MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.getMemberAccessorDeclaration = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
                return new TypeScript.GetMemberAccessorDeclarationSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, true);
            };
            StrictModeFactory.prototype.setMemberAccessorDeclaration = function (modifiers, setKeyword, propertyName, parameterList, block) {
                return new TypeScript.SetMemberAccessorDeclarationSyntax(modifiers, setKeyword, propertyName, parameterList, block, true);
            };
            StrictModeFactory.prototype.memberVariableDeclaration = function (modifiers, variableDeclarator, semicolonToken) {
                return new TypeScript.MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, true);
            };
            StrictModeFactory.prototype.throwStatement = function (throwKeyword, expression, semicolonToken) {
                return new TypeScript.ThrowStatementSyntax(throwKeyword, expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.returnStatement = function (returnKeyword, expression, semicolonToken) {
                return new TypeScript.ReturnStatementSyntax(returnKeyword, expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.objectCreationExpression = function (newKeyword, expression, argumentList) {
                return new TypeScript.ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, true);
            };
            StrictModeFactory.prototype.switchStatement = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
                return new TypeScript.SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, true);
            };
            StrictModeFactory.prototype.caseSwitchClause = function (caseKeyword, expression, colonToken, statements) {
                return new TypeScript.CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, true);
            };
            StrictModeFactory.prototype.defaultSwitchClause = function (defaultKeyword, colonToken, statements) {
                return new TypeScript.DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, true);
            };
            StrictModeFactory.prototype.breakStatement = function (breakKeyword, identifier, semicolonToken) {
                return new TypeScript.BreakStatementSyntax(breakKeyword, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.continueStatement = function (continueKeyword, identifier, semicolonToken) {
                return new TypeScript.ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.forStatement = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
                return new TypeScript.ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.forInStatement = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
                return new TypeScript.ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.whileStatement = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.withStatement = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.enumDeclaration = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
                return new TypeScript.EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.enumElement = function (propertyName, equalsValueClause) {
                return new TypeScript.EnumElementSyntax(propertyName, equalsValueClause, true);
            };
            StrictModeFactory.prototype.castExpression = function (lessThanToken, type, greaterThanToken, expression) {
                return new TypeScript.CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, true);
            };
            StrictModeFactory.prototype.objectLiteralExpression = function (openBraceToken, propertyAssignments, closeBraceToken) {
                return new TypeScript.ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, true);
            };
            StrictModeFactory.prototype.simplePropertyAssignment = function (propertyName, colonToken, expression) {
                return new TypeScript.SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, true);
            };
            StrictModeFactory.prototype.functionPropertyAssignment = function (propertyName, callSignature, block) {
                return new TypeScript.FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, true);
            };
            StrictModeFactory.prototype.getAccessorPropertyAssignment = function (getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block) {
                return new TypeScript.GetAccessorPropertyAssignmentSyntax(getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block, true);
            };
            StrictModeFactory.prototype.setAccessorPropertyAssignment = function (setKeyword, propertyName, openParenToken, parameter, closeParenToken, block) {
                return new TypeScript.SetAccessorPropertyAssignmentSyntax(setKeyword, propertyName, openParenToken, parameter, closeParenToken, block, true);
            };
            StrictModeFactory.prototype.functionExpression = function (functionKeyword, identifier, callSignature, block) {
                return new TypeScript.FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, true);
            };
            StrictModeFactory.prototype.emptyStatement = function (semicolonToken) {
                return new TypeScript.EmptyStatementSyntax(semicolonToken, true);
            };
            StrictModeFactory.prototype.tryStatement = function (tryKeyword, block, catchClause, finallyClause) {
                return new TypeScript.TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, true);
            };
            StrictModeFactory.prototype.catchClause = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
                return new TypeScript.CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, true);
            };
            StrictModeFactory.prototype.finallyClause = function (finallyKeyword, block) {
                return new TypeScript.FinallyClauseSyntax(finallyKeyword, block, true);
            };
            StrictModeFactory.prototype.labeledStatement = function (identifier, colonToken, statement) {
                return new TypeScript.LabeledStatementSyntax(identifier, colonToken, statement, true);
            };
            StrictModeFactory.prototype.doStatement = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
                return new TypeScript.DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, true);
            };
            StrictModeFactory.prototype.typeOfExpression = function (typeOfKeyword, expression) {
                return new TypeScript.TypeOfExpressionSyntax(typeOfKeyword, expression, true);
            };
            StrictModeFactory.prototype.deleteExpression = function (deleteKeyword, expression) {
                return new TypeScript.DeleteExpressionSyntax(deleteKeyword, expression, true);
            };
            StrictModeFactory.prototype.voidExpression = function (voidKeyword, expression) {
                return new TypeScript.VoidExpressionSyntax(voidKeyword, expression, true);
            };
            StrictModeFactory.prototype.debuggerStatement = function (debuggerKeyword, semicolonToken) {
                return new TypeScript.DebuggerStatementSyntax(debuggerKeyword, semicolonToken, true);
            };
            return StrictModeFactory;
        })();
        Syntax.StrictModeFactory = StrictModeFactory;

        Syntax.normalModeFactory = new NormalModeFactory();
        Syntax.strictModeFactory = new StrictModeFactory();
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxKind) {
        SyntaxKind[SyntaxKind["None"] = 0] = "None";
        SyntaxKind[SyntaxKind["List"] = 1] = "List";
        SyntaxKind[SyntaxKind["SeparatedList"] = 2] = "SeparatedList";
        SyntaxKind[SyntaxKind["TriviaList"] = 3] = "TriviaList";

        SyntaxKind[SyntaxKind["WhitespaceTrivia"] = 4] = "WhitespaceTrivia";
        SyntaxKind[SyntaxKind["NewLineTrivia"] = 5] = "NewLineTrivia";
        SyntaxKind[SyntaxKind["MultiLineCommentTrivia"] = 6] = "MultiLineCommentTrivia";
        SyntaxKind[SyntaxKind["SingleLineCommentTrivia"] = 7] = "SingleLineCommentTrivia";
        SyntaxKind[SyntaxKind["SkippedTokenTrivia"] = 8] = "SkippedTokenTrivia";

        SyntaxKind[SyntaxKind["ErrorToken"] = 9] = "ErrorToken";
        SyntaxKind[SyntaxKind["EndOfFileToken"] = 10] = "EndOfFileToken";

        SyntaxKind[SyntaxKind["IdentifierName"] = 11] = "IdentifierName";

        SyntaxKind[SyntaxKind["RegularExpressionLiteral"] = 12] = "RegularExpressionLiteral";
        SyntaxKind[SyntaxKind["NumericLiteral"] = 13] = "NumericLiteral";
        SyntaxKind[SyntaxKind["StringLiteral"] = 14] = "StringLiteral";

        SyntaxKind[SyntaxKind["BreakKeyword"] = 15] = "BreakKeyword";
        SyntaxKind[SyntaxKind["CaseKeyword"] = 16] = "CaseKeyword";
        SyntaxKind[SyntaxKind["CatchKeyword"] = 17] = "CatchKeyword";
        SyntaxKind[SyntaxKind["ContinueKeyword"] = 18] = "ContinueKeyword";
        SyntaxKind[SyntaxKind["DebuggerKeyword"] = 19] = "DebuggerKeyword";
        SyntaxKind[SyntaxKind["DefaultKeyword"] = 20] = "DefaultKeyword";
        SyntaxKind[SyntaxKind["DeleteKeyword"] = 21] = "DeleteKeyword";
        SyntaxKind[SyntaxKind["DoKeyword"] = 22] = "DoKeyword";
        SyntaxKind[SyntaxKind["ElseKeyword"] = 23] = "ElseKeyword";
        SyntaxKind[SyntaxKind["FalseKeyword"] = 24] = "FalseKeyword";
        SyntaxKind[SyntaxKind["FinallyKeyword"] = 25] = "FinallyKeyword";
        SyntaxKind[SyntaxKind["ForKeyword"] = 26] = "ForKeyword";
        SyntaxKind[SyntaxKind["FunctionKeyword"] = 27] = "FunctionKeyword";
        SyntaxKind[SyntaxKind["IfKeyword"] = 28] = "IfKeyword";
        SyntaxKind[SyntaxKind["InKeyword"] = 29] = "InKeyword";
        SyntaxKind[SyntaxKind["InstanceOfKeyword"] = 30] = "InstanceOfKeyword";
        SyntaxKind[SyntaxKind["NewKeyword"] = 31] = "NewKeyword";
        SyntaxKind[SyntaxKind["NullKeyword"] = 32] = "NullKeyword";
        SyntaxKind[SyntaxKind["ReturnKeyword"] = 33] = "ReturnKeyword";
        SyntaxKind[SyntaxKind["SwitchKeyword"] = 34] = "SwitchKeyword";
        SyntaxKind[SyntaxKind["ThisKeyword"] = 35] = "ThisKeyword";
        SyntaxKind[SyntaxKind["ThrowKeyword"] = 36] = "ThrowKeyword";
        SyntaxKind[SyntaxKind["TrueKeyword"] = 37] = "TrueKeyword";
        SyntaxKind[SyntaxKind["TryKeyword"] = 38] = "TryKeyword";
        SyntaxKind[SyntaxKind["TypeOfKeyword"] = 39] = "TypeOfKeyword";
        SyntaxKind[SyntaxKind["VarKeyword"] = 40] = "VarKeyword";
        SyntaxKind[SyntaxKind["VoidKeyword"] = 41] = "VoidKeyword";
        SyntaxKind[SyntaxKind["WhileKeyword"] = 42] = "WhileKeyword";
        SyntaxKind[SyntaxKind["WithKeyword"] = 43] = "WithKeyword";

        SyntaxKind[SyntaxKind["ClassKeyword"] = 44] = "ClassKeyword";
        SyntaxKind[SyntaxKind["ConstKeyword"] = 45] = "ConstKeyword";
        SyntaxKind[SyntaxKind["EnumKeyword"] = 46] = "EnumKeyword";
        SyntaxKind[SyntaxKind["ExportKeyword"] = 47] = "ExportKeyword";
        SyntaxKind[SyntaxKind["ExtendsKeyword"] = 48] = "ExtendsKeyword";
        SyntaxKind[SyntaxKind["ImportKeyword"] = 49] = "ImportKeyword";
        SyntaxKind[SyntaxKind["SuperKeyword"] = 50] = "SuperKeyword";

        SyntaxKind[SyntaxKind["ImplementsKeyword"] = 51] = "ImplementsKeyword";
        SyntaxKind[SyntaxKind["InterfaceKeyword"] = 52] = "InterfaceKeyword";
        SyntaxKind[SyntaxKind["LetKeyword"] = 53] = "LetKeyword";
        SyntaxKind[SyntaxKind["PackageKeyword"] = 54] = "PackageKeyword";
        SyntaxKind[SyntaxKind["PrivateKeyword"] = 55] = "PrivateKeyword";
        SyntaxKind[SyntaxKind["ProtectedKeyword"] = 56] = "ProtectedKeyword";
        SyntaxKind[SyntaxKind["PublicKeyword"] = 57] = "PublicKeyword";
        SyntaxKind[SyntaxKind["StaticKeyword"] = 58] = "StaticKeyword";
        SyntaxKind[SyntaxKind["YieldKeyword"] = 59] = "YieldKeyword";

        SyntaxKind[SyntaxKind["AnyKeyword"] = 60] = "AnyKeyword";
        SyntaxKind[SyntaxKind["BooleanKeyword"] = 61] = "BooleanKeyword";
        SyntaxKind[SyntaxKind["BoolKeyword"] = 62] = "BoolKeyword";
        SyntaxKind[SyntaxKind["ConstructorKeyword"] = 63] = "ConstructorKeyword";
        SyntaxKind[SyntaxKind["DeclareKeyword"] = 64] = "DeclareKeyword";
        SyntaxKind[SyntaxKind["GetKeyword"] = 65] = "GetKeyword";
        SyntaxKind[SyntaxKind["ModuleKeyword"] = 66] = "ModuleKeyword";
        SyntaxKind[SyntaxKind["RequireKeyword"] = 67] = "RequireKeyword";
        SyntaxKind[SyntaxKind["NumberKeyword"] = 68] = "NumberKeyword";
        SyntaxKind[SyntaxKind["SetKeyword"] = 69] = "SetKeyword";
        SyntaxKind[SyntaxKind["StringKeyword"] = 70] = "StringKeyword";

        SyntaxKind[SyntaxKind["OpenBraceToken"] = 71] = "OpenBraceToken";
        SyntaxKind[SyntaxKind["CloseBraceToken"] = 72] = "CloseBraceToken";
        SyntaxKind[SyntaxKind["OpenParenToken"] = 73] = "OpenParenToken";
        SyntaxKind[SyntaxKind["CloseParenToken"] = 74] = "CloseParenToken";
        SyntaxKind[SyntaxKind["OpenBracketToken"] = 75] = "OpenBracketToken";
        SyntaxKind[SyntaxKind["CloseBracketToken"] = 76] = "CloseBracketToken";
        SyntaxKind[SyntaxKind["DotToken"] = 77] = "DotToken";
        SyntaxKind[SyntaxKind["DotDotDotToken"] = 78] = "DotDotDotToken";
        SyntaxKind[SyntaxKind["SemicolonToken"] = 79] = "SemicolonToken";
        SyntaxKind[SyntaxKind["CommaToken"] = 80] = "CommaToken";
        SyntaxKind[SyntaxKind["LessThanToken"] = 81] = "LessThanToken";
        SyntaxKind[SyntaxKind["GreaterThanToken"] = 82] = "GreaterThanToken";
        SyntaxKind[SyntaxKind["LessThanEqualsToken"] = 83] = "LessThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanEqualsToken"] = 84] = "GreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["EqualsEqualsToken"] = 85] = "EqualsEqualsToken";
        SyntaxKind[SyntaxKind["EqualsGreaterThanToken"] = 86] = "EqualsGreaterThanToken";
        SyntaxKind[SyntaxKind["ExclamationEqualsToken"] = 87] = "ExclamationEqualsToken";
        SyntaxKind[SyntaxKind["EqualsEqualsEqualsToken"] = 88] = "EqualsEqualsEqualsToken";
        SyntaxKind[SyntaxKind["ExclamationEqualsEqualsToken"] = 89] = "ExclamationEqualsEqualsToken";
        SyntaxKind[SyntaxKind["PlusToken"] = 90] = "PlusToken";
        SyntaxKind[SyntaxKind["MinusToken"] = 91] = "MinusToken";
        SyntaxKind[SyntaxKind["AsteriskToken"] = 92] = "AsteriskToken";
        SyntaxKind[SyntaxKind["PercentToken"] = 93] = "PercentToken";
        SyntaxKind[SyntaxKind["PlusPlusToken"] = 94] = "PlusPlusToken";
        SyntaxKind[SyntaxKind["MinusMinusToken"] = 95] = "MinusMinusToken";
        SyntaxKind[SyntaxKind["LessThanLessThanToken"] = 96] = "LessThanLessThanToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanToken"] = 97] = "GreaterThanGreaterThanToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanToken"] = 98] = "GreaterThanGreaterThanGreaterThanToken";
        SyntaxKind[SyntaxKind["AmpersandToken"] = 99] = "AmpersandToken";
        SyntaxKind[SyntaxKind["BarToken"] = 100] = "BarToken";
        SyntaxKind[SyntaxKind["CaretToken"] = 101] = "CaretToken";
        SyntaxKind[SyntaxKind["ExclamationToken"] = 102] = "ExclamationToken";
        SyntaxKind[SyntaxKind["TildeToken"] = 103] = "TildeToken";
        SyntaxKind[SyntaxKind["AmpersandAmpersandToken"] = 104] = "AmpersandAmpersandToken";
        SyntaxKind[SyntaxKind["BarBarToken"] = 105] = "BarBarToken";
        SyntaxKind[SyntaxKind["QuestionToken"] = 106] = "QuestionToken";
        SyntaxKind[SyntaxKind["ColonToken"] = 107] = "ColonToken";
        SyntaxKind[SyntaxKind["EqualsToken"] = 108] = "EqualsToken";
        SyntaxKind[SyntaxKind["PlusEqualsToken"] = 109] = "PlusEqualsToken";
        SyntaxKind[SyntaxKind["MinusEqualsToken"] = 110] = "MinusEqualsToken";
        SyntaxKind[SyntaxKind["AsteriskEqualsToken"] = 111] = "AsteriskEqualsToken";
        SyntaxKind[SyntaxKind["PercentEqualsToken"] = 112] = "PercentEqualsToken";
        SyntaxKind[SyntaxKind["LessThanLessThanEqualsToken"] = 113] = "LessThanLessThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanEqualsToken"] = 114] = "GreaterThanGreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanEqualsToken"] = 115] = "GreaterThanGreaterThanGreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["AmpersandEqualsToken"] = 116] = "AmpersandEqualsToken";
        SyntaxKind[SyntaxKind["BarEqualsToken"] = 117] = "BarEqualsToken";
        SyntaxKind[SyntaxKind["CaretEqualsToken"] = 118] = "CaretEqualsToken";
        SyntaxKind[SyntaxKind["SlashToken"] = 119] = "SlashToken";
        SyntaxKind[SyntaxKind["SlashEqualsToken"] = 120] = "SlashEqualsToken";

        SyntaxKind[SyntaxKind["SourceUnit"] = 121] = "SourceUnit";

        SyntaxKind[SyntaxKind["QualifiedName"] = 122] = "QualifiedName";

        SyntaxKind[SyntaxKind["ObjectType"] = 123] = "ObjectType";
        SyntaxKind[SyntaxKind["FunctionType"] = 124] = "FunctionType";
        SyntaxKind[SyntaxKind["ArrayType"] = 125] = "ArrayType";
        SyntaxKind[SyntaxKind["ConstructorType"] = 126] = "ConstructorType";
        SyntaxKind[SyntaxKind["GenericType"] = 127] = "GenericType";

        SyntaxKind[SyntaxKind["InterfaceDeclaration"] = 128] = "InterfaceDeclaration";
        SyntaxKind[SyntaxKind["FunctionDeclaration"] = 129] = "FunctionDeclaration";
        SyntaxKind[SyntaxKind["ModuleDeclaration"] = 130] = "ModuleDeclaration";
        SyntaxKind[SyntaxKind["ClassDeclaration"] = 131] = "ClassDeclaration";
        SyntaxKind[SyntaxKind["EnumDeclaration"] = 132] = "EnumDeclaration";
        SyntaxKind[SyntaxKind["ImportDeclaration"] = 133] = "ImportDeclaration";
        SyntaxKind[SyntaxKind["ExportAssignment"] = 134] = "ExportAssignment";

        SyntaxKind[SyntaxKind["MemberFunctionDeclaration"] = 135] = "MemberFunctionDeclaration";
        SyntaxKind[SyntaxKind["MemberVariableDeclaration"] = 136] = "MemberVariableDeclaration";
        SyntaxKind[SyntaxKind["ConstructorDeclaration"] = 137] = "ConstructorDeclaration";
        SyntaxKind[SyntaxKind["GetMemberAccessorDeclaration"] = 138] = "GetMemberAccessorDeclaration";
        SyntaxKind[SyntaxKind["SetMemberAccessorDeclaration"] = 139] = "SetMemberAccessorDeclaration";

        SyntaxKind[SyntaxKind["PropertySignature"] = 140] = "PropertySignature";
        SyntaxKind[SyntaxKind["CallSignature"] = 141] = "CallSignature";
        SyntaxKind[SyntaxKind["ConstructSignature"] = 142] = "ConstructSignature";
        SyntaxKind[SyntaxKind["IndexSignature"] = 143] = "IndexSignature";
        SyntaxKind[SyntaxKind["MethodSignature"] = 144] = "MethodSignature";

        SyntaxKind[SyntaxKind["Block"] = 145] = "Block";
        SyntaxKind[SyntaxKind["IfStatement"] = 146] = "IfStatement";
        SyntaxKind[SyntaxKind["VariableStatement"] = 147] = "VariableStatement";
        SyntaxKind[SyntaxKind["ExpressionStatement"] = 148] = "ExpressionStatement";
        SyntaxKind[SyntaxKind["ReturnStatement"] = 149] = "ReturnStatement";
        SyntaxKind[SyntaxKind["SwitchStatement"] = 150] = "SwitchStatement";
        SyntaxKind[SyntaxKind["BreakStatement"] = 151] = "BreakStatement";
        SyntaxKind[SyntaxKind["ContinueStatement"] = 152] = "ContinueStatement";
        SyntaxKind[SyntaxKind["ForStatement"] = 153] = "ForStatement";
        SyntaxKind[SyntaxKind["ForInStatement"] = 154] = "ForInStatement";
        SyntaxKind[SyntaxKind["EmptyStatement"] = 155] = "EmptyStatement";
        SyntaxKind[SyntaxKind["ThrowStatement"] = 156] = "ThrowStatement";
        SyntaxKind[SyntaxKind["WhileStatement"] = 157] = "WhileStatement";
        SyntaxKind[SyntaxKind["TryStatement"] = 158] = "TryStatement";
        SyntaxKind[SyntaxKind["LabeledStatement"] = 159] = "LabeledStatement";
        SyntaxKind[SyntaxKind["DoStatement"] = 160] = "DoStatement";
        SyntaxKind[SyntaxKind["DebuggerStatement"] = 161] = "DebuggerStatement";
        SyntaxKind[SyntaxKind["WithStatement"] = 162] = "WithStatement";

        SyntaxKind[SyntaxKind["PlusExpression"] = 163] = "PlusExpression";
        SyntaxKind[SyntaxKind["NegateExpression"] = 164] = "NegateExpression";
        SyntaxKind[SyntaxKind["BitwiseNotExpression"] = 165] = "BitwiseNotExpression";
        SyntaxKind[SyntaxKind["LogicalNotExpression"] = 166] = "LogicalNotExpression";
        SyntaxKind[SyntaxKind["PreIncrementExpression"] = 167] = "PreIncrementExpression";
        SyntaxKind[SyntaxKind["PreDecrementExpression"] = 168] = "PreDecrementExpression";
        SyntaxKind[SyntaxKind["DeleteExpression"] = 169] = "DeleteExpression";
        SyntaxKind[SyntaxKind["TypeOfExpression"] = 170] = "TypeOfExpression";
        SyntaxKind[SyntaxKind["VoidExpression"] = 171] = "VoidExpression";
        SyntaxKind[SyntaxKind["CommaExpression"] = 172] = "CommaExpression";
        SyntaxKind[SyntaxKind["AssignmentExpression"] = 173] = "AssignmentExpression";
        SyntaxKind[SyntaxKind["AddAssignmentExpression"] = 174] = "AddAssignmentExpression";
        SyntaxKind[SyntaxKind["SubtractAssignmentExpression"] = 175] = "SubtractAssignmentExpression";
        SyntaxKind[SyntaxKind["MultiplyAssignmentExpression"] = 176] = "MultiplyAssignmentExpression";
        SyntaxKind[SyntaxKind["DivideAssignmentExpression"] = 177] = "DivideAssignmentExpression";
        SyntaxKind[SyntaxKind["ModuloAssignmentExpression"] = 178] = "ModuloAssignmentExpression";
        SyntaxKind[SyntaxKind["AndAssignmentExpression"] = 179] = "AndAssignmentExpression";
        SyntaxKind[SyntaxKind["ExclusiveOrAssignmentExpression"] = 180] = "ExclusiveOrAssignmentExpression";
        SyntaxKind[SyntaxKind["OrAssignmentExpression"] = 181] = "OrAssignmentExpression";
        SyntaxKind[SyntaxKind["LeftShiftAssignmentExpression"] = 182] = "LeftShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["SignedRightShiftAssignmentExpression"] = 183] = "SignedRightShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["UnsignedRightShiftAssignmentExpression"] = 184] = "UnsignedRightShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["ConditionalExpression"] = 185] = "ConditionalExpression";
        SyntaxKind[SyntaxKind["LogicalOrExpression"] = 186] = "LogicalOrExpression";
        SyntaxKind[SyntaxKind["LogicalAndExpression"] = 187] = "LogicalAndExpression";
        SyntaxKind[SyntaxKind["BitwiseOrExpression"] = 188] = "BitwiseOrExpression";
        SyntaxKind[SyntaxKind["BitwiseExclusiveOrExpression"] = 189] = "BitwiseExclusiveOrExpression";
        SyntaxKind[SyntaxKind["BitwiseAndExpression"] = 190] = "BitwiseAndExpression";
        SyntaxKind[SyntaxKind["EqualsWithTypeConversionExpression"] = 191] = "EqualsWithTypeConversionExpression";
        SyntaxKind[SyntaxKind["NotEqualsWithTypeConversionExpression"] = 192] = "NotEqualsWithTypeConversionExpression";
        SyntaxKind[SyntaxKind["EqualsExpression"] = 193] = "EqualsExpression";
        SyntaxKind[SyntaxKind["NotEqualsExpression"] = 194] = "NotEqualsExpression";
        SyntaxKind[SyntaxKind["LessThanExpression"] = 195] = "LessThanExpression";
        SyntaxKind[SyntaxKind["GreaterThanExpression"] = 196] = "GreaterThanExpression";
        SyntaxKind[SyntaxKind["LessThanOrEqualExpression"] = 197] = "LessThanOrEqualExpression";
        SyntaxKind[SyntaxKind["GreaterThanOrEqualExpression"] = 198] = "GreaterThanOrEqualExpression";
        SyntaxKind[SyntaxKind["InstanceOfExpression"] = 199] = "InstanceOfExpression";
        SyntaxKind[SyntaxKind["InExpression"] = 200] = "InExpression";
        SyntaxKind[SyntaxKind["LeftShiftExpression"] = 201] = "LeftShiftExpression";
        SyntaxKind[SyntaxKind["SignedRightShiftExpression"] = 202] = "SignedRightShiftExpression";
        SyntaxKind[SyntaxKind["UnsignedRightShiftExpression"] = 203] = "UnsignedRightShiftExpression";
        SyntaxKind[SyntaxKind["MultiplyExpression"] = 204] = "MultiplyExpression";
        SyntaxKind[SyntaxKind["DivideExpression"] = 205] = "DivideExpression";
        SyntaxKind[SyntaxKind["ModuloExpression"] = 206] = "ModuloExpression";
        SyntaxKind[SyntaxKind["AddExpression"] = 207] = "AddExpression";
        SyntaxKind[SyntaxKind["SubtractExpression"] = 208] = "SubtractExpression";
        SyntaxKind[SyntaxKind["PostIncrementExpression"] = 209] = "PostIncrementExpression";
        SyntaxKind[SyntaxKind["PostDecrementExpression"] = 210] = "PostDecrementExpression";
        SyntaxKind[SyntaxKind["MemberAccessExpression"] = 211] = "MemberAccessExpression";
        SyntaxKind[SyntaxKind["InvocationExpression"] = 212] = "InvocationExpression";
        SyntaxKind[SyntaxKind["ArrayLiteralExpression"] = 213] = "ArrayLiteralExpression";
        SyntaxKind[SyntaxKind["ObjectLiteralExpression"] = 214] = "ObjectLiteralExpression";
        SyntaxKind[SyntaxKind["ObjectCreationExpression"] = 215] = "ObjectCreationExpression";
        SyntaxKind[SyntaxKind["ParenthesizedExpression"] = 216] = "ParenthesizedExpression";
        SyntaxKind[SyntaxKind["ParenthesizedArrowFunctionExpression"] = 217] = "ParenthesizedArrowFunctionExpression";
        SyntaxKind[SyntaxKind["SimpleArrowFunctionExpression"] = 218] = "SimpleArrowFunctionExpression";
        SyntaxKind[SyntaxKind["CastExpression"] = 219] = "CastExpression";
        SyntaxKind[SyntaxKind["ElementAccessExpression"] = 220] = "ElementAccessExpression";
        SyntaxKind[SyntaxKind["FunctionExpression"] = 221] = "FunctionExpression";
        SyntaxKind[SyntaxKind["OmittedExpression"] = 222] = "OmittedExpression";

        SyntaxKind[SyntaxKind["VariableDeclaration"] = 223] = "VariableDeclaration";
        SyntaxKind[SyntaxKind["VariableDeclarator"] = 224] = "VariableDeclarator";

        SyntaxKind[SyntaxKind["ArgumentList"] = 225] = "ArgumentList";
        SyntaxKind[SyntaxKind["ParameterList"] = 226] = "ParameterList";
        SyntaxKind[SyntaxKind["TypeArgumentList"] = 227] = "TypeArgumentList";
        SyntaxKind[SyntaxKind["TypeParameterList"] = 228] = "TypeParameterList";

        SyntaxKind[SyntaxKind["HeritageClause"] = 229] = "HeritageClause";
        SyntaxKind[SyntaxKind["EqualsValueClause"] = 230] = "EqualsValueClause";
        SyntaxKind[SyntaxKind["CaseSwitchClause"] = 231] = "CaseSwitchClause";
        SyntaxKind[SyntaxKind["DefaultSwitchClause"] = 232] = "DefaultSwitchClause";
        SyntaxKind[SyntaxKind["ElseClause"] = 233] = "ElseClause";
        SyntaxKind[SyntaxKind["CatchClause"] = 234] = "CatchClause";
        SyntaxKind[SyntaxKind["FinallyClause"] = 235] = "FinallyClause";

        SyntaxKind[SyntaxKind["TypeParameter"] = 236] = "TypeParameter";
        SyntaxKind[SyntaxKind["Constraint"] = 237] = "Constraint";

        SyntaxKind[SyntaxKind["SimplePropertyAssignment"] = 238] = "SimplePropertyAssignment";
        SyntaxKind[SyntaxKind["GetAccessorPropertyAssignment"] = 239] = "GetAccessorPropertyAssignment";
        SyntaxKind[SyntaxKind["SetAccessorPropertyAssignment"] = 240] = "SetAccessorPropertyAssignment";
        SyntaxKind[SyntaxKind["FunctionPropertyAssignment"] = 241] = "FunctionPropertyAssignment";

        SyntaxKind[SyntaxKind["Parameter"] = 242] = "Parameter";
        SyntaxKind[SyntaxKind["EnumElement"] = 243] = "EnumElement";
        SyntaxKind[SyntaxKind["TypeAnnotation"] = 244] = "TypeAnnotation";
        SyntaxKind[SyntaxKind["ExternalModuleReference"] = 245] = "ExternalModuleReference";
        SyntaxKind[SyntaxKind["ModuleNameModuleReference"] = 246] = "ModuleNameModuleReference";

        SyntaxKind[SyntaxKind["FirstStandardKeyword"] = SyntaxKind.BreakKeyword] = "FirstStandardKeyword";
        SyntaxKind[SyntaxKind["LastStandardKeyword"] = SyntaxKind.WithKeyword] = "LastStandardKeyword";

        SyntaxKind[SyntaxKind["FirstFutureReservedKeyword"] = SyntaxKind.ClassKeyword] = "FirstFutureReservedKeyword";
        SyntaxKind[SyntaxKind["LastFutureReservedKeyword"] = SyntaxKind.SuperKeyword] = "LastFutureReservedKeyword";

        SyntaxKind[SyntaxKind["FirstFutureReservedStrictKeyword"] = SyntaxKind.ImplementsKeyword] = "FirstFutureReservedStrictKeyword";
        SyntaxKind[SyntaxKind["LastFutureReservedStrictKeyword"] = SyntaxKind.YieldKeyword] = "LastFutureReservedStrictKeyword";

        SyntaxKind[SyntaxKind["FirstTypeScriptKeyword"] = SyntaxKind.AnyKeyword] = "FirstTypeScriptKeyword";
        SyntaxKind[SyntaxKind["LastTypeScriptKeyword"] = SyntaxKind.StringKeyword] = "LastTypeScriptKeyword";

        SyntaxKind[SyntaxKind["FirstKeyword"] = SyntaxKind.FirstStandardKeyword] = "FirstKeyword";
        SyntaxKind[SyntaxKind["LastKeyword"] = SyntaxKind.LastTypeScriptKeyword] = "LastKeyword";

        SyntaxKind[SyntaxKind["FirstToken"] = SyntaxKind.ErrorToken] = "FirstToken";
        SyntaxKind[SyntaxKind["LastToken"] = SyntaxKind.SlashEqualsToken] = "LastToken";

        SyntaxKind[SyntaxKind["FirstPunctuation"] = SyntaxKind.OpenBraceToken] = "FirstPunctuation";
        SyntaxKind[SyntaxKind["LastPunctuation"] = SyntaxKind.SlashEqualsToken] = "LastPunctuation";

        SyntaxKind[SyntaxKind["FirstFixedWidth"] = SyntaxKind.FirstKeyword] = "FirstFixedWidth";
        SyntaxKind[SyntaxKind["LastFixedWidth"] = SyntaxKind.LastPunctuation] = "LastFixedWidth";
    })(TypeScript.SyntaxKind || (TypeScript.SyntaxKind = {}));
    var SyntaxKind = TypeScript.SyntaxKind;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxFacts) {
        var textToKeywordKind = {
            "any": 60 /* AnyKeyword */,
            "bool": 62 /* BoolKeyword */,
            "boolean": 61 /* BooleanKeyword */,
            "break": 15 /* BreakKeyword */,
            "case": 16 /* CaseKeyword */,
            "catch": 17 /* CatchKeyword */,
            "class": 44 /* ClassKeyword */,
            "continue": 18 /* ContinueKeyword */,
            "const": 45 /* ConstKeyword */,
            "constructor": 63 /* ConstructorKeyword */,
            "debugger": 19 /* DebuggerKeyword */,
            "declare": 64 /* DeclareKeyword */,
            "default": 20 /* DefaultKeyword */,
            "delete": 21 /* DeleteKeyword */,
            "do": 22 /* DoKeyword */,
            "else": 23 /* ElseKeyword */,
            "enum": 46 /* EnumKeyword */,
            "export": 47 /* ExportKeyword */,
            "extends": 48 /* ExtendsKeyword */,
            "false": 24 /* FalseKeyword */,
            "finally": 25 /* FinallyKeyword */,
            "for": 26 /* ForKeyword */,
            "function": 27 /* FunctionKeyword */,
            "get": 65 /* GetKeyword */,
            "if": 28 /* IfKeyword */,
            "implements": 51 /* ImplementsKeyword */,
            "import": 49 /* ImportKeyword */,
            "in": 29 /* InKeyword */,
            "instanceof": 30 /* InstanceOfKeyword */,
            "interface": 52 /* InterfaceKeyword */,
            "let": 53 /* LetKeyword */,
            "module": 66 /* ModuleKeyword */,
            "new": 31 /* NewKeyword */,
            "null": 32 /* NullKeyword */,
            "number": 68 /* NumberKeyword */,
            "package": 54 /* PackageKeyword */,
            "private": 55 /* PrivateKeyword */,
            "protected": 56 /* ProtectedKeyword */,
            "public": 57 /* PublicKeyword */,
            "require": 67 /* RequireKeyword */,
            "return": 33 /* ReturnKeyword */,
            "set": 69 /* SetKeyword */,
            "static": 58 /* StaticKeyword */,
            "string": 70 /* StringKeyword */,
            "super": 50 /* SuperKeyword */,
            "switch": 34 /* SwitchKeyword */,
            "this": 35 /* ThisKeyword */,
            "throw": 36 /* ThrowKeyword */,
            "true": 37 /* TrueKeyword */,
            "try": 38 /* TryKeyword */,
            "typeof": 39 /* TypeOfKeyword */,
            "var": 40 /* VarKeyword */,
            "void": 41 /* VoidKeyword */,
            "while": 42 /* WhileKeyword */,
            "with": 43 /* WithKeyword */,
            "yield": 59 /* YieldKeyword */,
            "{": 71 /* OpenBraceToken */,
            "}": 72 /* CloseBraceToken */,
            "(": 73 /* OpenParenToken */,
            ")": 74 /* CloseParenToken */,
            "[": 75 /* OpenBracketToken */,
            "]": 76 /* CloseBracketToken */,
            ".": 77 /* DotToken */,
            "...": 78 /* DotDotDotToken */,
            ";": 79 /* SemicolonToken */,
            ",": 80 /* CommaToken */,
            "<": 81 /* LessThanToken */,
            ">": 82 /* GreaterThanToken */,
            "<=": 83 /* LessThanEqualsToken */,
            ">=": 84 /* GreaterThanEqualsToken */,
            "==": 85 /* EqualsEqualsToken */,
            "=>": 86 /* EqualsGreaterThanToken */,
            "!=": 87 /* ExclamationEqualsToken */,
            "===": 88 /* EqualsEqualsEqualsToken */,
            "!==": 89 /* ExclamationEqualsEqualsToken */,
            "+": 90 /* PlusToken */,
            "-": 91 /* MinusToken */,
            "*": 92 /* AsteriskToken */,
            "%": 93 /* PercentToken */,
            "++": 94 /* PlusPlusToken */,
            "--": 95 /* MinusMinusToken */,
            "<<": 96 /* LessThanLessThanToken */,
            ">>": 97 /* GreaterThanGreaterThanToken */,
            ">>>": 98 /* GreaterThanGreaterThanGreaterThanToken */,
            "&": 99 /* AmpersandToken */,
            "|": 100 /* BarToken */,
            "^": 101 /* CaretToken */,
            "!": 102 /* ExclamationToken */,
            "~": 103 /* TildeToken */,
            "&&": 104 /* AmpersandAmpersandToken */,
            "||": 105 /* BarBarToken */,
            "?": 106 /* QuestionToken */,
            ":": 107 /* ColonToken */,
            "=": 108 /* EqualsToken */,
            "+=": 109 /* PlusEqualsToken */,
            "-=": 110 /* MinusEqualsToken */,
            "*=": 111 /* AsteriskEqualsToken */,
            "%=": 112 /* PercentEqualsToken */,
            "<<=": 113 /* LessThanLessThanEqualsToken */,
            ">>=": 114 /* GreaterThanGreaterThanEqualsToken */,
            ">>>=": 115 /* GreaterThanGreaterThanGreaterThanEqualsToken */,
            "&=": 116 /* AmpersandEqualsToken */,
            "|=": 117 /* BarEqualsToken */,
            "^=": 118 /* CaretEqualsToken */,
            "/": 119 /* SlashToken */,
            "/=": 120 /* SlashEqualsToken */
        };

        var kindToText = [];

        for (var name in textToKeywordKind) {
            if (textToKeywordKind.hasOwnProperty(name)) {
                kindToText[textToKeywordKind[name]] = name;
            }
        }

        kindToText[63 /* ConstructorKeyword */] = "constructor";

        function getTokenKind(text) {
            if (textToKeywordKind.hasOwnProperty(text)) {
                return textToKeywordKind[text];
            }

            return 0 /* None */;
        }
        SyntaxFacts.getTokenKind = getTokenKind;

        function getText(kind) {
            var result = kindToText[kind];
            return result !== undefined ? result : null;
        }
        SyntaxFacts.getText = getText;

        function isTokenKind(kind) {
            return kind >= 9 /* FirstToken */ && kind <= 120 /* LastToken */;
        }
        SyntaxFacts.isTokenKind = isTokenKind;

        function isAnyKeyword(kind) {
            return kind >= TypeScript.SyntaxKind.FirstKeyword && kind <= TypeScript.SyntaxKind.LastKeyword;
        }
        SyntaxFacts.isAnyKeyword = isAnyKeyword;

        function isStandardKeyword(kind) {
            return kind >= 15 /* FirstStandardKeyword */ && kind <= 43 /* LastStandardKeyword */;
        }
        SyntaxFacts.isStandardKeyword = isStandardKeyword;

        function isFutureReservedKeyword(kind) {
            return kind >= 44 /* FirstFutureReservedKeyword */ && kind <= 50 /* LastFutureReservedKeyword */;
        }
        SyntaxFacts.isFutureReservedKeyword = isFutureReservedKeyword;

        function isFutureReservedStrictKeyword(kind) {
            return kind >= 51 /* FirstFutureReservedStrictKeyword */ && kind <= 59 /* LastFutureReservedStrictKeyword */;
        }
        SyntaxFacts.isFutureReservedStrictKeyword = isFutureReservedStrictKeyword;

        function isAnyPunctuation(kind) {
            return kind >= 71 /* FirstPunctuation */ && kind <= 120 /* LastPunctuation */;
        }
        SyntaxFacts.isAnyPunctuation = isAnyPunctuation;

        function isPrefixUnaryExpressionOperatorToken(tokenKind) {
            return getPrefixUnaryExpressionFromOperatorToken(tokenKind) !== 0 /* None */;
        }
        SyntaxFacts.isPrefixUnaryExpressionOperatorToken = isPrefixUnaryExpressionOperatorToken;

        function isBinaryExpressionOperatorToken(tokenKind) {
            return getBinaryExpressionFromOperatorToken(tokenKind) !== 0 /* None */;
        }
        SyntaxFacts.isBinaryExpressionOperatorToken = isBinaryExpressionOperatorToken;

        function getPrefixUnaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 90 /* PlusToken */:
                    return 163 /* PlusExpression */;
                case 91 /* MinusToken */:
                    return 164 /* NegateExpression */;
                case 103 /* TildeToken */:
                    return 165 /* BitwiseNotExpression */;
                case 102 /* ExclamationToken */:
                    return 166 /* LogicalNotExpression */;
                case 94 /* PlusPlusToken */:
                    return 167 /* PreIncrementExpression */;
                case 95 /* MinusMinusToken */:
                    return 168 /* PreDecrementExpression */;

                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getPrefixUnaryExpressionFromOperatorToken = getPrefixUnaryExpressionFromOperatorToken;

        function getPostfixUnaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 94 /* PlusPlusToken */:
                    return 209 /* PostIncrementExpression */;
                case 95 /* MinusMinusToken */:
                    return 210 /* PostDecrementExpression */;
                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getPostfixUnaryExpressionFromOperatorToken = getPostfixUnaryExpressionFromOperatorToken;

        function getBinaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 92 /* AsteriskToken */:
                    return 204 /* MultiplyExpression */;

                case 119 /* SlashToken */:
                    return 205 /* DivideExpression */;

                case 93 /* PercentToken */:
                    return 206 /* ModuloExpression */;

                case 90 /* PlusToken */:
                    return 207 /* AddExpression */;

                case 91 /* MinusToken */:
                    return 208 /* SubtractExpression */;

                case 96 /* LessThanLessThanToken */:
                    return 201 /* LeftShiftExpression */;

                case 97 /* GreaterThanGreaterThanToken */:
                    return 202 /* SignedRightShiftExpression */;

                case 98 /* GreaterThanGreaterThanGreaterThanToken */:
                    return 203 /* UnsignedRightShiftExpression */;

                case 81 /* LessThanToken */:
                    return 195 /* LessThanExpression */;

                case 82 /* GreaterThanToken */:
                    return 196 /* GreaterThanExpression */;

                case 83 /* LessThanEqualsToken */:
                    return 197 /* LessThanOrEqualExpression */;

                case 84 /* GreaterThanEqualsToken */:
                    return 198 /* GreaterThanOrEqualExpression */;

                case 30 /* InstanceOfKeyword */:
                    return 199 /* InstanceOfExpression */;

                case 29 /* InKeyword */:
                    return 200 /* InExpression */;

                case 85 /* EqualsEqualsToken */:
                    return 191 /* EqualsWithTypeConversionExpression */;

                case 87 /* ExclamationEqualsToken */:
                    return 192 /* NotEqualsWithTypeConversionExpression */;

                case 88 /* EqualsEqualsEqualsToken */:
                    return 193 /* EqualsExpression */;

                case 89 /* ExclamationEqualsEqualsToken */:
                    return 194 /* NotEqualsExpression */;

                case 99 /* AmpersandToken */:
                    return 190 /* BitwiseAndExpression */;

                case 101 /* CaretToken */:
                    return 189 /* BitwiseExclusiveOrExpression */;

                case 100 /* BarToken */:
                    return 188 /* BitwiseOrExpression */;

                case 104 /* AmpersandAmpersandToken */:
                    return 187 /* LogicalAndExpression */;

                case 105 /* BarBarToken */:
                    return 186 /* LogicalOrExpression */;

                case 117 /* BarEqualsToken */:
                    return 181 /* OrAssignmentExpression */;

                case 116 /* AmpersandEqualsToken */:
                    return 179 /* AndAssignmentExpression */;

                case 118 /* CaretEqualsToken */:
                    return 180 /* ExclusiveOrAssignmentExpression */;

                case 113 /* LessThanLessThanEqualsToken */:
                    return 182 /* LeftShiftAssignmentExpression */;

                case 114 /* GreaterThanGreaterThanEqualsToken */:
                    return 183 /* SignedRightShiftAssignmentExpression */;

                case 115 /* GreaterThanGreaterThanGreaterThanEqualsToken */:
                    return 184 /* UnsignedRightShiftAssignmentExpression */;

                case 109 /* PlusEqualsToken */:
                    return 174 /* AddAssignmentExpression */;

                case 110 /* MinusEqualsToken */:
                    return 175 /* SubtractAssignmentExpression */;

                case 111 /* AsteriskEqualsToken */:
                    return 176 /* MultiplyAssignmentExpression */;

                case 120 /* SlashEqualsToken */:
                    return 177 /* DivideAssignmentExpression */;

                case 112 /* PercentEqualsToken */:
                    return 178 /* ModuloAssignmentExpression */;

                case 108 /* EqualsToken */:
                    return 173 /* AssignmentExpression */;

                case 80 /* CommaToken */:
                    return 172 /* CommaExpression */;

                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getBinaryExpressionFromOperatorToken = getBinaryExpressionFromOperatorToken;

        function isAnyDivideToken(kind) {
            switch (kind) {
                case 119 /* SlashToken */:
                case 120 /* SlashEqualsToken */:
                    return true;
                default:
                    return false;
            }
        }
        SyntaxFacts.isAnyDivideToken = isAnyDivideToken;

        function isAnyDivideOrRegularExpressionToken(kind) {
            switch (kind) {
                case 119 /* SlashToken */:
                case 120 /* SlashEqualsToken */:
                case 12 /* RegularExpressionLiteral */:
                    return true;
                default:
                    return false;
            }
        }
        SyntaxFacts.isAnyDivideOrRegularExpressionToken = isAnyDivideOrRegularExpressionToken;

        function isParserGenerated(kind) {
            switch (kind) {
                case 97 /* GreaterThanGreaterThanToken */:
                case 98 /* GreaterThanGreaterThanGreaterThanToken */:
                case 84 /* GreaterThanEqualsToken */:
                case 114 /* GreaterThanGreaterThanEqualsToken */:
                case 115 /* GreaterThanGreaterThanGreaterThanEqualsToken */:
                    return true;
                default:
                    return false;
            }
        }
        SyntaxFacts.isParserGenerated = isParserGenerated;

        function isAnyBinaryExpression(kind) {
            switch (kind) {
                case 172 /* CommaExpression */:
                case 173 /* AssignmentExpression */:
                case 174 /* AddAssignmentExpression */:
                case 175 /* SubtractAssignmentExpression */:
                case 176 /* MultiplyAssignmentExpression */:
                case 177 /* DivideAssignmentExpression */:
                case 178 /* ModuloAssignmentExpression */:
                case 179 /* AndAssignmentExpression */:
                case 180 /* ExclusiveOrAssignmentExpression */:
                case 181 /* OrAssignmentExpression */:
                case 182 /* LeftShiftAssignmentExpression */:
                case 183 /* SignedRightShiftAssignmentExpression */:
                case 184 /* UnsignedRightShiftAssignmentExpression */:
                case 186 /* LogicalOrExpression */:
                case 187 /* LogicalAndExpression */:
                case 188 /* BitwiseOrExpression */:
                case 189 /* BitwiseExclusiveOrExpression */:
                case 190 /* BitwiseAndExpression */:
                case 191 /* EqualsWithTypeConversionExpression */:
                case 192 /* NotEqualsWithTypeConversionExpression */:
                case 193 /* EqualsExpression */:
                case 194 /* NotEqualsExpression */:
                case 195 /* LessThanExpression */:
                case 196 /* GreaterThanExpression */:
                case 197 /* LessThanOrEqualExpression */:
                case 198 /* GreaterThanOrEqualExpression */:
                case 199 /* InstanceOfExpression */:
                case 200 /* InExpression */:
                case 201 /* LeftShiftExpression */:
                case 202 /* SignedRightShiftExpression */:
                case 203 /* UnsignedRightShiftExpression */:
                case 204 /* MultiplyExpression */:
                case 205 /* DivideExpression */:
                case 206 /* ModuloExpression */:
                case 207 /* AddExpression */:
                case 208 /* SubtractExpression */:
                    return true;
            }

            return false;
        }
        SyntaxFacts.isAnyBinaryExpression = isAnyBinaryExpression;
    })(TypeScript.SyntaxFacts || (TypeScript.SyntaxFacts = {}));
    var SyntaxFacts = TypeScript.SyntaxFacts;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxFacts) {
        function isDirectivePrologueElement(node) {
            if (node.kind() === 148 /* ExpressionStatement */) {
                var expressionStatement = node;
                var expression = expressionStatement.expression;

                if (expression.kind() === 14 /* StringLiteral */) {
                    return true;
                }
            }

            return false;
        }
        SyntaxFacts.isDirectivePrologueElement = isDirectivePrologueElement;

        function isUseStrictDirective(node) {
            var expressionStatement = node;
            var stringLiteral = expressionStatement.expression;

            var text = stringLiteral.text();
            return text === '"use strict"' || text === "'use strict'";
        }
        SyntaxFacts.isUseStrictDirective = isUseStrictDirective;

        function isIdentifierNameOrAnyKeyword(token) {
            var tokenKind = token.tokenKind;
            return tokenKind === 11 /* IdentifierName */ || TypeScript.SyntaxFacts.isAnyKeyword(tokenKind);
        }
        SyntaxFacts.isIdentifierNameOrAnyKeyword = isIdentifierNameOrAnyKeyword;
    })(TypeScript.SyntaxFacts || (TypeScript.SyntaxFacts = {}));
    var SyntaxFacts = TypeScript.SyntaxFacts;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var EmptySyntaxList = (function () {
            function EmptySyntaxList() {
            }
            EmptySyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            EmptySyntaxList.prototype.isNode = function () {
                return false;
            };
            EmptySyntaxList.prototype.isToken = function () {
                return false;
            };
            EmptySyntaxList.prototype.isList = function () {
                return true;
            };
            EmptySyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            EmptySyntaxList.prototype.toJSON = function (key) {
                return [];
            };

            EmptySyntaxList.prototype.childCount = function () {
                return 0;
            };

            EmptySyntaxList.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySyntaxList.prototype.toArray = function () {
                return [];
            };

            EmptySyntaxList.prototype.collectTextElements = function (elements) {
            };

            EmptySyntaxList.prototype.firstToken = function () {
                return null;
            };

            EmptySyntaxList.prototype.lastToken = function () {
                return null;
            };

            EmptySyntaxList.prototype.fullWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.width = function () {
                return 0;
            };

            EmptySyntaxList.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            EmptySyntaxList.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            EmptySyntaxList.prototype.leadingTriviaWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.trailingTriviaWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.fullText = function () {
                return "";
            };

            EmptySyntaxList.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptySyntaxList.prototype.isIncrementallyUnusable = function () {
                return false;
            };

            EmptySyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                throw TypeScript.Errors.invalidOperation();
            };

            EmptySyntaxList.prototype.insertChildrenInto = function (array, index) {
            };
            return EmptySyntaxList;
        })();
        Syntax.EmptySyntaxList = EmptySyntaxList;

        Syntax.emptyList = new EmptySyntaxList();

        var SingletonSyntaxList = (function () {
            function SingletonSyntaxList(item) {
                this.item = item;
            }
            SingletonSyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            SingletonSyntaxList.prototype.isToken = function () {
                return false;
            };
            SingletonSyntaxList.prototype.isNode = function () {
                return false;
            };
            SingletonSyntaxList.prototype.isList = function () {
                return true;
            };
            SingletonSyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            SingletonSyntaxList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSyntaxList.prototype.childCount = function () {
                return 1;
            };

            SingletonSyntaxList.prototype.childAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSyntaxList.prototype.toArray = function () {
                return [this.item];
            };

            SingletonSyntaxList.prototype.collectTextElements = function (elements) {
                this.item.collectTextElements(elements);
            };

            SingletonSyntaxList.prototype.firstToken = function () {
                return this.item.firstToken();
            };

            SingletonSyntaxList.prototype.lastToken = function () {
                return this.item.lastToken();
            };

            SingletonSyntaxList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSyntaxList.prototype.width = function () {
                return this.item.width();
            };

            SingletonSyntaxList.prototype.leadingTrivia = function () {
                return this.item.leadingTrivia();
            };

            SingletonSyntaxList.prototype.trailingTrivia = function () {
                return this.item.trailingTrivia();
            };

            SingletonSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.item.leadingTriviaWidth();
            };

            SingletonSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.item.trailingTriviaWidth();
            };

            SingletonSyntaxList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSyntaxList.prototype.isTypeScriptSpecific = function () {
                return this.item.isTypeScriptSpecific();
            };

            SingletonSyntaxList.prototype.isIncrementallyUnusable = function () {
                return this.item.isIncrementallyUnusable();
            };

            SingletonSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                return (this.item).findTokenInternal(new TypeScript.PositionedList(parent, this, fullStart), position, fullStart);
            };

            SingletonSyntaxList.prototype.insertChildrenInto = function (array, index) {
                array.splice(index, 0, this.item);
            };
            return SingletonSyntaxList;
        })();

        var NormalSyntaxList = (function () {
            function NormalSyntaxList(nodeOrTokens) {
                this._data = 0;
                this.nodeOrTokens = nodeOrTokens;
            }
            NormalSyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            NormalSyntaxList.prototype.isNode = function () {
                return false;
            };
            NormalSyntaxList.prototype.isToken = function () {
                return false;
            };
            NormalSyntaxList.prototype.isList = function () {
                return true;
            };
            NormalSyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            NormalSyntaxList.prototype.toJSON = function (key) {
                return this.nodeOrTokens;
            };

            NormalSyntaxList.prototype.childCount = function () {
                return this.nodeOrTokens.length;
            };

            NormalSyntaxList.prototype.childAt = function (index) {
                if (index < 0 || index >= this.nodeOrTokens.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.nodeOrTokens[index];
            };

            NormalSyntaxList.prototype.toArray = function () {
                return this.nodeOrTokens.slice(0);
            };

            NormalSyntaxList.prototype.collectTextElements = function (elements) {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var element = this.nodeOrTokens[i];
                    element.collectTextElements(elements);
                }
            };

            NormalSyntaxList.prototype.firstToken = function () {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var token = this.nodeOrTokens[i].firstToken();
                    if (token !== null) {
                        return token;
                    }
                }

                return null;
            };

            NormalSyntaxList.prototype.lastToken = function () {
                for (var i = this.nodeOrTokens.length - 1; i >= 0; i--) {
                    var token = this.nodeOrTokens[i].lastToken();
                    if (token !== null) {
                        return token;
                    }
                }

                return null;
            };

            NormalSyntaxList.prototype.fullText = function () {
                var elements = [];
                this.collectTextElements(elements);
                return elements.join("");
            };

            NormalSyntaxList.prototype.isTypeScriptSpecific = function () {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    if (this.nodeOrTokens[i].isTypeScriptSpecific()) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxList.prototype.isIncrementallyUnusable = function () {
                return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
            };

            NormalSyntaxList.prototype.fullWidth = function () {
                return this.data() >>> 3 /* NodeFullWidthShift */;
            };

            NormalSyntaxList.prototype.width = function () {
                var fullWidth = this.fullWidth();
                return fullWidth - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            NormalSyntaxList.prototype.leadingTrivia = function () {
                return this.firstToken().leadingTrivia();
            };

            NormalSyntaxList.prototype.trailingTrivia = function () {
                return this.lastToken().trailingTrivia();
            };

            NormalSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.firstToken().leadingTriviaWidth();
            };

            NormalSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.lastToken().trailingTriviaWidth();
            };

            NormalSyntaxList.prototype.computeData = function () {
                var fullWidth = 0;
                var isIncrementallyUnusable = false;

                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var node = this.nodeOrTokens[i];
                    fullWidth += node.fullWidth();
                    isIncrementallyUnusable = isIncrementallyUnusable || node.isIncrementallyUnusable();
                }

                return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
            };

            NormalSyntaxList.prototype.data = function () {
                if ((this._data & 1 /* NodeDataComputed */) === 0) {
                    this._data = this.computeData();
                }

                return this._data;
            };

            NormalSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                parent = new TypeScript.PositionedList(parent, this, fullStart);
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var nodeOrToken = this.nodeOrTokens[i];

                    var childWidth = nodeOrToken.fullWidth();
                    if (position < childWidth) {
                        return (nodeOrToken).findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }

                throw TypeScript.Errors.invalidOperation();
            };

            NormalSyntaxList.prototype.insertChildrenInto = function (array, index) {
                if (index === 0) {
                    array.unshift.apply(array, this.nodeOrTokens);
                } else {
                    array.splice.apply(array, [index, 0].concat(this.nodeOrTokens));
                }
            };
            return NormalSyntaxList;
        })();

        function list(nodes) {
            if (nodes === undefined || nodes === null || nodes.length === 0) {
                return Syntax.emptyList;
            }

            if (nodes.length === 1) {
                var item = nodes[0];
                return new SingletonSyntaxList(item);
            }

            return new NormalSyntaxList(nodes);
        }
        Syntax.list = list;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxNode = (function () {
        function SyntaxNode(parsedInStrictMode) {
            this._data = parsedInStrictMode ? 4 /* NodeParsedInStrictModeMask */ : 0;
        }
        SyntaxNode.prototype.isNode = function () {
            return true;
        };
        SyntaxNode.prototype.isToken = function () {
            return false;
        };
        SyntaxNode.prototype.isList = function () {
            return false;
        };
        SyntaxNode.prototype.isSeparatedList = function () {
            return false;
        };

        SyntaxNode.prototype.kind = function () {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.childCount = function () {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.childAt = function (slot) {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.firstToken = function () {
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.fullWidth() > 0 || element.kind() === 10 /* EndOfFileToken */) {
                        return element.firstToken();
                    }
                }
            }

            return null;
        };

        SyntaxNode.prototype.lastToken = function () {
            for (var i = this.childCount() - 1; i >= 0; i--) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.fullWidth() > 0 || element.kind() === 10 /* EndOfFileToken */) {
                        return element.lastToken();
                    }
                }
            }

            return null;
        };

        SyntaxNode.prototype.insertChildrenInto = function (array, index) {
            for (var i = this.childCount() - 1; i >= 0; i--) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.isNode() || element.isToken()) {
                        array.splice(index, 0, element);
                    } else if (element.isList()) {
                        (element).insertChildrenInto(array, index);
                    } else if (element.isSeparatedList()) {
                        (element).insertChildrenInto(array, index);
                    } else {
                        throw TypeScript.Errors.invalidOperation();
                    }
                }
            }
        };

        SyntaxNode.prototype.leadingTrivia = function () {
            return this.firstToken().leadingTrivia();
        };

        SyntaxNode.prototype.trailingTrivia = function () {
            return this.lastToken().trailingTrivia();
        };

        SyntaxNode.prototype.toJSON = function (key) {
            var result = {
                kind: TypeScript.SyntaxKind[this.kind()],
                fullWidth: this.fullWidth()
            };

            if (this.isIncrementallyUnusable()) {
                result.isIncrementallyUnusable = true;
            }

            if (this.parsedInStrictMode()) {
                result.parsedInStrictMode = true;
            }

            for (var i = 0, n = this.childCount(); i < n; i++) {
                var value = this.childAt(i);

                if (value) {
                    for (var name in this) {
                        if (value === this[name]) {
                            result[name] = value;
                            break;
                        }
                    }
                }
            }

            return result;
        };

        SyntaxNode.prototype.accept = function (visitor) {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.fullText = function () {
            var elements = [];
            this.collectTextElements(elements);
            return elements.join("");
        };

        SyntaxNode.prototype.collectTextElements = function (elements) {
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    element.collectTextElements(elements);
                }
            }
        };

        SyntaxNode.prototype.replaceToken = function (token1, token2) {
            if (token1 === token2) {
                return this;
            }

            return this.accept(new TypeScript.SyntaxTokenReplacer(token1, token2));
        };

        SyntaxNode.prototype.withLeadingTrivia = function (trivia) {
            return this.replaceToken(this.firstToken(), this.firstToken().withLeadingTrivia(trivia));
        };

        SyntaxNode.prototype.withTrailingTrivia = function (trivia) {
            return this.replaceToken(this.lastToken(), this.lastToken().withTrailingTrivia(trivia));
        };

        SyntaxNode.prototype.hasLeadingTrivia = function () {
            return this.lastToken().hasLeadingTrivia();
        };

        SyntaxNode.prototype.hasTrailingTrivia = function () {
            return this.lastToken().hasTrailingTrivia();
        };

        SyntaxNode.prototype.isTypeScriptSpecific = function () {
            return false;
        };

        SyntaxNode.prototype.isIncrementallyUnusable = function () {
            return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
        };

        SyntaxNode.prototype.parsedInStrictMode = function () {
            return (this.data() & 4 /* NodeParsedInStrictModeMask */) !== 0;
        };

        SyntaxNode.prototype.fullWidth = function () {
            return this.data() >>> 3 /* NodeFullWidthShift */;
        };

        SyntaxNode.prototype.computeData = function () {
            var slotCount = this.childCount();

            var fullWidth = 0;
            var childWidth = 0;

            var isIncrementallyUnusable = ((this._data & 2 /* NodeIncrementallyUnusableMask */) !== 0) || slotCount === 0;

            for (var i = 0, n = slotCount; i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    childWidth = element.fullWidth();
                    fullWidth += childWidth;

                    if (!isIncrementallyUnusable) {
                        isIncrementallyUnusable = element.isIncrementallyUnusable();
                    }
                }
            }

            return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
        };

        SyntaxNode.prototype.data = function () {
            if ((this._data & 1 /* NodeDataComputed */) === 0) {
                this._data |= this.computeData();
            }

            return this._data;
        };

        SyntaxNode.prototype.findToken = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var endOfFileToken = this.tryGetEndOfFileAt(position);
            if (endOfFileToken !== null) {
                return endOfFileToken;
            }

            if (position < 0 || position >= this.fullWidth()) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var positionedToken = this.findTokenInternal(null, position, 0);

            if (includeSkippedTokens) {
                return TypeScript.Syntax.findSkippedTokenInPositionedToken(positionedToken, position) || positionedToken;
            }

            return positionedToken;
        };

        SyntaxNode.prototype.tryGetEndOfFileAt = function (position) {
            if (this.kind() === 121 /* SourceUnit */ && position === this.fullWidth()) {
                var sourceUnit = this;
                return new TypeScript.PositionedToken(new TypeScript.PositionedNode(null, sourceUnit, 0), sourceUnit.endOfFileToken, sourceUnit.moduleElements.fullWidth());
            }

            return null;
        };

        SyntaxNode.prototype.findTokenInternal = function (parent, position, fullStart) {
            parent = new TypeScript.PositionedNode(parent, this, fullStart);
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    var childWidth = element.fullWidth();

                    if (position < childWidth) {
                        return (element).findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }
            }

            throw TypeScript.Errors.invalidOperation();
        };

        SyntaxNode.prototype.findTokenOnLeft = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var positionedToken = this.findToken(position, includeSkippedTokens);
            var start = positionedToken.start();

            if (position > start) {
                return positionedToken;
            }

            if (positionedToken.fullStart() === 0) {
                return null;
            }

            return positionedToken.previousToken(includeSkippedTokens);
        };

        SyntaxNode.prototype.findCompleteTokenOnLeft = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var positionedToken = this.findToken(position, includeSkippedTokens);

            if (positionedToken.token().width() > 0 && position >= positionedToken.end()) {
                return positionedToken;
            }

            return positionedToken.previousToken(includeSkippedTokens);
        };

        SyntaxNode.prototype.isModuleElement = function () {
            return false;
        };

        SyntaxNode.prototype.isClassElement = function () {
            return false;
        };

        SyntaxNode.prototype.isTypeMember = function () {
            return false;
        };

        SyntaxNode.prototype.isStatement = function () {
            return false;
        };

        SyntaxNode.prototype.isSwitchClause = function () {
            return false;
        };

        SyntaxNode.prototype.structuralEquals = function (node) {
            if (this === node) {
                return true;
            }
            if (node === null) {
                return false;
            }
            if (this.kind() !== node.kind()) {
                return false;
            }

            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element1 = this.childAt(i);
                var element2 = node.childAt(i);

                if (!TypeScript.Syntax.elementStructuralEquals(element1, element2)) {
                    return false;
                }
            }

            return true;
        };

        SyntaxNode.prototype.width = function () {
            return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
        };

        SyntaxNode.prototype.leadingTriviaWidth = function () {
            var firstToken = this.firstToken();
            return firstToken === null ? 0 : firstToken.leadingTriviaWidth();
        };

        SyntaxNode.prototype.trailingTriviaWidth = function () {
            var lastToken = this.lastToken();
            return lastToken === null ? 0 : lastToken.trailingTriviaWidth();
        };
        return SyntaxNode;
    })();
    TypeScript.SyntaxNode = SyntaxNode;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SourceUnitSyntax = (function (_super) {
        __extends(SourceUnitSyntax, _super);
        function SourceUnitSyntax(moduleElements, endOfFileToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.moduleElements = moduleElements;
            this.endOfFileToken = endOfFileToken;
        }
        SourceUnitSyntax.prototype.accept = function (visitor) {
            return visitor.visitSourceUnit(this);
        };

        SourceUnitSyntax.prototype.kind = function () {
            return 121 /* SourceUnit */;
        };

        SourceUnitSyntax.prototype.childCount = function () {
            return 2;
        };

        SourceUnitSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.moduleElements;
                case 1:
                    return this.endOfFileToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SourceUnitSyntax.prototype.update = function (moduleElements, endOfFileToken) {
            if (this.moduleElements === moduleElements && this.endOfFileToken === endOfFileToken) {
                return this;
            }

            return new SourceUnitSyntax(moduleElements, endOfFileToken, this.parsedInStrictMode());
        };

        SourceUnitSyntax.create = function (endOfFileToken) {
            return new SourceUnitSyntax(TypeScript.Syntax.emptyList, endOfFileToken, false);
        };

        SourceUnitSyntax.create1 = function (endOfFileToken) {
            return new SourceUnitSyntax(TypeScript.Syntax.emptyList, endOfFileToken, false);
        };

        SourceUnitSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SourceUnitSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SourceUnitSyntax.prototype.withModuleElements = function (moduleElements) {
            return this.update(moduleElements, this.endOfFileToken);
        };

        SourceUnitSyntax.prototype.withModuleElement = function (moduleElement) {
            return this.withModuleElements(TypeScript.Syntax.list([moduleElement]));
        };

        SourceUnitSyntax.prototype.withEndOfFileToken = function (endOfFileToken) {
            return this.update(this.moduleElements, endOfFileToken);
        };

        SourceUnitSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.moduleElements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SourceUnitSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SourceUnitSyntax = SourceUnitSyntax;

    var ModuleReferenceSyntax = (function (_super) {
        __extends(ModuleReferenceSyntax, _super);
        function ModuleReferenceSyntax(parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
        }
        ModuleReferenceSyntax.prototype.isModuleReference = function () {
            return true;
        };

        ModuleReferenceSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ModuleReferenceSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ModuleReferenceSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ModuleReferenceSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ModuleReferenceSyntax = ModuleReferenceSyntax;

    var ExternalModuleReferenceSyntax = (function (_super) {
        __extends(ExternalModuleReferenceSyntax, _super);
        function ExternalModuleReferenceSyntax(moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.moduleOrRequireKeyword = moduleOrRequireKeyword;
            this.openParenToken = openParenToken;
            this.stringLiteral = stringLiteral;
            this.closeParenToken = closeParenToken;
        }
        ExternalModuleReferenceSyntax.prototype.accept = function (visitor) {
            return visitor.visitExternalModuleReference(this);
        };

        ExternalModuleReferenceSyntax.prototype.kind = function () {
            return 245 /* ExternalModuleReference */;
        };

        ExternalModuleReferenceSyntax.prototype.childCount = function () {
            return 4;
        };

        ExternalModuleReferenceSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.moduleOrRequireKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.stringLiteral;
                case 3:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExternalModuleReferenceSyntax.prototype.update = function (moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken) {
            if (this.moduleOrRequireKeyword === moduleOrRequireKeyword && this.openParenToken === openParenToken && this.stringLiteral === stringLiteral && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ExternalModuleReferenceSyntax(moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken, this.parsedInStrictMode());
        };

        ExternalModuleReferenceSyntax.create1 = function (moduleOrRequireKeyword, stringLiteral) {
            return new ExternalModuleReferenceSyntax(moduleOrRequireKeyword, TypeScript.Syntax.token(73 /* OpenParenToken */), stringLiteral, TypeScript.Syntax.token(74 /* CloseParenToken */), false);
        };

        ExternalModuleReferenceSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExternalModuleReferenceSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExternalModuleReferenceSyntax.prototype.withModuleOrRequireKeyword = function (moduleOrRequireKeyword) {
            return this.update(moduleOrRequireKeyword, this.openParenToken, this.stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.moduleOrRequireKeyword, openParenToken, this.stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withStringLiteral = function (stringLiteral) {
            return this.update(this.moduleOrRequireKeyword, this.openParenToken, stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.moduleOrRequireKeyword, this.openParenToken, this.stringLiteral, closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ExternalModuleReferenceSyntax;
    })(ModuleReferenceSyntax);
    TypeScript.ExternalModuleReferenceSyntax = ExternalModuleReferenceSyntax;

    var ModuleNameModuleReferenceSyntax = (function (_super) {
        __extends(ModuleNameModuleReferenceSyntax, _super);
        function ModuleNameModuleReferenceSyntax(moduleName, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.moduleName = moduleName;
        }
        ModuleNameModuleReferenceSyntax.prototype.accept = function (visitor) {
            return visitor.visitModuleNameModuleReference(this);
        };

        ModuleNameModuleReferenceSyntax.prototype.kind = function () {
            return 246 /* ModuleNameModuleReference */;
        };

        ModuleNameModuleReferenceSyntax.prototype.childCount = function () {
            return 1;
        };

        ModuleNameModuleReferenceSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.moduleName;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ModuleNameModuleReferenceSyntax.prototype.update = function (moduleName) {
            if (this.moduleName === moduleName) {
                return this;
            }

            return new ModuleNameModuleReferenceSyntax(moduleName, this.parsedInStrictMode());
        };

        ModuleNameModuleReferenceSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ModuleNameModuleReferenceSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ModuleNameModuleReferenceSyntax.prototype.withModuleName = function (moduleName) {
            return this.update(moduleName);
        };

        ModuleNameModuleReferenceSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ModuleNameModuleReferenceSyntax;
    })(ModuleReferenceSyntax);
    TypeScript.ModuleNameModuleReferenceSyntax = ModuleNameModuleReferenceSyntax;

    var ImportDeclarationSyntax = (function (_super) {
        __extends(ImportDeclarationSyntax, _super);
        function ImportDeclarationSyntax(importKeyword, identifier, equalsToken, moduleReference, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.importKeyword = importKeyword;
            this.identifier = identifier;
            this.equalsToken = equalsToken;
            this.moduleReference = moduleReference;
            this.semicolonToken = semicolonToken;
        }
        ImportDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitImportDeclaration(this);
        };

        ImportDeclarationSyntax.prototype.kind = function () {
            return 133 /* ImportDeclaration */;
        };

        ImportDeclarationSyntax.prototype.childCount = function () {
            return 5;
        };

        ImportDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.importKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.equalsToken;
                case 3:
                    return this.moduleReference;
                case 4:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ImportDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ImportDeclarationSyntax.prototype.update = function (importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
            if (this.importKeyword === importKeyword && this.identifier === identifier && this.equalsToken === equalsToken && this.moduleReference === moduleReference && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ImportDeclarationSyntax(importKeyword, identifier, equalsToken, moduleReference, semicolonToken, this.parsedInStrictMode());
        };

        ImportDeclarationSyntax.create1 = function (identifier, moduleReference) {
            return new ImportDeclarationSyntax(TypeScript.Syntax.token(49 /* ImportKeyword */), identifier, TypeScript.Syntax.token(108 /* EqualsToken */), moduleReference, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ImportDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ImportDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ImportDeclarationSyntax.prototype.withImportKeyword = function (importKeyword) {
            return this.update(importKeyword, this.identifier, this.equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.importKeyword, identifier, this.equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(this.importKeyword, this.identifier, equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withModuleReference = function (moduleReference) {
            return this.update(this.importKeyword, this.identifier, this.equalsToken, moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.importKeyword, this.identifier, this.equalsToken, this.moduleReference, semicolonToken);
        };

        ImportDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ImportDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ImportDeclarationSyntax = ImportDeclarationSyntax;

    var ExportAssignmentSyntax = (function (_super) {
        __extends(ExportAssignmentSyntax, _super);
        function ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.exportKeyword = exportKeyword;
            this.equalsToken = equalsToken;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        ExportAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitExportAssignment(this);
        };

        ExportAssignmentSyntax.prototype.kind = function () {
            return 134 /* ExportAssignment */;
        };

        ExportAssignmentSyntax.prototype.childCount = function () {
            return 4;
        };

        ExportAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.exportKeyword;
                case 1:
                    return this.equalsToken;
                case 2:
                    return this.identifier;
                case 3:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExportAssignmentSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ExportAssignmentSyntax.prototype.update = function (exportKeyword, equalsToken, identifier, semicolonToken) {
            if (this.exportKeyword === exportKeyword && this.equalsToken === equalsToken && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, this.parsedInStrictMode());
        };

        ExportAssignmentSyntax.create1 = function (identifier) {
            return new ExportAssignmentSyntax(TypeScript.Syntax.token(47 /* ExportKeyword */), TypeScript.Syntax.token(108 /* EqualsToken */), identifier, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ExportAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExportAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExportAssignmentSyntax.prototype.withExportKeyword = function (exportKeyword) {
            return this.update(exportKeyword, this.equalsToken, this.identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(this.exportKeyword, equalsToken, this.identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.exportKeyword, this.equalsToken, identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.exportKeyword, this.equalsToken, this.identifier, semicolonToken);
        };

        ExportAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ExportAssignmentSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ExportAssignmentSyntax = ExportAssignmentSyntax;

    var ClassDeclarationSyntax = (function (_super) {
        __extends(ClassDeclarationSyntax, _super);
        function ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.classKeyword = classKeyword;
            this.identifier = identifier;
            this.typeParameterList = typeParameterList;
            this.heritageClauses = heritageClauses;
            this.openBraceToken = openBraceToken;
            this.classElements = classElements;
            this.closeBraceToken = closeBraceToken;
        }
        ClassDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitClassDeclaration(this);
        };

        ClassDeclarationSyntax.prototype.kind = function () {
            return 131 /* ClassDeclaration */;
        };

        ClassDeclarationSyntax.prototype.childCount = function () {
            return 8;
        };

        ClassDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.classKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeParameterList;
                case 4:
                    return this.heritageClauses;
                case 5:
                    return this.openBraceToken;
                case 6:
                    return this.classElements;
                case 7:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ClassDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ClassDeclarationSyntax.prototype.update = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.classKeyword === classKeyword && this.identifier === identifier && this.typeParameterList === typeParameterList && this.heritageClauses === heritageClauses && this.openBraceToken === openBraceToken && this.classElements === classElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, this.parsedInStrictMode());
        };

        ClassDeclarationSyntax.create = function (classKeyword, identifier, openBraceToken, closeBraceToken) {
            return new ClassDeclarationSyntax(TypeScript.Syntax.emptyList, classKeyword, identifier, null, TypeScript.Syntax.emptyList, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        ClassDeclarationSyntax.create1 = function (identifier) {
            return new ClassDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(44 /* ClassKeyword */), identifier, null, TypeScript.Syntax.emptyList, TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        ClassDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ClassDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ClassDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ClassDeclarationSyntax.prototype.withClassKeyword = function (classKeyword) {
            return this.update(this.modifiers, classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.classKeyword, identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withHeritageClauses = function (heritageClauses) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withHeritageClause = function (heritageClause) {
            return this.withHeritageClauses(TypeScript.Syntax.list([heritageClause]));
        };

        ClassDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withClassElements = function (classElements) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withClassElement = function (classElement) {
            return this.withClassElements(TypeScript.Syntax.list([classElement]));
        };

        ClassDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ClassDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ClassDeclarationSyntax = ClassDeclarationSyntax;

    var InterfaceDeclarationSyntax = (function (_super) {
        __extends(InterfaceDeclarationSyntax, _super);
        function InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.interfaceKeyword = interfaceKeyword;
            this.identifier = identifier;
            this.typeParameterList = typeParameterList;
            this.heritageClauses = heritageClauses;
            this.body = body;
        }
        InterfaceDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitInterfaceDeclaration(this);
        };

        InterfaceDeclarationSyntax.prototype.kind = function () {
            return 128 /* InterfaceDeclaration */;
        };

        InterfaceDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        InterfaceDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.interfaceKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeParameterList;
                case 4:
                    return this.heritageClauses;
                case 5:
                    return this.body;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        InterfaceDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        InterfaceDeclarationSyntax.prototype.update = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
            if (this.modifiers === modifiers && this.interfaceKeyword === interfaceKeyword && this.identifier === identifier && this.typeParameterList === typeParameterList && this.heritageClauses === heritageClauses && this.body === body) {
                return this;
            }

            return new InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, this.parsedInStrictMode());
        };

        InterfaceDeclarationSyntax.create = function (interfaceKeyword, identifier, body) {
            return new InterfaceDeclarationSyntax(TypeScript.Syntax.emptyList, interfaceKeyword, identifier, null, TypeScript.Syntax.emptyList, body, false);
        };

        InterfaceDeclarationSyntax.create1 = function (identifier) {
            return new InterfaceDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(52 /* InterfaceKeyword */), identifier, null, TypeScript.Syntax.emptyList, ObjectTypeSyntax.create1(), false);
        };

        InterfaceDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        InterfaceDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        InterfaceDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        InterfaceDeclarationSyntax.prototype.withInterfaceKeyword = function (interfaceKeyword) {
            return this.update(this.modifiers, interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.interfaceKeyword, identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withHeritageClauses = function (heritageClauses) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withHeritageClause = function (heritageClause) {
            return this.withHeritageClauses(TypeScript.Syntax.list([heritageClause]));
        };

        InterfaceDeclarationSyntax.prototype.withBody = function (body) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, body);
        };

        InterfaceDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return InterfaceDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.InterfaceDeclarationSyntax = InterfaceDeclarationSyntax;

    var HeritageClauseSyntax = (function (_super) {
        __extends(HeritageClauseSyntax, _super);
        function HeritageClauseSyntax(extendsOrImplementsKeyword, typeNames, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.extendsOrImplementsKeyword = extendsOrImplementsKeyword;
            this.typeNames = typeNames;
        }
        HeritageClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitHeritageClause(this);
        };

        HeritageClauseSyntax.prototype.kind = function () {
            return 229 /* HeritageClause */;
        };

        HeritageClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        HeritageClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.extendsOrImplementsKeyword;
                case 1:
                    return this.typeNames;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        HeritageClauseSyntax.prototype.update = function (extendsOrImplementsKeyword, typeNames) {
            if (this.extendsOrImplementsKeyword === extendsOrImplementsKeyword && this.typeNames === typeNames) {
                return this;
            }

            return new HeritageClauseSyntax(extendsOrImplementsKeyword, typeNames, this.parsedInStrictMode());
        };

        HeritageClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        HeritageClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        HeritageClauseSyntax.prototype.withExtendsOrImplementsKeyword = function (extendsOrImplementsKeyword) {
            return this.update(extendsOrImplementsKeyword, this.typeNames);
        };

        HeritageClauseSyntax.prototype.withTypeNames = function (typeNames) {
            return this.update(this.extendsOrImplementsKeyword, typeNames);
        };

        HeritageClauseSyntax.prototype.withTypeName = function (typeName) {
            return this.withTypeNames(TypeScript.Syntax.separatedList([typeName]));
        };

        HeritageClauseSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return HeritageClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.HeritageClauseSyntax = HeritageClauseSyntax;

    var ModuleDeclarationSyntax = (function (_super) {
        __extends(ModuleDeclarationSyntax, _super);
        function ModuleDeclarationSyntax(modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.moduleKeyword = moduleKeyword;
            this.moduleName = moduleName;
            this.stringLiteral = stringLiteral;
            this.openBraceToken = openBraceToken;
            this.moduleElements = moduleElements;
            this.closeBraceToken = closeBraceToken;
        }
        ModuleDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitModuleDeclaration(this);
        };

        ModuleDeclarationSyntax.prototype.kind = function () {
            return 130 /* ModuleDeclaration */;
        };

        ModuleDeclarationSyntax.prototype.childCount = function () {
            return 7;
        };

        ModuleDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.moduleKeyword;
                case 2:
                    return this.moduleName;
                case 3:
                    return this.stringLiteral;
                case 4:
                    return this.openBraceToken;
                case 5:
                    return this.moduleElements;
                case 6:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ModuleDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ModuleDeclarationSyntax.prototype.update = function (modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.moduleKeyword === moduleKeyword && this.moduleName === moduleName && this.stringLiteral === stringLiteral && this.openBraceToken === openBraceToken && this.moduleElements === moduleElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ModuleDeclarationSyntax(modifiers, moduleKeyword, moduleName, stringLiteral, openBraceToken, moduleElements, closeBraceToken, this.parsedInStrictMode());
        };

        ModuleDeclarationSyntax.create = function (moduleKeyword, openBraceToken, closeBraceToken) {
            return new ModuleDeclarationSyntax(TypeScript.Syntax.emptyList, moduleKeyword, null, null, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        ModuleDeclarationSyntax.create1 = function () {
            return new ModuleDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(66 /* ModuleKeyword */), null, null, TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        ModuleDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ModuleDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ModuleDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.moduleKeyword, this.moduleName, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ModuleDeclarationSyntax.prototype.withModuleKeyword = function (moduleKeyword) {
            return this.update(this.modifiers, moduleKeyword, this.moduleName, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModuleName = function (moduleName) {
            return this.update(this.modifiers, this.moduleKeyword, moduleName, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withStringLiteral = function (stringLiteral) {
            return this.update(this.modifiers, this.moduleKeyword, this.moduleName, stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.moduleKeyword, this.moduleName, this.stringLiteral, openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModuleElements = function (moduleElements) {
            return this.update(this.modifiers, this.moduleKeyword, this.moduleName, this.stringLiteral, this.openBraceToken, moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModuleElement = function (moduleElement) {
            return this.withModuleElements(TypeScript.Syntax.list([moduleElement]));
        };

        ModuleDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.moduleKeyword, this.moduleName, this.stringLiteral, this.openBraceToken, this.moduleElements, closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ModuleDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ModuleDeclarationSyntax = ModuleDeclarationSyntax;

    var FunctionDeclarationSyntax = (function (_super) {
        __extends(FunctionDeclarationSyntax, _super);
        function FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.functionKeyword = functionKeyword;
            this.identifier = identifier;
            this.callSignature = callSignature;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        FunctionDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionDeclaration(this);
        };

        FunctionDeclarationSyntax.prototype.kind = function () {
            return 129 /* FunctionDeclaration */;
        };

        FunctionDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        FunctionDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.functionKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.callSignature;
                case 4:
                    return this.block;
                case 5:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionDeclarationSyntax.prototype.isStatement = function () {
            return true;
        };

        FunctionDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        FunctionDeclarationSyntax.prototype.update = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
            if (this.modifiers === modifiers && this.functionKeyword === functionKeyword && this.identifier === identifier && this.callSignature === callSignature && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, this.parsedInStrictMode());
        };

        FunctionDeclarationSyntax.create = function (functionKeyword, identifier, callSignature) {
            return new FunctionDeclarationSyntax(TypeScript.Syntax.emptyList, functionKeyword, identifier, callSignature, null, null, false);
        };

        FunctionDeclarationSyntax.create1 = function (identifier) {
            return new FunctionDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(27 /* FunctionKeyword */), identifier, CallSignatureSyntax.create1(), null, null, false);
        };

        FunctionDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.functionKeyword, this.identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        FunctionDeclarationSyntax.prototype.withFunctionKeyword = function (functionKeyword) {
            return this.update(this.modifiers, functionKeyword, this.identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.functionKeyword, identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, this.callSignature, block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, this.callSignature, this.block, semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.modifiers.isTypeScriptSpecific()) {
                return true;
            }
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block !== null && this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionDeclarationSyntax = FunctionDeclarationSyntax;

    var VariableStatementSyntax = (function (_super) {
        __extends(VariableStatementSyntax, _super);
        function VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.variableDeclaration = variableDeclaration;
            this.semicolonToken = semicolonToken;
        }
        VariableStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableStatement(this);
        };

        VariableStatementSyntax.prototype.kind = function () {
            return 147 /* VariableStatement */;
        };

        VariableStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        VariableStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.variableDeclaration;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        VariableStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        VariableStatementSyntax.prototype.update = function (modifiers, variableDeclaration, semicolonToken) {
            if (this.modifiers === modifiers && this.variableDeclaration === variableDeclaration && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, this.parsedInStrictMode());
        };

        VariableStatementSyntax.create = function (variableDeclaration, semicolonToken) {
            return new VariableStatementSyntax(TypeScript.Syntax.emptyList, variableDeclaration, semicolonToken, false);
        };

        VariableStatementSyntax.create1 = function (variableDeclaration) {
            return new VariableStatementSyntax(TypeScript.Syntax.emptyList, variableDeclaration, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        VariableStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableStatementSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.variableDeclaration, this.semicolonToken);
        };

        VariableStatementSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        VariableStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.modifiers, variableDeclaration, this.semicolonToken);
        };

        VariableStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.variableDeclaration, semicolonToken);
        };

        VariableStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.modifiers.isTypeScriptSpecific()) {
                return true;
            }
            if (this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableStatementSyntax = VariableStatementSyntax;

    var VariableDeclarationSyntax = (function (_super) {
        __extends(VariableDeclarationSyntax, _super);
        function VariableDeclarationSyntax(varKeyword, variableDeclarators, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.varKeyword = varKeyword;
            this.variableDeclarators = variableDeclarators;
        }
        VariableDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableDeclaration(this);
        };

        VariableDeclarationSyntax.prototype.kind = function () {
            return 223 /* VariableDeclaration */;
        };

        VariableDeclarationSyntax.prototype.childCount = function () {
            return 2;
        };

        VariableDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.varKeyword;
                case 1:
                    return this.variableDeclarators;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableDeclarationSyntax.prototype.update = function (varKeyword, variableDeclarators) {
            if (this.varKeyword === varKeyword && this.variableDeclarators === variableDeclarators) {
                return this;
            }

            return new VariableDeclarationSyntax(varKeyword, variableDeclarators, this.parsedInStrictMode());
        };

        VariableDeclarationSyntax.create1 = function (variableDeclarators) {
            return new VariableDeclarationSyntax(TypeScript.Syntax.token(40 /* VarKeyword */), variableDeclarators, false);
        };

        VariableDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableDeclarationSyntax.prototype.withVarKeyword = function (varKeyword) {
            return this.update(varKeyword, this.variableDeclarators);
        };

        VariableDeclarationSyntax.prototype.withVariableDeclarators = function (variableDeclarators) {
            return this.update(this.varKeyword, variableDeclarators);
        };

        VariableDeclarationSyntax.prototype.withVariableDeclarator = function (variableDeclarator) {
            return this.withVariableDeclarators(TypeScript.Syntax.separatedList([variableDeclarator]));
        };

        VariableDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclarators.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableDeclarationSyntax = VariableDeclarationSyntax;

    var VariableDeclaratorSyntax = (function (_super) {
        __extends(VariableDeclaratorSyntax, _super);
        function VariableDeclaratorSyntax(identifier, typeAnnotation, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.typeAnnotation = typeAnnotation;
            this.equalsValueClause = equalsValueClause;
        }
        VariableDeclaratorSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableDeclarator(this);
        };

        VariableDeclaratorSyntax.prototype.kind = function () {
            return 224 /* VariableDeclarator */;
        };

        VariableDeclaratorSyntax.prototype.childCount = function () {
            return 3;
        };

        VariableDeclaratorSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.typeAnnotation;
                case 2:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableDeclaratorSyntax.prototype.update = function (identifier, typeAnnotation, equalsValueClause) {
            if (this.identifier === identifier && this.typeAnnotation === typeAnnotation && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new VariableDeclaratorSyntax(identifier, typeAnnotation, equalsValueClause, this.parsedInStrictMode());
        };

        VariableDeclaratorSyntax.create = function (identifier) {
            return new VariableDeclaratorSyntax(identifier, null, null, false);
        };

        VariableDeclaratorSyntax.create1 = function (identifier) {
            return new VariableDeclaratorSyntax(identifier, null, null, false);
        };

        VariableDeclaratorSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableDeclaratorSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableDeclaratorSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.typeAnnotation, this.equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.identifier, typeAnnotation, this.equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.identifier, this.typeAnnotation, equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeAnnotation !== null) {
                return true;
            }
            if (this.equalsValueClause !== null && this.equalsValueClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableDeclaratorSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableDeclaratorSyntax = VariableDeclaratorSyntax;

    var EqualsValueClauseSyntax = (function (_super) {
        __extends(EqualsValueClauseSyntax, _super);
        function EqualsValueClauseSyntax(equalsToken, value, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.equalsToken = equalsToken;
            this.value = value;
        }
        EqualsValueClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitEqualsValueClause(this);
        };

        EqualsValueClauseSyntax.prototype.kind = function () {
            return 230 /* EqualsValueClause */;
        };

        EqualsValueClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        EqualsValueClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.equalsToken;
                case 1:
                    return this.value;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EqualsValueClauseSyntax.prototype.update = function (equalsToken, value) {
            if (this.equalsToken === equalsToken && this.value === value) {
                return this;
            }

            return new EqualsValueClauseSyntax(equalsToken, value, this.parsedInStrictMode());
        };

        EqualsValueClauseSyntax.create1 = function (value) {
            return new EqualsValueClauseSyntax(TypeScript.Syntax.token(108 /* EqualsToken */), value, false);
        };

        EqualsValueClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EqualsValueClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EqualsValueClauseSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(equalsToken, this.value);
        };

        EqualsValueClauseSyntax.prototype.withValue = function (value) {
            return this.update(this.equalsToken, value);
        };

        EqualsValueClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.value.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return EqualsValueClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EqualsValueClauseSyntax = EqualsValueClauseSyntax;

    var PrefixUnaryExpressionSyntax = (function (_super) {
        __extends(PrefixUnaryExpressionSyntax, _super);
        function PrefixUnaryExpressionSyntax(kind, operatorToken, operand, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.operatorToken = operatorToken;
            this.operand = operand;

            this._kind = kind;
        }
        PrefixUnaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitPrefixUnaryExpression(this);
        };

        PrefixUnaryExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        PrefixUnaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.operatorToken;
                case 1:
                    return this.operand;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PrefixUnaryExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        PrefixUnaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        PrefixUnaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        PrefixUnaryExpressionSyntax.prototype.update = function (kind, operatorToken, operand) {
            if (this._kind === kind && this.operatorToken === operatorToken && this.operand === operand) {
                return this;
            }

            return new PrefixUnaryExpressionSyntax(kind, operatorToken, operand, this.parsedInStrictMode());
        };

        PrefixUnaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PrefixUnaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PrefixUnaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.operatorToken, this.operand);
        };

        PrefixUnaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, operatorToken, this.operand);
        };

        PrefixUnaryExpressionSyntax.prototype.withOperand = function (operand) {
            return this.update(this._kind, this.operatorToken, operand);
        };

        PrefixUnaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.operand.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return PrefixUnaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PrefixUnaryExpressionSyntax = PrefixUnaryExpressionSyntax;

    var ArrayLiteralExpressionSyntax = (function (_super) {
        __extends(ArrayLiteralExpressionSyntax, _super);
        function ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBracketToken = openBracketToken;
            this.expressions = expressions;
            this.closeBracketToken = closeBracketToken;
        }
        ArrayLiteralExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitArrayLiteralExpression(this);
        };

        ArrayLiteralExpressionSyntax.prototype.kind = function () {
            return 213 /* ArrayLiteralExpression */;
        };

        ArrayLiteralExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ArrayLiteralExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBracketToken;
                case 1:
                    return this.expressions;
                case 2:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArrayLiteralExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.update = function (openBracketToken, expressions, closeBracketToken) {
            if (this.openBracketToken === openBracketToken && this.expressions === expressions && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, this.parsedInStrictMode());
        };

        ArrayLiteralExpressionSyntax.create = function (openBracketToken, closeBracketToken) {
            return new ArrayLiteralExpressionSyntax(openBracketToken, TypeScript.Syntax.emptySeparatedList, closeBracketToken, false);
        };

        ArrayLiteralExpressionSyntax.create1 = function () {
            return new ArrayLiteralExpressionSyntax(TypeScript.Syntax.token(75 /* OpenBracketToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(76 /* CloseBracketToken */), false);
        };

        ArrayLiteralExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArrayLiteralExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArrayLiteralExpressionSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(openBracketToken, this.expressions, this.closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.withExpressions = function (expressions) {
            return this.update(this.openBracketToken, expressions, this.closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.withExpression = function (expression) {
            return this.withExpressions(TypeScript.Syntax.separatedList([expression]));
        };

        ArrayLiteralExpressionSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.openBracketToken, this.expressions, closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expressions.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ArrayLiteralExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArrayLiteralExpressionSyntax = ArrayLiteralExpressionSyntax;

    var OmittedExpressionSyntax = (function (_super) {
        __extends(OmittedExpressionSyntax, _super);
        function OmittedExpressionSyntax(parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
        }
        OmittedExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitOmittedExpression(this);
        };

        OmittedExpressionSyntax.prototype.kind = function () {
            return 222 /* OmittedExpression */;
        };

        OmittedExpressionSyntax.prototype.childCount = function () {
            return 0;
        };

        OmittedExpressionSyntax.prototype.childAt = function (slot) {
            throw TypeScript.Errors.invalidOperation();
        };

        OmittedExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        OmittedExpressionSyntax.prototype.update = function () {
            return this;
        };

        OmittedExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        OmittedExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        OmittedExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return OmittedExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.OmittedExpressionSyntax = OmittedExpressionSyntax;

    var ParenthesizedExpressionSyntax = (function (_super) {
        __extends(ParenthesizedExpressionSyntax, _super);
        function ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.expression = expression;
            this.closeParenToken = closeParenToken;
        }
        ParenthesizedExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitParenthesizedExpression(this);
        };

        ParenthesizedExpressionSyntax.prototype.kind = function () {
            return 216 /* ParenthesizedExpression */;
        };

        ParenthesizedExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ParenthesizedExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openParenToken;
                case 1:
                    return this.expression;
                case 2:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParenthesizedExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.update = function (openParenToken, expression, closeParenToken) {
            if (this.openParenToken === openParenToken && this.expression === expression && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, this.parsedInStrictMode());
        };

        ParenthesizedExpressionSyntax.create1 = function (expression) {
            return new ParenthesizedExpressionSyntax(TypeScript.Syntax.token(73 /* OpenParenToken */), expression, TypeScript.Syntax.token(74 /* CloseParenToken */), false);
        };

        ParenthesizedExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParenthesizedExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParenthesizedExpressionSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(openParenToken, this.expression, this.closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.openParenToken, expression, this.closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.openParenToken, this.expression, closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ParenthesizedExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParenthesizedExpressionSyntax = ParenthesizedExpressionSyntax;

    var ArrowFunctionExpressionSyntax = (function (_super) {
        __extends(ArrowFunctionExpressionSyntax, _super);
        function ArrowFunctionExpressionSyntax(equalsGreaterThanToken, body, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.body = body;
        }
        ArrowFunctionExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ArrowFunctionExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ArrowFunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArrowFunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArrowFunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ArrowFunctionExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArrowFunctionExpressionSyntax = ArrowFunctionExpressionSyntax;

    var SimpleArrowFunctionExpressionSyntax = (function (_super) {
        __extends(SimpleArrowFunctionExpressionSyntax, _super);
        function SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, body, parsedInStrictMode) {
            _super.call(this, equalsGreaterThanToken, body, parsedInStrictMode);
            this.identifier = identifier;
        }
        SimpleArrowFunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitSimpleArrowFunctionExpression(this);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.kind = function () {
            return 218 /* SimpleArrowFunctionExpression */;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.equalsGreaterThanToken;
                case 2:
                    return this.body;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SimpleArrowFunctionExpressionSyntax.prototype.update = function (identifier, equalsGreaterThanToken, body) {
            if (this.identifier === identifier && this.equalsGreaterThanToken === equalsGreaterThanToken && this.body === body) {
                return this;
            }

            return new SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, body, this.parsedInStrictMode());
        };

        SimpleArrowFunctionExpressionSyntax.create1 = function (identifier, body) {
            return new SimpleArrowFunctionExpressionSyntax(identifier, TypeScript.Syntax.token(86 /* EqualsGreaterThanToken */), body, false);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.equalsGreaterThanToken, this.body);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.identifier, equalsGreaterThanToken, this.body);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withBody = function (body) {
            return this.update(this.identifier, this.equalsGreaterThanToken, body);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return SimpleArrowFunctionExpressionSyntax;
    })(ArrowFunctionExpressionSyntax);
    TypeScript.SimpleArrowFunctionExpressionSyntax = SimpleArrowFunctionExpressionSyntax;

    var ParenthesizedArrowFunctionExpressionSyntax = (function (_super) {
        __extends(ParenthesizedArrowFunctionExpressionSyntax, _super);
        function ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, body, parsedInStrictMode) {
            _super.call(this, equalsGreaterThanToken, body, parsedInStrictMode);
            this.callSignature = callSignature;
        }
        ParenthesizedArrowFunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitParenthesizedArrowFunctionExpression(this);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.kind = function () {
            return 217 /* ParenthesizedArrowFunctionExpression */;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.callSignature;
                case 1:
                    return this.equalsGreaterThanToken;
                case 2:
                    return this.body;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.update = function (callSignature, equalsGreaterThanToken, body) {
            if (this.callSignature === callSignature && this.equalsGreaterThanToken === equalsGreaterThanToken && this.body === body) {
                return this;
            }

            return new ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, body, this.parsedInStrictMode());
        };

        ParenthesizedArrowFunctionExpressionSyntax.create1 = function (body) {
            return new ParenthesizedArrowFunctionExpressionSyntax(CallSignatureSyntax.create1(), TypeScript.Syntax.token(86 /* EqualsGreaterThanToken */), body, false);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(callSignature, this.equalsGreaterThanToken, this.body);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.callSignature, equalsGreaterThanToken, this.body);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withBody = function (body) {
            return this.update(this.callSignature, this.equalsGreaterThanToken, body);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ParenthesizedArrowFunctionExpressionSyntax;
    })(ArrowFunctionExpressionSyntax);
    TypeScript.ParenthesizedArrowFunctionExpressionSyntax = ParenthesizedArrowFunctionExpressionSyntax;

    var QualifiedNameSyntax = (function (_super) {
        __extends(QualifiedNameSyntax, _super);
        function QualifiedNameSyntax(left, dotToken, right, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.left = left;
            this.dotToken = dotToken;
            this.right = right;
        }
        QualifiedNameSyntax.prototype.accept = function (visitor) {
            return visitor.visitQualifiedName(this);
        };

        QualifiedNameSyntax.prototype.kind = function () {
            return 122 /* QualifiedName */;
        };

        QualifiedNameSyntax.prototype.childCount = function () {
            return 3;
        };

        QualifiedNameSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.left;
                case 1:
                    return this.dotToken;
                case 2:
                    return this.right;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        QualifiedNameSyntax.prototype.isName = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.isType = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.isExpression = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.update = function (left, dotToken, right) {
            if (this.left === left && this.dotToken === dotToken && this.right === right) {
                return this;
            }

            return new QualifiedNameSyntax(left, dotToken, right, this.parsedInStrictMode());
        };

        QualifiedNameSyntax.create1 = function (left, right) {
            return new QualifiedNameSyntax(left, TypeScript.Syntax.token(77 /* DotToken */), right, false);
        };

        QualifiedNameSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        QualifiedNameSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        QualifiedNameSyntax.prototype.withLeft = function (left) {
            return this.update(left, this.dotToken, this.right);
        };

        QualifiedNameSyntax.prototype.withDotToken = function (dotToken) {
            return this.update(this.left, dotToken, this.right);
        };

        QualifiedNameSyntax.prototype.withRight = function (right) {
            return this.update(this.left, this.dotToken, right);
        };

        QualifiedNameSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return QualifiedNameSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.QualifiedNameSyntax = QualifiedNameSyntax;

    var TypeArgumentListSyntax = (function (_super) {
        __extends(TypeArgumentListSyntax, _super);
        function TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.typeArguments = typeArguments;
            this.greaterThanToken = greaterThanToken;
        }
        TypeArgumentListSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeArgumentList(this);
        };

        TypeArgumentListSyntax.prototype.kind = function () {
            return 227 /* TypeArgumentList */;
        };

        TypeArgumentListSyntax.prototype.childCount = function () {
            return 3;
        };

        TypeArgumentListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.typeArguments;
                case 2:
                    return this.greaterThanToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeArgumentListSyntax.prototype.update = function (lessThanToken, typeArguments, greaterThanToken) {
            if (this.lessThanToken === lessThanToken && this.typeArguments === typeArguments && this.greaterThanToken === greaterThanToken) {
                return this;
            }

            return new TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, this.parsedInStrictMode());
        };

        TypeArgumentListSyntax.create = function (lessThanToken, greaterThanToken) {
            return new TypeArgumentListSyntax(lessThanToken, TypeScript.Syntax.emptySeparatedList, greaterThanToken, false);
        };

        TypeArgumentListSyntax.create1 = function () {
            return new TypeArgumentListSyntax(TypeScript.Syntax.token(81 /* LessThanToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(82 /* GreaterThanToken */), false);
        };

        TypeArgumentListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeArgumentListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeArgumentListSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.typeArguments, this.greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.withTypeArguments = function (typeArguments) {
            return this.update(this.lessThanToken, typeArguments, this.greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.withTypeArgument = function (typeArgument) {
            return this.withTypeArguments(TypeScript.Syntax.separatedList([typeArgument]));
        };

        TypeArgumentListSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.typeArguments, greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeArgumentListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeArgumentListSyntax = TypeArgumentListSyntax;

    var ConstructorTypeSyntax = (function (_super) {
        __extends(ConstructorTypeSyntax, _super);
        function ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.type = type;
        }
        ConstructorTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructorType(this);
        };

        ConstructorTypeSyntax.prototype.kind = function () {
            return 126 /* ConstructorType */;
        };

        ConstructorTypeSyntax.prototype.childCount = function () {
            return 5;
        };

        ConstructorTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.typeParameterList;
                case 2:
                    return this.parameterList;
                case 3:
                    return this.equalsGreaterThanToken;
                case 4:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructorTypeSyntax.prototype.isType = function () {
            return true;
        };

        ConstructorTypeSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ConstructorTypeSyntax.prototype.isExpression = function () {
            return true;
        };

        ConstructorTypeSyntax.prototype.update = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
            if (this.newKeyword === newKeyword && this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.equalsGreaterThanToken === equalsGreaterThanToken && this.type === type) {
                return this;
            }

            return new ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, this.parsedInStrictMode());
        };

        ConstructorTypeSyntax.create = function (newKeyword, parameterList, equalsGreaterThanToken, type) {
            return new ConstructorTypeSyntax(newKeyword, null, parameterList, equalsGreaterThanToken, type, false);
        };

        ConstructorTypeSyntax.create1 = function (type) {
            return new ConstructorTypeSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), null, ParameterListSyntax.create1(), TypeScript.Syntax.token(86 /* EqualsGreaterThanToken */), type, false);
        };

        ConstructorTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructorTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructorTypeSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.newKeyword, typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.newKeyword, this.typeParameterList, parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.newKeyword, this.typeParameterList, this.parameterList, equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withType = function (type) {
            return this.update(this.newKeyword, this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, type);
        };

        ConstructorTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructorTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructorTypeSyntax = ConstructorTypeSyntax;

    var FunctionTypeSyntax = (function (_super) {
        __extends(FunctionTypeSyntax, _super);
        function FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.type = type;
        }
        FunctionTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionType(this);
        };

        FunctionTypeSyntax.prototype.kind = function () {
            return 124 /* FunctionType */;
        };

        FunctionTypeSyntax.prototype.childCount = function () {
            return 4;
        };

        FunctionTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeParameterList;
                case 1:
                    return this.parameterList;
                case 2:
                    return this.equalsGreaterThanToken;
                case 3:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionTypeSyntax.prototype.isType = function () {
            return true;
        };

        FunctionTypeSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        FunctionTypeSyntax.prototype.isExpression = function () {
            return true;
        };

        FunctionTypeSyntax.prototype.update = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
            if (this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.equalsGreaterThanToken === equalsGreaterThanToken && this.type === type) {
                return this;
            }

            return new FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, this.parsedInStrictMode());
        };

        FunctionTypeSyntax.create = function (parameterList, equalsGreaterThanToken, type) {
            return new FunctionTypeSyntax(null, parameterList, equalsGreaterThanToken, type, false);
        };

        FunctionTypeSyntax.create1 = function (type) {
            return new FunctionTypeSyntax(null, ParameterListSyntax.create1(), TypeScript.Syntax.token(86 /* EqualsGreaterThanToken */), type, false);
        };

        FunctionTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionTypeSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.typeParameterList, parameterList, this.equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.typeParameterList, this.parameterList, equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withType = function (type) {
            return this.update(this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, type);
        };

        FunctionTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return FunctionTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionTypeSyntax = FunctionTypeSyntax;

    var ObjectTypeSyntax = (function (_super) {
        __extends(ObjectTypeSyntax, _super);
        function ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.typeMembers = typeMembers;
            this.closeBraceToken = closeBraceToken;
        }
        ObjectTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectType(this);
        };

        ObjectTypeSyntax.prototype.kind = function () {
            return 123 /* ObjectType */;
        };

        ObjectTypeSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.typeMembers;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectTypeSyntax.prototype.isType = function () {
            return true;
        };

        ObjectTypeSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ObjectTypeSyntax.prototype.isExpression = function () {
            return true;
        };

        ObjectTypeSyntax.prototype.update = function (openBraceToken, typeMembers, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.typeMembers === typeMembers && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, this.parsedInStrictMode());
        };

        ObjectTypeSyntax.create = function (openBraceToken, closeBraceToken) {
            return new ObjectTypeSyntax(openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        ObjectTypeSyntax.create1 = function () {
            return new ObjectTypeSyntax(TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        ObjectTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectTypeSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.typeMembers, this.closeBraceToken);
        };

        ObjectTypeSyntax.prototype.withTypeMembers = function (typeMembers) {
            return this.update(this.openBraceToken, typeMembers, this.closeBraceToken);
        };

        ObjectTypeSyntax.prototype.withTypeMember = function (typeMember) {
            return this.withTypeMembers(TypeScript.Syntax.separatedList([typeMember]));
        };

        ObjectTypeSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.typeMembers, closeBraceToken);
        };

        ObjectTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ObjectTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectTypeSyntax = ObjectTypeSyntax;

    var ArrayTypeSyntax = (function (_super) {
        __extends(ArrayTypeSyntax, _super);
        function ArrayTypeSyntax(type, openBracketToken, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.type = type;
            this.openBracketToken = openBracketToken;
            this.closeBracketToken = closeBracketToken;
        }
        ArrayTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitArrayType(this);
        };

        ArrayTypeSyntax.prototype.kind = function () {
            return 125 /* ArrayType */;
        };

        ArrayTypeSyntax.prototype.childCount = function () {
            return 3;
        };

        ArrayTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.type;
                case 1:
                    return this.openBracketToken;
                case 2:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArrayTypeSyntax.prototype.isType = function () {
            return true;
        };

        ArrayTypeSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ArrayTypeSyntax.prototype.isExpression = function () {
            return true;
        };

        ArrayTypeSyntax.prototype.update = function (type, openBracketToken, closeBracketToken) {
            if (this.type === type && this.openBracketToken === openBracketToken && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ArrayTypeSyntax(type, openBracketToken, closeBracketToken, this.parsedInStrictMode());
        };

        ArrayTypeSyntax.create1 = function (type) {
            return new ArrayTypeSyntax(type, TypeScript.Syntax.token(75 /* OpenBracketToken */), TypeScript.Syntax.token(76 /* CloseBracketToken */), false);
        };

        ArrayTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArrayTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArrayTypeSyntax.prototype.withType = function (type) {
            return this.update(type, this.openBracketToken, this.closeBracketToken);
        };

        ArrayTypeSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(this.type, openBracketToken, this.closeBracketToken);
        };

        ArrayTypeSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.type, this.openBracketToken, closeBracketToken);
        };

        ArrayTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ArrayTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArrayTypeSyntax = ArrayTypeSyntax;

    var GenericTypeSyntax = (function (_super) {
        __extends(GenericTypeSyntax, _super);
        function GenericTypeSyntax(name, typeArgumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.name = name;
            this.typeArgumentList = typeArgumentList;
        }
        GenericTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitGenericType(this);
        };

        GenericTypeSyntax.prototype.kind = function () {
            return 127 /* GenericType */;
        };

        GenericTypeSyntax.prototype.childCount = function () {
            return 2;
        };

        GenericTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.name;
                case 1:
                    return this.typeArgumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        GenericTypeSyntax.prototype.isType = function () {
            return true;
        };

        GenericTypeSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        GenericTypeSyntax.prototype.isExpression = function () {
            return true;
        };

        GenericTypeSyntax.prototype.update = function (name, typeArgumentList) {
            if (this.name === name && this.typeArgumentList === typeArgumentList) {
                return this;
            }

            return new GenericTypeSyntax(name, typeArgumentList, this.parsedInStrictMode());
        };

        GenericTypeSyntax.create1 = function (name) {
            return new GenericTypeSyntax(name, TypeArgumentListSyntax.create1(), false);
        };

        GenericTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        GenericTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        GenericTypeSyntax.prototype.withName = function (name) {
            return this.update(name, this.typeArgumentList);
        };

        GenericTypeSyntax.prototype.withTypeArgumentList = function (typeArgumentList) {
            return this.update(this.name, typeArgumentList);
        };

        GenericTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return GenericTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.GenericTypeSyntax = GenericTypeSyntax;

    var TypeAnnotationSyntax = (function (_super) {
        __extends(TypeAnnotationSyntax, _super);
        function TypeAnnotationSyntax(colonToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.colonToken = colonToken;
            this.type = type;
        }
        TypeAnnotationSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeAnnotation(this);
        };

        TypeAnnotationSyntax.prototype.kind = function () {
            return 244 /* TypeAnnotation */;
        };

        TypeAnnotationSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeAnnotationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.colonToken;
                case 1:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeAnnotationSyntax.prototype.update = function (colonToken, type) {
            if (this.colonToken === colonToken && this.type === type) {
                return this;
            }

            return new TypeAnnotationSyntax(colonToken, type, this.parsedInStrictMode());
        };

        TypeAnnotationSyntax.create1 = function (type) {
            return new TypeAnnotationSyntax(TypeScript.Syntax.token(107 /* ColonToken */), type, false);
        };

        TypeAnnotationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeAnnotationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeAnnotationSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(colonToken, this.type);
        };

        TypeAnnotationSyntax.prototype.withType = function (type) {
            return this.update(this.colonToken, type);
        };

        TypeAnnotationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeAnnotationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeAnnotationSyntax = TypeAnnotationSyntax;

    var BlockSyntax = (function (_super) {
        __extends(BlockSyntax, _super);
        function BlockSyntax(openBraceToken, statements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.statements = statements;
            this.closeBraceToken = closeBraceToken;
        }
        BlockSyntax.prototype.accept = function (visitor) {
            return visitor.visitBlock(this);
        };

        BlockSyntax.prototype.kind = function () {
            return 145 /* Block */;
        };

        BlockSyntax.prototype.childCount = function () {
            return 3;
        };

        BlockSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.statements;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BlockSyntax.prototype.isStatement = function () {
            return true;
        };

        BlockSyntax.prototype.isModuleElement = function () {
            return true;
        };

        BlockSyntax.prototype.update = function (openBraceToken, statements, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.statements === statements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new BlockSyntax(openBraceToken, statements, closeBraceToken, this.parsedInStrictMode());
        };

        BlockSyntax.create = function (openBraceToken, closeBraceToken) {
            return new BlockSyntax(openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        BlockSyntax.create1 = function () {
            return new BlockSyntax(TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        BlockSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BlockSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BlockSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.statements, this.closeBraceToken);
        };

        BlockSyntax.prototype.withStatements = function (statements) {
            return this.update(this.openBraceToken, statements, this.closeBraceToken);
        };

        BlockSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        BlockSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.statements, closeBraceToken);
        };

        BlockSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return BlockSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BlockSyntax = BlockSyntax;

    var ParameterSyntax = (function (_super) {
        __extends(ParameterSyntax, _super);
        function ParameterSyntax(dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.dotDotDotToken = dotDotDotToken;
            this.publicOrPrivateKeyword = publicOrPrivateKeyword;
            this.identifier = identifier;
            this.questionToken = questionToken;
            this.typeAnnotation = typeAnnotation;
            this.equalsValueClause = equalsValueClause;
        }
        ParameterSyntax.prototype.accept = function (visitor) {
            return visitor.visitParameter(this);
        };

        ParameterSyntax.prototype.kind = function () {
            return 242 /* Parameter */;
        };

        ParameterSyntax.prototype.childCount = function () {
            return 6;
        };

        ParameterSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.dotDotDotToken;
                case 1:
                    return this.publicOrPrivateKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.questionToken;
                case 4:
                    return this.typeAnnotation;
                case 5:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParameterSyntax.prototype.update = function (dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause) {
            if (this.dotDotDotToken === dotDotDotToken && this.publicOrPrivateKeyword === publicOrPrivateKeyword && this.identifier === identifier && this.questionToken === questionToken && this.typeAnnotation === typeAnnotation && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new ParameterSyntax(dotDotDotToken, publicOrPrivateKeyword, identifier, questionToken, typeAnnotation, equalsValueClause, this.parsedInStrictMode());
        };

        ParameterSyntax.create = function (identifier) {
            return new ParameterSyntax(null, null, identifier, null, null, null, false);
        };

        ParameterSyntax.create1 = function (identifier) {
            return new ParameterSyntax(null, null, identifier, null, null, null, false);
        };

        ParameterSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParameterSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParameterSyntax.prototype.withDotDotDotToken = function (dotDotDotToken) {
            return this.update(dotDotDotToken, this.publicOrPrivateKeyword, this.identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withPublicOrPrivateKeyword = function (publicOrPrivateKeyword) {
            return this.update(this.dotDotDotToken, publicOrPrivateKeyword, this.identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.dotDotDotToken, this.publicOrPrivateKeyword, identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.dotDotDotToken, this.publicOrPrivateKeyword, this.identifier, questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.dotDotDotToken, this.publicOrPrivateKeyword, this.identifier, this.questionToken, typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.dotDotDotToken, this.publicOrPrivateKeyword, this.identifier, this.questionToken, this.typeAnnotation, equalsValueClause);
        };

        ParameterSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.dotDotDotToken !== null) {
                return true;
            }
            if (this.publicOrPrivateKeyword !== null) {
                return true;
            }
            if (this.questionToken !== null) {
                return true;
            }
            if (this.typeAnnotation !== null) {
                return true;
            }
            if (this.equalsValueClause !== null) {
                return true;
            }
            return false;
        };
        return ParameterSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParameterSyntax = ParameterSyntax;

    var MemberAccessExpressionSyntax = (function (_super) {
        __extends(MemberAccessExpressionSyntax, _super);
        function MemberAccessExpressionSyntax(expression, dotToken, name, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.dotToken = dotToken;
            this.name = name;
        }
        MemberAccessExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberAccessExpression(this);
        };

        MemberAccessExpressionSyntax.prototype.kind = function () {
            return 211 /* MemberAccessExpression */;
        };

        MemberAccessExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        MemberAccessExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.dotToken;
                case 2:
                    return this.name;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberAccessExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.update = function (expression, dotToken, name) {
            if (this.expression === expression && this.dotToken === dotToken && this.name === name) {
                return this;
            }

            return new MemberAccessExpressionSyntax(expression, dotToken, name, this.parsedInStrictMode());
        };

        MemberAccessExpressionSyntax.create1 = function (expression, name) {
            return new MemberAccessExpressionSyntax(expression, TypeScript.Syntax.token(77 /* DotToken */), name, false);
        };

        MemberAccessExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberAccessExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberAccessExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.dotToken, this.name);
        };

        MemberAccessExpressionSyntax.prototype.withDotToken = function (dotToken) {
            return this.update(this.expression, dotToken, this.name);
        };

        MemberAccessExpressionSyntax.prototype.withName = function (name) {
            return this.update(this.expression, this.dotToken, name);
        };

        MemberAccessExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return MemberAccessExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberAccessExpressionSyntax = MemberAccessExpressionSyntax;

    var PostfixUnaryExpressionSyntax = (function (_super) {
        __extends(PostfixUnaryExpressionSyntax, _super);
        function PostfixUnaryExpressionSyntax(kind, operand, operatorToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.operand = operand;
            this.operatorToken = operatorToken;

            this._kind = kind;
        }
        PostfixUnaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitPostfixUnaryExpression(this);
        };

        PostfixUnaryExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        PostfixUnaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.operand;
                case 1:
                    return this.operatorToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PostfixUnaryExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        PostfixUnaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        PostfixUnaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        PostfixUnaryExpressionSyntax.prototype.update = function (kind, operand, operatorToken) {
            if (this._kind === kind && this.operand === operand && this.operatorToken === operatorToken) {
                return this;
            }

            return new PostfixUnaryExpressionSyntax(kind, operand, operatorToken, this.parsedInStrictMode());
        };

        PostfixUnaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PostfixUnaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PostfixUnaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.operand, this.operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.withOperand = function (operand) {
            return this.update(this._kind, operand, this.operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, this.operand, operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.operand.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return PostfixUnaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PostfixUnaryExpressionSyntax = PostfixUnaryExpressionSyntax;

    var ElementAccessExpressionSyntax = (function (_super) {
        __extends(ElementAccessExpressionSyntax, _super);
        function ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.openBracketToken = openBracketToken;
            this.argumentExpression = argumentExpression;
            this.closeBracketToken = closeBracketToken;
        }
        ElementAccessExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitElementAccessExpression(this);
        };

        ElementAccessExpressionSyntax.prototype.kind = function () {
            return 220 /* ElementAccessExpression */;
        };

        ElementAccessExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        ElementAccessExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.openBracketToken;
                case 2:
                    return this.argumentExpression;
                case 3:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ElementAccessExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.update = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
            if (this.expression === expression && this.openBracketToken === openBracketToken && this.argumentExpression === argumentExpression && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, this.parsedInStrictMode());
        };

        ElementAccessExpressionSyntax.create1 = function (expression, argumentExpression) {
            return new ElementAccessExpressionSyntax(expression, TypeScript.Syntax.token(75 /* OpenBracketToken */), argumentExpression, TypeScript.Syntax.token(76 /* CloseBracketToken */), false);
        };

        ElementAccessExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ElementAccessExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ElementAccessExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.openBracketToken, this.argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(this.expression, openBracketToken, this.argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withArgumentExpression = function (argumentExpression) {
            return this.update(this.expression, this.openBracketToken, argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.expression, this.openBracketToken, this.argumentExpression, closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentExpression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ElementAccessExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ElementAccessExpressionSyntax = ElementAccessExpressionSyntax;

    var InvocationExpressionSyntax = (function (_super) {
        __extends(InvocationExpressionSyntax, _super);
        function InvocationExpressionSyntax(expression, argumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.argumentList = argumentList;
        }
        InvocationExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitInvocationExpression(this);
        };

        InvocationExpressionSyntax.prototype.kind = function () {
            return 212 /* InvocationExpression */;
        };

        InvocationExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        InvocationExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.argumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        InvocationExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.update = function (expression, argumentList) {
            if (this.expression === expression && this.argumentList === argumentList) {
                return this;
            }

            return new InvocationExpressionSyntax(expression, argumentList, this.parsedInStrictMode());
        };

        InvocationExpressionSyntax.create1 = function (expression) {
            return new InvocationExpressionSyntax(expression, ArgumentListSyntax.create1(), false);
        };

        InvocationExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        InvocationExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        InvocationExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.argumentList);
        };

        InvocationExpressionSyntax.prototype.withArgumentList = function (argumentList) {
            return this.update(this.expression, argumentList);
        };

        InvocationExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentList.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return InvocationExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.InvocationExpressionSyntax = InvocationExpressionSyntax;

    var ArgumentListSyntax = (function (_super) {
        __extends(ArgumentListSyntax, _super);
        function ArgumentListSyntax(typeArgumentList, openParenToken, arguments, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeArgumentList = typeArgumentList;
            this.openParenToken = openParenToken;
            this.arguments = arguments;
            this.closeParenToken = closeParenToken;
        }
        ArgumentListSyntax.prototype.accept = function (visitor) {
            return visitor.visitArgumentList(this);
        };

        ArgumentListSyntax.prototype.kind = function () {
            return 225 /* ArgumentList */;
        };

        ArgumentListSyntax.prototype.childCount = function () {
            return 4;
        };

        ArgumentListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeArgumentList;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.arguments;
                case 3:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArgumentListSyntax.prototype.update = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
            if (this.typeArgumentList === typeArgumentList && this.openParenToken === openParenToken && this.arguments === _arguments && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, this.parsedInStrictMode());
        };

        ArgumentListSyntax.create = function (openParenToken, closeParenToken) {
            return new ArgumentListSyntax(null, openParenToken, TypeScript.Syntax.emptySeparatedList, closeParenToken, false);
        };

        ArgumentListSyntax.create1 = function () {
            return new ArgumentListSyntax(null, TypeScript.Syntax.token(73 /* OpenParenToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(74 /* CloseParenToken */), false);
        };

        ArgumentListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArgumentListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArgumentListSyntax.prototype.withTypeArgumentList = function (typeArgumentList) {
            return this.update(typeArgumentList, this.openParenToken, this.arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.typeArgumentList, openParenToken, this.arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withArguments = function (_arguments) {
            return this.update(this.typeArgumentList, this.openParenToken, _arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withArgument = function (_argument) {
            return this.withArguments(TypeScript.Syntax.separatedList([_argument]));
        };

        ArgumentListSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.typeArgumentList, this.openParenToken, this.arguments, closeParenToken);
        };

        ArgumentListSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeArgumentList !== null && this.typeArgumentList.isTypeScriptSpecific()) {
                return true;
            }
            if (this.arguments.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ArgumentListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArgumentListSyntax = ArgumentListSyntax;

    var BinaryExpressionSyntax = (function (_super) {
        __extends(BinaryExpressionSyntax, _super);
        function BinaryExpressionSyntax(kind, left, operatorToken, right, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.left = left;
            this.operatorToken = operatorToken;
            this.right = right;

            this._kind = kind;
        }
        BinaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitBinaryExpression(this);
        };

        BinaryExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        BinaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.left;
                case 1:
                    return this.operatorToken;
                case 2:
                    return this.right;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BinaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        BinaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        BinaryExpressionSyntax.prototype.update = function (kind, left, operatorToken, right) {
            if (this._kind === kind && this.left === left && this.operatorToken === operatorToken && this.right === right) {
                return this;
            }

            return new BinaryExpressionSyntax(kind, left, operatorToken, right, this.parsedInStrictMode());
        };

        BinaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BinaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BinaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.left, this.operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withLeft = function (left) {
            return this.update(this._kind, left, this.operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, this.left, operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withRight = function (right) {
            return this.update(this._kind, this.left, this.operatorToken, right);
        };

        BinaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.left.isTypeScriptSpecific()) {
                return true;
            }
            if (this.right.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return BinaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BinaryExpressionSyntax = BinaryExpressionSyntax;

    var ConditionalExpressionSyntax = (function (_super) {
        __extends(ConditionalExpressionSyntax, _super);
        function ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.condition = condition;
            this.questionToken = questionToken;
            this.whenTrue = whenTrue;
            this.colonToken = colonToken;
            this.whenFalse = whenFalse;
        }
        ConditionalExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitConditionalExpression(this);
        };

        ConditionalExpressionSyntax.prototype.kind = function () {
            return 185 /* ConditionalExpression */;
        };

        ConditionalExpressionSyntax.prototype.childCount = function () {
            return 5;
        };

        ConditionalExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.condition;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.whenTrue;
                case 3:
                    return this.colonToken;
                case 4:
                    return this.whenFalse;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConditionalExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ConditionalExpressionSyntax.prototype.update = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
            if (this.condition === condition && this.questionToken === questionToken && this.whenTrue === whenTrue && this.colonToken === colonToken && this.whenFalse === whenFalse) {
                return this;
            }

            return new ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, this.parsedInStrictMode());
        };

        ConditionalExpressionSyntax.create1 = function (condition, whenTrue, whenFalse) {
            return new ConditionalExpressionSyntax(condition, TypeScript.Syntax.token(106 /* QuestionToken */), whenTrue, TypeScript.Syntax.token(107 /* ColonToken */), whenFalse, false);
        };

        ConditionalExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConditionalExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConditionalExpressionSyntax.prototype.withCondition = function (condition) {
            return this.update(condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.condition, questionToken, this.whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withWhenTrue = function (whenTrue) {
            return this.update(this.condition, this.questionToken, whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.condition, this.questionToken, this.whenTrue, colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withWhenFalse = function (whenFalse) {
            return this.update(this.condition, this.questionToken, this.whenTrue, this.colonToken, whenFalse);
        };

        ConditionalExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.whenTrue.isTypeScriptSpecific()) {
                return true;
            }
            if (this.whenFalse.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ConditionalExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConditionalExpressionSyntax = ConditionalExpressionSyntax;

    var ConstructSignatureSyntax = (function (_super) {
        __extends(ConstructSignatureSyntax, _super);
        function ConstructSignatureSyntax(newKeyword, callSignature, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.callSignature = callSignature;
        }
        ConstructSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructSignature(this);
        };

        ConstructSignatureSyntax.prototype.kind = function () {
            return 142 /* ConstructSignature */;
        };

        ConstructSignatureSyntax.prototype.childCount = function () {
            return 2;
        };

        ConstructSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.callSignature;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        ConstructSignatureSyntax.prototype.update = function (newKeyword, callSignature) {
            if (this.newKeyword === newKeyword && this.callSignature === callSignature) {
                return this;
            }

            return new ConstructSignatureSyntax(newKeyword, callSignature, this.parsedInStrictMode());
        };

        ConstructSignatureSyntax.create1 = function () {
            return new ConstructSignatureSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), CallSignatureSyntax.create1(), false);
        };

        ConstructSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructSignatureSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.callSignature);
        };

        ConstructSignatureSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.newKeyword, callSignature);
        };

        ConstructSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructSignatureSyntax = ConstructSignatureSyntax;

    var MethodSignatureSyntax = (function (_super) {
        __extends(MethodSignatureSyntax, _super);
        function MethodSignatureSyntax(propertyName, questionToken, callSignature, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.questionToken = questionToken;
            this.callSignature = callSignature;
        }
        MethodSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitMethodSignature(this);
        };

        MethodSignatureSyntax.prototype.kind = function () {
            return 144 /* MethodSignature */;
        };

        MethodSignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        MethodSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.callSignature;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MethodSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        MethodSignatureSyntax.prototype.update = function (propertyName, questionToken, callSignature) {
            if (this.propertyName === propertyName && this.questionToken === questionToken && this.callSignature === callSignature) {
                return this;
            }

            return new MethodSignatureSyntax(propertyName, questionToken, callSignature, this.parsedInStrictMode());
        };

        MethodSignatureSyntax.create = function (propertyName, callSignature) {
            return new MethodSignatureSyntax(propertyName, null, callSignature, false);
        };

        MethodSignatureSyntax.create1 = function (propertyName) {
            return new MethodSignatureSyntax(propertyName, null, CallSignatureSyntax.create1(), false);
        };

        MethodSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MethodSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MethodSignatureSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.questionToken, this.callSignature);
        };

        MethodSignatureSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.propertyName, questionToken, this.callSignature);
        };

        MethodSignatureSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.propertyName, this.questionToken, callSignature);
        };

        MethodSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return MethodSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MethodSignatureSyntax = MethodSignatureSyntax;

    var IndexSignatureSyntax = (function (_super) {
        __extends(IndexSignatureSyntax, _super);
        function IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBracketToken = openBracketToken;
            this.parameter = parameter;
            this.closeBracketToken = closeBracketToken;
            this.typeAnnotation = typeAnnotation;
        }
        IndexSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitIndexSignature(this);
        };

        IndexSignatureSyntax.prototype.kind = function () {
            return 143 /* IndexSignature */;
        };

        IndexSignatureSyntax.prototype.childCount = function () {
            return 4;
        };

        IndexSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBracketToken;
                case 1:
                    return this.parameter;
                case 2:
                    return this.closeBracketToken;
                case 3:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        IndexSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        IndexSignatureSyntax.prototype.isClassElement = function () {
            return true;
        };

        IndexSignatureSyntax.prototype.update = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
            if (this.openBracketToken === openBracketToken && this.parameter === parameter && this.closeBracketToken === closeBracketToken && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, this.parsedInStrictMode());
        };

        IndexSignatureSyntax.create = function (openBracketToken, parameter, closeBracketToken) {
            return new IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, null, false);
        };

        IndexSignatureSyntax.create1 = function (parameter) {
            return new IndexSignatureSyntax(TypeScript.Syntax.token(75 /* OpenBracketToken */), parameter, TypeScript.Syntax.token(76 /* CloseBracketToken */), null, false);
        };

        IndexSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IndexSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IndexSignatureSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(openBracketToken, this.parameter, this.closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withParameter = function (parameter) {
            return this.update(this.openBracketToken, parameter, this.closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.openBracketToken, this.parameter, closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.openBracketToken, this.parameter, this.closeBracketToken, typeAnnotation);
        };

        IndexSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return IndexSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IndexSignatureSyntax = IndexSignatureSyntax;

    var PropertySignatureSyntax = (function (_super) {
        __extends(PropertySignatureSyntax, _super);
        function PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.questionToken = questionToken;
            this.typeAnnotation = typeAnnotation;
        }
        PropertySignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitPropertySignature(this);
        };

        PropertySignatureSyntax.prototype.kind = function () {
            return 140 /* PropertySignature */;
        };

        PropertySignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        PropertySignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PropertySignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        PropertySignatureSyntax.prototype.update = function (propertyName, questionToken, typeAnnotation) {
            if (this.propertyName === propertyName && this.questionToken === questionToken && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, this.parsedInStrictMode());
        };

        PropertySignatureSyntax.create = function (propertyName) {
            return new PropertySignatureSyntax(propertyName, null, null, false);
        };

        PropertySignatureSyntax.create1 = function (propertyName) {
            return new PropertySignatureSyntax(propertyName, null, null, false);
        };

        PropertySignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PropertySignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PropertySignatureSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.questionToken, this.typeAnnotation);
        };

        PropertySignatureSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.propertyName, questionToken, this.typeAnnotation);
        };

        PropertySignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.propertyName, this.questionToken, typeAnnotation);
        };

        PropertySignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return PropertySignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PropertySignatureSyntax = PropertySignatureSyntax;

    var CallSignatureSyntax = (function (_super) {
        __extends(CallSignatureSyntax, _super);
        function CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.typeAnnotation = typeAnnotation;
        }
        CallSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitCallSignature(this);
        };

        CallSignatureSyntax.prototype.kind = function () {
            return 141 /* CallSignature */;
        };

        CallSignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        CallSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeParameterList;
                case 1:
                    return this.parameterList;
                case 2:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CallSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        CallSignatureSyntax.prototype.update = function (typeParameterList, parameterList, typeAnnotation) {
            if (this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, this.parsedInStrictMode());
        };

        CallSignatureSyntax.create = function (parameterList) {
            return new CallSignatureSyntax(null, parameterList, null, false);
        };

        CallSignatureSyntax.create1 = function () {
            return new CallSignatureSyntax(null, ParameterListSyntax.create1(), null, false);
        };

        CallSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CallSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CallSignatureSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(typeParameterList, this.parameterList, this.typeAnnotation);
        };

        CallSignatureSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.typeParameterList, parameterList, this.typeAnnotation);
        };

        CallSignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.typeParameterList, this.parameterList, typeAnnotation);
        };

        CallSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeParameterList !== null) {
                return true;
            }
            if (this.parameterList.isTypeScriptSpecific()) {
                return true;
            }
            if (this.typeAnnotation !== null) {
                return true;
            }
            return false;
        };
        return CallSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CallSignatureSyntax = CallSignatureSyntax;

    var ParameterListSyntax = (function (_super) {
        __extends(ParameterListSyntax, _super);
        function ParameterListSyntax(openParenToken, parameters, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.parameters = parameters;
            this.closeParenToken = closeParenToken;
        }
        ParameterListSyntax.prototype.accept = function (visitor) {
            return visitor.visitParameterList(this);
        };

        ParameterListSyntax.prototype.kind = function () {
            return 226 /* ParameterList */;
        };

        ParameterListSyntax.prototype.childCount = function () {
            return 3;
        };

        ParameterListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openParenToken;
                case 1:
                    return this.parameters;
                case 2:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParameterListSyntax.prototype.update = function (openParenToken, parameters, closeParenToken) {
            if (this.openParenToken === openParenToken && this.parameters === parameters && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ParameterListSyntax(openParenToken, parameters, closeParenToken, this.parsedInStrictMode());
        };

        ParameterListSyntax.create = function (openParenToken, closeParenToken) {
            return new ParameterListSyntax(openParenToken, TypeScript.Syntax.emptySeparatedList, closeParenToken, false);
        };

        ParameterListSyntax.create1 = function () {
            return new ParameterListSyntax(TypeScript.Syntax.token(73 /* OpenParenToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(74 /* CloseParenToken */), false);
        };

        ParameterListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParameterListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParameterListSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(openParenToken, this.parameters, this.closeParenToken);
        };

        ParameterListSyntax.prototype.withParameters = function (parameters) {
            return this.update(this.openParenToken, parameters, this.closeParenToken);
        };

        ParameterListSyntax.prototype.withParameter = function (parameter) {
            return this.withParameters(TypeScript.Syntax.separatedList([parameter]));
        };

        ParameterListSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.openParenToken, this.parameters, closeParenToken);
        };

        ParameterListSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.parameters.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ParameterListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParameterListSyntax = ParameterListSyntax;

    var TypeParameterListSyntax = (function (_super) {
        __extends(TypeParameterListSyntax, _super);
        function TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.typeParameters = typeParameters;
            this.greaterThanToken = greaterThanToken;
        }
        TypeParameterListSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeParameterList(this);
        };

        TypeParameterListSyntax.prototype.kind = function () {
            return 228 /* TypeParameterList */;
        };

        TypeParameterListSyntax.prototype.childCount = function () {
            return 3;
        };

        TypeParameterListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.typeParameters;
                case 2:
                    return this.greaterThanToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeParameterListSyntax.prototype.update = function (lessThanToken, typeParameters, greaterThanToken) {
            if (this.lessThanToken === lessThanToken && this.typeParameters === typeParameters && this.greaterThanToken === greaterThanToken) {
                return this;
            }

            return new TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, this.parsedInStrictMode());
        };

        TypeParameterListSyntax.create = function (lessThanToken, greaterThanToken) {
            return new TypeParameterListSyntax(lessThanToken, TypeScript.Syntax.emptySeparatedList, greaterThanToken, false);
        };

        TypeParameterListSyntax.create1 = function () {
            return new TypeParameterListSyntax(TypeScript.Syntax.token(81 /* LessThanToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(82 /* GreaterThanToken */), false);
        };

        TypeParameterListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeParameterListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeParameterListSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.typeParameters, this.greaterThanToken);
        };

        TypeParameterListSyntax.prototype.withTypeParameters = function (typeParameters) {
            return this.update(this.lessThanToken, typeParameters, this.greaterThanToken);
        };

        TypeParameterListSyntax.prototype.withTypeParameter = function (typeParameter) {
            return this.withTypeParameters(TypeScript.Syntax.separatedList([typeParameter]));
        };

        TypeParameterListSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.typeParameters, greaterThanToken);
        };

        TypeParameterListSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeParameterListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeParameterListSyntax = TypeParameterListSyntax;

    var TypeParameterSyntax = (function (_super) {
        __extends(TypeParameterSyntax, _super);
        function TypeParameterSyntax(identifier, constraint, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.constraint = constraint;
        }
        TypeParameterSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeParameter(this);
        };

        TypeParameterSyntax.prototype.kind = function () {
            return 236 /* TypeParameter */;
        };

        TypeParameterSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeParameterSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.constraint;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeParameterSyntax.prototype.update = function (identifier, constraint) {
            if (this.identifier === identifier && this.constraint === constraint) {
                return this;
            }

            return new TypeParameterSyntax(identifier, constraint, this.parsedInStrictMode());
        };

        TypeParameterSyntax.create = function (identifier) {
            return new TypeParameterSyntax(identifier, null, false);
        };

        TypeParameterSyntax.create1 = function (identifier) {
            return new TypeParameterSyntax(identifier, null, false);
        };

        TypeParameterSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeParameterSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeParameterSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.constraint);
        };

        TypeParameterSyntax.prototype.withConstraint = function (constraint) {
            return this.update(this.identifier, constraint);
        };

        TypeParameterSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeParameterSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeParameterSyntax = TypeParameterSyntax;

    var ConstraintSyntax = (function (_super) {
        __extends(ConstraintSyntax, _super);
        function ConstraintSyntax(extendsKeyword, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.extendsKeyword = extendsKeyword;
            this.type = type;
        }
        ConstraintSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstraint(this);
        };

        ConstraintSyntax.prototype.kind = function () {
            return 237 /* Constraint */;
        };

        ConstraintSyntax.prototype.childCount = function () {
            return 2;
        };

        ConstraintSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.extendsKeyword;
                case 1:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstraintSyntax.prototype.update = function (extendsKeyword, type) {
            if (this.extendsKeyword === extendsKeyword && this.type === type) {
                return this;
            }

            return new ConstraintSyntax(extendsKeyword, type, this.parsedInStrictMode());
        };

        ConstraintSyntax.create1 = function (type) {
            return new ConstraintSyntax(TypeScript.Syntax.token(48 /* ExtendsKeyword */), type, false);
        };

        ConstraintSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstraintSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstraintSyntax.prototype.withExtendsKeyword = function (extendsKeyword) {
            return this.update(extendsKeyword, this.type);
        };

        ConstraintSyntax.prototype.withType = function (type) {
            return this.update(this.extendsKeyword, type);
        };

        ConstraintSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstraintSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstraintSyntax = ConstraintSyntax;

    var ElseClauseSyntax = (function (_super) {
        __extends(ElseClauseSyntax, _super);
        function ElseClauseSyntax(elseKeyword, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.elseKeyword = elseKeyword;
            this.statement = statement;
        }
        ElseClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitElseClause(this);
        };

        ElseClauseSyntax.prototype.kind = function () {
            return 233 /* ElseClause */;
        };

        ElseClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        ElseClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.elseKeyword;
                case 1:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ElseClauseSyntax.prototype.update = function (elseKeyword, statement) {
            if (this.elseKeyword === elseKeyword && this.statement === statement) {
                return this;
            }

            return new ElseClauseSyntax(elseKeyword, statement, this.parsedInStrictMode());
        };

        ElseClauseSyntax.create1 = function (statement) {
            return new ElseClauseSyntax(TypeScript.Syntax.token(23 /* ElseKeyword */), statement, false);
        };

        ElseClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ElseClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ElseClauseSyntax.prototype.withElseKeyword = function (elseKeyword) {
            return this.update(elseKeyword, this.statement);
        };

        ElseClauseSyntax.prototype.withStatement = function (statement) {
            return this.update(this.elseKeyword, statement);
        };

        ElseClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ElseClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ElseClauseSyntax = ElseClauseSyntax;

    var IfStatementSyntax = (function (_super) {
        __extends(IfStatementSyntax, _super);
        function IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.ifKeyword = ifKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
            this.elseClause = elseClause;
        }
        IfStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitIfStatement(this);
        };

        IfStatementSyntax.prototype.kind = function () {
            return 146 /* IfStatement */;
        };

        IfStatementSyntax.prototype.childCount = function () {
            return 6;
        };

        IfStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.ifKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                case 5:
                    return this.elseClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        IfStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        IfStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        IfStatementSyntax.prototype.update = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
            if (this.ifKeyword === ifKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement && this.elseClause === elseClause) {
                return this;
            }

            return new IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, this.parsedInStrictMode());
        };

        IfStatementSyntax.create = function (ifKeyword, openParenToken, condition, closeParenToken, statement) {
            return new IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, null, false);
        };

        IfStatementSyntax.create1 = function (condition, statement) {
            return new IfStatementSyntax(TypeScript.Syntax.token(28 /* IfKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), condition, TypeScript.Syntax.token(74 /* CloseParenToken */), statement, null, false);
        };

        IfStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IfStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IfStatementSyntax.prototype.withIfKeyword = function (ifKeyword) {
            return this.update(ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.ifKeyword, openParenToken, this.condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.ifKeyword, this.openParenToken, condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withElseClause = function (elseClause) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, elseClause);
        };

        IfStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            if (this.elseClause !== null && this.elseClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return IfStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IfStatementSyntax = IfStatementSyntax;

    var ExpressionStatementSyntax = (function (_super) {
        __extends(ExpressionStatementSyntax, _super);
        function ExpressionStatementSyntax(expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ExpressionStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitExpressionStatement(this);
        };

        ExpressionStatementSyntax.prototype.kind = function () {
            return 148 /* ExpressionStatement */;
        };

        ExpressionStatementSyntax.prototype.childCount = function () {
            return 2;
        };

        ExpressionStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExpressionStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ExpressionStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ExpressionStatementSyntax.prototype.update = function (expression, semicolonToken) {
            if (this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ExpressionStatementSyntax(expression, semicolonToken, this.parsedInStrictMode());
        };

        ExpressionStatementSyntax.create1 = function (expression) {
            return new ExpressionStatementSyntax(expression, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ExpressionStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExpressionStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExpressionStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.semicolonToken);
        };

        ExpressionStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.expression, semicolonToken);
        };

        ExpressionStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ExpressionStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ExpressionStatementSyntax = ExpressionStatementSyntax;

    var ConstructorDeclarationSyntax = (function (_super) {
        __extends(ConstructorDeclarationSyntax, _super);
        function ConstructorDeclarationSyntax(constructorKeyword, parameterList, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.constructorKeyword = constructorKeyword;
            this.parameterList = parameterList;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        ConstructorDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructorDeclaration(this);
        };

        ConstructorDeclarationSyntax.prototype.kind = function () {
            return 137 /* ConstructorDeclaration */;
        };

        ConstructorDeclarationSyntax.prototype.childCount = function () {
            return 4;
        };

        ConstructorDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.constructorKeyword;
                case 1:
                    return this.parameterList;
                case 2:
                    return this.block;
                case 3:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructorDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        ConstructorDeclarationSyntax.prototype.update = function (constructorKeyword, parameterList, block, semicolonToken) {
            if (this.constructorKeyword === constructorKeyword && this.parameterList === parameterList && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ConstructorDeclarationSyntax(constructorKeyword, parameterList, block, semicolonToken, this.parsedInStrictMode());
        };

        ConstructorDeclarationSyntax.create = function (constructorKeyword, parameterList) {
            return new ConstructorDeclarationSyntax(constructorKeyword, parameterList, null, null, false);
        };

        ConstructorDeclarationSyntax.create1 = function () {
            return new ConstructorDeclarationSyntax(TypeScript.Syntax.token(63 /* ConstructorKeyword */), ParameterListSyntax.create1(), null, null, false);
        };

        ConstructorDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructorDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructorDeclarationSyntax.prototype.withConstructorKeyword = function (constructorKeyword) {
            return this.update(constructorKeyword, this.parameterList, this.block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.constructorKeyword, parameterList, this.block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.constructorKeyword, this.parameterList, block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.constructorKeyword, this.parameterList, this.block, semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructorDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructorDeclarationSyntax = ConstructorDeclarationSyntax;

    var MemberFunctionDeclarationSyntax = (function (_super) {
        __extends(MemberFunctionDeclarationSyntax, _super);
        function MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.propertyName = propertyName;
            this.callSignature = callSignature;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        MemberFunctionDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberFunctionDeclaration(this);
        };

        MemberFunctionDeclarationSyntax.prototype.kind = function () {
            return 135 /* MemberFunctionDeclaration */;
        };

        MemberFunctionDeclarationSyntax.prototype.childCount = function () {
            return 5;
        };

        MemberFunctionDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.propertyName;
                case 2:
                    return this.callSignature;
                case 3:
                    return this.block;
                case 4:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberFunctionDeclarationSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        MemberFunctionDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        MemberFunctionDeclarationSyntax.prototype.update = function (modifiers, propertyName, callSignature, block, semicolonToken) {
            if (this.modifiers === modifiers && this.propertyName === propertyName && this.callSignature === callSignature && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, this.parsedInStrictMode());
        };

        MemberFunctionDeclarationSyntax.create = function (propertyName, callSignature) {
            return new MemberFunctionDeclarationSyntax(TypeScript.Syntax.emptyList, propertyName, callSignature, null, null, false);
        };

        MemberFunctionDeclarationSyntax.create1 = function (propertyName) {
            return new MemberFunctionDeclarationSyntax(TypeScript.Syntax.emptyList, propertyName, CallSignatureSyntax.create1(), null, null, false);
        };

        MemberFunctionDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberFunctionDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberFunctionDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.propertyName, this.callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        MemberFunctionDeclarationSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, propertyName, this.callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.modifiers, this.propertyName, callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.propertyName, this.callSignature, block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.propertyName, this.callSignature, this.block, semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return MemberFunctionDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberFunctionDeclarationSyntax = MemberFunctionDeclarationSyntax;

    var MemberAccessorDeclarationSyntax = (function (_super) {
        __extends(MemberAccessorDeclarationSyntax, _super);
        function MemberAccessorDeclarationSyntax(modifiers, propertyName, parameterList, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.propertyName = propertyName;
            this.parameterList = parameterList;
            this.block = block;
        }
        MemberAccessorDeclarationSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        MemberAccessorDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        MemberAccessorDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberAccessorDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberAccessorDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return MemberAccessorDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberAccessorDeclarationSyntax = MemberAccessorDeclarationSyntax;

    var GetMemberAccessorDeclarationSyntax = (function (_super) {
        __extends(GetMemberAccessorDeclarationSyntax, _super);
        function GetMemberAccessorDeclarationSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, parsedInStrictMode) {
            _super.call(this, modifiers, propertyName, parameterList, block, parsedInStrictMode);
            this.getKeyword = getKeyword;
            this.typeAnnotation = typeAnnotation;
        }
        GetMemberAccessorDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitGetMemberAccessorDeclaration(this);
        };

        GetMemberAccessorDeclarationSyntax.prototype.kind = function () {
            return 138 /* GetMemberAccessorDeclaration */;
        };

        GetMemberAccessorDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        GetMemberAccessorDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.getKeyword;
                case 2:
                    return this.propertyName;
                case 3:
                    return this.parameterList;
                case 4:
                    return this.typeAnnotation;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        GetMemberAccessorDeclarationSyntax.prototype.update = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
            if (this.modifiers === modifiers && this.getKeyword === getKeyword && this.propertyName === propertyName && this.parameterList === parameterList && this.typeAnnotation === typeAnnotation && this.block === block) {
                return this;
            }

            return new GetMemberAccessorDeclarationSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, this.parsedInStrictMode());
        };

        GetMemberAccessorDeclarationSyntax.create = function (getKeyword, propertyName, parameterList, block) {
            return new GetMemberAccessorDeclarationSyntax(TypeScript.Syntax.emptyList, getKeyword, propertyName, parameterList, null, block, false);
        };

        GetMemberAccessorDeclarationSyntax.create1 = function (propertyName) {
            return new GetMemberAccessorDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(65 /* GetKeyword */), propertyName, ParameterListSyntax.create1(), null, BlockSyntax.create1(), false);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        GetMemberAccessorDeclarationSyntax.prototype.withGetKeyword = function (getKeyword) {
            return this.update(this.modifiers, getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, this.getKeyword, propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, parameterList, this.typeAnnotation, this.block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, this.parameterList, typeAnnotation, this.block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, block);
        };

        GetMemberAccessorDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return GetMemberAccessorDeclarationSyntax;
    })(MemberAccessorDeclarationSyntax);
    TypeScript.GetMemberAccessorDeclarationSyntax = GetMemberAccessorDeclarationSyntax;

    var SetMemberAccessorDeclarationSyntax = (function (_super) {
        __extends(SetMemberAccessorDeclarationSyntax, _super);
        function SetMemberAccessorDeclarationSyntax(modifiers, setKeyword, propertyName, parameterList, block, parsedInStrictMode) {
            _super.call(this, modifiers, propertyName, parameterList, block, parsedInStrictMode);
            this.setKeyword = setKeyword;
        }
        SetMemberAccessorDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitSetMemberAccessorDeclaration(this);
        };

        SetMemberAccessorDeclarationSyntax.prototype.kind = function () {
            return 139 /* SetMemberAccessorDeclaration */;
        };

        SetMemberAccessorDeclarationSyntax.prototype.childCount = function () {
            return 5;
        };

        SetMemberAccessorDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.setKeyword;
                case 2:
                    return this.propertyName;
                case 3:
                    return this.parameterList;
                case 4:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SetMemberAccessorDeclarationSyntax.prototype.update = function (modifiers, setKeyword, propertyName, parameterList, block) {
            if (this.modifiers === modifiers && this.setKeyword === setKeyword && this.propertyName === propertyName && this.parameterList === parameterList && this.block === block) {
                return this;
            }

            return new SetMemberAccessorDeclarationSyntax(modifiers, setKeyword, propertyName, parameterList, block, this.parsedInStrictMode());
        };

        SetMemberAccessorDeclarationSyntax.create = function (setKeyword, propertyName, parameterList, block) {
            return new SetMemberAccessorDeclarationSyntax(TypeScript.Syntax.emptyList, setKeyword, propertyName, parameterList, block, false);
        };

        SetMemberAccessorDeclarationSyntax.create1 = function (propertyName) {
            return new SetMemberAccessorDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(69 /* SetKeyword */), propertyName, ParameterListSyntax.create1(), BlockSyntax.create1(), false);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.setKeyword, this.propertyName, this.parameterList, this.block);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        SetMemberAccessorDeclarationSyntax.prototype.withSetKeyword = function (setKeyword) {
            return this.update(this.modifiers, setKeyword, this.propertyName, this.parameterList, this.block);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, this.setKeyword, propertyName, this.parameterList, this.block);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.modifiers, this.setKeyword, this.propertyName, parameterList, this.block);
        };

        SetMemberAccessorDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.setKeyword, this.propertyName, this.parameterList, block);
        };

        SetMemberAccessorDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return SetMemberAccessorDeclarationSyntax;
    })(MemberAccessorDeclarationSyntax);
    TypeScript.SetMemberAccessorDeclarationSyntax = SetMemberAccessorDeclarationSyntax;

    var MemberVariableDeclarationSyntax = (function (_super) {
        __extends(MemberVariableDeclarationSyntax, _super);
        function MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.variableDeclarator = variableDeclarator;
            this.semicolonToken = semicolonToken;
        }
        MemberVariableDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberVariableDeclaration(this);
        };

        MemberVariableDeclarationSyntax.prototype.kind = function () {
            return 136 /* MemberVariableDeclaration */;
        };

        MemberVariableDeclarationSyntax.prototype.childCount = function () {
            return 3;
        };

        MemberVariableDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.variableDeclarator;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberVariableDeclarationSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        MemberVariableDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        MemberVariableDeclarationSyntax.prototype.update = function (modifiers, variableDeclarator, semicolonToken) {
            if (this.modifiers === modifiers && this.variableDeclarator === variableDeclarator && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, this.parsedInStrictMode());
        };

        MemberVariableDeclarationSyntax.create = function (variableDeclarator, semicolonToken) {
            return new MemberVariableDeclarationSyntax(TypeScript.Syntax.emptyList, variableDeclarator, semicolonToken, false);
        };

        MemberVariableDeclarationSyntax.create1 = function (variableDeclarator) {
            return new MemberVariableDeclarationSyntax(TypeScript.Syntax.emptyList, variableDeclarator, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        MemberVariableDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberVariableDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberVariableDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.variableDeclarator, this.semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        MemberVariableDeclarationSyntax.prototype.withVariableDeclarator = function (variableDeclarator) {
            return this.update(this.modifiers, variableDeclarator, this.semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.variableDeclarator, semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return MemberVariableDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberVariableDeclarationSyntax = MemberVariableDeclarationSyntax;

    var ThrowStatementSyntax = (function (_super) {
        __extends(ThrowStatementSyntax, _super);
        function ThrowStatementSyntax(throwKeyword, expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.throwKeyword = throwKeyword;
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ThrowStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitThrowStatement(this);
        };

        ThrowStatementSyntax.prototype.kind = function () {
            return 156 /* ThrowStatement */;
        };

        ThrowStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ThrowStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.throwKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ThrowStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ThrowStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ThrowStatementSyntax.prototype.update = function (throwKeyword, expression, semicolonToken) {
            if (this.throwKeyword === throwKeyword && this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ThrowStatementSyntax(throwKeyword, expression, semicolonToken, this.parsedInStrictMode());
        };

        ThrowStatementSyntax.create1 = function (expression) {
            return new ThrowStatementSyntax(TypeScript.Syntax.token(36 /* ThrowKeyword */), expression, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ThrowStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ThrowStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ThrowStatementSyntax.prototype.withThrowKeyword = function (throwKeyword) {
            return this.update(throwKeyword, this.expression, this.semicolonToken);
        };

        ThrowStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.throwKeyword, expression, this.semicolonToken);
        };

        ThrowStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.throwKeyword, this.expression, semicolonToken);
        };

        ThrowStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ThrowStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ThrowStatementSyntax = ThrowStatementSyntax;

    var ReturnStatementSyntax = (function (_super) {
        __extends(ReturnStatementSyntax, _super);
        function ReturnStatementSyntax(returnKeyword, expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.returnKeyword = returnKeyword;
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ReturnStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitReturnStatement(this);
        };

        ReturnStatementSyntax.prototype.kind = function () {
            return 149 /* ReturnStatement */;
        };

        ReturnStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ReturnStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.returnKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ReturnStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ReturnStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ReturnStatementSyntax.prototype.update = function (returnKeyword, expression, semicolonToken) {
            if (this.returnKeyword === returnKeyword && this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ReturnStatementSyntax(returnKeyword, expression, semicolonToken, this.parsedInStrictMode());
        };

        ReturnStatementSyntax.create = function (returnKeyword, semicolonToken) {
            return new ReturnStatementSyntax(returnKeyword, null, semicolonToken, false);
        };

        ReturnStatementSyntax.create1 = function () {
            return new ReturnStatementSyntax(TypeScript.Syntax.token(33 /* ReturnKeyword */), null, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ReturnStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ReturnStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ReturnStatementSyntax.prototype.withReturnKeyword = function (returnKeyword) {
            return this.update(returnKeyword, this.expression, this.semicolonToken);
        };

        ReturnStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.returnKeyword, expression, this.semicolonToken);
        };

        ReturnStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.returnKeyword, this.expression, semicolonToken);
        };

        ReturnStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression !== null && this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ReturnStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ReturnStatementSyntax = ReturnStatementSyntax;

    var ObjectCreationExpressionSyntax = (function (_super) {
        __extends(ObjectCreationExpressionSyntax, _super);
        function ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.expression = expression;
            this.argumentList = argumentList;
        }
        ObjectCreationExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectCreationExpression(this);
        };

        ObjectCreationExpressionSyntax.prototype.kind = function () {
            return 215 /* ObjectCreationExpression */;
        };

        ObjectCreationExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectCreationExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.argumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectCreationExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.update = function (newKeyword, expression, argumentList) {
            if (this.newKeyword === newKeyword && this.expression === expression && this.argumentList === argumentList) {
                return this;
            }

            return new ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, this.parsedInStrictMode());
        };

        ObjectCreationExpressionSyntax.create = function (newKeyword, expression) {
            return new ObjectCreationExpressionSyntax(newKeyword, expression, null, false);
        };

        ObjectCreationExpressionSyntax.create1 = function (expression) {
            return new ObjectCreationExpressionSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), expression, null, false);
        };

        ObjectCreationExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectCreationExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectCreationExpressionSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.expression, this.argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.newKeyword, expression, this.argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.withArgumentList = function (argumentList) {
            return this.update(this.newKeyword, this.expression, argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentList !== null && this.argumentList.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ObjectCreationExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectCreationExpressionSyntax = ObjectCreationExpressionSyntax;

    var SwitchStatementSyntax = (function (_super) {
        __extends(SwitchStatementSyntax, _super);
        function SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.switchKeyword = switchKeyword;
            this.openParenToken = openParenToken;
            this.expression = expression;
            this.closeParenToken = closeParenToken;
            this.openBraceToken = openBraceToken;
            this.switchClauses = switchClauses;
            this.closeBraceToken = closeBraceToken;
        }
        SwitchStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitSwitchStatement(this);
        };

        SwitchStatementSyntax.prototype.kind = function () {
            return 150 /* SwitchStatement */;
        };

        SwitchStatementSyntax.prototype.childCount = function () {
            return 7;
        };

        SwitchStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.switchKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.expression;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.openBraceToken;
                case 5:
                    return this.switchClauses;
                case 6:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SwitchStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        SwitchStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        SwitchStatementSyntax.prototype.update = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
            if (this.switchKeyword === switchKeyword && this.openParenToken === openParenToken && this.expression === expression && this.closeParenToken === closeParenToken && this.openBraceToken === openBraceToken && this.switchClauses === switchClauses && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, this.parsedInStrictMode());
        };

        SwitchStatementSyntax.create = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, closeBraceToken) {
            return new SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        SwitchStatementSyntax.create1 = function (expression) {
            return new SwitchStatementSyntax(TypeScript.Syntax.token(34 /* SwitchKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), expression, TypeScript.Syntax.token(74 /* CloseParenToken */), TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        SwitchStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SwitchStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SwitchStatementSyntax.prototype.withSwitchKeyword = function (switchKeyword) {
            return this.update(switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.switchKeyword, openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.switchKeyword, this.openParenToken, expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withSwitchClauses = function (switchClauses) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withSwitchClause = function (switchClause) {
            return this.withSwitchClauses(TypeScript.Syntax.list([switchClause]));
        };

        SwitchStatementSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, closeBraceToken);
        };

        SwitchStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.switchClauses.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SwitchStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SwitchStatementSyntax = SwitchStatementSyntax;

    var SwitchClauseSyntax = (function (_super) {
        __extends(SwitchClauseSyntax, _super);
        function SwitchClauseSyntax(colonToken, statements, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.colonToken = colonToken;
            this.statements = statements;
        }
        SwitchClauseSyntax.prototype.isSwitchClause = function () {
            return true;
        };

        SwitchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SwitchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SwitchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return SwitchClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SwitchClauseSyntax = SwitchClauseSyntax;

    var CaseSwitchClauseSyntax = (function (_super) {
        __extends(CaseSwitchClauseSyntax, _super);
        function CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, parsedInStrictMode) {
            _super.call(this, colonToken, statements, parsedInStrictMode);
            this.caseKeyword = caseKeyword;
            this.expression = expression;
        }
        CaseSwitchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitCaseSwitchClause(this);
        };

        CaseSwitchClauseSyntax.prototype.kind = function () {
            return 231 /* CaseSwitchClause */;
        };

        CaseSwitchClauseSyntax.prototype.childCount = function () {
            return 4;
        };

        CaseSwitchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.caseKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.colonToken;
                case 3:
                    return this.statements;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CaseSwitchClauseSyntax.prototype.update = function (caseKeyword, expression, colonToken, statements) {
            if (this.caseKeyword === caseKeyword && this.expression === expression && this.colonToken === colonToken && this.statements === statements) {
                return this;
            }

            return new CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, this.parsedInStrictMode());
        };

        CaseSwitchClauseSyntax.create = function (caseKeyword, expression, colonToken) {
            return new CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, TypeScript.Syntax.emptyList, false);
        };

        CaseSwitchClauseSyntax.create1 = function (expression) {
            return new CaseSwitchClauseSyntax(TypeScript.Syntax.token(16 /* CaseKeyword */), expression, TypeScript.Syntax.token(107 /* ColonToken */), TypeScript.Syntax.emptyList, false);
        };

        CaseSwitchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CaseSwitchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CaseSwitchClauseSyntax.prototype.withCaseKeyword = function (caseKeyword) {
            return this.update(caseKeyword, this.expression, this.colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withExpression = function (expression) {
            return this.update(this.caseKeyword, expression, this.colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.caseKeyword, this.expression, colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withStatements = function (statements) {
            return this.update(this.caseKeyword, this.expression, this.colonToken, statements);
        };

        CaseSwitchClauseSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        CaseSwitchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return CaseSwitchClauseSyntax;
    })(SwitchClauseSyntax);
    TypeScript.CaseSwitchClauseSyntax = CaseSwitchClauseSyntax;

    var DefaultSwitchClauseSyntax = (function (_super) {
        __extends(DefaultSwitchClauseSyntax, _super);
        function DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, parsedInStrictMode) {
            _super.call(this, colonToken, statements, parsedInStrictMode);
            this.defaultKeyword = defaultKeyword;
        }
        DefaultSwitchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitDefaultSwitchClause(this);
        };

        DefaultSwitchClauseSyntax.prototype.kind = function () {
            return 232 /* DefaultSwitchClause */;
        };

        DefaultSwitchClauseSyntax.prototype.childCount = function () {
            return 3;
        };

        DefaultSwitchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.defaultKeyword;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.statements;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DefaultSwitchClauseSyntax.prototype.update = function (defaultKeyword, colonToken, statements) {
            if (this.defaultKeyword === defaultKeyword && this.colonToken === colonToken && this.statements === statements) {
                return this;
            }

            return new DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, this.parsedInStrictMode());
        };

        DefaultSwitchClauseSyntax.create = function (defaultKeyword, colonToken) {
            return new DefaultSwitchClauseSyntax(defaultKeyword, colonToken, TypeScript.Syntax.emptyList, false);
        };

        DefaultSwitchClauseSyntax.create1 = function () {
            return new DefaultSwitchClauseSyntax(TypeScript.Syntax.token(20 /* DefaultKeyword */), TypeScript.Syntax.token(107 /* ColonToken */), TypeScript.Syntax.emptyList, false);
        };

        DefaultSwitchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DefaultSwitchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DefaultSwitchClauseSyntax.prototype.withDefaultKeyword = function (defaultKeyword) {
            return this.update(defaultKeyword, this.colonToken, this.statements);
        };

        DefaultSwitchClauseSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.defaultKeyword, colonToken, this.statements);
        };

        DefaultSwitchClauseSyntax.prototype.withStatements = function (statements) {
            return this.update(this.defaultKeyword, this.colonToken, statements);
        };

        DefaultSwitchClauseSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        DefaultSwitchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DefaultSwitchClauseSyntax;
    })(SwitchClauseSyntax);
    TypeScript.DefaultSwitchClauseSyntax = DefaultSwitchClauseSyntax;

    var BreakStatementSyntax = (function (_super) {
        __extends(BreakStatementSyntax, _super);
        function BreakStatementSyntax(breakKeyword, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.breakKeyword = breakKeyword;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        BreakStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitBreakStatement(this);
        };

        BreakStatementSyntax.prototype.kind = function () {
            return 151 /* BreakStatement */;
        };

        BreakStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        BreakStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.breakKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BreakStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        BreakStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        BreakStatementSyntax.prototype.update = function (breakKeyword, identifier, semicolonToken) {
            if (this.breakKeyword === breakKeyword && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new BreakStatementSyntax(breakKeyword, identifier, semicolonToken, this.parsedInStrictMode());
        };

        BreakStatementSyntax.create = function (breakKeyword, semicolonToken) {
            return new BreakStatementSyntax(breakKeyword, null, semicolonToken, false);
        };

        BreakStatementSyntax.create1 = function () {
            return new BreakStatementSyntax(TypeScript.Syntax.token(15 /* BreakKeyword */), null, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        BreakStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BreakStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BreakStatementSyntax.prototype.withBreakKeyword = function (breakKeyword) {
            return this.update(breakKeyword, this.identifier, this.semicolonToken);
        };

        BreakStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.breakKeyword, identifier, this.semicolonToken);
        };

        BreakStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.breakKeyword, this.identifier, semicolonToken);
        };

        BreakStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return BreakStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BreakStatementSyntax = BreakStatementSyntax;

    var ContinueStatementSyntax = (function (_super) {
        __extends(ContinueStatementSyntax, _super);
        function ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.continueKeyword = continueKeyword;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        ContinueStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitContinueStatement(this);
        };

        ContinueStatementSyntax.prototype.kind = function () {
            return 152 /* ContinueStatement */;
        };

        ContinueStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ContinueStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.continueKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ContinueStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ContinueStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ContinueStatementSyntax.prototype.update = function (continueKeyword, identifier, semicolonToken) {
            if (this.continueKeyword === continueKeyword && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, this.parsedInStrictMode());
        };

        ContinueStatementSyntax.create = function (continueKeyword, semicolonToken) {
            return new ContinueStatementSyntax(continueKeyword, null, semicolonToken, false);
        };

        ContinueStatementSyntax.create1 = function () {
            return new ContinueStatementSyntax(TypeScript.Syntax.token(18 /* ContinueKeyword */), null, TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        ContinueStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ContinueStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ContinueStatementSyntax.prototype.withContinueKeyword = function (continueKeyword) {
            return this.update(continueKeyword, this.identifier, this.semicolonToken);
        };

        ContinueStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.continueKeyword, identifier, this.semicolonToken);
        };

        ContinueStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.continueKeyword, this.identifier, semicolonToken);
        };

        ContinueStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return ContinueStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ContinueStatementSyntax = ContinueStatementSyntax;

    var IterationStatementSyntax = (function (_super) {
        __extends(IterationStatementSyntax, _super);
        function IterationStatementSyntax(openParenToken, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        IterationStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        IterationStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        IterationStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IterationStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IterationStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return IterationStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IterationStatementSyntax = IterationStatementSyntax;

    var BaseForStatementSyntax = (function (_super) {
        __extends(BaseForStatementSyntax, _super);
        function BaseForStatementSyntax(forKeyword, openParenToken, variableDeclaration, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, openParenToken, closeParenToken, statement, parsedInStrictMode);
            this.forKeyword = forKeyword;
            this.variableDeclaration = variableDeclaration;
        }
        BaseForStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BaseForStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BaseForStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return BaseForStatementSyntax;
    })(IterationStatementSyntax);
    TypeScript.BaseForStatementSyntax = BaseForStatementSyntax;

    var ForStatementSyntax = (function (_super) {
        __extends(ForStatementSyntax, _super);
        function ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, forKeyword, openParenToken, variableDeclaration, closeParenToken, statement, parsedInStrictMode);
            this.initializer = initializer;
            this.firstSemicolonToken = firstSemicolonToken;
            this.condition = condition;
            this.secondSemicolonToken = secondSemicolonToken;
            this.incrementor = incrementor;
        }
        ForStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitForStatement(this);
        };

        ForStatementSyntax.prototype.kind = function () {
            return 153 /* ForStatement */;
        };

        ForStatementSyntax.prototype.childCount = function () {
            return 10;
        };

        ForStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.forKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.variableDeclaration;
                case 3:
                    return this.initializer;
                case 4:
                    return this.firstSemicolonToken;
                case 5:
                    return this.condition;
                case 6:
                    return this.secondSemicolonToken;
                case 7:
                    return this.incrementor;
                case 8:
                    return this.closeParenToken;
                case 9:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ForStatementSyntax.prototype.update = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
            if (this.forKeyword === forKeyword && this.openParenToken === openParenToken && this.variableDeclaration === variableDeclaration && this.initializer === initializer && this.firstSemicolonToken === firstSemicolonToken && this.condition === condition && this.secondSemicolonToken === secondSemicolonToken && this.incrementor === incrementor && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, this.parsedInStrictMode());
        };

        ForStatementSyntax.create = function (forKeyword, openParenToken, firstSemicolonToken, secondSemicolonToken, closeParenToken, statement) {
            return new ForStatementSyntax(forKeyword, openParenToken, null, null, firstSemicolonToken, null, secondSemicolonToken, null, closeParenToken, statement, false);
        };

        ForStatementSyntax.create1 = function (statement) {
            return new ForStatementSyntax(TypeScript.Syntax.token(26 /* ForKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), null, null, TypeScript.Syntax.token(79 /* SemicolonToken */), null, TypeScript.Syntax.token(79 /* SemicolonToken */), null, TypeScript.Syntax.token(74 /* CloseParenToken */), statement, false);
        };

        ForStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ForStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ForStatementSyntax.prototype.withForKeyword = function (forKeyword) {
            return this.update(forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.forKeyword, openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.forKeyword, this.openParenToken, variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withInitializer = function (initializer) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withFirstSemicolonToken = function (firstSemicolonToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withSecondSemicolonToken = function (secondSemicolonToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withIncrementor = function (incrementor) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, statement);
        };

        ForStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclaration !== null && this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            if (this.initializer !== null && this.initializer.isTypeScriptSpecific()) {
                return true;
            }
            if (this.condition !== null && this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.incrementor !== null && this.incrementor.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ForStatementSyntax;
    })(BaseForStatementSyntax);
    TypeScript.ForStatementSyntax = ForStatementSyntax;

    var ForInStatementSyntax = (function (_super) {
        __extends(ForInStatementSyntax, _super);
        function ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, forKeyword, openParenToken, variableDeclaration, closeParenToken, statement, parsedInStrictMode);
            this.left = left;
            this.inKeyword = inKeyword;
            this.expression = expression;
        }
        ForInStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitForInStatement(this);
        };

        ForInStatementSyntax.prototype.kind = function () {
            return 154 /* ForInStatement */;
        };

        ForInStatementSyntax.prototype.childCount = function () {
            return 8;
        };

        ForInStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.forKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.variableDeclaration;
                case 3:
                    return this.left;
                case 4:
                    return this.inKeyword;
                case 5:
                    return this.expression;
                case 6:
                    return this.closeParenToken;
                case 7:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ForInStatementSyntax.prototype.update = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
            if (this.forKeyword === forKeyword && this.openParenToken === openParenToken && this.variableDeclaration === variableDeclaration && this.left === left && this.inKeyword === inKeyword && this.expression === expression && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, this.parsedInStrictMode());
        };

        ForInStatementSyntax.create = function (forKeyword, openParenToken, inKeyword, expression, closeParenToken, statement) {
            return new ForInStatementSyntax(forKeyword, openParenToken, null, null, inKeyword, expression, closeParenToken, statement, false);
        };

        ForInStatementSyntax.create1 = function (expression, statement) {
            return new ForInStatementSyntax(TypeScript.Syntax.token(26 /* ForKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), null, null, TypeScript.Syntax.token(29 /* InKeyword */), expression, TypeScript.Syntax.token(74 /* CloseParenToken */), statement, false);
        };

        ForInStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ForInStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ForInStatementSyntax.prototype.withForKeyword = function (forKeyword) {
            return this.update(forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.forKeyword, openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.forKeyword, this.openParenToken, variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withLeft = function (left) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withInKeyword = function (inKeyword) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, statement);
        };

        ForInStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclaration !== null && this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            if (this.left !== null && this.left.isTypeScriptSpecific()) {
                return true;
            }
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ForInStatementSyntax;
    })(BaseForStatementSyntax);
    TypeScript.ForInStatementSyntax = ForInStatementSyntax;

    var WhileStatementSyntax = (function (_super) {
        __extends(WhileStatementSyntax, _super);
        function WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, openParenToken, closeParenToken, statement, parsedInStrictMode);
            this.whileKeyword = whileKeyword;
            this.condition = condition;
        }
        WhileStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitWhileStatement(this);
        };

        WhileStatementSyntax.prototype.kind = function () {
            return 157 /* WhileStatement */;
        };

        WhileStatementSyntax.prototype.childCount = function () {
            return 5;
        };

        WhileStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.whileKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        WhileStatementSyntax.prototype.update = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
            if (this.whileKeyword === whileKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, this.parsedInStrictMode());
        };

        WhileStatementSyntax.create1 = function (condition, statement) {
            return new WhileStatementSyntax(TypeScript.Syntax.token(42 /* WhileKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), condition, TypeScript.Syntax.token(74 /* CloseParenToken */), statement, false);
        };

        WhileStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        WhileStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        WhileStatementSyntax.prototype.withWhileKeyword = function (whileKeyword) {
            return this.update(whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.whileKeyword, openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.whileKeyword, this.openParenToken, condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.whileKeyword, this.openParenToken, this.condition, closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, statement);
        };

        WhileStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return WhileStatementSyntax;
    })(IterationStatementSyntax);
    TypeScript.WhileStatementSyntax = WhileStatementSyntax;

    var WithStatementSyntax = (function (_super) {
        __extends(WithStatementSyntax, _super);
        function WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.withKeyword = withKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        WithStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitWithStatement(this);
        };

        WithStatementSyntax.prototype.kind = function () {
            return 162 /* WithStatement */;
        };

        WithStatementSyntax.prototype.childCount = function () {
            return 5;
        };

        WithStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.withKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        WithStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        WithStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        WithStatementSyntax.prototype.update = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
            if (this.withKeyword === withKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, this.parsedInStrictMode());
        };

        WithStatementSyntax.create1 = function (condition, statement) {
            return new WithStatementSyntax(TypeScript.Syntax.token(43 /* WithKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), condition, TypeScript.Syntax.token(74 /* CloseParenToken */), statement, false);
        };

        WithStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        WithStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        WithStatementSyntax.prototype.withWithKeyword = function (withKeyword) {
            return this.update(withKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.withKeyword, openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.withKeyword, this.openParenToken, condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.withKeyword, this.openParenToken, this.condition, closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.withKeyword, this.openParenToken, this.condition, this.closeParenToken, statement);
        };

        WithStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return WithStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.WithStatementSyntax = WithStatementSyntax;

    var EnumDeclarationSyntax = (function (_super) {
        __extends(EnumDeclarationSyntax, _super);
        function EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.enumKeyword = enumKeyword;
            this.identifier = identifier;
            this.openBraceToken = openBraceToken;
            this.enumElements = enumElements;
            this.closeBraceToken = closeBraceToken;
        }
        EnumDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitEnumDeclaration(this);
        };

        EnumDeclarationSyntax.prototype.kind = function () {
            return 132 /* EnumDeclaration */;
        };

        EnumDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        EnumDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.enumKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.openBraceToken;
                case 4:
                    return this.enumElements;
                case 5:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EnumDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        EnumDeclarationSyntax.prototype.update = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.enumKeyword === enumKeyword && this.identifier === identifier && this.openBraceToken === openBraceToken && this.enumElements === enumElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, this.parsedInStrictMode());
        };

        EnumDeclarationSyntax.create = function (enumKeyword, identifier, openBraceToken, closeBraceToken) {
            return new EnumDeclarationSyntax(TypeScript.Syntax.emptyList, enumKeyword, identifier, openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        EnumDeclarationSyntax.create1 = function (identifier) {
            return new EnumDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(46 /* EnumKeyword */), identifier, TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        EnumDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EnumDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EnumDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.enumKeyword, this.identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        EnumDeclarationSyntax.prototype.withEnumKeyword = function (enumKeyword) {
            return this.update(this.modifiers, enumKeyword, this.identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.enumKeyword, identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withEnumElements = function (enumElements) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, this.openBraceToken, enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withEnumElement = function (enumElement) {
            return this.withEnumElements(TypeScript.Syntax.separatedList([enumElement]));
        };

        EnumDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, this.openBraceToken, this.enumElements, closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return EnumDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EnumDeclarationSyntax = EnumDeclarationSyntax;

    var EnumElementSyntax = (function (_super) {
        __extends(EnumElementSyntax, _super);
        function EnumElementSyntax(propertyName, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.equalsValueClause = equalsValueClause;
        }
        EnumElementSyntax.prototype.accept = function (visitor) {
            return visitor.visitEnumElement(this);
        };

        EnumElementSyntax.prototype.kind = function () {
            return 243 /* EnumElement */;
        };

        EnumElementSyntax.prototype.childCount = function () {
            return 2;
        };

        EnumElementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EnumElementSyntax.prototype.update = function (propertyName, equalsValueClause) {
            if (this.propertyName === propertyName && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new EnumElementSyntax(propertyName, equalsValueClause, this.parsedInStrictMode());
        };

        EnumElementSyntax.create = function (propertyName) {
            return new EnumElementSyntax(propertyName, null, false);
        };

        EnumElementSyntax.create1 = function (propertyName) {
            return new EnumElementSyntax(propertyName, null, false);
        };

        EnumElementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EnumElementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EnumElementSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.equalsValueClause);
        };

        EnumElementSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.propertyName, equalsValueClause);
        };

        EnumElementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.equalsValueClause !== null && this.equalsValueClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return EnumElementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EnumElementSyntax = EnumElementSyntax;

    var CastExpressionSyntax = (function (_super) {
        __extends(CastExpressionSyntax, _super);
        function CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.type = type;
            this.greaterThanToken = greaterThanToken;
            this.expression = expression;
        }
        CastExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitCastExpression(this);
        };

        CastExpressionSyntax.prototype.kind = function () {
            return 219 /* CastExpression */;
        };

        CastExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        CastExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.type;
                case 2:
                    return this.greaterThanToken;
                case 3:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CastExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        CastExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        CastExpressionSyntax.prototype.update = function (lessThanToken, type, greaterThanToken, expression) {
            if (this.lessThanToken === lessThanToken && this.type === type && this.greaterThanToken === greaterThanToken && this.expression === expression) {
                return this;
            }

            return new CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, this.parsedInStrictMode());
        };

        CastExpressionSyntax.create1 = function (type, expression) {
            return new CastExpressionSyntax(TypeScript.Syntax.token(81 /* LessThanToken */), type, TypeScript.Syntax.token(82 /* GreaterThanToken */), expression, false);
        };

        CastExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CastExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CastExpressionSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.type, this.greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withType = function (type) {
            return this.update(this.lessThanToken, type, this.greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.type, greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.lessThanToken, this.type, this.greaterThanToken, expression);
        };

        CastExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return CastExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CastExpressionSyntax = CastExpressionSyntax;

    var ObjectLiteralExpressionSyntax = (function (_super) {
        __extends(ObjectLiteralExpressionSyntax, _super);
        function ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.propertyAssignments = propertyAssignments;
            this.closeBraceToken = closeBraceToken;
        }
        ObjectLiteralExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectLiteralExpression(this);
        };

        ObjectLiteralExpressionSyntax.prototype.kind = function () {
            return 214 /* ObjectLiteralExpression */;
        };

        ObjectLiteralExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectLiteralExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.propertyAssignments;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectLiteralExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.update = function (openBraceToken, propertyAssignments, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.propertyAssignments === propertyAssignments && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, this.parsedInStrictMode());
        };

        ObjectLiteralExpressionSyntax.create = function (openBraceToken, closeBraceToken) {
            return new ObjectLiteralExpressionSyntax(openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        ObjectLiteralExpressionSyntax.create1 = function () {
            return new ObjectLiteralExpressionSyntax(TypeScript.Syntax.token(71 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(72 /* CloseBraceToken */), false);
        };

        ObjectLiteralExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectLiteralExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectLiteralExpressionSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.propertyAssignments, this.closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.withPropertyAssignments = function (propertyAssignments) {
            return this.update(this.openBraceToken, propertyAssignments, this.closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.withPropertyAssignment = function (propertyAssignment) {
            return this.withPropertyAssignments(TypeScript.Syntax.separatedList([propertyAssignment]));
        };

        ObjectLiteralExpressionSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.propertyAssignments, closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.propertyAssignments.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ObjectLiteralExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectLiteralExpressionSyntax = ObjectLiteralExpressionSyntax;

    var PropertyAssignmentSyntax = (function (_super) {
        __extends(PropertyAssignmentSyntax, _super);
        function PropertyAssignmentSyntax(propertyName, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
        }
        PropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return PropertyAssignmentSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PropertyAssignmentSyntax = PropertyAssignmentSyntax;

    var SimplePropertyAssignmentSyntax = (function (_super) {
        __extends(SimplePropertyAssignmentSyntax, _super);
        function SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, parsedInStrictMode) {
            _super.call(this, propertyName, parsedInStrictMode);
            this.colonToken = colonToken;
            this.expression = expression;
        }
        SimplePropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitSimplePropertyAssignment(this);
        };

        SimplePropertyAssignmentSyntax.prototype.kind = function () {
            return 238 /* SimplePropertyAssignment */;
        };

        SimplePropertyAssignmentSyntax.prototype.childCount = function () {
            return 3;
        };

        SimplePropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SimplePropertyAssignmentSyntax.prototype.update = function (propertyName, colonToken, expression) {
            if (this.propertyName === propertyName && this.colonToken === colonToken && this.expression === expression) {
                return this;
            }

            return new SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, this.parsedInStrictMode());
        };

        SimplePropertyAssignmentSyntax.create1 = function (propertyName, expression) {
            return new SimplePropertyAssignmentSyntax(propertyName, TypeScript.Syntax.token(107 /* ColonToken */), expression, false);
        };

        SimplePropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SimplePropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SimplePropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.colonToken, this.expression);
        };

        SimplePropertyAssignmentSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.propertyName, colonToken, this.expression);
        };

        SimplePropertyAssignmentSyntax.prototype.withExpression = function (expression) {
            return this.update(this.propertyName, this.colonToken, expression);
        };

        SimplePropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SimplePropertyAssignmentSyntax;
    })(PropertyAssignmentSyntax);
    TypeScript.SimplePropertyAssignmentSyntax = SimplePropertyAssignmentSyntax;

    var FunctionPropertyAssignmentSyntax = (function (_super) {
        __extends(FunctionPropertyAssignmentSyntax, _super);
        function FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, parsedInStrictMode) {
            _super.call(this, propertyName, parsedInStrictMode);
            this.callSignature = callSignature;
            this.block = block;
        }
        FunctionPropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionPropertyAssignment(this);
        };

        FunctionPropertyAssignmentSyntax.prototype.kind = function () {
            return 241 /* FunctionPropertyAssignment */;
        };

        FunctionPropertyAssignmentSyntax.prototype.childCount = function () {
            return 3;
        };

        FunctionPropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.callSignature;
                case 2:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionPropertyAssignmentSyntax.prototype.update = function (propertyName, callSignature, block) {
            if (this.propertyName === propertyName && this.callSignature === callSignature && this.block === block) {
                return this;
            }

            return new FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, this.parsedInStrictMode());
        };

        FunctionPropertyAssignmentSyntax.create1 = function (propertyName) {
            return new FunctionPropertyAssignmentSyntax(propertyName, CallSignatureSyntax.create1(), BlockSyntax.create1(), false);
        };

        FunctionPropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionPropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionPropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.callSignature, this.block);
        };

        FunctionPropertyAssignmentSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.propertyName, callSignature, this.block);
        };

        FunctionPropertyAssignmentSyntax.prototype.withBlock = function (block) {
            return this.update(this.propertyName, this.callSignature, block);
        };

        FunctionPropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionPropertyAssignmentSyntax;
    })(PropertyAssignmentSyntax);
    TypeScript.FunctionPropertyAssignmentSyntax = FunctionPropertyAssignmentSyntax;

    var AccessorPropertyAssignmentSyntax = (function (_super) {
        __extends(AccessorPropertyAssignmentSyntax, _super);
        function AccessorPropertyAssignmentSyntax(propertyName, openParenToken, closeParenToken, block, parsedInStrictMode) {
            _super.call(this, propertyName, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.closeParenToken = closeParenToken;
            this.block = block;
        }
        AccessorPropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        AccessorPropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        AccessorPropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return AccessorPropertyAssignmentSyntax;
    })(PropertyAssignmentSyntax);
    TypeScript.AccessorPropertyAssignmentSyntax = AccessorPropertyAssignmentSyntax;

    var GetAccessorPropertyAssignmentSyntax = (function (_super) {
        __extends(GetAccessorPropertyAssignmentSyntax, _super);
        function GetAccessorPropertyAssignmentSyntax(getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block, parsedInStrictMode) {
            _super.call(this, propertyName, openParenToken, closeParenToken, block, parsedInStrictMode);
            this.getKeyword = getKeyword;
            this.typeAnnotation = typeAnnotation;
        }
        GetAccessorPropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitGetAccessorPropertyAssignment(this);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.kind = function () {
            return 239 /* GetAccessorPropertyAssignment */;
        };

        GetAccessorPropertyAssignmentSyntax.prototype.childCount = function () {
            return 6;
        };

        GetAccessorPropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.getKeyword;
                case 1:
                    return this.propertyName;
                case 2:
                    return this.openParenToken;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.typeAnnotation;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        GetAccessorPropertyAssignmentSyntax.prototype.update = function (getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block) {
            if (this.getKeyword === getKeyword && this.propertyName === propertyName && this.openParenToken === openParenToken && this.closeParenToken === closeParenToken && this.typeAnnotation === typeAnnotation && this.block === block) {
                return this;
            }

            return new GetAccessorPropertyAssignmentSyntax(getKeyword, propertyName, openParenToken, closeParenToken, typeAnnotation, block, this.parsedInStrictMode());
        };

        GetAccessorPropertyAssignmentSyntax.create = function (getKeyword, propertyName, openParenToken, closeParenToken, block) {
            return new GetAccessorPropertyAssignmentSyntax(getKeyword, propertyName, openParenToken, closeParenToken, null, block, false);
        };

        GetAccessorPropertyAssignmentSyntax.create1 = function (propertyName) {
            return new GetAccessorPropertyAssignmentSyntax(TypeScript.Syntax.token(65 /* GetKeyword */), propertyName, TypeScript.Syntax.token(73 /* OpenParenToken */), TypeScript.Syntax.token(74 /* CloseParenToken */), null, BlockSyntax.create1(), false);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withGetKeyword = function (getKeyword) {
            return this.update(getKeyword, this.propertyName, this.openParenToken, this.closeParenToken, this.typeAnnotation, this.block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.getKeyword, propertyName, this.openParenToken, this.closeParenToken, this.typeAnnotation, this.block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.getKeyword, this.propertyName, openParenToken, this.closeParenToken, this.typeAnnotation, this.block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.getKeyword, this.propertyName, this.openParenToken, closeParenToken, this.typeAnnotation, this.block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.getKeyword, this.propertyName, this.openParenToken, this.closeParenToken, typeAnnotation, this.block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.withBlock = function (block) {
            return this.update(this.getKeyword, this.propertyName, this.openParenToken, this.closeParenToken, this.typeAnnotation, block);
        };

        GetAccessorPropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeAnnotation !== null && this.typeAnnotation.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return GetAccessorPropertyAssignmentSyntax;
    })(AccessorPropertyAssignmentSyntax);
    TypeScript.GetAccessorPropertyAssignmentSyntax = GetAccessorPropertyAssignmentSyntax;

    var SetAccessorPropertyAssignmentSyntax = (function (_super) {
        __extends(SetAccessorPropertyAssignmentSyntax, _super);
        function SetAccessorPropertyAssignmentSyntax(setKeyword, propertyName, openParenToken, parameter, closeParenToken, block, parsedInStrictMode) {
            _super.call(this, propertyName, openParenToken, closeParenToken, block, parsedInStrictMode);
            this.setKeyword = setKeyword;
            this.parameter = parameter;
        }
        SetAccessorPropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitSetAccessorPropertyAssignment(this);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.kind = function () {
            return 240 /* SetAccessorPropertyAssignment */;
        };

        SetAccessorPropertyAssignmentSyntax.prototype.childCount = function () {
            return 6;
        };

        SetAccessorPropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.setKeyword;
                case 1:
                    return this.propertyName;
                case 2:
                    return this.openParenToken;
                case 3:
                    return this.parameter;
                case 4:
                    return this.closeParenToken;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SetAccessorPropertyAssignmentSyntax.prototype.update = function (setKeyword, propertyName, openParenToken, parameter, closeParenToken, block) {
            if (this.setKeyword === setKeyword && this.propertyName === propertyName && this.openParenToken === openParenToken && this.parameter === parameter && this.closeParenToken === closeParenToken && this.block === block) {
                return this;
            }

            return new SetAccessorPropertyAssignmentSyntax(setKeyword, propertyName, openParenToken, parameter, closeParenToken, block, this.parsedInStrictMode());
        };

        SetAccessorPropertyAssignmentSyntax.create1 = function (propertyName, parameter) {
            return new SetAccessorPropertyAssignmentSyntax(TypeScript.Syntax.token(69 /* SetKeyword */), propertyName, TypeScript.Syntax.token(73 /* OpenParenToken */), parameter, TypeScript.Syntax.token(74 /* CloseParenToken */), BlockSyntax.create1(), false);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withSetKeyword = function (setKeyword) {
            return this.update(setKeyword, this.propertyName, this.openParenToken, this.parameter, this.closeParenToken, this.block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.setKeyword, propertyName, this.openParenToken, this.parameter, this.closeParenToken, this.block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.setKeyword, this.propertyName, openParenToken, this.parameter, this.closeParenToken, this.block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withParameter = function (parameter) {
            return this.update(this.setKeyword, this.propertyName, this.openParenToken, parameter, this.closeParenToken, this.block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.setKeyword, this.propertyName, this.openParenToken, this.parameter, closeParenToken, this.block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.withBlock = function (block) {
            return this.update(this.setKeyword, this.propertyName, this.openParenToken, this.parameter, this.closeParenToken, block);
        };

        SetAccessorPropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.parameter.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SetAccessorPropertyAssignmentSyntax;
    })(AccessorPropertyAssignmentSyntax);
    TypeScript.SetAccessorPropertyAssignmentSyntax = SetAccessorPropertyAssignmentSyntax;

    var FunctionExpressionSyntax = (function (_super) {
        __extends(FunctionExpressionSyntax, _super);
        function FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.functionKeyword = functionKeyword;
            this.identifier = identifier;
            this.callSignature = callSignature;
            this.block = block;
        }
        FunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionExpression(this);
        };

        FunctionExpressionSyntax.prototype.kind = function () {
            return 221 /* FunctionExpression */;
        };

        FunctionExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        FunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.functionKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.callSignature;
                case 3:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.update = function (functionKeyword, identifier, callSignature, block) {
            if (this.functionKeyword === functionKeyword && this.identifier === identifier && this.callSignature === callSignature && this.block === block) {
                return this;
            }

            return new FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, this.parsedInStrictMode());
        };

        FunctionExpressionSyntax.create = function (functionKeyword, callSignature, block) {
            return new FunctionExpressionSyntax(functionKeyword, null, callSignature, block, false);
        };

        FunctionExpressionSyntax.create1 = function () {
            return new FunctionExpressionSyntax(TypeScript.Syntax.token(27 /* FunctionKeyword */), null, CallSignatureSyntax.create1(), BlockSyntax.create1(), false);
        };

        FunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionExpressionSyntax.prototype.withFunctionKeyword = function (functionKeyword) {
            return this.update(functionKeyword, this.identifier, this.callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.functionKeyword, identifier, this.callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.functionKeyword, this.identifier, callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withBlock = function (block) {
            return this.update(this.functionKeyword, this.identifier, this.callSignature, block);
        };

        FunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionExpressionSyntax = FunctionExpressionSyntax;

    var EmptyStatementSyntax = (function (_super) {
        __extends(EmptyStatementSyntax, _super);
        function EmptyStatementSyntax(semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.semicolonToken = semicolonToken;
        }
        EmptyStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitEmptyStatement(this);
        };

        EmptyStatementSyntax.prototype.kind = function () {
            return 155 /* EmptyStatement */;
        };

        EmptyStatementSyntax.prototype.childCount = function () {
            return 1;
        };

        EmptyStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EmptyStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        EmptyStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        EmptyStatementSyntax.prototype.update = function (semicolonToken) {
            if (this.semicolonToken === semicolonToken) {
                return this;
            }

            return new EmptyStatementSyntax(semicolonToken, this.parsedInStrictMode());
        };

        EmptyStatementSyntax.create1 = function () {
            return new EmptyStatementSyntax(TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        EmptyStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EmptyStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EmptyStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(semicolonToken);
        };

        EmptyStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return EmptyStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EmptyStatementSyntax = EmptyStatementSyntax;

    var TryStatementSyntax = (function (_super) {
        __extends(TryStatementSyntax, _super);
        function TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.tryKeyword = tryKeyword;
            this.block = block;
            this.catchClause = catchClause;
            this.finallyClause = finallyClause;
        }
        TryStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitTryStatement(this);
        };

        TryStatementSyntax.prototype.kind = function () {
            return 158 /* TryStatement */;
        };

        TryStatementSyntax.prototype.childCount = function () {
            return 4;
        };

        TryStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.tryKeyword;
                case 1:
                    return this.block;
                case 2:
                    return this.catchClause;
                case 3:
                    return this.finallyClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TryStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        TryStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        TryStatementSyntax.prototype.update = function (tryKeyword, block, catchClause, finallyClause) {
            if (this.tryKeyword === tryKeyword && this.block === block && this.catchClause === catchClause && this.finallyClause === finallyClause) {
                return this;
            }

            return new TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, this.parsedInStrictMode());
        };

        TryStatementSyntax.create = function (tryKeyword, block) {
            return new TryStatementSyntax(tryKeyword, block, null, null, false);
        };

        TryStatementSyntax.create1 = function () {
            return new TryStatementSyntax(TypeScript.Syntax.token(38 /* TryKeyword */), BlockSyntax.create1(), null, null, false);
        };

        TryStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TryStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TryStatementSyntax.prototype.withTryKeyword = function (tryKeyword) {
            return this.update(tryKeyword, this.block, this.catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withBlock = function (block) {
            return this.update(this.tryKeyword, block, this.catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withCatchClause = function (catchClause) {
            return this.update(this.tryKeyword, this.block, catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withFinallyClause = function (finallyClause) {
            return this.update(this.tryKeyword, this.block, this.catchClause, finallyClause);
        };

        TryStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            if (this.catchClause !== null && this.catchClause.isTypeScriptSpecific()) {
                return true;
            }
            if (this.finallyClause !== null && this.finallyClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return TryStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TryStatementSyntax = TryStatementSyntax;

    var CatchClauseSyntax = (function (_super) {
        __extends(CatchClauseSyntax, _super);
        function CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.catchKeyword = catchKeyword;
            this.openParenToken = openParenToken;
            this.identifier = identifier;
            this.typeAnnotation = typeAnnotation;
            this.closeParenToken = closeParenToken;
            this.block = block;
        }
        CatchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitCatchClause(this);
        };

        CatchClauseSyntax.prototype.kind = function () {
            return 234 /* CatchClause */;
        };

        CatchClauseSyntax.prototype.childCount = function () {
            return 6;
        };

        CatchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.catchKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeAnnotation;
                case 4:
                    return this.closeParenToken;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CatchClauseSyntax.prototype.update = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
            if (this.catchKeyword === catchKeyword && this.openParenToken === openParenToken && this.identifier === identifier && this.typeAnnotation === typeAnnotation && this.closeParenToken === closeParenToken && this.block === block) {
                return this;
            }

            return new CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, this.parsedInStrictMode());
        };

        CatchClauseSyntax.create = function (catchKeyword, openParenToken, identifier, closeParenToken, block) {
            return new CatchClauseSyntax(catchKeyword, openParenToken, identifier, null, closeParenToken, block, false);
        };

        CatchClauseSyntax.create1 = function (identifier) {
            return new CatchClauseSyntax(TypeScript.Syntax.token(17 /* CatchKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), identifier, null, TypeScript.Syntax.token(74 /* CloseParenToken */), BlockSyntax.create1(), false);
        };

        CatchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CatchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CatchClauseSyntax.prototype.withCatchKeyword = function (catchKeyword) {
            return this.update(catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.catchKeyword, openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.catchKeyword, this.openParenToken, identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withBlock = function (block) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, block);
        };

        CatchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeAnnotation !== null && this.typeAnnotation.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return CatchClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CatchClauseSyntax = CatchClauseSyntax;

    var FinallyClauseSyntax = (function (_super) {
        __extends(FinallyClauseSyntax, _super);
        function FinallyClauseSyntax(finallyKeyword, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.finallyKeyword = finallyKeyword;
            this.block = block;
        }
        FinallyClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitFinallyClause(this);
        };

        FinallyClauseSyntax.prototype.kind = function () {
            return 235 /* FinallyClause */;
        };

        FinallyClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        FinallyClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.finallyKeyword;
                case 1:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FinallyClauseSyntax.prototype.update = function (finallyKeyword, block) {
            if (this.finallyKeyword === finallyKeyword && this.block === block) {
                return this;
            }

            return new FinallyClauseSyntax(finallyKeyword, block, this.parsedInStrictMode());
        };

        FinallyClauseSyntax.create1 = function () {
            return new FinallyClauseSyntax(TypeScript.Syntax.token(25 /* FinallyKeyword */), BlockSyntax.create1(), false);
        };

        FinallyClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FinallyClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FinallyClauseSyntax.prototype.withFinallyKeyword = function (finallyKeyword) {
            return this.update(finallyKeyword, this.block);
        };

        FinallyClauseSyntax.prototype.withBlock = function (block) {
            return this.update(this.finallyKeyword, block);
        };

        FinallyClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FinallyClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FinallyClauseSyntax = FinallyClauseSyntax;

    var LabeledStatementSyntax = (function (_super) {
        __extends(LabeledStatementSyntax, _super);
        function LabeledStatementSyntax(identifier, colonToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.colonToken = colonToken;
            this.statement = statement;
        }
        LabeledStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitLabeledStatement(this);
        };

        LabeledStatementSyntax.prototype.kind = function () {
            return 159 /* LabeledStatement */;
        };

        LabeledStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        LabeledStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        LabeledStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        LabeledStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        LabeledStatementSyntax.prototype.update = function (identifier, colonToken, statement) {
            if (this.identifier === identifier && this.colonToken === colonToken && this.statement === statement) {
                return this;
            }

            return new LabeledStatementSyntax(identifier, colonToken, statement, this.parsedInStrictMode());
        };

        LabeledStatementSyntax.create1 = function (identifier, statement) {
            return new LabeledStatementSyntax(identifier, TypeScript.Syntax.token(107 /* ColonToken */), statement, false);
        };

        LabeledStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        LabeledStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        LabeledStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.colonToken, this.statement);
        };

        LabeledStatementSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.identifier, colonToken, this.statement);
        };

        LabeledStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.identifier, this.colonToken, statement);
        };

        LabeledStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return LabeledStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.LabeledStatementSyntax = LabeledStatementSyntax;

    var DoStatementSyntax = (function (_super) {
        __extends(DoStatementSyntax, _super);
        function DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, parsedInStrictMode) {
            _super.call(this, openParenToken, closeParenToken, statement, parsedInStrictMode);
            this.doKeyword = doKeyword;
            this.whileKeyword = whileKeyword;
            this.condition = condition;
            this.semicolonToken = semicolonToken;
        }
        DoStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitDoStatement(this);
        };

        DoStatementSyntax.prototype.kind = function () {
            return 160 /* DoStatement */;
        };

        DoStatementSyntax.prototype.childCount = function () {
            return 7;
        };

        DoStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.doKeyword;
                case 1:
                    return this.statement;
                case 2:
                    return this.whileKeyword;
                case 3:
                    return this.openParenToken;
                case 4:
                    return this.condition;
                case 5:
                    return this.closeParenToken;
                case 6:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DoStatementSyntax.prototype.update = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
            if (this.doKeyword === doKeyword && this.statement === statement && this.whileKeyword === whileKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, this.parsedInStrictMode());
        };

        DoStatementSyntax.create1 = function (statement, condition) {
            return new DoStatementSyntax(TypeScript.Syntax.token(22 /* DoKeyword */), statement, TypeScript.Syntax.token(42 /* WhileKeyword */), TypeScript.Syntax.token(73 /* OpenParenToken */), condition, TypeScript.Syntax.token(74 /* CloseParenToken */), TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        DoStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DoStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DoStatementSyntax.prototype.withDoKeyword = function (doKeyword) {
            return this.update(doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.doKeyword, statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withWhileKeyword = function (whileKeyword) {
            return this.update(this.doKeyword, this.statement, whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, semicolonToken);
        };

        DoStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DoStatementSyntax;
    })(IterationStatementSyntax);
    TypeScript.DoStatementSyntax = DoStatementSyntax;

    var TypeOfExpressionSyntax = (function (_super) {
        __extends(TypeOfExpressionSyntax, _super);
        function TypeOfExpressionSyntax(typeOfKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeOfKeyword = typeOfKeyword;
            this.expression = expression;
        }
        TypeOfExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeOfExpression(this);
        };

        TypeOfExpressionSyntax.prototype.kind = function () {
            return 170 /* TypeOfExpression */;
        };

        TypeOfExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeOfExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeOfKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeOfExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        TypeOfExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        TypeOfExpressionSyntax.prototype.update = function (typeOfKeyword, expression) {
            if (this.typeOfKeyword === typeOfKeyword && this.expression === expression) {
                return this;
            }

            return new TypeOfExpressionSyntax(typeOfKeyword, expression, this.parsedInStrictMode());
        };

        TypeOfExpressionSyntax.create1 = function (expression) {
            return new TypeOfExpressionSyntax(TypeScript.Syntax.token(39 /* TypeOfKeyword */), expression, false);
        };

        TypeOfExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeOfExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeOfExpressionSyntax.prototype.withTypeOfKeyword = function (typeOfKeyword) {
            return this.update(typeOfKeyword, this.expression);
        };

        TypeOfExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.typeOfKeyword, expression);
        };

        TypeOfExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return TypeOfExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeOfExpressionSyntax = TypeOfExpressionSyntax;

    var DeleteExpressionSyntax = (function (_super) {
        __extends(DeleteExpressionSyntax, _super);
        function DeleteExpressionSyntax(deleteKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.deleteKeyword = deleteKeyword;
            this.expression = expression;
        }
        DeleteExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitDeleteExpression(this);
        };

        DeleteExpressionSyntax.prototype.kind = function () {
            return 169 /* DeleteExpression */;
        };

        DeleteExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        DeleteExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.deleteKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DeleteExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        DeleteExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        DeleteExpressionSyntax.prototype.update = function (deleteKeyword, expression) {
            if (this.deleteKeyword === deleteKeyword && this.expression === expression) {
                return this;
            }

            return new DeleteExpressionSyntax(deleteKeyword, expression, this.parsedInStrictMode());
        };

        DeleteExpressionSyntax.create1 = function (expression) {
            return new DeleteExpressionSyntax(TypeScript.Syntax.token(21 /* DeleteKeyword */), expression, false);
        };

        DeleteExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DeleteExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DeleteExpressionSyntax.prototype.withDeleteKeyword = function (deleteKeyword) {
            return this.update(deleteKeyword, this.expression);
        };

        DeleteExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.deleteKeyword, expression);
        };

        DeleteExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DeleteExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DeleteExpressionSyntax = DeleteExpressionSyntax;

    var VoidExpressionSyntax = (function (_super) {
        __extends(VoidExpressionSyntax, _super);
        function VoidExpressionSyntax(voidKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.voidKeyword = voidKeyword;
            this.expression = expression;
        }
        VoidExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitVoidExpression(this);
        };

        VoidExpressionSyntax.prototype.kind = function () {
            return 171 /* VoidExpression */;
        };

        VoidExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        VoidExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.voidKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VoidExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        VoidExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        VoidExpressionSyntax.prototype.update = function (voidKeyword, expression) {
            if (this.voidKeyword === voidKeyword && this.expression === expression) {
                return this;
            }

            return new VoidExpressionSyntax(voidKeyword, expression, this.parsedInStrictMode());
        };

        VoidExpressionSyntax.create1 = function (expression) {
            return new VoidExpressionSyntax(TypeScript.Syntax.token(41 /* VoidKeyword */), expression, false);
        };

        VoidExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VoidExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VoidExpressionSyntax.prototype.withVoidKeyword = function (voidKeyword) {
            return this.update(voidKeyword, this.expression);
        };

        VoidExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.voidKeyword, expression);
        };

        VoidExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VoidExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VoidExpressionSyntax = VoidExpressionSyntax;

    var DebuggerStatementSyntax = (function (_super) {
        __extends(DebuggerStatementSyntax, _super);
        function DebuggerStatementSyntax(debuggerKeyword, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.debuggerKeyword = debuggerKeyword;
            this.semicolonToken = semicolonToken;
        }
        DebuggerStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitDebuggerStatement(this);
        };

        DebuggerStatementSyntax.prototype.kind = function () {
            return 161 /* DebuggerStatement */;
        };

        DebuggerStatementSyntax.prototype.childCount = function () {
            return 2;
        };

        DebuggerStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.debuggerKeyword;
                case 1:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DebuggerStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        DebuggerStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        DebuggerStatementSyntax.prototype.update = function (debuggerKeyword, semicolonToken) {
            if (this.debuggerKeyword === debuggerKeyword && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new DebuggerStatementSyntax(debuggerKeyword, semicolonToken, this.parsedInStrictMode());
        };

        DebuggerStatementSyntax.create1 = function () {
            return new DebuggerStatementSyntax(TypeScript.Syntax.token(19 /* DebuggerKeyword */), TypeScript.Syntax.token(79 /* SemicolonToken */), false);
        };

        DebuggerStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DebuggerStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DebuggerStatementSyntax.prototype.withDebuggerKeyword = function (debuggerKeyword) {
            return this.update(debuggerKeyword, this.semicolonToken);
        };

        DebuggerStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.debuggerKeyword, semicolonToken);
        };

        DebuggerStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return DebuggerStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DebuggerStatementSyntax = DebuggerStatementSyntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxRewriter = (function () {
        function SyntaxRewriter() {
        }
        SyntaxRewriter.prototype.visitToken = function (token) {
            return token;
        };

        SyntaxRewriter.prototype.visitNode = function (node) {
            return node.accept(this);
        };

        SyntaxRewriter.prototype.visitNodeOrToken = function (node) {
            return node.isToken() ? this.visitToken(node) : this.visitNode(node);
        };

        SyntaxRewriter.prototype.visitList = function (list) {
            var newItems = null;

            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                var newItem = this.visitNodeOrToken(item);

                if (item !== newItem && newItems === null) {
                    newItems = [];
                    for (var j = 0; j < i; j++) {
                        newItems.push(list.childAt(j));
                    }
                }

                if (newItems) {
                    newItems.push(newItem);
                }
            }

            return newItems === null ? list : TypeScript.Syntax.list(newItems);
        };

        SyntaxRewriter.prototype.visitSeparatedList = function (list) {
            var newItems = null;

            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                var newItem = item.isToken() ? this.visitToken(item) : this.visitNode(item);

                if (item !== newItem && newItems === null) {
                    newItems = [];
                    for (var j = 0; j < i; j++) {
                        newItems.push(list.childAt(j));
                    }
                }

                if (newItems) {
                    newItems.push(newItem);
                }
            }

            return newItems === null ? list : TypeScript.Syntax.separatedList(newItems);
        };

        SyntaxRewriter.prototype.visitSourceUnit = function (node) {
            return node.update(this.visitList(node.moduleElements), this.visitToken(node.endOfFileToken));
        };

        SyntaxRewriter.prototype.visitExternalModuleReference = function (node) {
            return node.update(this.visitToken(node.moduleOrRequireKeyword), this.visitToken(node.openParenToken), this.visitToken(node.stringLiteral), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitModuleNameModuleReference = function (node) {
            return node.update(this.visitNodeOrToken(node.moduleName));
        };

        SyntaxRewriter.prototype.visitImportDeclaration = function (node) {
            return node.update(this.visitToken(node.importKeyword), this.visitToken(node.identifier), this.visitToken(node.equalsToken), this.visitNode(node.moduleReference), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitExportAssignment = function (node) {
            return node.update(this.visitToken(node.exportKeyword), this.visitToken(node.equalsToken), this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitClassDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.classKeyword), this.visitToken(node.identifier), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitList(node.heritageClauses), this.visitToken(node.openBraceToken), this.visitList(node.classElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitInterfaceDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.interfaceKeyword), this.visitToken(node.identifier), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitList(node.heritageClauses), this.visitNode(node.body));
        };

        SyntaxRewriter.prototype.visitHeritageClause = function (node) {
            return node.update(this.visitToken(node.extendsOrImplementsKeyword), this.visitSeparatedList(node.typeNames));
        };

        SyntaxRewriter.prototype.visitModuleDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.moduleKeyword), node.moduleName === null ? null : this.visitNodeOrToken(node.moduleName), node.stringLiteral === null ? null : this.visitToken(node.stringLiteral), this.visitToken(node.openBraceToken), this.visitList(node.moduleElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitFunctionDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.functionKeyword), this.visitToken(node.identifier), this.visitNode(node.callSignature), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitVariableStatement = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitNode(node.variableDeclaration), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitVariableDeclaration = function (node) {
            return node.update(this.visitToken(node.varKeyword), this.visitSeparatedList(node.variableDeclarators));
        };

        SyntaxRewriter.prototype.visitVariableDeclarator = function (node) {
            return node.update(this.visitToken(node.identifier), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitEqualsValueClause = function (node) {
            return node.update(this.visitToken(node.equalsToken), this.visitNodeOrToken(node.value));
        };

        SyntaxRewriter.prototype.visitPrefixUnaryExpression = function (node) {
            return node.update(node.kind(), this.visitToken(node.operatorToken), this.visitNodeOrToken(node.operand));
        };

        SyntaxRewriter.prototype.visitArrayLiteralExpression = function (node) {
            return node.update(this.visitToken(node.openBracketToken), this.visitSeparatedList(node.expressions), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitOmittedExpression = function (node) {
            return node;
        };

        SyntaxRewriter.prototype.visitParenthesizedExpression = function (node) {
            return node.update(this.visitToken(node.openParenToken), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitSimpleArrowFunctionExpression = function (node) {
            return node.update(this.visitToken(node.identifier), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.body));
        };

        SyntaxRewriter.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            return node.update(this.visitNode(node.callSignature), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.body));
        };

        SyntaxRewriter.prototype.visitQualifiedName = function (node) {
            return node.update(this.visitNodeOrToken(node.left), this.visitToken(node.dotToken), this.visitToken(node.right));
        };

        SyntaxRewriter.prototype.visitTypeArgumentList = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitSeparatedList(node.typeArguments), this.visitToken(node.greaterThanToken));
        };

        SyntaxRewriter.prototype.visitConstructorType = function (node) {
            return node.update(this.visitToken(node.newKeyword), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitFunctionType = function (node) {
            return node.update(node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitObjectType = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitSeparatedList(node.typeMembers), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitArrayType = function (node) {
            return node.update(this.visitNodeOrToken(node.type), this.visitToken(node.openBracketToken), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitGenericType = function (node) {
            return node.update(this.visitNodeOrToken(node.name), this.visitNode(node.typeArgumentList));
        };

        SyntaxRewriter.prototype.visitTypeAnnotation = function (node) {
            return node.update(this.visitToken(node.colonToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitBlock = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitList(node.statements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitParameter = function (node) {
            return node.update(node.dotDotDotToken === null ? null : this.visitToken(node.dotDotDotToken), node.publicOrPrivateKeyword === null ? null : this.visitToken(node.publicOrPrivateKeyword), this.visitToken(node.identifier), node.questionToken === null ? null : this.visitToken(node.questionToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitMemberAccessExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.dotToken), this.visitToken(node.name));
        };

        SyntaxRewriter.prototype.visitPostfixUnaryExpression = function (node) {
            return node.update(node.kind(), this.visitNodeOrToken(node.operand), this.visitToken(node.operatorToken));
        };

        SyntaxRewriter.prototype.visitElementAccessExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.openBracketToken), this.visitNodeOrToken(node.argumentExpression), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitInvocationExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitNode(node.argumentList));
        };

        SyntaxRewriter.prototype.visitArgumentList = function (node) {
            return node.update(node.typeArgumentList === null ? null : this.visitNode(node.typeArgumentList), this.visitToken(node.openParenToken), this.visitSeparatedList(node.arguments), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitBinaryExpression = function (node) {
            return node.update(node.kind(), this.visitNodeOrToken(node.left), this.visitToken(node.operatorToken), this.visitNodeOrToken(node.right));
        };

        SyntaxRewriter.prototype.visitConditionalExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.condition), this.visitToken(node.questionToken), this.visitNodeOrToken(node.whenTrue), this.visitToken(node.colonToken), this.visitNodeOrToken(node.whenFalse));
        };

        SyntaxRewriter.prototype.visitConstructSignature = function (node) {
            return node.update(this.visitToken(node.newKeyword), this.visitNode(node.callSignature));
        };

        SyntaxRewriter.prototype.visitMethodSignature = function (node) {
            return node.update(this.visitToken(node.propertyName), node.questionToken === null ? null : this.visitToken(node.questionToken), this.visitNode(node.callSignature));
        };

        SyntaxRewriter.prototype.visitIndexSignature = function (node) {
            return node.update(this.visitToken(node.openBracketToken), this.visitNode(node.parameter), this.visitToken(node.closeBracketToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitPropertySignature = function (node) {
            return node.update(this.visitToken(node.propertyName), node.questionToken === null ? null : this.visitToken(node.questionToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitCallSignature = function (node) {
            return node.update(node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitParameterList = function (node) {
            return node.update(this.visitToken(node.openParenToken), this.visitSeparatedList(node.parameters), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitTypeParameterList = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitSeparatedList(node.typeParameters), this.visitToken(node.greaterThanToken));
        };

        SyntaxRewriter.prototype.visitTypeParameter = function (node) {
            return node.update(this.visitToken(node.identifier), node.constraint === null ? null : this.visitNode(node.constraint));
        };

        SyntaxRewriter.prototype.visitConstraint = function (node) {
            return node.update(this.visitToken(node.extendsKeyword), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitElseClause = function (node) {
            return node.update(this.visitToken(node.elseKeyword), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitIfStatement = function (node) {
            return node.update(this.visitToken(node.ifKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement), node.elseClause === null ? null : this.visitNode(node.elseClause));
        };

        SyntaxRewriter.prototype.visitExpressionStatement = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitConstructorDeclaration = function (node) {
            return node.update(this.visitToken(node.constructorKeyword), this.visitNode(node.parameterList), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitMemberFunctionDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.propertyName), this.visitNode(node.callSignature), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitGetMemberAccessorDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.getKeyword), this.visitToken(node.propertyName), this.visitNode(node.parameterList), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitSetMemberAccessorDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.setKeyword), this.visitToken(node.propertyName), this.visitNode(node.parameterList), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitMemberVariableDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitNode(node.variableDeclarator), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitThrowStatement = function (node) {
            return node.update(this.visitToken(node.throwKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitReturnStatement = function (node) {
            return node.update(this.visitToken(node.returnKeyword), node.expression === null ? null : this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitObjectCreationExpression = function (node) {
            return node.update(this.visitToken(node.newKeyword), this.visitNodeOrToken(node.expression), node.argumentList === null ? null : this.visitNode(node.argumentList));
        };

        SyntaxRewriter.prototype.visitSwitchStatement = function (node) {
            return node.update(this.visitToken(node.switchKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken), this.visitToken(node.openBraceToken), this.visitList(node.switchClauses), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitCaseSwitchClause = function (node) {
            return node.update(this.visitToken(node.caseKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.colonToken), this.visitList(node.statements));
        };

        SyntaxRewriter.prototype.visitDefaultSwitchClause = function (node) {
            return node.update(this.visitToken(node.defaultKeyword), this.visitToken(node.colonToken), this.visitList(node.statements));
        };

        SyntaxRewriter.prototype.visitBreakStatement = function (node) {
            return node.update(this.visitToken(node.breakKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitContinueStatement = function (node) {
            return node.update(this.visitToken(node.continueKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitForStatement = function (node) {
            return node.update(this.visitToken(node.forKeyword), this.visitToken(node.openParenToken), node.variableDeclaration === null ? null : this.visitNode(node.variableDeclaration), node.initializer === null ? null : this.visitNodeOrToken(node.initializer), this.visitToken(node.firstSemicolonToken), node.condition === null ? null : this.visitNodeOrToken(node.condition), this.visitToken(node.secondSemicolonToken), node.incrementor === null ? null : this.visitNodeOrToken(node.incrementor), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitForInStatement = function (node) {
            return node.update(this.visitToken(node.forKeyword), this.visitToken(node.openParenToken), node.variableDeclaration === null ? null : this.visitNode(node.variableDeclaration), node.left === null ? null : this.visitNodeOrToken(node.left), this.visitToken(node.inKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitWhileStatement = function (node) {
            return node.update(this.visitToken(node.whileKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitWithStatement = function (node) {
            return node.update(this.visitToken(node.withKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitEnumDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.enumKeyword), this.visitToken(node.identifier), this.visitToken(node.openBraceToken), this.visitSeparatedList(node.enumElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitEnumElement = function (node) {
            return node.update(this.visitToken(node.propertyName), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitCastExpression = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitNodeOrToken(node.type), this.visitToken(node.greaterThanToken), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitObjectLiteralExpression = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitSeparatedList(node.propertyAssignments), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitSimplePropertyAssignment = function (node) {
            return node.update(this.visitToken(node.propertyName), this.visitToken(node.colonToken), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitFunctionPropertyAssignment = function (node) {
            return node.update(this.visitToken(node.propertyName), this.visitNode(node.callSignature), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitGetAccessorPropertyAssignment = function (node) {
            return node.update(this.visitToken(node.getKeyword), this.visitToken(node.propertyName), this.visitToken(node.openParenToken), this.visitToken(node.closeParenToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitSetAccessorPropertyAssignment = function (node) {
            return node.update(this.visitToken(node.setKeyword), this.visitToken(node.propertyName), this.visitToken(node.openParenToken), this.visitNode(node.parameter), this.visitToken(node.closeParenToken), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitFunctionExpression = function (node) {
            return node.update(this.visitToken(node.functionKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitNode(node.callSignature), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitEmptyStatement = function (node) {
            return node.update(this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitTryStatement = function (node) {
            return node.update(this.visitToken(node.tryKeyword), this.visitNode(node.block), node.catchClause === null ? null : this.visitNode(node.catchClause), node.finallyClause === null ? null : this.visitNode(node.finallyClause));
        };

        SyntaxRewriter.prototype.visitCatchClause = function (node) {
            return node.update(this.visitToken(node.catchKeyword), this.visitToken(node.openParenToken), this.visitToken(node.identifier), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), this.visitToken(node.closeParenToken), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitFinallyClause = function (node) {
            return node.update(this.visitToken(node.finallyKeyword), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitLabeledStatement = function (node) {
            return node.update(this.visitToken(node.identifier), this.visitToken(node.colonToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitDoStatement = function (node) {
            return node.update(this.visitToken(node.doKeyword), this.visitNodeOrToken(node.statement), this.visitToken(node.whileKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitTypeOfExpression = function (node) {
            return node.update(this.visitToken(node.typeOfKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitDeleteExpression = function (node) {
            return node.update(this.visitToken(node.deleteKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitVoidExpression = function (node) {
            return node.update(this.visitToken(node.voidKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitDebuggerStatement = function (node) {
            return node.update(this.visitToken(node.debuggerKeyword), this.visitToken(node.semicolonToken));
        };
        return SyntaxRewriter;
    })();
    TypeScript.SyntaxRewriter = SyntaxRewriter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxDedenter = (function (_super) {
        __extends(SyntaxDedenter, _super);
        function SyntaxDedenter(dedentFirstToken, dedentationAmount, minimumIndent, options) {
            _super.call(this);
            this.dedentationAmount = dedentationAmount;
            this.minimumIndent = minimumIndent;
            this.options = options;
            this.lastTriviaWasNewLine = dedentFirstToken;
        }
        SyntaxDedenter.prototype.abort = function () {
            this.lastTriviaWasNewLine = false;
            this.dedentationAmount = 0;
        };

        SyntaxDedenter.prototype.isAborted = function () {
            return this.dedentationAmount === 0;
        };

        SyntaxDedenter.prototype.visitToken = function (token) {
            if (token.width() === 0) {
                return token;
            }

            var result = token;
            if (this.lastTriviaWasNewLine) {
                result = token.withLeadingTrivia(this.dedentTriviaList(token.leadingTrivia()));
            }

            if (this.isAborted()) {
                return token;
            }

            this.lastTriviaWasNewLine = token.hasTrailingNewLine();
            return result;
        };

        SyntaxDedenter.prototype.dedentTriviaList = function (triviaList) {
            var result = [];
            var dedentNextWhitespace = true;

            for (var i = 0, n = triviaList.count(); i < n && !this.isAborted(); i++) {
                var trivia = triviaList.syntaxTriviaAt(i);

                var dedentThisTrivia = dedentNextWhitespace;
                dedentNextWhitespace = false;

                if (dedentThisTrivia) {
                    if (trivia.kind() === 4 /* WhitespaceTrivia */) {
                        var hasFollowingNewLine = (i < triviaList.count() - 1) && triviaList.syntaxTriviaAt(i + 1).kind() === 5 /* NewLineTrivia */;
                        result.push(this.dedentWhitespace(trivia, hasFollowingNewLine));
                        continue;
                    } else if (trivia.kind() !== 5 /* NewLineTrivia */) {
                        this.abort();
                        break;
                    }
                }

                if (trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                    result.push(this.dedentMultiLineComment(trivia));
                    continue;
                }

                result.push(trivia);
                if (trivia.kind() === 5 /* NewLineTrivia */) {
                    dedentNextWhitespace = true;
                }
            }

            if (dedentNextWhitespace) {
                this.abort();
            }

            if (this.isAborted()) {
                return triviaList;
            }

            return TypeScript.Syntax.triviaList(result);
        };

        SyntaxDedenter.prototype.dedentSegment = function (segment, hasFollowingNewLineTrivia) {
            var firstNonWhitespacePosition = TypeScript.Indentation.firstNonWhitespacePosition(segment);

            if (firstNonWhitespacePosition === segment.length) {
                if (hasFollowingNewLineTrivia) {
                    return "";
                }
            } else if (TypeScript.CharacterInfo.isLineTerminator(segment.charCodeAt(firstNonWhitespacePosition))) {
                return segment.substring(firstNonWhitespacePosition);
            }

            var firstNonWhitespaceColumn = TypeScript.Indentation.columnForPositionInString(segment, firstNonWhitespacePosition, this.options);

            var newFirstNonWhitespaceColumn = TypeScript.MathPrototype.min(firstNonWhitespaceColumn, TypeScript.MathPrototype.max(firstNonWhitespaceColumn - this.dedentationAmount, this.minimumIndent));

            if (newFirstNonWhitespaceColumn === firstNonWhitespaceColumn) {
                this.abort();
                return segment;
            }

            this.dedentationAmount = firstNonWhitespaceColumn - newFirstNonWhitespaceColumn;
            TypeScript.Debug.assert(this.dedentationAmount >= 0);

            var indentationString = TypeScript.Indentation.indentationString(newFirstNonWhitespaceColumn, this.options);

            return indentationString + segment.substring(firstNonWhitespacePosition);
        };

        SyntaxDedenter.prototype.dedentWhitespace = function (trivia, hasFollowingNewLineTrivia) {
            var newIndentation = this.dedentSegment(trivia.fullText(), hasFollowingNewLineTrivia);
            return TypeScript.Syntax.whitespace(newIndentation);
        };

        SyntaxDedenter.prototype.dedentMultiLineComment = function (trivia) {
            var segments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);
            if (segments.length === 1) {
                return trivia;
            }

            for (var i = 1; i < segments.length; i++) {
                var segment = segments[i];
                segments[i] = this.dedentSegment(segment, false);
            }

            var result = segments.join("");

            return TypeScript.Syntax.multiLineComment(result);
        };

        SyntaxDedenter.dedentNode = function (node, dedentFirstToken, dedentAmount, minimumIndent, options) {
            var dedenter = new SyntaxDedenter(dedentFirstToken, dedentAmount, minimumIndent, options);
            var result = node.accept(dedenter);

            if (dedenter.isAborted()) {
                return node;
            }

            return result;
        };
        return SyntaxDedenter;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxDedenter = SyntaxDedenter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxIndenter = (function (_super) {
        __extends(SyntaxIndenter, _super);
        function SyntaxIndenter(indentFirstToken, indentationAmount, options) {
            _super.call(this);
            this.indentationAmount = indentationAmount;
            this.options = options;
            this.lastTriviaWasNewLine = indentFirstToken;
            this.indentationTrivia = TypeScript.Indentation.indentationTrivia(this.indentationAmount, this.options);
        }
        SyntaxIndenter.prototype.visitToken = function (token) {
            if (token.width() === 0) {
                return token;
            }

            var result = token;
            if (this.lastTriviaWasNewLine) {
                result = token.withLeadingTrivia(this.indentTriviaList(token.leadingTrivia()));
            }

            this.lastTriviaWasNewLine = token.hasTrailingNewLine();
            return result;
        };

        SyntaxIndenter.prototype.indentTriviaList = function (triviaList) {
            var result = [];

            var indentNextTrivia = true;
            for (var i = 0, n = triviaList.count(); i < n; i++) {
                var trivia = triviaList.syntaxTriviaAt(i);

                var indentThisTrivia = indentNextTrivia;
                indentNextTrivia = false;

                switch (trivia.kind()) {
                    case 6 /* MultiLineCommentTrivia */:
                        this.indentMultiLineComment(trivia, indentThisTrivia, result);
                        continue;

                    case 7 /* SingleLineCommentTrivia */:
                    case 8 /* SkippedTokenTrivia */:
                        this.indentSingleLineOrSkippedText(trivia, indentThisTrivia, result);
                        continue;

                    case 4 /* WhitespaceTrivia */:
                        this.indentWhitespace(trivia, indentThisTrivia, result);
                        continue;

                    case 5 /* NewLineTrivia */:
                        result.push(trivia);
                        indentNextTrivia = true;
                        continue;

                    default:
                        throw TypeScript.Errors.invalidOperation();
                }
            }

            if (indentNextTrivia) {
                result.push(this.indentationTrivia);
            }

            return TypeScript.Syntax.triviaList(result);
        };

        SyntaxIndenter.prototype.indentSegment = function (segment) {
            var firstNonWhitespacePosition = TypeScript.Indentation.firstNonWhitespacePosition(segment);

            if (firstNonWhitespacePosition < segment.length && TypeScript.CharacterInfo.isLineTerminator(segment.charCodeAt(firstNonWhitespacePosition))) {
                return segment;
            }

            var firstNonWhitespaceColumn = TypeScript.Indentation.columnForPositionInString(segment, firstNonWhitespacePosition, this.options);

            var newFirstNonWhitespaceColumn = firstNonWhitespaceColumn + this.indentationAmount;

            var indentationString = TypeScript.Indentation.indentationString(newFirstNonWhitespaceColumn, this.options);

            return indentationString + segment.substring(firstNonWhitespacePosition);
        };

        SyntaxIndenter.prototype.indentWhitespace = function (trivia, indentThisTrivia, result) {
            if (!indentThisTrivia) {
                result.push(trivia);
                return;
            }

            var newIndentation = this.indentSegment(trivia.fullText());
            result.push(TypeScript.Syntax.whitespace(newIndentation));
        };

        SyntaxIndenter.prototype.indentSingleLineOrSkippedText = function (trivia, indentThisTrivia, result) {
            if (indentThisTrivia) {
                result.push(this.indentationTrivia);
            }

            result.push(trivia);
        };

        SyntaxIndenter.prototype.indentMultiLineComment = function (trivia, indentThisTrivia, result) {
            if (indentThisTrivia) {
                result.push(this.indentationTrivia);
            }

            var segments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);

            for (var i = 1; i < segments.length; i++) {
                segments[i] = this.indentSegment(segments[i]);
            }

            var newText = segments.join("");
            result.push(TypeScript.Syntax.multiLineComment(newText));
        };

        SyntaxIndenter.indentNode = function (node, indentFirstToken, indentAmount, options) {
            var indenter = new SyntaxIndenter(indentFirstToken, indentAmount, options);
            return node.accept(indenter);
        };

        SyntaxIndenter.indentNodes = function (nodes, indentFirstToken, indentAmount, options) {
            var indenter = new SyntaxIndenter(indentFirstToken, indentAmount, options);
            var result = TypeScript.ArrayUtilities.select(nodes, function (n) {
                return n.accept(indenter);
            });

            return result;
        };
        return SyntaxIndenter;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxIndenter = SyntaxIndenter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var VariableWidthTokenWithNoTrivia = (function () {
            function VariableWidthTokenWithNoTrivia(sourceText, fullStart, kind, textOrWidth) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._textOrWidth = textOrWidth;
            }
            VariableWidthTokenWithNoTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithNoTrivia(this._sourceText, this._fullStart, this.tokenKind, this._textOrWidth);
            };

            VariableWidthTokenWithNoTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithNoTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithNoTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithNoTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithNoTrivia.prototype.fullWidth = function () {
                return this.width();
            };
            VariableWidthTokenWithNoTrivia.prototype.start = function () {
                return this._fullStart;
            };
            VariableWidthTokenWithNoTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            VariableWidthTokenWithNoTrivia.prototype.width = function () {
                return typeof this._textOrWidth === 'number' ? this._textOrWidth : this._textOrWidth.length;
            };

            VariableWidthTokenWithNoTrivia.prototype.text = function () {
                if (typeof this._textOrWidth === 'number') {
                    this._textOrWidth = this._sourceText.substr(this.start(), this._textOrWidth, this.tokenKind === 11 /* IdentifierName */);
                }

                return this._textOrWidth;
            };

            VariableWidthTokenWithNoTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            VariableWidthTokenWithNoTrivia.prototype.value = function () {
                if ((this)._value === undefined) {
                    (this)._value = Syntax.value(this);
                }

                return (this)._value;
            };

            VariableWidthTokenWithNoTrivia.prototype.valueText = function () {
                if ((this)._valueText === undefined) {
                    (this)._valueText = Syntax.valueText(this);
                }

                return (this)._valueText;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithNoTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithNoTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithNoTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithNoTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithNoTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithNoTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return VariableWidthTokenWithNoTrivia;
        })();
        Syntax.VariableWidthTokenWithNoTrivia = VariableWidthTokenWithNoTrivia;

        var VariableWidthTokenWithLeadingTrivia = (function () {
            function VariableWidthTokenWithLeadingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, textOrWidth) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
                this._textOrWidth = textOrWidth;
            }
            VariableWidthTokenWithLeadingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithLeadingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._leadingTriviaInfo, this._textOrWidth);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithLeadingTrivia.prototype.fullWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo) + this.width();
            };
            VariableWidthTokenWithLeadingTrivia.prototype.start = function () {
                return this._fullStart + getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            VariableWidthTokenWithLeadingTrivia.prototype.width = function () {
                return typeof this._textOrWidth === 'number' ? this._textOrWidth : this._textOrWidth.length;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.text = function () {
                if (typeof this._textOrWidth === 'number') {
                    this._textOrWidth = this._sourceText.substr(this.start(), this._textOrWidth, this.tokenKind === 11 /* IdentifierName */);
                }

                return this._textOrWidth;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.value = function () {
                if ((this)._value === undefined) {
                    (this)._value = Syntax.value(this);
                }

                return (this)._value;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.valueText = function () {
                if ((this)._valueText === undefined) {
                    (this)._valueText = Syntax.valueText(this);
                }

                return (this)._valueText;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this._fullStart, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return VariableWidthTokenWithLeadingTrivia;
        })();
        Syntax.VariableWidthTokenWithLeadingTrivia = VariableWidthTokenWithLeadingTrivia;

        var VariableWidthTokenWithTrailingTrivia = (function () {
            function VariableWidthTokenWithTrailingTrivia(sourceText, fullStart, kind, textOrWidth, trailingTriviaInfo) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._textOrWidth = textOrWidth;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            VariableWidthTokenWithTrailingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithTrailingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._textOrWidth, this._trailingTriviaInfo);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithTrailingTrivia.prototype.fullWidth = function () {
                return this.width() + getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.start = function () {
                return this._fullStart;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            VariableWidthTokenWithTrailingTrivia.prototype.width = function () {
                return typeof this._textOrWidth === 'number' ? this._textOrWidth : this._textOrWidth.length;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.text = function () {
                if (typeof this._textOrWidth === 'number') {
                    this._textOrWidth = this._sourceText.substr(this.start(), this._textOrWidth, this.tokenKind === 11 /* IdentifierName */);
                }

                return this._textOrWidth;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.value = function () {
                if ((this)._value === undefined) {
                    (this)._value = Syntax.value(this);
                }

                return (this)._value;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.valueText = function () {
                if ((this)._valueText === undefined) {
                    (this)._valueText = Syntax.valueText(this);
                }

                return (this)._valueText;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this.end(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return VariableWidthTokenWithTrailingTrivia;
        })();
        Syntax.VariableWidthTokenWithTrailingTrivia = VariableWidthTokenWithTrailingTrivia;

        var VariableWidthTokenWithLeadingAndTrailingTrivia = (function () {
            function VariableWidthTokenWithLeadingAndTrailingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, textOrWidth, trailingTriviaInfo) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
                this._textOrWidth = textOrWidth;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithLeadingAndTrailingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._leadingTriviaInfo, this._textOrWidth, this._trailingTriviaInfo);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.fullWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo) + this.width() + getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.start = function () {
                return this._fullStart + getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.width = function () {
                return typeof this._textOrWidth === 'number' ? this._textOrWidth : this._textOrWidth.length;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.text = function () {
                if (typeof this._textOrWidth === 'number') {
                    this._textOrWidth = this._sourceText.substr(this.start(), this._textOrWidth, this.tokenKind === 11 /* IdentifierName */);
                }

                return this._textOrWidth;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.value = function () {
                if ((this)._value === undefined) {
                    (this)._value = Syntax.value(this);
                }

                return (this)._value;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.valueText = function () {
                if ((this)._valueText === undefined) {
                    (this)._valueText = Syntax.valueText(this);
                }

                return (this)._valueText;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this._fullStart, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this.end(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return VariableWidthTokenWithLeadingAndTrailingTrivia;
        })();
        Syntax.VariableWidthTokenWithLeadingAndTrailingTrivia = VariableWidthTokenWithLeadingAndTrailingTrivia;

        var FixedWidthTokenWithNoTrivia = (function () {
            function FixedWidthTokenWithNoTrivia(kind) {
                this.tokenKind = kind;
            }
            FixedWidthTokenWithNoTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithNoTrivia(this.tokenKind);
            };

            FixedWidthTokenWithNoTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithNoTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithNoTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithNoTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithNoTrivia.prototype.fullWidth = function () {
                return this.width();
            };
            FixedWidthTokenWithNoTrivia.prototype.width = function () {
                return this.text().length;
            };
            FixedWidthTokenWithNoTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithNoTrivia.prototype.fullText = function () {
                return this.text();
            };

            FixedWidthTokenWithNoTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithNoTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithNoTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithNoTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithNoTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithNoTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithNoTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithNoTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithNoTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return FixedWidthTokenWithNoTrivia;
        })();
        Syntax.FixedWidthTokenWithNoTrivia = FixedWidthTokenWithNoTrivia;

        var FixedWidthTokenWithLeadingTrivia = (function () {
            function FixedWidthTokenWithLeadingTrivia(sourceText, fullStart, kind, leadingTriviaInfo) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
            }
            FixedWidthTokenWithLeadingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithLeadingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._leadingTriviaInfo);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithLeadingTrivia.prototype.fullWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo) + this.width();
            };
            FixedWidthTokenWithLeadingTrivia.prototype.start = function () {
                return this._fullStart + getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            FixedWidthTokenWithLeadingTrivia.prototype.width = function () {
                return this.text().length;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this._fullStart, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return FixedWidthTokenWithLeadingTrivia;
        })();
        Syntax.FixedWidthTokenWithLeadingTrivia = FixedWidthTokenWithLeadingTrivia;

        var FixedWidthTokenWithTrailingTrivia = (function () {
            function FixedWidthTokenWithTrailingTrivia(sourceText, fullStart, kind, trailingTriviaInfo) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            FixedWidthTokenWithTrailingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithTrailingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._trailingTriviaInfo);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithTrailingTrivia.prototype.fullWidth = function () {
                return this.width() + getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.start = function () {
                return this._fullStart;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            FixedWidthTokenWithTrailingTrivia.prototype.width = function () {
                return this.text().length;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this.end(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return FixedWidthTokenWithTrailingTrivia;
        })();
        Syntax.FixedWidthTokenWithTrailingTrivia = FixedWidthTokenWithTrailingTrivia;

        var FixedWidthTokenWithLeadingAndTrailingTrivia = (function () {
            function FixedWidthTokenWithLeadingAndTrailingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, trailingTriviaInfo) {
                this._sourceText = sourceText;
                this._fullStart = fullStart;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithLeadingAndTrailingTrivia(this._sourceText, this._fullStart, this.tokenKind, this._leadingTriviaInfo, this._trailingTriviaInfo);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.fullWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo) + this.width() + getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.start = function () {
                return this._fullStart + getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.end = function () {
                return this.start() + this.width();
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.width = function () {
                return this.text().length;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.fullText = function () {
                return this._sourceText.substr(this._fullStart, this.fullWidth(), false);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this._fullStart, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(this._sourceText, this.end(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return FixedWidthTokenWithLeadingAndTrailingTrivia;
        })();
        Syntax.FixedWidthTokenWithLeadingAndTrailingTrivia = FixedWidthTokenWithLeadingAndTrailingTrivia;

        function collectTokenTextElements(token, elements) {
            token.leadingTrivia().collectTextElements(elements);
            elements.push(token.text());
            token.trailingTrivia().collectTextElements(elements);
        }

        function fixedWidthToken(sourceText, fullStart, kind, leadingTriviaInfo, trailingTriviaInfo) {
            if (leadingTriviaInfo === 0) {
                if (trailingTriviaInfo === 0) {
                    return new FixedWidthTokenWithNoTrivia(kind);
                } else {
                    return new FixedWidthTokenWithTrailingTrivia(sourceText, fullStart, kind, trailingTriviaInfo);
                }
            } else if (trailingTriviaInfo === 0) {
                return new FixedWidthTokenWithLeadingTrivia(sourceText, fullStart, kind, leadingTriviaInfo);
            } else {
                return new FixedWidthTokenWithLeadingAndTrailingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, trailingTriviaInfo);
            }
        }
        Syntax.fixedWidthToken = fixedWidthToken;

        function variableWidthToken(sourceText, fullStart, kind, leadingTriviaInfo, width, trailingTriviaInfo) {
            if (leadingTriviaInfo === 0) {
                if (trailingTriviaInfo === 0) {
                    return new VariableWidthTokenWithNoTrivia(sourceText, fullStart, kind, width);
                } else {
                    return new VariableWidthTokenWithTrailingTrivia(sourceText, fullStart, kind, width, trailingTriviaInfo);
                }
            } else if (trailingTriviaInfo === 0) {
                return new VariableWidthTokenWithLeadingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, width);
            } else {
                return new VariableWidthTokenWithLeadingAndTrailingTrivia(sourceText, fullStart, kind, leadingTriviaInfo, width, trailingTriviaInfo);
            }
        }
        Syntax.variableWidthToken = variableWidthToken;

        function getTriviaWidth(value) {
            return value >>> 2 /* TriviaFullWidthShift */;
        }

        function hasTriviaComment(value) {
            return (value & 2 /* TriviaCommentMask */) !== 0;
        }

        function hasTriviaNewLine(value) {
            return (value & 1 /* TriviaNewLineMask */) !== 0;
        }
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        function realizeToken(token) {
            return new RealizedToken(token.tokenKind, token.leadingTrivia(), token.text(), token.value(), token.valueText(), token.trailingTrivia());
        }
        Syntax.realizeToken = realizeToken;

        function convertToIdentifierName(token) {
            TypeScript.Debug.assert(TypeScript.SyntaxFacts.isAnyKeyword(token.tokenKind));
            return new RealizedToken(11 /* IdentifierName */, token.leadingTrivia(), token.text(), token.text(), token.text(), token.trailingTrivia());
        }
        Syntax.convertToIdentifierName = convertToIdentifierName;

        function tokenToJSON(token) {
            var result = {};

            for (var name in TypeScript.SyntaxKind) {
                if (TypeScript.SyntaxKind[name] === token.kind()) {
                    result.kind = name;
                    break;
                }
            }

            result.width = token.width();
            if (token.fullWidth() !== token.width()) {
                result.fullWidth = token.fullWidth();
            }

            result.text = token.text();

            var value = token.value();
            if (value !== null) {
                result.value = value;
                result.valueText = token.valueText();
            }

            if (token.hasLeadingTrivia()) {
                result.hasLeadingTrivia = true;
            }

            if (token.hasLeadingComment()) {
                result.hasLeadingComment = true;
            }

            if (token.hasLeadingNewLine()) {
                result.hasLeadingNewLine = true;
            }

            if (token.hasLeadingSkippedText()) {
                result.hasLeadingSkippedText = true;
            }

            if (token.hasTrailingTrivia()) {
                result.hasTrailingTrivia = true;
            }

            if (token.hasTrailingComment()) {
                result.hasTrailingComment = true;
            }

            if (token.hasTrailingNewLine()) {
                result.hasTrailingNewLine = true;
            }

            if (token.hasTrailingSkippedText()) {
                result.hasTrailingSkippedText = true;
            }

            var trivia = token.leadingTrivia();
            if (trivia.count() > 0) {
                result.leadingTrivia = trivia;
            }

            trivia = token.trailingTrivia();
            if (trivia.count() > 0) {
                result.trailingTrivia = trivia;
            }

            return result;
        }
        Syntax.tokenToJSON = tokenToJSON;

        function value(token) {
            return value1(token.tokenKind, token.text());
        }
        Syntax.value = value;

        function hexValue(text, start, length) {
            var intChar = 0;
            for (var i = 0; i < length; i++) {
                var ch2 = text.charCodeAt(start + i);
                if (!TypeScript.CharacterInfo.isHexDigit(ch2)) {
                    break;
                }

                intChar = (intChar << 4) + TypeScript.CharacterInfo.hexValue(ch2);
            }

            return intChar;
        }

        var characterArray = [];

        function convertEscapes(text) {
            characterArray.length = 0;
            var result = "";

            for (var i = 0, n = text.length; i < n; i++) {
                var ch = text.charCodeAt(i);

                if (ch === 92 /* backslash */) {
                    i++;
                    if (i < n) {
                        ch = text.charCodeAt(i);
                        switch (ch) {
                            case 48 /* _0 */:
                                characterArray.push(0 /* nullCharacter */);
                                continue;

                            case 98 /* b */:
                                characterArray.push(8 /* backspace */);
                                continue;

                            case 102 /* f */:
                                characterArray.push(12 /* formFeed */);
                                continue;

                            case 110 /* n */:
                                characterArray.push(10 /* lineFeed */);
                                continue;

                            case 114 /* r */:
                                characterArray.push(13 /* carriageReturn */);
                                continue;

                            case 116 /* t */:
                                characterArray.push(9 /* tab */);
                                continue;

                            case 118 /* v */:
                                characterArray.push(11 /* verticalTab */);
                                continue;

                            case 120 /* x */:
                                characterArray.push(hexValue(text, i + 1, 2));
                                i += 2;
                                continue;

                            case 117 /* u */:
                                characterArray.push(hexValue(text, i + 1, 4));
                                i += 4;
                                continue;

                            default:
                        }
                    }
                }

                characterArray.push(ch);

                if (i && !(i % 1024)) {
                    result = result.concat(String.fromCharCode.apply(null, characterArray));
                    characterArray.length = 0;
                }
            }

            if (characterArray.length) {
                result = result.concat(String.fromCharCode.apply(null, characterArray));
            }

            return result;
        }

        function massageEscapes(text) {
            return text.indexOf("\\") >= 0 ? convertEscapes(text) : text;
        }

        function value1(kind, text) {
            if (kind === 11 /* IdentifierName */) {
                return massageEscapes(text);
            }

            switch (kind) {
                case 37 /* TrueKeyword */:
                    return true;
                case 24 /* FalseKeyword */:
                    return false;
                case 32 /* NullKeyword */:
                    return null;
            }

            if (TypeScript.SyntaxFacts.isAnyKeyword(kind) || TypeScript.SyntaxFacts.isAnyPunctuation(kind)) {
                return TypeScript.SyntaxFacts.getText(kind);
            }

            if (kind === 13 /* NumericLiteral */) {
                return parseFloat(text);
            } else if (kind === 14 /* StringLiteral */) {
                if (text.length > 1 && text.charCodeAt(text.length - 1) === text.charCodeAt(0)) {
                    return massageEscapes(text.substr(1, text.length - 2));
                } else {
                    return massageEscapes(text.substr(1));
                }
            } else if (kind === 12 /* RegularExpressionLiteral */) {
                try  {
                    var lastSlash = text.lastIndexOf("/");
                    var body = text.substring(1, lastSlash);
                    var flags = text.substring(lastSlash + 1);
                    return new RegExp(body, flags);
                } catch (e) {
                    return null;
                }
            } else if (kind === 10 /* EndOfFileToken */ || kind === 9 /* ErrorToken */) {
                return null;
            } else {
                throw TypeScript.Errors.invalidOperation();
            }
        }

        function valueText1(kind, text) {
            var value = value1(kind, text);
            return value === null ? "" : value.toString();
        }

        function valueText(token) {
            var value = token.value();
            return value === null ? "" : value.toString();
        }
        Syntax.valueText = valueText;

        var EmptyToken = (function () {
            function EmptyToken(kind) {
                this.tokenKind = kind;
            }
            EmptyToken.prototype.clone = function () {
                return new EmptyToken(this.tokenKind);
            };

            EmptyToken.prototype.kind = function () {
                return this.tokenKind;
            };

            EmptyToken.prototype.isToken = function () {
                return true;
            };
            EmptyToken.prototype.isNode = function () {
                return false;
            };
            EmptyToken.prototype.isList = function () {
                return false;
            };
            EmptyToken.prototype.isSeparatedList = function () {
                return false;
            };

            EmptyToken.prototype.childCount = function () {
                return 0;
            };

            EmptyToken.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptyToken.prototype.toJSON = function (key) {
                return tokenToJSON(this);
            };
            EmptyToken.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };

            EmptyToken.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            EmptyToken.prototype.firstToken = function () {
                return this;
            };
            EmptyToken.prototype.lastToken = function () {
                return this;
            };
            EmptyToken.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptyToken.prototype.isIncrementallyUnusable = function () {
                return true;
            };

            EmptyToken.prototype.fullWidth = function () {
                return 0;
            };
            EmptyToken.prototype.width = function () {
                return 0;
            };
            EmptyToken.prototype.text = function () {
                return "";
            };
            EmptyToken.prototype.fullText = function () {
                return "";
            };
            EmptyToken.prototype.value = function () {
                return null;
            };
            EmptyToken.prototype.valueText = function () {
                return "";
            };

            EmptyToken.prototype.hasLeadingTrivia = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingComment = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingNewLine = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            EmptyToken.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            EmptyToken.prototype.hasTrailingTrivia = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingComment = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingNewLine = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            EmptyToken.prototype.hasSkippedToken = function () {
                return false;
            };

            EmptyToken.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            EmptyToken.prototype.leadingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };
            EmptyToken.prototype.trailingTrivia = function () {
                return TypeScript.Syntax.emptyTriviaList;
            };
            EmptyToken.prototype.realize = function () {
                return realizeToken(this);
            };
            EmptyToken.prototype.collectTextElements = function (elements) {
            };

            EmptyToken.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            EmptyToken.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };
            return EmptyToken;
        })();

        function emptyToken(kind) {
            return new EmptyToken(kind);
        }
        Syntax.emptyToken = emptyToken;

        var RealizedToken = (function () {
            function RealizedToken(tokenKind, leadingTrivia, text, value, valueText, trailingTrivia) {
                this.tokenKind = tokenKind;
                this._leadingTrivia = leadingTrivia;
                this._text = text;
                this._value = value;
                this._valueText = valueText;
                this._trailingTrivia = trailingTrivia;
            }
            RealizedToken.prototype.clone = function () {
                return new RealizedToken(this.tokenKind, this._leadingTrivia, this._text, this._value, this._valueText, this._trailingTrivia);
            };

            RealizedToken.prototype.kind = function () {
                return this.tokenKind;
            };
            RealizedToken.prototype.toJSON = function (key) {
                return tokenToJSON(this);
            };
            RealizedToken.prototype.firstToken = function () {
                return this;
            };
            RealizedToken.prototype.lastToken = function () {
                return this;
            };
            RealizedToken.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            RealizedToken.prototype.isIncrementallyUnusable = function () {
                return true;
            };

            RealizedToken.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };

            RealizedToken.prototype.childCount = function () {
                return 0;
            };

            RealizedToken.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            RealizedToken.prototype.isToken = function () {
                return true;
            };
            RealizedToken.prototype.isNode = function () {
                return false;
            };
            RealizedToken.prototype.isList = function () {
                return false;
            };
            RealizedToken.prototype.isSeparatedList = function () {
                return false;
            };
            RealizedToken.prototype.isTrivia = function () {
                return false;
            };
            RealizedToken.prototype.isTriviaList = function () {
                return false;
            };

            RealizedToken.prototype.fullWidth = function () {
                return this._leadingTrivia.fullWidth() + this.width() + this._trailingTrivia.fullWidth();
            };
            RealizedToken.prototype.width = function () {
                return this.text().length;
            };

            RealizedToken.prototype.text = function () {
                return this._text;
            };
            RealizedToken.prototype.fullText = function () {
                return this._leadingTrivia.fullText() + this.text() + this._trailingTrivia.fullText();
            };

            RealizedToken.prototype.value = function () {
                return this._value;
            };
            RealizedToken.prototype.valueText = function () {
                return this._valueText;
            };

            RealizedToken.prototype.hasLeadingTrivia = function () {
                return this._leadingTrivia.count() > 0;
            };
            RealizedToken.prototype.hasLeadingComment = function () {
                return this._leadingTrivia.hasComment();
            };
            RealizedToken.prototype.hasLeadingNewLine = function () {
                return this._leadingTrivia.hasNewLine();
            };
            RealizedToken.prototype.hasLeadingSkippedText = function () {
                return this._leadingTrivia.hasSkippedToken();
            };
            RealizedToken.prototype.leadingTriviaWidth = function () {
                return this._leadingTrivia.fullWidth();
            };

            RealizedToken.prototype.hasTrailingTrivia = function () {
                return this._trailingTrivia.count() > 0;
            };
            RealizedToken.prototype.hasTrailingComment = function () {
                return this._trailingTrivia.hasComment();
            };
            RealizedToken.prototype.hasTrailingNewLine = function () {
                return this._trailingTrivia.hasNewLine();
            };
            RealizedToken.prototype.hasTrailingSkippedText = function () {
                return this._trailingTrivia.hasSkippedToken();
            };
            RealizedToken.prototype.trailingTriviaWidth = function () {
                return this._trailingTrivia.fullWidth();
            };

            RealizedToken.prototype.hasSkippedToken = function () {
                return this.hasLeadingSkippedText() || this.hasTrailingSkippedText();
            };

            RealizedToken.prototype.leadingTrivia = function () {
                return this._leadingTrivia;
            };
            RealizedToken.prototype.trailingTrivia = function () {
                return this._trailingTrivia;
            };

            RealizedToken.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            RealizedToken.prototype.collectTextElements = function (elements) {
                this.leadingTrivia().collectTextElements(elements);
                elements.push(this.text());
                this.trailingTrivia().collectTextElements(elements);
            };

            RealizedToken.prototype.withLeadingTrivia = function (leadingTrivia) {
                return new RealizedToken(this.tokenKind, leadingTrivia, this._text, this._value, this._valueText, this._trailingTrivia);
            };

            RealizedToken.prototype.withTrailingTrivia = function (trailingTrivia) {
                return new RealizedToken(this.tokenKind, this._leadingTrivia, this._text, this._value, this._valueText, trailingTrivia);
            };
            return RealizedToken;
        })();

        function token(kind, info) {
            if (typeof info === "undefined") { info = null; }
            var text = (info !== null && info.text !== undefined) ? info.text : TypeScript.SyntaxFacts.getText(kind);

            return new RealizedToken(kind, TypeScript.Syntax.triviaList(info === null ? null : info.leadingTrivia), text, value1(kind, text), valueText1(kind, text), TypeScript.Syntax.triviaList(info === null ? null : info.trailingTrivia));
        }
        Syntax.token = token;

        function identifier(text, info) {
            if (typeof info === "undefined") { info = null; }
            info = info || {};
            info.text = text;
            return token(11 /* IdentifierName */, info);
        }
        Syntax.identifier = identifier;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxTokenReplacer = (function (_super) {
        __extends(SyntaxTokenReplacer, _super);
        function SyntaxTokenReplacer(token1, token2) {
            _super.call(this);
            this.token1 = token1;
            this.token2 = token2;
        }
        SyntaxTokenReplacer.prototype.visitToken = function (token) {
            if (token === this.token1) {
                var result = this.token2;
                this.token1 = null;
                this.token2 = null;

                return result;
            }

            return token;
        };

        SyntaxTokenReplacer.prototype.visitNode = function (node) {
            if (this.token1 === null) {
                return node;
            }

            return _super.prototype.visitNode.call(this, node);
        };

        SyntaxTokenReplacer.prototype.visitList = function (list) {
            if (this.token1 === null) {
                return list;
            }

            return _super.prototype.visitList.call(this, list);
        };

        SyntaxTokenReplacer.prototype.visitSeparatedList = function (list) {
            if (this.token1 === null) {
                return list;
            }

            return _super.prototype.visitSeparatedList.call(this, list);
        };
        return SyntaxTokenReplacer;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxTokenReplacer = SyntaxTokenReplacer;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var SyntaxTrivia = (function () {
            function SyntaxTrivia(kind, textOrToken) {
                this._kind = kind;
                this._textOrToken = textOrToken;
            }
            SyntaxTrivia.prototype.toJSON = function (key) {
                var result = {};
                result.kind = TypeScript.SyntaxKind[this._kind];

                if (this.isSkippedToken()) {
                    result.skippedToken = this._textOrToken;
                } else {
                    result.text = this._textOrToken;
                }
                return result;
            };

            SyntaxTrivia.prototype.kind = function () {
                return this._kind;
            };

            SyntaxTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };

            SyntaxTrivia.prototype.fullText = function () {
                return this.isSkippedToken() ? this.skippedToken().fullText() : this._textOrToken;
            };

            SyntaxTrivia.prototype.isWhitespace = function () {
                return this.kind() === 4 /* WhitespaceTrivia */;
            };

            SyntaxTrivia.prototype.isComment = function () {
                return this.kind() === 7 /* SingleLineCommentTrivia */ || this.kind() === 6 /* MultiLineCommentTrivia */;
            };

            SyntaxTrivia.prototype.isNewLine = function () {
                return this.kind() === 5 /* NewLineTrivia */;
            };

            SyntaxTrivia.prototype.isSkippedToken = function () {
                return this.kind() === 8 /* SkippedTokenTrivia */;
            };

            SyntaxTrivia.prototype.skippedToken = function () {
                TypeScript.Debug.assert(this.isSkippedToken());
                return this._textOrToken;
            };

            SyntaxTrivia.prototype.collectTextElements = function (elements) {
                elements.push(this.fullText());
            };
            return SyntaxTrivia;
        })();

        function trivia(kind, text) {
            return new SyntaxTrivia(kind, text);
        }
        Syntax.trivia = trivia;

        function skippedTokenTrivia(token) {
            TypeScript.Debug.assert(!token.hasLeadingTrivia());
            TypeScript.Debug.assert(!token.hasTrailingTrivia());
            TypeScript.Debug.assert(token.fullWidth() > 0);
            return new SyntaxTrivia(8 /* SkippedTokenTrivia */, token);
        }
        Syntax.skippedTokenTrivia = skippedTokenTrivia;

        function spaces(count) {
            return trivia(4 /* WhitespaceTrivia */, TypeScript.StringUtilities.repeat(" ", count));
        }
        Syntax.spaces = spaces;

        function whitespace(text) {
            return trivia(4 /* WhitespaceTrivia */, text);
        }
        Syntax.whitespace = whitespace;

        function multiLineComment(text) {
            return trivia(6 /* MultiLineCommentTrivia */, text);
        }
        Syntax.multiLineComment = multiLineComment;

        function singleLineComment(text) {
            return trivia(7 /* SingleLineCommentTrivia */, text);
        }
        Syntax.singleLineComment = singleLineComment;

        Syntax.spaceTrivia = spaces(1);
        Syntax.lineFeedTrivia = trivia(5 /* NewLineTrivia */, "\n");
        Syntax.carriageReturnTrivia = trivia(5 /* NewLineTrivia */, "\r");
        Syntax.carriageReturnLineFeedTrivia = trivia(5 /* NewLineTrivia */, "\r\n");

        function splitMultiLineCommentTriviaIntoMultipleLines(trivia) {
            var result = [];

            var triviaText = trivia.fullText();
            var currentIndex = 0;

            for (var i = 0; i < triviaText.length; i++) {
                var ch = triviaText.charCodeAt(i);

                var isCarriageReturnLineFeed = false;
                switch (ch) {
                    case 13 /* carriageReturn */:
                        if (i < triviaText.length - 1 && triviaText.charCodeAt(i + 1) === 10 /* lineFeed */) {
                            i++;
                        }

                    case 10 /* lineFeed */:
                    case 8233 /* paragraphSeparator */:
                    case 8232 /* lineSeparator */:
                        result.push(triviaText.substring(currentIndex, i + 1));

                        currentIndex = i + 1;
                        continue;
                }
            }

            result.push(triviaText.substring(currentIndex));
            return result;
        }
        Syntax.splitMultiLineCommentTriviaIntoMultipleLines = splitMultiLineCommentTriviaIntoMultipleLines;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        Syntax.emptyTriviaList = {
            kind: function () {
                return 3 /* TriviaList */;
            },
            count: function () {
                return 0;
            },
            syntaxTriviaAt: function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            },
            last: function () {
                throw TypeScript.Errors.argumentOutOfRange("index");
            },
            fullWidth: function () {
                return 0;
            },
            fullText: function () {
                return "";
            },
            hasComment: function () {
                return false;
            },
            hasNewLine: function () {
                return false;
            },
            hasSkippedToken: function () {
                return false;
            },
            toJSON: function (key) {
                return [];
            },
            collectTextElements: function (elements) {
            },
            toArray: function () {
                return [];
            },
            concat: function (trivia) {
                return trivia;
            }
        };

        function concatTrivia(list1, list2) {
            if (list1.count() === 0) {
                return list2;
            }

            if (list2.count() === 0) {
                return list1;
            }

            var trivia = list1.toArray();
            trivia.push.apply(trivia, list2.toArray());

            return triviaList(trivia);
        }

        function isComment(trivia) {
            return trivia.kind() === 6 /* MultiLineCommentTrivia */ || trivia.kind() === 7 /* SingleLineCommentTrivia */;
        }

        var SingletonSyntaxTriviaList = (function () {
            function SingletonSyntaxTriviaList(item) {
                this.item = item;
            }
            SingletonSyntaxTriviaList.prototype.kind = function () {
                return 3 /* TriviaList */;
            };

            SingletonSyntaxTriviaList.prototype.count = function () {
                return 1;
            };

            SingletonSyntaxTriviaList.prototype.syntaxTriviaAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSyntaxTriviaList.prototype.last = function () {
                return this.item;
            };

            SingletonSyntaxTriviaList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSyntaxTriviaList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSyntaxTriviaList.prototype.hasComment = function () {
                return isComment(this.item);
            };

            SingletonSyntaxTriviaList.prototype.hasNewLine = function () {
                return this.item.kind() === 5 /* NewLineTrivia */;
            };

            SingletonSyntaxTriviaList.prototype.hasSkippedToken = function () {
                return this.item.kind() === 8 /* SkippedTokenTrivia */;
            };

            SingletonSyntaxTriviaList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSyntaxTriviaList.prototype.collectTextElements = function (elements) {
                (this.item).collectTextElements(elements);
            };

            SingletonSyntaxTriviaList.prototype.toArray = function () {
                return [this.item];
            };

            SingletonSyntaxTriviaList.prototype.concat = function (trivia) {
                return concatTrivia(this, trivia);
            };
            return SingletonSyntaxTriviaList;
        })();

        var NormalSyntaxTriviaList = (function () {
            function NormalSyntaxTriviaList(trivia) {
                this.trivia = trivia;
            }
            NormalSyntaxTriviaList.prototype.kind = function () {
                return 3 /* TriviaList */;
            };

            NormalSyntaxTriviaList.prototype.count = function () {
                return this.trivia.length;
            };

            NormalSyntaxTriviaList.prototype.syntaxTriviaAt = function (index) {
                if (index < 0 || index >= this.trivia.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.trivia[index];
            };

            NormalSyntaxTriviaList.prototype.last = function () {
                return this.trivia[this.trivia.length - 1];
            };

            NormalSyntaxTriviaList.prototype.fullWidth = function () {
                return TypeScript.ArrayUtilities.sum(this.trivia, function (t) {
                    return t.fullWidth();
                });
            };

            NormalSyntaxTriviaList.prototype.fullText = function () {
                var result = "";

                for (var i = 0, n = this.trivia.length; i < n; i++) {
                    result += this.trivia[i].fullText();
                }

                return result;
            };

            NormalSyntaxTriviaList.prototype.hasComment = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (isComment(this.trivia[i])) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.hasNewLine = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (this.trivia[i].kind() === 5 /* NewLineTrivia */) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.hasSkippedToken = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (this.trivia[i].kind() === 8 /* SkippedTokenTrivia */) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.toJSON = function (key) {
                return this.trivia;
            };

            NormalSyntaxTriviaList.prototype.collectTextElements = function (elements) {
                for (var i = 0; i < this.trivia.length; i++) {
                    (this.trivia[i]).collectTextElements(elements);
                }
            };

            NormalSyntaxTriviaList.prototype.toArray = function () {
                return this.trivia.slice(0);
            };

            NormalSyntaxTriviaList.prototype.concat = function (trivia) {
                return concatTrivia(this, trivia);
            };
            return NormalSyntaxTriviaList;
        })();

        function triviaList(trivia) {
            if (trivia === undefined || trivia === null || trivia.length === 0) {
                return TypeScript.Syntax.emptyTriviaList;
            }

            if (trivia.length === 1) {
                return new SingletonSyntaxTriviaList(trivia[0]);
            }

            return new NormalSyntaxTriviaList(trivia);
        }
        Syntax.triviaList = triviaList;

        Syntax.spaceTriviaList = triviaList([TypeScript.Syntax.spaceTrivia]);
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxUtilities = (function () {
        function SyntaxUtilities() {
        }
        SyntaxUtilities.isAngleBracket = function (positionedElement) {
            var element = positionedElement.element();
            var parent = positionedElement.parentElement();
            if (parent !== null && (element.kind() === 81 /* LessThanToken */ || element.kind() === 82 /* GreaterThanToken */)) {
                switch (parent.kind()) {
                    case 227 /* TypeArgumentList */:
                    case 228 /* TypeParameterList */:
                    case 219 /* CastExpression */:
                        return true;
                }
            }

            return false;
        };

        SyntaxUtilities.getToken = function (list, kind) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                var token = list.childAt(i);
                if (token.tokenKind === kind) {
                    return token;
                }
            }

            return null;
        };

        SyntaxUtilities.containsToken = function (list, kind) {
            return SyntaxUtilities.getToken(list, kind) !== null;
        };

        SyntaxUtilities.hasExportKeyword = function (moduleElement) {
            switch (moduleElement.kind()) {
                case 130 /* ModuleDeclaration */:
                case 131 /* ClassDeclaration */:
                case 129 /* FunctionDeclaration */:
                case 147 /* VariableStatement */:
                case 132 /* EnumDeclaration */:
                case 128 /* InterfaceDeclaration */:
                    return SyntaxUtilities.containsToken((moduleElement).modifiers, 47 /* ExportKeyword */);
            }

            return false;
        };

        SyntaxUtilities.isAmbientDeclarationSyntax = function (positionNode) {
            if (!positionNode) {
                return false;
            }

            var node = positionNode.node();
            switch (node.kind()) {
                case 130 /* ModuleDeclaration */:
                case 131 /* ClassDeclaration */:
                case 129 /* FunctionDeclaration */:
                case 147 /* VariableStatement */:
                case 132 /* EnumDeclaration */:
                    if (SyntaxUtilities.containsToken((node).modifiers, 64 /* DeclareKeyword */)) {
                        return true;
                    }

                case 133 /* ImportDeclaration */:
                case 137 /* ConstructorDeclaration */:
                case 135 /* MemberFunctionDeclaration */:
                case 138 /* GetMemberAccessorDeclaration */:
                case 139 /* SetMemberAccessorDeclaration */:
                case 136 /* MemberVariableDeclaration */:
                    if (node.isClassElement() || node.isModuleElement()) {
                        return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode());
                    }

                case 243 /* EnumElement */:
                    return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode().containingNode());

                default:
                    return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode());
            }
        };
        return SyntaxUtilities;
    })();
    TypeScript.SyntaxUtilities = SyntaxUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxVisitor = (function () {
        function SyntaxVisitor() {
        }
        SyntaxVisitor.prototype.defaultVisit = function (node) {
            return null;
        };

        SyntaxVisitor.prototype.visitToken = function (token) {
            return this.defaultVisit(token);
        };

        SyntaxVisitor.prototype.visitSourceUnit = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExternalModuleReference = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitModuleNameModuleReference = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitImportDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExportAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitClassDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitInterfaceDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitHeritageClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitModuleDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableDeclarator = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEqualsValueClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPrefixUnaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArrayLiteralExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitOmittedExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParenthesizedExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSimpleArrowFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitQualifiedName = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeArgumentList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructorType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArrayType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitGenericType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeAnnotation = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBlock = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParameter = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberAccessExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPostfixUnaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitElementAccessExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitInvocationExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArgumentList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBinaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConditionalExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMethodSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitIndexSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPropertySignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCallSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParameterList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeParameterList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeParameter = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstraint = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitElseClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitIfStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExpressionStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructorDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberFunctionDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitGetMemberAccessorDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSetMemberAccessorDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberVariableDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitThrowStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitReturnStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectCreationExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSwitchStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCaseSwitchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDefaultSwitchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBreakStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitContinueStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitForStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitForInStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitWhileStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitWithStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEnumDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEnumElement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCastExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectLiteralExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSimplePropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionPropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitGetAccessorPropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSetAccessorPropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEmptyStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTryStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCatchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFinallyClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitLabeledStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDoStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeOfExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDeleteExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVoidExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDebuggerStatement = function (node) {
            return this.defaultVisit(node);
        };
        return SyntaxVisitor;
    })();
    TypeScript.SyntaxVisitor = SyntaxVisitor;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxWalker = (function () {
        function SyntaxWalker() {
        }
        SyntaxWalker.prototype.visitToken = function (token) {
        };

        SyntaxWalker.prototype.visitNode = function (node) {
            node.accept(this);
        };

        SyntaxWalker.prototype.visitNodeOrToken = function (nodeOrToken) {
            if (nodeOrToken.isToken()) {
                this.visitToken(nodeOrToken);
            } else {
                this.visitNode(nodeOrToken);
            }
        };

        SyntaxWalker.prototype.visitOptionalToken = function (token) {
            if (token === null) {
                return;
            }

            this.visitToken(token);
        };

        SyntaxWalker.prototype.visitOptionalNode = function (node) {
            if (node === null) {
                return;
            }

            this.visitNode(node);
        };

        SyntaxWalker.prototype.visitOptionalNodeOrToken = function (nodeOrToken) {
            if (nodeOrToken === null) {
                return;
            }

            this.visitNodeOrToken(nodeOrToken);
        };

        SyntaxWalker.prototype.visitList = function (list) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                this.visitNodeOrToken(list.childAt(i));
            }
        };

        SyntaxWalker.prototype.visitSeparatedList = function (list) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                this.visitNodeOrToken(item);
            }
        };

        SyntaxWalker.prototype.visitSourceUnit = function (node) {
            this.visitList(node.moduleElements);
            this.visitToken(node.endOfFileToken);
        };

        SyntaxWalker.prototype.visitExternalModuleReference = function (node) {
            this.visitToken(node.moduleOrRequireKeyword);
            this.visitToken(node.openParenToken);
            this.visitToken(node.stringLiteral);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitModuleNameModuleReference = function (node) {
            this.visitNodeOrToken(node.moduleName);
        };

        SyntaxWalker.prototype.visitImportDeclaration = function (node) {
            this.visitToken(node.importKeyword);
            this.visitToken(node.identifier);
            this.visitToken(node.equalsToken);
            this.visitNode(node.moduleReference);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitExportAssignment = function (node) {
            this.visitToken(node.exportKeyword);
            this.visitToken(node.equalsToken);
            this.visitToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitClassDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.classKeyword);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeParameterList);
            this.visitList(node.heritageClauses);
            this.visitToken(node.openBraceToken);
            this.visitList(node.classElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitInterfaceDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.interfaceKeyword);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeParameterList);
            this.visitList(node.heritageClauses);
            this.visitNode(node.body);
        };

        SyntaxWalker.prototype.visitHeritageClause = function (node) {
            this.visitToken(node.extendsOrImplementsKeyword);
            this.visitSeparatedList(node.typeNames);
        };

        SyntaxWalker.prototype.visitModuleDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.moduleKeyword);
            this.visitOptionalNodeOrToken(node.moduleName);
            this.visitOptionalToken(node.stringLiteral);
            this.visitToken(node.openBraceToken);
            this.visitList(node.moduleElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitFunctionDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.functionKeyword);
            this.visitToken(node.identifier);
            this.visitNode(node.callSignature);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitVariableStatement = function (node) {
            this.visitList(node.modifiers);
            this.visitNode(node.variableDeclaration);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitVariableDeclaration = function (node) {
            this.visitToken(node.varKeyword);
            this.visitSeparatedList(node.variableDeclarators);
        };

        SyntaxWalker.prototype.visitVariableDeclarator = function (node) {
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitEqualsValueClause = function (node) {
            this.visitToken(node.equalsToken);
            this.visitNodeOrToken(node.value);
        };

        SyntaxWalker.prototype.visitPrefixUnaryExpression = function (node) {
            this.visitToken(node.operatorToken);
            this.visitNodeOrToken(node.operand);
        };

        SyntaxWalker.prototype.visitArrayLiteralExpression = function (node) {
            this.visitToken(node.openBracketToken);
            this.visitSeparatedList(node.expressions);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitOmittedExpression = function (node) {
        };

        SyntaxWalker.prototype.visitParenthesizedExpression = function (node) {
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitSimpleArrowFunctionExpression = function (node) {
            this.visitToken(node.identifier);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.body);
        };

        SyntaxWalker.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            this.visitNode(node.callSignature);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.body);
        };

        SyntaxWalker.prototype.visitQualifiedName = function (node) {
            this.visitNodeOrToken(node.left);
            this.visitToken(node.dotToken);
            this.visitToken(node.right);
        };

        SyntaxWalker.prototype.visitTypeArgumentList = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitSeparatedList(node.typeArguments);
            this.visitToken(node.greaterThanToken);
        };

        SyntaxWalker.prototype.visitConstructorType = function (node) {
            this.visitToken(node.newKeyword);
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitFunctionType = function (node) {
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitObjectType = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.typeMembers);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitArrayType = function (node) {
            this.visitNodeOrToken(node.type);
            this.visitToken(node.openBracketToken);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitGenericType = function (node) {
            this.visitNodeOrToken(node.name);
            this.visitNode(node.typeArgumentList);
        };

        SyntaxWalker.prototype.visitTypeAnnotation = function (node) {
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitBlock = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitList(node.statements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitParameter = function (node) {
            this.visitOptionalToken(node.dotDotDotToken);
            this.visitOptionalToken(node.publicOrPrivateKeyword);
            this.visitToken(node.identifier);
            this.visitOptionalToken(node.questionToken);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitMemberAccessExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.dotToken);
            this.visitToken(node.name);
        };

        SyntaxWalker.prototype.visitPostfixUnaryExpression = function (node) {
            this.visitNodeOrToken(node.operand);
            this.visitToken(node.operatorToken);
        };

        SyntaxWalker.prototype.visitElementAccessExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.openBracketToken);
            this.visitNodeOrToken(node.argumentExpression);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitInvocationExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitNode(node.argumentList);
        };

        SyntaxWalker.prototype.visitArgumentList = function (node) {
            this.visitOptionalNode(node.typeArgumentList);
            this.visitToken(node.openParenToken);
            this.visitSeparatedList(node.arguments);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitBinaryExpression = function (node) {
            this.visitNodeOrToken(node.left);
            this.visitToken(node.operatorToken);
            this.visitNodeOrToken(node.right);
        };

        SyntaxWalker.prototype.visitConditionalExpression = function (node) {
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.questionToken);
            this.visitNodeOrToken(node.whenTrue);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.whenFalse);
        };

        SyntaxWalker.prototype.visitConstructSignature = function (node) {
            this.visitToken(node.newKeyword);
            this.visitNode(node.callSignature);
        };

        SyntaxWalker.prototype.visitMethodSignature = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalToken(node.questionToken);
            this.visitNode(node.callSignature);
        };

        SyntaxWalker.prototype.visitIndexSignature = function (node) {
            this.visitToken(node.openBracketToken);
            this.visitNode(node.parameter);
            this.visitToken(node.closeBracketToken);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitPropertySignature = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalToken(node.questionToken);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitCallSignature = function (node) {
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitParameterList = function (node) {
            this.visitToken(node.openParenToken);
            this.visitSeparatedList(node.parameters);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitTypeParameterList = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitSeparatedList(node.typeParameters);
            this.visitToken(node.greaterThanToken);
        };

        SyntaxWalker.prototype.visitTypeParameter = function (node) {
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.constraint);
        };

        SyntaxWalker.prototype.visitConstraint = function (node) {
            this.visitToken(node.extendsKeyword);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitElseClause = function (node) {
            this.visitToken(node.elseKeyword);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitIfStatement = function (node) {
            this.visitToken(node.ifKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
            this.visitOptionalNode(node.elseClause);
        };

        SyntaxWalker.prototype.visitExpressionStatement = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitConstructorDeclaration = function (node) {
            this.visitToken(node.constructorKeyword);
            this.visitNode(node.parameterList);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitMemberFunctionDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.propertyName);
            this.visitNode(node.callSignature);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitGetMemberAccessorDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.getKeyword);
            this.visitToken(node.propertyName);
            this.visitNode(node.parameterList);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitSetMemberAccessorDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.setKeyword);
            this.visitToken(node.propertyName);
            this.visitNode(node.parameterList);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitMemberVariableDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitNode(node.variableDeclarator);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitThrowStatement = function (node) {
            this.visitToken(node.throwKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitReturnStatement = function (node) {
            this.visitToken(node.returnKeyword);
            this.visitOptionalNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitObjectCreationExpression = function (node) {
            this.visitToken(node.newKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitOptionalNode(node.argumentList);
        };

        SyntaxWalker.prototype.visitSwitchStatement = function (node) {
            this.visitToken(node.switchKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
            this.visitToken(node.openBraceToken);
            this.visitList(node.switchClauses);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitCaseSwitchClause = function (node) {
            this.visitToken(node.caseKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.colonToken);
            this.visitList(node.statements);
        };

        SyntaxWalker.prototype.visitDefaultSwitchClause = function (node) {
            this.visitToken(node.defaultKeyword);
            this.visitToken(node.colonToken);
            this.visitList(node.statements);
        };

        SyntaxWalker.prototype.visitBreakStatement = function (node) {
            this.visitToken(node.breakKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitContinueStatement = function (node) {
            this.visitToken(node.continueKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitForStatement = function (node) {
            this.visitToken(node.forKeyword);
            this.visitToken(node.openParenToken);
            this.visitOptionalNode(node.variableDeclaration);
            this.visitOptionalNodeOrToken(node.initializer);
            this.visitToken(node.firstSemicolonToken);
            this.visitOptionalNodeOrToken(node.condition);
            this.visitToken(node.secondSemicolonToken);
            this.visitOptionalNodeOrToken(node.incrementor);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitForInStatement = function (node) {
            this.visitToken(node.forKeyword);
            this.visitToken(node.openParenToken);
            this.visitOptionalNode(node.variableDeclaration);
            this.visitOptionalNodeOrToken(node.left);
            this.visitToken(node.inKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitWhileStatement = function (node) {
            this.visitToken(node.whileKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitWithStatement = function (node) {
            this.visitToken(node.withKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitEnumDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.enumKeyword);
            this.visitToken(node.identifier);
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.enumElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitEnumElement = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitCastExpression = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitNodeOrToken(node.type);
            this.visitToken(node.greaterThanToken);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitObjectLiteralExpression = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.propertyAssignments);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitSimplePropertyAssignment = function (node) {
            this.visitToken(node.propertyName);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitFunctionPropertyAssignment = function (node) {
            this.visitToken(node.propertyName);
            this.visitNode(node.callSignature);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitGetAccessorPropertyAssignment = function (node) {
            this.visitToken(node.getKeyword);
            this.visitToken(node.propertyName);
            this.visitToken(node.openParenToken);
            this.visitToken(node.closeParenToken);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitSetAccessorPropertyAssignment = function (node) {
            this.visitToken(node.setKeyword);
            this.visitToken(node.propertyName);
            this.visitToken(node.openParenToken);
            this.visitNode(node.parameter);
            this.visitToken(node.closeParenToken);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitFunctionExpression = function (node) {
            this.visitToken(node.functionKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitNode(node.callSignature);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitEmptyStatement = function (node) {
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitTryStatement = function (node) {
            this.visitToken(node.tryKeyword);
            this.visitNode(node.block);
            this.visitOptionalNode(node.catchClause);
            this.visitOptionalNode(node.finallyClause);
        };

        SyntaxWalker.prototype.visitCatchClause = function (node) {
            this.visitToken(node.catchKeyword);
            this.visitToken(node.openParenToken);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitToken(node.closeParenToken);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitFinallyClause = function (node) {
            this.visitToken(node.finallyKeyword);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitLabeledStatement = function (node) {
            this.visitToken(node.identifier);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitDoStatement = function (node) {
            this.visitToken(node.doKeyword);
            this.visitNodeOrToken(node.statement);
            this.visitToken(node.whileKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitTypeOfExpression = function (node) {
            this.visitToken(node.typeOfKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitDeleteExpression = function (node) {
            this.visitToken(node.deleteKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitVoidExpression = function (node) {
            this.visitToken(node.voidKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitDebuggerStatement = function (node) {
            this.visitToken(node.debuggerKeyword);
            this.visitToken(node.semicolonToken);
        };
        return SyntaxWalker;
    })();
    TypeScript.SyntaxWalker = SyntaxWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var PositionTrackingWalker = (function (_super) {
        __extends(PositionTrackingWalker, _super);
        function PositionTrackingWalker() {
            _super.apply(this, arguments);
            this._position = 0;
        }
        PositionTrackingWalker.prototype.visitToken = function (token) {
            this._position += token.fullWidth();
        };

        PositionTrackingWalker.prototype.position = function () {
            return this._position;
        };

        PositionTrackingWalker.prototype.skip = function (element) {
            this._position += element.fullWidth();
        };
        return PositionTrackingWalker;
    })(TypeScript.SyntaxWalker);
    TypeScript.PositionTrackingWalker = PositionTrackingWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxInformationMap = (function (_super) {
        __extends(SyntaxInformationMap, _super);
        function SyntaxInformationMap(trackParents, trackPreviousToken) {
            _super.call(this);
            this.trackParents = trackParents;
            this.trackPreviousToken = trackPreviousToken;
            this.tokenToInformation = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this.elementToPosition = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this._previousToken = null;
            this._previousTokenInformation = null;
            this._currentPosition = 0;
            this._elementToParent = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this._parentStack = [];
            this._parentStack.push(null);
        }
        SyntaxInformationMap.create = function (node, trackParents, trackPreviousToken) {
            var map = new SyntaxInformationMap(trackParents, trackPreviousToken);
            map.visitNode(node);
            return map;
        };

        SyntaxInformationMap.prototype.visitNode = function (node) {
            this.trackParents && this._elementToParent.add(node, TypeScript.ArrayUtilities.last(this._parentStack));
            this.elementToPosition.add(node, this._currentPosition);

            this.trackParents && this._parentStack.push(node);
            _super.prototype.visitNode.call(this, node);
            this.trackParents && this._parentStack.pop();
        };

        SyntaxInformationMap.prototype.visitToken = function (token) {
            this.trackParents && this._elementToParent.add(token, TypeScript.ArrayUtilities.last(this._parentStack));

            if (this.trackPreviousToken) {
                var tokenInformation = {
                    previousToken: this._previousToken,
                    nextToken: null
                };

                if (this._previousTokenInformation !== null) {
                    this._previousTokenInformation.nextToken = token;
                }

                this._previousToken = token;
                this._previousTokenInformation = tokenInformation;

                this.tokenToInformation.add(token, tokenInformation);
            }

            this.elementToPosition.add(token, this._currentPosition);
            this._currentPosition += token.fullWidth();
        };

        SyntaxInformationMap.prototype.parent = function (element) {
            return this._elementToParent.get(element);
        };

        SyntaxInformationMap.prototype.fullStart = function (element) {
            return this.elementToPosition.get(element);
        };

        SyntaxInformationMap.prototype.start = function (element) {
            return this.fullStart(element) + element.leadingTriviaWidth();
        };

        SyntaxInformationMap.prototype.end = function (element) {
            return this.start(element) + element.width();
        };

        SyntaxInformationMap.prototype.previousToken = function (token) {
            return this.tokenInformation(token).previousToken;
        };

        SyntaxInformationMap.prototype.tokenInformation = function (token) {
            return this.tokenToInformation.get(token);
        };

        SyntaxInformationMap.prototype.firstTokenInLineContainingToken = function (token) {
            var current = token;
            while (true) {
                var information = this.tokenInformation(current);
                if (this.isFirstTokenInLineWorker(information)) {
                    break;
                }

                current = information.previousToken;
            }

            return current;
        };

        SyntaxInformationMap.prototype.isFirstTokenInLine = function (token) {
            var information = this.tokenInformation(token);
            return this.isFirstTokenInLineWorker(information);
        };

        SyntaxInformationMap.prototype.isFirstTokenInLineWorker = function (information) {
            return information.previousToken === null || information.previousToken.hasTrailingNewLine();
        };
        return SyntaxInformationMap;
    })(TypeScript.SyntaxWalker);
    TypeScript.SyntaxInformationMap = SyntaxInformationMap;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxNodeInvariantsChecker = (function (_super) {
        __extends(SyntaxNodeInvariantsChecker, _super);
        function SyntaxNodeInvariantsChecker() {
            _super.apply(this, arguments);
            this.tokenTable = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
        }
        SyntaxNodeInvariantsChecker.checkInvariants = function (node) {
            node.accept(new SyntaxNodeInvariantsChecker());
        };

        SyntaxNodeInvariantsChecker.prototype.visitToken = function (token) {
            this.tokenTable.add(token, token);
        };
        return SyntaxNodeInvariantsChecker;
    })(TypeScript.SyntaxWalker);
    TypeScript.SyntaxNodeInvariantsChecker = SyntaxNodeInvariantsChecker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var DepthLimitedWalker = (function (_super) {
        __extends(DepthLimitedWalker, _super);
        function DepthLimitedWalker(maximumDepth) {
            _super.call(this);
            this._depth = 0;
            this._maximumDepth = 0;
            this._maximumDepth = maximumDepth;
        }
        DepthLimitedWalker.prototype.visitNode = function (node) {
            if (this._depth < this._maximumDepth) {
                this._depth++;
                _super.prototype.visitNode.call(this, node);
                this._depth--;
            } else {
                this.skip(node);
            }
        };
        return DepthLimitedWalker;
    })(TypeScript.PositionTrackingWalker);
    TypeScript.DepthLimitedWalker = DepthLimitedWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Parser) {
        var ExpressionPrecedence;
        (function (ExpressionPrecedence) {
            ExpressionPrecedence[ExpressionPrecedence["CommaExpressionPrecedence"] = 1] = "CommaExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["AssignmentExpressionPrecedence"] = 2] = "AssignmentExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["ConditionalExpressionPrecedence"] = 3] = "ConditionalExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["ArrowFunctionPrecedence"] = 4] = "ArrowFunctionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["LogicalOrExpressionPrecedence"] = 5] = "LogicalOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["LogicalAndExpressionPrecedence"] = 6] = "LogicalAndExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseOrExpressionPrecedence"] = 7] = "BitwiseOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseExclusiveOrExpressionPrecedence"] = 8] = "BitwiseExclusiveOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseAndExpressionPrecedence"] = 9] = "BitwiseAndExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["EqualityExpressionPrecedence"] = 10] = "EqualityExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["RelationalExpressionPrecedence"] = 11] = "RelationalExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["ShiftExpressionPrecdence"] = 12] = "ShiftExpressionPrecdence";
            ExpressionPrecedence[ExpressionPrecedence["AdditiveExpressionPrecedence"] = 13] = "AdditiveExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["MultiplicativeExpressionPrecedence"] = 14] = "MultiplicativeExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["UnaryExpressionPrecedence"] = 15] = "UnaryExpressionPrecedence";
        })(ExpressionPrecedence || (ExpressionPrecedence = {}));

        var ListParsingState;
        (function (ListParsingState) {
            ListParsingState[ListParsingState["SourceUnit_ModuleElements"] = 1 << 0] = "SourceUnit_ModuleElements";
            ListParsingState[ListParsingState["ClassDeclaration_ClassElements"] = 1 << 1] = "ClassDeclaration_ClassElements";
            ListParsingState[ListParsingState["ModuleDeclaration_ModuleElements"] = 1 << 2] = "ModuleDeclaration_ModuleElements";
            ListParsingState[ListParsingState["SwitchStatement_SwitchClauses"] = 1 << 3] = "SwitchStatement_SwitchClauses";
            ListParsingState[ListParsingState["SwitchClause_Statements"] = 1 << 4] = "SwitchClause_Statements";
            ListParsingState[ListParsingState["Block_Statements"] = 1 << 5] = "Block_Statements";
            ListParsingState[ListParsingState["TryBlock_Statements"] = 1 << 6] = "TryBlock_Statements";
            ListParsingState[ListParsingState["CatchBlock_Statements"] = 1 << 7] = "CatchBlock_Statements";
            ListParsingState[ListParsingState["EnumDeclaration_EnumElements"] = 1 << 8] = "EnumDeclaration_EnumElements";
            ListParsingState[ListParsingState["ObjectType_TypeMembers"] = 1 << 9] = "ObjectType_TypeMembers";
            ListParsingState[ListParsingState["ClassOrInterfaceDeclaration_HeritageClauses"] = 1 << 10] = "ClassOrInterfaceDeclaration_HeritageClauses";
            ListParsingState[ListParsingState["HeritageClause_TypeNameList"] = 1 << 11] = "HeritageClause_TypeNameList";
            ListParsingState[ListParsingState["VariableDeclaration_VariableDeclarators_AllowIn"] = 1 << 12] = "VariableDeclaration_VariableDeclarators_AllowIn";
            ListParsingState[ListParsingState["VariableDeclaration_VariableDeclarators_DisallowIn"] = 1 << 13] = "VariableDeclaration_VariableDeclarators_DisallowIn";
            ListParsingState[ListParsingState["ArgumentList_AssignmentExpressions"] = 1 << 14] = "ArgumentList_AssignmentExpressions";
            ListParsingState[ListParsingState["ObjectLiteralExpression_PropertyAssignments"] = 1 << 15] = "ObjectLiteralExpression_PropertyAssignments";
            ListParsingState[ListParsingState["ArrayLiteralExpression_AssignmentExpressions"] = 1 << 16] = "ArrayLiteralExpression_AssignmentExpressions";
            ListParsingState[ListParsingState["ParameterList_Parameters"] = 1 << 17] = "ParameterList_Parameters";
            ListParsingState[ListParsingState["TypeArgumentList_Types"] = 1 << 18] = "TypeArgumentList_Types";
            ListParsingState[ListParsingState["TypeParameterList_TypeParameters"] = 1 << 19] = "TypeParameterList_TypeParameters";

            ListParsingState[ListParsingState["FirstListParsingState"] = ListParsingState.SourceUnit_ModuleElements] = "FirstListParsingState";
            ListParsingState[ListParsingState["LastListParsingState"] = ListParsingState.TypeArgumentList_Types] = "LastListParsingState";
        })(ListParsingState || (ListParsingState = {}));

        var SyntaxCursor = (function () {
            function SyntaxCursor(sourceUnit) {
                this._elements = [];
                this._index = 0;
                this._pinCount = 0;
                sourceUnit.insertChildrenInto(this._elements, 0);
            }
            SyntaxCursor.prototype.isFinished = function () {
                return this._index === this._elements.length;
            };

            SyntaxCursor.prototype.currentElement = function () {
                if (this.isFinished()) {
                    return null;
                }

                return this._elements[this._index];
            };

            SyntaxCursor.prototype.currentNode = function () {
                var element = this.currentElement();
                return element !== null && element.isNode() ? element : null;
            };

            SyntaxCursor.prototype.moveToFirstChild = function () {
                if (this.isFinished()) {
                    return;
                }

                var element = this._elements[this._index];
                if (element.isToken()) {
                    return;
                }

                var node = element;

                this._elements.splice(this._index, 1);

                node.insertChildrenInto(this._elements, this._index);
            };

            SyntaxCursor.prototype.moveToNextSibling = function () {
                if (this.isFinished()) {
                    return;
                }

                if (this._pinCount > 0) {
                    this._index++;
                    return;
                }

                this._elements.shift();
            };

            SyntaxCursor.prototype.getAndPinCursorIndex = function () {
                this._pinCount++;
                return this._index;
            };

            SyntaxCursor.prototype.releaseAndUnpinCursorIndex = function (index) {
                this._pinCount--;
                if (this._pinCount === 0) {
                }
            };

            SyntaxCursor.prototype.rewindToPinnedCursorIndex = function (index) {
                this._index = index;
            };

            SyntaxCursor.prototype.pinCount = function () {
                return this._pinCount;
            };

            SyntaxCursor.prototype.moveToFirstToken = function () {
                var element;

                while (!this.isFinished()) {
                    element = this.currentElement();
                    if (element.isNode()) {
                        this.moveToFirstChild();
                        continue;
                    }

                    return;
                }
            };

            SyntaxCursor.prototype.currentToken = function () {
                this.moveToFirstToken();
                if (this.isFinished()) {
                    return null;
                }

                var element = this.currentElement();

                return element;
            };

            SyntaxCursor.prototype.peekToken = function (n) {
                this.moveToFirstToken();
                var pin = this.getAndPinCursorIndex();
                try  {
                    for (var i = 0; i < n; i++) {
                        this.moveToNextSibling();
                        this.moveToFirstToken();
                    }

                    return this.currentToken();
                } finally {
                    this.rewindToPinnedCursorIndex(pin);
                    this.releaseAndUnpinCursorIndex(pin);
                }
            };
            return SyntaxCursor;
        })();

        var NormalParserSource = (function () {
            function NormalParserSource(fileName, text, languageVersion) {
                this._previousToken = null;
                this._absolutePosition = 0;
                this._tokenDiagnostics = [];
                this.rewindPointPool = [];
                this.rewindPointPoolCount = 0;
                this.slidingWindow = new TypeScript.SlidingWindow(this, TypeScript.ArrayUtilities.createArray(32, null), null);
                this.scanner = new TypeScript.Scanner(fileName, text, languageVersion);
            }
            NormalParserSource.prototype.languageVersion = function () {
                return this.scanner.languageVersion();
            };

            NormalParserSource.prototype.currentNode = function () {
                return null;
            };

            NormalParserSource.prototype.moveToNextNode = function () {
                throw TypeScript.Errors.invalidOperation();
            };

            NormalParserSource.prototype.absolutePosition = function () {
                return this._absolutePosition;
            };

            NormalParserSource.prototype.previousToken = function () {
                return this._previousToken;
            };

            NormalParserSource.prototype.tokenDiagnostics = function () {
                return this._tokenDiagnostics;
            };

            NormalParserSource.prototype.getOrCreateRewindPoint = function () {
                if (this.rewindPointPoolCount === 0) {
                    return {};
                }

                this.rewindPointPoolCount--;
                var result = this.rewindPointPool[this.rewindPointPoolCount];
                this.rewindPointPool[this.rewindPointPoolCount] = null;
                return result;
            };

            NormalParserSource.prototype.getRewindPoint = function () {
                var slidingWindowIndex = this.slidingWindow.getAndPinAbsoluteIndex();

                var rewindPoint = this.getOrCreateRewindPoint();

                rewindPoint.slidingWindowIndex = slidingWindowIndex;
                rewindPoint.previousToken = this._previousToken;
                rewindPoint.absolutePosition = this._absolutePosition;

                rewindPoint.pinCount = this.slidingWindow.pinCount();

                return rewindPoint;
            };

            NormalParserSource.prototype.isPinned = function () {
                return this.slidingWindow.pinCount() > 0;
            };

            NormalParserSource.prototype.rewind = function (rewindPoint) {
                this.slidingWindow.rewindToPinnedIndex(rewindPoint.slidingWindowIndex);

                this._previousToken = rewindPoint.previousToken;
                this._absolutePosition = rewindPoint.absolutePosition;
            };

            NormalParserSource.prototype.releaseRewindPoint = function (rewindPoint) {
                this.slidingWindow.releaseAndUnpinAbsoluteIndex((rewindPoint).absoluteIndex);

                this.rewindPointPool[this.rewindPointPoolCount] = rewindPoint;
                this.rewindPointPoolCount++;
            };

            NormalParserSource.prototype.fetchMoreItems = function (allowRegularExpression, sourceIndex, window, destinationIndex, spaceAvailable) {
                window[destinationIndex] = this.scanner.scan(this._tokenDiagnostics, allowRegularExpression);
                return 1;
            };

            NormalParserSource.prototype.peekToken = function (n) {
                return this.slidingWindow.peekItemN(n);
            };

            NormalParserSource.prototype.moveToNextToken = function () {
                var currentToken = this.currentToken();
                this._absolutePosition += currentToken.fullWidth();
                this._previousToken = currentToken;

                this.slidingWindow.moveToNextItem();
            };

            NormalParserSource.prototype.currentToken = function () {
                return this.slidingWindow.currentItem(false);
            };

            NormalParserSource.prototype.removeDiagnosticsOnOrAfterPosition = function (position) {
                var tokenDiagnosticsLength = this._tokenDiagnostics.length;
                while (tokenDiagnosticsLength > 0) {
                    var diagnostic = this._tokenDiagnostics[tokenDiagnosticsLength - 1];
                    if (diagnostic.start() >= position) {
                        tokenDiagnosticsLength--;
                    } else {
                        break;
                    }
                }

                this._tokenDiagnostics.length = tokenDiagnosticsLength;
            };

            NormalParserSource.prototype.resetToPosition = function (absolutePosition, previousToken) {
                this._absolutePosition = absolutePosition;
                this._previousToken = previousToken;

                this.removeDiagnosticsOnOrAfterPosition(absolutePosition);

                this.slidingWindow.disgardAllItemsFromCurrentIndexOnwards();

                this.scanner.setAbsoluteIndex(absolutePosition);
            };

            NormalParserSource.prototype.currentTokenAllowingRegularExpression = function () {
                this.resetToPosition(this._absolutePosition, this._previousToken);

                var token = this.slidingWindow.currentItem(true);

                return token;
            };
            return NormalParserSource;
        })();

        var IncrementalParserSource = (function () {
            function IncrementalParserSource(oldSyntaxTree, textChangeRange, newText) {
                this._changeDelta = 0;
                var oldSourceUnit = oldSyntaxTree.sourceUnit();
                this._oldSourceUnitCursor = new SyntaxCursor(oldSourceUnit);

                this._changeRange = IncrementalParserSource.extendToAffectedRange(textChangeRange, oldSourceUnit);

                this._normalParserSource = new NormalParserSource(oldSyntaxTree.fileName(), newText, oldSyntaxTree.languageVersion());
            }
            IncrementalParserSource.extendToAffectedRange = function (changeRange, sourceUnit) {
                var maxLookahead = 1;

                var start = changeRange.span().start();

                for (var i = 0; start > 0 && i <= maxLookahead; i++) {
                    var token = sourceUnit.findToken(start);

                    var position = token.fullStart();

                    start = TypeScript.MathPrototype.max(0, position - 1);
                }

                var finalSpan = TypeScript.TextSpan.fromBounds(start, changeRange.span().end());
                var finalLength = changeRange.newLength() + (changeRange.span().start() - start);

                return new TypeScript.TextChangeRange(finalSpan, finalLength);
            };

            IncrementalParserSource.prototype.languageVersion = function () {
                return this._normalParserSource.languageVersion();
            };

            IncrementalParserSource.prototype.absolutePosition = function () {
                return this._normalParserSource.absolutePosition();
            };

            IncrementalParserSource.prototype.previousToken = function () {
                return this._normalParserSource.previousToken();
            };

            IncrementalParserSource.prototype.tokenDiagnostics = function () {
                return this._normalParserSource.tokenDiagnostics();
            };

            IncrementalParserSource.prototype.getRewindPoint = function () {
                var rewindPoint = this._normalParserSource.getRewindPoint();
                var oldSourceUnitCursorIndex = this._oldSourceUnitCursor.getAndPinCursorIndex();

                rewindPoint.changeDelta = this._changeDelta;
                rewindPoint.changeRange = this._changeRange;
                rewindPoint.oldSourceUnitCursorIndex = oldSourceUnitCursorIndex;

                return rewindPoint;
            };

            IncrementalParserSource.prototype.rewind = function (rewindPoint) {
                this._changeRange = rewindPoint.changeRange;
                this._changeDelta = rewindPoint.changeDelta;
                this._oldSourceUnitCursor.rewindToPinnedCursorIndex(rewindPoint.oldSourceUnitCursorIndex);

                this._normalParserSource.rewind(rewindPoint);
            };

            IncrementalParserSource.prototype.releaseRewindPoint = function (rewindPoint) {
                this._oldSourceUnitCursor.releaseAndUnpinCursorIndex(rewindPoint.oldSourceUnitCursorIndex);
                this._normalParserSource.releaseRewindPoint(rewindPoint);
            };

            IncrementalParserSource.prototype.canReadFromOldSourceUnit = function () {
                if (this._normalParserSource.isPinned()) {
                    return false;
                }

                if (this._changeRange !== null && this._changeRange.newSpan().intersectsWithPosition(this.absolutePosition())) {
                    return false;
                }

                this.syncCursorToNewTextIfBehind();

                return this._changeDelta === 0 && !this._oldSourceUnitCursor.isFinished();
            };

            IncrementalParserSource.prototype.currentNode = function () {
                if (this.canReadFromOldSourceUnit()) {
                    return this.tryGetNodeFromOldSourceUnit();
                }

                return null;
            };

            IncrementalParserSource.prototype.currentToken = function () {
                if (this.canReadFromOldSourceUnit()) {
                    var token = this.tryGetTokenFromOldSourceUnit();
                    if (token !== null) {
                        return token;
                    }
                }

                return this._normalParserSource.currentToken();
            };

            IncrementalParserSource.prototype.currentTokenAllowingRegularExpression = function () {
                return this._normalParserSource.currentTokenAllowingRegularExpression();
            };

            IncrementalParserSource.prototype.syncCursorToNewTextIfBehind = function () {
                while (true) {
                    if (this._oldSourceUnitCursor.isFinished()) {
                        break;
                    }

                    if (this._changeDelta >= 0) {
                        break;
                    }

                    var currentElement = this._oldSourceUnitCursor.currentElement();

                    if (currentElement.isNode() && (currentElement.fullWidth() > Math.abs(this._changeDelta))) {
                        this._oldSourceUnitCursor.moveToFirstChild();
                    } else {
                        this._oldSourceUnitCursor.moveToNextSibling();

                        this._changeDelta += currentElement.fullWidth();
                    }
                }
            };

            IncrementalParserSource.prototype.intersectsWithChangeRangeSpanInOriginalText = function (start, length) {
                return this._changeRange !== null && this._changeRange.span().intersectsWith(start, length);
            };

            IncrementalParserSource.prototype.tryGetNodeFromOldSourceUnit = function () {
                while (true) {
                    var node = this._oldSourceUnitCursor.currentNode();
                    if (node === null) {
                        return null;
                    }

                    if (!this.intersectsWithChangeRangeSpanInOriginalText(this.absolutePosition(), node.fullWidth())) {
                        if (!node.isIncrementallyUnusable()) {
                            return node;
                        }
                    }

                    this._oldSourceUnitCursor.moveToFirstChild();
                }
            };

            IncrementalParserSource.prototype.canReuseTokenFromOldSourceUnit = function (position, token) {
                if (token !== null) {
                    if (!this.intersectsWithChangeRangeSpanInOriginalText(position, token.fullWidth())) {
                        if (!token.isIncrementallyUnusable()) {
                            return true;
                        }
                    }
                }

                return false;
            };

            IncrementalParserSource.prototype.tryGetTokenFromOldSourceUnit = function () {
                var token = this._oldSourceUnitCursor.currentToken();

                return this.canReuseTokenFromOldSourceUnit(this.absolutePosition(), token) ? token : null;
            };

            IncrementalParserSource.prototype.peekToken = function (n) {
                if (this.canReadFromOldSourceUnit()) {
                    var token = this.tryPeekTokenFromOldSourceUnit(n);
                    if (token !== null) {
                        return token;
                    }
                }

                return this._normalParserSource.peekToken(n);
            };

            IncrementalParserSource.prototype.tryPeekTokenFromOldSourceUnit = function (n) {
                var currentPosition = this.absolutePosition();
                for (var i = 0; i < n; i++) {
                    var interimToken = this._oldSourceUnitCursor.peekToken(i);
                    if (!this.canReuseTokenFromOldSourceUnit(currentPosition, interimToken)) {
                        return null;
                    }

                    currentPosition += interimToken.fullWidth();
                }

                var token = this._oldSourceUnitCursor.peekToken(n);
                return this.canReuseTokenFromOldSourceUnit(currentPosition, token) ? token : null;
            };

            IncrementalParserSource.prototype.moveToNextNode = function () {
                var currentElement = this._oldSourceUnitCursor.currentElement();
                var currentNode = this._oldSourceUnitCursor.currentNode();

                this._oldSourceUnitCursor.moveToNextSibling();

                var absolutePosition = this.absolutePosition() + currentNode.fullWidth();
                var previousToken = currentNode.lastToken();
                this._normalParserSource.resetToPosition(absolutePosition, previousToken);

                if (this._changeRange !== null) {
                }
            };

            IncrementalParserSource.prototype.moveToNextToken = function () {
                var currentToken = this.currentToken();

                if (this._oldSourceUnitCursor.currentToken() === currentToken) {
                    this._oldSourceUnitCursor.moveToNextSibling();

                    var absolutePosition = this.absolutePosition() + currentToken.fullWidth();
                    var previousToken = currentToken;
                    this._normalParserSource.resetToPosition(absolutePosition, previousToken);

                    if (this._changeRange !== null) {
                    }
                } else {
                    this._changeDelta -= currentToken.fullWidth();

                    this._normalParserSource.moveToNextToken();

                    if (this._changeRange !== null) {
                        var changeRangeSpanInNewText = this._changeRange.newSpan();
                        if (this.absolutePosition() >= changeRangeSpanInNewText.end()) {
                            this._changeDelta += this._changeRange.newLength() - this._changeRange.span().length();
                            this._changeRange = null;
                        }
                    }
                }
            };
            return IncrementalParserSource;
        })();

        var ParserImpl = (function () {
            function ParserImpl(fileName, lineMap, source, parseOptions) {
                this.listParsingState = 0;
                this.isInStrictMode = false;
                this.diagnostics = [];
                this.factory = TypeScript.Syntax.normalModeFactory;
                this.mergeTokensStorage = [];
                this.arrayPool = [];
                this.fileName = fileName;
                this.lineMap = lineMap;
                this.source = source;
                this.parseOptions = parseOptions;
            }
            ParserImpl.prototype.getRewindPoint = function () {
                var rewindPoint = this.source.getRewindPoint();

                rewindPoint.diagnosticsCount = this.diagnostics.length;

                rewindPoint.isInStrictMode = this.isInStrictMode;
                rewindPoint.listParsingState = this.listParsingState;

                return rewindPoint;
            };

            ParserImpl.prototype.rewind = function (rewindPoint) {
                this.source.rewind(rewindPoint);

                this.diagnostics.length = rewindPoint.diagnosticsCount;
            };

            ParserImpl.prototype.releaseRewindPoint = function (rewindPoint) {
                this.source.releaseRewindPoint(rewindPoint);
            };

            ParserImpl.prototype.currentTokenStart = function () {
                return this.source.absolutePosition() + this.currentToken().leadingTriviaWidth();
            };

            ParserImpl.prototype.previousTokenStart = function () {
                if (this.previousToken() === null) {
                    return 0;
                }

                return this.source.absolutePosition() - this.previousToken().fullWidth() + this.previousToken().leadingTriviaWidth();
            };

            ParserImpl.prototype.previousTokenEnd = function () {
                if (this.previousToken() === null) {
                    return 0;
                }

                return this.previousTokenStart() + this.previousToken().width();
            };

            ParserImpl.prototype.currentNode = function () {
                var node = this.source.currentNode();

                if (node === null || node.parsedInStrictMode() !== this.isInStrictMode) {
                    return null;
                }

                return node;
            };

            ParserImpl.prototype.currentToken = function () {
                return this.source.currentToken();
            };

            ParserImpl.prototype.currentTokenAllowingRegularExpression = function () {
                return this.source.currentTokenAllowingRegularExpression();
            };

            ParserImpl.prototype.peekToken = function (n) {
                return this.source.peekToken(n);
            };

            ParserImpl.prototype.eatAnyToken = function () {
                var token = this.currentToken();
                this.moveToNextToken();
                return token;
            };

            ParserImpl.prototype.moveToNextToken = function () {
                this.source.moveToNextToken();
            };

            ParserImpl.prototype.previousToken = function () {
                return this.source.previousToken();
            };

            ParserImpl.prototype.eatNode = function () {
                var node = this.source.currentNode();
                this.source.moveToNextNode();
                return node;
            };

            ParserImpl.prototype.eatToken = function (kind) {
                var token = this.currentToken();
                if (token.tokenKind === kind) {
                    this.moveToNextToken();
                    return token;
                }

                return this.createMissingToken(kind, token);
            };

            ParserImpl.prototype.tryEatToken = function (kind) {
                if (this.currentToken().tokenKind === kind) {
                    return this.eatToken(kind);
                }

                return null;
            };

            ParserImpl.prototype.tryEatKeyword = function (kind) {
                if (this.currentToken().tokenKind === kind) {
                    return this.eatKeyword(kind);
                }

                return null;
            };

            ParserImpl.prototype.eatKeyword = function (kind) {
                var token = this.currentToken();
                if (token.tokenKind === kind) {
                    this.moveToNextToken();
                    return token;
                }

                return this.createMissingToken(kind, token);
            };

            ParserImpl.prototype.isIdentifier = function (token) {
                var tokenKind = token.tokenKind;

                if (tokenKind === 11 /* IdentifierName */) {
                    return true;
                }

                if (tokenKind >= 51 /* FirstFutureReservedStrictKeyword */) {
                    if (tokenKind <= 59 /* LastFutureReservedStrictKeyword */) {
                        return !this.isInStrictMode;
                    }

                    return tokenKind <= 70 /* LastTypeScriptKeyword */;
                }

                return false;
            };

            ParserImpl.prototype.eatIdentifierNameToken = function () {
                var token = this.currentToken();

                if (token.tokenKind === 11 /* IdentifierName */) {
                    this.moveToNextToken();
                    return token;
                }

                if (TypeScript.SyntaxFacts.isAnyKeyword(token.tokenKind)) {
                    this.moveToNextToken();
                    return TypeScript.Syntax.convertToIdentifierName(token);
                }

                return this.createMissingToken(11 /* IdentifierName */, token);
            };

            ParserImpl.prototype.eatIdentifierToken = function () {
                var token = this.currentToken();
                if (this.isIdentifier(token)) {
                    this.moveToNextToken();

                    if (token.tokenKind === 11 /* IdentifierName */) {
                        return token;
                    }

                    return TypeScript.Syntax.convertToIdentifierName(token);
                }

                return this.createMissingToken(11 /* IdentifierName */, token);
            };

            ParserImpl.prototype.canEatAutomaticSemicolon = function (allowWithoutNewLine) {
                var token = this.currentToken();

                if (token.tokenKind === 10 /* EndOfFileToken */) {
                    return true;
                }

                if (token.tokenKind === 72 /* CloseBraceToken */) {
                    return true;
                }

                if (allowWithoutNewLine) {
                    return true;
                }

                if (this.previousToken() !== null && this.previousToken().hasTrailingNewLine()) {
                    return true;
                }

                return false;
            };

            ParserImpl.prototype.canEatExplicitOrAutomaticSemicolon = function (allowWithoutNewline) {
                var token = this.currentToken();

                if (token.tokenKind === 79 /* SemicolonToken */) {
                    return true;
                }

                return this.canEatAutomaticSemicolon(allowWithoutNewline);
            };

            ParserImpl.prototype.eatExplicitOrAutomaticSemicolon = function (allowWithoutNewline) {
                var token = this.currentToken();

                if (token.tokenKind === 79 /* SemicolonToken */) {
                    return this.eatToken(79 /* SemicolonToken */);
                }

                if (this.canEatAutomaticSemicolon(allowWithoutNewline)) {
                    var semicolonToken = TypeScript.Syntax.emptyToken(79 /* SemicolonToken */);

                    if (!this.parseOptions.allowAutomaticSemicolonInsertion()) {
                        this.addDiagnostic(new TypeScript.SyntaxDiagnostic(this.fileName, this.previousTokenEnd(), 0, 11 /* Automatic_semicolon_insertion_not_allowed */, null));
                    }

                    return semicolonToken;
                }

                return this.eatToken(79 /* SemicolonToken */);
            };

            ParserImpl.prototype.isKeyword = function (kind) {
                if (kind >= TypeScript.SyntaxKind.FirstKeyword) {
                    if (kind <= 50 /* LastFutureReservedKeyword */) {
                        return true;
                    }

                    if (this.isInStrictMode) {
                        return kind <= 59 /* LastFutureReservedStrictKeyword */;
                    }
                }

                return false;
            };

            ParserImpl.prototype.createMissingToken = function (expectedKind, actual) {
                var diagnostic = this.getExpectedTokenDiagnostic(expectedKind, actual);
                this.addDiagnostic(diagnostic);

                return TypeScript.Syntax.emptyToken(expectedKind);
            };

            ParserImpl.prototype.getExpectedTokenDiagnostic = function (expectedKind, actual) {
                var token = this.currentToken();

                if (TypeScript.SyntaxFacts.isAnyKeyword(expectedKind) || TypeScript.SyntaxFacts.isAnyPunctuation(expectedKind)) {
                    return new TypeScript.SyntaxDiagnostic(this.fileName, this.currentTokenStart(), token.width(), 9 /* _0_expected */, [TypeScript.SyntaxFacts.getText(expectedKind)]);
                } else {
                    if (actual !== null && TypeScript.SyntaxFacts.isAnyKeyword(actual.tokenKind)) {
                        return new TypeScript.SyntaxDiagnostic(this.fileName, this.currentTokenStart(), token.width(), 10 /* Identifier_expected__0__is_a_keyword */, [TypeScript.SyntaxFacts.getText(actual.tokenKind)]);
                    } else {
                        return new TypeScript.SyntaxDiagnostic(this.fileName, this.currentTokenStart(), token.width(), 7 /* Identifier_expected */, null);
                    }
                }
            };

            ParserImpl.getPrecedence = function (expressionKind) {
                switch (expressionKind) {
                    case 172 /* CommaExpression */:
                        return 1 /* CommaExpressionPrecedence */;

                    case 173 /* AssignmentExpression */:
                    case 174 /* AddAssignmentExpression */:
                    case 175 /* SubtractAssignmentExpression */:
                    case 176 /* MultiplyAssignmentExpression */:
                    case 177 /* DivideAssignmentExpression */:
                    case 178 /* ModuloAssignmentExpression */:
                    case 179 /* AndAssignmentExpression */:
                    case 180 /* ExclusiveOrAssignmentExpression */:
                    case 181 /* OrAssignmentExpression */:
                    case 182 /* LeftShiftAssignmentExpression */:
                    case 183 /* SignedRightShiftAssignmentExpression */:
                    case 184 /* UnsignedRightShiftAssignmentExpression */:
                        return 2 /* AssignmentExpressionPrecedence */;

                    case 185 /* ConditionalExpression */:
                        return 3 /* ConditionalExpressionPrecedence */;

                    case 186 /* LogicalOrExpression */:
                        return 5 /* LogicalOrExpressionPrecedence */;

                    case 187 /* LogicalAndExpression */:
                        return 6 /* LogicalAndExpressionPrecedence */;

                    case 188 /* BitwiseOrExpression */:
                        return 7 /* BitwiseOrExpressionPrecedence */;

                    case 189 /* BitwiseExclusiveOrExpression */:
                        return 8 /* BitwiseExclusiveOrExpressionPrecedence */;

                    case 190 /* BitwiseAndExpression */:
                        return 9 /* BitwiseAndExpressionPrecedence */;

                    case 191 /* EqualsWithTypeConversionExpression */:
                    case 192 /* NotEqualsWithTypeConversionExpression */:
                    case 193 /* EqualsExpression */:
                    case 194 /* NotEqualsExpression */:
                        return 10 /* EqualityExpressionPrecedence */;

                    case 195 /* LessThanExpression */:
                    case 196 /* GreaterThanExpression */:
                    case 197 /* LessThanOrEqualExpression */:
                    case 198 /* GreaterThanOrEqualExpression */:
                    case 199 /* InstanceOfExpression */:
                    case 200 /* InExpression */:
                        return 11 /* RelationalExpressionPrecedence */;

                    case 201 /* LeftShiftExpression */:
                    case 202 /* SignedRightShiftExpression */:
                    case 203 /* UnsignedRightShiftExpression */:
                        return 12 /* ShiftExpressionPrecdence */;

                    case 207 /* AddExpression */:
                    case 208 /* SubtractExpression */:
                        return 13 /* AdditiveExpressionPrecedence */;

                    case 204 /* MultiplyExpression */:
                    case 205 /* DivideExpression */:
                    case 206 /* ModuloExpression */:
                        return 14 /* MultiplicativeExpressionPrecedence */;

                    case 163 /* PlusExpression */:
                    case 164 /* NegateExpression */:
                    case 165 /* BitwiseNotExpression */:
                    case 166 /* LogicalNotExpression */:
                    case 169 /* DeleteExpression */:
                    case 170 /* TypeOfExpression */:
                    case 171 /* VoidExpression */:
                    case 167 /* PreIncrementExpression */:
                    case 168 /* PreDecrementExpression */:
                        return 15 /* UnaryExpressionPrecedence */;
                }

                throw TypeScript.Errors.invalidOperation();
            };

            ParserImpl.prototype.addSkippedTokenAfterNodeOrToken = function (nodeOrToken, skippedToken) {
                if (nodeOrToken.isToken()) {
                    return this.addSkippedTokenAfterToken(nodeOrToken, skippedToken);
                } else if (nodeOrToken.isNode()) {
                    return this.addSkippedTokenAfterNode(nodeOrToken, skippedToken);
                } else {
                    throw TypeScript.Errors.invalidOperation();
                }
            };

            ParserImpl.prototype.addSkippedTokenAfterNode = function (node, skippedToken) {
                var oldToken = node.lastToken();
                var newToken = this.addSkippedTokenAfterToken(oldToken, skippedToken);

                return node.replaceToken(oldToken, newToken);
            };

            ParserImpl.prototype.addSkippedTokensBeforeNode = function (node, skippedTokens) {
                if (skippedTokens.length > 0) {
                    var oldToken = node.firstToken();
                    var newToken = this.addSkippedTokensBeforeToken(oldToken, skippedTokens);

                    return node.replaceToken(oldToken, newToken);
                }

                return node;
            };

            ParserImpl.prototype.addSkippedTokensBeforeToken = function (token, skippedTokens) {
                var leadingTrivia = [];
                for (var i = 0, n = skippedTokens.length; i < n; i++) {
                    this.addSkippedTokenToTriviaArray(leadingTrivia, skippedTokens[i]);
                }

                this.addTriviaTo(token.leadingTrivia(), leadingTrivia);

                this.returnArray(skippedTokens);
                return token.withLeadingTrivia(TypeScript.Syntax.triviaList(leadingTrivia));
            };

            ParserImpl.prototype.addSkippedTokensAfterToken = function (token, skippedTokens) {
                if (skippedTokens.length === 0) {
                    this.returnArray(skippedTokens);
                    return token;
                }

                var trailingTrivia = token.trailingTrivia().toArray();

                for (var i = 0, n = skippedTokens.length; i < n; i++) {
                    this.addSkippedTokenToTriviaArray(trailingTrivia, skippedTokens[i]);
                }

                this.returnArray(skippedTokens);
                return token.withTrailingTrivia(TypeScript.Syntax.triviaList(trailingTrivia));
            };

            ParserImpl.prototype.addSkippedTokenAfterToken = function (token, skippedToken) {
                var trailingTrivia = token.trailingTrivia().toArray();
                this.addSkippedTokenToTriviaArray(trailingTrivia, skippedToken);

                return token.withTrailingTrivia(TypeScript.Syntax.triviaList(trailingTrivia));
            };

            ParserImpl.prototype.addSkippedTokenToTriviaArray = function (array, skippedToken) {
                this.addTriviaTo(skippedToken.leadingTrivia(), array);

                var trimmedToken = skippedToken.withLeadingTrivia(TypeScript.Syntax.emptyTriviaList).withTrailingTrivia(TypeScript.Syntax.emptyTriviaList);
                array.push(TypeScript.Syntax.skippedTokenTrivia(trimmedToken));

                this.addTriviaTo(skippedToken.trailingTrivia(), array);
            };

            ParserImpl.prototype.addTriviaTo = function (list, array) {
                for (var i = 0, n = list.count(); i < n; i++) {
                    array.push(list.syntaxTriviaAt(i));
                }
            };

            ParserImpl.prototype.parseSyntaxTree = function (isDeclaration) {
                var sourceUnit = this.parseSourceUnit();

                var allDiagnostics = this.source.tokenDiagnostics().concat(this.diagnostics);
                allDiagnostics.sort(function (a, b) {
                    return a.start() - b.start();
                });

                return new TypeScript.SyntaxTree(sourceUnit, isDeclaration, allDiagnostics, this.fileName, this.lineMap, this.source.languageVersion(), this.parseOptions);
            };

            ParserImpl.prototype.setStrictMode = function (isInStrictMode) {
                this.isInStrictMode = isInStrictMode;
                this.factory = isInStrictMode ? TypeScript.Syntax.strictModeFactory : TypeScript.Syntax.normalModeFactory;
            };

            ParserImpl.prototype.parseSourceUnit = function () {
                var savedIsInStrictMode = this.isInStrictMode;

                var result = this.parseSyntaxList(1 /* SourceUnit_ModuleElements */, ParserImpl.updateStrictModeState);
                var moduleElements = result.list;

                this.setStrictMode(savedIsInStrictMode);

                var sourceUnit = this.factory.sourceUnit(moduleElements, this.currentToken());
                sourceUnit = this.addSkippedTokensBeforeNode(sourceUnit, result.skippedTokens);

                return sourceUnit;
            };

            ParserImpl.updateStrictModeState = function (parser, items) {
                if (!parser.isInStrictMode) {
                    for (var i = 0; i < items.length; i++) {
                        var item = items[i];
                        if (!TypeScript.SyntaxFacts.isDirectivePrologueElement(item)) {
                            return;
                        }
                    }

                    parser.setStrictMode(TypeScript.SyntaxFacts.isUseStrictDirective(items[items.length - 1]));
                }
            };

            ParserImpl.prototype.isModuleElement = function (inErrorRecovery) {
                if (this.currentNode() !== null && this.currentNode().isModuleElement()) {
                    return true;
                }

                return this.isImportDeclaration() || this.isExportAssignment() || this.isModuleDeclaration() || this.isInterfaceDeclaration() || this.isClassDeclaration() || this.isEnumDeclaration() || this.isStatement(inErrorRecovery);
            };

            ParserImpl.prototype.parseModuleElement = function () {
                if (this.currentNode() !== null && this.currentNode().isModuleElement()) {
                    return this.eatNode();
                }

                if (this.isImportDeclaration()) {
                    return this.parseImportDeclaration();
                } else if (this.isExportAssignment()) {
                    return this.parseExportAssignment();
                } else if (this.isModuleDeclaration()) {
                    return this.parseModuleDeclaration();
                } else if (this.isInterfaceDeclaration()) {
                    return this.parseInterfaceDeclaration();
                } else if (this.isClassDeclaration()) {
                    return this.parseClassDeclaration();
                } else if (this.isEnumDeclaration()) {
                    return this.parseEnumDeclaration();
                } else if (this.isStatement(false)) {
                    return this.parseStatement();
                } else {
                    throw TypeScript.Errors.invalidOperation();
                }
            };

            ParserImpl.prototype.isImportDeclaration = function () {
                return this.currentToken().tokenKind === 49 /* ImportKeyword */;
            };

            ParserImpl.prototype.parseImportDeclaration = function () {
                var importKeyword = this.eatKeyword(49 /* ImportKeyword */);
                var identifier = this.eatIdentifierToken();
                var equalsToken = this.eatToken(108 /* EqualsToken */);
                var moduleReference = this.parseModuleReference();
                var semicolonToken = this.eatExplicitOrAutomaticSemicolon(false);

                return this.factory.importDeclaration(importKeyword, identifier, equalsToken, moduleReference, semicolonToken);
            };

            ParserImpl.prototype.isExportAssignment = function () {
                return this.currentToken().tokenKind === 47 /* ExportKeyword */ && this.peekToken(1).tokenKind === 108 /* EqualsToken */;
            };

            ParserImpl.prototype.parseExportAssignment = function () {
                var exportKeyword = this.eatKeyword(47 /* ExportKeyword */);
                var equalsToken = this.eatToken(108 /* EqualsToken */);
                var identifier = this.eatIdentifierToken();
                var semicolonToken = this.eatExplicitOrAutomaticSemicolon(false);

                return this.factory.exportAssignment(exportKeyword, equalsToken, identifier, semicolonToken);
            };

            ParserImpl.prototype.parseModuleReference = function () {
                if (this.isExternalModuleReference()) {
                    return this.parseExternalModuleReference();
                } else {
                    return this.parseModuleNameModuleReference();
                }
            };

            ParserImpl.prototype.isExternalModuleReference = function () {
                var token0 = this.currentToken();
                if (token0.tokenKind === 66 /* ModuleKeyword */ || token0.tokenKind === 67 /* RequireKeyword */) {
                    return this.peekToken(1).tokenKind === 73 /* OpenParenToken */;
                }

                return false;
            };

            ParserImpl.prototype.parseExternalModuleReference = function () {
                var moduleOrRequireKeyword = this.eatAnyToken();
                var openParenToken = this.eatToken(73 /* OpenParenToken */);
                var stringLiteral = this.eatToken(14 /* StringLiteral */);
                var closeParenToken = this.eatToken(74 /* CloseParenToken */);

                return this.factory.externalModuleReference(moduleOrRequireKeyword, openParenToken, stringLiteral, closeParenToken);
            };

            ParserImpl.prototype.parseModuleNameModuleReference = function () {
                var name = this.parseName();
                return this.factory.moduleNameModuleReference(name);
            };

            ParserImpl.prototype.parseIdentifierName = function () {
                var identifierName = this.eatIdentifierNameToken();
                return identifierName;
            };

            ParserImpl.prototype.isName = function () {
                return this.isIdentifier(this.currentToken());
            };

            ParserImpl.prototype.tryParseTypeArgumentList = function (inExpression) {
                if (this.currentToken().kind() !== 81 /* LessThanToken */) {
                    return null;
                }

                var lessThanToken;
                var greaterThanToken;
                var result;
                var typeArguments;

                if (!inExpression) {
                    lessThanToken = this.eatToken(81 /* LessThanToken */);

                    result = this.parseSeparatedSyntaxList(262144 /* TypeArgumentList_Types */);
                    typeArguments = result.list;
                    lessThanToken = this.addSkippedTokensAfterToken(lessThanToken, result.skippedTokens);

                    greaterThanToken = this.eatToken(82 /* GreaterThanToken */);

                    return this.factory.typeArgumentList(lessThanToken, typeArguments, greaterThanToken);
                }

                var rewindPoint = this.getRewindPoint();
                try  {
                    lessThanToken = this.eatToken(81 /* LessThanToken */);

                    result = this.parseSeparatedSyntaxList(262144 /* TypeArgumentList_Types */);
                    typeArguments = result.list;
                    lessThanToken = this.addSkippedTokensAfterToken(lessThanToken, result.skippedTokens);

                    greaterThanToken = this.eatToken(82 /* GreaterThanToken */);

                    if (greaterThanToken.fullWidth() === 0 || !this.canFollowTypeArgumentListInExpression(this.currentToken().kind())) {
                        this.rewind(rewindPoint);
                        return null;
                    }

                    return this.factory.typeArgumentList(lessThanToken, typeArguments, greaterThanToken);
                } finally {
                    this.releaseRewindPoint(rewindPoint);
                }
            };

            ParserImpl.prototype.canFollowTypeArgumentListInExpression = function (kind) {
                switch (kind) {
                    case 73 /* OpenParenToken */:
                    case 77 /* DotToken */:

                    case 74 /* CloseParenToken */:
                    case 76 /* CloseBracketToken */:
                    case 107 /* ColonToken */:
                    case 79 /* SemicolonToken */:
                    case 80 /* CommaToken */:
                    case 106 /* QuestionToken */:
                    case 85 /* EqualsEqualsToken */:
                    case 88 /* EqualsEqualsEqualsToken */:
                    case 87 /* ExclamationEqualsToken */:
                    case 89 /* ExclamationEqualsEqualsToken */:
                    case 104 /* AmpersandAmpersandToken */:
                    case 105 /* BarBarToken */:
                    case 101 /* CaretToken */:
                    case 99 /* AmpersandToken */:
                    case 100 /* BarToken */:
                    case 72 /* CloseBraceToken */:
                    case 10 /* EndOfFileToken */:
                        return true;

                    default:
                        return false;
                }
            };

            ParserImpl.prototype.parseName = function () {
                var shouldContinue = this.isIdentifier(this.currentToken());
                var current = this.eatIdentifierToken();

                while (shouldContinue && this.currentToken().tokenKind === 77 /* DotToken */) {
                    var dotToken = this.eatToken(77 /* DotToken */);

                    var currentToken = this.currentToken();
                    var identifierName;

                    if (TypeScript.SyntaxFacts.isAnyKeyword(currentToken.tokenKind) && this.previousToken().hasTrailingNewLine() && !currentToken.hasTrailingNewLine() && TypeScript.SyntaxFacts.isIdentifierNameOrAnyKeyword(this.peekToken(1))) {
                        identifierName = this.createMissingToken(11 /* IdentifierName */, currentToken);
                    } else {
                        identifierName = this.eatIdentifierNameToken();
                    }

                    current = this.factory.qualifiedName(current, dotToken, identifierName);

                    shouldContinue = identifierName.fullWidth() > 0;
                }

                return current;
            };

            ParserImpl.prototype.isEnumDeclaration = function () {
                var index = this.modifierCount();

                if (index > 0 && this.peekToken(index).tokenKind === 46 /* EnumKeyword */) {
                    return true;
                }

                return this.currentToken().tokenKind === 46 /* EnumKeyword */ && this.isIdentifier(this.peekToken(1));
            };

            ParserImpl.prototype.parseEnumDeclaration = function () {
                var modifiers = this.parseModifiers();
                var enumKeyword = this.eatKeyword(46 /* EnumKeyword */);
                var identifier = this.eatIdentifierToken();

                var openBraceToken = this.eatToken(71 /* OpenBraceToken */);
                var enumElements = TypeScript.Syntax.emptySeparatedList;

                if (openBraceToken.width() > 0) {
                    var result = this.parseSeparatedSyntaxList(256 /* EnumDeclaration_EnumElements */);
                    enumElements = result.list;
                    openBraceToken = this.addSkippedTokensAfterToken(openBraceToken, result.skippedTokens);
                }

                var closeBraceToken = this.eatToken(72 /* CloseBraceToken */);

                return this.factory.enumDeclaration(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken);
            };

            ParserImpl.prototype.isEnumElement = function (inErrorRecovery) {
                if (this.currentNode() !== null && this.currentNode().kind() === 243 /* EnumElement */) {
                    return true;
                }

                return this.isPropertyName(this.currentToken(), inErrorRecovery);
            };

            ParserImpl.prototype.parseEnumElement = function () {
                if (this.currentNode() !== null && this.currentNode().kind() === 243 /* EnumElement */) {
                    return this.eatNode();
                }

                var propertyName = this.eatPropertyName();
                var equalsValueClause = null;
                if (this.isEqualsValueClause(false)) {
                    equalsValueClause = this.parseEqualsValueClause(true);
                }

                return this.factory.enumElement(propertyName, equalsValueClause);
            };

            ParserImpl.isModifier = function (token) {
                switch (token.tokenKind) {
                    case 57 /* PublicKeyword */:
                    case 55 /* PrivateKeyword */:
                    case 58 /* StaticKeyword */:
                    case 47 /* ExportKeyword */:
                    case 64 /* DeclareKeyword */:
                        return true;

                    default:
                        return false;
                }
            };

            ParserImpl.prototype.modifierCount = function () {
                var modifierCount = 0;
                while (true) {
                    if (ParserImpl.isModifier(this.peekToken(modifierCount))) {
                        modifierCount++;
                        continue;
                    }

                    break;
                }

                return modifierCount;
            };

            ParserImpl.prototype.parseModifiers = function () {
                var tokens = this.getArray();

                while (true) {
                    if (ParserImpl.isModifier(this.currentToken())) {
                        tokens.push(this.eatAnyToken());
                        continue;
                    }

                    break;
                }

                var result = TypeScript.Syntax.list(tokens);

                this.returnZeroOrOneLengthArray(tokens);

                return result;
            };

            ParserImpl.prototype.isClassDeclaration = function () {
                var index = this.modifierCount();

                if (index > 0 && this.peekToken(index).tokenKind === 44 /* ClassKeyword */) {
                    return true;
                }

                return this.currentToken().tokenKind === 44 /* ClassKeyword */ && this.isIdentifier(this.peekToken(1));
            };

            ParserImpl.prototype.parseHeritageClauses = function () {
                var heritageClauses = TypeScript.Syntax.emptyList;

                if (this.isHeritageClause()) {
                    var result = this.parseSyntaxList(1024 /* ClassOrInterfaceDeclaration_HeritageClauses */);
                    heritageClauses = result.list;
                    TypeScript.Debug.assert(result.skippedTokens.length === 0);
                }

                return heritageClauses;
            };

            ParserImpl.prototype.parseClassDeclaration = function () {
                var modifiers = this.parseModifiers();

                var classKeyword = this.eatKeyword(44 /* ClassKeyword */);
                var identifier = this.eatIdentifierToken();
                var typeParameterList = this.parseOptionalTypeParameterList(false);
                var heritageClauses = this.parseHeritageClauses();
                var openBraceToken = this.eatToken(71 /* OpenBraceToken */);
                var classElements = TypeScript.Syntax.emptyList;

                if (openBraceToken.width() > 0) {
                    var result = this.parseSyntaxList(2 /* ClassDeclaration_ClassElements */);

                    classElements = result.list;
                    openBraceToken = this.addSkippedTokensAfterToken(openBraceToken, result.skippedTokens);
                }

                var closeBraceToken = this.eatToken(72 /* CloseBraceToken */);
                return this.factory.classDeclaration(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken);
            };

            ParserImpl.prototype.isConstructorDeclaration = function () {
                return this.currentToken().tokenKind === 63 /* ConstructorKeyword */;
            };

            ParserImpl.isPublicOrPrivateKeyword = function (token) {
                return token.tokenKind === 57 /* PublicKeyword */ || token.tokenKind === 55 /* PrivateKeyword */;
            };

            ParserImpl.prototype.isMemberAccessorDeclaration = function (inErrorRecovery) {
                var index = this.modifierCount();

                if (this.peekToken(index).tokenKind !== 65 /* GetKeyword */ && this.peekToken(index).tokenKind !== 69 /* SetKeyword */) {
                    return false;
                }

                index++;
                return this.isPropertyName(this.peekToken(index), inErrorRecovery);
            };

            ParserImpl.prototype.parseMemberAccessorDeclaration = function () {
                var modifiers = this.parseModifiers();

                if (this.currentToken().tokenKind === 65 /* GetKeyword */) {
                    return this.parseGetMemberAccessorDeclaration(modifiers);
                } else if (this.currentToken().tokenKind === 69 /* SetKeyword */) {
                    return this.parseSetMemberAccessorDeclaration(modifiers);
                } else {
                    throw TypeScript.Errors.invalidOperation();
                }
            };

            ParserImpl.prototype.parseGetMemberAccessorDeclaration = function (modifiers) {
                var getKeyword = this.eatKeyword(65 /* GetKeyword */);
                var propertyName = this.eatPropertyName();
                var parameterList = this.parseParameterList();
                var typeAnnotation = this.parseOptionalTypeAnnotation(false);
                var block = this.parseBlock(false, false);

                return this.factory.getMemberAccessorDeclaration(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block);
            };

            ParserImpl.prototype.parseSetMemberAccessorDeclaration = function (modifiers) {
                var setKeyword = this.eatKeyword(69 /* SetKeyword */);
                var propertyName = this.eatPropertyName();
                var parameterList = this.parseParameterList();
                var block = this.parseBlock(false, false);

                return this.factory.setMemberAccessorDeclaration(modifiers, setKeyword, propertyName, parameterList, block);
            };

            ParserImpl.prototype.isClassElement = function (inErrorRecovery) {
                if (this.currentNode() !== null && this.currentNode().isClassElement()) {
                    return true;
                }

                return this.isConstructorDeclaration() || this.isMemberFunctionDeclaration(inErrorRecovery) || this.isMemberAccessorDeclaration(inErrorRecovery) || this.isMemberVariableDeclaration(inErrorRecovery) || this.isIndexSignature();
            };

            ParserImpl.prototype.parseConstructorDeclaration = function () {
                var constructorKeyword = this.eatKeyword(63 /* ConstructorKeyword */);
                var parameterList = this.parseParameterList();

                var semicolonToken = null;
                var block = null;

                if (this.isBlock()) {
                    block = this.parseBlock(false, true);
                } else {
                    semicolonToken = this.eatExplicitOrAutomaticSemicolon(false);
                }

                return this.factory.constructorDeclaration(constructorKeyword, parameterList, block, semicolonToken);
            };

            ParserImpl.prototype.isMemberFunctionDeclaration = function (inErrorRecovery) {
                var index = 0;

                while (true) {
                    var token = this.peekToken(index);
                    if (this.isPropertyName(token, inErrorRecovery) && this.isCallSignature(index + 1)) {
                        return true;
                    }

                    if (ParserImpl.isModifier(token)) {
                        index++;
                        continue;
                    }

                    return false;
                }
            };

            ParserImpl.prototype.parseMemberFunctionDeclaration = function () {
                var modifierArray = this.getArray();

                while (true) {
                    var currentToken = this.currentToken();
                    if (this.isPropertyName(currentToken, false) && this.isCallSignature(1)) {
                        break;
                    }

                    TypeScript.Debug.assert(ParserImpl.isModifier(currentToken));
                    modifierArray.push(this.eatAnyToken());
                }

                var modifiers = TypeScript.Syntax.list(modifierArray);
                this.returnZeroOrOneLengthArray(modifierArray);

                var propertyName = this.eatPropertyName();
                var callSignature = this.parseCallSignature(false);

                var newCallSignature = this.tryAddUnexpectedEqualsGreaterThanToken(callSignature);
                var parseBlockEvenWithNoOpenBrace = callSignature !== newCallSignature;
                callSignature = newCallSignature;

                var block = null;
                var semicolon = null;

                if (parseBlockEvenWithNoOpenBrace || this.isBlock()) {
                    block = this.parseBlock(parseBlockEvenWithNoOpenBrace, true);
                } else {
                    semicolon = this.eatExplicitOrAutomaticSemicolon(false);
                }

                return this.factory.memberFunctionDeclaration(modifiers, propertyName, callSignature, block, semicolon);
            };

            ParserImpl.prototype.isDefinitelyMemberVariablePropertyName = function (index) {
                if (TypeScript.SyntaxFacts.isAnyKeyword(this.peekToken(index).tokenKind)) {
                    switch (this.peekToken(index + 1).tokenKind) {
                        case 79 /* SemicolonToken */:
                        case 108 /* EqualsToken */:
                        case 107 /* ColonToken */:
                        case 72 /* CloseBraceToken */:
                        case 10 /* EndOfFileToken */:
                            return true;
                        default:
                            return false;
                    }
                } else {
                    return true;
                }
            };

            ParserImpl.prototype.isMemberVariableDeclaration = function (inErrorRecovery) {
                var index = 0;

                while (true) {
                    var token = this.peekToken(index);
                    if (this.isPropertyName(token, inErrorRecovery) && this.isDefinitelyMemberVariablePropertyName(index)) {
                        return true;
                    }

                    if (ParserImpl.isModifier(this.peekToken(index))) {
                        index++;
                        continue;
                    }
