/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.openide.util.NbBundle;

public abstract class DefaultVersionDescriptor
implements VersionDescriptor {
    private static final VersionDescriptor FOREVER_COMPATIBLE = new VersionDescriptor(){

        @Override
        public boolean isCompatibleWith(VersionDescriptor descriptor) {
            return true;
        }

        @Override
        public boolean isCompatibleWith(Collection<String> abilities) {
            return true;
        }

        @Override
        public Set<String> getPreliminaryConvertMessages(DesignComponent component, Collection<String> oldAbilities, Collection<String> newAbilities) {
            return null;
        }

        @Override
        public void convertComponent(DesignComponent component, Collection<String> oldAbilities, Collection<String> newAbilities) {
        }
    };
    private Kind kind;
    private String[] abilities;

    public DefaultVersionDescriptor(Kind kind, String[] abilities) {
        assert (kind != null && abilities != null);
        this.kind = kind;
        this.abilities = abilities;
    }

    public final boolean isCompatibleWith(String[] abilities) {
        if (this.kind == Kind.ALL) {
            return Arrays.asList(abilities).containsAll(Arrays.asList(this.abilities));
        }
        List<String> abilitiesList = Arrays.asList(abilities);
        for (String ability : this.abilities) {
            if (!abilitiesList.contains(ability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getPreliminaryConvertMessages(DesignComponent component, Collection<String> oldAbilities, Collection<String> newAbilities) {
        if (this.isCompatibleWith(newAbilities)) {
            return null;
        }
        String htmlDisplayName = InfoPresenter.getHtmlDisplayName(component);
        if (htmlDisplayName == null) {
            htmlDisplayName = "#" + component.getComponentID();
        }
        return Collections.singleton(NbBundle.getMessage(DefaultVersionDescriptor.class, (String)"MSG_Convertion_RemoveComponent", (Object)htmlDisplayName));
    }

    public static VersionDescriptor createForeverCompatibleVersionDescriptor() {
        return FOREVER_COMPATIBLE;
    }

    public static enum Kind {
        ANY,
        ALL;

    }
}

