/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;

public final class PropertyValueSupport {
    public static PropertyValue addArrayValue(PropertyValue array, PropertyValue value) {
        assert (array != null && value != null);
        assert (array.getKind().equals((Object)PropertyValue.Kind.ARRAY));
        TypeID componentType = array.getType().getComponentType();
        assert (value.isCompatible(componentType));
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(array.getArray());
        values.add(value);
        return PropertyValue.createArray(componentType, values);
    }

    public static PropertyValue addArrayValue(PropertyValue array, int index, PropertyValue value) {
        assert (array != null && value != null);
        assert (array.getKind().equals((Object)PropertyValue.Kind.ARRAY));
        TypeID componentType = array.getType().getComponentType();
        assert (value.isCompatible(componentType));
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(array.getArray());
        values.add(index, value);
        return PropertyValue.createArray(componentType, values);
    }

    public static PropertyValue setArrayValue(PropertyValue array, int index, PropertyValue value) {
        assert (array != null && value != null);
        assert (array.getKind().equals((Object)PropertyValue.Kind.ARRAY));
        TypeID componentType = array.getType().getComponentType();
        assert (value.isCompatible(componentType));
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(array.getArray());
        values.set(index, value);
        return PropertyValue.createArray(componentType, values);
    }

    public static PropertyValue removeArrayValue(PropertyValue array, PropertyValue value) {
        assert (array != null && value != null);
        assert (array.getKind().equals((Object)PropertyValue.Kind.ARRAY));
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(array.getArray());
        values.remove(value);
        return PropertyValue.createArray(array.getType().getComponentType(), values);
    }

    public static PropertyValue removeArrayValue(PropertyValue array, int index) {
        assert (array != null);
        assert (array.getKind().equals((Object)PropertyValue.Kind.ARRAY));
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(array.getArray());
        values.remove(index);
        return PropertyValue.createArray(array.getType().getComponentType(), values);
    }
}

