/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PresenterListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

final class PresenterEventManager
implements PresenterEvent {
    private ArrayList<DependencyItem> dependencies = new ArrayList();
    private HashSet<PresenterListener> changed;
    private List<PresenterListener> topology;
    private Map<PresenterListener, HashSet<PresenterListener>> dependencyMap;

    PresenterEventManager() {
    }

    void firePresenterChanged(PresenterListener listener) {
        this.changed.add(listener);
    }

    void addPresenterListener(DesignComponent component, Class<? extends Presenter> presenterClass, PresenterListener listener) {
        this.dependencies.add(new DependencyItem(component, presenterClass, listener));
        this.topology = null;
    }

    void removePresenterListener(DesignComponent component, Class<? extends Presenter> presenterClass, PresenterListener listener) {
        this.dependencies.remove(new DependencyItem(component, presenterClass, listener));
        this.topology = null;
    }

    void removeAllPresenterListeners(PresenterListener listener) {
        Iterator<DependencyItem> i = this.dependencies.iterator();
        while (i.hasNext()) {
            DependencyItem di = i.next();
            if (di.listener != listener) continue;
            i.remove();
            this.topology = null;
        }
    }

    void prepare(boolean forceUpdateTopology) {
        this.changed = new HashSet(100);
        if (forceUpdateTopology) {
            this.topology = null;
        }
    }

    void execute() {
        if (this.topology == null) {
            this.createTopology();
        }
        List<PresenterListener> _topology = this.topology;
        Map<PresenterListener, HashSet<PresenterListener>> _dependencyMap = this.dependencyMap;
        HashSet<PresenterListener> marked = new HashSet<PresenterListener>(100);
        for (PresenterListener presenterListener : this.changed) {
            if (_topology.contains(presenterListener)) {
                marked.add(presenterListener);
                continue;
            }
            presenterListener.presenterChanged(this);
        }
        for (PresenterListener presenterListener : _topology) {
            HashSet<PresenterListener> set;
            if (marked.contains(presenterListener)) {
                presenterListener.presenterChanged(this);
            }
            if (!this.changed.contains(presenterListener) || (set = _dependencyMap.get(presenterListener)) == null) continue;
            for (PresenterListener listener : set) {
                marked.add(listener);
            }
        }
    }

    private void createTopology() {
        HashSet unsortedSet = new HashSet();
        HashMap<PresenterListener, HashSet<PresenterListener>> _dependencyMap = new HashMap<PresenterListener, HashSet<PresenterListener>>();
        for (DependencyItem item : this.dependencies) {
            item.setupTopology(unsortedSet, _dependencyMap);
        }
        try {
            this.topology = Utilities.topologicalSort(unsortedSet, _dependencyMap);
            this.dependencyMap = _dependencyMap;
        }
        catch (TopologicalSortException e) {
            Debug.warning(new Object[]{e});
            System.err.println("TopologicalSortException: Topological Sets:" + Arrays.toString(e.topologicalSets()));
            System.err.println("TopologicalSortException: Unsortable Set:" + Arrays.toString(e.unsortableSets()));
            this.topology = Collections.emptyList();
            this.dependencyMap = Collections.emptyMap();
        }
    }

    @Override
    public boolean isPresenterChanged(DesignComponent component, Class<? extends Presenter> presenterClass) {
        assert (component != null && presenterClass != null);
        for (Presenter presenter : component.getPresenters(presenterClass)) {
            if (!(presenter instanceof DynamicPresenter) || !this.changed.contains(((DynamicPresenter)presenter).getPresenterListener())) continue;
            return true;
        }
        return false;
    }

    private class DependencyItem {
        private DesignComponent component;
        private Class<? extends Presenter> presenterClass;
        private PresenterListener listener;

        public DependencyItem(DesignComponent component, Class<? extends Presenter> presenterClass, PresenterListener listener) {
            assert (component != null && presenterClass != null && listener != null);
            this.component = component;
            this.presenterClass = presenterClass;
            this.listener = listener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyItem di = (DependencyItem)o;
            if (this.component != di.component) {
                return false;
            }
            if (!this.presenterClass.equals(di.presenterClass)) {
                return false;
            }
            return this.listener == di.listener;
        }

        public int hashCode() {
            int result = this.component != null ? this.component.hashCode() : 0;
            result = 29 * result + (this.presenterClass != null ? this.presenterClass.hashCode() : 0);
            result = 29 * result + (this.listener != null ? this.listener.hashCode() : 0);
            return result;
        }

        private void setupTopology(HashSet<PresenterListener> unsortedSet, HashMap<PresenterListener, HashSet<PresenterListener>> dependencyMap) {
            Presenter presenter = this.component.getPresenter(this.presenterClass);
            if (!(presenter instanceof DynamicPresenter)) {
                return;
            }
            PresenterListener presenterListener = ((DynamicPresenter)presenter).getPresenterListener();
            if (presenterListener == this.listener) {
                return;
            }
            unsortedSet.add(presenterListener);
            unsortedSet.add(this.listener);
            HashSet<PresenterListener> set = dependencyMap.get(presenterListener);
            if (set == null) {
                set = new HashSet();
                dependencyMap.put(presenterListener, set);
            }
            set.add(this.listener);
        }
    }
}

