/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class LexUtilities {
    private static final Set<TokenId> END_PAIRS = new HashSet<TokenId>();
    private static final Set<TokenId> INDENT_WORDS = new HashSet<TokenId>();

    private LexUtilities() {
    }

    @CheckForNull
    public static BaseDocument getDocument(RubyParseResult result, boolean forceOpen) {
        if (result != null) {
            Source source = result.getSnapshot().getSource();
            return GsfUtilities.getDocument((FileObject)source.getFileObject(), (boolean)forceOpen);
        }
        return null;
    }

    public static int getLexerOffset(Parser.Result result, int astOffset) {
        return result.getSnapshot().getOriginalOffset(astOffset);
    }

    public static OffsetRange getLexerOffsets(Parser.Result result, OffsetRange astRange) {
        int rangeStart = astRange.getStart();
        int start = result.getSnapshot().getOriginalOffset(rangeStart);
        if (start == rangeStart) {
            return astRange;
        }
        if (start == -1) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(start, start + astRange.getLength());
    }

    public static TokenSequence<? extends RubyTokenId> getRubyTokenSequence(BaseDocument doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)th, offset);
    }

    private static TokenSequence<? extends RubyTokenId> findRhtmlDelimited(TokenSequence t, int offset) {
        String mimeType = t.language().mimeType();
        if (mimeType.equals("application/x-httpd-eruby") || mimeType.equals("text/x-yaml")) {
            TokenSequence ets;
            t.move(offset);
            if (t.moveNext() && t.token() != null && "ruby-delimiter".equals(t.token().id().primaryCategory()) && t.moveNext() && t.token() != null && "ruby".equals(t.token().id().primaryCategory()) && (ets = t.embedded()) != null) {
                return ets;
            }
        }
        return null;
    }

    public static TokenSequence<? extends RubyTokenId> getRubyTokenSequence(TokenHierarchy<Document> th, int offset) {
        TokenSequence ts = th.tokenSequence(RubyTokenId.language());
        if (ts == null) {
            TokenSequence<? extends RubyTokenId> ets;
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() == RubyTokenId.language()) {
                    ts = t;
                    break;
                }
                ets = LexUtilities.findRhtmlDelimited(t, offset);
                if (ets == null) continue;
                return ets;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() == RubyTokenId.language()) {
                        ts = t;
                        break;
                    }
                    ets = LexUtilities.findRhtmlDelimited(t, offset);
                    if (ets == null) continue;
                    return ets;
                }
            }
        }
        return ts;
    }

    public static TokenSequence<? extends RubyTokenId> getPositionedSequence(BaseDocument doc, int offset) {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts != null) {
            try {
                ts.move(offset);
            }
            catch (AssertionError e) {
                DataObject dobj = (DataObject)doc.getProperty((Object)"stream");
                if (dobj != null) {
                    Exceptions.attachMessage((Throwable)((Object)e), (String)FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
                }
                throw e;
            }
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
            return ts;
        }
        return null;
    }

    public static Token<? extends RubyTokenId> getToken(BaseDocument doc, int offset) {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getPositionedSequence(doc, offset);
        if (ts != null) {
            return ts.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument doc, int offset) {
        String text;
        Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, offset);
        if (token != null && (text = ((Object)token.text()).toString()).length() > 0) {
            return text.charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findHeredocEnd(TokenSequence<? extends RubyTokenId> ts, Token<? extends RubyTokenId> startToken) {
        String text = ((Object)startToken.text()).toString();
        assert (text.startsWith("<<"));
        if ((text = text.substring(2)).startsWith("-")) {
            text = text.substring(1);
        }
        if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(0, text.length() - 2);
        }
        String textn = text + "\n";
        while (ts.moveNext()) {
            String t;
            Token token = ts.token();
            TokenId id = token.id();
            if (id != RubyTokenId.STRING_END && id != RubyTokenId.QUOTED_STRING_END || !text.equals(t = ((Object)token.text()).toString()) && !textn.equals(t)) continue;
            return new OffsetRange(ts.offset(), ts.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findHeredocBegin(TokenSequence<? extends RubyTokenId> ts, Token<? extends RubyTokenId> endToken) {
        String text = ((Object)endToken.text()).toString();
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        String textQuotes = "\"" + text + "\"";
        String textSQuotes = "'" + text + "'";
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (id != RubyTokenId.STRING_BEGIN && id != RubyTokenId.QUOTED_STRING_BEGIN) continue;
            String t = ((Object)token.text()).toString();
            String marker = null;
            if (t.startsWith("<<-")) {
                marker = t.substring(3);
            } else if (t.startsWith("<<")) {
                marker = t.substring(2);
            }
            if (marker == null || !text.equals(marker) && !textQuotes.equals(marker) && !textSQuotes.equals(marker)) continue;
            return new OffsetRange(ts.offset(), ts.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findFwd(BaseDocument doc, TokenSequence<? extends RubyTokenId> ts, TokenId up, TokenId down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (id == up) {
                ++balance;
                continue;
            }
            if (id != down) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument doc, TokenSequence<? extends RubyTokenId> ts, TokenId up, TokenId down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (id == up) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (id != down) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument doc, TokenSequence<? extends RubyTokenId> ts) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (LexUtilities.isBeginToken(id, doc, ts)) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                --balance;
                continue;
            }
            if (id != RubyTokenId.END) continue;
            ++balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findEnd(BaseDocument doc, TokenSequence<? extends RubyTokenId> ts) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (LexUtilities.isBeginToken(id, doc, ts)) {
                --balance;
                continue;
            }
            if (id != RubyTokenId.END) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            ++balance;
        }
        return OffsetRange.NONE;
    }

    public static boolean isEndmatchingDo(BaseDocument doc, int offset) {
        try {
            TokenId id;
            Token<? extends RubyTokenId> token;
            int first = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            if (first != -1 && (token = LexUtilities.getToken(doc, first)) != null && ((id = token.id()) == RubyTokenId.WHILE || id == RubyTokenId.UNTIL || id == RubyTokenId.FOR)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isBeginToken(TokenId id, BaseDocument doc, int offset) {
        if (id == RubyTokenId.DO) {
            return LexUtilities.isEndmatchingDo(doc, offset);
        }
        return END_PAIRS.contains(id);
    }

    public static boolean isBeginToken(TokenId id, BaseDocument doc, TokenSequence<? extends RubyTokenId> ts) {
        if (id == RubyTokenId.DO) {
            return LexUtilities.isEndmatchingDo(doc, ts.offset());
        }
        return END_PAIRS.contains(id);
    }

    public static boolean isIndentToken(TokenId id) {
        return INDENT_WORDS.contains(id);
    }

    public static int getBeginEndLineBalance(BaseDocument doc, int offset, boolean upToOffset) {
        try {
            int begin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            int end = upToOffset ? offset : Utilities.getRowEnd((BaseDocument)doc, (int)offset);
            TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            int balance = 0;
            do {
                Token token;
                TokenId id;
                if (LexUtilities.isBeginToken(id = (token = ts.token()).id(), doc, ts)) {
                    ++balance;
                    continue;
                }
                if (id != RubyTokenId.END) continue;
                --balance;
            } while (ts.moveNext() && ts.offset() <= end);
            return balance;
        }
        catch (BadLocationException ble) {
            return 0;
        }
    }

    public static int getLineBalance(BaseDocument doc, int offset, TokenId up, TokenId down) {
        try {
            int begin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            int end = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
            TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            int balance = 0;
            do {
                Token token;
                TokenId id;
                if ((id = (token = ts.token()).id()) == up) {
                    ++balance;
                    continue;
                }
                if (id != down) continue;
                --balance;
            } while (ts.moveNext() && ts.offset() <= end);
            return balance;
        }
        catch (BadLocationException ble) {
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument doc, TokenId open, TokenId close, int offset) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, 0);
        if (ts == null) {
            return 0;
        }
        ts.moveIndex(0);
        if (!ts.moveNext()) {
            return 0;
        }
        int balance = 0;
        do {
            Token t;
            if ((t = ts.token()).id() == open) {
                ++balance;
                continue;
            }
            if (t.id() != close) continue;
            --balance;
        } while (ts.moveNext());
        return balance;
    }

    public static boolean isCommentOnlyLine(BaseDocument doc, int offset) throws BadLocationException {
        int begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (begin == -1) {
            return false;
        }
        if (begin == doc.getLength()) {
            return false;
        }
        return doc.getText(begin, 1).equals("#");
    }

    public static String getStringAt(int caretOffset, TokenHierarchy<Document> th) {
        TokenSequence ts = LexUtilities.getRubyTokenSequence(th, caretOffset);
        if (ts == null) {
            return null;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == caretOffset && !ts.movePrevious()) {
            return null;
        }
        Token token = ts.token();
        if (token != null) {
            TokenId id = token.id();
            if (id == RubyTokenId.EMBEDDED_RUBY) {
                ts = ts.embedded();
                assert (ts != null);
                ts.move(caretOffset);
                if (!ts.moveNext() && !ts.movePrevious()) {
                    return null;
                }
                token = ts.token();
                id = token.id();
            }
            String string = null;
            int segments = 0;
            while (id == RubyTokenId.ERROR || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.EMBEDDED_RUBY) {
                string = ((Object)token.text()).toString();
                ++segments;
                if (!ts.movePrevious()) {
                    return null;
                }
                token = ts.token();
                id = token.id();
            }
            if (id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN) {
                if (segments == 1) {
                    return string;
                }
                StringBuilder sb = new StringBuilder();
                while (ts.moveNext() && ((id = (token = ts.token()).id()) == RubyTokenId.ERROR || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.EMBEDDED_RUBY)) {
                    sb.append(token.text());
                }
                return sb.toString();
            }
        }
        return null;
    }

    public static int getRequireStringOffset(int caretOffset, TokenHierarchy<Document> th) {
        TokenEvaluator evaluator = new TokenEvaluator(){

            @Override
            boolean next() {
                return false;
            }

            @Override
            boolean handled() {
                return true;
            }

            @Override
            int returnValue() {
                if (this.token.id() == RubyTokenId.IDENTIFIER) {
                    String text = ((Object)this.token.text()).toString();
                    if (text.equals("require") || text.equals("load")) {
                        return this.start;
                    }
                    return -1;
                }
                return -1;
            }
        };
        return LexUtilities.getStringOffset(caretOffset, th, evaluator);
    }

    public static int getClassNameStringOffset(int caretOffset, TokenHierarchy<Document> th) {
        TokenEvaluator evaluator = new TokenEvaluator(){

            @Override
            boolean next() {
                return this.token.id() == RubyTokenId.NONUNARY_OP;
            }

            @Override
            boolean handled() {
                return true;
            }

            @Override
            int returnValue() {
                if (this.token.id() == RubyTokenId.TYPE_SYMBOL) {
                    String text = ((Object)this.token.text()).toString();
                    if (text.equals("class") || text.equals("class_name")) {
                        return this.start;
                    }
                    return -1;
                }
                return -1;
            }
        };
        return LexUtilities.getStringOffset(caretOffset, th, evaluator);
    }

    private static int getStringOffset(int caretOffset, TokenHierarchy<Document> th, TokenEvaluator evaluator) {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(th, caretOffset);
        if (ts == null) {
            return -1;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (ts.offset() == caretOffset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        if (token != null) {
            TokenId id = token.id();
            while (id == RubyTokenId.ERROR || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.EMBEDDED_RUBY) {
                if (!ts.movePrevious()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            int stringStart = ts.offset() + token.length();
            evaluator.setStart(stringStart);
            if (id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN) {
                while (ts.movePrevious()) {
                    token = ts.token();
                    id = token.id();
                    if (id == RubyTokenId.WHITESPACE || id == RubyTokenId.LPAREN || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL) continue;
                    evaluator.setToken(token);
                    if (evaluator.next() || !evaluator.handled()) continue;
                    return evaluator.returnValue();
                }
            }
        }
        return -1;
    }

    public static int getSingleQuotedStringOffset(int caretOffset, TokenHierarchy<Document> th) {
        return LexUtilities.getLiteralStringOffset(caretOffset, th, RubyTokenId.STRING_BEGIN);
    }

    public static int getDoubleQuotedStringOffset(int caretOffset, TokenHierarchy<Document> th) {
        return LexUtilities.getLiteralStringOffset(caretOffset, th, RubyTokenId.QUOTED_STRING_BEGIN);
    }

    public static int getRegexpOffset(int caretOffset, TokenHierarchy<Document> th) {
        return LexUtilities.getLiteralStringOffset(caretOffset, th, RubyTokenId.REGEXP_BEGIN);
    }

    private static int getLiteralStringOffset(int caretOffset, TokenHierarchy<Document> th, RubyTokenId begin) {
        TokenSequence ts = LexUtilities.getRubyTokenSequence(th, caretOffset);
        if (ts == null) {
            return -1;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (ts.offset() == caretOffset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        if (token != null) {
            TokenId id = token.id();
            if (id == RubyTokenId.EMBEDDED_RUBY) {
                ts = ts.embedded();
                assert (ts != null);
                ts.move(caretOffset);
                if (!ts.moveNext() && !ts.movePrevious()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            while (id == RubyTokenId.ERROR || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.REGEXP_LITERAL || id == RubyTokenId.EMBEDDED_RUBY) {
                if (!ts.movePrevious()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            if (id == begin) {
                if (!ts.moveNext()) {
                    return -1;
                }
                return ts.offset();
            }
        }
        return -1;
    }

    public static boolean isInsideQuotedString(BaseDocument doc, int offset) {
        Token token;
        TokenId id;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(offset);
        if (ts.moveNext() && ((id = (token = ts.token()).id()) == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_END)) {
            return true;
        }
        return ts.movePrevious() && ((id = (token = ts.token()).id()) == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_BEGIN);
    }

    public static boolean isInsideRegexp(BaseDocument doc, int offset) {
        Token token;
        TokenId id;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(offset);
        if (ts.moveNext() && ((id = (token = ts.token()).id()) == RubyTokenId.REGEXP_LITERAL || id == RubyTokenId.REGEXP_END)) {
            return true;
        }
        return ts.movePrevious() && ((id = (token = ts.token()).id()) == RubyTokenId.REGEXP_LITERAL || id == RubyTokenId.REGEXP_BEGIN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OffsetRange getCommentBlock(BaseDocument doc, int caretOffset) {
        int end;
        int begin;
        block8: {
            try {
                Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, caretOffset);
                if (token != null && token.id() == RubyTokenId.LINE_COMMENT) {
                    begin = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
                    end = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
                    if (!LexUtilities.isCommentOnlyLine(doc, caretOffset)) {
                        TokenHierarchy th = TokenHierarchy.get((Document)doc);
                        int offset = token.offset(th);
                        return new OffsetRange(offset, offset + token.length());
                    }
                    break block8;
                }
                if (token == null) return OffsetRange.NONE;
                if (token.id() != RubyTokenId.DOCUMENTATION) return OffsetRange.NONE;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int begin2 = token.offset(th);
                int end2 = begin2 + token.length();
                return new OffsetRange(begin2, end2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return OffsetRange.NONE;
        }
        while (begin > 0) {
            int newBegin = Utilities.getRowStart((BaseDocument)doc, (int)(begin - 1));
            if (newBegin < 0 || !LexUtilities.isCommentOnlyLine(doc, newBegin)) {
                begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)begin);
                break;
            }
            begin = newBegin;
        }
        int length = doc.getLength();
        while (true) {
            int newEnd;
            if ((newEnd = Utilities.getRowEnd((BaseDocument)doc, (int)(end + 1))) >= length || !LexUtilities.isCommentOnlyLine(doc, newEnd)) {
                end = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end) + 1;
                if (begin >= end) return OffsetRange.NONE;
                return new OffsetRange(begin, end);
            }
            end = newEnd;
        }
    }

    public static int findSpaceBegin(BaseDocument doc, int lexOffset) {
        int lineStart;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, lexOffset);
        if (ts == null) {
            return lexOffset;
        }
        boolean allowPrevLine = false;
        try {
            int firstNonWhite;
            char c;
            lineStart = Utilities.getRowStart((BaseDocument)doc, (int)Math.min(lexOffset, doc.getLength()));
            int prevLast = lineStart - 1;
            if (lineStart > 0 && (prevLast = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)(lineStart - 1))) != -1 && (c = doc.getText(prevLast, 1).charAt(0)) == ',') {
                allowPrevLine = true;
            }
            if (!allowPrevLine) {
                firstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)lineStart);
                if (lexOffset <= firstNonWhite || firstNonWhite == -1) {
                    return lexOffset;
                }
            } else {
                firstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)lineStart);
                if (prevLast >= 0 && (lexOffset <= firstNonWhite || firstNonWhite == -1)) {
                    return prevLast + 1;
                }
                lineStart = 0;
            }
        }
        catch (BadLocationException ble) {
            return lexOffset;
        }
        ts.move(lexOffset);
        if (ts.moveNext()) {
            if (lexOffset > ts.offset()) {
                return Math.max(ts.token().id() == RubyTokenId.WHITESPACE ? ts.offset() : lexOffset, lineStart);
            }
            while (ts.movePrevious()) {
                Token token = ts.token();
                if (token.id() == RubyTokenId.WHITESPACE) continue;
                return Math.max(ts.offset() + token.length(), lineStart);
            }
        }
        return lexOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffsetRange findRDocRange(BaseDocument baseDoc, int methodBegin) {
        int begin = methodBegin;
        try {
            if (methodBegin >= baseDoc.getLength()) {
                return OffsetRange.NONE;
            }
            int offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)methodBegin);
            --offset;
            while (offset >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDoc, (int)(offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)offset))) || Utilities.isRowWhite((BaseDocument)baseDoc, (int)offset))) {
                --offset;
            }
            if (offset < 0) {
                return OffsetRange.NONE;
            }
            while (offset >= 0 && !Utilities.isRowEmpty((BaseDocument)baseDoc, (int)(offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)offset))) && !Utilities.isRowWhite((BaseDocument)baseDoc, (int)offset)) {
                int lineEnd;
                int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)baseDoc, (int)offset);
                String line = baseDoc.getText(lineBegin, (lineEnd = Utilities.getRowLastNonWhite((BaseDocument)baseDoc, (int)offset) + 1) - lineBegin);
                if (line.startsWith("#")) {
                    begin = lineBegin;
                } else if (line.startsWith("=end") && lineBegin == Utilities.getRowStart((BaseDocument)baseDoc, (int)offset)) {
                    int docBegin = LexUtilities.findInlineDocStart(baseDoc, offset);
                    if (docBegin == -1) return OffsetRange.NONE;
                    begin = docBegin;
                } else {
                    if (!line.equals("public") && !line.equals("private") && !line.equals("protected")) break;
                    --offset;
                    while (offset >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDoc, (int)(offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)offset))) || Utilities.isRowWhite((BaseDocument)baseDoc, (int)offset))) {
                        --offset;
                    }
                    continue;
                }
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (methodBegin <= begin) return OffsetRange.NONE;
        return new OffsetRange(begin, methodBegin);
    }

    private static int findInlineDocStart(BaseDocument baseDoc, int offset) throws BadLocationException {
        offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)offset);
        --offset;
        while (offset >= 0) {
            int lineEnd;
            int lineBegin = offset = Utilities.getRowStart((BaseDocument)baseDoc, (int)offset);
            String line = baseDoc.getText(lineBegin, (lineEnd = Utilities.getRowEnd((BaseDocument)baseDoc, (int)offset)) - lineBegin);
            if (line.startsWith("=begin")) {
                return lineBegin;
            }
            --offset;
        }
        return -1;
    }

    static {
        END_PAIRS.add(RubyTokenId.BEGIN);
        END_PAIRS.add(RubyTokenId.FOR);
        END_PAIRS.add(RubyTokenId.CLASS);
        END_PAIRS.add(RubyTokenId.DEF);
        END_PAIRS.add(RubyTokenId.DO);
        END_PAIRS.add(RubyTokenId.WHILE);
        END_PAIRS.add(RubyTokenId.IF);
        END_PAIRS.add(RubyTokenId.CLASS);
        END_PAIRS.add(RubyTokenId.MODULE);
        END_PAIRS.add(RubyTokenId.CASE);
        END_PAIRS.add(RubyTokenId.LOOP);
        END_PAIRS.add(RubyTokenId.UNTIL);
        END_PAIRS.add(RubyTokenId.UNLESS);
        INDENT_WORDS.addAll(END_PAIRS);
        INDENT_WORDS.add(RubyTokenId.ELSE);
        INDENT_WORDS.add(RubyTokenId.ELSIF);
        INDENT_WORDS.add(RubyTokenId.ENSURE);
        INDENT_WORDS.add(RubyTokenId.WHEN);
        INDENT_WORDS.add(RubyTokenId.RESCUE);
    }

    private static abstract class TokenEvaluator {
        protected Token token;
        protected int start;

        private TokenEvaluator() {
        }

        void setToken(Token token) {
            this.token = token;
        }

        void setStart(int start) {
            this.start = start;
        }

        abstract boolean next();

        abstract boolean handled();

        abstract int returnValue();
    }
}

