/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class DefaultMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private Map multipartParameters;

    public DefaultMultipartHttpServletRequest(HttpServletRequest request, Map multipartFiles, Map multipartParameters) {
        super(request);
        this.setMultipartFiles(multipartFiles);
        this.setMultipartParameters(multipartParameters);
    }

    public DefaultMultipartHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public Enumeration getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.getMultipartParameters().keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.getMultipartParameters().get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.getMultipartParameters().get(name);
        if (values != null) {
            return values;
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap paramMap = new HashMap();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.getMultipartParameters());
        return paramMap;
    }

    protected final void setMultipartParameters(Map multipartParameters) {
        this.multipartParameters = multipartParameters;
    }

    protected Map getMultipartParameters() {
        if (this.multipartParameters == null) {
            this.initializeMultipart();
        }
        return this.multipartParameters;
    }
}

