/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Vector;

public class ConstantPool {
    protected Vector<Info> cpVector;
    private JCPackage jPackage;
    private boolean printedError;

    public ConstantPool(JCPackage jCPackage) {
        this.jPackage = jCPackage;
        this.cpVector = new Vector();
    }

    void addConstantPoolEntry(Info info) {
        assert (info != null) : "info != null";
        this.cpVector.addElement(info);
        if (this.cpVector.size() > 65535 && !this.printedError) {
            Object[] objectArray = new Object[]{this.jPackage.getName()};
            Msg.error("package.2", objectArray);
            this.printedError = true;
        }
    }

    public Info getConstantPoolEntry(int n) {
        assert (n >= 0) : "index >= 0";
        if (n >= this.cpVector.size()) {
            return null;
        }
        return this.cpVector.elementAt(n);
    }

    public Enumeration<Info> elements() {
        return this.cpVector.elements();
    }

    public int getCount() {
        return this.cpVector.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".constantPool {" + Msg.eol);
        for (Info info : this.cpVector) {
            stringBuffer.append(info + ";" + Msg.eol);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

